<?php
$page = "Admin Vendors Dashboard";
$page_url = "vendors";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'dasha';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

$paginatedvendors = $dashboard->getVendorsPaginated();
$overview = $dashboard->getAdminDashboardOverview();
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));

// Handle AJAX status update for unrestrict
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_status'])) {
    header('Content-Type: application/json');
    $vendorId = $_POST['vendor_id'];
    $newStatus = $_POST['new_status'];
    $updated = $dashboard->updateVendorStatus($vendorId, $newStatus);
    if ($updated) {
        echo json_encode(['success' => true, 'message' => "Vendor status updated to $newStatus."]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update status.']);
    }
    exit();
}
?>

<style>
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .content-area {
        padding: 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb span {
        color: #6c757d;
        margin: 0 8px;
    }

    .search-filter-bar {
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        margin-bottom: 20px;
        justify-content: space-between;
        align-items: center;
    }

    .search-input {
        flex: 1;
        max-width: 300px;
        position: relative;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .button-filters {
        display: flex;
        gap: 20px;
    }

    .filter-btn,
    .export-btn {
        padding: 8px 16px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        font-size: 14px;
        color: #333;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .filter-btn:hover,
    .export-btn:hover {
        background: #f8f9fa;
    }

    .vendors-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .vendors-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
    }

    .vendors-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .vendors-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .filter-tabs {
        padding: 0 16px;
        background-color: #f1f5f9;
        width: fit-content;
        border-radius: 6px;
        margin-bottom: 16px;
    }

    .filter-tabs ul {
        list-style: none;
        padding: 6px 0;
        margin: 0;
        display: flex;
    }

    .filter-tabs li {
        margin-right: 30px;
    }

    .filter-tabs p {
        display: block;
        border-radius: 6px;
        padding: 8px;
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .filter-tabs p.active {
        background-color: #fff;
    }

    .filter-tabs p:hover {
        text-decoration: none;
        background: #e9ecef;
    }

    .table-container {
        overflow-x: auto;
    }

    .vendors-table {
        width: 100%;
        margin: 0;
        border-collapse: collapse;
    }

    .vendors-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .vendors-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
        text-align: left;
    }

    .vendors-table tbody tr {
        border-bottom: 1px solid #f8f9fa;
        transition: background 0.3s ease;
    }

    .vendors-table tbody tr:hover {
        background: #f8f9fa;
    }

    .vendors-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        font-size: 14px;
    }

    .vendor-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .vendor-checkbox {
        margin-right: 30px;
    }

    .vendor-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #0d3e9b;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
        margin-right: 15px;
    }

    .vendor-details h6 {
        margin: 0;
        color: #333;
        font-weight: 500;
        font-size: 14px;
    }

    .vendor-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 500;
        display: inline-block;
    }

    .status-active {
        background: #0d3e9b;
        color: white;
    }

    .status-pending {
        background: #ffc107;
        color: white;
    }

    .status-restricted {
        background: #dc3545;
        color: white;
    }

    .status-declined {
        background: #6c757d;
        color: white;
    }

    .vendor-type {
        color: #333;
        font-size: 14px;
    }

    .vendor-phone {
        color: #6c757d;
        font-size: 14px;
    }

    .vendor-date {
        color: #6c757d;
        font-size: 14px;
    }

    .actions-btn,
    .view-btn {
        background: none;
        border: none;
        color: #6c757d;
        padding: 5px;
        cursor: pointer;
        border-radius: 4px;
        transition: background 0.3s ease;
    }

    .actions-btn:hover,
    .view-btn:hover {
        background: #f8f9fa;
    }

    .pagination-container {
        padding: 20px 25px;
        border-top: 1px solid #f8f9fa;
        display: flex;
        justify-content: flex-end;
        align-items: center;
        gap: 20px;
    }

    .pagination-info {
        color: #6c757d;
        font-size: 14px;
    }

    .pagination-controls {
        display: flex;
        gap: 8px;
        align-items: center;
    }

    .pagination-btn {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.3s ease;
        color: #6c757d;
    }

    .pagination-btn:hover {
        background: #f8f9fa;
    }

    .pagination-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
        border-bottom: 1px solid #e9ecef;
        padding: 20px;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .modal-body {
        padding: 20px;
    }

    .modal-body p {
        color: #666;
        margin-bottom: 20px;
        line-height: 1.5;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .btn-primary {
        background: #0d3e9b;
        border: 1px solid #0d3e9b;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        cursor: pointer;
    }

    .btn-primary:hover {
        background: #0b3484;
        border-color: #0b3484;
    }

    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .alert {
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-dismissible .close {
        position: absolute;
        top: 0;
        right: 10px;
        padding: 10px;
        color: inherit;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .top-bar {
            padding: 15px 20px;
        }

        .search-filter-bar {
            flex-direction: column;
            align-items: stretch;
            gap: 10px;
        }

        .search-input {
            max-width: none;
        }

        .pagination-container {
            flex-direction: column;
            gap: 10px;
            text-align: center;
        }

        .vendors-table th,
        .vendors-table td {
            padding: 10px;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Vendors</h1>
        <!-- <button class="btn btn-primary" onclick="addVendor()">
            <i class="fa fa-plus"></i> Add New Vendor
        </button> -->

    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span>></span>
            <span style="color: #333; font-weight: 500">Vendors</span>
        </nav>

        <!-- Search and Filter Bar -->
        <div class="search-filter-bar">
            <div class="search-input">
                <input type="text" placeholder="Search vendors" id="vendorSearch" />
                <i class="fa fa-search"></i>
            </div>
            <div class="button-filters">
                <button class="filter-btn" onclick="showFilters()">
                    <i class="fa fa-filter"></i> Filter
                </button>
                <button class="export-btn" onclick="exportVendors()">
                    <i class="fa fa-download"></i> Export
                </button>
            </div>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <ul>
                <li>
                    <p class="active" onclick="filterVendors('all')">All</p>
                </li>
                <li>
                    <p onclick="filterVendors('active')">Active</p>
                </li>
                <li>
                    <p onclick="filterVendors('pending')">Pending</p>
                </li>
                <li>
                    <p onclick="filterVendors('restricted')">Restricted</p>
                </li>
                <li>
                    <p onclick="filterVendors('declined')">Declined</p>
                </li>
            </ul>
        </div>

        <!-- Vendors Section -->
        <div class="vendors-section">
            <div class="vendors-header">
                <div>
                    <h3 class="vendors-title">Vendors</h3>
                    <p class="vendors-subtitle">Manage vendors and view their information.</p>
                </div>
            </div>

            <!-- Vendors Table -->
            <div class="table-container">
                <table class="vendors-table">
                    <thead>
                        <tr>
                            <th>
                                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()" />
                                <span style="margin-left: 10px">Name</span>
                            </th>
                            <th>Type</th>
                            <th>Status</th>
                            <th>Phone Number</th>
                            <th>Date of Registration</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="vendorsTableBody">
                        <?php foreach ($paginatedvendors as $vendor): ?>
                            <?php
                            $status = strtolower($vendor->status);
                            $avatarInitials = strtoupper(substr($vendor->business_name, 0, 2));
                            ?>
                            <tr data-vendor-id="<?= $vendor->id ?>" data-status="<?= htmlspecialchars($status) ?>">
                                <td>
                                    <div class="vendor-info">
                                        <input type="checkbox" class="vendor-checkbox" />
                                        <div class="vendor-avatar"><?= htmlspecialchars($avatarInitials) ?></div>
                                        <div class="vendor-details">
                                            <h6><?= htmlspecialchars($vendor->business_name) ?></h6>
                                            <p><?= htmlspecialchars($vendor->email) ?></p>
                                        </div>
                                    </div>
                                </td>
                                <td><span class="vendor-type"><?= htmlspecialchars($vendor->type ?: 'N/A') ?></span></td>
                                <td>
                                    <span class="status-badge status-<?= $status ?>">
                                        <?= htmlspecialchars(ucfirst($vendor->status)) ?>
                                    </span>
                                </td>
                                <td><span
                                        class="vendor-phone"><?= htmlspecialchars($vendor->bank_account ?: 'N/A') ?></span>
                                </td>
                                <td><span
                                        class="vendor-date"><?= htmlspecialchars(date('Y-m-d h:i A', strtotime($vendor->created_at))) ?></span>
                                </td>
                                <td>
                                    <?php if ($status === 'restricted'): ?>
                                        <button class="actions-btn"
                                            onclick="showUnrestrictModal(<?= $vendor->id ?>, '<?= htmlspecialchars($vendor->business_name) ?>')">
                                            <i class="fa fa-lock"></i>
                                        </button>
                                    <?php else: ?>
                                        <button class="view-btn" onclick="viewVendor(<?= $vendor->id ?>)">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="pagination-container">
                <div class="pagination-info">Page 1 of <?= ceil($overview['total_vendors'] / 10) ?></div>
                <div class="pagination-controls">
                    <button class="pagination-btn" onclick="goToPage('first')" disabled><i
                            class="fa fa-angle-double-left"></i></button>
                    <button class="pagination-btn" onclick="goToPage('prev')" disabled><i
                            class="fa fa-angle-left"></i></button>
                    <button class="pagination-btn" onclick="goToPage('next')"><i class="fa fa-angle-right"></i></button>
                    <button class="pagination-btn" onclick="goToPage('last')"><i
                            class="fa fa-angle-double-right"></i></button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Unrestrict Confirmation Modal -->
<div class="modal fade" id="unrestrictModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Unrestrict Vendor</h4>
            </div>
            <div class="modal-body">
                <p id="unrestrictMessage"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="hideUnrestrictModal()">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmUnrestrictBtn">Confirm</button>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    let currentPage = 1;
    const totalPages = <?= ceil($overview['total_vendors'] / 10) ?>;

    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'dashboard' ? 'dasha' : page === 'vendors' ? 'vendors' : '#';
    }

    // Add vendor (placeholder)
    function addVendor() {
        alert("Add New Vendor - would open vendor registration form");
    }

    // View vendor details
    function viewVendor(vendorId) {
        window.location.href = `vendor_detail.php?id=${encodeURIComponent(btoa(vendorId))}`;
    }

    // Filter vendors by status
    function filterVendors(status) {
        document.querySelectorAll('.filter-tabs p').forEach(tab => {
            tab.classList.remove('active');
        });
        event.target.classList.add('active');

        const rows = document.querySelectorAll('#vendorsTableBody tr');
        rows.forEach(row => {
            const rowStatus = row.dataset.status;
            row.style.display = (status === 'all' || rowStatus === status) ? '' : 'none';
        });
    }


    // Show unrestrict modal
    function showUnrestrictModal(vendorId, vendorName) {
        document.getElementById('unrestrictMessage').innerHTML = `Are you sure you want to unrestrict ${vendorName}? This will restore their access to the Marketplace.`;
        document.getElementById('confirmUnrestrictBtn').dataset.vendorId = vendorId;
        $('#unrestrictModal').modal('show');
    }

    // Hide unrestrict modal
    function hideUnrestrictModal() {
        $('#unrestrictModal').modal('hide');
    }

    // Unrestrict vendor
    function unrestrictVendor(vendorId) {
        const btn = document.getElementById('confirmUnrestrictBtn');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
        btn.disabled = true;

        $.ajax({
            type: 'POST',
            url: 'vendors.php',
            data: { vendor_id: vendorId, new_status: 'active' },
            dataType: 'json',
            success: function (data) {
                if (data.success) {
                    showNotification(`Vendor unrestricted successfully!`, 'success');
                    // Update status in UI
                    const row = document.querySelector(`tr[data-vendor-id="${vendorId}"]`);
                    const statusBadge = row.querySelector('.status-badge');
                    statusBadge.textContent = 'Active';
                    statusBadge.className = 'status-badge status-active';
                    // Update action button
                    const actionCell = row.querySelector('td:last-child');
                    actionCell.innerHTML = `<button class="view-btn" onclick="viewVendor(${vendorId})"><i class="fa fa-eye"></i></button>`;
                    hideUnrestrictModal();
                } else {
                    showNotification(`Failed to unrestrict vendor: ${data.message}`, 'error');
                }
                btn.innerHTML = originalText;
                btn.disabled = false;
            },
            error: function () {
                showNotification('Error unrestricting vendor. Please try again.', 'error');
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        });
    }


    // Search functionality
    document.getElementById('vendorSearch').addEventListener('input', function () {
        const searchTerm = this.value.toLowerCase();
        const rows = document.querySelectorAll('#vendorsTableBody tr');

        rows.forEach(row => {
            const vendorName = row.querySelector('.vendor-details h6').textContent.toLowerCase();
            const vendorEmail = row.querySelector('.vendor-details p').textContent.toLowerCase();
            const vendorType = row.querySelector('.vendor-type').textContent.toLowerCase();
            const vendorPhone = row.querySelector('.vendor-phone').textContent.toLowerCase();

            row.style.display = (vendorName.includes(searchTerm) ||
                vendorEmail.includes(searchTerm) ||
                vendorType.includes(searchTerm) ||
                vendorPhone.includes(searchTerm)) ? '' : 'none';
        });
    });

    // Toggle select all checkboxes
    function toggleSelectAll() {
        const selectAllCheckbox = document.getElementById('selectAll');
        const vendorCheckboxes = document.querySelectorAll('.vendor-checkbox');
        vendorCheckboxes.forEach(checkbox => {
            checkbox.checked = selectAllCheckbox.checked;
        });
    }

    // Show filters (placeholder)
    function showFilters() {
        alert('Show Filters - would open filter options modal');
    }

    // Export vendors
    function exportVendors() {
        const rows = document.querySelectorAll('#vendorsTableBody tr');
        let csvContent = 'Name,Email,Type,Status,Phone,Registration Date\n';

        rows.forEach(row => {
            const name = row.querySelector('.vendor-details h6').textContent;
            const email = row.querySelector('.vendor-details p').textContent;
            const type = row.querySelector('.vendor-type').textContent;
            const status = row.querySelector('.status-badge').textContent;
            const phone = row.querySelector('.vendor-phone').textContent;
            const date = row.querySelector('.vendor-date').textContent;
            csvContent += `"${name}","${email}","${type}","${status}","${phone}","${date}"\n`;
        });

        const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
        const link = document.createElement('a');
        link.href = URL.createObjectURL(blob);
        link.download = 'vendors.csv';
        link.click();
    }

    // Pagination navigation
    function goToPage(direction) {
        if (direction === 'first') {
            currentPage = 1;
        } else if (direction === 'prev' && currentPage > 1) {
            currentPage--;
        } else if (direction === 'next' && currentPage < totalPages) {
            currentPage++;
        } else if (direction === 'last') {
            currentPage = totalPages;
        }

        // Update pagination info
        document.querySelector('.pagination-info').textContent = `Page ${currentPage} of ${totalPages}`;

        // Update button states
        document.querySelector('.pagination-btn[onclick="goToPage(\'first\')]').disabled = currentPage === 1;
        document.querySelector('.pagination-btn[onclick="goToPage(\'prev\')]').disabled = currentPage === 1;
        document.querySelector('.pagination-btn[onclick="goToPage(\'next\')]').disabled = currentPage === totalPages;
        document.querySelector('.pagination-btn[onclick="goToPage(\'last\')]').disabled = currentPage === totalPages;

        // Fetch new page data (placeholder)
        alert(`Navigate to page ${currentPage}`);
        // In a real app, fetch new vendor data via AJAX
    }

    // Confirm unrestrict action
    document.getElementById('confirmUnrestrictBtn').addEventListener('click', function () {
        const vendorId = this.dataset.vendorId;
        unrestrictVendor(vendorId);
    });

    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible`;
        notification.style.cssText = `
            position: fixed;
            top: 90px;
            right: 20px;
            z-index: 9999;
            min-width: 300px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        `;
        notification.innerHTML = `
            <button type="button" class="close" onclick="this.parentElement.remove()">
                <span>&times;</span>
            </button>
            <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
        `;
        document.body.appendChild(notification);
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    // Initialize page
    document.addEventListener('DOMContentLoaded', function () {
        console.log('Vendors Dashboard initialized');
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        }
    });

    // Handle responsive behavior
    window.addEventListener('resize', function () {
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        } else {
            document.body.classList.remove('mobile-view');
        }
    });

    // Initialize Bootstrap tooltips
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>