<?php
$page = "Marketplace Vendor Sales";
$page_url = "vendor_sales";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
?>

<!-- Include DataTables and Bootstrap Datepicker CSS/JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

<style>
    /* Retain provided CSS with DataTables-specific adjustments */
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 5px 0 10px;
        font-size: 14px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
    }

    .breadcrumb a:hover {
        color: #0d3e9b;
    }

    .sales-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .search-filter-bar {
        display: flex;
        justify-content: space-between;
        margin: 20px 0;
        flex-wrap: wrap;
        gap: 10px;
    }

    .search-input {
        flex: 1;
        max-width: 300px;
        position: relative;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .button-filters {
        display: flex;
        gap: 20px;
    }

    .filter-btn,
    .export-btn {
        border: 1px solid #ddd;
        padding: 8px 16px;
        border-radius: 4px;
        background: #f8f9fa;
        color: #333;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
    }

    .filter-btn:hover,
    .export-btn:hover {
        background: #e9ecef;
    }

    .table-container {
        overflow-x: auto;
    }

    .sales-table {
        margin: 0;
        width: 100%;
        border-collapse: collapse;
    }

    .sales-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .sales-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
    }

    .sales-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        border-bottom: 1px solid #f8f9fa;
    }

    .sales-table tbody tr:hover {
        background: #f8f9fa;
    }

    .customer-info {
        display: flex;
        align-items: center;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 6px;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
        background: #e9ecef;
    }

    .customer-details h6 {
        margin: 0;
        color: #333;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .label {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        color: white;
        font-weight: 500;
    }

    .label-fulfilled {
        background: #0d3e9b;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: #f8f9fa;
        border-radius: 4px;
        color: #6c757d;
        margin: 0 2px;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: #e9ecef;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: #1976d2;
        color: white;
        border-color: #1976d2;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .dataTables_info {
        color: #6c757d;
        font-size: 14px;
        padding: 20px 25px;
    }

    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 10000;
        align-items: center;
        justify-content: center;
    }

    .modal-content {
        background: white;
        padding: 30px;
        border-radius: 12px;
        min-width: 400px;
        max-width: 600px;
        position: relative;
    }

    .close-btn {
        position: absolute;
        top: 10px;
        right: 15px;
        font-size: 20px;
        cursor: pointer;
        color: #6c757d;
    }

    .modal-header {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin-bottom: 20px;
    }

    .modal-body .section-title {
        font-size: 16px;
        font-weight: 500;
        color: #333;
        margin: 20px 0 10px;
    }

    .modal-body .info-table {
        width: 100%;
        border-collapse: collapse;
    }

    .modal-body .info-table tr {
        border-bottom: 1px solid #f8f9fa;
    }

    .modal-body .info-table td {
        padding: 8px 0;
        color: #333;
        font-size: 14px;
    }

    .modal-body .info-table td:first-child {
        width: 40%;
        color: #6c757d;
    }

    .btn-primary {
        background: #1976d2;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-primary:hover {
        background: #0d3e9b;
    }

    .btn-default {
        border: 1px solid #ddd;
        padding: 8px 16px;
        border-radius: 4px;
        background: #f8f9fa;
        color: #333;
    }

    .btn-default:hover {
        background: #e9ecef;
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-danger {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
    }

    .alert-success {
        background: #d1fae5;
        border: 1px solid #6ee7b7;
        color: #065f46;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .search-filter-bar {
            flex-direction: column;
            align-items: stretch;
            gap: 10px;
        }

        .search-input {
            max-width: none;
        }

        .stat-card {
            margin-bottom: 15px;
        }

        .sales-table th,
        .sales-table td {
            padding: 10px 15px;
        }

        .modal-content {
            min-width: 90%;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Sales</h1>
        <button class="btn btn-primary export-btn" onclick="exportToCSV()">
            <i class="fa fa-download" style="margin-right: 8px"></i>Export as CSV
        </button>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span style="color: #6c757d; margin: 0 8px">></span>
            <span style="color: #333">Sales</span>
        </nav>

        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">Create
                    Vendor Account</a>
            </div>
        <?php else: ?>
            <!-- Stats Row -->
            <div class="row stats-row">
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Revenue</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦<?= number_format($vendor_check['total_revenue'], 2) ?></div>
                        <div class="stat-label">Sum of all sales transactions</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Sales</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= $vendor_check['total_orders'] ?></div>
                        <div class="stat-label">Orders made in the last 30 days</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Calculated Profit</div>
                            <div class="stat-icon">
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= htmlspecialchars($vendor_check['calculated_profit'] ?? 'N/A') ?></div>
                        <div class="stat-label">Estimated profit from sales</div>
                    </div>
                </div>
            </div>

            <!-- Search and Filter Bar -->
            <div class="search-filter-bar">
                <div class="search-input">
                    <input type="text" class="form-control" placeholder="Search sales" id="salesSearch" />
                    <i class="fa fa-search"></i>
                </div>
                <div class="button-filters">
                    <button class="filter-btn" data-toggle="modal" data-target="#filterModal">
                        <i class="fa fa-filter"></i> Filter
                    </button>
                </div>
            </div>

            <!-- Sales Section -->
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Sales</h3>
                        <p class="sales-subtitle">Purchases made from your store online</p>
                    </div>
                </div>

                <!-- Sales Table -->
                <div class="table-container">
                    <table class="sales-table" id="salesTable">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" onchange="toggleSelectAll()" /> Customer</th>
                                <th>Product</th>
                                <th>Status</th>
                                <th>Price</th>
                                <th>Purchase Date</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Sale Details Modal -->
    <div id="saleModal" class="modal"></div>

    <!-- Filter Modal -->
    <div class="modal fade" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="filterModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="filterModalLabel">Filter Sales</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="startDate">Start Date</label>
                        <input type="text" class="form-control datepicker" id="startDate" placeholder="YYYY-MM-DD">
                    </div>
                    <div class="form-group">
                        <label for="endDate">End Date</label>
                        <input type="text" class="form-control datepicker" id="endDate" placeholder="YYYY-MM-DD">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="applyFilters()">Apply Filters</button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    $(document).ready(function () {
        let currentStartDate = null;
        let currentEndDate = null;

        // Initialize Datepickers
        $('#startDate, #endDate').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true
        });

        // Initialize DataTables
        const table = $('#salesTable').DataTable({
            serverSide: true,
            processing: true,
            pageLength: 5,
            lengthChange: false,
            searching: false,
            ordering: true,
            info: true,
            ajax: {
                url: 'ajax/ajax_vendor_sales.php',
                type: 'GET',
                data: function (d) {
                    d.page = Math.floor(d.start / d.length) + 1;
                    d.search = $('#salesSearch').val();
                    d.startDate = currentStartDate;
                    d.endDate = currentEndDate;
                },
                error: function (xhr, error, thrown) {
                    console.log('DataTables AJAX error:', xhr, error, thrown);
                    showNotification('Failed to load sales. Check the console for details.', 'error');
                }
            },
            columns: [
                { data: 'customer', orderable: true },
                { data: 'product', orderable: true },
                { data: 'status', orderable: true },
                { data: 'price', orderable: true },
                { data: 'date', orderable: true }
            ]
        });

        // Custom search
        $('#salesSearch').on('input', function () {
            table.ajax.reload();
        });

        // Apply date filters
        window.applyFilters = function () {
            currentStartDate = $('#startDate').val();
            currentEndDate = $('#endDate').val();
            $('#filterModal').modal('hide');
            table.ajax.reload();
        };

        // Toggle select all checkboxes
        window.toggleSelectAll = function () {
            const selectAllCheckbox = $('#selectAll')[0];
            const salesCheckboxes = $('.sales-checkbox');
            salesCheckboxes.prop('checked', selectAllCheckbox.checked);
        };

        // Export to CSV
        window.exportToCSV = function () {
            $.ajax({
                url: 'ajax/ajax_vendor_sales.php',
                type: 'GET',
                data: {
                    action: 'export',
                    search: $('#salesSearch').val(),
                    startDate: currentStartDate,
                    endDate: currentEndDate
                },
                success: function (response) {
                    const data = response.data;
                    let csvContent = 'Order ID,Customer,Email,Product,Status,Price,Date\n';
                    data.forEach(row => {
                        const cleanPrice = row.price.replace(/[^\d.,]/g, '');
                        csvContent += `"${row.order_id}","${row.customer_name}","${row.email}","${row.product}","${row.status}","${cleanPrice}","${row.date}"\n`;
                    });
                    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
                    const link = document.createElement('a');
                    link.href = URL.createObjectURL(blob);
                    link.download = 'sales_export.csv';
                    link.click();
                },
                error: function () {
                    showNotification('Failed to export sales. Please try again.', 'error');
                }
            });
        };

        // Sale details modal
        $(document).on('click', 'tbody tr', function () {
            const rowData = table.row(this).data();
            if (!rowData) return;

            const modal = `
                <div class="modal" style="display: flex;">
                    <div class="modal-content">
                        <span class="close-btn" onclick="closeModal()">&times;</span>
                        <div class="modal-header">Sale Details</div>
                        <div class="modal-body">
                            <div class="section-title">Sale Information</div>
                            <table class="info-table">
                                <tr>
                                    <td>Order ID:</td>
                                    <td><a href="/ajax/order_detail.php?id=${encodeURIComponent(btoa(rowData.order_id))}" style="color: #0d3e9b; text-decoration: none;">#${rowData.order_id}</a></td>
                                </tr>
                                <tr>
                                    <td>Customer:</td>
                                    <td>${rowData.customer_name}</td>
                                </tr>
                                <tr>
                                    <td>Email:</td>
                                    <td>${rowData.email}</td>
                                </tr>
                                <tr>
                                    <td>Product:</td>
                                    <td>${rowData.product}</td>
                                </tr>
                                <tr>
                                    <td>Status:</td>
                                    <td><span class="label label-fulfilled">${rowData.status}</span></td>
                                </tr>
                                <tr>
                                    <td>Price:</td>
                                    <td>${rowData.price}</td>
                                </tr>
                                <tr>
                                    <td>Purchase Date:</td>
                                    <td>${rowData.date}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>`;
            $('#saleModal').html(modal);
        });

        // Close modal
        window.closeModal = function () {
            $('.modal').remove();
        };

        // Notification system
        window.showNotification = function (message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'}`;
            notification.innerHTML = `
                <button type="button" class="close" onclick="this.parentElement.remove()">
                    <span>&times;</span>
                </button>
                <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
            `;
            document.body.appendChild(notification);
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        };

        // Navigation function
        window.navigateTo = function (page) {
            window.location.href = page === 'dashboard' ? 'vendor_dashboard.php' : '#';
        };

        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>