<?PHP
$page = "Marketplace Vendor Products";
$page_url = "vendor_products";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?PHP
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
if ($vendor_id !== null) {
    $vendor_check = $dashboard->vendorProductDashboard($vendor_id);
    $lastSales = $dashboard->getsalesByGlobalId($_SESSION[$sid . 'userid']);
}
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        inset: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .content-nav {
        margin-bottom: 4px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        /* background: white; */
        border-radius: 8px;
        padding: 25px;
        /* box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); */
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .sales-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .sales-list {
        padding: 0;
    }

    .sale-item {
        padding: 15px 25px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: space-between;
        transition: background 0.3s ease;
    }

    .sale-item:hover {
        background: #f8f9fa;
    }

    .sale-item:last-child {
        border-bottom: none;
    }

    .customer-info {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
    }

    .customer-details h6 {
        margin: 0;
        color: #333;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .product-name {
        flex: 1;
        color: #6c757d;
        font-size: 14px;
        text-align: center;
    }

    .sale-amount {
        color: #333;
        font-weight: 500;
        font-size: 14px;
    }

    .itemdropdown {
        display: none;
        position: absolute;
        background-color: white;
        box-shadow: 0px 2px 8px rgba(0, 0, 0, 0.2);
        z-index: 10;
        right: 0;
        top: 45px;
        min-width: 160px;
        border-radius: 6px;
        overflow: hidden;
    }

    /* Prevent dropdown from overflowing the table for last rows */
    .table-responsive {
        position: relative;
    }

    .action-container {
        position: relative;
    }

    .itemdropdown {
        /* If dropdown would go below the viewport, show above */
        bottom: auto;
        /* You can use JS to dynamically set 'bottom' instead of 'top' for last rows if needed */
        /* Or add max-height and scroll */
        max-height: 220px;
        overflow-y: auto;
    }

    .itemdropdown a,
    .actions-header {
        padding: 10px 15px;
        display: block;
        text-decoration: none;
        color: #333;
    }

    .actions-header {
        border-bottom: 1px solid #eee;
        font-weight: 600;
    }

    .itemdropdown a:hover {
        background-color: #f1f1f1;
    }

    .itemdropdown a:last-child {
        color: red;
        border-bottom: none;
    }

    .search-area {
        display: flex;
        justify-content: space-between;
        margin: 20px 0;
    }

    /* Modal Styles */
    .modal {
        display: none;
        position: fixed;
        z-index: 50;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        background-color: white;
        margin: 60px auto;
        padding: 20px;
        border-radius: 10px;
        width: 90%;
        max-width: 600px;
    }

    .modal-header {
        font-size: 18px;
        font-weight: bold;
        margin-bottom: 10px;
    }

    .modal-body {
        border-top: 1px solid #ddd;
        padding-top: 10px;
    }

    .modal-body p,
    .modal-body div {
        margin: 8px 0;
    }

    .close-btn {
        float: right;
        font-size: 20px;
        cursor: pointer;
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
    }

    .form-group input {
        width: 100%;
        padding: 8px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }

    .modal-footer {
        text-align: right;
        margin-top: 20px;
    }

    .btn-save {
        background: #0d3e9b;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }

    .btn-cancel {
        background: #6c757d;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        margin-right: 10px;
    }

    @media (max-width: 768px) {
        .sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s ease;
        }

        .sidebar.show {
            transform: translateX(0);
        }

        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .stat-card {
            margin-bottom: 15px;
        }
    }
</style>

<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Dashboard</h1>
        <button class="btn btn-primary">
            <i class="fa fa-plus" style="margin-right: 8px"></i>Add a Product
        </button>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">
                    Create Vendor Account
                </a>
            </div>
        <?php else: ?>
            <!-- Stats Row -->
            <nav class="breadcrumb" style="background: none; padding: 0; margin: 5px 0 10px">
                <a href="#" style="color: #6c757d; text-decoration: none; font-size: 14px">Dashboard</a>
                <span style="color: #6c757d; margin: 0 8px">></span>
                <span style="color: #333; font-size: 14px">Products</span>
            </nav>

            <!-- Stats Row -->
            <div class="row stats-row">
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Revenue</div>
                            <div class="stat-icon">
                                <i class="fa fa-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦<?= number_format($vendor_check['total_revenue'], 2) ?></div>
                        <div class="stat-label">Sum of all sales transactions</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Sales</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= $vendor_check['total_orders'] ?></div>
                        <div class="stat-label">Orders made in the last 30 days</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Active Now</div>
                            <div class="stat-icon">
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= htmlspecialchars($vendor_check['active_products'] ?? 'N/A') ?></div>
                        <div class="stat-label">Total active products</div>
                    </div>
                </div>
            </div>

            <!-- Search and filter area -->
            <div class="search-area flex mt-4">
                <div class="input-group" style="width: 300px; display: flex">
                    <input type="text" class="form-control" placeholder="Search products"
                        style="border: 1px solid #ddd; padding: 17px 12px" />
                    <span class="input-group-btn">
                        <button class="btn btn-default" type="button" style="
                        border-radius: 0 4px 4px 0;
                        border: 1px solid #ddd;
                        border-left: none;
                        padding: 7px 12px;
                      ">
                            <i class="fa fa-search"></i>
                        </button>
                    </span>
                </div>
                <button class="btn btn-default" style="
                    border: 1px solid #ddd;
                    padding: 8px 16px;
                    border-radius: 4px;
                  ">
                    <i class="fa fa-filter" style="margin-right: 8px"></i>Filter
                </button>
            </div>

            <!-- Products Section -->
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Products</h3>
                        <p class="sales-subtitle">Manage your products and view their sales performance.</p>
                    </div>
                </div>

                <!-- Products Table -->
                <div class="table-responsive">
                    <table class="table table-hover" style="margin: 0">
                        <thead style="background: #f8f9fa; border-bottom: 1px solid #e9ecef">
                            <tr>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    <input type="checkbox" style="margin-right: 10px" />Name
                                </th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Status
                                </th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Revenue
                                </th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Total Sales
                                </th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Created at
                                </th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($vendor_check['all_products'] as $product): ?>
                                <tr style="border-bottom: 1px solid #f8f9fa">
                                    <td style="padding: 15px 25px; border: none; vertical-align: middle;">
                                        <div style="display: flex; align-items: center">
                                            <input type="checkbox" style="margin-right: 15px" />
                                            <div
                                                style="width: 40px; height: 40px; background: #e9ecef; border-radius: 6px; margin-right: 15px;">
                                            </div>
                                            <a href="vendor_product_detail.php?id=<?= urlencode(base64_encode($product['product_id'])) ?>"
                                                style="color: #333; font-weight: 500">
                                                <?= htmlspecialchars($product['product_name']) ?>
                                            </a>
                                        </div>
                                    </td>
                                    <td style="padding: 15px 25px; border: none; vertical-align: middle;">
                                        <span class="" style="
                               
                                background: <?= $product['product_status'] == 'active' ? '#0d3e9b' : ($product['product_status'] == 'pending' ? '#FFDE00' : ($product['product_status'] == 'rejected' ? 'red' : '#6c757d')) ?>;
                                padding: 4px 12px;
                                border-radius: 12px;
                                font-size: 12px;
                                color: white;
                              ">
                                            <?= htmlspecialchars($product['product_status']) ?>
                                        </span>
                                    </td>
                                    <td style="padding: 15px 25px; border: none; vertical-align: middle; color: #333;">
                                        ₦<?= number_format($product['total_amount_sold'], 2) ?>
                                    </td>
                                    <td style="padding: 15px 25px; border: none; vertical-align: middle; color: #333;">
                                        <?= number_format($product['number_of_sales']) ?>
                                    </td>
                                    <td style="padding: 15px 25px; border: none; vertical-align: middle; color: #6c757d;">
                                        <?= htmlspecialchars($product['product_created_date']) ?>
                                    </td>
                                    <td style="padding: 15px 25px; border: none; vertical-align: middle; position: relative;">
                                        <div class="action-container">
                                            <button class="btn btn-link action-btn" style="color: #6c757d; padding: 5px">
                                                <i class="fa fa-ellipsis-h"></i>
                                            </button>
                                            <div class="itemdropdown" style="display: none">
                                                <p class="actions-header">Actions</p>
                                                <!-- <a href="#" class="archive-btn"
                                                    data-product-id="<?= $product['product_id'] ?>">Archive</a> -->
                                                <a href="vendor_product_detail.php?id=<?= urlencode(base64_encode($product['product_id'])) ?>"
                                                    class="edit-btn">Edit</a>
                                                <!-- <a href="#" class="add-stock-btn"
                                                    data-product-id="<?= $product['product_id'] ?>"
                                                    data-product-name="<?= htmlspecialchars($product['product_name']) ?>">Add
                                                    Stock</a> -->
                                                <!-- <a href="#" class="copy-link-btn"
                                                    data-product-id="<?= $product['product_id'] ?>">Copy Link</a>
                                                <a href="#" class="delete-btn"
                                                    data-product-id="<?= $product['product_id'] ?>">Delete</a> -->
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div
                    style="padding: 20px 25px; border-top: 1px solid #f8f9fa; display: flex; justify-content: flex-end; gap: 8px; align-items: center;">
                    <div style="color: #6c757d; font-size: 14px">Page 1 of 10</div>
                    <div>
                        <button class="btn btn-default btn-sm"
                            style="border: 1px solid #ddd; margin-right: 5px; padding: 5px 10px;">
                            <i class="fa fa-angle-double-left"></i>
                        </button>
                        <button class="btn btn-default btn-sm"
                            style="border: 1px solid #ddd; margin-right: 5px; padding: 5px 10px;">
                            <i class="fa fa-angle-left"></i>
                        </button>
                        <button class="btn btn-default btn-sm"
                            style="border: 1px solid #ddd; margin-right: 5px; padding: 5px 10px;">
                            <i class="fa fa-angle-right"></i>
                        </button>
                        <button class="btn btn-default btn-sm" style="border: 1px solid #ddd; padding: 5px 10px;">
                            <i class="fa fa-angle-double-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add Stock Modal -->
<div id="addStockModal" class="modal">
    <div class="modal-content">
        <span class="close-btn" id="closeStockModal">&times;</span>
        <div class="modal-header">Add Stock for <span id="modalProductName"></span></div>
        <div class="modal-body">
            <form id="addStockForm">
                <div class="form-group">
                    <label for="stockQuantity">Stock Quantity</label>
                    <input type="number" id="stockQuantity" name="stock_quantity" min="1" required>
                    <input type="hidden" id="productId" name="product_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-cancel" id="cancelStockModal">Cancel</button>
                    <button type="submit" class="btn btn-save">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?PHP include_once 'includes/footer.php'; ?>

<script>
    // Add Product button functionality
    $(".btn-primary").click(function () {
        window.location.href = "vendor_add_product.php";
    });

    // Search functionality
    $('input[placeholder="Search products"]').on("keyup", function () {
        var searchTerm = $(this).val().toLowerCase();
        $("tbody tr").each(function () {
            var productName = $(this).find("td:first a").text().toLowerCase();
            if (productName.indexOf(searchTerm) === -1) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
    });

    // Filter button functionality
    $('.btn-default:contains("Filter")').click(function () {
        alert("Filter Products - This would show filter options");
    });

    // Checkbox functionality
    $('input[type="checkbox"]').change(function () {
        if ($(this).closest("th").length) {
            var isChecked = $(this).is(":checked");
            $('tbody input[type="checkbox"]').prop("checked", isChecked);
        }
    });

    // Modal and itemdropdown functionality
    const addStockModal = document.getElementById("addStockModal");
    const closeStockModal = document.getElementById("closeStockModal");
    const cancelStockModal = document.getElementById("cancelStockModal");

    // Close modal
    closeStockModal.addEventListener("click", () => {
        addStockModal.style.display = "none";
    });

    cancelStockModal.addEventListener("click", () => {
        addStockModal.style.display = "none";
    });

    // Close modal on outside click
    window.addEventListener("click", (event) => {
        if (event.target === addStockModal) {
            addStockModal.style.display = "none";
        }
    });

    // Handle itemdropdown toggle for each row
    document.querySelectorAll(".action-btn").forEach((button) => {
        button.addEventListener("click", (e) => {
            e.preventDefault();
            const itemdropdown = button.closest(".action-container").querySelector(".itemdropdown");
            // Close all other itemdropdowns
            document.querySelectorAll(".itemdropdown").forEach((d) => {
                if (d !== itemdropdown) d.style.display = "none";
            });
            // Toggle current itemdropdown
            itemdropdown.style.display = itemdropdown.style.display === "block" ? "none" : "block";
        });
    });

    // Close itemdropdowns when clicking outside
    window.addEventListener("click", (event) => {
        if (!event.target.closest(".action-container")) {
            document.querySelectorAll(".itemdropdown").forEach((itemdropdown) => {
                itemdropdown.style.display = "none";
            });
        }
    });

    // Archive button functionality
    document.querySelectorAll(".archive-btn").forEach((archiveBtn) => {
        archiveBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const productId = archiveBtn.getAttribute("data-product-id");
            alert(`Archiving product with ID: ${productId}`);
            archiveBtn.closest(".itemdropdown").style.display = "none";
            // Add AJAX call to archive product here
        });
    });

    // Add Stock button functionality
    document.querySelectorAll(".add-stock-btn").forEach((addStockBtn) => {
        addStockBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const productId = addStockBtn.getAttribute("data-product-id");
            const productName = addStockBtn.getAttribute("data-product-name");
            document.getElementById("modalProductName").textContent = productName;
            document.getElementById("productId").value = productId;
            addStockModal.style.display = "block";
            addStockBtn.closest(".itemdropdown").style.display = "none";
        });
    });

    // Copy Link button functionality
    document.querySelectorAll(".copy-link-btn").forEach((copyLinkBtn) => {
        copyLinkBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const productId = copyLinkBtn.getAttribute("data-product-id");
            const productLink = `${window.location.origin}/vendor_product_detail.php?id=${encodeURIComponent(btoa(productId))}`;
            navigator.clipboard.writeText(productLink).then(() => {
                alert("Product link copied to clipboard!");
                copyLinkBtn.closest(".itemdropdown").style.display = "none";
            });
        });
    });

    // Delete button functionality
    document.querySelectorAll(".delete-btn").forEach((deleteBtn) => {
        deleteBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const productId = deleteBtn.getAttribute("data-product-id");
            if (confirm(`Are you sure you want to delete product with ID: ${productId}?`)) {
                alert(`Deleting product with ID: ${productId}`);
                deleteBtn.closest(".itemdropdown").style.display = "none";
                // Add AJAX call to delete product here
            }
        });
    });

    // Add Stock form submission
    document.getElementById("addStockForm").addEventListener("submit", (e) => {
        e.preventDefault();
        const productId = document.getElementById("productId").value;
        const stockQuantity = document.getElementById("stockQuantity").value;
        alert(`Adding ${stockQuantity} stock to product with ID: ${productId}`);
        addStockModal.style.display = "none";
        // Add AJAX call to update stock here
    });

    // Table row hover effects
    $("tbody tr").hover(
        function () {
            $(this).css("background-color", "#f8f9fa");
        },
        function () {
            $(this).css("background-color", "white");
        }
    );

    // Initialize tooltips if needed
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>