<?php
$page = "Orders";
$page_url = "vendor_orders";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

if ($vendor_id !== null) {
    $vendorOrders = $dashboard->getVendorOrders($vendor_id);
}
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 5px 0 10px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb span {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb .active {
        color: #333;
        font-size: 14px;
    }

    .stats-row {
        margin-bottom: 30px;
        display: flex;
        gap: 20px;
        flex-wrap: wrap;
    }

    .stat-card {
        background: white;
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        flex: 1;
        min-width: 200px;
        max-width: 300px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .sales-section {
        background: white;
        border-radius: 8px;
        border: 1px solid #e9ecef;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .search-area {
        display: flex;
        justify-content: space-between;
        margin: 20px 0;
        flex-wrap: wrap;
        gap: 10px;
    }

    .input-group {
        width: 300px;
        display: flex;
    }

    .form-control {
        border: 1px solid #ddd;
        padding: 17px 12px;
        border-radius: 4px 0 0 4px;
        font-size: 14px;
    }

    .input-group-btn .btn {
        border-radius: 0 4px 4px 0;
        border: 1px solid #ddd;
        border-left: none;
        padding: 7px 12px;
        background: #f8f9fa;
    }

    .btn-filter {
        border: 1px solid #ddd;
        padding: 8px 16px;
        border-radius: 4px;
        background: #f8f9fa;
        color: #333;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    .table {
        margin: 0;
        width: 100%;
        border-collapse: collapse;
    }

    .table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
    }

    .table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        border-bottom: 1px solid #f8f9fa;
    }

    .customer-info {
        display: flex;
        align-items: center;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
    }

    .customer-details h6 {
        margin: 0;
        color: #0f172a;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .label {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        color: white;
    }

    .action-container {
        position: relative;
    }

    .action-btn {
        color: #6c757d;
        padding: 5px;
        background: none;
        border: none;
    }

    .itemdropdown {
        display: none;
        position: absolute;
        background-color: white;
        box-shadow: 0px 2px 8px rgba(0, 0, 0, 0.2);
        z-index: 10;
        right: 0;
        top: 45px;
        min-width: 160px;
        border-radius: 6px;
        overflow: hidden;
    }

    .itemdropdown a,
    .actions-header {
        padding: 10px 15px;
        display: block;
        text-decoration: none;
        color: #333;
    }

    .actions-header {
        border-bottom: 1px solid #eee;
        font-weight: 600;
    }

    .itemdropdown a:hover {
        background-color: #f1f1f1;
    }

    .itemdropdown a.mark-declined {
        color: red;
    }


    .pagination {
        padding: 20px 25px;
        border-top: 1px solid #f8f9fa;
        display: flex;
        justify-content: flex-end;
        gap: 8px;
        align-items: center;
    }

    .pagination .btn {
        border: 1px solid #ddd;
        padding: 5px 10px;
        background: #f8f9fa;
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-danger {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
    }

    .alert-success {
        background: #d1fae5;
        border: 1px solid #6ee7b7;
        color: #065f46;
    }

    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content.confirmation-modal {
        max-width: 500px;
    }

    .modal-body textarea {
        width: 100%;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        padding: 8px;
        font-size: 14px;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    /* 
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
    } */
    .modal {
        display: none;
        position: fixed;
        z-index: 1050;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal.show {
        display: block;
    }

    .modal-content {
        background-color: white;
        margin: 5% auto;
        padding: 0;
        border-radius: 8px;
        width: 90%;
        max-width: 600px;
        max-height: 90vh;
        overflow-y: auto;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    }

    .modal-header {
        display: flex;
        justify-content: space-between;

        align-items: center;
        /* padding: 20px 24px; */
        /* width: 100%; */
        border-bottom: 1px solid #e5e5e5;
        background-color: #fafafa;
        /* border-radius: 8px 8px 0 0; */
    }

    .modal-header h2 {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .close-btn {
        font-size: 24px;
        font-weight: bold;
        color: #666;
        cursor: pointer;
        padding: 0 5px;
        line-height: 1;
    }

    .close-btn:hover {
        color: #000;
    }

    .modal-body {
        padding: 24px;
    }

    .order-date {
        color: #666;
        font-size: 14px;
        margin-bottom: 24px;
    }

    .section-title {
        font-size: 16px;
        font-weight: 600;
        color: #333;
        margin-bottom: 16px;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
    }

    .info-table.order-details thead th {
        background-color: #f8f9fa;
        padding: 12px 8px;
        font-size: 14px;
        font-weight: 600;
        color: #333;
        border-bottom: 2px solid #e5e5e5;
    }

    .info-table.order-details tbody td {
        padding: 12px 8px;
        font-size: 14px;
        color: #333;
        border-bottom: 1px solid #f0f0f0;
    }

    .info-table.order-details tbody tr:last-child td {
        border-bottom: none;
    }

    .divider {
        height: 1px;
        background-color: #e5e5e5;
        margin: 20px 0;
    }

    .info-table.order-summary td {
        padding: 8px 0;
        font-size: 14px;
        border: none;
    }

    .info-table.order-summary td:first-child {
        color: #333;
        font-weight: 500;
    }

    .info-table.order-summary td:last-child {
        text-align: right;
        color: #333;
        font-weight: 500;
    }

    .info-table.order-summary .total td {
        font-weight: 600;
        font-size: 16px;
        border-top: 1px solid #e5e5e5;
        padding-top: 12px;
    }

    .info-table.order-summary .discount {
        color: #28a745;
    }

    .info-table.customer-info td {
        padding: 8px 0;
        font-size: 14px;
        border: none;
        vertical-align: top;
    }

    .info-table.customer-info td:first-child {
        color: #333;
        font-weight: 500;
        width: 80px;
    }

    .info-table.customer-info td:last-child {
        color: #333;
    }

    @media (max-width: 768px) {
        .modal-content {
            margin: 2% auto;
            width: 95%;
            max-height: 96vh;
        }

        .modal-body {
            padding: 16px;
        }

        .info-table.order-details {
            font-size: 12px;
        }

        .info-table.order-details thead th,
        .info-table.order-details tbody td {
            padding: 8px 4px;
        }
    }

    .btn-primary {
        background: #3b82f6;
        border-color: #3b82f6;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-primary:hover {
        background: #2563eb;
        border-color: #2563eb;
    }

    .btn-secondary {
        background: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-secondary:hover {
        background: #5a6268;
        border-color: #5a6268;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .stat-card {
            margin-bottom: 15px;
            max-width: 100%;
        }

        .input-group {
            width: 100%;
        }

        .table th,
        .table td {
            padding: 10px 15px;
        }

        /* .modal-content {
            width: 95%;
            margin: 30px auto;
        } */
    }

    @media (max-width: 576px) {
        .search-area {
            flex-direction: column;
            align-items: stretch;
        }

        .btn-filter {
            width: 100%;
            justify-content: center;
        }

        .table th,
        .table td {
            font-size: 12px;
        }

        .customer-avatar {
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .info-table td {
            font-size: 12px;
        }

        .mobile-hide {
            display: none
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Dashboard</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span>></span>
            <span class="active">Orders</span>
        </nav>

        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">Create
                    Vendor Account</a>
            </div>
        <?php else: ?>
            <!-- Stats Row -->
            <div class="stats-row">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value">N<?= number_format($vendor_check['total_revenue'] ?? 0, 2) ?></div>
                            <div class="stat-label">Total Revenue</div>
                        </div>
                        <!-- <img src="https://img.icons8.com/color/48/000000/money-bag.png" class="stat-icon"
                            alt="Revenue Icon"> -->
                        <div class="stat-icon">
                            <i class="fa-regular fa-badge-dollar"></i>
                        </div>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?= $vendor_check['total_orders_overall'] ?? 0 ?></div>
                            <div class="stat-label">Total Orders</div>
                        </div>
                        <!-- <img src="https://img.icons8.com/color/48/000000/shopping-cart.png" class="stat-icon"
                            alt="Orders Icon"> -->
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?= htmlspecialchars($vendor_check['top_selling_product'] ?? 'N/A') ?>
                            </div>
                            <div class="stat-label">Best Selling Product</div>
                        </div>
                        <!-- <img src="https://img.icons8.com/color/48/000000/product.png" class="stat-icon" alt="Product Icon"> -->
                    </div>
                </div>
            </div>

            <!-- Search and Filter Area -->
            <div class="search-area">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search orders" id="searchInput" />
                    <span class="input-group-btn">
                        <button class="btn btn-default" type="button">
                            <i class="fa fa-search"></i>
                        </button>
                    </span>
                </div>
                <button class="btn-filter">
                    <i class="fa fa-filter"></i>Filter
                </button>
            </div>

            <!-- Orders Section -->
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Recent Orders</h3>
                        <p class="sales-subtitle">Recent Orders from your Stores</p>
                    </div>
                </div>

                <!-- Orders Table -->
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" /> Name</th>
                                <th class="mobile-hide">Order ID</th>
                                <th>Status</th>
                                <th>Total Price</th>
                                <th class="mobile-hide">Date of Order</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($vendorOrders)): ?>
                                <?php
                                $avatarColors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
                                $statusColors = [
                                    'fulfilled' => '#4caf50',
                                    'pending' => '#ff9800',
                                    'declined' => '#f44336',
                                    'canceled' => '#9c27b0'
                                ];
                                foreach ($vendorOrders as $index => $order):
                                    $avatarColor = $avatarColors[$index % count($avatarColors)];
                                    $status = strtolower($order['status']);
                                    $statusColor = $statusColors[$status] ?? '#607d8b';
                                    $initials = strtoupper(substr($order['customer_name'], 0, 1) . (strpos($order['customer_name'], ' ') !== false ? substr($order['customer_name'], strpos($order['customer_name'], ' ') + 1, 1) : ''));
                                    ?>
                                    <tr data-order-id="<?= htmlspecialchars($order['order_id']) ?>">
                                        <td>
                                            <div style="display: flex; align-items: center">
                                                <input type="checkbox" class="order-checkbox" />
                                                <a href="#" class="view-btn"
                                                    data-order-id="<?= htmlspecialchars($order['order_id']) ?>">
                                                    <div class="customer-info">
                                                        <div class="customer-avatar <?= $avatarColor ?>"><?= $initials ?></div>
                                                        <div class="customer-details">
                                                            <h6><?= htmlspecialchars($order['customer_name']) ?></h6>
                                                            <p><?= htmlspecialchars($order['customer_email']) ?></p>
                                                        </div>
                                                    </div>
                                                </a>

                                            </div>
                                        </td>
                                        <td class="mobile-hide">#<?= htmlspecialchars($order['order_id']) ?></td>
                                        <td>
                                            <span class="label" style="background: <?= $statusColor ?>;">
                                                <?= ucfirst(htmlspecialchars($status)) ?>
                                            </span>
                                        </td>
                                        <td>N<?= number_format($order['total_amount'], 2) ?></td>
                                        <td class="mobile-hide"><?= date('Y-m-d H:i', strtotime($order['created_at'])) ?></td>
                                        <td>
                                            <div class="action-container">
                                                <button class="action-btn">
                                                    <i class="fa fa-ellipsis-h"></i>
                                                </button>
                                                <div class="itemdropdown">
                                                    <p class="actions-header">Actions</p>
                                                    <a href="#" class="view-btn"
                                                        data-order-id="<?= htmlspecialchars($order['order_id']) ?>">View</a>
                                                    <?php if ($status !== 'fulfilled'): ?>
                                                        <a href="#" class="mark-fulfilled" data-status="fulfilled"
                                                            data-order-id="<?= htmlspecialchars($order['order_id']) ?>">Mark as
                                                            Fulfilled</a>
                                                    <?php endif; ?>
                                                    <?php if ($status !== 'declined' && $status !== 'canceled' && $status != "fulfilled"): ?>
                                                        <a href="#" class="mark-declined" data-status="declined"
                                                            data-order-id="<?= htmlspecialchars($order['order_id']) ?>">Mark as
                                                            Declined</a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" style="text-align: center; color: #777;">No orders found for this vendor.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="pagination">
                    <div style="color: #6c757d; font-size: 14px">Page 1 of 10</div>
                    <div>
                        <button class="btn btn-default btn-sm"><i class="fa fa-angle-double-left"></i></button>
                        <button class="btn btn-default btn-sm"><i class="fa fa-angle-left"></i></button>
                        <button class="btn btn-default btn-sm"><i class="fa fa-angle-right"></i></button>
                        <button class="btn btn-default btn-sm"><i class="fa fa-angle-double-right"></i></button>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Order Details Modal -->

<div id="orderModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Order <span class="order-id"></span></h2>
            <span class="close-btn" id="closeModal">&times;</span>
        </div>
        <div class="modal-body">
            <div class="order-date"><strong>Date:</strong> <span></span></div>

            <div class="section-title">Order Details</div>
            <table class="info-table order-details">
                <thead>
                    <tr>
                        <th style="text-align: left;">Product</th>
                        <th style="text-align: center;">SKU</th>
                        <th style="text-align: center;">Qty</th>
                        <th style="text-align: right;">Unit Price</th>
                        <th style="text-align: right;">Line Total</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>

            <div class="divider"></div>

            <table class="info-table order-summary">
                <tr>
                    <td>Subtotal:</td>
                    <td class="subtotal"></td>
                </tr>
                <tr>
                    <td>Shipping:</td>
                    <td class="shipping"></td>
                </tr>
                <tr>
                    <td>Tax:</td>
                    <td class="tax"></td>
                </tr>
                <tr class="discount" style="display: none;">
                    <td>Discount:</td>
                    <td class="discount-amount"></td>
                </tr>
                <tr class="total">
                    <td>Total:</td>
                    <td class="total-amount"></td>
                </tr>
                <tr>
                    <td>Status:</td>
                    <td class="order-status"></td>
                </tr>
            </table>

            <div class="divider"></div>

            <div class="section-title">Customer Information</div>
            <table class="info-table customer-info">
                <tr>
                    <td>Customer:</td>
                    <td class="customer-name"></td>
                </tr>
                <tr>
                    <td>Email:</td>
                    <td class="customer-email"></td>
                </tr>
                <tr>
                    <td>Phone:</td>
                    <td class="customer-phone"></td>
                </tr>
                <tr>
                    <td>Address:</td>
                    <td class="customer-address"></td>
                </tr>
            </table>
        </div>
    </div>
</div>


<!-- Status Confirmation Modal -->
<div class="modal" id="statusModal">
    <div class="modal-content confirmation-modal">
        <div class="modal-header">
            <span id="statusModalTitle"></span>
            <span class="close-btn" onclick="hideStatusModal()">&times;</span>
        </div>
        <div class="modal-body">
            <p id="statusModalMessage"></p>
            <div class="form-group" id="reasonGroup" style="display: none;">
                <label style="font-weight: 500; color: #374151;">Reason for Declining</label>
                <textarea class="form-control" id="declineReason" rows="4"
                    placeholder="Provide a reason for declining this order"></textarea>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" onclick="hideStatusModal()">Cancel</button>
            <button type="button" class="btn btn-primary" id="confirmStatusBtn">Confirm</button>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'dashboard' ? 'vendor_dashboard.php' : '#';
    }

    // Search functionality
    $('#searchInput').on("keyup", function () {
        var searchTerm = $(this).val().toLowerCase();
        $("tbody tr").each(function () {
            var customerName = $(this).find(".customer-details h6").text().toLowerCase();
            var orderId = $(this).find("td:nth-child(2)").text().toLowerCase();
            if (customerName.indexOf(searchTerm) === -1 && orderId.indexOf(searchTerm) === -1) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
    });

    // Filter button functionality
    $('.btn-filter').click(function () {
        alert("Filter Orders - This would show filter options");
    });

    // Checkbox functionality
    $('#selectAll').change(function () {
        var isChecked = $(this).is(":checked");
        $('.order-checkbox').prop("checked", isChecked);
    });

    // Modal and dropdown functionality
    const orderModal = document.getElementById("orderModal");
    const closeModal = document.getElementById("closeModal");

    closeModal.addEventListener("click", () => {
        orderModal.style.display = "none";
    });

    window.addEventListener("click", (event) => {
        if (event.target === orderModal) {
            orderModal.style.display = "none";
        }
    });

    document.querySelectorAll(".action-btn").forEach((button) => {
        button.addEventListener("click", (e) => {
            e.preventDefault();
            const itemdropdown = button.closest(".action-container").querySelector(".itemdropdown");
            document.querySelectorAll(".itemdropdown").forEach((d) => {
                if (d !== itemdropdown) d.style.display = "none";
            });
            itemdropdown.style.display = itemdropdown.style.display === "block" ? "none" : "block";
        });
    });

    window.addEventListener("click", (event) => {
        if (!event.target.closest(".action-container")) {
            document.querySelectorAll(".itemdropdown").forEach((itemdropdown) => {
                itemdropdown.style.display = "none";
            });
        }
    });

    // View order details
    document.querySelectorAll(".view-btn").forEach((viewBtn) => {
        viewBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const row = viewBtn.closest("tr");
            const orderId = row.dataset.orderId;
            const customerName = row.querySelector(".customer-details h6").textContent;
            const customerEmail = row.querySelector(".customer-details p").textContent;
            const orderDate = row.querySelector("td:nth-child(5)").textContent;

            $.ajax({
                type: "GET",
                url: "ajax/get_order_details.php",
                data: { order_id: orderId },
                dataType: "json",
                success: function (data) {
                    if (data.success) {
                        document.querySelector(".order-id").textContent = orderId;
                        document.querySelector(".order-date span").textContent = data.created_at;
                        document.querySelector(".order-details tbody").innerHTML = data.items.map(item => `
              <tr>
                <td>${item.name}</td>
                <td style="text-align: center;">${item.sku || 'N/A'}</td>
                <td style="text-align: center;">${item.quantity}</td>
                <td style="text-align: right;">N${parseFloat(item.price).toFixed(2)}</td>
                <td style="text-align: right;">N${parseFloat(item.line_total).toFixed(2)}</td>
              </tr>
            `).join('');
                        document.querySelector(".subtotal").textContent = `N${parseFloat(data.subtotal).toFixed(2)}`;
                        document.querySelector(".shipping").textContent = `N${parseFloat(data.shipping).toFixed(2)}`;
                        document.querySelector(".tax").textContent = `N${parseFloat(data.tax).toFixed(2)}`;
                        document.querySelector(".discount").style.display = data.discount > 0 ? "table-row" : "none";
                        document.querySelector(".discount-amount").textContent = data.discount > 0 ? `-N${parseFloat(data.discount).toFixed(2)}` : '';
                        document.querySelector(".total-amount").textContent = `N${parseFloat(data.total).toFixed(2)}`;
                        document.querySelector(".order-status").textContent = data.status.charAt(0).toUpperCase() + data.status.slice(1);
                        document.querySelector(".customer-name").textContent = data.customer_name;
                        document.querySelector(".customer-email").textContent = data.customer_email;
                        document.querySelector(".customer-phone").textContent = data.customer_phone || 'N/A';
                        document.querySelector(".customer-address").textContent = data.customer_address || 'N/A';
                        orderModal.style.display = "block";
                    } else {
                        showNotification("Failed to load order details: " + data.message, "error");
                    }
                },
                error: function () {
                    showNotification("Error fetching order details. Please try again.", "error");
                }
            });
            viewBtn.closest(".itemdropdown").style.display = "none";
        });
    });

    // Status update modal
    function showStatusModal(orderId, status, orderNumber) {
        const title = status === "fulfilled" ? "Mark Order as Fulfilled" : "Mark Order as Declined";
        const message = status === "fulfilled" ?
            `Are you sure you want to mark order #${orderNumber} as fulfilled?` :
            `Are you sure you want to mark order #${orderNumber} as declined? Please provide a reason.`;
        document.getElementById("statusModalTitle").textContent = title;
        document.getElementById("statusModalMessage").textContent = message;
        document.getElementById("reasonGroup").style.display = status === "declined" ? "block" : "none";
        document.getElementById("declineReason").value = "";
        document.getElementById("confirmStatusBtn").dataset.orderId = orderId;
        document.getElementById("confirmStatusBtn").dataset.status = status;
        $('#statusModal').modal('show');
    }

    function hideStatusModal() {
        $('#statusModal').modal('hide');
    }

    // Status update functionality
    document.querySelectorAll(".mark-fulfilled, .mark-declined").forEach((actionBtn) => {
        actionBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const orderId = actionBtn.dataset.orderId;
            const status = actionBtn.dataset.status;
            const orderNumber = actionBtn.closest("tr").querySelector("td:nth-child(2)").textContent.replace("#", "");
            showStatusModal(orderId, status, orderNumber);
            actionBtn.closest(".itemdropdown").style.display = "none";
        });
    });

    // Confirm status update
    document.getElementById("confirmStatusBtn").addEventListener("click", () => {
        const orderId = document.getElementById("confirmStatusBtn").dataset.orderId;
        const status = document.getElementById("confirmStatusBtn").dataset.status;
        const reason = status === "declined" ? document.getElementById("declineReason").value.trim() : "";

        if (status === "declined" && !reason) {
            showNotification("Please provide a reason for declining the order.", "error");
            return;
        }

        const btn = document.getElementById("confirmStatusBtn");
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
        btn.disabled = true;

        $.ajax({
            type: "POST",
            url: "ajax/vendor_order_status.php",
            data: { order_id: orderId, status: status, reason: reason },
            dataType: "json",
            success: function (data) {
                if (data.success) {
                    showNotification(`Order marked as ${status.charAt(0).toUpperCase() + status.slice(1)}`, "success");
                    const row = document.querySelector(`tr[data-order-id="${orderId}"]`);
                    const statusSpan = row.querySelector(".label");
                    const bgColor = status === "fulfilled" ? "#4caf50" : "#f44336";
                    statusSpan.textContent = status.charAt(0).toUpperCase() + status.slice(1);
                    statusSpan.style.background = bgColor;

                    // Update dropdown options
                    const dropdown = row.querySelector(".itemdropdown");
                    dropdown.innerHTML = `
            <p class="actions-header">Actions</p>
            <a href="#" class="view-btn" data-order-id="${orderId}">View</a>
            ${status !== "fulfilled" ? `<a href="#" class="mark-fulfilled" data-status="fulfilled" data-order-id="${orderId}">Mark as Fulfilled</a>` : ""}
            ${status !== "declined" && status !== "canceled" ? `<a href="#" class="mark-declined" data-status="declined" data-order-id="${orderId}">Mark as Declined</a>` : ""}
          `;
                    hideStatusModal();
                } else {
                    showNotification(`Failed to update status: ${data.message}`, "error");
                }
                btn.innerHTML = originalText;
                btn.disabled = false;
            },
            error: function () {
                showNotification("Error updating order status. Please try again.", "error");
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        });
    });

    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'}`;
        notification.innerHTML = `
      <button type="button" class="close" onclick="this.parentElement.remove()">
        <span>&times;</span>
      </button>
      <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
    `;
        document.body.appendChild(notification);
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    // Table row hover effects
    $("tbody tr").hover(
        function () {
            $(this).css("background-color", "#f8f9fa");
        },
        function () {
            $(this).css("background-color", "white");
        }
    );

    // Initialize tooltips
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>