<?php
$page = "Orders";
$page_url = "vendor_orders";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
//$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));

// Handle AJAX status update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['status'])) {
    header('Content-Type: application/json');
    $orderId = $_POST['order_id'];
    $newStatus = $_POST['status'];
    $reason = isset($_POST['reason']) ? trim($_POST['reason']) : '';
    $updated = $dashboard->updateOrderStatus($orderId, $newStatus, $reason);
    if ($updated) {
        echo json_encode(['success' => true, 'message' => "Order status updated to $newStatus."]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update status.']);
    }
    exit();
}
?>

<!-- Include DataTables and Bootstrap Datepicker CSS/JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

<style>
    /* Retain provided CSS with DataTables-specific adjustments */
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 5px 0 10px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb span {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb .active {
        color: #333;
        font-size: 14px;
    }

    .stats-row {
        margin-bottom: 30px;
        display: flex;
        gap: 20px;
        flex-wrap: wrap;
    }

    .stat-card {
        background: white;
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        flex: 1;
        min-width: 200px;
        max-width: 300px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .orders-section {
        background: white;
        border-radius: 8px;
        border: 1px solid #e9ecef;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }

    .orders-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .orders-title {
        font-size: 18px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .orders-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .search-filter-bar {
        display: flex;
        justify-content: space-between;
        margin: 20px 0;
        flex-wrap: wrap;
        gap: 10px;
    }

    .search-input {
        flex: 1;
        max-width: 300px;
        position: relative;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .button-filters {
        display: flex;
        gap: 20px;
    }

    .filter-btn,
    .export-btn {
        border: 1px solid #ddd;
        padding: 8px 16px;
        border-radius: 4px;
        background: #f8f9fa;
        color: #333;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
    }

    .filter-btn:hover,
    .export-btn:hover {
        background: #e9ecef;
    }

    .filter-tabs {
        padding: 0 16px;
        background-color: #f1f5f9;
        width: fit-content;
        border-radius: 6px;
        margin-bottom: 16px;
    }

    .filter-tabs ul {
        list-style: none;
        padding: 6px 0;
        margin: 0;
        display: flex;
    }

    .filter-tabs li {
        margin-right: 30px;
    }

    .filter-tabs a {
        display: block;
        border-radius: 6px;
        padding: 8px;
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .filter-tabs a.active {
        background-color: #fff;
    }

    .filter-tabs a:hover {
        text-decoration: none;
        background: #e9ecef;
    }

    .table-container {
        overflow-x: auto;
    }

    .orders-table {
        margin: 0;
        width: 100%;
        border-collapse: collapse;
    }

    .orders-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .orders-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
    }

    .orders-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        border-bottom: 1px solid #f8f9fa;
    }

    .customer-info {
        display: flex;
        align-items: center;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
    }

    .customer-details h6 {
        margin: 0;
        color: #0f172a;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .label {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        color: white;
    }

    .action-container {
        position: relative;
    }

    .action-btn {
        color: #6c757d;
        padding: 5px;
        background: none;
        border: none;
    }

    .itemdropdown {
        display: none;
        position: absolute;
        background-color: white;
        box-shadow: 0px 2px 8px rgba(0, 0, 0, 0.2);
        z-index: 10;
        right: 0;
        top: 45px;
        min-width: 160px;
        border-radius: 6px;
        overflow: hidden;
    }

    .itemdropdown a,
    .actions-header {
        padding: 10px 15px;
        display: block;
        text-decoration: none;
        color: #333;
    }

    .actions-header {
        border-bottom: 1px solid #eee;
        font-weight: 600;
    }

    .itemdropdown a:hover {
        background-color: #f1f1f1;
    }

    .itemdropdown a.mark-declined {
        color: red;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: #f8f9fa;
        border-radius: 4px;
        color: #6c757d;
        margin: 0 2px;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: #e9ecef;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: #1976d2;
        color: white;
        border-color: #1976d2;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .dataTables_info {
        color: #6c757d;
        font-size: 14px;
        padding: 20px 25px;
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-danger {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
    }

    .alert-success {
        background: #d1fae5;
        border: 1px solid #6ee7b7;
        color: #065f46;
    }

    .modal {
        display: none;
        position: fixed;
        z-index: 1050;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal.show {
        display: block;
    }

    .modal-content {
        background-color: white;
        margin: 5% auto;
        padding: 0;
        border-radius: 8px;
        width: 90%;
        max-width: 600px;
        max-height: 90vh;
        overflow-y: auto;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    }

    .modal-content.confirmation-modal {
        max-width: 500px;
    }

    .modal-header {
        display: flex;
        /* justify-content: space-between; */
        align-items: center;
        border-bottom: 1px solid #e5e5e5;
        background-color: #fafafa;
        padding: 20px 24px;
        width: 100%;
    }

    .modal-header h2 {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        flex: 1;
    }

    .close-btn {
        font-size: 24px;
        font-weight: bold;
        color: #666;
        cursor: pointer;
        /* padding: 0 5px; */
        line-height: 1;
    }

    .close-btn:hover {
        color: #000;
    }

    .modal-body {
        padding: 24px;
    }

    .modal-body textarea {
        width: 100%;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        padding: 8px;
        font-size: 14px;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .order-date {
        color: #666;
        font-size: 14px;
        margin-bottom: 24px;
    }

    .section-title {
        font-size: 16px;
        font-weight: 600;
        color: #333;
        margin-bottom: 16px;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
    }

    .info-table.order-details thead th {
        background-color: #f8f9fa;
        padding: 12px 8px;
        font-size: 14px;
        font-weight: 600;
        color: #333;
        border-bottom: 2px solid #e5e5e5;
    }

    .info-table.order-details tbody td {
        padding: 12px 8px;
        font-size: 14px;
        color: #333;
        border-bottom: 1px solid #f0f0f0;
    }

    .info-table.order-details tbody tr:last-child td {
        border-bottom: none;
    }

    .divider {
        height: 1px;
        background-color: #e5e5e5;
        margin: 20px 0;
    }

    .info-table.order-summary td {
        padding: 8px 0;
        font-size: 14px;
        border: none;
    }

    .info-table.order-summary td:first-child {
        color: #333;
        font-weight: 500;
    }

    .info-table.order-summary td:last-child {
        text-align: right;
        color: #333;
        font-weight: 500;
    }

    .info-table.order-summary .total td {
        font-weight: 600;
        font-size: 16px;
        border-top: 1px solid #e5e5e5;
        padding-top: 12px;
    }

    .info-table.order-summary .discount {
        color: #28a745;
    }

    .info-table.customer-info td {
        padding: 8px 0;
        font-size: 14px;
        border: none;
        vertical-align: top;
    }

    .info-table.customer-info td:first-child {
        color: #333;
        font-weight: 500;
        width: 80px;
    }

    .info-table.customer-info td:last-child {
        color: #333;
    }

    .btn-primary {
        background: #3b82f6;
        border-color: #3b82f6;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-primary:hover {
        background: #2563eb;
        border-color: #2563eb;
    }

    .btn-secondary {
        background: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-secondary:hover {
        background: #5a6268;
        border-color: #5a6268;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .stat-card {
            margin-bottom: 15px;
            max-width: 100%;
        }

        .search-filter-bar {
            flex-direction: column;
            align-items: stretch;
            gap: 10px;
        }

        .search-input {
            max-width: none;
        }

        .orders-table th,
        .orders-table td {
            padding: 10px 15px;
        }

        .modal-content {
            margin: 2% auto;
            width: 95%;
            max-height: 96vh;
        }

        .modal-body {
            padding: 16px;
        }

        .info-table.order-details {
            font-size: 12px;
        }

        .info-table.order-details thead th,
        .info-table.order-details tbody td {
            padding: 8px 4px;
        }
    }

    @media (max-width: 576px) {
        .search-filter-bar {
            flex-direction: column;
            align-items: stretch;
        }

        .filter-btn,
        .export-btn {
            width: 100%;
            justify-content: center;
        }

        .orders-table th,
        .orders-table td {
            font-size: 12px;
        }

        .customer-avatar {
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .mobile-hide {
            display: none;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Orders</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span>></span>
            <span class="active">Orders</span>
        </nav>

        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">Create
                    Vendor Account</a>
            </div>
        <?php else: ?>
            <!-- Stats Row -->
            <div class="stats-row">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value">₦<?= number_format($vendor_check['total_revenue'] ?? 0, 2) ?></div>
                            <div class="stat-label">Total Revenue</div>
                        </div>
                        <div class="stat-icon">
                            <i class="fa-regular fa-badge-dollar"></i>
                        </div>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?= $vendor_check['total_orders_overall'] ?? 0 ?></div>
                            <div class="stat-label">Total Orders</div>
                        </div>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value"><?= htmlspecialchars($vendor_check['top_selling_product'] ?? 'N/A') ?>
                            </div>
                            <div class="stat-label">Best Selling Product</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Search and Filter Bar -->
            <div class="search-filter-bar">
                <div class="search-input">
                    <input type="text" class="form-control" placeholder="Search orders" id="orderSearch" />
                    <i class="fa fa-search"></i>
                </div>
                <div class="button-filters">
                    <button class="filter-btn" data-toggle="modal" data-target="#filterModal">
                        <i class="fa fa-filter"></i> Filter
                    </button>
                    <button class="export-btn" onclick="exportOrders()">
                        <i class="fa fa-download"></i> Export
                    </button>
                </div>
            </div>

            <!-- Filter Tabs -->
            <div class="filter-tabs">
                <ul>
                    <li><a href="#" class="active" data-status="all" onclick="filterOrders('all')">All</a></li>
                    <li><a href="#" data-status="fulfilled" onclick="filterOrders('fulfilled')">Fulfilled</a></li>
                    <li><a href="#" data-status="pending" onclick="filterOrders('pending')">Pending</a></li>
                    <li><a href="#" data-status="declined" onclick="filterOrders('declined')">Declined</a></li>
                    <li><a href="#" data-status="canceled" onclick="filterOrders('canceled')">Canceled</a></li>
                </ul>
            </div>

            <!-- Orders Section -->
            <div class="orders-section">
                <div class="orders-header">
                    <div>
                        <h3 class="orders-title">Recent Orders</h3>
                        <p class="orders-subtitle">Recent Orders from your Stores</p>
                    </div>
                </div>

                <!-- Orders Table -->
                <div class="table-container">
                    <table class="orders-table" id="ordersTable">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" onchange="toggleSelectAll()" /> Name</th>
                                <th class="mobile-hide">Order ID</th>
                                <th>Status</th>
                                <th>Total Price</th>
                                <th class="mobile-hide">Date of Order</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="ordersTableBody"></tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Order Details Modal -->
<div id="orderModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Order <span class="order-id"></span></h2>
            <span class="close-btn" id="closeModal">&times;</span>
        </div>
        <div class="modal-body">
            <div class="order-date"><strong>Date:</strong> <span></span></div>
            <div class="section-title">Order Details</div>
            <table class="info-table order-details">
                <thead>
                    <tr>
                        <th style="text-align: left;">Product</th>
                        <th style="text-align: center;">SKU</th>
                        <th style="text-align: center;">Qty</th>
                        <th style="text-align: right;">Unit Price</th>
                        <th style="text-align: right;">Line Total</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            <div class="divider"></div>
            <table class="info-table order-summary">
                <tr>
                    <td>Subtotal:</td>
                    <td class="subtotal"></td>
                </tr>
                <tr>
                    <td>Shipping:</td>
                    <td class="shipping"></td>
                </tr>
                <tr>
                    <td>Tax:</td>
                    <td class="tax"></td>
                </tr>
                <tr class="discount" style="display: none;">
                    <td>Discount:</td>
                    <td class="discount-amount"></td>
                </tr>
                <tr class="total">
                    <td>Total:</td>
                    <td class="total-amount"></td>
                </tr>
                <tr>
                    <td>Status:</td>
                    <td class="order-status"></td>
                </tr>
            </table>
            <div class="divider"></div>
            <div class="section-title">Customer Information</div>
            <table class="info-table customer-info">
                <tr>
                    <td>Customer:</td>
                    <td class="customer-name"></td>
                </tr>
                <tr>
                    <td>Email:</td>
                    <td class="customer-email"></td>
                </tr>
                <tr>
                    <td>Phone:</td>
                    <td class="customer-phone"></td>
                </tr>
                <tr>
                    <td>Address:</td>
                    <td class="customer-address"></td>
                </tr>
            </table>
        </div>
    </div>
</div>

<!-- Status Confirmation Modal -->
<div class="modal" id="statusModal">
    <div class="modal-content confirmation-modal">
        <div class="modal-header">
            <span id="statusModalTitle"></span>
            <span class="close-btn" onclick="hideStatusModal()">&times;</span>
        </div>
        <div class="modal-body">
            <p id="statusModalMessage"></p>
            <div class="form-group" id="reasonGroup" style="display: none;">
                <label style="font-weight: 500; color: #374151;">Reason for Declining</label>
                <textarea class="form-control" id="declineReason" rows="4"
                    placeholder="Provide a reason for declining this order"></textarea>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" onclick="hideStatusModal()">Cancel</button>
            <button type="button" class="btn btn-primary" id="confirmStatusBtn">Confirm</button>
        </div>
    </div>
</div>

<!-- Filter Modal -->
<div class="modal fade" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="filterModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="filterModalLabel">Filter Orders</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="startDate">Start Date</label>
                    <input type="text" class="form-control datepicker" id="startDate" placeholder="YYYY-MM-DD">
                </div>
                <div class="form-group">
                    <label for="endDate">End Date</label>
                    <input type="text" class="form-control datepicker" id="endDate" placeholder="YYYY-MM-DD">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="applyFilters()">Apply Filters</button>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    $(document).ready(function () {
        let currentStatus = 'all';
        let currentStartDate = null;
        let currentEndDate = null;

        // Initialize Datepickers
        $('#startDate, #endDate').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true
        });

        // Initialize DataTables
        const table = $('#ordersTable').DataTable({
            serverSide: true,
            processing: true,
            pageLength: 10,
            lengthChange: false,
            searching: false,
            ordering: true,
            info: true,
            ajax: {
                url: 'ajax/ajax_vendor_orders.php',
                type: 'GET',
                data: function (d) {
                    d.page = Math.floor(d.start / d.length) + 1;
                    d.search = $('#orderSearch').val();
                    d.status = currentStatus;
                    d.startDate = currentStartDate;
                    d.endDate = currentEndDate;
                },
                error: function (xhr, error, thrown) {
                    console.log('DataTables AJAX error:', xhr, error, thrown);
                    showNotification('Failed to load orders. Check the console for details.', 'error');
                }
            },
            columns: [{
                data: 'customer_name',
                orderable: true
            },
            {
                data: 'order_id',
                orderable: true,
                className: 'mobile-hide'
            },
            {
                data: 'status',
                orderable: true
            },
            {
                data: 'total_amount',
                orderable: true
            },
            {
                data: 'created_at',
                orderable: true,
                className: 'mobile-hide'
            },
            {
                data: 'actions',
                orderable: false
            }
            ],
            drawCallback: function () {
                // Reattach event listeners for action buttons
                $('.action-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const itemdropdown = $(this).closest('.action-container').find('.itemdropdown');
                    $('.itemdropdown').not(itemdropdown).hide();
                    itemdropdown.toggle();
                });

                // View order details
                $('.view-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const orderId = $(this).data('order-id');
                    $.ajax({
                        type: "GET",
                        url: "ajax/get_order_details.php",
                        data: {
                            order_id: orderId
                        },
                        dataType: "json",
                        success: function (data) {
                            if (data.success) {
                                document.querySelector(".order-id").textContent = orderId;
                                document.querySelector(".order-date span").textContent = data.created_at;
                                document.querySelector(".order-details tbody").innerHTML = data.items.map(item => `
                                <tr>
                                    <td>${item.name}</td>
                                    <td style="text-align: center;">${item.sku || 'N/A'}</td>
                                    <td style="text-align: center;">${item.quantity}</td>
                                    <td style="text-align: right;">₦${parseFloat(item.price).toFixed(2)}</td>
                                    <td style="text-align: right;">₦${parseFloat(item.line_total).toFixed(2)}</td>
                                </tr>
                            `).join('');
                                document.querySelector(".subtotal").textContent = `₦${parseFloat(data.subtotal).toFixed(2)}`;
                                document.querySelector(".shipping").textContent = `₦${parseFloat(data.shipping).toFixed(2)}`;
                                document.querySelector(".tax").textContent = `₦${parseFloat(data.tax).toFixed(2)}`;
                                document.querySelector(".discount").style.display = data.discount > 0 ? "table-row" : "none";
                                document.querySelector(".discount-amount").textContent = data.discount > 0 ? `-₦${parseFloat(data.discount).toFixed(2)}` : '';
                                document.querySelector(".total-amount").textContent = `₦${parseFloat(data.total).toFixed(2)}`;
                                document.querySelector(".order-status").textContent = data.status.charAt(0).toUpperCase() + data.status.slice(1);
                                document.querySelector(".customer-name").textContent = data.customer_name;
                                document.querySelector(".customer-email").textContent = data.customer_email;
                                document.querySelector(".customer-phone").textContent = data.customer_phone || 'N/A';
                                document.querySelector(".customer-address").textContent = data.customer_address || 'N/A';
                                document.getElementById("orderModal").style.display = "block";
                                $('.itemdropdown').hide(); // Close dropdown on view
                            } else {
                                showNotification("Failed to load order details: " + data.message, "error");
                            }
                        },
                        error: function () {
                            showNotification("Error fetching order details. Please try again.", "error");
                        }
                    });
                });

                // Mark as fulfilled or declined
                $('.mark-fulfilled, .mark-declined').off('click').on('click', function (e) {
                    e.preventDefault();
                    const orderId = $(this).data('order-id');
                    const status = $(this).data('status');
                    const orderNumber = $(this).closest('tr').find('.order-id').text();
                    showStatusModal(orderId, status, orderNumber);
                    $(this).closest('.itemdropdown').hide();
                });
            }
        });

        // Custom search
        $('#orderSearch').on('input', function () {
            table.ajax.reload();
        });

        // Filter by status
        window.filterOrders = function (status) {
            $('.filter-tabs a').removeClass('active');
            $(`.filter-tabs a[data-status="${status}"]`).addClass('active');
            currentStatus = status;
            table.ajax.reload();
        };

        // Apply date filters
        window.applyFilters = function () {
            currentStartDate = $('#startDate').val();
            currentEndDate = $('#endDate').val();
            $('#filterModal').modal('hide');
            table.ajax.reload();
        };

        // Toggle select all checkboxes
        window.toggleSelectAll = function () {
            const selectAllCheckbox = $('#selectAll')[0];
            const orderCheckboxes = $('.order-checkbox');
            orderCheckboxes.prop('checked', selectAllCheckbox.checked);
        };

        // Export orders
        window.exportOrders = function () {
            $.ajax({
                url: 'ajax/ajax_vendor_orders.php',
                type: 'GET',
                data: {
                    action: 'export',
                    search: $('#orderSearch').val(),
                    status: currentStatus,
                    startDate: currentStartDate,
                    endDate: currentEndDate
                },
                success: function (response) {
                    const data = response.data;
                    let csvContent = 'Customer Name,Customer Email,Order ID,Status,Total Price,Date of Order\n';
                    data.forEach(row => {
                        const cleanPrice = row.total_amount.replace(/[^\d.,]/g, '');
                        csvContent += `"${row.customer_name}","${row.customer_email}","${row.order_id}","${row.status}","${cleanPrice}","${row.created_at}"\n`;
                    });
                    const blob = new Blob([csvContent], {
                        type: 'text/csv;charset=utf-8;'
                    });
                    const link = document.createElement('a');
                    link.href = URL.createObjectURL(blob);
                    link.download = 'orders.csv';
                    link.click();
                },
                error: function () {
                    showNotification('Failed to export orders. Please try again.', 'error');
                }
            });
        };

        // Order details modal
        const orderModal = document.getElementById("orderModal");
        const closeModal = document.getElementById("closeModal");

        closeModal.addEventListener("click", () => {
            orderModal.style.display = "none";
        });

        window.addEventListener("click", (event) => {
            if (event.target === orderModal) {
                orderModal.style.display = "none";
            }
        });

        // Close dropdowns when clicking outside
        $(document).on('click', function (e) {
            if (!$(e.target).closest('.action-container').length) {
                $('.itemdropdown').hide();
            }
        });

        // Status update modal
        window.showStatusModal = function (orderId, status, orderNumber) {
            const title = status === "fulfilled" ? "Mark Order as Fulfilled" : "Mark Order as Declined";
            const message = status === "fulfilled" ?
                `Are you sure you want to mark order #${orderNumber} as fulfilled?` :
                `Are you sure you want to mark order #${orderNumber} as declined? Please provide a reason.`;
            document.getElementById("statusModalTitle").textContent = title;
            document.getElementById("statusModalMessage").textContent = message;
            document.getElementById("reasonGroup").style.display = status === "declined" ? "block" : "none";
            document.getElementById("declineReason").value = "";
            document.getElementById("confirmStatusBtn").dataset.orderId = orderId;
            document.getElementById("confirmStatusBtn").dataset.status = status;
            $('#statusModal').modal('show');
        };

        window.hideStatusModal = function () {
            $('#statusModal').modal('hide');
        };

        // Confirm status update
        $('#confirmStatusBtn').on('click', function () {
            const orderId = this.dataset.orderId;
            const status = this.dataset.status;
            const reason = status === "declined" ? document.getElementById("declineReason").value.trim() : "";

            if (status === "declined" && !reason) {
                showNotification("Please provide a reason for declining the order.", "error");
                return;
            }

            const btn = this;
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
            btn.disabled = true;

            $.ajax({
                type: "POST",
                url: "ajax/vendor_order_status.php",
                data: {
                    order_id: orderId,
                    status: status,
                    reason: reason
                },
                dataType: "json",
                success: function (data) {
                    if (data.success) {
                        showNotification(`Order marked as ${status.charAt(0).toUpperCase() + status.slice(1)}`, "success");
                        table.ajax.reload(); // Reload table to reflect status change
                    } else {
                        showNotification(`Failed to update status: ${data.message}`, "error");
                    }
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                    hideStatusModal();
                },
                error: function () {
                    showNotification("Error updating order status. Please try again.", "error");
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                }
            });
        });

        // Notification system
        window.showNotification = function (message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'}`;
            notification.innerHTML = `
            <button type="button" class="close" onclick="this.parentElement.remove()">
                <span>&times;</span>
            </button>
            <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
        `;
            document.body.appendChild(notification);
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        };

        // Initialize page
        console.log('Orders Dashboard initialized');
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        }

        $(window).on('resize', function () {
            if (window.innerWidth <= 768) {
                document.body.classList.add('mobile-view');
            } else {
                document.body.classList.remove('mobile-view');
            }
        });

        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>