<?php
$page = "Vendor Detail Dashboard";
$page_url = "vendor_detail";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'dasha';
    </script>
    <?php
    exit();
endif;

if (!isset($_GET['id'])):
    ?>
    <script>
        window.location.href = 'vendors';
    </script>
    <?php
    exit();
endif;

$vendorId = base64_decode(urldecode($_GET['id']));
if (!is_numeric($vendorId)):
    ?>
    <script>
        window.location.href = 'vendors';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

$vendor = $dashboard->getVendorDetails($vendorId);
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_status'])) {
    $newStatus = $_POST['new_status'];
    $reason = $_POST['decline_reason'] ?? '';
    $updated = $dashboard->updateVendorStatus($vendorId, $newStatus);
    if ($updated) {
        $vendor = $dashboard->getVendorDetails($vendorId); // Refresh vendor info
    }
}
?>

<style>
    .main-content {
        margin-left: 250px;
        margin-top: 70px;
        padding: 30px;
        background-color: white;
        min-height: 100vh;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
    }

    .btn-approve {
        background-color: #2c5aa0;
        border-color: #2c5aa0;
        color: white;
        padding: 8px 20px;
        font-weight: 500;
        border-radius: 4px;
        border: none;
        cursor: pointer;
    }

    .btn-decline,
    .btn-restrict {
        background-color: #dc3545;
        border-color: #dc3545;
        color: white;
        padding: 8px 20px;
        font-weight: 500;
        border-radius: 4px;
        border: none;
        cursor: pointer;
    }

    .btn-disabled {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 20px;
        font-weight: 500;
        border-radius: 4px;
        cursor: not-allowed;
        opacity: 0.65;
    }

    .info-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        margin-bottom: 25px;
        overflow: hidden;
    }

    .card-header {
        background-color: #f8f9fa;
        display: flex;
        justify-content: space-between;
        padding: 15px 20px;
        border-bottom: 1px solid #e9ecef;
        font-weight: 600;
        color: #333;
    }

    .card-body {
        padding: 20px;
    }

    .form-row {
        display: flex;
        margin-bottom: 15px;
        align-items: center;
        justify-content: space-between;
    }

    .form-label {
        width: 180px;
        color: #666;
        font-weight: 500;
        margin-bottom: 0;
    }

    .form-value {
        flex: 1;
        color: #333;
        font-weight: 400;
        word-break: break-word;
    }

    .view-link {
        color: #2c5aa0;
        text-decoration: none;
        font-weight: 500;
    }

    .view-link:hover {
        text-decoration: underline;
    }

    .date-badge {
        font-size: 12px;
        font-weight: normal;
        color: #6c757d;
    }

    .action-btn {
        background: white;
        border: none;
        color: #666;
        padding: 0 15px;
        border-radius: 4px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        font-size: 16px;
        height: 35px;
    }

    .status {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 0.9em;
        font-weight: bold;
        color: white;
    }

    .status.active {
        background-color: #28a745;
    }

    .status.pending,
    .status.declined,
    .status.restricted {
        background-color: #dc3545;
    }

    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
        border-bottom: 1px solid #e9ecef;
        padding: 20px;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .modal-body {
        padding: 20px;
    }

    .modal-body p {
        color: #666;
        margin-bottom: 20px;
        line-height: 1.5;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .form-control {
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 10px 12px;
        width: 100%;
        resize: vertical;
        min-height: 80px;
    }

    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .alert {
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-dismissible .close {
        position: absolute;
        top: 0;
        right: 10px;
        padding: 10px;
        color: inherit;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
            padding: 15px;
        }

        .content-area {
            padding: 0 15px 15px;
        }

        .page-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .form-row {
            flex-direction: column;
            align-items: flex-start;
            gap: 5px;
        }

        .form-label {
            width: 100%;
        }

        .form-value {
            width: 100%;
        }
    }

    @media (max-width: 576px) {
        .action-buttons {
            flex-direction: column;
            gap: 10px;
            width: 100%;
        }

        .btn-approve,
        .btn-decline,
        .btn-restrict,
        .btn-disabled {
            width: 100%;
            text-align: center;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Vendor Details</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span class="breadcrumb-separator">></span>
            <a href="#" onclick="navigateTo('vendors')">Vendors</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current">Vendor Details</span>
        </nav>

        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title"><?= htmlspecialchars($vendor->business_name) ?></h1>
            <div class="action-buttons">
                <?php
                $status = strtolower($vendor->status);
                if ($status === 'pending'):
                    ?>
                    <button class="btn-approve" onclick="updateVendorStatus(<?= $vendorId ?>, 'active')">Approve</button>
                    <button class="btn-decline" onclick="showDeclineModal()">Decline</button>
                <?php elseif ($status === 'active'): ?>
                    <button class="btn-restrict" onclick="showRestrictModal()">Restrict</button>
                    <button class="btn-disabled" disabled>Active</button>
                <?php elseif ($status === 'declined'): ?>
                    <button class="btn-approve" onclick="updateVendorStatus(<?= $vendorId ?>, 'active')">Approve</button>
                    <button class="btn-disabled" disabled>Restrict</button>
                <?php elseif ($status === 'restricted'): ?>
                    <button class="btn-approve" onclick="updateVendorStatus(<?= $vendorId ?>, 'active')">Unrestrict</button>
                <?php else: ?>
                    <p>Status change options not available.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="row">
            <!-- Left Column -->
            <div class="col-md-6">
                <!-- Vendor Information -->
                <div class="info-card">
                    <div class="card-header">
                        <div>
                            <p>Vendor Information</p>
                            <p class="date-badge">Date:
                                <?= htmlspecialchars(date('F j, Y', strtotime($vendor->created_at))) ?>
                            </p>
                        </div>
                        <button class="action-btn">
                            <i class="fa fa-ellipsis-v"></i>
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-label">Vendor/Store Name</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->business_name) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Contact Name</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->name) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Email</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->email) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Business Type</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->type ?: 'N/A') ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Business Address</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->address ?: 'N/A') ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Location</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->location ?: 'N/A') ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Status</div>
                            <div class="form-value">
                                <span class="status <?= $status === 'active' ? 'active' : 'inactive' ?>"
                                    id="vendor-status">
                                    <?= htmlspecialchars(ucfirst($vendor->status)) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bank Information -->
                <div class="info-card">
                    <div class="card-header">
                        <div>
                            <p>Bank Information</p>
                            <p class="date-badge">Date:
                                <?= htmlspecialchars(date('F j, Y', strtotime($vendor->updated_at))) ?>
                            </p>
                        </div>
                        <button class="action-btn">
                            <i class="fa fa-ellipsis-v"></i>
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-label">Bank Account</div>
                            <div class="form-value"><?= htmlspecialchars($vendor->bank_account ?: 'N/A') ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Bank Name</div>
                            <div class="form-value">N/A</div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Account Name</div>
                            <div class="form-value">N/A</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="col-md-6">
                <!-- Business Verification Details -->
                <div class="info-card">
                    <div class="card-header">
                        <div>
                            <p>Business Verification Details</p>
                            <p class="date-badge">Date:
                                <?= htmlspecialchars(date('F j, Y', strtotime($vendor->updated_at))) ?>
                            </p>
                        </div>
                        <button class="action-btn">
                            <i class="fa fa-ellipsis-v"></i>
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-label">Business Info</div>
                            <div class="form-value"><?= nl2br(htmlspecialchars($vendor->business_info ?: 'N/A')) ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">CAC Certificate</div>
                            <div class="form-value">
                                <a href="#" class="view-link">View</a>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Tax ID (TIN)</div>
                            <div class="form-value">
                                <a href="#" class="view-link">View</a>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">ID Document</div>
                            <div class="form-value">
                                <a href="#" class="view-link">View</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Decline/Restrict Modal -->
<div class="modal fade" id="actionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modalTitle">Are you absolutely sure?</h4>
            </div>
            <div class="modal-body">
                <p id="modalMessage"></p>
                <div class="form-group">
                    <label for="actionReason" class="sr-only">Reason</label>
                    <textarea class="form-control" id="actionReason" placeholder="Provide reason for this action"
                        rows="4"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="hideActionModal()">Cancel</button>
                <button type="button" class="btn btn-decline" id="confirmActionBtn">Confirm</button>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'dashboard' ? 'dasha' : page === 'vendors' ? 'vendors' : '#';
    }

    // Modal functions
    function showDeclineModal() {
        document.getElementById('modalTitle').textContent = 'Decline Vendor';
        document.getElementById('modalMessage').innerHTML = `This action will notify ${<?= json_encode(htmlspecialchars($vendor->business_name)) ?>} that their request to use the Marketplace has been declined. Please provide a reason for declining this request.`;
        document.getElementById('confirmActionBtn').dataset.action = 'declined';
        document.getElementById('confirmActionBtn').textContent = 'Yes, decline vendor';
        $('#actionModal').modal('show');
    }

    function showRestrictModal() {
        document.getElementById('modalTitle').textContent = 'Restrict Vendor';
        document.getElementById('modalMessage').innerHTML = `This action will restrict ${<?= json_encode(htmlspecialchars($vendor->business_name)) ?>}'s access to the Marketplace. Please provide a reason for restricting this vendor.`;
        document.getElementById('confirmActionBtn').dataset.action = 'restricted';
        document.getElementById('confirmActionBtn').textContent = 'Yes, restrict vendor';
        $('#actionModal').modal('show');
    }

    function hideActionModal() {
        $('#actionModal').modal('hide');
        document.getElementById('actionReason').value = '';
    }

    function updateVendorStatus(vendorId, status, reason = '') {
        const btn = event ? event.target : document.getElementById('confirmActionBtn');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
        btn.disabled = true;

        $.ajax({
            type: 'POST',
            url: 'ajax/update_vendor_status.php',
            data: { vendor_id: vendorId, new_status: status, decline_reason: reason },
            dataType: 'json',
            success: function (data) {
                if (data.success) {
                    showNotification(`Vendor status updated to ${status}!`, 'success');
                    // Update status display in UI
                    const statusSpan = document.getElementById('vendor-status');
                    statusSpan.textContent = status.charAt(0).toUpperCase() + status.slice(1);
                    statusSpan.className = `status ${status === 'active' ? 'active' : 'inactive'}`;
                    // Update action buttons
                    updateActionButtons(status);
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                    hideActionModal();
                } else {
                    showNotification(`Failed to update status: ${data.message}`, 'error');
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                }
            },
            error: function () {
                showNotification('Error updating vendor status. Please try again.', 'error');
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        });
    }

    // Update action buttons based on status
    function updateActionButtons(status) {
        const actionButtons = document.querySelector('.action-buttons');
        let html = '';
        if (status === 'pending') {
            html = `
                <button class="btn-approve" onclick="updateVendorStatus(${<?= $vendorId ?>}, 'active')">Approve</button>
                <button class="btn-decline" onclick="showDeclineModal()">Decline</button>
            `;
        } else if (status === 'active') {
            html = `
                <button class="btn-restrict" onclick="showRestrictModal()">Restrict</button>
                <button class="btn-disabled" disabled>Active</button>
            `;
        } else if (status === 'declined') {
            html = `
                <button class="btn-approve" onclick="updateVendorStatus(${<?= $vendorId ?>}, 'active')">Approve</button>
                <button class="btn-disabled" disabled>Restrict</button>
            `;
        } else if (status === 'restricted') {
            html = `
                <button class="btn-approve" onclick="updateVendorStatus(${<?= $vendorId ?>}, 'active')">Unrestrict</button>
            `;
        } else {
            html = '<p>Status change options not available.</p>';
        }
        actionButtons.innerHTML = html;
    }

    // Confirm action (Decline/Restrict)
    document.getElementById('confirmActionBtn').addEventListener('click', function () {
        const reason = document.getElementById('actionReason').value.trim();
        const action = this.dataset.action;

        if (!reason && (action === 'declined' || action === 'restricted')) {
            alert(`Please provide a reason for ${action === 'declined' ? 'declining' : 'restricting'} this vendor.`);
            return;
        }

        updateVendorStatus(<?= $vendorId ?>, action, reason);
    });

    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible`;
        notification.style.cssText = `
            position: fixed;
            top: 90px;
            right: 20px;
            z-index: 9999;
            min-width: 300px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        `;
        notification.innerHTML = `
            <button type="button" class="close" onclick="this.parentElement.remove()">
                <span>&times;</span>
            </button>
            <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
        `;
        document.body.appendChild(notification);
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    // Initialize page
    document.addEventListener('DOMContentLoaded', function () {
        console.log('Vendor Management System initialized');
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        }
    });

    // Handle responsive behavior
    window.addEventListener('resize', function () {
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        } else {
            document.body.classList.remove('mobile-view');
        }
    });

    // Initialize Bootstrap tooltips
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>