<?PHP 
$page = "My Tickets";
$page_url="tickets";
include_once 'includes/header.php'; 
include_once 'includes/sidemenu.php'; 
    
if ( isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201) ) : 
?>   
   <script> window.location.href = 'dasha'; </script>
<?PHP
    exit;
endif;

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);
$tck = new Tickets($db, $ad);
$username = $_SESSION[$sid.'username'];
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        My Tickets
        <small>online support tickets.</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Tickets</li>
      </ol>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> My Tickets</h3>
                </div>
                <div class="box-body">
                    
                  <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">
                      <li class="active"><a href="#myTickets" data-toggle="tab">My Tickets</a></li>
                      <li><a href="#newTicket" data-toggle="tab">Create New Tickets</a></li>               
                    </ul>
                    <div class="tab-content">
                      <div class="tab-pane active" id="myTickets">
                          <h3>My Tickets
                                <small>list of my support tickets</small>
                            </h3>
                            <p>To contact one of our representatives, please use this section to open a support ticket.</p> 

                            <p><strong>Important:</strong> The table below contains your most recent tickets and shows their subject. 
            Please write your comments regarding a certain issue in one ticket only. 
            This way we can easily manage our correspondence. Thank you! </p>

<p>To continue the communication in a previously opened ticket, simply click on the ticket number or subject in the table below.</p>

                <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                    <thead>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?PHP 
                        $mytcks = $tck->getTicketList($username);
                        if (isset($mytcks)):
                            $cter = 0;
                            foreach ($mytcks as $key => $mytck) :
                            /*
                             * $ret[$row->TCK_ID] = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME];
                             */
                                preg_match("/(?:\w+(?:\W+|$)){0,20}/", $mytck["CONTENT"], $phrase);
                                if ($mytck["STATUS"] == "Needs Assistance"):
                                    $lblcolor = "label-info";
                                elseif ($mytck["STATUS"] == "Assistance Received"):
                                    $lblcolor = "label-success";
                                elseif ($mytck["STATUS"] == "Closed"):
                                    $lblcolor = "label-warning";
                                endif;
                                $rand = new Password_Generator();
                                $coded = base64_encode($mytck["TICKETID"]);
                                $coded = $rand->generate(50, 50, TRUE, TRUE, TRUE) . $coded . $coded . $coded;
                        ?>
                        <tr style="font-size:0.7em;">
                            <!--<td><?PHP echo ++$cter; ?></td>-->
                            <td class='center' style='text-align: center !important;'><a href="vtick/<?PHP echo $coded; ?>"><?PHP echo $mytck["TICKETID"]; ?></a></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo date("d M, Y H:i:s a", strtotime($mytck["DATE_CREATED"])); ?></td>
                            <td><?PHP echo $mytck["DEPT"]; ?></td>
                            <td><a href="vtick/<?PHP echo $coded; ?>"><?PHP echo "<strong>".$mytck["TITLE"]."</strong><br/>{$phrase[0]} ..."; ?></a></td>
                            <td class='center' style='text-align: center !important;font-size:1.3em !important;'><span class="label-default label <?PHP echo $lblcolor; ?>"><?PHP echo $mytck["STATUS"]; ?></span></td>
                            <td class='center' style='text-align: center !important;'></td>
                        </tr>
                        <?PHP
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                    
                </table>
                      </div>
                      <!-- /.tab-pane -->
                      
                      <div class="tab-pane" id="newTicket">
                          <h3>New Tickets
                                <small>raise a fresh support tickets</small>
                            </h3>
                            <p>To serve you better and ensure prompt response to issues raised, kindly ensure that tickets are only created once for a particular issue.</p>

                            <p>To continue the communication in a previously opened ticket, simply click on the ticket number or subject in the table below.</p>
                            
                        <form role="form" enctype="multipart/form-data" class="form-horizontal" data-toggle="validator" id="tck_form" name="tck_form" action="" method="post">
                        <fieldset>
                            <input type="hidden" name="user" id="user" value="<?PHP echo $_SESSION[$sid.'username']; ?>" />
                            <input type="hidden" name="userid" id="userid" value="<?PHP echo $_SESSION[$sid.'userid']; ?>" />
                                                        
                            <div class="form-group has-feedback col-md-6 ">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-addon">Title: </span>
                                    <input type="text" data-minlength="4" class="form-control" id="title" name="title" placeholder="Ticket Title" required>

                                </div>
                                <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                                <span class="help-block with-errors">Minimum of 4 characters</span>
                            </div>
                            <div class="clearfix"></div>
                            
                            <div class="form-group has-feedback col-md-12 ">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-addon">Details</span>
                                    <!--<input type="text" data-minlength="2" class="form-control" id="title" name="title" placeholder="Ticket Title" required>-->
                                    <textarea class="" rows="10" style="width: 50%;" id="content" name="content" placeholder="Support Ticket Details" required></textarea>
                                </div>
                                <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                                <span class="help-block with-errors">Minimum of 30 characters</span>
                            </div>
                            <div class="clearfix"></div>
                            
                            <div class="form-group col-md-6 ">
                                <div class="input-group input-group-sm">
                                    <!--<span class="input-group-addon">File (if any)</span>-->
                                    <input type="file" class="form-control-file" id="tfiles" name="tfiles" placeholder="File (If any)" >

                                </div>
                                <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                                <span class="help-block with-errors">screenshot or any other file (pdf, png, jpg supported)</span>
                            </div>
                            <div class="clearfix"></div>
                            
                            <div class="form-group has-feedback col-md-6 ">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-addon">Department</span>
                                <select class="form-control" id="deptid" name="deptid" placeholder="Select Ticket Priority" required>
                                    <option value="" selected="">Select Department</option>
                                    <?PHP
                                    $depts = $tck->getDepts();
                                    foreach ($depts as $dept):
                                    ?>
                                    <option value="<?PHP echo $dept["DEPT_ID"]; ?>"><?PHP echo $dept["DEPT"]; ?></option>
                                    <?PHP
                                    endforeach;
                                    ?>
                                </select>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            
                            <div class="form-group has-feedback col-md-6 ">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-addon">Ticket Priority</span>
                                <select class="form-control" id="priority" name="priority" placeholder="Select Ticket Priority" required>
                                    <option value="0">Low Priority</option>
                                    <option value="1" selected="">Normal Priority</option>
                                    <option value="2">Medium Priority</option>
                                    <option value="3">High Priority</option>
                                </select>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            
                            <p class="center col-md-6">
                                <button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-lock green"></i> Submit Ticket</button>
                            </p>
                            
                        </fieldset>
                                
                        </form>
                      </div>
                      <!-- /.tab-pane -->
                      
                    </div>
                    <!-- /.tab-content -->
                      
                  </div>
                  <!-- /.nav-tabs-custom -->
                    
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-12 -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.Main content -->
    
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script type="text/javascript">
   $(document).ready(function () {
       // Show an element and then fade it out with the timeout given
    var fadeInFadeOut = function(jQueryElement, timeout) {
    jQueryElement.fadeIn(1000);
    setTimeout(function() { jQueryElement.fadeOut("slow"); }, timeout);
    };

   var Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(e){var t="";var n,r,i,s,o,u,a;var f=0;e=Base64._utf8_encode(e);while(f<e.length){n=e.charCodeAt(f++);r=e.charCodeAt(f++);i=e.charCodeAt(f++);s=n>>2;o=(n&3)<<4|r>>4;u=(r&15)<<2|i>>6;a=i&63;if(isNaN(r)){u=a=64}else if(isNaN(i)){a=64}t=t+this._keyStr.charAt(s)+this._keyStr.charAt(o)+this._keyStr.charAt(u)+this._keyStr.charAt(a)}return t},decode:function(e){var t="";var n,r,i;var s,o,u,a;var f=0;e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(f<e.length){s=this._keyStr.indexOf(e.charAt(f++));o=this._keyStr.indexOf(e.charAt(f++));u=this._keyStr.indexOf(e.charAt(f++));a=this._keyStr.indexOf(e.charAt(f++));n=s<<2|o>>4;r=(o&15)<<4|u>>2;i=(u&3)<<6|a;t=t+String.fromCharCode(n);if(u!=64){t=t+String.fromCharCode(r)}if(a!=64){t=t+String.fromCharCode(i)}}t=Base64._utf8_decode(t);return t},_utf8_encode:function(e){e=e.replace(/\r\n/g,"\n");var t="";for(var n=0;n<e.length;n++){var r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r)}else if(r>127&&r<2048){t+=String.fromCharCode(r>>6|192);t+=String.fromCharCode(r&63|128)}else{t+=String.fromCharCode(r>>12|224);t+=String.fromCharCode(r>>6&63|128);t+=String.fromCharCode(r&63|128)}}return t},_utf8_decode:function(e){var t="";var n=0;var r=c1=c2=0;while(n<e.length){r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r);n++}else if(r>191&&r<224){c2=e.charCodeAt(n+1);t+=String.fromCharCode((r&31)<<6|c2&63);n+=2}else{c2=e.charCodeAt(n+1);c3=e.charCodeAt(n+2);t+=String.fromCharCode((r&15)<<12|(c2&63)<<6|c3&63);n+=3}}return t}}

    $('#tck_form').validator().on('submit', function (e) { 
        if (e.isDefaultPrevented()) {
          // handle the invalid form...
          //alert("Error");
        } else {
            e.preventDefault();

          // everything looks good!
            var dat = $('#tck_form').serialize(); //alert(dat);
            var p = $('#tck_form').find('select[name="priority"]').val(); //alert(p);
            var formData = new FormData(this);
            if (p != "") {
                $('#myLoading').modal({
                    keyboard: false,
                    show: true,
                    backdrop: "static"
                  });
                myAjaxCall(formData);
//                myAjaxCall(dat);
            } else{
                $('div#errPan').html("Priority cannot be blank!");
                fadeInFadeOut($("div#errPan"), 5000);
            }
        }
    });
    
    var myAjaxCall = function(dat) {
        $.ajax({
            type: "POST",
            url: "ajax/ctickets.php",
            data: dat,
//            dataType: "text",
            cache:false,
            contentType: false,
            processData: false,
            success: function(response){  //alert(response);
                if(response.match(/Success/i)) { //alert(response);
                    //window.location.href = "index.php"; 
                    $('#myLoading').modal("hide");                                   
                    $('div#succPan').html(response);
                    fadeInFadeOut($("div#succPan"), 5000);
                    //$(window.location).attr('href', 'ad_userlist'); 
                    $(window.location).attr('href', $(window.location).attr('href')); 
                 }  else {
                    $('#myLoading').modal("hide");
                    $('div#errPan').html(response);
                    alert(response);
                    fadeInFadeOut($("div#errPan"), 5000);
                 }
            },
            error: function(xhr, error) {
                $('#myLoading').modal("hide");
                $('div#errPan').text("Sorry, cannot contact server at this time. Please try again later!"); /* + xhr + " :: " + error*/
                fadeInFadeOut($("div#errPan"), 5000);
                console.debug(xhr); console.debug(error);
            }
        });
    };
        
        $('#acctable').DataTable({
//            "dom": "<'row'<'col-md-6'l><'col-md-6'f>r>t<'row'<'col-md-12'i><'col-md-12 center-block'p>>",
//            'paging'      : true,
//            'lengthChange': false,
//            'searching'   : true,
            'ordering'    : true,
//            'info'        : true,
            deferRender: true,
//            columnDefs: [ {
//                orderable: false,
//                className: 'select-checkbox',
//                targets:   0
//            } ],            
//            select: {
//                style:    'os',
//                selector: 'td:first-child'
//            },
//            order: [[ 1, 'asc' ]],
//            columns: [
//                { data: 'username' },
//                { data: 'service_id' },
//                { data: 'service' },
//                { data: 'type' },
//                { data: 'amount' },
//                { data: 'expiration' },
//                { data: 'status' },
//                { data: 'action' }
//            ],
//            select: true,
            'autoWidth'   : false,
            "aLengthMenu": [ [50, 100, 200, -1], [50, 100, 200, "All"] ],
            "iDisplayLength": 50,
            fixedHeader: true,
        	scrollX: true,
//            dom: 'Bfrtip',
//            buttons: [
//                'copyHtml5',
//                'pdfHtml5',
//                'excelHtml5',
//                'print',
//                'pageLength'
//            ]
            dom: 'B<"clear"><"clear">lfrtip',
//            ajax: '/api/data',
            buttons: {
                name: 'primary',
                buttons: [ 'copy', 'csv', 'excel', 'print', 'pdf', 'colvis', {
                        text: 'Reload',
                        action: function ( e, dt, node, config ) {
                            dt.ajax.reload();
                        }
                    } ]
            }
        });
   });   
</script>
<?PHP include_once 'includes/footer_end.php';