<?PHP
$page = "MArketplace Admin Dashboard";
$page_url = "marketdashboard";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'vendor_dashboard';
    </script>
    <?PHP
    exit();
endif;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
//$locations = $dashboard->getLocations();
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$overview = $dashboard->getAdminDashboardOverview();
$pendingVendors = $dashboard->getLastPendingVendors();
//print_r($_SESSION[$sid . 'userid']);
//print_r($_SESSION[$sid . 'usertype_id']);
//$mmdat = $ad->getTransactions("", 0, 20);
$adminId = $_SESSION[$sid . 'userid'];
$accessLevel = $_SESSION[$sid . 'usertype_id'];
$getteamhearachy = $dashboard->getTeamHierarchy($adminId, $accessLevel);
$month = date('Y-m-01');
$savedTargets = $dashboard->getSalesTargetsForMonth($adminId, $month, $accessLevel);
$isTeamLead = ($accessLevel == 20);
$salesList = $dashboard->getUnassignedSalesExecs();
if (!$isTeamLead) {
    echo "<script>window.location.href = 'ism_dashboard';</script>";
    exit;
}
//print_r($getteamhearachy);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

//print_r($getTeamHierarchy);
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>


<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .page-title-section {
        background: white;
        border-radius: 8px;
        padding: 25px 30px;
        margin-bottom: 30px;
        border: 1px solid #e9ecef;
    }

    .page-title-section h3 {
        margin: 0 0 8px 0;
        color: #0f172a;
        font-size: 18px;
        font-weight: 600;
    }

    .page-title-section p {
        margin: 0;
        color: #6c757d;
        font-size: 14px;
    }

    /* Target cards */
    .target-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        overflow: hidden;
        height: 100%;
        border: 1px solid #e4e4e7;
    }

    .target-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 20px;
        border: none;
    }

    .card-header h4 {
        margin: 0;
        font-size: 16px;
        font-weight: 600;
    }

    .card-body {
        padding: 25px;
    }

    .form-label {
        color: #4a5568;
        font-weight: 600;
        font-size: 14px;
        margin-bottom: 8px;
        display: block;
    }

    .target-input {
        border: 1px solid #e9ecef;
        border-radius: 4px;
        padding: 12px 16px;
        font-size: 14px;
        transition: all 0.3s;
        width: 100%;
    }

    .target-input:focus {
        border-color: #0d3e9b;
        box-shadow: 0 0 0 3px rgba(13, 62, 155, 0.1);
        outline: none;
    }

    .current-target-display {
        background: #f8f9fa;
        border-radius: 4px;
        padding: 12px 16px;
        margin-bottom: 20px;
        border-left: 4px solid #0d3e9b;
    }

    .current-target-display .label {
        font-size: 12px;
        color: #6c757d;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .current-target-display .value {
        font-size: 20px;
        color: #0f172a;
        font-weight: 700;
        margin-top: 4px;
    }

    .save-target {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        color: white;
        padding: 10px 20px;
        border-radius: 4px;
        font-weight: 500;
        font-size: 14px;
        width: 100%;
        transition: all 0.3s;
        cursor: pointer;
    }

    .save-target:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 8px rgba(13, 62, 155, 0.3);
    }

    .save-target:active {
        transform: translateY(0);
    }

    .save-target:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        transform: none;
    }

    .empty-state {
        background: white;
        border-radius: 8px;
        padding: 60px 30px;
        text-align: center;
        border: 1px solid #e9ecef;
    }

    .empty-state i {
        font-size: 64px;
        color: #cbd5e0;
        margin-bottom: 20px;
    }

    .empty-state h4 {
        color: #0f172a;
        font-size: 20px;
        margin-bottom: 8px;
    }

    .empty-state p {
        color: #6c757d;
        font-size: 14px;
    }

    /* Success message styling */
    .alert-success {
        background: #f0fdf4;
        border: 1px solid #86efac;
        color: #166534;
        padding: 12px 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        display: none;
    }

    .alert-error {
        background: #fef2f2;
        border: 1px solid #fca5a5;
        color: #991b1b;
        padding: 12px 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        display: none;
    }

    /* Responsive grid */
    .row.g-4 {
        margin: 0 -12px;
    }

    .row.g-4>[class*='col-'] {
        padding: 0 12px;
        margin-bottom: 24px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }

        .top-header {
            padding: 20px 15px;
        }
    }
</style>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Set Monthly Sales Targets</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Page title section -->
        <div class="page-title-section">
            <h3><?= date('F Y') ?> Sales Targets</h3>
            <p>Set individual sales targets for your team members. Targets help track performance and motivate your
                sales team.</p>
        </div>

        <!-- Global message area -->
        <div id="globalMessage"></div>

        <?php if (!empty($getteamhearachy)): ?>
            <div class="row g-4">
                <?php foreach ($getteamhearachy as $group): ?>
                    <?php if (!empty($group['sales_team'])): ?>
                        <?php foreach ($group['sales_team'] as $sales): ?>
                            <div class="col-md-4">
                                <div class="card target-card">
                                    <div class="card-header">
                                        <h4><?= htmlspecialchars($sales->sales_name) ?></h4>
                                    </div>

                                    <div class="card-body">
                                        <?php if (isset($savedTargets[$sales->sales_id]) && $savedTargets[$sales->sales_id] > 0): ?>
                                            <div class="current-target-display">
                                                <div class="label">Current Target</div>
                                                <div class="value">₦<?= number_format($savedTargets[$sales->sales_id], 2) ?></div>
                                            </div>
                                        <?php endif; ?>

                                        <form method="post" class="target-form" data-sales-id="<?= (int) $sales->sales_id ?>">
                                            <!-- Hidden fields -->
                                            <input type="hidden" name="sales_exec_id" value="<?= (int) $sales->sales_id ?>">
                                            <input type="hidden" name="month" value="<?= date('Y-m-01') ?>">

                                            <div class="mb-3">
                                                <label class="form-label">
                                                    <?= isset($savedTargets[$sales->sales_id]) && $savedTargets[$sales->sales_id] > 0 ? 'Update Target Amount' : 'Set Target Amount' ?>
                                                </label>
                                                <input type="number" name="target_amount" class="form-control target-input" step="0.01"
                                                    min="0" placeholder="Enter amount (e.g., 500000)"
                                                    value="<?= isset($savedTargets[$sales->sales_id]) ? $savedTargets[$sales->sales_id] : '' ?>"
                                                    required>
                                            </div>

                                            <?php if ($accessLevel == 20): ?>
                                                <button type="submit" class="btn save-target" data-sales-id="<?= (int) $sales->sales_id ?>">
                                                    <i class="fa fa-save"></i>
                                                    <?= isset($savedTargets[$sales->sales_id]) && $savedTargets[$sales->sales_id] > 0 ? 'Update Target' : 'Set Target' ?>
                                                </button>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="fa fa-users"></i>
                <h4>No Sales Executives Found</h4>
                <p>You don't have any sales executives in your team yet. Assign team members to start setting targets.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script>
    $(document).ready(function () {
        $('.save-target').on('click', function (e) {
            e.preventDefault();

            let $button = $(this);
            let $form = $button.closest('form');
            let sales_id = $button.data('sales-id');
            let target_amount = $form.find('[name="target_amount"]').val();
            let month = $form.find('[name="month"]').val();

            // Validate input
            if (!target_amount || parseFloat(target_amount) <= 0) {
                showMessage('Please enter a valid target amount', 'error');
                return;
            }

            // Disable button and show loading state
            let originalText = $button.html();
            $button.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');

            $.ajax({
                url: 'ajax/save_sales_target.php',
                type: 'POST',
                data: {
                    sales_id: sales_id,
                    target_amount: target_amount,
                    month: month
                },
                success: function (response) {
                    // Re-enable button
                    $button.prop('disabled', false).html(originalText);

                    if (response.success) {
                        showMessage(response.message || 'Target saved successfully!', 'success');

                        // Update the current target display
                        let $card = $form.closest('.target-card');
                        let $currentDisplay = $card.find('.current-target-display');

                        if ($currentDisplay.length) {
                            // Update existing display
                            $currentDisplay.find('.value').text('₦' + parseFloat(target_amount).toLocaleString('en-NG', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                        } else {
                            // Create new display
                            let displayHtml = `
                                <div class="current-target-display">
                                    <div class="label">Current Target</div>
                                    <div class="value">₦${parseFloat(target_amount).toLocaleString('en-NG', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</div>
                                </div>
                            `;
                            $form.prepend(displayHtml);
                        }

                        // Update button text and label
                        $button.html('<i class="fa fa-save"></i> Update Target');
                        $form.find('.form-label').text('Update Target Amount');
                    } else {
                        showMessage(response.message || 'Failed to save target', 'error');
                    }
                },
                error: function () {
                    $button.prop('disabled', false).html(originalText);
                    showMessage('Something went wrong. Please try again.', 'error');
                }
            });
        });

        function showMessage(message, type) {
            let alertClass = type === 'success' ? 'alert-success' : 'alert-error';
            let iconClass = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

            let $alert = $(`
                <div class="${alertClass}" style="display: none;">
                    <i class="fa ${iconClass}"></i> ${message}
                </div>
            `);

            $('#globalMessage').html($alert);
            $alert.fadeIn();

            setTimeout(function () {
                $alert.fadeOut(function () {
                    $(this).remove();
                });
            }, 4000);
        }
    });
</script>

<?PHP
include_once 'includes/footer_end.php';
?>