<?php
$page = "Marketplace Sales Earnings";
$page_url = "sales_earnings";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';


if (isset($_SESSION[$sid . 'loggedin']) && $_SESSION[$sid . 'loggedin'] == 201) {
    if (!isset($_SESSION[$sid . 'usertype_id']) || $_SESSION[$sid . 'usertype_id'] != 21) {
        ?>
        <script>
            window.location.href = 'sales_dash';
        </script>
        <?php
        exit();
    }
}

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];

$salesagent_Id = $dashboard->getSalesAdminState($_SESSION[$sid . 'userid']);
//var_dump($salesagent_Id);

$targets = $dashboard->getSalesTargetForSalesExec($_SESSION[$sid . 'userid'], date('Y-m-01'), 21);
$monthlysales = $dashboard->getSalesExecMonthlySales($_SESSION[$sid . 'userid'], date('Y-m-01'), 21);
$performancePercent = $targets > 0 ? ($monthlysales / $targets) * 100 : 0;
$monthlyOrders = $dashboard->getMonthlySalesOrdersWithPlanBySalesExec($_SESSION[$sid . 'userid'], date('Y-m-01'));

$totalCommissionResult = $dashboard->calculateTotalCommission($monthlyOrders, $performancePercent);
//var_dump($monthlyOrders);
if ($salesagent_Id == null) {
    echo '<script>
            window.location.href = "index.php";
          </script>';
    exit();
}

// Determine agent type: 27 = External Agent, else = Internal Agent
$isExternalAgent = (isset($_SESSION[$sid . 'usertype_id']) && $_SESSION[$sid . 'usertype_id'] == 27);
$isInternalAgent = !$isExternalAgent;




$selected_year = isset($_GET['year']) ? (int) $_GET['year'] : date('Y');
if ($salesagent_Id !== null) {
    // Get earnings for selected year
    $earnings = $dashboard->getAgentEarnings($salesagent_Id);
    $orders_by_month = $dashboard->getPaidOrdersByMonth($salesagent_Id, $selected_year);
}

$default_start_date = $selected_year . '-01-01';
$default_end_date = $selected_year . '-12-31';
?>

<style>
    .dashboard-select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;

        min-width: 140px;
        padding: 8px 36px 8px 12px;
        font-size: 14px;
        font-weight: 500;

        border-radius: 6px;
        border: 1px solid #e5e7eb;
        background-color: #ffffff;

        color: #111827;
        cursor: pointer;

        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3E%3Cpath fill='%236b7280' d='M5.23 7.21a.75.75 0 011.06.02L10 11.06l3.71-3.83a.75.75 0 111.08 1.04l-4.25 4.38a.75.75 0 01-1.08 0L5.21 8.27a.75.75 0 01.02-1.06z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 16px;

        transition: border-color 0.15s ease, box-shadow 0.15s ease;
    }

    .dashboard-select:hover {
        border-color: #9ca3af;
    }

    .dashboard-select:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.15);
    }

    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .sales-section {
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    /* Wrapper */
    .table-wrapper {
        overflow-x: auto;
        margin-top: 20px;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    /* Table */
    .dashboard-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        font-family: 'Inter', sans-serif;
        background: #ffffff;
    }

    /* Header */
    .dashboard-table thead tr {
        background: #4f46e5;
        /* dashboard purple */
        color: #fff;
        text-align: left;
    }

    .dashboard-table thead th {
        padding: 12px 20px;
        font-weight: 600;
        font-size: 14px;
        letter-spacing: 0.5px;
    }

    /* Body rows */
    .dashboard-table tbody tr {
        border-bottom: 1px solid #e5e7eb;
        transition: background 0.2s ease;
    }

    .dashboard-table tbody tr:hover {
        background: #f3f4f6;
    }

    /* Body cells */
    .dashboard-table tbody td {
        padding: 12px 20px;
        font-size: 14px;
        color: #374151;
    }

    /* Alternating row colors */
    .dashboard-table tbody tr:nth-child(even) {
        background: #f9fafb;
    }

    /* View button */
    .view-btn {
        display: inline-block;
        padding: 6px 10px;
        background: #6366f1;
        color: #fff;
        border-radius: 6px;
        text-decoration: none;
        font-size: 14px;
        transition: background 0.2s;
    }

    .view-btn:hover {
        background: #4f46e5;
    }

    /* Disabled icon */
    .dashboard-table tbody .icon.disabled {
        color: #9ca3af;
        cursor: not-allowed;
    }

    /* Empty row */
    .dashboard-table tbody .empty {
        text-align: center;
        color: #9ca3af;
        padding: 20px;
        font-style: italic;
    }

    /* Date Filter Styling */
    .filter-container {
        background: #ffffff;
        border-radius: 8px;
        padding: 20px 25px;
        margin-bottom: 25px;
        border: 1px solid #e5e7eb;
    }

    .filter-header {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 20px;
    }

    .filter-header h3 {
        color: #374151;
        font-size: 16px;
        font-weight: 600;
        margin: 0;
    }

    .filter-header i {
        color: #6b7280;
        font-size: 16px;
    }

    .filter-controls {
        display: flex;
        gap: 20px;
        align-items: flex-end;
        flex-wrap: wrap;
    }

    .filter-group {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .filter-group label {
        color: #6b7280;
        font-size: 13px;
        font-weight: 500;
    }

    .filter-input,
    .filter-select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        padding: 8px 12px;
        border: 1px solid #d1d5db;
        border-radius: 6px;
        background-color: #ffffff;
        color: #1f2937;
        font-size: 14px;
        font-weight: 400;
        min-width: 160px;
        transition: all 0.2s ease;
        cursor: pointer;
    }

    .filter-input:hover,
    .filter-select:hover {
        border-color: #9ca3af;
    }

    .filter-input:focus,
    .filter-select:focus {
        outline: none;
        border-color: #6b7280;
        box-shadow: 0 0 0 1px #6b7280;
    }

    .filter-select {
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3E%3Cpath fill='%236b7280' d='M5.23 7.21a.75.75 0 011.06.02L10 11.06l3.71-3.83a.75.75 0 111.08 1.04l-4.25 4.38a.75.75 0 01-1.08 0L5.21 8.27a.75.75 0 01.02-1.06z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px;
        padding-right: 40px;
    }

    .filter-btn {
        padding: 8px 20px;
        background: #374151;
        color: #ffffff;
        border: 1px solid #374151;
        border-radius: 6px;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .filter-btn:hover {
        background: #1f2937;
        border-color: #1f2937;
    }

    .filter-btn:active {
        transform: translateY(0);
    }

    .filter-separator {
        width: 1px;
        height: 40px;
        background: #e5e7eb;
        align-self: flex-end;
    }

    @media (max-width: 768px) {
        .filter-controls {
            flex-direction: column;
            align-items: stretch;
        }

        .filter-separator {
            display: none;
        }

        .filter-input,
        .filter-select {
            width: 100%;
        }
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Dashboard</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">

        <!-- Stats Row -->
        <div class="row stats-row">
            <?php if ($isExternalAgent): ?>
                <!-- External Agent Stats -->
                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Sales</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($earnings['total'] ?? 0) ?></div>
                        <div class="stat-label">Since you signed up</div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Sales this month</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($earnings['month'] ?? 0) ?></div>
                        <div class="stat-label">since beginning of the month</div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total commision</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($earnings['total_commission'] ?? 0) ?></div>
                        <div class="stat-label">Total Commission</div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Commission this month</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($earnings['month_commission'] ?? 0) ?></div>
                        <div class="stat-label">This month</div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Internal Agent Stats -->
                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Monthly Target</div>
                            <div class="stat-icon">
                                <i class="fa fa-bullseye"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($targets ?? 0) ?></div>
                        <div class="stat-label">Monthly Target for
                            <?= date('F Y') ?>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Sales this month</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($monthlysales ?? 0) ?></div>
                        <div class="stat-label">Since beginning of the month</div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Monthly Performance</div>
                            <div class="stat-icon">
                                <i class="fa fa-chart-line"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($performancePercent, 0) ?>%</div>
                        <div class="stat-label">Performance for the Month</div>
                    </div>
                </div>

                <?php if ($performancePercent >= 75): ?>
                    <div class="col-md-3">
                        <div class="stat-card">
                            <div class="stat-header">
                                <div>Commission this month</div>
                                <div class="stat-icon">
                                    <i class="fa-regular fa-badge-dollar"></i>
                                </div>
                            </div>
                            <div class="stat-value"><?= number_format($totalCommissionResult['totalCommission'] ?? 0) ?></div>
                            <div class="stat-label">Commission Earned</div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Enhanced Date Filter Section -->
        <div class="filter-container">
            <div class="filter-header">
                <i class="fa fa-filter"></i>
                <h3>Paid Orders Summary - Filter Options</h3>
            </div>
            <div class="filter-controls">
                <!-- Year Selection Form -->
                <form method="get" action="" style="display: contents;">
                    <div class="filter-group">
                        <label for="year">Select Year</label>
                        <select name="year" id="year" onchange="this.form.submit()" class="filter-select">
                            <?php
                            $currentYear = date('Y');
                            for ($y = $currentYear; $y >= $currentYear - 5; $y--) {
                                $selected = ($y == $selected_year) ? 'selected' : '';
                                echo "<option value=\"$y\" $selected>$y</option>";
                            }
                            ?>
                        </select>
                    </div>
                </form>

                <div class="filter-separator"></div>

                <!-- Date Range Form -->
                <form method="get" action="sales_earnings_by_month.php" style="display: contents;">
                    <div class="filter-group">
                        <label for="start_date">From Date</label>
                        <input type="date" name="start_date" id="start_date" value="<?= $default_start_date ?>"
                            class="filter-input" required>
                    </div>

                    <div class="filter-group">
                        <label for="end_date">To Date</label>
                        <input type="date" name="end_date" id="end_date" value="<?= $default_end_date ?>"
                            class="filter-input" required>
                    </div>

                    <!-- Pass selected year as hidden input -->
                    <input type="hidden" name="year" value="<?= $selected_year ?>">

                    <div class="filter-group" style="margin-top: 23px;">
                        <button type="submit" class="filter-btn">
                            View Report
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="table-wrapper">
            <table class="dashboard-table">
                <thead>
                    <tr>
                        <th>Month</th>
                        <th>No of Orders</th>
                        <th>Total Sales</th>
                        <?php if ($isExternalAgent): ?>
                            <th>Commission</th>
                        <?php endif; ?>
                        <th>View</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($orders_by_month)): ?>
                        <?php foreach ($orders_by_month as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['month_name']) ?></td>
                                <td><?= (int) $row['total_orders'] ?></td>
                                <td>N<?= number_format($row['total_sales'], 2) ?></td>
                                <?php if ($isExternalAgent): ?>
                                    <td>N<?= number_format($row['agent_commission'], 2) ?></td>
                                <?php endif; ?>
                                <td class="icon">
                                    <?php if ((int) $row['total_orders'] > 0): ?>
                                        <a href="sales_earnings_by_month.php?month=<?= urlencode($row['month_num']) ?>&year=<?= urlencode($selected_year) ?>"
                                            title="View Details" class="view-btn">👁️</a>
                                    <?php else: ?>
                                        <span class="icon disabled" title="No orders to view">—</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="<?= $isExternalAgent ? '5' : '4' ?>" class="empty">No data found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>



    </div>
</div>

<script>
    // View All button functionality
    $(".view-all-btn").click(function () {
        window.location.href = "vendor_orders.php";
    });

    // Sale item click functionality
    $(".sale-item").click(function () {
        $(this).css("background-color", "#e3f2fd").animate({
            backgroundColor: "#f8f9fa"
        }, 300);
    });

    // Initialize tooltips if needed
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>