<?php
$page = "Marketplace Sales Dashboard";
$page_url = "sales_dash";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'sales_dash';
    </script>
    <?php
    exit();
endif;
if (!isset($_SESSION[$sid . 'usertype_id']) || $_SESSION[$sid . 'usertype_id'] != 21):
    ?>
    <script>
        window.location.href = 'ism_dashboard';
    </script>
    <?php
    exit();
endif;
// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];

$sales_check = $dashboard->getSalesAdminState($_SESSION[$sid . 'userid']);

$userId = $_SESSION[$sid . 'userid'];
// $db should be your mysqli connection
$result = $dashboard->insertSalesAgent($userId);
$monthlytopplans = $dashboard->getMonthlySalesByPlan($userId, date('Y-m-01'));

// if ($result) {
//     echo "Sales agent inserted successfully.";
// } else {
//     echo "Already exists or insert failed.";
// }
$sales_check = $dashboard->getSalesDashboardOverview($_SESSION[$sid . 'userid']);
if ($sales_check !== null) {
    $lastPending = $dashboard->getSalesadminPending($_SESSION[$sid . 'userid']);
}
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
// /

?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .btn-primary {
        background: #1976d2;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-primary:hover {
        background: #0d3e9b;
    }


    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .sales-section {
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .view-all-btn {
        background: #0d3e9b;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .view-all-btn:hover {
        background: #3367d6;
    }

    .sales-list {
        padding: 0;
    }

    .sale-item {
        padding: 15px 25px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: space-between;
        transition: background 0.3s ease;
    }

    .sale-item:hover {
        background: #f8f9fa;
    }

    .sale-item:last-child {
        border-bottom: none;
    }

    .customer-info {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
    }

    .customer-details h6 {
        margin: 0;
        color: #0f172a;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .product-name {
        flex: 1;
        color: #6c757d;
        font-size: 14px;
        text-align: center;
    }

    .sale-amount {
        color: #0f172a;
        font-weight: 500;
        font-size: 14px;
    }

    .avatar-pink {
        background: #e91e63;
    }

    .avatar-blue {
        background: #2196f3;
    }

    .avatar-orange {
        background: #ff9800;
    }

    .avatar-green {
        background: #4caf50;
    }

    .avatar-purple {
        background: #9c27b0;
    }

    .avatar-teal {
        background: #009688;
    }

    .avatar-red {
        background: #f44336;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .stat-card {
            margin-bottom: 15px;
        }
    }

    /* Modal Styles */
    .modal-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 1000;
        align-items: center;
        justify-content: center;
    }

    .modal-overlay.active {
        display: flex;
    }

    .modal-content {
        background: white;
        border-radius: 8px;
        width: 90%;
        max-width: 600px;
        max-height: 80vh;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    }

    .modal-header {
        padding: 20px 25px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-title {
        font-size: 20px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .modal-close {
        background: none;
        border: none;
        font-size: 24px;
        color: #6c757d;
        cursor: pointer;
        padding: 0;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 4px;
        transition: background 0.2s;
    }

    .modal-close:hover {
        background: #f8f9fa;
        color: #333;
    }

    .modal-body {
        padding: 25px;
        overflow-y: auto;
    }

    .plan-item {
        padding: 15px;
        margin-bottom: 12px;
        border: 1px solid #e9ecef;
        border-radius: 6px;
        background: #fff;
        transition: all 0.2s;
    }

    .plan-item:hover {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border-color: #1976d2;
    }

    .plan-item.top-plan {
        background: #f0f7ff;
        border-color: #1976d2;
    }

    .plan-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 8px;
    }

    .plan-name {
        font-weight: 600;
        color: #0f172a;
        font-size: 15px;
    }

    .top-badge {
        background: #1976d2;
        color: white;
        padding: 3px 10px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 600;
    }

    .plan-details {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .plan-revenue {
        color: #28a745;
        font-weight: 600;
        font-size: 16px;
    }

    .plan-orders {
        color: #6c757d;
        font-size: 14px;
    }

    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: #6c757d;
    }

    .empty-state i {
        font-size: 48px;
        color: #dee2e6;
        margin-bottom: 15px;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Dashboard</h1>
        <button class="btn btn-primary" onclick="openPerformanceModal()">Check My
            Performance</button>
    </div>

    <!-- Content Area -->
    <div class="content-area">

        <!-- Stats Row -->
        <div class="row stats-row">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Registered</div>
                        <div class="stat-icon">
                            <i class="fa-regular fa-badge-dollar"></i>
                        </div>
                    </div>
                    <div class="stat-value"><?= number_format($sales_check['total_registered'] ?? 0) ?></div>
                    <div class="stat-label">Leads</div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Pending</div>
                        <div class="stat-icon">
                            <i class="fa fa-shopping-cart"></i>
                        </div>
                    </div>
                    <div class="stat-value"><?= number_format($sales_check['total_pending'] ?? 0) ?></div>
                    <div class="stat-label">In Progress</div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Customers</div>
                        <div class="stat-icon">
                            <i class="fa fa-star"></i>
                        </div>
                    </div>
                    <div class="stat-value"><?= number_format($sales_check['total_customers'] ?? 0) ?></div>
                    <div class="stat-label">Subscribers</div>
                </div>
            </div>
        </div>

        <!-- Recent Pending Customers Section -->
        <?php if (!empty($lastPending)): ?>
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Last Pending Customers</h3>
                        <p class="sales-subtitle">Latest customers who haven’t completed payment</p>
                    </div>
                </div>
                <div class="sales-list">
                    <?php
                    $avatar_colors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
                    $color_index = 0;
                    foreach ($lastPending as $customer):
                        $initials = strtoupper(substr($customer['customer_name'], 0, 1) . (strpos($customer['customer_name'], ' ') !== false ? substr($customer['customer_name'], strpos($customer['customer_name'], ' ') + 1, 1) : ''));
                        ?>
                        <div class="sale-item">
                            <div class="customer-info">
                                <div class="customer-avatar <?= $avatar_colors[$color_index] ?>"><?= $initials ?></div>
                                <div class="customer-details">
                                    <h6><?= htmlspecialchars($customer['customer_name']) ?></h6>
                                    <p><?= htmlspecialchars($customer['customer_email']) ?></p>
                                    <small
                                        class="text-muted"><?= htmlspecialchars($customer['customer_address'] ?? 'N/A') ?></small>
                                </div>
                            </div>
                            <div class="sale-actions">
                                <button class="btn btn-sm btn-primary resend-link-btn"
                                    data-customer-id="<?= $customer['customer_id'] ?>">
                                    Resend Payment Link
                                </button>
                            </div>
                        </div>
                        <?php
                        $color_index = ($color_index + 1) % count($avatar_colors);
                    endforeach;
                    ?>
                </div>
            </div>
        <?php else: ?>
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Last Pending Customers</h3>
                        <p class="sales-subtitle">Latest customers who haven’t completed payment</p>
                    </div>
                </div>
                <p style="text-align: center; color: #6c757d; font-style: italic; padding: 20px;">No pending customers found
                    for this
                    agent.
                </p>
            </div>
        <?php endif; ?>


    </div>
</div>

<!-- Performance Modal -->
<div class="modal-overlay" id="performanceModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title">My Monthly Performance - <?= date('F Y') ?></h3>
            <button class="modal-close" onclick="closePerformanceModal()">&times;</button>
        </div>
        <div class="modal-body">
            <?php if (!empty($monthlytopplans)): ?>
                <?php foreach ($monthlytopplans as $index => $plan): ?>
                    <div class="plan-item <?= $index < 3 ? 'top-plan' : '' ?>">
                        <div class="plan-header">
                            <span class="plan-name"><?= htmlspecialchars($plan['plan_name']) ?></span>
                            <?php if ($index < 3): ?>
                                <span class="top-badge">TOP <?= $index + 1 ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="plan-details">
                            <span class="plan-revenue">₦<?= number_format($plan['total_revenue'], 2) ?></span>
                            <span class="plan-orders"><?= (int) $plan['total_orders'] ?> orders</span>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fa fa-chart-line"></i>
                    <p>You have no sales for this month yet.</p>
                    <p style="font-size: 13px;">Your top performing plans will appear here once you make sales.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    // Modal functions
    function openPerformanceModal() {
        document.getElementById('performanceModal').classList.add('active');
    }

    function closePerformanceModal() {
        document.getElementById('performanceModal').classList.remove('active');
    }

    // Close modal when clicking outside
    document.getElementById('performanceModal').addEventListener('click', function (e) {
        if (e.target === this) {
            closePerformanceModal();
        }
    });

    // Close modal with Escape key
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') {
            closePerformanceModal();
        }
    });

    // View All button functionality
    $(".view-all-btn").click(function () {
        window.location.href = "vendor_orders.php";
    });

    // Sale item click functionality
    $(".sale-item").click(function () {
        $(this).css("background-color", "#e3f2fd").animate({
            backgroundColor: "#f8f9fa"
        }, 300);
    });

    // Initialize tooltips if needed
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>