<?php
$page = "Sales Agent Customers";
$page_url = "sales_cutomers";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && $_SESSION[$sid . 'loggedin'] == 201) {
    if (!isset($_SESSION[$sid . 'usertype_id']) || $_SESSION[$sid . 'usertype_id'] != 21) {
        ?>
        <script>
            window.location.href = 'marketdash';
        </script>
        <?php
        exit();
    }
}



// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
?>

<!-- Include DataTables CSS/JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>

<style>
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .content-area {
        padding: 30px;
    }

    .search-filter-bar {
        display: flex;
        margin-bottom: 20px;
        justify-content: space-between;
        align-items: center;
    }

    .search-input {
        flex: 1;
        max-width: 400px;
        position: relative;
    }

    .filter-tabs {
        margin-bottom: 20px;
        border-bottom: 2px solid #e9ecef;
    }

    .filter-tabs ul {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        gap: 10px;
    }

    .filter-tabs li {
        margin: 0;
    }

    .filter-tabs a {
        display: block;
        padding: 10px 20px;
        color: #6c757d;
        text-decoration: none;
        border-bottom: 2px solid transparent;
        transition: all 0.3s ease;
        font-weight: 500;
    }

    .filter-tabs a:hover {
        color: #0d3e9b;
    }

    .filter-tabs a.active {
        color: #0d3e9b;
        border-bottom-color: #0d3e9b;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .customers-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .customers-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
    }

    .customers-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .customers-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .table-container {
        overflow-x: auto;
    }

    .customers-table {
        width: 100%;
        margin: 0;
        border-collapse: collapse;
    }

    .customers-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .customers-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
        text-align: left;
    }

    .customers-table tbody tr {
        border-bottom: 1px solid #f8f9fa;
        transition: background 0.3s ease;
    }

    .customers-table tbody tr:hover {
        background: #f8f9fa;
    }

    .customers-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        font-size: 14px;
    }

    .customer-info {
        display: flex;
        flex-direction: column;
    }

    .customer-name {
        font-weight: 600;
        color: #333;
    }

    .customer-email {
        font-size: 12px;
        color: #6c757d;
        margin-top: 2px;
    }

    .badge-light {
        background: #eef2ff;
        color: #4338ca;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        display: inline-block;
    }

    .badge-success {
        background: #d1fae5;
        color: #065f46;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        display: inline-block;
        font-weight: 500;
    }

    .badge-warning {
        background: #fef3c7;
        color: #92400e;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        display: inline-block;
        font-weight: 500;
    }

    .view-btn {
        background: none;
        border: none;
        color: #0d3e9b;
        padding: 5px 10px;
        cursor: pointer;
        border-radius: 4px;
        transition: background 0.3s ease;
        text-decoration: none;
    }

    .view-btn:hover {
        background: #f8f9fa;
        color: #0d3e9b;
    }

    .resend-link-btn {
        background: #0d3e9b;
        color: white;
        border: none;
        padding: 5px 12px;
        cursor: pointer;
        border-radius: 4px;
        font-size: 12px;
        transition: background 0.3s ease;
        margin-right: 5px;
    }

    .resend-link-btn:hover {
        background: #0a2f73;
    }

    .resend-link-btn:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }

    .action-buttons {
        display: flex;
        gap: 5px;
        align-items: center;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        color: #6c757d;
        margin: 0 2px;
        transition: all 0.3s ease;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: #f8f9fa;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: #0d3e9b;
        color: white;
        border-color: #0d3e9b;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .dataTables_wrapper .dataTables_paginate span:empty {
        display: none;
    }

    .dataTables_wrapper .dataTables_paginate .ellipsis {
        display: none;
    }

    .dataTables_info {
        color: #6c757d;
        font-size: 14px;
        padding: 20px 25px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }

        .search-input {
            max-width: none;
        }
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Customers</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Search Bar -->
        <div class="search-filter-bar">
            <div class="search-input">
                <input type="text" placeholder="Search by email, tracking ID, or sales order ID" id="customerSearch" />
                <i class="fa fa-search"></i>
            </div>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <ul>
                <li><a href="#" class="active" data-status="all" onclick="filterCustomers('all')">All</a></li>
                <li><a href="#" data-status="paid" onclick="filterCustomers('paid')">Paid</a></li>
                <li><a href="#" data-status="pending" onclick="filterCustomers('pending')">Pending</a></li>
            </ul>
        </div>

        <!-- Customers Section -->
        <div class="customers-section">
            <div class="customers-header">
                <div>
                    <h3 class="customers-title" id="sectionTitle">All Customers</h3>
                    <p class="customers-subtitle">Recent sales from your store</p>
                </div>
            </div>

            <!-- Customers Table -->
            <div class="table-container">
                <table class="customers-table" id="customersTable">
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th>Tracking ID</th>
                            <th>Sales Order ID</th>
                            <th>Status</th>
                            <th>Total</th>
                            <th>Order Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="customersTableBody">
                        <!-- DataTables will populate this -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    $(document).ready(function () {
        let currentStatus = 'all';

        // Initialize DataTables
        const table = $('#customersTable').DataTable({
            serverSide: true,
            processing: true,
            pageLength: 10,
            lengthChange: false,
            searching: false,
            ordering: true,
            info: true,
            dom: 'rtip',
            ajax: {
                url: 'ajax/ajax_sales_customers.php',
                type: 'GET',
                data: function (d) {
                    d.page = Math.floor(d.start / d.length) + 1;
                    d.search = $('#customerSearch').val();
                    d.status = currentStatus;
                },
                error: function (xhr, error, code) {
                    console.error('AJAX error:', xhr, error, code);
                }
            },
            columns: [{
                data: 'customer',
                orderable: true
            },
            {
                data: 'tracking_id',
                orderable: true
            },
            {
                data: 'sales_order_id',
                orderable: true
            },
            {
                data: 'status',
                orderable: true
            },
            {
                data: 'total',
                orderable: true
            },
            {
                data: 'order_date',
                orderable: true
            },
            {
                data: 'action',
                orderable: false
            }
            ]
        });

        // Custom search
        $('#customerSearch').on('input', function () {
            table.ajax.reload();
        });

        // Filter by status
        window.filterCustomers = function (status) {
            $('.filter-tabs a').removeClass('active');
            $(`.filter-tabs a[data-status="${status}"]`).addClass('active');
            currentStatus = status;

            // Update section title
            let title = 'All Customers';
            if (status === 'paid') title = 'Paid Customers';
            else if (status === 'pending') title = 'Pending Customers';
            $('#sectionTitle').text(title);

            table.ajax.reload();
        };

        // View order
        window.viewOrder = function (orderId) {
            window.location.href = `order_view.php?id=${encodeURIComponent(btoa(orderId))}`;
        };

        // Resend payment link
        window.resendPaymentLink = function (customerId, button) {
            const $button = $(button);
            const originalText = $button.text();

            $button.prop('disabled', true).text('Sending...');

            $.ajax({
                url: 'ajax/resend_payment_link.php',
                method: 'POST',
                data: {
                    customer_id: customerId
                },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        alert('Payment link resent successfully!');
                    } else {
                        alert('Failed to resend link: ' + response.message);
                    }
                    $button.prop('disabled', false).text(originalText);
                },
                error: function (xhr, status, error) {
                    alert('AJAX error: ' + error);
                    $button.prop('disabled', false).text(originalText);
                }
            });
        };
    });
</script>