<?php
$page = "Sales Executive Details";
$page_url = "sales_exec_detail";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (!isset($_GET['id'])):
?>
    <script>
        window.location.href = 'ism_dashboard';
    </script>
<?php
    exit();
endif;
$sales_exec_id = (int) $_GET['id'];
?>

<?php
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'usertype_id'] == 21)):
    exit();
endif;

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$adminId = $_SESSION[$sid . 'userid'];
$accessLevel = $_SESSION[$sid . 'usertype_id'];

if (!$dashboard->canViewSalesExec($adminId, $accessLevel, $sales_exec_id)) {
?>
    <div class="main-content">
        <div class="content-area">
            <div class="info-card">
                <div class="card-header">
                    <p>Access Denied</p>
                </div>
                <div class="card-body" style="text-align: center;">
                    <h2 style="color: #dc3545;">Access Denied</h2>
                    <p>You do not have permission to view this page.</p>
                </div>
            </div>
        </div>
    </div>
<?php
    include_once 'includes/footer.php';
    include_once 'includes/footer_end.php';
    exit;
}
$month = date('Y-m-01');
$savedTargets = $dashboard->getSalesTargetsForMonth($adminId, $month, $accessLevel);
$salesAmount = $dashboard->getSalesExecMonthlySales(
    $sales_exec_id,
    date('Y-m-01')
);
$targetAmount = $savedTargets[$sales_exec_id] ?? 0;
$performancePercent = 0;
if ($targetAmount > 0) {
    $performancePercent = ($salesAmount / $targetAmount) * 100;
}
$sales = $dashboard->getSalesExecDetails($sales_exec_id);
$monthlyOrders = $dashboard->getMonthlySalesOrdersWithPlanBySalesExec($sales_exec_id, date('Y-m-01'));
$monthlytopplans = $dashboard->getMonthlySalesByPlan($sales_exec_id, date('Y-m-01'));

$totalCommissionResult = $dashboard->calculateTotalCommission($monthlyOrders, $performancePercent);
$totalCommission = $totalCommissionResult['totalCommission'];

if ($sales === null) {
?>
    <div class="main-content">
        <div class="content-area">
            <div class="info-card">
                <div class="card-header">
                    <p>Error</p>
                </div>
                <div class="card-body" style="text-align: center;">
                    <h2 style="color: #dc3545;">Sales Executive Not Found</h2>
                    <p>The requested sales executive could not be found.</p>
                </div>
            </div>
        </div>
    </div>
<?php
    include_once 'includes/footer.php';
    include_once 'includes/footer_end.php';
    exit;
}
?>

<style>
    .main-content {
        margin-left: 230px;
        background-color: white;
        min-height: 100vh;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }

    .card-header {
        background-color: #f8f9fa;
        display: flex;
        justify-content: space-between;
        padding: 15px 20px;
        border-bottom: 1px solid #e9ecef;
        font-weight: 600;
        color: #333;
    }

    .card-body {
        padding: 20px;
    }

    .form-row {
        display: flex;
        margin-bottom: 15px;
        align-items: center;
        justify-content: space-between;
    }

    .form-label {
        width: 200px;
        color: #666;
        font-weight: 500;
        margin-bottom: 0;
    }

    .form-value {
        flex: 1;
        color: #333;
        font-weight: 400;
        word-break: break-word;
    }

    .performance-badge {
        display: inline-block;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 0.9em;
        font-weight: bold;
        color: white;
    }

    .performance-excellent {
        background-color: #28a745;
    }

    .performance-good {
        background-color: #007bff;
    }

    .performance-fair {
        background-color: #ffc107;
        color: #333;
    }

    .performance-low {
        background-color: #dc3545;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 25px;
    }

    .stat-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 20px;
        border-radius: 8px;
        color: white;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .stat-card.target {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }

    .stat-card.earnings {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }

    .stat-label {
        font-size: 0.9em;
        opacity: 0.9;
        margin-bottom: 5px;
    }

    .stat-value {
        font-size: 1.8em;
        font-weight: bold;
    }

    .table-responsive {
        margin-bottom: 20px;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        background-color: #fff;
    }

    .table th,
    .table td {
        padding: 12px;
        border: 1px solid #e9ecef;
        text-align: left;
    }

    .table th {
        background-color: #1976d2;
        color: white;
        font-weight: 600;
    }

    .table tbody tr:nth-child(even) {
        background-color: #f8f9fa;
    }

    .table tbody tr:hover {
        background-color: #e9ecef;
    }

    .missing-plans-alert {
        background-color: #fff3cd;
        border: 1px solid #ffc107;
        color: #856404;
        padding: 12px 15px;
        border-radius: 4px;
        margin-top: 15px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
            padding: 15px;
        }

        .content-area {
            padding: 0 15px 15px;
        }

        .page-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .form-row {
            flex-direction: column;
            align-items: flex-start;
            gap: 5px;
        }

        .form-label {
            width: 100%;
        }

        .form-value {
            width: 100%;
        }

        .stats-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Sales Executive Details</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <nav class="breadcrumb">
            <a href="#" onclick="window.location.href='ism_dashboard'">Dashboard</a>
            <span class="breadcrumb-separator">></span>
            <a href="#" onclick="window.location.href='ism_dashboard'">Sales Executives</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current">Executive Details</span>
        </nav>

        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title"><?= htmlspecialchars($sales->FULLNAME) ?></h1>
        </div>

        <!-- Stats Grid -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-label">Monthly Sales (<?= date('F') ?>)</div>
                <div class="stat-value">₦<?= number_format($salesAmount, 2) ?></div>
            </div>
            <div class="stat-card target">
                <div class="stat-label">Monthly Target</div>
                <div class="stat-value">₦<?= number_format($savedTargets[$sales_exec_id] ?? 0, 2) ?></div>
            </div>
            <div class="stat-card earnings">
                <div class="stat-label">Monthly Earnings</div>
                <div class="stat-value">₦<?= number_format($totalCommission, 2) ?></div>
            </div>
        </div>
        <h2 class="section-title">Sales exec Monthly Performance</h2>

        <div class="row">
            <div class="col-12">
                <div class="team-card">

                    <div class="team-card-body">
                        <?php
                        if (!empty($monthlytopplans)):
                        ?>
                            <ul class="top-plans-list" style="list-style: none; padding-left: 0;">
                                <?php foreach ($monthlytopplans as $index => $plan): ?>
                                    <li style="margin-bottom: 10px; padding: 10px; border-radius: 5px; 
                                <?= $index < 3 ? 'background-color: #d4edda;' : 'background-color: #f8f9fa;' ?>;">
                                        <strong><?= htmlspecialchars($plan['plan_name']) ?></strong>
                                        <span class="plan-revenue" style="margin-left: 10px;">
                                            N<?= number_format($plan['total_revenue'], 2) ?>
                                        </span>
                                        <span class="plan-orders" style="margin-left: 10px; color: #6c757d;">
                                            (<?= (int)$plan['total_orders'] ?> orders)
                                        </span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            <div class="empty-plans" style="padding: 20px; text-align: center;">
                                You have no sales for this month yet.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column -->
            <div class="col-md-6">
                <!-- Executive Information -->
                <div class="info-card">
                    <div class="card-header">
                        <p>Executive Information</p>
                    </div>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-label">Full Name</div>
                            <div class="form-value"><?= htmlspecialchars($sales->FULLNAME) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Email</div>
                            <div class="form-value"><?= htmlspecialchars($sales->EMAIL) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Mobile</div>
                            <div class="form-value"><?= htmlspecialchars($sales->MOBILE) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Date Joined</div>
                            <div class="form-value"><?= date('F j, Y', strtotime($sales->DATE_ADDED)) ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="col-md-6">
                <!-- Performance Summary -->
                <div class="info-card">
                    <div class="card-header">
                        <p>Performance Summary - <?= date('F Y') ?></p>
                    </div>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-label">Target Amount</div>
                            <div class="form-value">₦<?= number_format($savedTargets[$sales_exec_id] ?? 0, 2) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Sales Amount</div>
                            <div class="form-value">₦<?= number_format($salesAmount, 2) ?></div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Performance</div>
                            <div class="form-value">
                                <?php
                                $performanceClass = 'performance-low';
                                if ($performancePercent >= 100) $performanceClass = 'performance-excellent';
                                elseif ($performancePercent >= 75) $performanceClass = 'performance-good';
                                elseif ($performancePercent > 0) $performanceClass = 'performance-fair';
                                ?>
                                <span class="performance-badge <?= $performanceClass ?>">
                                    <?= number_format($performancePercent, 2) ?>%
                                </span>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-label">Commission Earned</div>
                            <div class="form-value">₦<?= number_format($totalCommission, 2) ?></div>
                        </div>
                        <?php if (!empty($totalCommissionResult['missingPlans'])): ?>
                            <div class="missing-plans-alert">
                                <strong>⚠ Missing Commission Plans:</strong><br>
                                <?= implode(', ', array_map(function($plan) { return htmlspecialchars($plan['plan_name']); }, $totalCommissionResult['missingPlans'])) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Transactions -->
        <div class="col-12">
            <div class="info-card">
                <div class="card-header">
                    <p>Monthly Transactions - <?= date('F Y') ?></p>
                </div>
                <div class="card-body">
                    <?php if (!empty($monthlyOrders)): ?>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Order ID</th>
                                        <th>Plan Name</th>
                                        <th style="text-align: right;">Amount (₦)</th>
                                        <th style="text-align: center;">Payment Date</th>
                                        <th style="text-align: center;">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($monthlyOrders as $order): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($order['sales_order_id']) ?></td>
                                            <td><?= htmlspecialchars($order['plan_name'] ?? '—') ?></td>
                                            <td style="text-align: right;">₦<?= number_format($order['total_price'], 2) ?></td>
                                            <td style="text-align: center;"><?= date('M d, Y', strtotime($order['payment_date'])) ?></td>
                                            <td style="text-align: center;">
                                                <span style="padding: 4px 10px; border-radius: 12px; font-size: 0.85em; background-color: <?= $order['status'] === 'completed' ? '#28a745' : '#6c757d' ?>; color: white;">
                                                    <?= ucfirst(htmlspecialchars($order['status'])) ?>
                                                </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p style="text-align: center; color: #6c757d; padding: 30px 0;">
                            No transactions recorded for this month.
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    $(document).ready(function() {
        // Initialize tooltips if needed
        $(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    });
</script>