<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

// only a post with paystack signature header gets our attention
if ((strtoupper($_SERVER['REQUEST_METHOD']) != 'POST' ) || 
        (!array_key_exists('x-paystack-signature', $_SERVER) &&
        !array_key_exists('HTTP_X_PAYSTACK_SIGNATURE', $_SERVER))) {
    exit();
}

// Retrieve the request's body

$input = @file_get_contents("php://input");

// validate event do all at once to avoid timing attack
if (($_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] !== hash_hmac('sha512', $input, PS_UPC_LIVE_PRIV_KEY)) &&
        ($_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] !== hash_hmac('sha512', $input, PS_LIVE_PRIV_KEY))) {
    exit();
}

//sleep(25);
//
//http_response_code(200);
//exit();

// echo "HJ";
// parse event (which is json string) as object
// Do something - that will not take long - with $event
$event = json_decode($input, TRUE); //print_r($event);
if ($event["event"] != "charge.success"): //echo "NOR";
    exit();
endif;
$info = $event["data"];

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$txnref = $txnid = $info['reference'];

// Check Transaction for Lock
$ut = 0;
do {
    if ($ut++ > 0) { sleep(25); }
    if ($ut == 10) { exit(); }
    $sql = "UPDATE tbl_tranx SET ISLOCKED=1 WHERE TRANX_ID=?";
    $locked = $db->execute_query($sql, "s", $txnref);
} while (!$locked);


$vval = $ad->getTranx4Verification($txnref);

$isUpgrade = 0;
if ($vval['PLAN_CHANGE']) :
    $isUpgrade = 1;
    $accHasExpired = $ad->userHasExpired($vval["RAD_USERNAME"]);
endif;
if (count($vval) <= 0) {
    http_response_code(401);
    //Unlock Transaction
            $sql = "UPDATE tbl_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
            $locked = $db->execute_query($sql, "s", $txnref);
    exit();
}
if ($vval['DB_UPDATED'] == 1) :
    http_response_code(200);
    //Unlock Transaction
            $sql = "UPDATE tbl_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
            $locked = $db->execute_query($sql, "s", $txnref);
    exit();
endif;


//upcountry
$isupcountry = $vval['IS_UPCOUNTRY'];
$journal_info = [];
if ($isupcountry):
    $privkey = PS_UPC_LIVE_PRIV_KEY; //(!$ismobile)? PS_UPC_LIVE_PRIV_KEY : PS_UPC_TEST_PRIV_KEY;
    $erpacct = PAYSTACK_UPCOUNTRY;
//    $notifurl = NOTIFICATION_PS_UPCINV_URL;
	$journal_info = $ad->getJournalInfoERP2("PAYSTACK_UPC");
else:
    $privkey = PS_LIVE_PRIV_KEY; // (!$ismobile)? PS_LIVE_PRIV_KEY : PS_TEST_PRIV_KEY;
    $erpacct = PAYSTACK_RENEWAL;
//    $notifurl = NOTIFICATION_PS_INV_URL;
	$journal_info = $ad->getJournalInfoERP2("PAYSTACK_REG");
endif;

$result = array();
//The parameter after verify/ is the transaction reference to be verified
$url = VERIFY_PS_URL . $vval['TRANS_ID'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt(
        $ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $privkey]
); //PS_LIVE_PRIV_KEY
$request = curl_exec($ch);
curl_close($ch);

$is_okay = 0;
$expd = $vval["EXPIRY_DATE"];
$exp = isExpired($vval["EXPIRY_DATE"]); //echo "<br>$expd :: $exp<br>";
$nu_expd = $expd;
$addition = "";
$validity = 0;
$sent = 0;

if ($request) {
    $result = json_decode($request, true);

    if ($result) {
        if ($result['data']) {
            //something came in
            $respcode = '00';
            $resp = "";
            if ($result['data']['status'] == 'success') {
                // the transaction was successful, you can deliver value
                if (($vval["REQ_AMOUNT"] <= ($result['data']['amount'] / 100)) && ($vval['TRANS_ID'] == $result['data']['reference'])):

                    $is_okay = 1;

                    $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
                    $exp = isExpired($userdet['EXPIRATION']);
                    $expd = $userdet['EXPIRATION'];
                    $limitcomb = $userdet["LIMITCOMB"];

                    $validity = ($vval["NMONTHS"] >= 12) ? ($vval["NMONTHS"] * $userdet["VALIDITY"]) + 8 : ($vval["NMONTHS"] * $userdet["VALIDITY"]);
                    if ($exp) :
                        $nu_expd = add_date(date("Y-m-d H:i:s"), $validity); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                    else:
                        $nu_expd = add_date($userdet['EXPIRATION'], $validity); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                    endif;
                    $resp = $result['data']['gateway_response'];
                else:
                    $respcode = "ZZ";
                    $resp = $result['data']['gateway_response'] . ": Invalid Amount";
                endif;
            } else {
                // the transaction was not successful, do not deliver value'

                $respcode = "Z0";
                $resp = $result['data']['gateway_response'];

//                echo json_encode(["STATUS" => $respcode, "MSG" => "Transaction was not successful: Last gateway response was: " . $result['data']['gateway_response']]);
                $sent = 11;
            }

            //Save Transaction
            $pdate = date("Y-m-d H:i:s");
            $appDate = date("Y-m-d H:i:s", strtotime($result['data']['transaction_date']));

            $ad->saveTranxResp($result['data']['reference'], $result['data']['authorization']['authorization_code'],
                    ($result['data']['amount'] / 100), CURRENCY, $respcode, $resp, $nu_expd, $pdate,
                    "paystack-" . $result['data']['channel'], $appDate,
                    $result['data']['authorization']['last4'], $result['data']['reference'], "", $vval["RAD_USERNAME"], $result);


            $upg = "";
            if ($isUpgrade):
                $upgradePaid = $ad->setUpgradeToPaid($vval["RAD_USERNAME"], $txnref, $appDate);
                $upg = "Upgrade";
            endif;

            $du = date("jS M, Y g:i:sa T", strtotime($nu_expd));

            if ($is_okay) :
                if ($isUpgrade) {
                    $upgDone = $ad->upgradeUserPlan($vval["RAD_USERNAME"], $txnref, 1);
                    //mail user
                    $dets = $ad->getPlanUpgradeTranx($vval["RAD_USERNAME"], $txnref);
                    $raw_msgg = $ad->getCannedMessage("SELF_UPGRADE_COMPLETE");
                    $msgg = sprintf($raw_msgg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $dets['OLD_PLAN'], $dets['NEW_PLAN']);
                    $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "FiberOne - Successful Plan Upgrade", $msgg);
                //mail one4two email SELF_UPGRADE_SPECIAL
                if (in_array($dets['NEW_PLAN'], ["SmartHome Plus", "SmartHome Premium", "Smarthome Platinum"])):
                $raw_msggg = $ad->getCannedMessage("SELF_UPGRADE_SPECIAL");
                $msggg = sprintf($raw_msggg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $dets['OLD_PLAN'], $dets['NEW_PLAN']);
                $sentAdmin = $ad->sendEmail(UPGRADE_NOTIF_EMAIL, $userdet["EMAIL"], "[{$vval["RAD_USERNAME"]}] Device Change Required - Successful Plan Upgrade ({$dets['OLD_PLAN']} to {$dets['NEW_PLAN']})", $msggg, ['ONE4TWO'=>"one4twopromo@gmail.com"]);
                endif;
                    //reload details
                    $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
//                    $_SESSION[$sid.'package'] = $userdet['SERVICE'];
//                    $_SESSION[$sid.'package_id'] = $userdet['SRVID'];
                }
                $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"] * $userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $result['data']['reference'], $exp, $vval["NMONTHS"]);
                
                //Unlock Transaction
                $sql = "UPDATE tbl_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
                $locked = $db->execute_query($sql, "s", $txnref);
                
                http_response_code(200);
    
                //Log To ERP  //($ismobile)?"ERP_TEST":
                $mob = ($ismobile) ? " Mobile" : "";
                if ($vval['ERPID'] > 0) {
                    $ad->sendToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], ($result['data']['amount'] / 100), $vval["RAD_USERNAME"] . "-ESERVICE-{$vval["PACKAGE"]}-Renewal $upg(paystackW$mob)", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], $journal_info['JOURNALID'], $txnref, $nu_expd, $journal_info);
                } //PAYSTACK_RENEWAL
                //Get Message
                $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
                $url = SERVER_URL . "";
                //$msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $nu_expd, $result['data']['reference'], $result['data']['reference'], $url);
                $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], ($result['data']['amount'] / 100), $vval["PACKAGE"], $nu_expd, $result['data']['reference'], $result['data']['reference'], $url);

                $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "FiberOne - Successful Subscription Renewal", $msg);

                //Send Admin Email
                $raw_msg = $ad->getCannedMessage("ADMIN_NOTIFICATION");
                $payDate = $appDate;
                $msg = sprintf($raw_msg, $result['data']['reference'], $resp, $vval["RAD_USERNAME"], $payDate, number_format(($result['data']['amount'] / 100), 2));

                $adminsent = $ad->sendEmail(PAY_NOTIF_EMAIL, EMAIL_SENDER, "Succesful Transaction on Paystack", $msg);

                //Redirect

//                echo json_encode(["STATUS" => $respcode, "MSG" => $resp]);


                exit();
            endif;


            if ($sent == 0) {
//                echo json_encode(["STATUS" => $respcode, "MSG" => "Renewal Failed "]);
            }
        } else {
            http_response_code(401);
            if ($sent == 0) {
//                echo json_encode(["STATUS" => "ZX", "MSG" => $result['message']]);
            }
        }
    } else {
//      die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
    }
} else {
//    die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
}
//Unlock Transaction
            $sql = "UPDATE tbl_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
            $locked = $db->execute_query($sql, "s", $txnref);
exit();
