<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($sid)) { $sid = session_id(); }

extract($_POST);

if ($raduser == '' || $invno == '' || $payref == '' || $paymethod == '' || $payamt == ''):
    echo "Error: Incomplete Information!";
    exit();
endif;

if (!isset($_SESSION[$sid.'username'])) {
    echo "Error: It seems this session is expired. Refresh the page and try again!";
    exit();
}

$adminUser = $_SESSION[$sid.'username'];

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$txnref = $invno;
$vval =  $ad->getInvoice4Verification($txnref);

if ($vval['PAID'] == 1) :
    //Already Recorded, Do something
    echo "Invoice Already Paid!";
    exit();
endif;

$payamt = filter_var(str_replace(" ", "", $payamt), FILTER_VALIDATE_FLOAT, FILTER_FLAG_ALLOW_THOUSAND);

/** Save Manual Invoice Info **/
$data = ['erpid'=>$vval['ERPID'], 'order_erpid'=>$vval["ORDER_ERPID"], 'orderno'=>$vval['ORDERNO'], 
    'tellerno'=>payref, 'processedby'=>$adminUser, 'paydate'=>$paydate, 'paid_amt'=>$payamt];
$ff = "DATA, DATESENT, DATAORIGIN";
$logda = "'".base64_encode(json_encode($data))."|{$vval['ORDERNO']}','".date("Y-m-d H:i:s")."', 'ERP_MANINVPAY'";
$ad->insertLog($ff, $logda, "tbl_erpinvoice_data_encrypt");
$logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'ERP_MANINVPAY'";
$ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
/** ./Save Manual Invoice Info **/

$result = array();

if ($txnref == $ixu) :
    $respcode = '00';
    $resp = "Successful Manual Invoice Payment by $adminUser";
    $is_okay = 1;
    
    $pdate = date("Y-m-d H:i:s", strtotime($paydate)); 
    $appDate = date("Y-m-d H:i:s");
    
    $saved = $ad->saveInvoiceTranxResp($txnref, $is_okay, $payref, $payamt, CURRENCY, $respcode, $resp, $pdate, 
                            "$paymethod-MANUAL-BY-$adminUser-($is_okay)", $appDate, "MANX", $raduser);
    
    if ($saved):
        //Create on eService & Radius
        $ad->accProvisionFromOrder($vval["RAD_USERNAME"], $vval['TRANS_ID']);
        //TODO: update SENTTOERP in tbl_install_invoice=1 //DONE
        $ad->sendInvoiceToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $vval["ORDER_ERPID"], $payamt, $vval["RAD_USERNAME"]."-ESERVICE-INIT-Invoice($paymethod-manual-$adminUser)", date("Y-m-d") );
        echo "Success: Payment Recorded!";
    else :
        echo "Error: Failed to record Payment";
    endif;
else:
    echo "Error: Integrity Test Failed";
endif;
