<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

extract($_GET);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$txnref = $txnid;

// Check Transaction for Lock
$ut = 0;
do {
    if ($ut++ > 0) { sleep(25); }
    if ($ut == 10) { exit(); }
    $sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=1 WHERE TRANX_ID=?";
    $locked = $db->execute_query($sql, "s", $txnref);
} while (!$locked);

$vval =  $ad->getRelocTranx4Verification($txnref);
if ($vval['DB_UPDATED'] == 1) :
    //Already Recorded, Do something
    //Unlock Transaction
        $sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
        $locked = $db->execute_query($sql, "s", $txnref);
    echo "<script> window.location.href = '".SERVER_URL."reloc_auto_log'; </script>";
    exit();
endif;

$result = array();
//The parameter after verify/ is the transaction reference to be verified
$url = VERIFY_PS_URL . $vval['TRANS_ID'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt(
  $ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . PS_RELOC_LIVE_PRIV_KEY]
);
$request = curl_exec($ch);
curl_close($ch);

$is_okay = 0;

if ($request) {
    $result = json_decode($request, true);
    // print_r($result);
    if($result){
      if($result['data']){
        //something came in
          $respcode = '00';
          $resp = "";
        if($result['data']['status'] == 'success'){
            
            if ( ($vval["REQ_AMOUNT"] <= ($result['data']['amount']/100))
                        && ($vval['TRANS_ID'] == $result['data']['reference']) ):
                //successful do something
                $is_okay = 1;
                $resp = $result['data']['gateway_response'];
            else:
                $respcode = "ZZ";
                $resp = $result['data']['gateway_response'] . ": Invalid Amount";
            endif; 
            
        } //if($result['data']['status'] == 'success')
        else{
          // the transaction was not successful, do not deliver value'
          // print_r($result);  //uncomment this line to inspect the result, to check why it failed.
          echo "Transaction was not successful: Last gateway response was: ".$result['data']['gateway_response'];
          $respcode = "Z0";
          $resp = $result['data']['gateway_response'];
        } //if($result['data']['status'] == 'success')
        
        //Save Transaction
        $pdate = date("Y-m-d H:i:s"); 
        $appDate = date("Y-m-d H:i:s", strtotime($result['data']['transaction_date']));

        $curr = CURRENCY;
        $ad->saveRelocTranxResp($result['data']['reference'], $result['data']['authorization']['authorization_code'], 
                            ($result['data']['amount']/100), $curr, $respcode, $resp, $pdate, 
                            "paystack-".$result['data']['channel'], $appDate,
                            $result['data']['authorization']['last4'], $result['data']['reference'], "", $vval["RAD_USERNAME"]);
        
        
        if ($is_okay) :  
            
            $ad->updateRelocationStatus($vval["RELOC_ID"], "Account", "Payment verification", date("Y-m-d H:i:s"));
            $pause_till = add_date(date("Y-m-d H:i:s"), 7 );
            $pauseAccount = $ad->pauseAccount($vval["RAD_USERNAME"], $pause_till, 1, "RELOCATION ADMIN");
            $resp = $ad->createRelocationOnMiddleware($vval["RELOC_ID"], $vval["RAD_USERNAME"], 
                    $vval["FULLNAME"], $vval["OLD_ADDRESS"], $vval["NEW_ADDRESS"]);
            
            $sender = ADMIN_RELOC_EMAIL;
            $ad->relocationTicketNotification($vval["RELOC_ID"], $vval["RAD_USERNAME"], 
                    $vval["PHONE"], $vval["EMAIL"], $vval["OLD_ADDRESS"], $vval["NEW_ADDRESS"], $sender);
            
            //Unlock Transaction
                $sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
                $locked = $db->execute_query($sql, "s", $txnref);
                
      		echo "<script> window.location.href = '".SERVER_URL."reloc_auto_log'; </script>";
                
                exit();
        endif;
        
      } //if($result['data'])
      else{
        echo $result['message'];
        //Unlock Transaction
        $sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
        $locked = $db->execute_query($sql, "s", $txnref);
      	exit();
      }
      
    } //if($result)
    else{
        //Unlock Transaction
        $sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
        $locked = $db->execute_query($sql, "s", $txnref);
      //print_r($result);
      die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
    }
    
} //if ($request)
else{
    //Unlock Transaction
                $sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
                $locked = $db->execute_query($sql, "s", $txnref);
    //var_dump($request);
    die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
}
//Unlock Transaction
$sql = "UPDATE tbl_relocation_tranx SET ISLOCKED=0 WHERE TRANX_ID=?";
$locked = $db->execute_query($sql, "s", $txnref);

echo "<script> window.location.href = '".SERVER_URL."reloc_auto_log'; </script>";

