<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

// only a post with paystack signature header gets our attention
if ((strtoupper($_SERVER['REQUEST_METHOD']) != 'POST' ) || (!array_key_exists('x-klump-signature', $_SERVER) && !array_key_exists('HTTP_X_KLUMP_SIGNATURE', $_SERVER) )) {
    // print_r($_SERVER);
    exit();
}

// Retrieve the request's body
$input = @file_get_contents("php://input");
$klump_event_payload = $event = json_decode($input, true);

// validate event do all at once to avoid timing attack
$hash = hash_hmac('sha512', $klump_event_payload, KLUMP_TEST_PRIV_KEY);
if ( ($hash !== $_SERVER['x-klump-signature']) && ($_SERVER['HTTP_X_KLUMP_SIGNATURE'] !== hash_hmac('sha512', $input, KLUMP_TEST_PRIV_KEY)) ) {
    exit();
}

$event = json_decode($input, TRUE); //print_r($event);
if ($event["event"] != "klump.payment.transaction.successful"): //echo "NOR";
    exit();
endif;
$info = $result = $event["data"];

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$txnref = $txnid = $info['merchant_reference'];

// Check Transaction for Lock
$ut = 0;
do {
    if ($ut++ > 0) { sleep(25); }
    if ($ut == 10) { exit(); }
    $sql = "UPDATE tbl_install_invoice SET ISLOCKED=1 WHERE ORDERNO=?";
    $locked = $db->execute_query($sql, "s", $txnref);
} while (!$locked);


$vval =  $ad->getInvoice4Verification($txnref);
if (count($vval) <= 0) {
    http_response_code(401);
    //Unlock Transaction
    $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
    $locked = $db->execute_query($sql, "s", $txnref);
    exit();
}
if ($vval['PAID'] == 1) :
    //Already Recorded, Do something
    //Unlock Transaction
    $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
    $locked = $db->execute_query($sql, "s", $txnref);
    header("HTTP/1.1 200 OK");
    http_response_code(200);
    exit();
endif;

$respcode = '00';
$resp = "";

if ($result['status'] === 'successful') {
    if ( ($vval["REQ_AMOUNT"] <= ($result['amount']))
                && ($vval['TRANS_ID'] == $result['merchant_reference']) ):
        //successful do something
        $is_okay = 1;
        $resp = $result['status'];
    else:
        $respcode = "ZZ";
        $resp = $result['status'] . ": Invalid Amount";
    endif; 
} else{
    // the transaction was not successful, do not deliver value'
    $respcode = "Z0";
    $resp = $result['status'];
}

//Save Transaction
$pdate = date("Y-m-d H:i:s"); 
$appDate = date("Y-m-d H:i:s", strtotime($result['created_at']));

$ad->saveInvoiceTranxResp($result['merchant_reference'], $is_okay, $result['reference'], 
                    ($result['amount']), CURRENCY, $respcode, $resp, $pdate, 
                    "klump-gw", $appDate, $result['id'], $vval["RAD_USERNAME"]);

if ($is_okay) :
    http_response_code(200);
    if ( ($vval['ERPID']>0 && $vval["ORDER_ERPID"]>0) || ($vval["BITRIX_ID"] > 0) ) {   //ERP_DB
        //Create on eService & Radius
        $ad->accProvisionFromOrder($vval["RAD_USERNAME"], $vval['TRANS_ID']);

        //Unlock Transaction
        $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
        $locked = $db->execute_query($sql, "s", $txnref);

        //TODO: update SENTTOERP in tbl_install_invoice=1 //DONE
        if ($vval["BITRIX_ID"] > 0) {
            $ad->sendToBitrix($vval["BITRIX_ID"], $pdate);
        } else  {
            $ad->sendInvoiceToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $vval["ORDER_ERPID"], ($result['amount']), $vval["RAD_USERNAME"]."-ESERVICE-INIT-Invoice(klump)", date("Y-m-d") );
        }
    }

    //Unlock Transaction
    $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
    $locked = $db->execute_query($sql, "s", $txnref);
    
endif;

//Unlock Transaction
$sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
$locked = $db->execute_query($sql, "s", $txnref);