<?php
$page = "Product Detail Dashboard";
$page_url = "product_detail";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'dasha';
    </script>
    <?php
    exit();
endif;

if (!isset($_GET['id'])):
    ?>
    <script>
        window.location.href = 'all_products';
    </script>
    <?php
    exit();
endif;

$productId = base64_decode(urldecode($_GET['id']));
if (!is_numeric($productId)):
    ?>
    <script>
        window.location.href = 'all_products';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

$product = $dashboard->getproductDetails($productId);
$categories = $dashboard->getAllCategories();
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));

// Handle AJAX form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $action = $_POST['action'];
    $adminReason = isset($_POST['admin_reason']) ? trim($_POST['admin_reason']) : '';

    if ($action === 'deny' && empty($adminReason)) {
        echo json_encode(['success' => false, 'message' => 'Please provide a reason for denying the product.']);
        exit();
    }

    $newStatus = ($action === 'approve') ? 'active' : 'declined';
    $updated = $dashboard->updateproductStatus($productId, $newStatus, $adminReason);

    if ($updated) {
        echo json_encode(['success' => true, 'message' => "Product status updated to $newStatus."]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update product status.']);
    }
    exit();
}
?>

<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<style>
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e4e4e7;
        position: sticky;
        top: 0;
        z-index: 50;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        margin: 0;
    }

    .content-area {
        padding: 20px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .form-section {
        background: white;
        border-radius: 12px;
        border: 1px solid #e4e4e7;
        margin-bottom: 24px;
        overflow: hidden;
    }

    .section-header {
        padding: 24px 24px 16px;
        border-bottom: none;
    }

    .section-title {
        font-size: 18px;
        font-weight: 600;
        color: #1a1a1a;
        margin: 0 0 8px;
    }

    .section-subtitle {
        color: #6b7280;
        font-size: 14px;
        margin: 0;
        font-weight: 400;
    }

    .section-content {
        padding: 0 24px 24px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        font-weight: 500;
        color: #374151;
        margin-bottom: 8px;
        display: block;
        font-size: 14px;
    }

    .form-control {
        width: 100%;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        font-size: 14px;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
        background: white;
    }

    .form-control:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .form-control::placeholder {
        color: #9ca3af;
    }

    .form-control-sm {
        padding: 8px 12px;
        font-size: 13px;
    }

    .categories-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 8px;
    }

    .manage-categories {
        color: #3b82f6;
        font-size: 14px;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
    }

    .manage-categories:hover {
        color: #2563eb;
    }

    .ql-toolbar.ql-snow {
        border: 1px solid #d1d5db;
        border-bottom: none;
        border-radius: 8px 8px 0 0;
    }

    .ql-container.ql-snow {
        border: 1px solid #d1d5db;
        border-radius: 0 0 8px 8px;
        font-size: 14px;
    }

    .ql-editor {
        min-height: 120px;
    }

    .ql-editor.ql-blank::before {
        color: #9ca3af;
        font-style: normal;
    }

    .price-input-group {
        position: relative;
    }

    .price-input-group .currency-symbol {
        position: absolute;
        left: 16px;
        top: 50%;
        transform: translateY(-50%);
        color: #6b7280;
        font-weight: 500;
        z-index: 10;
    }

    .price-input-group .form-control {
        padding-left: 36px;
    }

    .price-helper-text {
        font-size: 12px;
        color: #6b7280;
        margin-top: 4px;
    }

    .image-upload-container {
        position: relative;
    }

    .image-upload {
        border: 2px dashed #d1d5db;
        border-radius: 12px;
        padding: 32px;
        text-align: center;
        background: #f9fafb;
        transition: border-color 0.3s ease;
        cursor: pointer;
        min-height: 160px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .image-upload:hover {
        border-color: #3b82f6;
    }

    .image-upload .upload-icon {
        font-size: 32px;
        color: #9ca3af;
        margin-bottom: 12px;
    }

    .upload-text {
        color: #374151;
        font-weight: 500;
        margin-bottom: 4px;
    }

    .upload-subtext {
        color: #6b7280;
        font-size: 12px;
        margin-top: 8px;
    }

    .file-input {
        display: none;
    }

    .spec-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 16px;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        margin-bottom: 12px;
    }

    .spec-item input {
        flex: 1;
        border: none;
        background: none;
        padding: 4px;
        font-size: 14px;
    }

    .spec-item input:focus {
        outline: 1px solid #3b82f6;
        background: white;
        border-radius: 4px;
        padding: 8px;
    }

    .add-spec-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        background: none;
        border: 1px solid #d1d5db;
        color: #374151;
        padding: 12px 20px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
        width: 100%;
        transition: all 0.3s ease;
    }

    .add-spec-btn:hover {
        background: #f9fafb;
        border-color: #3b82f6;
        color: #3b82f6;
    }

    .settings-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 16px 0;
        border-bottom: 1px solid #f3f4f6;
    }

    .settings-item:last-child {
        border-bottom: none;
    }

    .settings-label {
        font-weight: 500;
        color: #374151;
        font-size: 14px;
    }

    .limit-input {
        margin-top: 12px;
        display: none;
    }

    .limit-input.show {
        display: block;
    }

    .toggle-switch {
        position: relative;
        width: 44px;
        height: 24px;
        background: #d1d5db;
        border-radius: 12px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .toggle-switch.active {
        background: #3b82f6;
    }

    .toggle-switch::after {
        content: "";
        position: absolute;
        top: 2px;
        left: 2px;
        width: 20px;
        height: 20px;
        background: white;
        border-radius: 50%;
        transition: transform 0.3s ease;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }

    .toggle-switch.active::after {
        transform: translateX(20px);
    }

    .btn-primary {
        background: #3b82f6;
        border-color: #3b82f6;
        color: white;
        padding: 12px 24px;
        font-weight: 600;
        border-radius: 8px;
        font-size: 14px;
        width: 100%;
        margin-bottom: 12px;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background: #2563eb;
        border-color: #2563eb;
    }

    .btn-danger {
        background: #dc2626;
        border-color: #dc2626;
        color: white;
        padding: 12px 24px;
        font-weight: 600;
        border-radius: 8px;
        font-size: 14px;
        width: 100%;
        margin-bottom: 12px;
        transition: all 0.3s ease;
    }

    .btn-danger:hover {
        background: #b91c1c;
        border-color: #b91c1c;
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-danger {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
    }

    .alert-success {
        background: #d1fae5;
        border: 1px solid #6ee7b7;
        color: #065f46;
    }

    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
        border-bottom: 1px solid #e9ecef;
        padding: 20px;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .modal-body {
        padding: 20px;
    }

    .modal-body p {
        color: #666;
        margin-bottom: 20px;
        line-height: 1.5;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .admin-reason {
        background: #fee2e2;
        padding: 10px;
        margin-top: 10px;
        border-left: 4px solid #dc2626;
        color: #a62c2c;
        border-radius: 4px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }

        .top-bar {
            padding: 15px;
        }

        .section-content {
            padding: 0 16px 16px;
        }

        .section-header {
            padding: 16px;
        }

        .form-control {
            padding: 8px;
        }

        .image-upload {
            padding: 20px;
            min-height: 120px;
        }

        .btn-primary,
        .btn-danger,
        .btn-secondary {
            font-size: 13px;
            padding: 10px 16px;
        }
    }

    @media (max-width: 576px) {
        .spec-item {
            flex-direction: column;
        }

        .spec-item input {
            width: 100%;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Product Details</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('all_products')">Products</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current"><?= htmlspecialchars($product->name) ?></span>
        </nav>

        <div class="alert alert-danger" id="errPan" style="display: none"></div>
        <div class="alert alert-success" id="succPan" style="display: none"></div>

        <form id="product_detail_form" role="form" method="post" data-toggle="validator" action="">
            <input type="hidden" name="product_id" value="<?= htmlspecialchars($productId) ?>">
            <div class="row">
                <!-- Left Column -->
                <div class="col-md-8">
                    <!-- Product Details -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Product Details</h3>
                            <p class="section-subtitle">View and manage product information</p>
                        </div>
                        <div class="section-content">
                            <div class="form-group">
                                <label class="form-label">Name</label>
                                <input type="text" class="form-control" id="product_name" name="product_name"
                                    placeholder="Enter product name"
                                    value="<?= htmlspecialchars($product->name ?? '') ?>" readonly />
                            </div>

                            <div class="form-group">
                                <div class="categories-header">
                                    <label class="form-label">Category</label>
                                    <a href="#" class="manage-categories" style="display: none;">Manage categories</a>
                                </div>
                                <select class="form-control" id="category" name="category_id" disabled>
                                    <option value="">Select category</option>
                                    <?php foreach ($categories as $cat): ?>
                                        <option value="<?= $cat->id ?>" <?= $cat->id == ($product->category_id ?? '') ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($cat->name) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Description</label>
                                <div id="editor"><?= htmlspecialchars($product->description ?? '') ?></div>
                                <input type="hidden" id="description" name="description"
                                    value="<?= htmlspecialchars($product->description ?? '') ?>">
                            </div>

                            <div class="form-group">
                                <label class="form-label">Selling Price</label>
                                <div class="price-input-group">
                                    <span class="currency-symbol">₦</span>
                                    <input type="number" class="form-control" id="product_price" name="product_price"
                                        placeholder="0" step="0.01"
                                        value="<?= htmlspecialchars($product->price ?? '') ?>" readonly />
                                </div>
                                <div class="price-helper-text">Current selling price of the product</div>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Discounted Price</label>
                                <div class="price-input-group">
                                    <span class="currency-symbol">₦</span>
                                    <input type="number" class="form-control" id="discount_price" name="discount_price"
                                        placeholder="0" step="0.01"
                                        value="<?= htmlspecialchars($product->discount_price ?? '') ?>" readonly />
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Tags</label>
                                <input type="text" class="form-control" id="tags" name="tags"
                                    placeholder="Enter tags (e.g., solar, electronics)"
                                    value="<?= htmlspecialchars($product->tags ?? '') ?>" readonly />
                            </div>
                        </div>
                    </div>

                    <!-- Product Images -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Product Images</h3>
                            <p class="section-subtitle">View uploaded images for this product</p>
                        </div>
                        <div class="section-content">
                            <div id="imagePreview" class="mt-3">
                                <?php
                                $images = !empty($product->additional_images) ? array_merge([$product->main_image], explode(',', $product->additional_images)) : [$product->main_image];
                                foreach ($images as $image):
                                    if ($image):
                                        ?>
                                        <img src="<?= htmlspecialchars($image) ?>"
                                            style="width: 100px; height: 100px; object-fit: cover; border-radius: 8px; margin: 5px; border: 1px solid #e4e4e7;" />
                                        <?php
                                    endif;
                                endforeach;
                                ?>
                            </div>
                        </div>
                    </div>

                    <!-- Specifications -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Specifications</h3>
                            <p class="section-subtitle">Key features of the product</p>
                        </div>
                        <div class="section-content">
                            <div id="specificationsList">
                                <?php if (!empty($product->specifications)): ?>
                                    <?php foreach ($product->specifications as $spec): ?>
                                        <div class="spec-item">
                                            <input type="text" name="specifications[name][]"
                                                placeholder="Feature name (e.g., Weight)" class="spec-name"
                                                value="<?= htmlspecialchars($spec['name'] ?? '') ?>" readonly>
                                            <input type="text" name="specifications[value][]"
                                                placeholder="Feature value (e.g., 2kg)" class="spec-value"
                                                value="<?= htmlspecialchars($spec['value'] ?? '') ?>" readonly>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No specifications available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Attributes -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Attributes</h3>
                            <p class="section-subtitle">Product variants and their quantities</p>
                        </div>
                        <div class="section-content">
                            <div id="attributesList">
                                <?php if (!empty($product->attributes)): ?>
                                    <?php foreach ($product->attributes as $attr): ?>
                                        <div class="variant-form">
                                            <div class="variant-name-input">
                                                <label class="form-label">Attribute Name</label>
                                                <input type="text" class="form-control" name="attribute_name[]"
                                                    placeholder="Enter attribute name (e.g., Color)"
                                                    value="<?= htmlspecialchars($attr['name'] ?? '') ?>" readonly>
                                            </div>
                                            <?php foreach ($attr['options'] as $option): ?>
                                                <div class="variant-row">
                                                    <input type="text" class="form-control" name="attribute_value[]"
                                                        placeholder="Value (e.g., Red)"
                                                        value="<?= htmlspecialchars($option['value'] ?? '') ?>" readonly>
                                                    <input type="number" class="form-control" name="attribute_quantity[]"
                                                        placeholder="Quantity" min="0"
                                                        value="<?= htmlspecialchars($option['quantity'] ?? '') ?>" readonly>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No attributes available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Stock -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Stock</h3>
                            <p class="section-subtitle">Total number of this product available</p>
                        </div>
                        <div class="section-content">
                            <div class="form-group">
                                <label class="form-label">Total Stock</label>
                                <input type="number" class="form-control" id="stock_quantity" name="stock_quantity"
                                    placeholder="Enter total stock" min="0"
                                    value="<?= htmlspecialchars($product->stock_quantity ?? '') ?>" readonly />
                            </div>
                            <div class="form-group">
                                <label class="form-label">Minimum Order Quantity</label>
                                <input type="number" class="form-control" id="min_order_quantity"
                                    name="min_order_quantity" placeholder="Enter minimum order quantity" min="1"
                                    value="<?= htmlspecialchars($product->min_order_quantity ?? '') ?>" readonly />
                            </div>
                            <div class="form-group">
                                <label class="form-label">Maximum Order Quantity</label>
                                <input type="number" class="form-control" id="max_order_quantity"
                                    name="max_order_quantity" placeholder="Enter maximum order quantity" min="1"
                                    value="<?= htmlspecialchars($product->max_order_quantity ?? '') ?>" readonly />
                            </div>
                        </div>
                    </div>

                    <?php if (!empty($product->admin_reason)): ?>
                        <div class="admin-reason">
                            <strong>Admin Reason:</strong> <?= htmlspecialchars($product->admin_reason) ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Right Column - Settings -->
                <div class="col-md-4">
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Settings</h3>
                            <p class="section-subtitle">Manage product status and visibility</p>
                        </div>
                        <div class="section-content">
                            <div class="settings-item">
                                <span class="settings-label">Limit product sale</span>
                                <div class="toggle-switch <?= ($product->sale_limit ?? false) ? 'active' : '' ?>"
                                    onclick="toggleLimitSale(this)"></div>
                            </div>
                            <div class="limit-input <?= ($product->sale_limit ?? false) ? 'show' : '' ?>"
                                id="limitInput">
                                <input type="number" class="form-control" name="sale_limit" placeholder="Enter limit"
                                    min="1" value="<?= htmlspecialchars($product->sale_limit ?? '') ?>" readonly />
                            </div>
                            <div class="settings-item">
                                <span class="settings-label">Show number of sales on product page</span>
                                <div class="toggle-switch <?= ($product->show_sales ?? false) ? 'active' : '' ?>"
                                    onclick="toggleSwitch(this)"></div>
                            </div>

                            <?php
                            $status = strtolower($product->status ?? 'pending');
                            if (in_array($status, ['pending', 'inactive'])): ?>
                                <div class="d-flex flex-column mt-4">
                                    <button type="button" class="btn-primary"
                                        onclick="approveProduct(<?= $productId ?>, '<?= htmlspecialchars($product->name) ?>')">Approve</button>
                                    <button type="button" class="btn-danger"
                                        onclick="showDenyModal(<?= $productId ?>, '<?= htmlspecialchars($product->name) ?>')">Deny</button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Deny Confirmation Modal -->
<div class="modal fade" id="denyModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Deny Product</h4>
            </div>
            <div class="modal-body">
                <p id="denyMessage"></p>
                <div class="form-group">
                    <label class="form-label">Reason for Denial</label>
                    <textarea class="form-control" id="admin_reason" name="admin_reason" rows="4"
                        placeholder="Provide a reason for denying this product" required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="hideDenyModal()">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmDenyBtn">Confirm</button>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
    // Initialize Quill Editor
    var quill = new Quill("#editor", {
        theme: "snow",
        readOnly: true,
        modules: {
            toolbar: false
        }
    });

    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'all_products' ? 'all_products.php' : '#';
    }

    // Show deny modal
    function showDenyModal(productId, productName) {
        document.getElementById('denyMessage').innerHTML = `Are you sure you want to deny the product "${productName}"? This will mark it as declined and notify the vendor.`;
        document.getElementById('admin_reason').value = '';
        document.getElementById('confirmDenyBtn').dataset.productId = productId;
        $('#denyModal').modal('show');
    }

    // Hide deny modal
    function hideDenyModal() {
        $('#denyModal').modal('hide');
    }

    // Approve product
    function approveProduct(productId, productName) {
        const btn = document.querySelector(`button[onclick="approveProduct(${productId}, '${productName}')"]`);
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
        btn.disabled = true;

        $.ajax({
            type: 'POST',
            url: 'product_detail.php',
            data: { product_id: productId, action: 'approve' },
            dataType: 'json',
            success: function (data) {
                if (data.success) {
                    showNotification(data.message, 'success');
                    // Update status in UI
                    document.getElementById('status').value = 'Active';
                    // Remove action buttons
                    const settingsActions = document.querySelector('.d-flex.flex-column.mt-4');
                    if (settingsActions) {
                        settingsActions.remove();
                    }
                    // Add admin reason if present
                    if (data.admin_reason) {
                        const reasonDiv = document.createElement('div');
                        reasonDiv.className = 'admin-reason';
                        reasonDiv.innerHTML = `<strong>Admin Reason:</strong> ${data.admin_reason}`;
                        document.querySelector('.col-md-8').appendChild(reasonDiv);
                    }
                } else {
                    showNotification(data.message, 'error');
                }
                btn.innerHTML = originalText;
                btn.disabled = false;
            },
            error: function () {
                showNotification('Error approving product. Please try again.', 'error');
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        });
    }

    // Deny product
    function denyProduct(productId) {
        const adminReason = document.getElementById('admin_reason').value.trim();
        if (!adminReason) {
            showNotification('Please provide a reason for denying the product.', 'error');
            return;
        }

        const btn = document.getElementById('confirmDenyBtn');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
        btn.disabled = true;

        $.ajax({
            type: 'POST',
            url: 'product_detail.php',
            data: { product_id: productId, action: 'deny', admin_reason: adminReason },
            dataType: 'json',
            success: function (data) {
                if (data.success) {
                    showNotification(data.message, 'success');
                    // Update status in UI
                    document.getElementById('status').value = 'Declined';
                    // Remove action buttons
                    const settingsActions = document.querySelector('.d-flex.flex-column.mt-4');
                    if (settingsActions) {
                        settingsActions.remove();
                    }
                    // Add admin reason
                    const reasonDiv = document.createElement('div');
                    reasonDiv.className = 'admin-reason';
                    reasonDiv.innerHTML = `<strong>Admin Reason:</strong> ${adminReason}`;
                    document.querySelector('.col-md-8').appendChild(reasonDiv);
                    hideDenyModal();
                } else {
                    showNotification(data.message, 'error');
                }
                btn.innerHTML = originalText;
                btn.disabled = false;
            },
            error: function () {
                showNotification('Error denying product. Please try again.', 'error');
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        });
    }

    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'}`;
        notification.innerHTML = `
            <button type="button" class="close" onclick="this.parentElement.remove()">
                <span>&times;</span>
            </button>
            <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
        `;
        document.body.appendChild(notification);
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    // Initialize page
    $(document).ready(function () {
        // Confirm deny action
        $('#confirmDenyBtn').on('click', function () {
            const productId = this.dataset.productId;
            denyProduct(productId);
        });

        // Initialize Bootstrap tooltips
        $('[data-toggle="tooltip"]').tooltip();

        // Disable toggle switches
        $('.toggle-switch').css('pointer-events', 'none');
    });

    // Toggle switch functionality (disabled but included for UI consistency)
    function toggleSwitch(element) {
        // Disabled for admin view
    }

    function toggleLimitSale(element) {
        // Disabled for admin view
    }
</script>