<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

$requestBody = file_get_contents('php://input');
//print_r($_SERVER); [REMOTE_ADDR]

$data = ["MerchantReference"=>'', "Customers"=>["Status"=>0, "Error"=>"Service Currently Unavailable"]];
$respBody = getRespXML("<CustomerInformationResponse />", $data);
echo $respBody;
exit();

//$isw_ips = ['41.223.145.177'];  //ISW TEST SERVER
$isw_ips = ['41.223.145.174', '154.72.34.174'];  //ISW LIVE SERVER

if (!(in_array($_SERVER['REMOTE_ADDR'], $isw_ips))) :
   exit();
endif;


$xml=simplexml_load_string($requestBody) or die("Error: Cannot create object");
//print_r($xml);       
        
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);

$fields = "`STATE`, `LOG`";
$value = "'IN', '$requestBody'";
$ad->insertLog($fields, $value);

switch ($xml->getName()) {
    
    case "CustomerInformationRequest" : 
        
        $data = custInfoResp($xml);   
    	$respBody = getRespXML("<CustomerInformationResponse />", $data);
        
        echo $respBody;
    	
    	$value = "'OUT', '$respBody'";
		$ad->insertLog($fields, $value);
        
        break;
    
    
    case "PaymentNotificationRequest" :
        
        $data = payNotifResp($xml);
    	$respBody = getRespXML("<PaymentNotificationResponse />", $data);
        
        echo $respBody; 
    	
    	$value = "'OUT', '$respBody'";
		$ad->insertLog($fields, $value);
        
        break;
    
    default :
        
        break;
}
exit();

/**
 * Generate an Array containing the Customer Information Response data
 * @param String $xml XML string containing the Customer Information Request from Interswitch
 * @return mixed An array containing the Customer Information Response data
 */
function custInfoResp($xml) {
    $custref = strtolower($xml->CustReference);  //remove the concatenated "s" to enable payment
    
    global $ad;
    //echo "YERE: $custref";
    $sacct = $ad->loadRADAccountByUsername($custref);    //print_r($sacct);
    // $sacc=$sacct["$custref"];    //print_r($sacc); echo "AGAIN:".$sacc[0]['SERVICE_ID'];
	foreach ($sacct as $key=>$vall):
		$sacc=$vall;
		break;
	endforeach;
    //$srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); //echo "YES";
	// $fp = fopen("paydirect_log.txt", "a+");
	// fwrite($fp, "Me test");
	// fclose($fp);
    $status = 0;
    $fname = $lname = $email = $mobile = "";
    $amt = 0;
    $payinfo = [];
    
//    $rec[$row->PLAN_ID] = array("PLAN_ID"=>$row->PLAN_ID, "PLAN"=>$row->PLAN, "SRVID"=>$row->SRVID, 
//                    "DATA"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY, 
//                    "CAN_SPILLOVER"=>$row->CAN_SPILLOVER, "PLAN_DESC"=>$row->DESCRIPTION, 
//                    "IS_ENABLED"=>$row->IS_ENABLED, "DATE_ADDED"=>$row->DATE_ADDED, "ADDED_BY"=>$row->ADDED_BY,
//                    "PACKAGE"=>$row->srvname, "PACKAGE_DESC"=>$row->descr, 
//                    "ODATA"=>formatBytes($row->DATA_VOLUME, 2, FALSE));

    if ( (count($sacct) < 1) || (!isset($sacc[0]['ENABLED'])) || !$sacc[0]['ENABLED']) { 
        $status = 1; 
        
    } else {
    	$srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); 
        foreach ($srvlist as $key => $value) {
            $amt = $value["AMOUNT"];  //$value["SRVID"]
            $pcode = (isset($value["PLANCODE"]) && !is_null($value["PLANCODE"]))? $value["PLANCODE"] : $value["SRVID"];
            $payinfo["Item"] = ["ProductName" => $value["PLAN"], "ProductCode" => $pcode,
                                "Quantity" => 1, "Price" => $amt, "Subtotal" => $amt,
                                "Tax" => 0, "Total" => $amt];
            
            if ($xml->PaymentItemCode <> $pcode) $status = 1;
            
            break;
        }
        $fname = $sacc[0]["FIRSTNAME"]; //$sacct["$custref"][0]["FIRSTNAME"];
        $lname = $sacc[0]["LASTNAME"]; //$sacct["$custref"][0]["LASTNAME"];
        $email = $sacc[0]["EMAIL"]; //$sacct["$custref"][0]["EMAIL"];
        $mobile = $sacc[0]["MOBILE"]; //$sacct["$custref"][0]["MOBILE"];
//        $ret[$row->USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
//                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
//                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
//                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
//                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
//                        "ACC_TYPE" => $row->ACC_TYPE);
    }
    
    $cust["Customer"] = ["Status" => $status, "CustReference" => $custref, "CustomerReferenceAlternate" => "",
                         "FirstName" => $fname, "LastName" => $lname, "Email" => $email,
                         "Phone" => $mobile, "ThirdPartyCode" => "", "Amount" => $amt, "NU"=>json_encode($sacc)];
    //($vval['REQ_AMOUNT']*100)
    if (isset($payinfo["Item"]) && ($status == 0)):
        $cust["Customer"]["PaymentItems"] = $payinfo;
    endif;
    $ret = ["MerchantReference" => $xml->MerchantReference/*PAYDIRECT_MERCHANT_REF*/, 
            "Customers" => $cust
        ];
    
    return $ret;
    
}

/**
 * Generate an Array containing the Payment Notification Response data
 * @param String $xml XML string containing the Payment Notification Request from Interswitch
 * @return mixed An array containing the Payment Notification Response data
 */
function payNotifResp($xml) { //echo $xml->ServiceUrl; print_r($xml);
    $custref = strtolower($xml->Payments->Payment->CustReference); 
    $txnref = $paylogid = $xml->Payments->Payment->PaymentLogId;
    
    $status = 0;
    $ret = [];
    
    global $ad;
    //echo "YERRRE: $custref ! $txnref !! $paylogid !!!";
    $sacct = $ad->loadRADAccountByUsername($custref);    //print_r($sacct);
//    $sacc=$sacct["$custref"];   //print_r($sacc); //echo "AGAIN:".$sacc[0]['SERVICE_ID'];
    foreach ($sacct as $key=>$vall):
        $sacc=$vall;
        break;
    endforeach;
    if (count($sacc) < 1):
        $payres["Payment"] = ["PaymentLogId" => $paylogid, "Status" => 1];
        $ret = ["Payments" => $payres];
        
        return $ret;
    endif;
    $srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); //echo "YES";
    foreach ($srvlist as $key => $value) {
        $amount_due = $amt_due = $value["AMOUNT"];
        $planid = $value["PLAN_ID"];
        break;
    }
    
    $expiry = $ad->getExpirationDate($custref);
//    $srvlist = $ad->loadPlans($custref);
//    $amt_due = $srvlist[$custref]["AMOUNT"];
    $nmonths = 1;    
    
    /*MODIFY*/
    $vval =  $ad->getTranx4Verification($txnref);
    
    if (count($vval) <= 0) { $saveRet = $ad->saveInitTranx($paylogid, $custref, $expiry, $amount_due, CURRENCY, $nmonths, $planid); }
    
    /*MODIFY*/
    $vval =  $ad->getTranx4Verification($txnref);
    
    if ( (count($vval) <= 0) || ($xml->Payments->Payment->Amount == 0) ) :
        $payres["Payment"] = ["PaymentLogId" => $paylogid, "Status" => 1];
        $ret = ["Payments" => $payres];
        
        return $ret;
    endif;
    //print_r($xml->Payments->Payment);  exit;
    
    $payxml = $xml->Payments->Payment;
    
    if ($vval["STATUS_CODE"] == "00") { 
        //Payment Processed to DB Already
        //Check if it's reversal to repeated notification
        if (($payxml->IsReversal == "True") || ($payxml->Amount < 0)) :
            //Log Reversals
            $rvs_array = ["TRANX_ID" => $payxml->CustReference, "RAD_USERNAME" => $vval["RAD_USERNAME"],
                        "PAY_REFERENCE" => $payxml->PaymentReference, "ORIGINAL_PAY_REFERENCE" => $payxml->OriginalPaymentReference, 
                        "RET_REF_NO" => $payxml->PaymentLogId, "ORIGINAL_RET_REF_NO" => $payxml->OriginalPaymentLogId,
                        "APPR_AMOUNT" => $payxml->Amount];
                        
            $ad->logPayDirectReversal($rvs_array);
        endif;
        
    } else {
        //Not Yet Processed to DB, Process Now!
        if ($vval['DB_UPDATED'] == 1) :
            $payres["Payment"] = ["PaymentLogId" => $paylogid, "Status" => 1];
            $ret = ["Payments" => $payres];

            return $ret;
        endif;
      if (($payxml->IsReversal == "False") && ($payxml->Amount > 0)) : //print_r($payxml);  
        $expd = $vval["EXPIRY_DATE"];
        $exp = isExpired($vval["EXPIRY_DATE"]); //echo "<br>$expd :: $exp<br>";
        $nu_expd = $expd;
        
        $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
        
        $exp = isExpired($userdet['EXPIRATION']);
        $expd = $userdet['EXPIRATION'];
        $limitcomb = $userdet["LIMITCOMB"];

        $validity = ($vval["NMONTHS"] >= 12)? ($vval["NMONTHS"]*$userdet["VALIDITY"])+8 : ($vval["NMONTHS"]*$userdet["VALIDITY"]);
        if ($exp) :
            $nu_expd = add_date(date("Y-m-d H:i:s"), $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
        else:
            $nu_expd = add_date($userdet['EXPIRATION'], $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
        endif;
        
        //Save Transaction
        $pdate = date("Y-m-d H:i:s"); 
        $appDate = date("Y-m-d H:i:s", strtotime($payxml->PaymentDate));
        //$ad->saveTranxResp($gtpay_tranx_id,$xml->MerchantReference, $gtpay_tranx_amt, $gtpay_tranx_curr, 
        //                    $gtpay_tranx_status_code, $gtpay_tranx_status_msg, $nu_expd, $pdate, $gtpay_gway_name);
        $payloc = (isset($payxml->Location))? $payxml->ChannelName . ": " . $payxml->Location : $payxml->ChannelName;
        $payloc = (isset($payxml->BankCode))? $payloc . " (" . $payxml->BankCode . ")" : $payloc;
//        $ad->saveTranxResp($xml->CustReference, $xml->PaymentReference, $xml->Amount, $xml->PaymentCurrency, 
//                           "00", "Approved by Financial Institution", $nu_expd, $pdate, 
//                            $payloc, $appDate,
//                           isset($xml->BankCode)? $xml->BankCode : "", $xml->PaymentLogId, $xml->ReceiptNo);
        $ad->saveTranxResp($payxml->PaymentLogId, $payxml->PaymentReference, $payxml->Amount, $payxml->PaymentCurrency, 
                           "00", "Approved by Financial Institution", $nu_expd, $pdate, 
                            $payloc, $appDate,
                           isset($payxml->BankCode)? $payxml->BankCode : "", $payxml->ReceiptNo, $payxml->ReceiptNo, $vval["RAD_USERNAME"]);
        //($xml->Amount/100)

//        $du = date("jS M, Y g:i:sa T", strtotime($nu_expd));
        
        if ($vval["REQ_AMOUNT"] == $payxml->Amount) :
//            $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $xml->CustReference);
            $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $payxml->PaymentLogId, $exp, $vval["NMONTHS"]);
            //Log To ERP
            if ($vval['ERPID']>0) { $ad->sendToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $payxml->Amount, $vval["RAD_USERNAME"]."-ESERVICE-{$vval["PACKAGE"]}-Renewal(paydirect)", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], INTERSWITCH_RENEWAL, $txnref); }
            
            //Get Message
            $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
            $url = SERVER_URL . "";
//            $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $nu_expd, $xml->CustReference, $xml->PaymentReference, $url);
            //$msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $nu_expd, $payxml->PaymentLogId, $payxml->PaymentReference, $url);
            $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $payxml->Amount, $vval["PACKAGE"], $nu_expd, $payxml->PaymentLogId, $payxml->PaymentReference, $url);

            $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on FiberOne Online", $msg);
    
            //Send Admin Email
            $raw_msg = $ad->getCannedMessage("ADMIN_NOTIFICATION");
            $payDate = date("d-m-Y H:i:s", strtotime($payxml->PaymentDate));
            $msg = sprintf($raw_msg, $payxml->PaymentLogId, "Approved by Financial Institution", $vval["RAD_USERNAME"], $payDate, number_format($payxml->Amount, 2));

            $adminsent = $ad->sendEmail(PAY_NOTIF_EMAIL, EMAIL_SENDER, "Succesful Transaction on Interswitch PayDirect", $msg);
    
        else:
            $payres["Payment"] = ["PaymentLogId" => $paylogid, "Status" => 1];
            $ret = ["Payments" => $payres];

            return $ret;
        endif;
        
      else:
          //Log Reversals
        $rvs_array = ["TRANX_ID" => $payxml->CustReference, "RAD_USERNAME" => $vval["RAD_USERNAME"],
                    "PAY_REFERENCE" => $payxml->PaymentReference, "ORIGINAL_PAY_REFERENCE" => $payxml->OriginalPaymentReference, 
                    "RET_REF_NO" => $payxml->PaymentLogId, "ORIGINAL_RET_REF_NO" => $payxml->OriginalPaymentLogId,
                    "APPR_AMOUNT" => $payxml->Amount];

        $ad->logPayDirectReversal($rvs_array);
      endif;  
        
    } //if ($vval["STATUS_CODE"] == "00")
    
    
    $payres["Payment"] = ["PaymentLogId" => $paylogid, "Status" => $status];
    $ret = ["Payments" => $payres];
    
    return $ret;
    
}