<?PHP
$page = "Outage Ticket Information View";
$page_url = "outageView";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)) :
    ?>  
    <script> window.location.href = <?PHP echo "'" . SERVER_URL . "dasha'"; ?> ;</script>
    <?PHP
    exit();
endif;


$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

// include_once 'includes/accesschk.php';

$ad = new UserProfile($db);
extract($_GET);

$username = $_SESSION[$sid . 'username'];

$tid = substr($nc, 50);
$tid = substr($tid, 0, strlen($tid)/3);
$ticketId = base64_decode($tid);
$tckInfo = $ad->loadOutageTicket($ticketId);
if (count($tckInfo) > 1) :
    echo "<script> alert('Invalid Data provided.');";
    echo "window.location.href = '" . SERVER_URL . "outagePending'; </script>";
    exit();
endif;
foreach ($tckInfo as $key => $tck) {
    $dTicket = $tck;
}

$approvalDetails = json_decode(($dTicket['REWARD_APPROVED_BY']), TRUE); 

?>

<style>
    .custom-header {
        text-align: center;
        padding: 3px;
        background: #000;
        color: #fff;
    }
    input.search-input {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        width: 100%;
        margin-bottom: 5px;
        height: auto;
    }
    .form-horizontal .form-group {
        margin-right: -15px;
        margin-left: 0px;
    }
    .levelView {
        cursor: pointer;
        color: blue;
        font-weight: 700;
        font-size: 0.8em;
        margin-top: 5px;
    }
    .levelViewer th, .levelViewer td {
  	padding: 10px;
    }
    .levelViewer th {
	background-color: #FDDF95;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Outage Ticket Info 
            <small>outage ticket management</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="#"> Outage Ticket Info</a></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Outage Ticket Info</h3>
                    </div>
                    <div class="box-body">
                        
                        <form role="form" enctype="multipart/form-data" class="form-horizontal" data-toggle="validator" id="tck_form" name="tck_form" action="" method="post">
                            <fieldset>

                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Ticket ID: </span>
                                        <input type="text" class="form-control" name="tickectID" id="tickectID" value="<?PHP echo $dTicket["TICKET_ID"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence ID: </span>
                                        <input type="text" class="form-control" name="incidenceId" id="incidenceId" value="<?PHP echo $dTicket["INCIDENCE_ID"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence Type: </span>
                                        <input type="text" class="form-control" name="incType" id="incType" value="<?PHP echo $dTicket["INCIDENCE_TYPE"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence Summary: </span>
                                        <textarea class="form-control" style="min-height:80px" name="summary" id="summary" rows='5' cols='45' type="text" readonly ><?PHP echo $dTicket["SUMMARY"]; ?></textarea>

                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence Date: </span>
                                        <input type="datetime" class="form-control" name="incDate" id="incDate" value="<?PHP echo $dTicket["START_DATE"]; ?>" readonly disabled />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Resolution Date: </span>
                                        <input type="datetime" class="form-control" name="incResDate" id="incResDate" value="<?PHP echo $dTicket["ACTUAL_RESOLUTION_DATE"]; ?>" readonly disabled />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Days Requested: </span>
                                        <input type="text" class="form-control" name="DaysReq" id="DaysReq" value="<?PHP echo $dTicket["REQUESTED_DURATION"]; ?>" readonly disabled />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Days To Approve: </span>
                                        <input type="number" class="form-control" name="daysApproved" id="daysApproved" value="<?PHP echo $dueLevel==1? $dTicket["REQUESTED_DURATION"] : $dTicket["APPROVED_DURATION"]; ?>" min="0" readonly disabled  />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Approval Cost: </span>
                                        <input type="text" class="form-control" name="approvalCost" id="approvalCost" value="&#8358 <?PHP echo $dTicket["COST"]; ?>" readonly disabled  />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div id='contentDiv'>
                                        <div style="display:inline-block; border:1px solid black; margin: 10px; padding: 10px; vertical-align:top; max-height: 80px; overflow-y: auto;">
                                            <label >Affected Users (<?PHP echo $dTicket['NO_AFFECTED_USERS']; ?> users)</label><br/>
                                            <span id="vcontent" style="width: 100%;max-height: 80px; overflow-y: scroll;">
                                                <?PHP echo $dTicket['AFFECTED_USERS']; ?>
                                            </span>
                                        </div>

                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Approved Level: </span>
                                        <input type="text" class="form-control" name="appLvl" id="appLvl" value="Level <?PHP echo $dTicket["REWARD_APPROVAL_LEVEL"]; ?>" readonly />
                                    </div>
                                    <div class="levelView" id="viewDetails" data-vis="hide"><i class="glyphicon glyphicon-menu-right"></i> View Approval Details</div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-8 ">
                                    <div id='contentDiv'>
                                        <div id="levelViewer" class="levelViewer" style="display:none; border:3px solid #1b40b7; margin: 10px; padding: 10px; vertical-align:top; border-radius: 7px; overflow-y: auto;">
                                            
                                            <table border="1" padding="5">
                                                <caption style="text-align: center; font-weight: 700;" >Completed Stages</caption>
                                                <tr>
                                                    <th>Level</th>
                                                    <th>Done By</th>
                                                    <th>Decision</th>
                                                    <th>Days Approved</th>
                                                    <th width='30%'>Comment</th>
                                                    <th>Date Done</th>
                                                </tr>
                                                <?PHP foreach ($approvalDetails as $approvalInfo) : ?>
                                                <tr>
                                                    <td><strong>Level <?PHP echo $approvalInfo['APPROVAL_LEVEL']; ?></strong></td>
                                                    <td><?PHP echo $approvalInfo['APPROVER']; ?></td>
                                                    <td><?PHP echo $approvalInfo['DECISION']; ?></td>
                                                    <td><center><?PHP echo $approvalInfo['DAYS_APPROVED']; ?></center></td>
                                                    <td><?PHP echo $approvalInfo['APPROVER_COMMENT']; ?></td>
                                                    <td><?PHP echo $approvalInfo['APPROVAL_DATE']; ?></td>
                                                </tr>
                                                <?PHP endforeach; ?>
                                                
                                            </table>
                                        </div>

                                    </div>
                                </div>
                                <div class="clearfix"></div><br/>
                                
                            </fieldset>
                            
                        </form>
                        
                    </div>
                    
                </div>
                
            </div>
            
        </div>
        
    </section>
        
</div>

    <div class="modal fade" id="mySubA" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">

        <div class="modal-dialog" style="width: 800px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" style='margin-top: -7px;'>×</button>
<!--                    <h3>Settings</h3>-->
                </div>
                <div id="subacctlist" class="modal-body">
                    <center>
                        <p><img src="img/ajax-loaders/ajax-loader-5.gif" title="img/ajax-loaders/ajax-loader-5.gif"></p>
                        <p>Please Wait! Loading Data</p>
                    </center>
                </div>
            </div>
        </div>
    </div>


<?PHP include_once 'includes/footer.php'; ?>

<script type="text/javascript">
    $(document).ready(function () {
        // Show an element and then fade it out with the timeout given
           var fadeInFadeOut = function (jQueryElement, timeout) {
               jQueryElement.fadeIn(1000);
               setTimeout(function () {
                   jQueryElement.fadeOut("slow");
               }, timeout);
           };
           
        $("#viewDetails").on("click", function(e) {
            
            var vis = $("#viewDetails").data("vis");
            if (vis === 'hide') {
                $("#levelViewer").css("display", "block");
                $("#viewDetails").data("vis", "show");
                $(this).html('<i class="glyphicon glyphicon-menu-down"></i> Hide Approval Details');
            } else {
                $("#levelViewer").css("display", "none");
                $("#viewDetails").data("vis", "hide");
                $(this).html('<i class="glyphicon glyphicon-menu-right"></i> View Approval Details');
            }
            
        });
        
        
        
    });
    
</script>
<?PHP
include_once 'includes/footer_end.php';