<?PHP 
$page = "Local Outage Ticket List";
$page_url="outageLocalList";
include_once 'includes/header.php'; 
include_once 'includes/sidemenu.php'; 

$not_done = 'label-danger';
$done = 'label-success';
$partial = 'label-warning';

if ( isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101) ) : 
?>
   <script> window.location.href = 'dasha'; </script>
<?PHP
    exit();
endif;

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

include_once 'includes/accesschk.php'; 

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Local Outage Ticket List 
        <small>View list of Local Outage Tickets on EService</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Local Outage Ticket List</a></li>
      </ol>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Client List</h3>
                </div>
                <div class="box-body">
                    <table border="0" cellspacing="5" cellpadding="5">
                        <tbody>
                            <tr>
                                <td>Start Date:</td>
                                <td><input name="min" id="min" type="text"></td>
                            </tr>
                            <tr><td colspan="2">&nbsp;</td></tr>
                            <tr>
                                <td>End Date:</td>
                                <td><input name="max" id="max" type="text"></td>
                            </tr>
                        </tbody>
                    </table>
                    <br/>
                    <table id="acctable" class='table nowrap table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                        <thead>
                        <tr>
                            <th>SN</th>
                            <th class="center">TICKET ID</th>
                            <th class="center">INCIDENCE TYPE</th>
                            <th style="text-align: center !important;">AFFECTED USERS</th> 
                            <th style="text-align: center !important;">START DATE</th>   
                            <th style="text-align: center !important;">EXPECTED RESOL. DATE</th>    
                            <th style="text-align: center !important;">ACTUAL RESOL. DATE</th>   
                            <th style="text-align: center !important;">INCIDENCE SUMMARY</th>      
                            <th style="text-align: center !important;">CREATOR</th>      
                            <th style="text-align: center !important;">DATE CREATED</th>      
                            <th class="center" style="text-align: center !important;">STATUS</th>      
                            <th class="center" style="text-align: center !important;">CLOSED BY</th>   
                            <th class="center">TICKET ID</th>                                        
                            <th class="center" style="text-align: center !important;">ACTION</th>
                        </tr>
                        </thead>
                        <tbody>
                            
                        </tbody>
                        <tfoot>
                        <tr>
                            <th>SN</th>
                            <th class="center">TICKET ID</th>
                            <th class="center">INCIDENCE TYPE</th>
                            <th style="text-align: center !important;">AFFECTED USERS</th> 
                            <th style="text-align: center !important;">START DATE</th>   
                            <th style="text-align: center !important;">EXPECTED RESOL. DATE</th>    
                            <th style="text-align: center !important;">ACTUAL RESOL. DATE</th> 
                            <th style="text-align: center !important;">INCIDENCE SUMMARY</th>      
                            <th style="text-align: center !important;">CREATOR</th>      
                            <th style="text-align: center !important;">DATE CREATED</th>      
                            <th class="center" style="text-align: center !important;">STATUS</th>    
                            <th class="center" style="text-align: center !important;">CLOSED BY</th>    
                            <th class="center">TICKET ID</th>                                      
                            <th class="center" style="text-align: center !important;">ACTION</th>
                        </tr>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-12 -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.Main content -->
    
</div>
<!-- /.content-wrapper -->

<!-- DIV to display Addon/Sub Radius Accounts -->       
    <div class="modal fade" id="mySubA" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">

        <div class="modal-dialog" style="width: 800px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" style='margin-top: -7px;'>×</button>
<!--                    <h3>Settings</h3>-->
                </div>
                <div id="subacctlist" class="modal-body">
                    <center>
                        <p><img src="img/ajax-loaders/ajax-loader-5.gif" title="img/ajax-loaders/ajax-loader-5.gif"></p>
                        <p>Please Wait! Loading Data</p>
                    </center>
                </div>
            </div>
        </div>
    </div>


<div class="modal fade modal-primary" id="manPayModal" tabindex="-1" role="dialog" aria-labelledby="manPayModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="delModalLabel">Process Local Incidence Ticket</h4>
      </div>
      <div class="modal-body">
          <form role="form" class="" data-toggle="validator" id="frmManPay" action="" method="POST">
              <fieldset>
                <div id="raddiv" class="form-group has-feedback">
                    <div class="input-group input-group-md">
                        <span class="input-group-addon">Ticket ID:</span>
                        <input type="text" value="" class="form-control" id="ticketId" name="ticketId"  readonly required />
                    </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>
                </div>
                <div id="userdiv" class="form-group has-feedback">
                    <div class="input-group input-group-md">
                        <span class="input-group-addon">Username:</span>
                        <input type="text" value="" class="form-control" id="username" name="username"  readonly required />
                    </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>
                </div>
                <div id="userdiv" class="form-group has-feedback">
                    <div class="input-group input-group-md">
                        <span class="input-group-addon">Incidence Summary:</span>
                        <textarea type="text" value="" class="form-control" id="incsummary" name="incsummary" required ></textarea>
                    </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>
                </div>
                  
                <div class="form-group has-feedback">
                  <div class="input-group date">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i> Incidence Date:
                    </div>
                      <input type="text" class="form-control pull-right" value="" id="datepicker" name="incidencedate" >
                  </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>
                </div>
                  
                <div class="form-group has-feedback">
                  <div class="input-group date">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i> Provided Resolution Date:
                    </div>
                      <input type="text" class="form-control pull-right" value="" id="datepickerExpRes" name="expectedResolutiondate" data-provide="datepicker" >
                  </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>
                </div>
                
                <div id="tresolveDiv" class="form-group has-feedback" style="display:block">
                    <label for="isopen">
                        <input type="radio" name="ticketResolved" id="isopen" value="isopen" /> Ticket is still open
                    </label><br/>
                    <label for="isclosed">
                        <input type="radio" name="ticketResolved" id="isclosed" value='isclosed' /> Ticket has been resolved, close but don&apos;t request refund
                    </label><br/>
                    <label for="isclosedrequest">
                        <input type="radio" name="ticketResolved" id="isclosedrequest" value='isclosedrequest' /> Ticket has been resolved, close and request refund
                    </label>
                </div>
                
                <div id="paymetdiv" class="form-group has-feedback" style="display:block">
                    <select class="form-control select2" id="qualified" name="qualified" placeholder="Select Loss Days Qualification" required>
                        <option value="" disabled="disabled"></option>
                        <option value="1" >Qualified for Loss Days</option>
                        <option value="0" >Not Qualified for Loss Days</option>
                    </select>
                </div>

                <div class="clearfix"></div>
                            
                <div class="form-group has-feedback">
                  <div class="input-group date">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i> Actual Resolution Date:
                    </div>
                      <input type="text" class="form-control pull-right" value="" id="datepickerRes" name="resolutiondate" data-provide="datepicker" >
                  </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>

                </div>

                <div class="clearfix"></div>
                            
                <input type="hidden" name="ixu" id="ixu"  value="" />
                <input type="hidden" name="rxu" id="rxu"  value="" />
                <input type="hidden" name="user" id="user"  value="<?PHP echo $_SESSION[$sid.'username']; ?>" />
                <center><button type="button" id='manPayBtn' data-tck='' data-inc='' data-row='' class="btn btn-warning">Process Ticket</button></center>
              </fieldset>
          </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary left-side" data-dismiss="modal">Cancel</button>

      </div>
    </div>
  </div>
</div>


<div class="modal fade modal-primary" id="manPayModal1" tabindex="-1" role="dialog" aria-labelledby="manPayModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="delModalLabel">Request Ticket Lost Day(s)</h4>
      </div>
      <div class="modal-body">
          <form role="form" class="" data-toggle="validator" id="frmManPay1" action="" method="POST">
              <fieldset>
                <div id="raddiv" class="form-group has-feedback">
                    <div class="input-group input-group-md">
                        <span class="input-group-addon">Ticket ID:</span>
                        <input type="text" value="" class="form-control" id="ticketId" name="ticketId"  readonly required />
                        <input type="hidden" value="" class="form-control" id="incidenceId" name="incidenceId"  readonly required />
                    </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>
                </div>
                            
                <div class="form-group has-feedback">
                  <div class="input-group date">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i> No of Days to Add:
                    </div>
                      <input type="number" class="form-control pull-right" value="1" id="nDays" name="nDays" readonly />
                  </div>
                    <span class="glyphicon form-control-feedback" aria-hidden="true"></span>
                    <span class="help-block with-errors"></span>

                </div>

                <div class="clearfix"></div>
                            
                <input type="hidden" name="ixu" id="ixu"  value="" />
                <input type="hidden" name="rxu" id="rxu"  value="" />
                <button type="button" id='manPayBtn1' data-dur='' data-tck='' data-inc='' data-row='' class="btn btn-warning">Request Ticket Lost Day(s)</button>
              </fieldset>
          </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary left-side" data-dismiss="modal">Cancel</button>

      </div>
    </div>
  </div>
</div>


<?PHP include_once 'includes/footer.php'; ?>
<script type="text/javascript" src="dist/js/fnFindCellRowIndexes.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
       
       //Date picker
        $('#datepicker, #datepickerExpRes, #datepickerRes').datepicker({
          autoclose: true,
          format: 'yyyy-mm-dd',
          todayBtn: true,
//          startDate: new Date()
        });
        
        $("table").on("click", "a.gFormManPay1", function(){ 
           
            $('#manPayModal1').modal({
                show: 'false'
            }); 
            
            var tck = $(this).data("tck");
            var inc = $(this).data("inc");
            var dur = $(this).data("dur");
            
            $("#manPayBtn1").attr("data-tck", tck);
            $("#manPayBtn1").attr("data-inc", inc);
            $("#manPayBtn1").attr("data-dur", dur);
            
            $('#frmManPay1 #ixu').val(inc);
            $('#frmManPay1 #rxu').val(tck);
            $('#frmManPay1 #incidenceId').val(inc); 
            $('#frmManPay1 #ticketId').val(tck);
            $('#frmManPay1 #nDays').val(dur);
            
            var rowId = $('#acctable').dataTable()
                        .fnFindCellRowIndexes(tck, 1);
                console.log("rowId=" + rowId);
            $("#manPayBtn1").attr("data-row", rowId);
        });         
        
       $("#manPayBtn1").on("click", function() {
            var dat = $('#frmManPay1').serialize(); //alert(dat);
            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: "static"
              });
              
            $.ajax({
                type: "POST",
                url: "ajax/requestLocalLostDays.php",
                data: dat,
                dataType: "text",
                success: function(response){  //alert(response);
                    if(response.match(/Success/i)) { //
                        alert(response);
                        $('#myLoading').modal("hide");     
                    	table.ajax.reload();
                        $('#manPayModal1').modal("toggle");

                     }  else {
                         alert(response);
                        $('#myLoading').modal("hide");
                     }
                },
                error: function(xhr, error) {
                    $('#myLoading').modal("hide");
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                }
            });
       });
        
        $("table").on("click", "a.gFormManPay", function(){ 
           
            $('#manPayModal').modal({
                show: 'false'
            }); 
            
            var tck = $(this).data("tck");
            var inc = $(this).data("inc");
            var startDate = $(this).data("startdate");
            var expResDate = $(this).data("expresdate");
            var summary = $(this).data("summ");
            var username = $(this).data("usr");
            
            $("#manPayBtn").attr("data-user", tck);
            $("#manPayBtn").attr("data-inv", inc);
            
            $('#frmManPay #ixu').val(inc);
            $('#frmManPay #rxu').val(tck);
            $('#frmManPay #incidenceId').val(inc); 
            $('#frmManPay #ticketId').val(tck);
            $('#incsummary').val(summary);
            $('#username').val(username);
            $('input[name="incidencedate"]').datepicker('setDate', startDate);
            $('input[name="expectedResolutiondate"]').datepicker('setDate', expResDate);
            $('input[name="resolutiondate"]').datepicker('setDate', expResDate);
            
            //set Start Date
//            $('#datepicker').datepicker('setStartDate', startDate);
            
            var rowId = $('#acctable').dataTable()
                        .fnFindCellRowIndexes(tck, 1);
                console.log("rowId=" + rowId);
            $("#manPayBtn").attr("data-row", rowId);
        });          
        
       $("#manPayBtn").on("click", function() {
            var dat = $('#frmManPay').serialize(); //alert(dat);
            if (!$('input[name="ticketResolved"]').is(':checked')) {
                alert('Select Ticket Status and action');
                return false;
            }
            var selAction = $('input[name="ticketResolved"]').val();
            var resDate = $('input[name="resolutiondate"]').val();
            if (resDate == '' && selAction != 'isopen') {
                alert('Supply Resolution Date');
                return false;
            }
            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: "static"
              });
              
            $.ajax({
                type: "POST",
                url: "ajax/closeOutageLocalTicket.php",
                data: dat,
                dataType: "text",
                success: function(response){  //alert(response);
                    if(response.match(/Success/i)) { //
                        alert(response);
                        $('#myLoading').modal("hide");     
                    	table.ajax.reload();
                        $('#manPayModal').modal("toggle");
                     }  else {
                         alert(response);
                        $('#myLoading').modal("hide");
                     }
                },
                error: function(xhr, error) {
                    $('#myLoading').modal("hide");
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                }
            });
       });
   
   /* For Export Buttons available inside jquery-datatable "server side processing" - Start
- due to "server side processing" jquery datatble doesn't support all data to be exported
- below function makes the datatable to export all records when "server side processing" is on */

function newexportaction(e, dt, button, config) { 
	alert("Pulling data from DB, download will commence once data is pulled. This may take 1-3mins depending on the volume of data");
    var self = this;
    var oldStart = dt.settings()[0]._iDisplayStart;
    dt.one('preXhr', function (e, s, data) {
        // Just this once, load all data from the server...
        data.start = 0;
        data.length = 2147483647;
        dt.one('preDraw', function (e, settings) {
            // Call the original action function
            if (button[0].className.indexOf('buttons-copy') >= 0) {
                $.fn.dataTable.ext.buttons.copyHtml5.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-excel') >= 0) {
                $.fn.dataTable.ext.buttons.excelHtml5.available(dt, config) ?
                    $.fn.dataTable.ext.buttons.excelHtml5.action.call(self, e, dt, button, config) :
                    $.fn.dataTable.ext.buttons.excelFlash.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-csv') >= 0) {
                $.fn.dataTable.ext.buttons.csvHtml5.available(dt, config) ?
                    $.fn.dataTable.ext.buttons.csvHtml5.action.call(self, e, dt, button, config) :
                    $.fn.dataTable.ext.buttons.csvFlash.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-pdf') >= 0) {
                $.fn.dataTable.ext.buttons.pdfHtml5.available(dt, config) ?
                    $.fn.dataTable.ext.buttons.pdfHtml5.action.call(self, e, dt, button, config) :
                    $.fn.dataTable.ext.buttons.pdfFlash.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-print') >= 0) {
                $.fn.dataTable.ext.buttons.print.action(e, dt, button, config);
            }
            dt.one('preXhr', function (e, s, data) {
                // DataTables thinks the first item displayed is index 0, but we're not drawing that.
                // Set the property to what it was before exporting.
                settings._iDisplayStart = oldStart;
                data.start = oldStart;
            });
            // Reload the grid with the original page. Otherwise, API functions like table.cell(this) don't work properly.
            setTimeout(dt.ajax.reload, 0);
            // Prevent rendering of the full data to the DOM
            return false;
        });
    });
    // Requery the server with the new one-time export settings
    dt.ajax.reload();
};

        
        var table = $('#acctable').DataTable({
            'ordering'    : true,
//            'info'        : true,
            'autoWidth'   : false,
            "aLengthMenu": [ [50, 100, 200, 500, 1000, 1500, 2000, 5000, -1], [50, 100, 200, 500, 1000, 1500, 2000, 5000, "All"] ],
            "iDisplayLength": 50,
//            fixedHeader: true,
            "deferRender": true,
            "order": [[ 10, "DESC" ]],
            "processing": true,
            "serverSide": true,
            "bSortClasses": false,
            'scrollX': '100%',
            'scrollY': '40vh',
            scrollCollapse: true,
            
            'serverMethod': 'post',
             'columns': [
                { data: 'SN' }, 
                { data: 'TICKET_ID' },
                { data: 'INCIDENCE_TYPE' },
                { data: 'NO_AFFECTED_USERS' },
                { data: 'START_DATE' }, 
                { data: 'EXPECTED_RESOLUTION_DATE' },
                { data: 'ACTUAL_RESOLUTION_DATE' },
                { data: 'SUMMARY' },
                { data: 'CREATED_BY' }, 
                { data: 'CREATION_DATE' },
                { data: 'STATUS' },
                { data: 'CLOSED_BY' },
                { data: 'TICKET_ID' },
                { data: 'ACTION' }
             ],

            dom: 'B<"clear"><"clear">lfrtip',
            'ajax': {
                'url':'ajax/outageLocalList',
                'data': function(data){
                   // Read values
                   var min = $('#min').val();
                   var max = $('#max').val();
                   // Append to data
                   data.min = min;
                   data.max = max;
                }
             },
        	
            buttons: {
                name: 'primary',
            	"buttons": [{
               "extend": 'copy',
               "text": '<i class="fa fa-files-o" style="color: green;"></i> Copy',
               "titleAttr": 'Copy',                               
               "action": newexportaction
            },
            {
               "extend": 'excel',
               "text": '<i class="fa fa-file-excel-o" style="color: green;"></i> Excel',
               "titleAttr": 'Excel',                               
               "action": newexportaction
            },
            {
               "extend": 'csv',
               "text": '<i class="fa fa-file-text-o" style="color: green;"></i> CSV',
               "titleAttr": 'CSV',                               
               "action": newexportaction
            },
            {
               "extend": 'pdf',
               "text": '<i class="fa fa-file-pdf-o" style="color: green;"></i> PDF',
               "titleAttr": 'PDF',                               
               "action": newexportaction
            }, 'colvis', {
                        text: 'Reload',
                        action: function ( e, dt, node, config ) {
                            dt.ajax.reload();
                        }
            },
            {
               "extend": 'print',
               "text": '<i class="fa fa-print" style="color: green;"></i> Print',
               "titleAttr": 'Print',                                
               "action": newexportaction
            }],
            }
        });  
        
        $("#min").datepicker({ onSelect: function () { table.draw(); }, changeMonth: true, changeYear: true, format: 'yyyy-mm-dd' , dateFormat:"dd-mm-yy"});
        $("#max").datepicker({ onSelect: function () { table.draw(); }, changeMonth: true, changeYear: true, format: 'yyyy-mm-dd', dateFormat:"dd-mm-yy" });

        // Event listener to the two range filtering inputs to redraw on input
        $('#min, #max').change(function () {
            table.draw();
        });
        
    table.on('draw', function () {
        $(".downloadIcon").each(function(){
            $(this).off().click(function(){
                $('#myLoading').modal({
                    keyboard: false,
                    show: true,
                    backdrop: "static"
                  });
                let ticketId = $(this).data('tck');
                let incId = $(this).data('inc');
                
                let dat = "ticketId=" + ticketId + "&incId=" + incId + "&action=incidenceBeneficiaryList";
                $.ajax({
                    type: "POST",
                    url: "ajax/outageReportGen",
                    data: dat,
                    success: function(response){  
                        alert(response);
                        $('#myLoading').modal('hide');
                    },
                    error: function() {
                        alert("Sorry, cannot contact server at this time. Please try again later!");
                        $('#myLoading').modal('hide');
                    }
                });
             });
       });
   });
        
        
    });
    
</script>
<?PHP include_once 'includes/footer_end.php';    