<?PHP
$page = "Outage Ticket Information";
$page_url = "outageInfo";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)) :
    ?>  
    <script> window.location.href = <?PHP echo "'" . SERVER_URL . "dasha'"; ?> ;</script>
    <?PHP
    exit();
endif;

if ($_SESSION[$sid . 'readonly']) {
    echo "<script> alert('You only have readonly access. Contact Administrator if you think this is by error.');";
    echo " window.location.href = '" . SERVER_URL . "ad_raduser'; </script>";
    exit();
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

// include_once 'includes/accesschk.php';

$ad = new UserProfile($db);
extract($_GET);

$username = $_SESSION[$sid . 'username'];
$approverList = $ad->loadOutageApprover($username);
if ( count($approverList) <1 || (!isset($nc))):
    echo "<script> alert('You do not have access to approve this request. Contact Administrator if you think this is by error.');";
    echo "window.location.href = '" . SERVER_URL . "outagePending'; </script>";
    exit();
endif;
$approvalLevel = $approverList[0]["APPROVAL_LEVEL"];

$tid = substr($nc, 50);
$tid = substr($tid, 0, strlen($tid)/3);
$ticketId = base64_decode($tid);
$tckInfo = $ad->loadOutageTicket($ticketId);
if (count($tckInfo) > 1) :
    echo "<script> alert('Invalid Data provided.');";
    echo "window.location.href = '" . SERVER_URL . "outagePending'; </script>";
    exit();
endif;
foreach ($tckInfo as $key => $tck) {
    $dTicket = $tck;
}

$canApproveThis = $ad->canApproveLevel($_SESSION[$sid.'userid'], $dTicket['REWARD_APPROVAL_LEVEL'] + 1);
$approvalDetails = json_decode(($dTicket['REWARD_APPROVED_BY']), TRUE); 
$dueLevel = $canApproveThis? $dTicket['REWARD_APPROVAL_LEVEL'] + 1 : 0;
//array("INCIDENCE_ID"=>$row->INCIDENCE_ID, "TICKET_ID"=>$row->TICKET_ID, 
//                "INCIDENCE_TYPE"=> $row->INCIDENCE_TYPE, "OLT_ID"=>$row->OLT_ID, "GPON_ID"=>$row->GPON_ID,
//                "AFFECTED_USERS"=> $row->AFFECTED_USERS, "NO_AFFECTED_USERS"=> count(explode(",",$row->AFFECTED_USERS)),
//                "START_DATE"=> $row->START_DATE, "EXPECTED_RESOLUTION_DATE"=>$row->EXPECTED_RESOLUTION_DATE,
//                "ACTUAL_RESOLUTION_DATE" => $row->ACTUAL_RESOLUTION_DATE, "TICKET_STATUS" => $row->TICKET_STATUS, 
//                "SUMMARY" => $row->SUMMARY, "CREATION_DATE" => $row->CREATION_DATE, "CREATED_BY" => $row->CREATED_BY, 
//                "LASTUPDATED_BY" => $row->LASTUPDATED_BY, "LASTUPDATED_DATE" => $row->LASTUPDATED_DATE,
//                "DURATION" => $row->DURATION, "ISCLOSED" => $row->ISCLOSED, 
//                "QUALIFIED_FOR_REWARD" => $row->QUALIFIED_FOR_REWARD, "IS_REWARDED" => $row->IS_REWARDED, 
//                "REWARD_REQUEST_BY" => $row->REWARD_REQUEST_BY, "REWARD_REQUEST_DATE" => $row->REWARD_REQUEST_DATE, 
//                "REWARD_APPROVED_BY" => $row->REWARD_APPROVED_BY, "REWARD_APPRVAL_DATE" => $row->REWARD_APPRVAL_DATE,
//                "REWARD_APPROVAL_LEVEL"=>$row->REWARD_APPROVAL_LEVEL)
?>
<!--<link href="dist/css/multi-select.dist.css" media="screen" rel="stylesheet" type="text/css">-->
<!-- Select2 -->
<!--<link rel="stylesheet" href="bower_components/select2/dist/css/select2.min.css">-->
<style>
    .custom-header {
        text-align: center;
        padding: 3px;
        background: #000;
        color: #fff;
    }
    input.search-input {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        width: 100%;
        margin-bottom: 5px;
        height: auto;
    }
    .form-horizontal .form-group {
        margin-right: -15px;
        margin-left: 0px;
    }
    .levelView {
        cursor: pointer;
        color: blue;
        font-weight: 700;
        font-size: 0.8em;
        margin-top: 5px;
    }
    .levelViewer th, .levelViewer td {
  	padding: 10px;
    }
    .levelViewer th {
	background-color: #FDDF95;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Outage Ticket Info 
            <small>outage ticket management</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="#"> Outage Ticket Info</a></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Outage Ticket Info</h3>
                    </div>
                    <div class="box-body">
                        <div class="alert alert-danger" id="errPan" style="display: none" ></div>
                        <div class="alert alert-success" id="succPan" style="display: none" ></div>
                        
                        <form role="form" enctype="multipart/form-data" class="form-horizontal" data-toggle="validator" id="tck_form" name="tck_form" action="" method="post">
                            <fieldset>
                                <input type="hidden" name="user" id="user" value="<?PHP echo $_SESSION[$sid . 'username']; ?>" />
                                <input type="hidden" name="userid" id="userid" value="<?PHP echo $_SESSION[$sid . 'userid']; ?>" />
                                <input type="hidden" name="tckid" id="tckid" value="<?PHP echo $dTicket["TICKET_ID"]; ?>" />
                                <input type="hidden" name="incid" id="incid" value="<?PHP echo $dTicket["INCIDENCE_ID"]; ?>" />
                                <input type="hidden" name="appLevel" id="appLevel" value="<?PHP echo $dueLevel; ?>" />

                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Ticket ID: </span>
                                        <input type="text" class="form-control" name="tickectID" id="tickectID" value="<?PHP echo $dTicket["TICKET_ID"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence ID: </span>
                                        <input type="text" class="form-control" name="incidenceId" id="incidenceId" value="<?PHP echo $dTicket["INCIDENCE_ID"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence Type: </span>
                                        <input type="text" class="form-control" name="incType" id="incType" value="<?PHP echo $dTicket["INCIDENCE_TYPE"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="form-group has-feedback col-md-5 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence Summary: </span>
                                        <textarea class="form-control" style="min-height:100px" name="summary" id="summary" rows='5' cols='45' type="text" readonly><?PHP echo $dTicket["SUMMARY"]; ?></textarea>

                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Incidence Date: </span>
                                        <input type="text" class="form-control" name="incDate" id="incDate" value="<?PHP echo date('Y-m-d', strtotime($dTicket["START_DATE"])); ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Resolution Date: </span>
                                        <input type="text" class="form-control" name="incResDate" id="incResDate" value="<?PHP echo date('Y-m-d', strtotime($dTicket["ACTUAL_RESOLUTION_DATE"])); ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Days Requested: </span>
                                        <input type="text" class="form-control" name="DaysReq" id="DaysReq" value="<?PHP echo $dTicket["REQUESTED_DURATION"]; ?>" readonly />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Confirmed Resolution Date: </span>
                                        <input type="text" class="form-control" name="adjResDate" id="adjResDate" value="<?PHP echo date('Y-m-d', strtotime($dTicket["ADJUSTED_RESOLUTION_DATE"]?? $dTicket["ACTUAL_RESOLUTION_DATE"])); ?>" autocomplete="off"  />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Days To Approve: </span>
                                        <input type="number" class="form-control" name="daysApproved" id="daysApproved" value="<?PHP echo $dueLevel==1? $dTicket["REQUESTED_DURATION"] : $dTicket["APPROVED_DURATION"]; ?>" min="0" readonly <?PHP //echo $dueLevel==1? "" : "readonly" ?>  />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Approval Cost: </span>
                                        <input type="text" class="form-control" name="approvalCost" id="approvalCost" value="&#8358 <?PHP echo $dTicket["COST"]; ?>" readonly disabled  />
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div id='contentDiv'>
                                        <div style="display:inline-block; border:1px solid black; margin: 10px; padding: 10px; vertical-align:top; max-height: 80px; overflow-y: auto;">
                                            <label >Affected Users (<?PHP echo $dTicket['NO_AFFECTED_USERS']; ?> users)</label><br/>
                                            <span id="vcontent" style="width: 100%;max-height: 80px; overflow-y: scroll;">
                                                <?PHP echo $dTicket['AFFECTED_USERS']; ?>
                                            </span>
                                        </div>

                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Approved Level: </span>
                                        <input type="text" class="form-control" name="appLvl" id="appLvl" value="Level <?PHP echo $dTicket["REWARD_APPROVAL_LEVEL"]; ?>" readonly />
                                    </div>
                                    <div class="levelView" id="viewDetails" data-vis="hide"><i class="glyphicon glyphicon-menu-right"></i> View Approval Details</div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-8 ">
                                    <div id='contentDiv'>
                                        <div id="levelViewer" class="levelViewer" style="display:none; border:3px solid #1b40b7; margin: 10px; padding: 10px; vertical-align:top; border-radius: 7px; overflow-y: auto;">
                                            
                                            <table border="1" padding="5">
                                                <caption style="text-align: center; font-weight: 700;" >Completed Stages</caption>
                                        		<tr>
                                                    <th>Level</th>
                                                    <th>Done By</th>
                                                    <th>Decision</th>
                                                    <th>Days Approved</th>
                                                    <th>Rework?</th>
                                                    <th width='25%'>Comment</th>
                                                    <th>Date Done</th>
                                                </tr>
                                                <?PHP foreach ($approvalDetails as $approvalInfo) : ?>
                                                <tr>
                                                    <td><strong>Level <?PHP echo $approvalInfo['APPROVAL_LEVEL']; ?></strong></td>
                                                    <td><?PHP echo $approvalInfo['APPROVER']; ?></td>
                                                    <td><?PHP echo $approvalInfo['DECISION']; ?></td>
                                                    <td><center><?PHP echo $approvalInfo['DAYS_APPROVED']; ?></center></td>
                                                    <td><center><?PHP echo $approvalInfo['REWORK']?? ''; ?></center></td>
                                                    <td><?PHP echo $approvalInfo['APPROVER_COMMENT']; ?></td>
                                                    <td><?PHP echo $approvalInfo['APPROVAL_DATE']; ?></td>
                                                </tr>
                                                <?PHP endforeach; ?>
                                                
                                            </table>
                                        </div>

                                    </div>
                                </div>
                                <div class="clearfix"></div><br/>
                                
                                <?PHP 
                                if ($canApproveThis && (!in_array($dTicket['IS_REWARDED'], [-1,1])) ):
                                ?>
                                <div class="form-group has-feedback col-md-3 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Decision: </span>
                                        <select class="form-control" id="appDecision" name="appDecision" required>
                                            <option value="" >Select as applicable</option>
                                            <option value="1">Approve Request</option>
                                            <option value="0">Decline Request</option>
                                        </select>

                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group reworkDiv col-md-5" style="display: none; margin-bottom: 15px !important;background-color: #d2cee7;font-size: 1.2em;padding: 2px 5px 2px 10px;">
                                    
                                        <div class="input-group input-group-md" style="width:100%">
                                            <label class="checkbox-inline" style="width:100%">
                                              <input type="checkbox" id="to_rework" name="to_rework" value="1" aria-label="Send for Re-work"> Send for re-work
                                            </label>
                                        </div><!-- /input-group -->
                                    
                                </div>
                                <div class="clearfix"></div>
                                
                                <div class="form-group has-feedback col-md-5 ">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon">Decision Comment: </span>
                                        <textarea class="form-control" style="min-height: 80px" name="decision_comment" id="decision_comment" rows='3' cols='45' type="text" ></textarea>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                
                                <div id='contentDiv'>
                                    <div style="display:inline-block; border:1px solid black; margin: 10px; padding: 10px; width: 40%;vertical-align:top; max-height: 80px; overflow-y: auto;">
                                        <span class="center col-md-12" style="">
                                            <button type="submit" class="btn btn-warning">Submit Request</button>
                                        </span>
                                    </div>
                                </div>
                                
                                <?PHP
                                endif;
                                ?>
                                
                            </fieldset>
                            
                        </form>
                        
                    </div>
                    
                </div>
                
            </div>
            
        </div>
        
    </section>
        
</div>

    <div class="modal fade" id="mySubA" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">

        <div class="modal-dialog" style="width: 800px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" style='margin-top: -7px;'>×</button>
<!--                    <h3>Settings</h3>-->
                </div>
                <div id="subacctlist" class="modal-body">
                    <center>
                        <p><img src="img/ajax-loaders/ajax-loader-5.gif" title="img/ajax-loaders/ajax-loader-5.gif"></p>
                        <p>Please Wait! Loading Data</p>
                    </center>
                </div>
            </div>
        </div>
    </div>


<?PHP include_once 'includes/footer.php'; ?>

<script type="text/javascript">
    $(document).ready(function () {
        // Show an element and then fade it out with the timeout given
           var fadeInFadeOut = function (jQueryElement, timeout) {
               jQueryElement.fadeIn(1000);
               setTimeout(function () {
                   jQueryElement.fadeOut("slow");
               }, timeout);
           };
           
        $('#incDate, #incResDate').datepicker({
          autoclose: true,
          format: 'yyyy-mm-dd',
          enableOnReadonly: false
        });
        $("#adjResDate").datepicker({
          autoclose: true,
          format: 'yyyy-mm-dd',
          enableOnReadonly: false
        }).on('changeDate', function(ev){
            var start = $('#incDate').datepicker('getDate');
            var endst   = $('#adjResDate').datepicker('getDate');
			
            if (start<endst) {
                var days = ((endst - start)/1000/60/60/24) ;
                $('#daysApproved').val(days-1);
            }
    	});
           //set Start Date
        $('#adjResDate').datepicker('setStartDate', '<?PHP echo date("Y-m-d", strtotime($dTicket["START_DATE"])); ?>');
           
        $("#viewDetails").on("click", function(e) {
            
            var vis = $("#viewDetails").data("vis");
            if (vis === 'hide') {
                $("#levelViewer").css("display", "block");
                $("#viewDetails").data("vis", "show");
                $(this).html('<i class="glyphicon glyphicon-menu-down"></i> Hide Approval Details');
            } else {
                $("#levelViewer").css("display", "none");
                $("#viewDetails").data("vis", "hide");
                $(this).html('<i class="glyphicon glyphicon-menu-right"></i> View Approval Details');
            }
            
        });
        
        $("#appDecision").on('change', function() {
            var sel = this.value;
            if (sel == 1) {
                $("#decision_comment").prop("required", false);
                $(".reworkDiv").css("display", "none");
                $("#to_rework").prop("checked", false);
            } else {
                $("#decision_comment").prop("required", true);
                $(".reworkDiv").css("display", "block");
            }
          });
           
        $('#tck_form').validator().on('submit', function (e) {
               if (e.isDefaultPrevented()) {
                   // handle the invalid form...
                   alert("Error");
               } else {
                   e.preventDefault();

                   // everything looks good!
                   var dat = $('#tck_form').serialize(); //alert(dat);

                   $('#myLoading').modal({
                       keyboard: false,
                       show: true,
                       backdrop: "static"
                   });
                   myAjaxCall(dat);
               }
           });

           var myAjaxCall = function (dat) {
               $.ajax({
                   type: "POST",
                   url: "<?PHP echo SERVER_URL; ?>ajax/approveLostDaysLevel",
                   data: dat,
                   dataType: "text",

                   success: function (response) {  //alert(response);
                       if (response.match(/Success/i)) {
                           alert(response);
                            
                           $('#myLoading').modal("hide");
                           $('div#succPan').html(response);
                           fadeInFadeOut($("div#succPan"), 5000);
                            $(window.location).attr('href', '<?PHP echo SERVER_URL; ?>outagePending'); 

                       } else {
                           $('#myLoading').modal("hide");
                           $('div#errPan').html(response);
                           alert(response);
                           fadeInFadeOut($("div#errPan"), 5000);
                       }
                   },
                   error: function (xhr, error) {
                       $('#myLoading').modal("hide");
                       $('div#errPan').text("Sorry, cannot contact server at this time. Please try again later!"); /* + xhr + " :: " + error*/
                       fadeInFadeOut($("div#errPan"), 5000);
                       console.debug(xhr);
                       console.debug(error);
                   }
               });
           };
    });
    
</script>
<?PHP
include_once 'includes/footer_end.php';

