<?php
$page = "Sales Agent Order View";
$page_url = "order_view";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';


if (isset($_SESSION[$sid . 'loggedin']) && $_SESSION[$sid . 'loggedin'] == 201) {
    if (!isset($_SESSION[$sid . 'usertype_id']) || $_SESSION[$sid . 'usertype_id'] != 21) {
        ?>
        <script>
            window.location.href = 'all_products';
        </script>
        <?php
        exit();
    }
}



if (!isset($_GET['id'])):
    ?>
    <script>
        window.location.href = 'sales_earnings';
    </script>
    <?php
    exit();
endif;

$order_id = base64_decode(urldecode($_GET['id']));

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

$salesagent_Id = $dashboard->getSalesAdminState($_SESSION[$sid . 'userid']);

if ($salesagent_Id === null) {
    // ob_end_clean();
    echo "<script>alert('Invalid or missing sales agent.'); window.location.href = 'sales_earnings';</script>";
    exit();
}
//
//exit;
$order_details = $dashboard->getCustomerFromSalesOrder($order_id, $salesagent_Id);
//print_r($order_details);

$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$categories = $dashboard->getAllCategories();
$product = $dashboard->getvendorproductDetails($productId, $vendor_id);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));


// Determine agent type: 27 = External Agent, else = Internal Agent
$isExternalAgent = (isset($_SESSION[$sid . 'usertype_id']) && $_SESSION[$sid . 'usertype_id'] == 27);
$isInternalAgent = !$isExternalAgent;
?>
<style>
    .main-content {
        margin-left: 230px;
        background-color: white;
        min-height: 100vh;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }

    .info-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        margin-bottom: 25px;
        overflow: hidden;
    }

    .card-header {
        background-color: #f8f9fa;
        display: flex;
        justify-content: space-between;
        padding: 15px 20px;
        border-bottom: 1px solid #e9ecef;
        font-weight: 600;
        color: #333;
    }

    .card-body {
        padding: 20px;
    }

    .form-row {
        display: flex;
        margin-bottom: 15px;
        align-items: center;
        justify-content: space-between;
    }

    .form-label {
        width: 200px;
        color: #666;
        font-weight: 500;
        margin-bottom: 0;
    }

    .form-value {
        flex: 1;
        color: #333;
        font-weight: 400;
        word-break: break-word;
    }

    .status {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 0.9em;
        font-weight: bold;
        color: white;
    }

    .status.paid {
        background-color: #28a745;
    }

    .status.pending {
        background-color: #ffc107;
    }

    .status.failed {
        background-color: #dc3545;
    }

    .date-badge {
        font-size: 12px;
        color: #6c757d;
        font-weight: normal;
        margin-top: 5px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
            padding: 15px;
        }

        .content-area {
            padding: 0 15px 15px;
        }

        .page-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .form-row {
            flex-direction: column;
            align-items: flex-start;
            gap: 5px;
        }

        .form-label {
            width: 100%;
        }

        .form-value {
            width: 100%;
        }
    }
</style>


<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Order Details</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('sales_dash.php')">Dashboard</a>
            <span class="breadcrumb-separator">></span>
            <a href="#" onclick="navigateTo('sales_cutomers.php')">Customers</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current">Order Details</span>
        </nav>

        <?php if ($order_details): ?>
            <!-- Page Header -->
            <div class="page-header">
                <h1 class="page-title">Order #<?= htmlspecialchars($order_details->sales_order_id ?: 'N/A') ?></h1>
            </div>

            <div class="row">
                <!-- Left Column -->
                <div class="col-md-6">
                    <!-- Customer Information -->
                    <div class="info-card">
                        <div class="card-header">
                            <div>
                                <p>Customer Information</p>
                                <p class="date-badge">Payment Date:
                                    <?= $order_details->payment_date ? date('F j, Y H:i', strtotime($order_details->payment_date)) : 'N/A' ?>
                                </p>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-label">Name</div>
                                <div class="form-value"><?= htmlspecialchars($order_details->name ?: '-') ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Email</div>
                                <div class="form-value"><?= htmlspecialchars($order_details->email ?: '-') ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Phone</div>
                                <div class="form-value"><?= htmlspecialchars($order_details->phone ?: '-') ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Address</div>
                                <div class="form-value"><?= htmlspecialchars($order_details->address ?: '-') ?></div>
                            </div>
                            <?php if ($order_details->appointment_date): ?>
                                <div class="form-row">
                                    <div class="form-label">Installation Date</div>
                                    <div class="form-value"><?= htmlspecialchars($order_details->appointment_date) ?></div>
                                </div>
                            <?php endif; ?>
                            <div class="form-row">
                                <div class="form-label">Payment Status</div>
                                <div class="form-value">
                                    <span class="status <?= strtolower($order_details->status) ?>">
                                        <?= ucfirst(htmlspecialchars($order_details->status)) ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-6">
                    <!-- Order Summary -->
                    <div class="info-card">
                        <div class="card-header">
                            <p>Order Summary</p>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-label">Transaction ID</div>
                                <div class="form-value"><?= htmlspecialchars($order_details->transaction_id ?: '-') ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Sales Order ID</div>
                                <div class="form-value"><?= htmlspecialchars($order_details->sales_order_id ?: '-') ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Plan</div>
                                <div class="form-value">
                                    <?= htmlspecialchars($order_details->plan_name ?: '-') ?>
                                    <?php if ($order_details->plan_type): ?>
                                        (<?= htmlspecialchars($order_details->plan_type) ?>)
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Plan Amount</div>
                                <div class="form-value">₦<?= number_format($order_details->plan_amount, 2) ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">OTC Cost</div>
                                <div class="form-value">₦<?= number_format($order_details->otc_cost, 2) ?></div>
                            </div>

                            <?php if (!$isInternalAgent): ?>
                                <div class="form-row">
                                    <div class="form-label">Commission Amount</div>
                                    <div class="form-value">₦
                                        <?= number_format($order_details->agent_commission, 2) ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="form-row"
                                style="font-weight: bold; background-color: #f0f0f0; padding: 8px; margin-top: 10px;">
                                <div class="form-label">Total Amount</div>
                                <div class="form-value">₦<?= number_format($order_details->total_amount, 2) ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="info-card">
                <div class="card-header">
                    <p>Error</p>
                </div>
                <div class="card-body" style="text-align: center;">
                    <h2 style="color: #dc3545;">Order Not Found</h2>
                    <p>No order details available.</p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>

    // Navigation function
    function navigateTo(page) {
        window.location.href = page;
    }


</script>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>