<?PHP
$page = "MArketplace Admin Dashboard";
$page_url = "marketdashboard";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'vendor_dashboard';
    </script>
    <?PHP
    exit();
endif;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
//$locations = $dashboard->getLocations();
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$overview = $dashboard->getAdminDashboardOverview();
$pendingVendors = $dashboard->getLastPendingVendors();


//$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>

<!-- <style>
    .stateName {
        padding-left: 3px !important;

    }

    .nTranxContainer {
        text-align: right;
    }

    .stat-table {
        font-size: 0.8em;
    }

    .stat-table>table>thead {
        background-color: #0f1d77;
        color: white;
    }

    .box {
        border-radius: 7px;
        -webkit-box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        -moz-box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
    }

    .box .overlay {
        background: rgba(255, 255, 255, 0.85);
        border-radius: 6px;
    }

    .lastone,
    .lastone>.box,
    .lastone>.box>.box-footer {
        background-color: #eee !important;
        /*#144b90*/
        /* 	border-top: 0px; */
    }

    .widget-user .widget-user-image>span {
        width: 90px;
        height: auto;
        border: 3px solid #fff;
        vertical-align: middle;
        padding: 15px 15px;
        font-size: 1.2em;
    }

    .widget-user .box-footer {
        padding-top: 1px;
        height: 130px;
        /* 155px;*/
    }

    .widget-user .widget-user-header {
        padding: 10px !important;
        min-height: 60px !important;
        border-top-left-radius: 20px;
    }

    .box .border-right {
        border-right: 1px solid #e6d8d8;
    }

    .border-bottom {
        border-bottom: 1px solid #e6d8d8;
    }

    .border-top {
        border-top: 1px solid #e6d8d8;
    }

    .nav-stacked>li>a {
        /*     font-size: 1.2em;  */
    }

    .nav-stacked>li>a>span {
        /*font-size: 1.1em; */
    }

    .widget-user .widget-user-image {
        left: 55% !important;
    }

    .widget-user .widget-user-username {
        font-size: 15px !important;
        /*20px*/
        font-weight: 500 !important;
    }

    .center-box {
        -webkit-border-radius: 20px;
        -moz-border-radius: 20px;
        border-radius: 20px;
    }

    .description-block>.description-header {
        font-size: 0.8em !important;
    }

    .description-block>.description-text {
        font-size: 0.8em !important;
    }

    .description-block {
        cursor: pointer;
        /*font-size: 0.7em !important;*/
    }

    .description-block:hover {
        background-color: #e1f1f5 !important;
    }

    .vmiddle {
        padding-top: 30px;
    }

    .col-sm-4,
    .col-sm-6 {
        padding-left: 5px !important;
        padding-right: 5px !important;
    }

    .widget-user-image {
        display: none;
    }

    .progress-description {
        font-size: 1.2em;
        font-weight: bolder;
    }

    .progress-description>.subtext {
        float: right !important;
        font-weight: normal;
        font-size: 0.8em;
        display: inline-block;
    }

    .progress-description>.subvalue {
        /*float: right !important;*/
        font-weight: normal;
        font-size: 0.8em;
        display: inline-block;
    }

    .row>.width-20p {
        width: 19%;
        display: inline-block;
    }

    .gray-bg {
        background-color: lightgray !important;
    }

    .widget-user .box-footer {
        padding-top: 0px;
        border-bottom-right-radius: 20px;
    }

    .row {
        margin-left: -10px;
        margin-right: -10px;
    }

    .box.box-widget {
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        background-color: #e1e1e1;
    }

    .micon {
        font-size: 0.8em;
        margin-right: 3px;
    }

    .amountBlock {
        text-align: right;
    }

    .iSelect {
        border: 2px outset #aaa2a2;
        -webkit-box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.4);
        -moz-box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.4);
    }

    .downloadIcon {
        color: #d81b60;
        font-size: 0.8em;
        margin-left: 5px;
        cursor: pointer;
    }

    .nolink {
        cursor: auto;
    }

    .stateName .col-sm-5 {
        padding-right: 1px;
    }

    .nTranxContainer .col-sm-2 {
        padding-left: 5px;
    }
</style> -->

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-header {
        background-color: #ffffff;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 0;
    }

    .top-header h2 {
        margin: 0;
        color: #333;
        font-size: 24px;
        font-weight: 400;
    }

    .content-area {
        padding: 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        /* background: white; */
        border-radius: 8px;
        padding: 25px;
        /* box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); */
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .vendor-section {
        background: white;
        border-radius: 8px;
        border: 1px solid #e9ecef;
        overflow: hidden;
    }

    .vendor-header {
        padding: 20px 25px;
        border-bottom: 1px solid #e9ecef;
        background-color: #fafafa;
    }

    .vendor-header h4 {
        margin: 0 0 5px 0;
        color: #333;
        font-size: 18px;
        font-weight: 500;
    }

    .vendor-header p {
        margin: 0;
        color: #6c757d;
        font-size: 14px;
    }

    .vendor-list {
        padding: 0;
    }

    .vendor-item {
        padding: 18px 25px;
        border-bottom: 1px solid #f1f1f1;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .vendor-item:last-child {
        border-bottom: none;
    }

    .vendor-info h5 {
        margin: 0 0 4px 0;
        color: #333;
        font-size: 15px;
        font-weight: 500;
    }

    .vendor-info p {
        margin: 0;
        color: #6c757d;
        font-size: 13px;
    }

    .vendor-address {
        color: #9ca3af;
        font-size: 13px;
    }

    .btn-view {
        background-color: #337ab7;
        color: white;
        border: none;
        padding: 6px 16px;
        border-radius: 4px;
        font-size: 13px;
        text-decoration: none;
        transition: background-color 0.2s;
    }

    .btn-view:hover {
        background-color: #2c5aa0;
        color: white;
        text-decoration: none;
    }
</style>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Header -->
    <div class="top-header">
        <h2>Dashboard</h2>
    </div>
    <div class="content-area">
        <!-- Stats Cards -->
        <div class="row stats-row">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Total Vendors</div>
                        <div class="stat-icon">
                            <i class="fa fa-dollar"></i>
                        </div>
                    </div>

                    <div class="stat-value"><?= number_format($overview['total_vendors']) ?></div>
                    <div class="stat-label">Sum of all vendors on Fiberone</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Total Products</div>
                        <div class="stat-icon">
                            <i class="fa fa-shopping-cart"></i>
                        </div>
                    </div>

                    <div class="stat-value"><?= number_format($overview['total_products']) ?></div>
                    <div class="stat-label">Sum of all products on Fiberone</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div> <?= htmlspecialchars($overview['top_selling_product'] ?? 'N/A') ?></div>
                        <div class="stat-icon">
                            <i class="fa fa-star"></i>
                        </div>
                    </div>

                    <div class="stat-value"></div>
                    <div class="stat-label">Product driving the most sales</div>
                </div>
            </div>
        </div>

        <!-- Vendor Request Section -->
        <div class="vendor-section">
            <div class="vendor-header">
                <h4>Vendor Request</h4>
                <p>Recent sales from your store</p>
            </div>

            <?php if (!empty($pendingVendors)): ?>
                <div class="vendor-list">
                    <?php foreach ($pendingVendors as $vendor): ?>
                        <div class="vendor-item">
                            <div class="vendor-info">
                                <h5><?= $vendor->name ?></h5>
                                <p><?= $vendor->email ?></p>
                            </div>
                            <div class="vendor-address">
                                <?= $vendor->address ?>
                            </div>
                            <div>
                                <a href="#" class="btn-view">View</a>
                            </div>
                        </div>
                    <?php endforeach; ?>



                </div>
            <?php else: ?>
                <p>No pending vendors at the moment.</p>
            <?php endif; ?>

        </div>
    </div>
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script>
    $(document).ready(function () {
        // Mobile sidebar toggle



        // View button click handlers
        $(".btn-view").click(function (e) {
            e.preventDefault();
            alert("View vendor details functionality would be implemented here.");
        });
    });



</script>


<?PHP
include_once 'includes/footer_end.php';
