<?PHP
$page = "MArketplace Admin Dashboard";
$page_url = "marketdashboard";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'vendor_dashboard';
    </script>
    <?PHP
    exit();
endif;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
//$locations = $dashboard->getLocations();
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$overview = $dashboard->getAdminDashboardOverview();
$pendingVendors = $dashboard->getLastPendingVendors();


//$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>


<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-header {
        background-color: #ffffff;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 0;
    }

    .top-header h2 {
        margin: 0;
        color: #333;
        font-size: 24px;
        font-weight: 400;
    }

    .content-area {
        padding: 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        /* background: white; */
        border-radius: 8px;
        padding: 25px;
        /* box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); */
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .vendor-section {
        background: white;
        border-radius: 8px;
        border: 1px solid #e9ecef;
        overflow: hidden;
    }

    .vendor-header {
        padding: 20px 25px;
        border-bottom: 1px solid #e9ecef;
        background-color: #fafafa;
    }

    .vendor-header h4 {
        margin: 0 0 5px 0;
        color: #333;
        font-size: 18px;
        font-weight: 500;
    }

    .vendor-header p {
        margin: 0;
        color: #6c757d;
        font-size: 14px;
    }

    .vendor-list {
        padding: 0;
    }

    .vendor-item {
        padding: 18px 25px;
        border-bottom: 1px solid #f1f1f1;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .vendor-item:last-child {
        border-bottom: none;
    }

    .vendor-info h5 {
        margin: 0 0 4px 0;
        color: #333;
        font-size: 15px;
        font-weight: 500;
    }

    .vendor-info p {
        margin: 0;
        color: #6c757d;
        font-size: 13px;
    }

    .vendor-address {
        color: #9ca3af;
        font-size: 13px;
    }

    .btn-view {
        background-color: #337ab7;
        color: white;
        border: none;
        padding: 6px 16px;
        border-radius: 4px;
        font-size: 13px;
        text-decoration: none;
        transition: background-color 0.2s;
    }

    .btn-view:hover {
        background-color: #2c5aa0;
        color: white;
        text-decoration: none;
    }
</style>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Header -->
    <div class="top-header">
        <h2>Dashboard</h2>
    </div>
    <div class="content-area">
        <!-- Stats Cards -->
        <div class="row stats-row">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Total Vendors</div>
                        <div class="stat-icon">
                            <i class="fa fa-users"></i>
                        </div>
                    </div>

                    <div class="stat-value"><?= number_format($overview['total_vendors']) ?></div>
                    <div class="stat-label">Sum of all vendors on Fiberone</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Total Products</div>
                        <div class="stat-icon">
                            <i class="fa fa-shopping-cart"></i>
                        </div>
                    </div>

                    <div class="stat-value"><?= number_format($overview['total_products']) ?></div>
                    <div class="stat-label">Sum of all products on Fiberone</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Top Selling Product</div>
                        <div class="stat-icon">
                            <i class="fa fa-star"></i>
                        </div>
                    </div>

                    <div class="stat-value"> <?= htmlspecialchars($overview['top_selling_product'] ?? 'N/A') ?></div>
                    <div class="stat-label">Product driving the most sales</div>
                </div>
            </div>
        </div>

        <!-- Vendor Request Section -->
        <div class="vendor-section">
            <div class="vendor-header">
                <h4>Vendor Request</h4>
                <p>Last four pending vendor requests</p>
            </div>

            <?php if (!empty($pendingVendors)): ?>
                <div class="vendor-list">
                    <?php foreach ($pendingVendors as $vendor): ?>
                        <div class="vendor-item">
                            <div class="vendor-info">
                                <h5><?= $vendor->name ?></h5>
                                <p><?= $vendor->email ?></p>
                            </div>
                            <div class="vendor-address">
                                <?= $vendor->address ?>
                            </div>
                            <div>
                                <a class="btn-view"
                                    href="vendor_detail.php?id=<?= urlencode(base64_encode($vendor->id)) ?>">View Vendor</a>
                            </div>
                        </div>
                    <?php endforeach; ?>



                </div>
            <?php else: ?>
                <p style="text-align:center; padding: 10px;">No pending vendors at the moment.</p>
            <?php endif; ?>

        </div>
    </div>
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script>
    $(document).ready(function () {
        // Mobile sidebar toggle


    });



</script>


<?PHP
include_once 'includes/footer_end.php';
