<?PHP
$page = "MArketplace Admin Dashboard";
$page_url = "marketdashboard";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
?>
    <script>
        window.location.href = 'vendor_dashboard';
    </script>
<?PHP
    exit();
endif;
if (isset($_SESSION[$sid . 'usertype_id']) && $_SESSION[$sid . 'usertype_id'] == 21):
?>
    <script>
        window.location.href = 'sales_dash_internal';
    </script>
<?php
    exit();
endif;
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
//$locations = $dashboard->getLocations();
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$overview = $dashboard->getAdminDashboardOverview();
$pendingVendors = $dashboard->getLastPendingVendors();
//print_r($_SESSION[$sid . 'userid']);
//print_r($_SESSION[$sid . 'usertype_id']);
//$mmdat = $ad->getTransactions("", 0, 20);
$adminId = $_SESSION[$sid . 'userid'];
$accessLevel = $_SESSION[$sid . 'usertype_id'];
$getteamhearachy = $dashboard->getTeamHierarchy($adminId, $accessLevel);
$isTeamLead = ($accessLevel == 20);
$salesList = $dashboard->getUnassignedSalesExecs();

$sales_team_members = [];

if ($accessLevel == 18) {
    foreach ($getteamhearachy as $team) {
        if (!empty($team['sales_team'])) {
            $sales_team_members = array_merge(
                $sales_team_members,
                $team['sales_team']
            );
        }
    }
} else {
    $sales_team_members = $getteamhearachy[0]['sales_team'] ?? [];
}

//$sales_team_members = $getteamhearachy[0]['sales_team'];

$targetSummary = $dashboard->getTeamLeadMonthlyTargetSummary($adminId, date('Y-m-01'), $sales_team_members, $accessLevel);

$teamLeadMonthlySales = $dashboard->getTeamLeadMonthlySales($adminId, date('Y-m-01'), $sales_team_members);
$monthlytopplans = $dashboard->getTeamLeadMonthlyTopPlans($sales_team_members, date('Y-m-01'));

$totalMonthlyTarget = $targetSummary['total_target'];
$missingTargets = $targetSummary['missing_targets'];
$performancePercent = $totalMonthlyTarget > 0
    ? ($teamLeadMonthlySales / $totalMonthlyTarget) * 100
    : 0;
$teamLeadData = $dashboard->calculateTeamLeadCommission($totalMonthlyTarget, $performancePercent);
//print_r($monthlytopplans);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

//print_r($getTeamHierarchy);
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>


<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-header {
        background-color: #ffffff;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 0;
    }

    .top-header h2 {
        margin: 0;
        color: #333;
        font-size: 24px;
        font-weight: 400;
    }

    .content-area {
        padding: 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        /* background: white; */
        border-radius: 8px;
        padding: 25px;
        /* box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); */
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .team-section {
        margin-top: 40px;
    }

    .section-title {
        color: #0f172a;
        font-size: 20px;
        font-weight: 600;
        margin-bottom: 25px;
        padding-bottom: 10px;
        border-bottom: 2px solid #e9ecef;
    }

    .team-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        margin-bottom: 20px;
        border: 1px solid #e9ecef;
    }

    .team-card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 15px 20px;
        color: white;
        font-weight: 600;
        font-size: 16px;
    }

    .team-card-body {
        padding: 0;
    }

    .team-member-item {
        padding: 15px 20px;
        border-bottom: 1px solid #f1f1f1;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: background-color 0.2s;
    }

    .team-member-item:hover {
        background-color: #f8f9fa;
    }

    .team-member-item:last-child {
        border-bottom: none;
    }

    .team-member-item a {
        color: #333;
        text-decoration: none;
        font-weight: 500;
        font-size: 14px;
        transition: color 0.2s;
    }

    .team-member-item a:hover {
        color: #667eea;
    }

    .missing-target-badge {
        display: inline-block;
        background-color: #ffc107;
        color: #856404;
        font-size: 10px;
        font-weight: 600;
        padding: 2px 6px;
        border-radius: 3px;
        margin-left: 8px;
        text-transform: uppercase;
    }

    .btn-remove {
        background-color: #dc3545;
        color: white;
        border: none;
        padding: 6px 14px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 500;
        cursor: pointer;
        transition: background-color 0.2s;
    }

    .btn-remove:hover {
        background-color: #c82333;
    }

    .empty-team {
        padding: 30px 20px;
        text-align: center;
        color: #6c757d;
        font-style: italic;
    }

    .assign-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        padding: 25px;
        margin-top: 30px;
        border: 1px solid #e9ecef;
    }

    .assign-section h3 {
        color: #0f172a;
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 20px;
    }

    .assign-form {
        display: flex;
        gap: 10px;
        align-items: flex-start;
        flex-wrap: wrap;
    }

    .assign-form select {
        flex: 1;
        min-width: 250px;
        padding: 10px 15px;
        border: 1px solid #e9ecef;
        border-radius: 4px;
        font-size: 14px;
    }

    .btn-assign {
        background-color: #667eea;
        color: white;
        border: none;
        padding: 10px 25px;
        border-radius: 4px;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        transition: background-color 0.2s;
    }

    .btn-assign:hover {
        background-color: #5568d3;
    }

    #assignMsg {
        margin-top: 10px;
        padding: 10px 15px;
        border-radius: 4px;
        font-size: 14px;
        display: none;
    }

    #assignMsg.success {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
        display: block;
    }

    #assignMsg.error {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
        display: block;
    }

    /* Confirmation Modal */
    .modal-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 9999;
        justify-content: center;
        align-items: center;
    }

    .modal-overlay.active {
        display: flex;
    }

    .modal-content {
        background: white;
        border-radius: 8px;
        padding: 30px;
        max-width: 400px;
        width: 90%;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        animation: modalSlideIn 0.3s ease-out;
    }

    @keyframes modalSlideIn {
        from {
            transform: translateY(-50px);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .modal-header {
        margin-bottom: 20px;
    }

    .modal-header h3 {
        margin: 0;
        color: #dc3545;
        font-size: 20px;
        font-weight: 600;
    }

    .modal-body {
        margin-bottom: 25px;
        color: #333;
        font-size: 15px;
        line-height: 1.5;
    }

    .modal-footer {
        display: flex;
        gap: 10px;
        justify-content: flex-end;
    }

    .btn-modal {
        padding: 10px 20px;
        border-radius: 4px;
        border: none;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s;
    }

    .btn-modal-cancel {
        background-color: #6c757d;
        color: white;
    }

    .btn-modal-cancel:hover {
        background-color: #5a6268;
    }

    .btn-modal-confirm {
        background-color: #dc3545;
        color: white;
    }

    .btn-modal-confirm:hover {
        background-color: #c82333;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }

        .assign-form {
            flex-direction: column;
        }

        .assign-form select {
            width: 100%;
        }

        .btn-assign {
            width: 100%;
        }
    }
</style>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Header -->
    <div class="top-header">
        <h2>Dashboard</h2>
    </div>
    <div class="content-area">
        <!-- Stats Cards -->
        <div class="row stats-row">
            <div>

                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Monthly Sales</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦<?= number_format($teamLeadMonthlySales ?? 0) ?></div>
                        <div class="stat-label">Since you signed up</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Commission this month</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦<?= number_format($teamLeadData['commission'] ?? 0, 2) ?></div>
                        <div class="stat-label">since beginning of the month</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Monthly Target</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦<?= number_format($totalMonthlyTarget ?? 0) ?></div>
                        <div class="stat-label">since beginning of the month</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div> Monthly Performance</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= number_format($performancePercent ?? 0) ?>%</div>
                        <div class="stat-label">since beginning of the month</div>
                    </div>
                </div>
            </div>
        </div>


        <div class="team-section">
            <div>
                <h2 class="section-title">Monthly Performance</h2>

                <div class="row">
                    <div class="col-md-4">
                        <div class="team-card">
                            <div class="team-card-header">
                                Top Performing Plans
                            </div>
                            <div class="team-card-body ">
                                <?php
                                // Fetch top-performing plans for the month
                                $monthlytopplans = $dashboard->getTeamLeadMonthlyTopPlans($sales_team_members, date('Y-m-01'));

                                if (!empty($monthlytopplans)):
                                ?>
                                    <ul class="top-plans-list" style="list-style: none; padding-left: 0;">
                                        <?php foreach ($monthlytopplans as $index => $plan): ?>
                                            <li style="margin-bottom: 10px; padding: 10px; border-radius: 5px; 
                                <?= $index < 3 ? 'background-color: #d4edda;' : 'background-color: #f8f9fa;' ?>;">
                                                <strong><?= htmlspecialchars($plan['plan_name']) ?></strong>
                                                <span class="plan-revenue" style="margin-left: 10px;">
                                                    N<?= number_format($plan['total_revenue'], 2) ?>
                                                </span>
                                                <span class="plan-orders" style="margin-left: 10px; color: #6c757d;">
                                                    (<?= (int)$plan['total_orders'] ?> orders)
                                                </span>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php else: ?>
                                    <div class="empty-plans" style="padding: 20px; text-align: center;">
                                        No sales for this month yet.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </div>


        <!-- Team Section -->
        <div class="team-section">
            <div>
                <h2 class="section-title">Team Members</h2>

                <div class="row">
                    <?php
                    // Collect all missing targets into an array for easy lookup
                    $allMissingTargets = array_merge(
                        $missingTargets ?? [],
                        $teamLeadData['missing_targets'] ?? []
                    );
                    $allMissingTargets = array_unique($allMissingTargets);

                    if (!empty($getteamhearachy)):
                    ?>
                        <?php foreach ($getteamhearachy as $group): ?>
                            <div class="col-md-4">
                                <div class="team-card">
                                    <div class="team-card-header">
                                        <?php
                                        echo $group['team_lead']
                                            ? htmlspecialchars($group['team_lead']->team_lead_name)
                                            : "Sales Team";
                                        ?>
                                    </div>
                                    <div class="team-card-body">
                                        <?php if (!empty($group['sales_team'])): ?>
                                            <?php foreach ($group['sales_team'] as $sales): ?>
                                                <div class="team-member-item">
                                                    <div>
                                                        <a href="sales-exec-detail.php?id=<?= (int) $sales->sales_id ?>">
                                                            <?= htmlspecialchars($sales->sales_name) ?>
                                                        </a>
                                                        <?php if (in_array($sales->sales_name, $allMissingTargets)): ?>
                                                            <span class="missing-target-badge" title="Missing Target">
                                                                No Target
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php if ($isTeamLead): ?>
                                                        <button class="btn-remove" onclick="removeSales(<?= (int) $sales->sales_id ?>)">
                                                            Remove
                                                        </button>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <div class="empty-team">
                                                No sales executives assigned
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="empty-team"
                                style="background: white; border-radius: 8px; padding: 40px; text-align: center;">
                                No team members found.
                            </div>
                        </div>
                    <?php endif; ?>
                </div>


            </div>
        </div>

        <!-- Assign Section -->
        <?php if ($isTeamLead): ?>
            <div class="assign-section">
                <h3>Assign New Sales Executive</h3>
                <div class="assign-form">
                    <select id="salesSelect" required>
                        <option value="">Select Sales Executive</option>
                        <?php foreach ($salesList as $sales): ?>
                            <option value="<?= (int) $sales->AID ?>">
                                <?= htmlspecialchars($sales->FULLNAME) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <button id="assignBtn" class="btn-assign">Assign</button>
                </div>
                <div id="assignMsg"></div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Confirmation Modal -->
<div class="modal-overlay" id="confirmModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Confirm Removal</h3>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to remove <strong id="salesExecName"></strong> from your team?</p>
        </div>
        <div class="modal-footer">
            <button class="btn-modal btn-modal-cancel" onclick="closeConfirmModal()">Cancel</button>
            <button class="btn-modal btn-modal-confirm" id="confirmRemoveBtn">Remove</button>
        </div>
    </div>
</div>

<?PHP include_once 'includes/footer.php'; ?>
<script>
    let salesIdToRemove = null;

    function closeConfirmModal() {
        $('#confirmModal').removeClass('active');
    }

    function removeSales(sales_id) {
        // Get the sales exec name
        var salesName = $('button[onclick="removeSales(' + sales_id + ')"]').parent().find('a').text().trim();

        // Set up modal
        salesIdToRemove = sales_id;
        $('#salesExecName').text(salesName);
        $('#confirmModal').addClass('active');
    }

    // Close modal on overlay click
    $('#confirmModal').click(function(e) {
        if (e.target.id === 'confirmModal') {
            closeConfirmModal();
            salesIdToRemove = null;
        }
    });

    $(document).ready(function() {
        // Confirm removal
        $('#confirmRemoveBtn').click(function() {
            if (!salesIdToRemove) return;

            var salesIdCopy = salesIdToRemove;
            closeConfirmModal();
            salesIdToRemove = null;

            // Show loading state
            var $button = $('button[onclick="removeSales(' + salesIdCopy + ')"]');
            var originalText = $button.text();
            $button.text('Removing...').prop('disabled', true);

            $.ajax({
                url: 'ajax/assign_remove_exec.php',
                type: 'POST',
                data: {
                    sales_id: salesIdCopy
                },
                success: function(response) {
                    console.log('Server response:', response);

                    // Try to parse response as JSON
                    var data;
                    try {
                        data = typeof response === 'string' ? JSON.parse(response) : response;
                    } catch (e) {
                        console.error('JSON parse error:', e);
                        // If not JSON, treat as error
                        $button.text(originalText).prop('disabled', false);
                        $('#assignMsg').text('Invalid response from server: ' + response)
                            .removeClass('success').addClass('error').show();
                        setTimeout(function() {
                            $('#assignMsg').fadeOut();
                        }, 4000);
                        return;
                    }

                    if (data && data.success) {
                        // Get sales exec info before removing
                        var removedName = $button.parent().find('a').text().trim();

                        // Fade out and remove the item
                        $button.closest('.team-member-item').fadeOut(300, function() {
                            $(this).remove();

                            // Check if team card is now empty
                            var $teamCard = $('.team-card-body');
                            if ($teamCard.find('.team-member-item:visible').length === 0) {
                                $teamCard.html('<div class="empty-team">No sales executives assigned</div>');
                            }
                        });

                        // Show success message
                        $('#assignMsg').text(data.message || 'Sales Executive removed successfully')
                            .removeClass('error').addClass('success').show();

                        // Add removed sales exec back to dropdown if it exists
                        if ($('#salesSelect').length) {
                            $('#salesSelect').append('<option value="' + salesIdToRemove + '">' + removedName + '</option>');
                        }

                        setTimeout(function() {
                            $('#assignMsg').fadeOut();
                        }, 4000);
                    } else {
                        // Restore button
                        $button.text(originalText).prop('disabled', false);

                        $('#assignMsg').text((data && data.message) || 'Failed to remove Sales Executive')
                            .removeClass('success').addClass('error').show();

                        setTimeout(function() {
                            $('#assignMsg').fadeOut();
                        }, 4000);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', status, error);
                    console.error('Response:', xhr.responseText);

                    // Restore button
                    $button.text(originalText).prop('disabled', false);

                    $('#assignMsg').text('Error removing Sales Executive. Please try again.')
                        .removeClass('success').addClass('error').show();

                    setTimeout(function() {
                        $('#assignMsg').fadeOut();
                    }, 4000);
                }
            });

            salesIdToRemove = null;
        });

        // Assign sales executive
        $('#assignBtn').click(function(e) {
            e.preventDefault();

            var sales_id = $('#salesSelect').val();
            var sales_name = $('#salesSelect option:selected').text();

            if (!sales_id) {
                $('#assignMsg').text('Please select a Sales Executive')
                    .removeClass('success').addClass('error').show();

                setTimeout(function() {
                    $('#assignMsg').fadeOut();
                }, 3000);
                return;
            }

            // Show loading state
            var $btn = $(this);
            var originalText = $btn.text();
            $btn.text('Assigning...').prop('disabled', true);

            $.ajax({
                url: 'ajax/assign_sales_exec.php',
                type: 'POST',
                data: {
                    sales_id: sales_id
                },
                dataType: 'text',
                success: function(response) {
                    // Restore button
                    $btn.text(originalText).prop('disabled', false);

                    // Try to parse as JSON first, fall back to text
                    var message = response;
                    try {
                        var jsonResponse = JSON.parse(response);
                        if (jsonResponse.message) {
                            message = jsonResponse.message;
                        }
                    } catch (e) {
                        // Use response as is
                    }

                    $('#assignMsg').text(message || 'Sales Executive assigned successfully')
                        .removeClass('error').addClass('success').show();

                    // Find the first team card and add new member
                    var $firstTeamCard = $('.team-card-body').first();

                    // Remove "no executives" message if present
                    $firstTeamCard.find('.empty-team').remove();

                    // Add new team member
                    var newItem = `<div class="team-member-item" style="display: none;">
                                       <div>
                                           <a href="sales-exec-detail.php?id=` + sales_id + `">` + sales_name + `</a>
                                       </div>
                                       <button class="btn-remove" onclick="removeSales(` + sales_id + `)">Remove</button>
                                   </div>`;
                    $firstTeamCard.append(newItem);
                    $firstTeamCard.find('.team-member-item:last').fadeIn(300);

                    // Remove from dropdown and reset
                    $('#salesSelect option:selected').remove();
                    $('#salesSelect').val('');

                    setTimeout(function() {
                        $('#assignMsg').fadeOut();
                    }, 4000);
                },
                error: function(xhr, status, error) {
                    // Restore button
                    $btn.text(originalText).prop('disabled', false);

                    $('#assignMsg').text('Error assigning Sales Executive. Please try again.')
                        .removeClass('success').addClass('error').show();

                    setTimeout(function() {
                        $('#assignMsg').fadeOut();
                    }, 4000);
                }
            });
        });
    });
</script>


<?PHP
include_once 'includes/footer_end.php';
