<?PHP  
$page = "List of User Invoice(s)";
$page_url="invoices";
include_once 'includes/header.php'; 
include_once 'includes/sidemenu.php'; 

$not_done = 'label-danger';
$done = 'label-success';
$partial = 'label-warning';

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);

$invs = $ad->loadInvoiceByUser($_SESSION[$sid.'username']);
//$inv = $invs[0];

//$invno = "SO04595";
//$invs = $ad->loadInvoiceByID($invno); 
//$inv = $invs[0];

//$invmd = $ad->loadInvoiceMetadata($inv["INVID"]);

include_once 'includes/accesschk.php'; 

$db->close();
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper" id="minvoice">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Customer Invoice(s)
        <small>View your invoice(s)</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Invoices</a></li>
      </ol>
    </section>
    
    <!-- Main content -->
        <section class="content">
        <div class="row">
            <div class="col-md-12">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Customer Invoice List</h3>
                </div>
                <div class="box-body">
                    <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                        <thead>
                        <tr>
                            <th>SN</th>
                            <th class="center">INVOICE DATE</th>
                            <th class="center">INVOICE NO</th>
                            <th style="text-align: center !important;">INVOICE TOTAL</th> 
                            <th style="text-align: center !important;">SALES PERSON</th>  
                            <th class="center" style="text-align: center !important;">STATUS</th>                         
                            <th class="center" style="text-align: center !important;">ACTION</th>
                        </tr>
                        </thead>
                        <tbody>
<?PHP
            $sn = 0;
            foreach ($invs as $key => $inv) :
              /*
               * $ret[] = array("INVOICENO"=>$row->ORDERNO, "FIRSTNAME"=>$row->firstname, "ADDRESS" => $row->address, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "COMPANY"=> $row->company,
                        "INVID"=> $row->INVID, "ORDER_ERPID"=> $row->ORDER_ERPID, "INVOICE_TOTAL"=> $row->INVOICE_TOTAL,
                         "SALESPERSON"=> $row->SALESPERSON, "SALESEMAIL"=> $row->SALESEMAIL, "INVOICEDATE"=> $row->INVOICEDATE,
                        "PAID" => $row->PAID, "DATEPAID" => $row->DATEPAID, "PAY_GATEWAY" => $row->PAY_GATEWAY,
                        "PAY_REFERENCE" => $row->PAY_REFERENCE, "APPR_AMOUNT" => $row->APPR_AMOUNT );
               */
            ?>
                    <tr>
                        <td><?PHP echo ++$sn; ?></td>
                        <td class="center"><?PHP list($y, $m, $d) = sscanf($inv["INVOICEDATE"], '%d-%d-%d %s');      
                                        $invdate = "$d-$m-$y";
                                        echo $invdate; ?></td>
                        <td class="center"><?PHP echo $inv["INVOICENO"]; ?></td>                        
                        <td style="text-align: right !important;">&#8358;<?PHP echo number_format($inv["INVOICE_TOTAL"],2); ?></td>
                        <td style="text-align: center !important;"><?PHP echo $inv["SALESPERSON"]; ?></span></i></td>
                        <td  class="center " style="text-align: center !important; vertical-align:middle">
                            <span style="padding: 6px; font-size:1.1em;" class="label-default label <?PHP if (isset($inv['PAID'])) { echo ($inv['PAID']==1)? $done : $not_done; } ?>"><?PHP if (isset($inv['PAID'])) echo ($inv['PAID']==1)? "PAID" : "UNPAID";  ?></span>
                        </td>
                        <td class="center " style='font-size: 20px; text-align: center !important;'>
                            
                            <?PHP 
                            if ( ( !$_SESSION[$sid.'readonly'] ) ): // data-placement="left"
                                echo '<form id="gFormAdd' . $inv["INVOICENO"] . '" action="invoice" target="" method="post" style="display: inline-block; padding-right: 6px;">';
                                echo '<a href="javascript: submitform(\'gFormAdd' . $inv["INVOICENO"] . '\')" class="btn btn-success" title="View Invoice"  data-toggle="tooltip">
                                        View invoice
                                      </a><input type="hidden" name="invid" id="invid" value="' . $inv["INVID"] . '" />
                                        <input type="hidden" name="invno" id="invno" value="' . $inv["INVOICENO"] . '" />'; 
                                echo "</form>";   
                            else:
                                echo '<span style="margin-right:5px">&nbsp;</span>'; 

                            endif; 
                            
                            ?>
                            <!--<i class="glyphicon glyphicon-plus-sign" style="color:#999"></i>-->
                        </td>
                    </tr>
            <?PHP
            endforeach;
            ?>

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>SN</th>
                            <th class="center">INVOICE DATE</th>
                            <th class="center">INVOICE NO</th>
                            <th style="text-align: center !important;">INVOICE TOTAL</th> 
                            <th style="text-align: center !important;">SALES PERSON</th>  
                            <th class="center" style="text-align: center !important;">STATUS</th>                         
                            <th class="center" style="text-align: center !important;">ACTION</th>
                        </tr>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-12 -->
        </div>
        <!-- /.row -->
    </section>
    
    <!-- /.Main content -->
    <div class="clearfix"></div>
  </section>
    <!-- /.Main content -->
    
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script src="<?PHP echo SERVER_URL; ?>dist/js/browser.js"></script>
<script type="text/javascript">
function submitform(formname)
{
    document.forms[formname].submit();
}

   $(document).ready(function () {

        
        $('#acctable').DataTable({
//            "dom": "<'row'<'col-md-6'l><'col-md-6'f>r>t<'row'<'col-md-12'i><'col-md-12 center-block'p>>",
//            'paging'      : true,
//            'lengthChange': false,
//            'searching'   : true,
            'ordering'    : true,
//            'info'        : true,
            'autoWidth'   : false,
            "aLengthMenu": [ [50, 100, 200, -1], [50, 100, 200, "All"] ],
            "iDisplayLength": 50,
            fixedHeader: true,
            "deferRender": true,
//            dom: 'Bfrtip',
//            buttons: [
//                'copyHtml5',
//                'pdfHtml5',
//                'excelHtml5',
//                'print',
//                'pageLength'
//            ]
            dom: 'B<"clear"><"clear">lfrtip',
//            ajax: '/api/data',
            buttons: {
                name: 'primary',
                buttons: [ 'copy', 'csv', 'excel', 'print', 'pdf', 'colvis', {
                        text: 'Reload',
                        action: function ( e, dt, node, config ) {
                            dt.ajax.reload();
                        }
                    } ]
            },
            initComplete: function () {
                this.api().columns().every( function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                        .appendTo( $(column.footer()).empty() )
//                        .appendTo( $(column.header()) )
                        .on( 'change', function () {
                            var val = $.fn.dataTable.util.escapeRegex(
                                $(this).val()
                            );

                            column
                                .search( val ? '^'+val+'$' : '', true, false )
                                .draw();
                        } );

                    column.data().unique().sort().each( function ( d, j ) {
                        select.append( '<option value="'+d+'">'+d+'</option>' )
                    } );
                } );
            }
        });
   });   
   
</script>
<?PHP include_once 'includes/footer_end.php';