<?php

return [
    'language' => 'Norwegian',
    'formats' => [
        'date' => 'YYYY-MM-DD',
        'time' => 'HH:MM:SS',
        'datetime' => 'YYYY-MM-DD HH:MM:SS',
        'money' => '# ##0.00;[RED]-# ##0.00',
    ],
    'functions' => [
        'HENTPIVOTDATA' => 'GETPIVOTDATA', //Returnerer data som er lagret i en pivottabellrapport
        'KUBEKPIMEDLEM' => 'CUBEKPIMEMBER', //Returnerer navnet, egenskapen og målet for en viktig ytelsesindikator (KPI), og viser navnet og egenskapen i cellen. En KPI er en målbar enhet, for eksempel månedlig bruttoinntjening eller kvartalsvis inntjening per ansatt, og brukes til å overvåke ytelsen i en organisasjon.
        'KUBEMEDLEM' => 'CUBEMEMBER', //Returnerer et medlem eller en tuppel i et kubehierarki. Brukes til å validere at medlemmet eller tuppelen finnes i kuben.
        'KUBEMEDLEMEGENSKAP' => 'CUBEMEMBERPROPERTY', //Returnerer verdien til en medlemsegenskap i kuben. Brukes til å validere at et medlemsnavn finnes i kuben, og til å returnere den angitte egenskapen for dette medlemmet.
        'KUBERANGERTMEDLEM' => 'CUBERANKEDMEMBER', //Returnerer det n-te, eller rangerte, medlemmet i et sett. Brukes til å returnere ett eller flere elementer i et sett, for eksempel de 10 beste studentene.
        'KUBESETT' => 'CUBESET', //Definerer et beregnet sett av medlemmer eller tuppeler ved å sende et settuttrykk til kuben på serveren, noe som oppretter settet og deretter returnerer dette settet til Microsoft Office Excel.
        'KUBESETTANTALL' => 'CUBESETCOUNT', //Returnerer antallet elementer i et sett.
        'KUBEVERDI' => 'CUBEVALUE', //Returnerer en aggregert verdi fra en kube.
        'DGJENNOMSNITT' => 'DAVERAGE', //Returnerer gjennomsnittet av merkede databaseposter
        'DANTALL' => 'DCOUNT', //Teller celler som inneholder tall i en database
        'DANTALLA' => 'DCOUNTA', //Teller celler som ikke er tomme i en database
        'DHENT' => 'DGET', //Trekker ut fra en database en post som oppfyller angitte vilkår
        'DMAKS' => 'DMAX', //Returnerer maksimumsverdien fra merkede databaseposter
        'DMIN' => 'DMIN', //Returnerer minimumsverdien fra merkede databaseposter
        'DPRODUKT' => 'DPRODUCT', //Multipliserer verdiene i et bestemt felt med poster som oppfyller vilkårene i en database
        'DSTDAV' => 'DSTDEV', //Estimerer standardavviket basert på et utvalg av merkede databaseposter
        'DSTAVP' => 'DSTDEVP', //Beregner standardavviket basert på at merkede databaseposter utgjør hele populasjonen
        'DSUMMER' => 'DSUM', //Legger til tallene i feltkolonnen med poster, i databasen som oppfyller vilkårene
        'DVARIANS' => 'DVAR', //Estimerer variansen basert på et utvalg av merkede databaseposter
        'DVARIANSP' => 'DVARP', //Beregner variansen basert på at merkede databaseposter utgjør hele populasjonen
        'DATO' => 'DATE', //Returnerer serienummeret som svarer til en bestemt dato
        'DATOVERDI' => 'DATEVALUE', //Konverterer en dato med tekstformat til et serienummer
        'DAG' => 'DAY', //Konverterer et serienummer til en dag i måneden
        'DAGER360' => 'DAYS360', //Beregner antall dager mellom to datoer basert på et år med 360 dager
        'DAG.ETTER' => 'EDATE', //Returnerer serienummeret som svarer til datoen som er det indikerte antall måneder før eller etter startdatoen
        'MÅNEDSSLUTT' => 'EOMONTH', //Returnerer serienummeret som svarer til siste dag i måneden, før eller etter et angitt antall måneder
        'TIME' => 'HOUR', //Konverterer et serienummer til en time
        'MINUTT' => 'MINUTE', //Konverterer et serienummer til et minutt
        'MÅNED' => 'MONTH', //Konverterer et serienummer til en måned
        'NETT.ARBEIDSDAGER' => 'NETWORKDAYS', //Returnerer antall hele arbeidsdager mellom to datoer
        'NÅ' => 'NOW', //Returnerer serienummeret som svarer til gjeldende dato og klokkeslett
        'SEKUND' => 'SECOND', //Konverterer et serienummer til et sekund
        'TID' => 'TIME', //Returnerer serienummeret som svarer til et bestemt klokkeslett
        'TIDSVERDI' => 'TIMEVALUE', //Konverterer et klokkeslett i tekstformat til et serienummer
        'IDAG' => 'TODAY', //Returnerer serienummeret som svarer til dagens dato
        'UKEDAG' => 'WEEKDAY', //Konverterer et serienummer til en ukedag
        'UKENR' => 'WEEKNUM', //Konverterer et serienummer til et tall som representerer hvilket nummer uken har i et år
        'ARBEIDSDAG' => 'WORKDAY', //Returnerer serienummeret som svarer til datoen før eller etter et angitt antall arbeidsdager
        'ÅR' => 'YEAR', //Konverterer et serienummer til et år
        'ÅRDEL' => 'YEARFRAC', //Returnerer brøkdelen for året, som svarer til antall hele dager mellom startdato og sluttdato
        'BESSELI' => 'BESSELI', //Returnerer den endrede Bessel-funksjonen In(x)
        'BESSELJ' => 'BESSELJ', //Returnerer Bessel-funksjonen Jn(x)
        'BESSELK' => 'BESSELK', //Returnerer den endrede Bessel-funksjonen Kn(x)
        'BESSELY' => 'BESSELY', //Returnerer Bessel-funksjonen Yn(x)
        'BINTILDES' => 'BIN2DEC', //Konverterer et binært tall til et desimaltall
        'BINTILHEKS' => 'BIN2HEX', //Konverterer et binært tall til et heksadesimaltall
        'BINTILOKT' => 'BIN2OCT', //Konverterer et binært tall til et oktaltall
        'KOMPLEKS' => 'COMPLEX', //Konverterer reelle og imaginære koeffisienter til et komplekst tall
        'KONVERTER' => 'CONVERT', //Konverterer et tall fra ett målsystem til et annet
        'DESTILBIN' => 'DEC2BIN', //Konverterer et desimaltall til et binærtall
        'DESTILHEKS' => 'DEC2HEX', //Konverterer et heltall i 10-tallsystemet til et heksadesimalt tall
        'DESTILOKT' => 'DEC2OCT', //Konverterer et heltall i 10-tallsystemet til et oktaltall
        'DELTA' => 'DELTA', //Undersøker om to verdier er like
        'FEILF' => 'ERF', //Returnerer feilfunksjonen
        'FEILFK' => 'ERFC', //Returnerer den komplementære feilfunksjonen
        'GRENSEVERDI' => 'GESTEP', //Tester om et tall er større enn en terskelverdi
        'HEKSTILBIN' => 'HEX2BIN', //Konverterer et heksadesimaltall til et binært tall
        'HEKSTILDES' => 'HEX2DEC', //Konverterer et heksadesimalt tall til et heltall i 10-tallsystemet
        'HEKSTILOKT' => 'HEX2OCT', //Konverterer et heksadesimalt tall til et oktaltall
        'IMABS' => 'IMABS', //Returnerer absoluttverdien (koeffisienten) til et komplekst tall
        'IMAGINÆR' => 'IMAGINARY', //Returnerer den imaginære koeffisienten til et komplekst tall
        'IMARGUMENT' => 'IMARGUMENT', //Returnerer argumentet theta, som er en vinkel uttrykt i radianer
        'IMKONJUGERT' => 'IMCONJUGATE', //Returnerer den komplekse konjugaten til et komplekst tall
        'IMCOS' => 'IMCOS', //Returnerer cosinus til et komplekst tall
        'IMDIV' => 'IMDIV', //Returnerer kvotienten til to komplekse tall
        'IMEKSP' => 'IMEXP', //Returnerer eksponenten til et komplekst tall
        'IMLN' => 'IMLN', //Returnerer den naturlige logaritmen for et komplekst tall
        'IMLOG10' => 'IMLOG10', //Returnerer logaritmen med grunntall 10 for et komplekst tall
        'IMLOG2' => 'IMLOG2', //Returnerer logaritmen med grunntall 2 for et komplekst tall
        'IMOPPHØY' => 'IMPOWER', //Returnerer et komplekst tall opphøyd til en heltallspotens
        'IMPRODUKT' => 'IMPRODUCT', //Returnerer produktet av komplekse tall
        'IMREELL' => 'IMREAL', //Returnerer den reelle koeffisienten til et komplekst tall
        'IMSIN' => 'IMSIN', //Returnerer sinus til et komplekst tall
        'IMROT' => 'IMSQRT', //Returnerer kvadratroten av et komplekst tall
        'IMSUB' => 'IMSUB', //Returnerer differansen mellom to komplekse tall
        'IMSUMMER' => 'IMSUM', //Returnerer summen av komplekse tall
        'OKTTILBIN' => 'OCT2BIN', //Konverterer et oktaltall til et binært tall
        'OKTTILDES' => 'OCT2DEC', //Konverterer et oktaltall til et desimaltall
        'OKTTILHEKS' => 'OCT2HEX', //Konverterer et oktaltall til et heksadesimaltall
        'PÅLØPT.PERIODISK.RENTE' => 'ACCRINT', //Returnerer påløpte renter for et verdipapir som betaler periodisk rente
        'PÅLØPT.FORFALLSRENTE' => 'ACCRINTM', //Returnerer den påløpte renten for et verdipapir som betaler rente ved forfall
        'AMORDEGRC' => 'AMORDEGRC', //Returnerer avskrivningen for hver regnskapsperiode ved hjelp av en avskrivingskoeffisient
        'AMORLINC' => 'AMORLINC', //Returnerer avskrivingen for hver regnskapsperiode
        'OBLIG.DAGER.FF' => 'COUPDAYBS', //Returnerer antall dager fra begynnelsen av den rentebærende perioden til innløsningsdatoen
        'OBLIG.DAGER' => 'COUPDAYS', //Returnerer antall dager i den rentebærende perioden som inneholder innløsningsdatoen
        'OBLIG.DAGER.NF' => 'COUPDAYSNC', //Returnerer antall dager fra betalingsdato til neste renteinnbetalingsdato
        'OBLIG.DAGER.EF' => 'COUPNCD', //Returnerer obligasjonsdatoen som kommer etter oppgjørsdatoen
        'OBLIG.ANTALL' => 'COUPNUM', //Returnerer antall obligasjoner som skal betales mellom oppgjørsdatoen og forfallsdatoen
        'OBLIG.DAG.FORRIGE' => 'COUPPCD', //Returnerer obligasjonsdatoen som kommer før oppgjørsdatoen
        'SAMLET.RENTE' => 'CUMIPMT', //Returnerer den kumulative renten som er betalt mellom to perioder
        'SAMLET.HOVEDSTOL' => 'CUMPRINC', //Returnerer den kumulative hovedstolen som er betalt for et lån mellom to perioder
        'DAVSKR' => 'DB', //Returnerer avskrivningen for et aktivum i en angitt periode, foretatt med fast degressiv avskrivning
        'DEGRAVS' => 'DDB', //Returnerer avskrivningen for et aktivum for en gitt periode, ved hjelp av dobbel degressiv avskrivning eller en metode som du selv angir
        'DISKONTERT' => 'DISC', //Returnerer diskonteringsraten for et verdipapir
        'DOLLARDE' => 'DOLLARDE', //Konverterer en valutapris uttrykt som en brøk, til en valutapris uttrykt som et desimaltall
        'DOLLARBR' => 'DOLLARFR', //Konverterer en valutapris uttrykt som et desimaltall, til en valutapris uttrykt som en brøk
        'VARIGHET' => 'DURATION', //Returnerer årlig varighet for et verdipapir med renter som betales periodisk
        'EFFEKTIV.RENTE' => 'EFFECT', //Returnerer den effektive årlige rentesatsen
        'SLUTTVERDI' => 'FV', //Returnerer fremtidig verdi for en investering
        'SVPLAN' => 'FVSCHEDULE', //Returnerer den fremtidige verdien av en inngående hovedstol etter å ha anvendt en serie med sammensatte rentesatser
        'RENTESATS' => 'INTRATE', //Returnerer rentefoten av et fullfinansiert verdipapir
        'RAVDRAG' => 'IPMT', //Returnerer betalte renter på en investering for en gitt periode
        'IR' => 'IRR', //Returnerer internrenten for en serie kontantstrømmer
        'ER.AVDRAG' => 'ISPMT', //Beregner renten som er betalt for en investering i løpet av en bestemt periode
        'MVARIGHET' => 'MDURATION', //Returnerer Macauleys modifiserte varighet for et verdipapir med en antatt pålydende verdi på kr 100,00
        'MODIR' => 'MIRR', //Returnerer internrenten der positive og negative kontantstrømmer finansieres med forskjellige satser
        'NOMINELL' => 'NOMINAL', //Returnerer årlig nominell rentesats
        'PERIODER' => 'NPER', //Returnerer antall perioder for en investering
        'NNV' => 'NPV', //Returnerer netto nåverdi for en investering, basert på en serie periodiske kontantstrømmer og en rentesats
        'AVVIKFP.PRIS' => 'ODDFPRICE', //Returnerer pris pålydende kr 100 for et verdipapir med en odde første periode
        'AVVIKFP.AVKASTNING' => 'ODDFYIELD', //Returnerer avkastingen for et verdipapir med en odde første periode
        'AVVIKSP.PRIS' => 'ODDLPRICE', //Returnerer pris pålydende kr 100 for et verdipapir med en odde siste periode
        'AVVIKSP.AVKASTNING' => 'ODDLYIELD', //Returnerer avkastingen for et verdipapir med en odde siste periode
        'AVDRAG' => 'PMT', //Returnerer periodisk betaling for en annuitet
        'AMORT' => 'PPMT', //Returnerer betalingen på hovedstolen for en investering i en gitt periode
        'PRIS' => 'PRICE', //Returnerer prisen per pålydende kr 100 for et verdipapir som gir periodisk avkastning
        'PRIS.DISKONTERT' => 'PRICEDISC', //Returnerer prisen per pålydende kr 100 for et diskontert verdipapir
        'PRIS.FORFALL' => 'PRICEMAT', //Returnerer prisen per pålydende kr 100 av et verdipapir som betaler rente ved forfall
        'NÅVERDI' => 'PV', //Returnerer nåverdien av en investering
        'RENTE' => 'RATE', //Returnerer rentesatsen per periode for en annuitet
        'MOTTATT.AVKAST' => 'RECEIVED', //Returnerer summen som mottas ved forfallsdato for et fullinvestert verdipapir
        'LINAVS' => 'SLN', //Returnerer den lineære avskrivningen for et aktivum i én periode
        'ÅRSAVS' => 'SYD', //Returnerer årsavskrivningen for et aktivum i en angitt periode
        'TBILLEKV' => 'TBILLEQ', //Returnerer den obligasjonsekvivalente avkastningen for en statsobligasjon
        'TBILLPRIS' => 'TBILLPRICE', //Returnerer prisen per pålydende kr 100 for en statsobligasjon
        'TBILLAVKASTNING' => 'TBILLYIELD', //Returnerer avkastningen til en statsobligasjon
        'VERDIAVS' => 'VDB', //Returnerer avskrivningen for et aktivum i en angitt periode eller delperiode, ved hjelp av degressiv avskrivning
        'XIR' => 'XIRR', //Returnerer internrenten for en serie kontantstrømmer som ikke nødvendigvis er periodiske
        'XNNV' => 'XNPV', //Returnerer netto nåverdi for en serie kontantstrømmer som ikke nødvendigvis er periodiske
        'AVKAST' => 'YIELD', //Returnerer avkastningen på et verdipapir som betaler periodisk rente
        'AVKAST.DISKONTERT' => 'YIELDDISC', //Returnerer årlig avkastning for et diskontert verdipapir, for eksempel en statskasseveksel
        'AVKAST.FORFALL' => 'YIELDMAT', //Returnerer den årlige avkastningen for et verdipapir som betaler rente ved forfallsdato
        'CELLE' => 'CELL', //Returnerer informasjon om formatering, plassering eller innholdet til en celle
        'FEIL.TYPE' => 'ERROR.TYPE', //Returnerer et tall som svarer til en feiltype
        'INFO' => 'INFO', //Returnerer informasjon om gjeldende operativmiljø
        'ERTOM' => 'ISBLANK', //Returnerer SANN hvis verdien er tom
        'ERFEIL' => 'ISERR', //Returnerer SANN hvis verdien er en hvilken som helst annen feilverdi enn #I/T
        'ERFEIL' => 'ISERROR', //Returnerer SANN hvis verdien er en hvilken som helst feilverdi
        'ERPARTALL' => 'ISEVEN', //Returnerer SANN hvis tallet er et partall
        'ERLOGISK' => 'ISLOGICAL', //Returnerer SANN hvis verdien er en logisk verdi
        'ERIT' => 'ISNA', //Returnerer SANN hvis verdien er feilverdien #I/T
        'ERIKKETEKST' => 'ISNONTEXT', //Returnerer SANN hvis verdien ikke er tekst
        'ERTALL' => 'ISNUMBER', //Returnerer SANN hvis verdien er et tall
        'ERODDETALL' => 'ISODD', //Returnerer SANN hvis tallet er et oddetall
        'ERREF' => 'ISREF', //Returnerer SANN hvis verdien er en referanse
        'ERTEKST' => 'ISTEXT', //Returnerer SANN hvis verdien er tekst
        'N' => 'N', //Returnerer en verdi som er konvertert til et tall
        'IT' => 'NA', //Returnerer feilverdien #I/T
        'VERDITYPE' => 'TYPE', //Returnerer et tall som indikerer datatypen til en verdi
        'OG' => 'AND', //Returnerer SANN hvis alle argumentene er lik SANN
        'USANN' => 'FALSE', //Returnerer den logiske verdien USANN
        'HVIS' => 'IF', //Angir en logisk test som skal utføres
        'HVISFEIL' => 'IFERROR', //Returnerer en verdi du angir hvis en formel evaluerer til en feil. Ellers returnerer den resultatet av formelen.
        'IKKE' => 'NOT', //Reverserer logikken til argumentet
        'ELLER' => 'OR', //Returnerer SANN hvis ett eller flere argumenter er lik SANN
        'SANN' => 'TRUE', //Returnerer den logiske verdien SANN
        'ADRESSE' => 'ADDRESS', //Returnerer en referanse som tekst til en enkelt celle i et regneark
        'OMRÅDER' => 'AREAS', //Returnerer antall områder i en referanse
        'VELG' => 'CHOOSE', //Velger en verdi fra en liste med verdier
        'KOLONNE' => 'COLUMN', //Returnerer kolonnenummeret for en referanse
        'KOLONNER' => 'COLUMNS', //Returnerer antall kolonner i en referanse
        'FINN.KOLONNE' => 'HLOOKUP', //Leter i den øverste raden i en matrise og returnerer verdien for den angitte cellen
        'HYPERKOBLING' => 'HYPERLINK', //Oppretter en snarvei eller et hopp som åpner et dokument som er lagret på en nettverksserver, et intranett eller Internett
        'INDEKS' => 'INDEX', //Bruker en indeks til å velge en verdi fra en referanse eller matrise
        'INDIREKTE' => 'INDIRECT', //Returnerer en referanse angitt av en tekstverdi
        'SLÅ.OPP' => 'LOOKUP', //Slår opp verdier i en vektor eller matrise
        'SAMMENLIGNE' => 'MATCH', //Slår opp verdier i en referanse eller matrise
        'FORSKYVNING' => 'OFFSET', //Returnerer en referanseforskyvning fra en gitt referanse
        'RAD' => 'ROW', //Returnerer radnummeret for en referanse
        'RADER' => 'ROWS', //Returnerer antall rader i en referanse
        'RTD' => 'RTD', //Henter sanntidsdata fra et program som støtter COM-automatisering (automatisering: En måte å arbeide på med programobjekter fra et annet program- eller utviklingsverktøy. Tidligere kalt OLE-automatisering. Automatisering er en bransjestandard og en funksjon i Component Object Model (COM).)
        'TRANSPONER' => 'TRANSPOSE', //Returnerer transponeringen av en matrise
        'FINN.RAD' => 'VLOOKUP', //Leter i den første kolonnen i en matrise og flytter bortover raden for å returnere verdien til en celle
        'ABS' => 'ABS', //Returnerer absoluttverdien til et tall
        'ARCCOS' => 'ACOS', //Returnerer arcus cosinus til et tall
        'ARCCOSH' => 'ACOSH', //Returnerer den inverse hyperbolske cosinus til et tall
        'ARCSIN' => 'ASIN', //Returnerer arcus sinus til et tall
        'ARCSINH' => 'ASINH', //Returnerer den inverse hyperbolske sinus til et tall
        'ARCTAN' => 'ATAN', //Returnerer arcus tangens til et tall
        'ARCTAN2' => 'ATAN2', //Returnerer arcus tangens fra x- og y-koordinater
        'ARCTANH' => 'ATANH', //Returnerer den inverse hyperbolske tangens til et tall
        'AVRUND.GJELDENDE.MULTIPLUM' => 'CEILING', //Runder av et tall til nærmeste heltall eller til nærmeste signifikante multiplum
        'KOMBINASJON' => 'COMBIN', //Returnerer antall kombinasjoner for ett gitt antall objekter
        'COS' => 'COS', //Returnerer cosinus til et tall
        'COSH' => 'COSH', //Returnerer den hyperbolske cosinus til et tall
        'GRADER' => 'DEGREES', //Konverterer radianer til grader
        'AVRUND.TIL.PARTALL' => 'EVEN', //Runder av et tall oppover til nærmeste heltall som er et partall
        'EKSP' => 'EXP', //Returnerer e opphøyd i en angitt potens
        'FAKULTET' => 'FACT', //Returnerer fakultet til et tall
        'DOBBELFAKT' => 'FACTDOUBLE', //Returnerer et talls doble fakultet
        'AVRUND.GJELDENDE.MULTIPLUM.NED' => 'FLOOR', //Avrunder et tall nedover, mot null
        'SFF' => 'GCD', //Returnerer høyeste felles divisor
        'HELTALL' => 'INT', //Avrunder et tall nedover til nærmeste heltall
        'MFM' => 'LCM', //Returnerer minste felles multiplum
        'LN' => 'LN', //Returnerer den naturlige logaritmen til et tall
        'LOG' => 'LOG', //Returnerer logaritmen for et tall til et angitt grunntall
        'LOG10' => 'LOG10', //Returnerer logaritmen med grunntall 10 for et tall
        'MDETERM' => 'MDETERM', //Returnerer matrisedeterminanten til en matrise
        'MINVERS' => 'MINVERSE', //Returnerer den inverse matrisen til en matrise
        'MMULT' => 'MMULT', //Returnerer matriseproduktet av to matriser
        'REST' => 'MOD', //Returnerer resten fra en divisjon
        'MRUND' => 'MROUND', //Returnerer et tall avrundet til det ønskede multiplum
        'MULTINOMINELL' => 'MULTINOMIAL', //Returnerer det multinominelle for et sett med tall
        'AVRUND.TIL.ODDETALL' => 'ODD', //Runder av et tall oppover til nærmeste heltall som er et oddetall
        'PI' => 'PI', //Returnerer verdien av pi
        'OPPHØYD.I' => 'POWER', //Returnerer resultatet av et tall opphøyd i en potens
        'PRODUKT' => 'PRODUCT', //Multipliserer argumentene
        'KVOTIENT' => 'QUOTIENT', //Returnerer heltallsdelen av en divisjon
        'RADIANER' => 'RADIANS', //Konverterer grader til radianer
        'TILFELDIG' => 'RAND', //Returnerer et tilfeldig tall mellom 0 og 1
        'TILFELDIGMELLOM' => 'RANDBETWEEN', //Returnerer et tilfeldig tall innenfor et angitt område
        'ROMERTALL' => 'ROMAN', //Konverterer vanlige tall til romertall, som tekst
        'AVRUND' => 'ROUND', //Avrunder et tall til et angitt antall sifre
        'AVRUND.NED' => 'ROUNDDOWN', //Avrunder et tall nedover, mot null
        'AVRUND.OPP' => 'ROUNDUP', //Runder av et tall oppover, bort fra null
        'SUMMER.REKKE' => 'SERIESSUM', //Returnerer summen av en geometrisk rekke, basert på formelen
        'FORTEGN' => 'SIGN', //Returnerer fortegnet for et tall
        'SIN' => 'SIN', //Returnerer sinus til en gitt vinkel
        'SINH' => 'SINH', //Returnerer den hyperbolske sinus til et tall
        'ROT' => 'SQRT', //Returnerer en positiv kvadratrot
        'ROTPI' => 'SQRTPI', //Returnerer kvadratroten av (tall * pi)
        'DELSUM' => 'SUBTOTAL', //Returnerer en delsum i en liste eller database
        'SUMMER' => 'SUM', //Legger sammen argumentene
        'SUMMERHVIS' => 'SUMIF', //Legger sammen cellene angitt ved et gitt vilkår
        'SUMMER.HVIS.SETT' => 'SUMIFS', //Legger sammen cellene i et område som oppfyller flere vilkår
        'SUMMERPRODUKT' => 'SUMPRODUCT', //Returnerer summen av produktene av tilsvarende matrisekomponenter
        'SUMMERKVADRAT' => 'SUMSQ', //Returnerer kvadratsummen av argumentene
        'SUMMERX2MY2' => 'SUMX2MY2', //Returnerer summen av differansen av kvadratene for tilsvarende verdier i to matriser
        'SUMMERX2PY2' => 'SUMX2PY2', //Returnerer summen av kvadratsummene for tilsvarende verdier i to matriser
        'SUMMERXMY2' => 'SUMXMY2', //Returnerer summen av kvadratene av differansen for tilsvarende verdier i to matriser
        'TAN' => 'TAN', //Returnerer tangens for et tall
        'TANH' => 'TANH', //Returnerer den hyperbolske tangens for et tall
        'AVKORT' => 'TRUNC', //Korter av et tall til et heltall
        'GJENNOMSNITTSAVVIK' => 'AVEDEV', //Returnerer datapunktenes gjennomsnittlige absoluttavvik fra middelverdien
        'GJENNOMSNITT' => 'AVERAGE', //Returnerer gjennomsnittet for argumentene
        'GJENNOMSNITTA' => 'AVERAGEA', //Returnerer gjennomsnittet for argumentene, inkludert tall, tekst og logiske verdier
        'GJENNOMSNITTHVIS' => 'AVERAGEIF', //Returnerer gjennomsnittet (aritmetisk gjennomsnitt) av alle cellene i et område som oppfyller et bestemt vilkår
        'GJENNOMSNITT.HVIS.SETT' => 'AVERAGEIFS', //Returnerer gjennomsnittet (aritmetisk middelverdi) av alle celler som oppfyller flere vilkår.
        'BETA.FORDELING' => 'BETADIST', //Returnerer den kumulative betafordelingsfunksjonen
        'INVERS.BETA.FORDELING' => 'BETAINV', //Returnerer den inverse verdien til fordelingsfunksjonen for en angitt betafordeling
        'BINOM.FORDELING' => 'BINOMDIST', //Returnerer den individuelle binomiske sannsynlighetsfordelingen
        'KJI.FORDELING' => 'CHIDIST', //Returnerer den ensidige sannsynligheten for en kjikvadrert fordeling
        'INVERS.KJI.FORDELING' => 'CHIINV', //Returnerer den inverse av den ensidige sannsynligheten for den kjikvadrerte fordelingen
        'KJI.TEST' => 'CHITEST', //Utfører testen for uavhengighet
        'KONFIDENS' => 'CONFIDENCE', //Returnerer konfidensintervallet til gjennomsnittet for en populasjon
        'KORRELASJON' => 'CORREL', //Returnerer korrelasjonskoeffisienten mellom to datasett
        'ANTALL' => 'COUNT', //Teller hvor mange tall som er i argumentlisten
        'ANTALLA' => 'COUNTA', //Teller hvor mange verdier som er i argumentlisten
        'TELLBLANKE' => 'COUNTBLANK', //Teller antall tomme celler i et område.
        'ANTALL.HVIS' => 'COUNTIF', //Teller antall celler i et område som oppfyller gitte vilkår
        'ANTALL.HVIS.SETT' => 'COUNTIFS', //Teller antallet ikke-tomme celler i et område som oppfyller flere vilkår
        'KOVARIANS' => 'COVAR', //Returnerer kovariansen, gjennomsnittet av produktene av parvise avvik
        'GRENSE.BINOM' => 'CRITBINOM', //Returnerer den minste verdien der den kumulative binomiske fordelingen er mindre enn eller lik en vilkårsverdi
        'AVVIK.KVADRERT' => 'DEVSQ', //Returnerer summen av kvadrerte avvik
        'EKSP.FORDELING' => 'EXPONDIST', //Returnerer eksponentialfordelingen
        'FFORDELING' => 'FDIST', //Returnerer F-sannsynlighetsfordelingen
        'FFORDELING.INVERS' => 'FINV', //Returnerer den inverse av den sannsynlige F-fordelingen
        'FISHER' => 'FISHER', //Returnerer Fisher-transformasjonen
        'FISHERINV' => 'FISHERINV', //Returnerer den inverse av Fisher-transformasjonen
        'PROGNOSE' => 'FORECAST', //Returnerer en verdi langs en lineær trend
        'FREKVENS' => 'FREQUENCY', //Returnerer en frekvensdistribusjon som en loddrett matrise
        'FTEST' => 'FTEST', //Returnerer resultatet av en F-test
        'GAMMAFORDELING' => 'GAMMADIST', //Returnerer gammafordelingen
        'GAMMAINV' => 'GAMMAINV', //Returnerer den inverse av den gammakumulative fordelingen
        'GAMMALN' => 'GAMMALN', //Returnerer den naturlige logaritmen til gammafunksjonen G(x)
        'GJENNOMSNITT.GEOMETRISK' => 'GEOMEAN', //Returnerer den geometriske middelverdien
        'VEKST' => 'GROWTH', //Returnerer verdier langs en eksponentiell trend
        'GJENNOMSNITT.HARMONISK' => 'HARMEAN', //Returnerer den harmoniske middelverdien
        'HYPGEOM.FORDELING' => 'HYPGEOMDIST', //Returnerer den hypergeometriske fordelingen
        'SKJÆRINGSPUNKT' => 'INTERCEPT', //Returnerer skjæringspunktet til den lineære regresjonslinjen
        'KURT' => 'KURT', //Returnerer kurtosen til et datasett
        'N.STØRST' => 'LARGE', //Returnerer den n-te største verdien i et datasett
        'RETTLINJE' => 'LINEST', //Returnerer parameterne til en lineær trend
        'KURVE' => 'LOGEST', //Returnerer parameterne til en eksponentiell trend
        'LOGINV' => 'LOGINV', //Returnerer den inverse lognormale fordelingen
        'LOGNORMFORD' => 'LOGNORMDIST', //Returnerer den kumulative lognormale fordelingen
        'STØRST' => 'MAX', //Returnerer maksimumsverdien i en argumentliste
        'MAKSA' => 'MAXA', //Returnerer maksimumsverdien i en argumentliste, inkludert tall, tekst og logiske verdier
        'MEDIAN' => 'MEDIAN', //Returnerer medianen til tallene som er gitt
        'MIN' => 'MIN', //Returnerer minimumsverdien i en argumentliste
        'MINA' => 'MINA', //Returnerer den minste verdien i en argumentliste, inkludert tall, tekst og logiske verdier
        'MODUS' => 'MODE', //Returnerer den vanligste verdien i et datasett
        'NEGBINOM.FORDELING' => 'NEGBINOMDIST', //Returnerer den negative binomiske fordelingen
        'NORMALFORDELING' => 'NORMDIST', //Returnerer den kumulative normalfordelingen
        'NORMINV' => 'NORMINV', //Returnerer den inverse kumulative normalfordelingen
        'NORMSFORDELING' => 'NORMSDIST', //Returnerer standard kumulativ normalfordeling
        'NORMSINV' => 'NORMSINV', //Returnerer den inverse av den den kumulative standard normalfordelingen
        'PEARSON' => 'PEARSON', //Returnerer produktmomentkorrelasjonskoeffisienten, Pearson
        'PERSENTIL' => 'PERCENTILE', //Returnerer den n-te persentil av verdiene i et område
        'PROSENTDEL' => 'PERCENTRANK', //Returnerer prosentrangeringen av en verdi i et datasett
        'PERMUTER' => 'PERMUT', //Returnerer antall permutasjoner for et gitt antall objekter
        'POISSON' => 'POISSON', //Returnerer Poissons sannsynlighetsfordeling
        'SANNSYNLIG' => 'PROB', //Returnerer sannsynligheten for at verdier i et område ligger mellom to grenser
        'KVARTIL' => 'QUARTILE', //Returnerer kvartilen til et datasett
        'RANG' => 'RANK', //Returnerer rangeringen av et tall, eller plassen tallet har i en rekke
        'RKVADRAT' => 'RSQ', //Returnerer kvadratet av produktmomentkorrelasjonskoeffisienten (Pearsons r)
        'SKJEVFORDELING' => 'SKEW', //Returnerer skjevheten i en fordeling
        'STIGNINGSTALL' => 'SLOPE', //Returnerer stigningtallet for den lineære regresjonslinjen
        'N.MINST' => 'SMALL', //Returnerer den n-te minste verdien i et datasett
        'NORMALISER' => 'STANDARDIZE', //Returnerer en normalisert verdi
        'STDAV' => 'STDEV', //Estimere standardavvik på grunnlag av et utvalg
        'STDAVVIKA' => 'STDEVA', //Estimerer standardavvik basert på et utvalg, inkludert tall, tekst og logiske verdier
        'STDAVP' => 'STDEVP', //Beregner standardavvik basert på hele populasjonen
        'STDAVVIKPA' => 'STDEVPA', //Beregner standardavvik basert på hele populasjonen, inkludert tall, tekst og logiske verdier
        'STANDARDFEIL' => 'STEYX', //Returnerer standardfeilen for den predikerte y-verdien for hver x i regresjonen
        'TFORDELING' => 'TDIST', //Returnerer en Student t-fordeling
        'TINV' => 'TINV', //Returnerer den inverse Student t-fordelingen
        'TREND' => 'TREND', //Returnerer verdier langs en lineær trend
        'TRIMMET.GJENNOMSNITT' => 'TRIMMEAN', //Returnerer den interne middelverdien til et datasett
        'TTEST' => 'TTEST', //Returnerer sannsynligheten assosiert med en Student t-test
        'VARIANS' => 'VAR', //Estimerer varians basert på et utvalg
        'VARIANSA' => 'VARA', //Estimerer varians basert på et utvalg, inkludert tall, tekst og logiske verdier
        'VARIANSP' => 'VARP', //Beregner varians basert på hele populasjonen
        'VARIANSPA' => 'VARPA', //Beregner varians basert på hele populasjonen, inkludert tall, tekst og logiske verdier
        'WEIBULL.FORDELING' => 'WEIBULL', //Returnerer Weibull-fordelingen
        'ZTEST' => 'ZTEST', //Returnerer den ensidige sannsynlighetsverdien for en z-test
        'STIGENDE' => 'ASC', //Endrer fullbreddes (dobbeltbyte) engelske bokstaver eller katakana i en tegnstreng, til halvbreddes (enkeltbyte) tegn
        'BAHTTEKST' => 'BAHTTEXT', //Konverterer et tall til tekst, og bruker valutaformatet ß (baht)
        'TEGNKODE' => 'CHAR', //Returnerer tegnet som svarer til kodenummeret
        'RENSK' => 'CLEAN', //Fjerner alle tegn som ikke kan skrives ut, fra teksten
        'KODE' => 'CODE', //Returnerer en numerisk kode for det første tegnet i en tekststreng
        'KJEDE.SAMMEN' => 'CONCATENATE', //Slår sammen flere tekstelementer til ett tekstelement
        'VALUTA' => 'DOLLAR', //Konverterer et tall til tekst, og bruker valutaformatet $ (dollar)
        'EKSAKT' => 'EXACT', //Kontrollerer om to tekstverdier er like
        'FINN' => 'FIND', //Finner en tekstverdi inne i en annen (skiller mellom store og små bokstaver)
        'FINNB' => 'FINDB', //Finner en tekstverdi inne i en annen (skiller mellom store og små bokstaver)
        'FASTSATT' => 'FIXED', //Formaterer et tall som tekst med et bestemt antall desimaler
        'JIS' => 'JIS', //Endrer halvbreddes (enkeltbyte) engelske bokstaver eller katakana i en tegnstreng, til fullbreddes (dobbeltbyte) tegn
        'VENSTRE' => 'LEFT', //Returnerer tegnene lengst til venstre i en tekstverdi
        'VENSTREB' => 'LEFTB', //Returnerer tegnene lengst til venstre i en tekstverdi
        'LENGDE' => 'LEN', //Returnerer antall tegn i en tekststreng
        'LENGDEB' => 'LENB', //Returnerer antall tegn i en tekststreng
        'SMÅ' => 'LOWER', //Konverterer tekst til små bokstaver
        'DELTEKST' => 'MID', //Returnerer et angitt antall tegn fra en tekststreng, og begynner fra posisjonen du angir
        'DELTEKSTB' => 'MIDB', //Returnerer et angitt antall tegn fra en tekststreng, og begynner fra posisjonen du angir
        'FURIGANA' => 'PHONETIC', //Trekker ut fonetiske tegn (furigana) fra en tekststreng
        'STOR.FORBOKSTAV' => 'PROPER', //Gir den første bokstaven i hvert ord i en tekstverdi stor forbokstav
        'ERSTATT' => 'REPLACE', //Erstatter tegn i en tekst
        'ERSTATTB' => 'REPLACEB', //Erstatter tegn i en tekst
        'GJENTA' => 'REPT', //Gjentar tekst et gitt antall ganger
        'HØYRE' => 'RIGHT', //Returnerer tegnene lengst til høyre i en tekstverdi
        'HØYREB' => 'RIGHTB', //Returnerer tegnene lengst til høyre i en tekstverdi
        'SØK' => 'SEARCH', //Finner en tekstverdi inne i en annen (skiller ikke mellom store og små bokstaver)
        'SØKB' => 'SEARCHB', //Finner en tekstverdi inne i en annen (skiller ikke mellom store og små bokstaver)
        'BYTT.UT' => 'SUBSTITUTE', //Bytter ut gammel tekst med ny tekst i en tekststreng
        'T' => 'T', //Konverterer argumentene til tekst
        'TEKST' => 'TEXT', //Formaterer et tall og konverterer det til tekst
        'TRIMME' => 'TRIM', //Fjerner mellomrom fra tekst
        'STORE' => 'UPPER', //Konverterer tekst til store bokstaver
        'VERDI' => 'VALUE', //Konverterer et tekstargument til et tall
    ],
];
//EOF
