<?php
// fr_FR

return [
    'language' => 'French',
    'formats' => [
        'date' => 'DD/MM/YYYY',
        'time' => 'HH:MM:SS',
        'datetime' => 'DD/MM/YYYY HH:MM:SS',
        'money' => '#,##0.00 [$€];[RED]-#,##0.00 [$€]',
    ],
    'functions' => [
        'LIREDONNEESTABCROISDYNAMIQUE' => 'GETPIVOTDATA', //Renvoie les données stockées dans un rapport de tableau croisé dynamique.
        'MEMBREKPICUBE' => 'CUBEKPIMEMBER', //Renvoie un nom, une propriété et une mesure d’indicateur de performance clé et affiche le nom et la propriété dans la cellule. Un indicateur de performance clé est une mesure quantifiable, telle que la marge bénéficiaire brute mensuelle ou la rotation trimestrielle du personnel, utilisée pour évaluer les performances d’une entreprise.
        'MEMBRECUBE' => 'CUBEMEMBER', //Renvoie un membre ou un uplet dans une hiérarchie de cubes. Utilisez cette fonction pour valider l’existence du membre ou de l’uplet dans le cube.
        'PROPRIETEMEMBRECUBE' => 'CUBEMEMBERPROPERTY', //Renvoie la valeur d’une propriété de membre du cube. Utilisez cette fonction pour valider l’existence d’un nom de membre dans le cube et pour renvoyer la propriété spécifiée pour ce membre.
        'RANGMEMBRECUBE' => 'CUBERANKEDMEMBER', //Renvoie le nième membre ou le membre placé à un certain rang dans un ensemble. Utilisez cette fonction pour renvoyer un ou plusieurs éléments d’un ensemble, tels que les meilleurs vendeurs ou les 10 meilleurs étudiants.
        'JEUCUBE' => 'CUBESET', //Définit un ensemble calculé de membres ou d’uplets en envoyant une expression définie au cube sur le serveur qui crée l’ensemble et le renvoie à Microsoft Office Excel.
        'NBJEUCUBE' => 'CUBESETCOUNT', //Renvoie le nombre d’éléments dans un jeu.
        'VALEURCUBE' => 'CUBEVALUE', //Renvoie une valeur d’agrégation issue d’un cube.
        'BDMOYENNE' => 'DAVERAGE', //Renvoie la moyenne des entrées de base de données sélectionnées.
        'BCOMPTE' => 'DCOUNT', //Compte le nombre de cellules d’une base de données qui contiennent des nombres.
        'BDNBVAL' => 'DCOUNTA', //Compte les cellules non vides d’une base de données.
        'BDLIRE' => 'DGET', //Extrait d’une base de données un enregistrement unique répondant aux critères spécifiés.
        'BDMAX' => 'DMAX', //Renvoie la valeur maximale des entrées de base de données sélectionnées.
        'BDMIN' => 'DMIN', //Renvoie la valeur minimale des entrées de base de données sélectionnées.
        'BDPRODUIT' => 'DPRODUCT', //Multiplie les valeurs d’un champ particulier des enregistrements d’une base de données, qui répondent aux critères spécifiés.
        'BDECARTYPE' => 'DSTDEV', //Calcule l’écart type pour un échantillon d’entrées de base de données sélectionnées.
        'BDECARTYPEP' => 'DSTDEVP', //Calcule l’écart type pour l’ensemble d’une population d’entrées de base de données sélectionnées.
        'BDSOMME' => 'DSUM', //Ajoute les nombres dans la colonne de champ des enregistrements de la base de données, qui répondent aux critères.
        'BDVAR' => 'DVAR', //Calcule la variance pour un échantillon d’entrées de base de données sélectionnées.
        'BDVARP' => 'DVARP', //Calcule la variance pour l’ensemble d’une population d’entrées de base de données sélectionnées.
        'DATE' => 'DATE', //Renvoie le numéro de série d’une date précise.
        'DATEVAL' => 'DATEVALUE', //Convertit une date représentée sous forme de texte en numéro de série.
        'JOUR' => 'DAY', //Convertit un numéro de série en jour du mois.
        'JOURS360' => 'DAYS360', //Calcule le nombre de jours qui séparent deux dates sur la base d’une année de 360 jours.
        'MOIS.DECALER' => 'EDATE', //Renvoie le numéro séquentiel de la date qui représente une date spécifiée (l’argument date_départ), corrigée en plus ou en moins du nombre de mois indiqué.
        'FIN.MOIS' => 'EOMONTH', //Renvoie le numéro séquentiel de la date du dernier jour du mois précédant ou suivant la date_départ du nombre de mois indiqué.
        'HEURE' => 'HOUR', //Convertit un numéro de série en heure.
        'MINUTE' => 'MINUTE', //Convertit un numéro de série en minute.
        'MOIS' => 'MONTH', //Convertit un numéro de série en mois.
        'NB.JOURS.OUVRES' => 'NETWORKDAYS', //Renvoie le nombre de jours ouvrés entiers compris entre deux dates.
        'MAINTENANT' => 'NOW', //Renvoie le numéro de série de la date et de l’heure du jour.
        'SECONDE' => 'SECOND', //Convertit un numéro de série en seconde.
        'TEMPS' => 'TIME', //Renvoie le numéro de série d’une heure précise.
        'TEMPSVAL' => 'TIMEVALUE', //Convertit une date représentée sous forme de texte en numéro de série.
        'AUJOURDHUI' => 'TODAY', //Renvoie le numéro de série de la date du jour.
        'JOURSEM' => 'WEEKDAY', //Convertit un numéro de série en jour de la semaine.
        'NO.SEMAINE' => 'WEEKNUM', //Convertit un numéro de série en un numéro représentant l’ordre de la semaine dans l’année.
        'SERIE.JOUR.OUVRE' => 'WORKDAY', //Renvoie le numéro de série de la date avant ou après le nombre de jours ouvrés spécifiés.
        'ANNEE' => 'YEAR', //Convertit un numéro de série en année.
        'FRACTION.ANNEE' => 'YEARFRAC', //Renvoie la fraction de l’année représentant le nombre de jours entre la date de début et la date de fin.
        'BESSELI' => 'BESSELI', //Renvoie la fonction Bessel modifiée In(x).
        'BESSELJ' => 'BESSELJ', //Renvoie la fonction Bessel Jn(x).
        'BESSELK' => 'BESSELK', //Renvoie la fonction Bessel modifiée Kn(x).
        'BESSELY' => 'BESSELY', //Renvoie la fonction Bessel Yn(x).
        'BINDEC' => 'BIN2DEC', //Convertit un nombre binaire en nombre décimal.
        'BINHEX' => 'BIN2HEX', //Convertit un nombre binaire en nombre hexadécimal.
        'BINOCT' => 'BIN2OCT', //Convertit un nombre binaire en nombre octal.
        'COMPLEXE' => 'COMPLEX', //Convertit des coefficients réel et imaginaire en un nombre complexe.
        'CONVERT' => 'CONVERT', //Convertit un nombre d’une unité de mesure à une autre.
        'DECBIN' => 'DEC2BIN', //Convertit un nombre décimal en nombre binaire.
        'DECHEX' => 'DEC2HEX', //Convertit un nombre décimal en nombre hexadécimal.
        'DECOCT' => 'DEC2OCT', //Convertit un nombre décimal en nombre octal.
        'DELTA' => 'DELTA', //Teste l’égalité de deux nombres.
        'ERF' => 'ERF', //Renvoie la valeur de la fonction d’erreur.
        'ERFC' => 'ERFC', //Renvoie la valeur de la fonction d’erreur complémentaire.
        'SUP.SEUIL' => 'GESTEP', //Teste si un nombre est supérieur à une valeur de seuil.
        'HEXBIN' => 'HEX2BIN', //Convertit un nombre hexadécimal en nombre binaire.
        'HEXDEC' => 'HEX2DEC', //Convertit un nombre hexadécimal en nombre décimal.
        'HEXOCT' => 'HEX2OCT', //Convertit un nombre hexadécimal en nombre octal.
        'COMPLEXE.MODULE' => 'IMABS', //Renvoie la valeur absolue (module) d’un nombre complexe.
        'COMPLEXE.IMAGINAIRE' => 'IMAGINARY', //Renvoie le coefficient imaginaire d’un nombre complexe.
        'COMPLEXE.ARGUMENT' => 'IMARGUMENT', //Renvoie l’argument thêta, un angle exprimé en radians.
        'COMPLEXE.CONJUGUE' => 'IMCONJUGATE', //Renvoie le nombre complexe conjugué d’un nombre complexe.
        'IMCOS' => 'IMCOS', //Renvoie le cosinus d’un nombre complexe.
        'COMPLEXE.DIV' => 'IMDIV', //Renvoie le quotient de deux nombres complexes.
        'COMPLEXE.EXP' => 'IMEXP', //Renvoie la fonction exponentielle d’un nombre complexe.
        'COMPLEXE.LN' => 'IMLN', //Renvoie le logarithme népérien d’un nombre complexe.
        'COMPLEXE.LOG10' => 'IMLOG10', //Calcule le logarithme en base 10 d’un nombre complexe.
        'COMPLEXE.LOG2' => 'IMLOG2', //Calcule le logarithme en base 2 d’un nombre complexe.
        'COMPLEXE.PUISSANCE' => 'IMPOWER', //Renvoie un nombre complexe élevé à une puissance entière.
        'COMPLEXE.PRODUIT' => 'IMPRODUCT', //Renvoie le produit de plusieurs nombres complexes.
        'COMPLEXE.REEL' => 'IMREAL', //Renvoie le coefficient réel d’un nombre complexe.
        'COMPLEXE.SIN' => 'IMSIN', //Renvoie le sinus d’un nombre complexe.
        'COMPLEXE.RACINE' => 'IMSQRT', //Renvoie la racine carrée d’un nombre complexe.
        'COMPLEXE.DIFFERENCE' => 'IMSUB', //Renvoie la différence entre deux nombres complexes.
        'COMPLEXE.SOMME' => 'IMSUM', //Renvoie la somme de plusieurs nombres complexes.
        'OCTBIN' => 'OCT2BIN', //Convertit un nombre octal en nombre binaire.
        'OCTDEC' => 'OCT2DEC', //Convertit un nombre octal en nombre décimal.
        'OCTHEX' => 'OCT2HEX', //Convertit un nombre octal en nombre hexadécimal.
        'INTERET.ACC' => 'ACCRINT', //Renvoie l’intérêt couru non échu d’un titre dont l’intérêt est perçu périodiquement.
        'INTERET.ACC.MAT' => 'ACCRINTM', //Renvoie l’intérêt couru non échu d’un titre dont l’intérêt est perçu à l’échéance.
        'AMORDEGRC' => 'AMORDEGRC', //Renvoie l’amortissement correspondant à chaque période comptable en utilisant un coefficient d’amortissement.
        'AMORLINC' => 'AMORLINC', //Renvoie l’amortissement d’un bien à la fin d’une période fiscale donnée.
        'NB.JOURS.COUPON.PREC' => 'COUPDAYBS', //Renvoie le nombre de jours entre le début de la période de coupon et la date de liquidation.
        'NB.JOURS.COUPONS' => 'COUPDAYS', //Renvoie le nombre de jours pour la période du coupon contenant la date de liquidation.
        'NB.JOURS.COUPON.SUIV' => 'COUPDAYSNC', //Renvoie le nombre de jours entre la date de liquidation et la date du coupon suivant la date de liquidation.
        'DATE.COUPON.SUIV' => 'COUPNCD', //Renvoie la première date de coupon ultérieure à la date de règlement.
        'NB.COUPONS' => 'COUPNUM', //Renvoie le nombre de coupons dus entre la date de règlement et la date d’échéance.
        'DATE.COUPON.PREC' => 'COUPPCD', //Renvoie la date de coupon précédant la date de règlement.
        'CUMUL.INTER' => 'CUMIPMT', //Renvoie l’intérêt cumulé payé sur un emprunt entre deux périodes.
        'CUMUL.PRINCPER' => 'CUMPRINC', //Renvoie le montant cumulé des remboursements du capital d’un emprunt effectués entre deux périodes.
        'DB' => 'DB', //Renvoie l’amortissement d’un bien pour une période spécifiée en utilisant la méthode de l’amortissement dégressif à taux fixe.
        'DDB' => 'DDB', //Renvoie l’amortissement d’un bien pour toute période spécifiée, en utilisant la méthode de l’amortissement dégressif à taux double ou selon un coefficient à spécifier.
        'TAUX.ESCOMPTE' => 'DISC', //Calcule le taux d’escompte d’une transaction.
        'PRIX.DEC' => 'DOLLARDE', //Convertit un prix en euros, exprimé sous forme de fraction, en un prix en euros exprimé sous forme de nombre décimal.
        'PRIX.FRAC' => 'DOLLARFR', //Convertit un prix en euros, exprimé sous forme de nombre décimal, en un prix en euros exprimé sous forme de fraction.
        'DUREE' => 'DURATION', //Renvoie la durée, en années, d’un titre dont l’intérêt est perçu périodiquement.
        'TAUX.EFFECTIF' => 'EFFECT', //Renvoie le taux d’intérêt annuel effectif.
        'VC' => 'FV', //Renvoie la valeur future d’un investissement.
        'VC.PAIEMENTS' => 'FVSCHEDULE', //Calcule la valeur future d’un investissement en appliquant une série de taux d’intérêt composites.
        'TAUX.INTERET' => 'INTRATE', //Affiche le taux d’intérêt d’un titre totalement investi.
        'INTPER' => 'IPMT', //Calcule le montant des intérêts d’un investissement pour une période donnée.
        'TRI' => 'IRR', //Calcule le taux de rentabilité interne d’un investissement pour une succession de trésoreries.
        'ISPMT' => 'ISPMT', //Calcule le montant des intérêts d’un investissement pour une période donnée.
        'DUREE.MODIFIEE' => 'MDURATION', //Renvoie la durée de Macauley modifiée pour un titre ayant une valeur nominale hypothétique de 100_euros.
        'TRIM' => 'MIRR', //Calcule le taux de rentabilité interne lorsque les paiements positifs et négatifs sont financés à des taux différents.
        'TAUX.NOMINAL' => 'NOMINAL', //Calcule le taux d’intérêt nominal annuel.
        'NPM' => 'NPER', //Renvoie le nombre de versements nécessaires pour rembourser un emprunt.
        'VAN' => 'NPV', //Calcule la valeur actuelle nette d’un investissement basé sur une série de décaissements et un taux d’escompte.
        'PRIX.PCOUPON.IRREG' => 'ODDFPRICE', //Renvoie le prix par tranche de valeur nominale de 100 euros d’un titre dont la première période de coupon est irrégulière.
        'REND.PCOUPON.IRREG' => 'ODDFYIELD', //Renvoie le taux de rendement d’un titre dont la première période de coupon est irrégulière.
        'PRIX.DCOUPON.IRREG' => 'ODDLPRICE', //Renvoie le prix par tranche de valeur nominale de 100 euros d’un titre dont la première période de coupon est irrégulière.
        'REND.DCOUPON.IRREG' => 'ODDLYIELD', //Renvoie le taux de rendement d’un titre dont la dernière période de coupon est irrégulière.
        'VPM' => 'PMT', //Calcule le paiement périodique d’un investissement donné.
        'PRINCPER' => 'PPMT', //Calcule, pour une période donnée, la part de remboursement du principal d’un investissement.
        'PRIX.TITRE' => 'PRICE', //Renvoie le prix d’un titre rapportant des intérêts périodiques, pour une valeur nominale de 100 euros.
        'VALEUR.ENCAISSEMENT' => 'PRICEDISC', //Renvoie la valeur d’encaissement d’un escompte commercial, pour une valeur nominale de 100 euros.
        'PRIX.TITRE.ECHEANCE' => 'PRICEMAT', //Renvoie le prix d’un titre dont la valeur nominale est 100 euros et qui rapporte des intérêts à l’échéance.
        'PV' => 'PV', //Calcule la valeur actuelle d’un investissement.
        'TAUX' => 'RATE', //Calcule le taux d’intérêt par période pour une annuité.
        'VALEUR.NOMINALE' => 'RECEIVED', //Renvoie la valeur nominale à échéance d’un effet de commerce.
        'AMORLIN' => 'SLN', //Calcule l’amortissement linéaire d’un bien pour une période donnée.
        'SYD' => 'SYD', //Calcule l’amortissement d’un bien pour une période donnée sur la base de la méthode américaine Sum-of-Years Digits (amortissement dégressif à taux décroissant appliqué à une valeur constante).
        'TAUX.ESCOMPTE.R' => 'TBILLEQ', //Renvoie le taux d’escompte rationnel d’un bon du Trésor.
        'PRIX.BON.TRESOR' => 'TBILLPRICE', //Renvoie le prix d’un bon du Trésor d’une valeur nominale de 100 euros.
        'RENDEMENT.BON.TRESOR' => 'TBILLYIELD', //Calcule le taux de rendement d’un bon du Trésor.
        'VDB' => 'VDB', //Renvoie l’amortissement d’un bien pour une période spécifiée ou partielle en utilisant une méthode de l’amortissement dégressif à taux fixe.
        'TRI.PAIEMENTS' => 'XIRR', //Calcule le taux de rentabilité interne d’un ensemble de paiements non périodiques.
        'VAN.PAIEMENTS' => 'XNPV', //Renvoie la valeur actuelle nette d’un ensemble de paiements non périodiques.
        'RENDEMENT.TITRE' => 'YIELD', //Calcule le rendement d’un titre rapportant des intérêts périodiquement.
        'RENDEMENT.SIMPLE' => 'YIELDDISC', //Calcule le taux de rendement d’un emprunt à intérêt simple (par exemple, un bon du Trésor).
        'RENDEMENT.TITRE.ECHEANCE' => 'YIELDMAT', //Renvoie le rendement annuel d’un titre qui rapporte des intérêts à l’échéance.
        'CELLULE' => 'CELL', //Renvoie des informations sur la mise en forme, l’emplacement et le contenu d’une cellule.
        'TYPE.ERREUR' => 'ERROR.TYPE', //Renvoie un nombre correspondant à un type d’erreur.
        'INFORMATIONS' => 'INFO', //Renvoie des informations sur l’environnement d’exploitation actuel.
        'ESTVIDE' => 'ISBLANK', //Renvoie VRAI si l’argument valeur est vide.
        'ESTERR' => 'ISERR', //Renvoie VRAI si l’argument valeur fait référence à une valeur d’erreur, sauf #N/A.
        'ESTERREUR' => 'ISERROR', //Renvoie VRAI si l’argument valeur fait référence à une valeur d’erreur.
        'EST.PAIR' => 'ISEVEN', //Renvoie VRAI si le chiffre est pair.
        'ESTLOGIQUE' => 'ISLOGICAL', //Renvoie VRAI si l’argument valeur fait référence à une valeur logique.
        'ESTNA' => 'ISNA', //Renvoie VRAI si l’argument valeur fait référence à la valeur d’erreur #N/A.
        'ESTNONTEXTE' => 'ISNONTEXT', //Renvoie VRAI si l’argument valeur ne se présente pas sous forme de texte.
        'ESTNUM' => 'ISNUMBER', //Renvoie VRAI si l’argument valeur représente un nombre.
        'EST.IMPAIR' => 'ISODD', //Renvoie VRAI si le chiffre est impair.
        'ESTREF' => 'ISREF', //Renvoie VRAI si l’argument valeur est une référence.
        'ESTTEXTE' => 'ISTEXT', //Renvoie VRAI si l’argument valeur se présente sous forme de texte.
        'N' => 'N', //Renvoie une valeur convertie en nombre.
        'NA' => 'NA', //Renvoie la valeur d’erreur #N/A.
        'TYPE' => 'TYPE', //Renvoie un nombre indiquant le type de données d’une valeur.
        'ET' => 'AND', //Renvoie VRAI si tous ses arguments sont VRAI.
        'FAUX' => 'FALSE', //Renvoie la valeur logique FAUX.
        'SI' => 'IF', //Spécifie un test logique à effectuer.
        'SIERREUR' => 'IFERROR', //Renvoie une valeur que vous spécifiez si une formule génère une erreur ; sinon, elle renvoie le résultat de la formule.
        'NON' => 'NOT', //Inverse la logique de cet argument.
        'OU' => 'OR', //Renvoie VRAI si un des arguments est VRAI.
        'VRAI' => 'TRUE', //Renvoie la valeur logique VRAI.
        'ADRESSE' => 'ADDRESS', //Renvoie une référence sous forme de texte à une seule cellule d’une feuille de calcul.
        'ZONES' => 'AREAS', //Renvoie le nombre de zones dans une référence.
        'CHOISIR' => 'CHOOSE', //Choisit une valeur dans une liste.
        'COLONNE' => 'COLUMN', //Renvoie le numéro de colonne d’une référence.
        'COLONNES' => 'COLUMNS', //Renvoie le nombre de colonnes dans une référence.
        'RECHERCHEH' => 'HLOOKUP', //Effectue une recherche dans la première ligne d’une matrice et renvoie la valeur de la cellule indiquée.
        'LIEN_HYPERTEXTE' => 'HYPERLINK', //Crée un raccourci ou un renvoi qui ouvre un document stocké sur un serveur réseau, sur un réseau Intranet ou sur Internet.
        'INDEX' => 'INDEX', //Utilise un index pour choisir une valeur provenant d’une référence ou d’une matrice.
        'INDIRECT' => 'INDIRECT', //Renvoie une référence indiquée par une valeur de texte.
        'RECHERCHE' => 'LOOKUP', //Recherche des valeurs dans un vecteur ou une matrice.
        'EQUIV' => 'MATCH', //Recherche des valeurs dans une référence ou une matrice.
        'DECALER' => 'OFFSET', //Renvoie une référence décalée par rapport à une référence donnée.
        'LIGNE' => 'ROW', //Renvoie le numéro de ligne d’une référence.
        'LIGNES' => 'ROWS', //Renvoie le nombre de lignes dans une référence.
        'RTD' => 'RTD', //Extrait les données en temps réel à partir d’un programme prenant en charge l’automation COM (Automation : utilisation des objets d'une application à partir d'une autre application ou d'un autre outil de développement. Autrefois appelée OLE Automation, Automation est une norme industrielle et une fonctionnalité du modèle d'objet COM (Component Object Model).).
        'TRANSPOSE' => 'TRANSPOSE', //Renvoie la transposition d’une matrice.
        'RECHERCHEV' => 'VLOOKUP', //Effectue une recherche dans la première colonne d’une matrice et se déplace sur la ligne pour renvoyer la valeur d’une cellule.
        'ABS' => 'ABS', //Renvoie la valeur absolue d’un nombre.
        'ACOS' => 'ACOS', //Renvoie l’arccosinus d’un nombre.
        'ACOSH' => 'ACOSH', //Renvoie le cosinus hyperbolique inverse d’un nombre.
        'ASIN' => 'ASIN', //Renvoie l’arcsinus d’un nombre.
        'ASINH' => 'ASINH', //Renvoie le sinus hyperbolique inverse d’un nombre.
        'ATAN' => 'ATAN', //Renvoie l’arctangente d’un nombre.
        'ATAN2' => 'ATAN2', //Renvoie l’arctangente des coordonnées x et y.
        'ATANH' => 'ATANH', //Renvoie la tangente hyperbolique inverse d’un nombre.
        'PLAFOND' => 'CEILING', //Arrondit un nombre au nombre entier le plus proche ou au multiple le plus proche de l’argument précision en s’éloignant de zéro.
        'COMBIN' => 'COMBIN', //Renvoie le nombre de combinaisons que l’on peut former avec un nombre donné d’objets.
        'COS' => 'COS', //Renvoie le cosinus d’un nombre.
        'COSH' => 'COSH', //Renvoie le cosinus hyperbolique d’un nombre.
        'DEGRES' => 'DEGREES', //Convertit des radians en degrés.
        'PAIR' => 'EVEN', //Arrondit un nombre au nombre entier pair le plus proche en s’éloignant de zéro.
        'EXP' => 'EXP', //Renvoie e élevé à la puissance d’un nombre donné.
        'FACT' => 'FACT', //Renvoie la factorielle d’un nombre.
        'FACTDOUBLE' => 'FACTDOUBLE', //Renvoie la factorielle double d’un nombre.
        'PLANCHER' => 'FLOOR', //Arrondit un nombre en tendant vers 0 (zéro).
        'PGCD' => 'GCD', //Renvoie le plus grand commun diviseur.
        'ENT' => 'INT', //Arrondit un nombre à l’entier immédiatement inférieur.
        'PPCM' => 'LCM', //Renvoie le plus petit commun multiple.
        'LN' => 'LN', //Renvoie le logarithme népérien d’un nombre.
        'LOG' => 'LOG', //Renvoie le logarithme d’un nombre dans la base spécifiée.
        'LOG10' => 'LOG10', //Calcule le logarithme en base 10 d’un nombre.
        'DETERMAT' => 'MDETERM', //Renvoie le déterminant d’une matrice.
        'INVERSEMAT' => 'MINVERSE', //Renvoie la matrice inverse d’une matrice.
        'PRODUITMAT' => 'MMULT', //Renvoie le produit de deux matrices.
        'MOD' => 'MOD', //Renvoie le reste d’une division.
        'ARRONDI.AU.MULTIPLE' => 'MROUND', //Donne l’arrondi d’un nombre au multiple spécifié.
        'MULTINOMIALE' => 'MULTINOMIAL', //Calcule la multinomiale d’un ensemble de nombres.
        'IMPAIR' => 'ODD', //Renvoie le nombre, arrondi à la valeur du nombre entier impair le plus proche en s’éloignant de zéro.
        'PI' => 'PI', //Renvoie la valeur de pi.
        'PUISSANCE' => 'POWER', //Renvoie la valeur du nombre élevé à une puissance.
        'PRODUIT' => 'PRODUCT', //Multiplie ses arguments.
        'QUOTIENT' => 'QUOTIENT', //Renvoie la partie entière du résultat d’une division.
        'RADIANS' => 'RADIANS', //Convertit des degrés en radians.
        'ALEA' => 'RAND', //Renvoie un nombre aléatoire compris entre 0 et 1.
        'ALEA.ENTRE.BORNES' => 'RANDBETWEEN', //Renvoie un nombre aléatoire entre les nombres que vous spécifiez.
        'ROMAIN' => 'ROMAN', //Convertit des chiffres arabes en chiffres romains, sous forme de texte.
        'ARRONDI' => 'ROUND', //Arrondit un nombre au nombre de chiffres indiqué.
        'ARRONDI.INF' => 'ROUNDDOWN', //Arrondit un nombre en tendant vers 0 (zéro).
        'ARRONDI.SUP' => 'ROUNDUP', //Arrondit un nombre à l’entier supérieur, en s’éloignant de zéro.
        'SOMME.SERIES' => 'SERIESSUM', //Renvoie la somme d’une série géométrique en s’appuyant sur la formule suivante :
        'SIGNE' => 'SIGN', //Renvoie le signe d’un nombre.
        'SIN' => 'SIN', //Renvoie le sinus d’un angle donné.
        'SINH' => 'SINH', //Renvoie le sinus hyperbolique d’un nombre.
        'RACINE' => 'SQRT', //Renvoie la racine carrée d’un nombre.
        'RACINE.PI' => 'SQRTPI', //Renvoie la racine carrée de (nombre * pi).
        'SOUS.TOTAL' => 'SUBTOTAL', //Renvoie un sous-total dans une liste ou une base de données.
        'SOMME' => 'SUM', //Calcule la somme de ses arguments.
        'SOMME.SI' => 'SUMIF', //Additionne les cellules spécifiées si elles répondent à un critère donné.
        'SOMME.SI.ENS' => 'SUMIFS', //Ajoute les cellules d’une plage qui répondent à plusieurs critères.
        'SOMMEPROD' => 'SUMPRODUCT', //Multiplie les valeurs correspondantes des matrices spécifiées et calcule la somme de ces produits.
        'SOMME.CARRES' => 'SUMSQ', //Renvoie la somme des carrés des arguments.
        'SOMME.X2MY2' => 'SUMX2MY2', //Renvoie la somme de la différence des carrés des valeurs correspondantes de deux matrices.
        'SOMME.X2PY2' => 'SUMX2PY2', //Renvoie la somme de la somme des carrés des valeurs correspondantes de deux matrices.
        'SOMME.XMY2' => 'SUMXMY2', //Renvoie la somme des carrés des différences entre les valeurs correspondantes de deux matrices.
        'TAN' => 'TAN', //Renvoie la tangente d’un nombre.
        'TANH' => 'TANH', //Renvoie la tangente hyperbolique d’un nombre.
        'TRONQUE' => 'TRUNC', //Renvoie la partie entière d’un nombre.
        'ECART.MOYEN' => 'AVEDEV', //Renvoie la moyenne des écarts absolus observés dans la moyenne des points de données.
        'MOYENNE' => 'AVERAGE', //Renvoie la moyenne de ses arguments.
        'AVERAGEA' => 'AVERAGEA', //Renvoie la moyenne de ses arguments, nombres, texte et valeurs logiques inclus.
        'MOYENNE.SI' => 'AVERAGEIF', //Renvoie la moyenne (arithmétique) de toutes les cellules d’une plage qui répondent à des critères donnés.
        'MOYENNE.SI.ENS' => 'AVERAGEIFS', //Renvoie la moyenne (arithmétique) de toutes les cellules qui répondent à plusieurs critères.
        'LOI.BETA' => 'BETADIST', //Renvoie la fonction de distribution cumulée.
        'BETA.INVERSE' => 'BETAINV', //Renvoie l’inverse de la fonction de distribution cumulée pour une distribution bêta spécifiée.
        'LOI.BINOMIALE' => 'BINOMDIST', //Renvoie la probabilité d’une variable aléatoire discrète suivant la loi binomiale.
        'LOI.KHIDEUX' => 'CHIDIST', //Renvoie la probabilité unilatérale de la distribution khi-deux.
        'KHIDEUX.INVERSE' => 'CHIINV', //Renvoie l’inverse de la probabilité unilatérale de la distribution khi-deux.
        'TEST.KHIDEUX' => 'CHITEST', //Renvoie le test d’indépendance.
        'INTERVALLE.CONFIANCE' => 'CONFIDENCE', //Renvoie l’intervalle de confiance pour une moyenne de population.
        'COEFFICIENT.CORRELATION' => 'CORREL', //Renvoie le coefficient de corrélation entre deux séries de données.
        'NB' => 'COUNT', //Détermine les nombres compris dans la liste des arguments.
        'NBVAL' => 'COUNTA', //Détermine le nombre de valeurs comprises dans la liste des arguments.
        'NB.VIDE' => 'COUNTBLANK', //Compte le nombre de cellules vides dans une plage.
        'NB.SI' => 'COUNTIF', //Compte le nombre de cellules qui répondent à un critère donné dans une plage.
        'NB.SI.ENS' => 'COUNTIFS', //Compte le nombre de cellules à l’intérieur d’une plage qui répondent à plusieurs critères.
        'COVARIANCE' => 'COVAR', //Renvoie la covariance, moyenne des produits des écarts pour chaque série d’observations.
        'CRITERE.LOI.BINOMIALE' => 'CRITBINOM', //Renvoie la plus petite valeur pour laquelle la distribution binomiale cumulée est inférieure ou égale à une valeur de critère.
        'SOMME.CARRES.ECARTS' => 'DEVSQ', //Renvoie la somme des carrés des écarts.
        'LOI.EXPONENTIELLE' => 'EXPONDIST', //Renvoie la distribution exponentielle.
        'LOI.F' => 'FDIST', //Renvoie la distribution de probabilité F.
        'INVERSE.LOI.F' => 'FINV', //Renvoie l’inverse de la distribution de probabilité F.
        'FISHER' => 'FISHER', //Renvoie la transformation de Fisher.
        'FISHER.INVERSE' => 'FISHERINV', //Renvoie l’inverse de la transformation de Fisher.
        'PREVISION' => 'FORECAST', //Calcule une valeur par rapport à une tendance linéaire.
        'FREQUENCE' => 'FREQUENCY', //Calcule la fréquence d’apparition des valeurs dans une plage de valeurs, puis renvoie des nombres sous forme de matrice verticale.
        'TEST.F' => 'FTEST', //Renvoie le résultat d’un test F.
        'LOI.GAMMA' => 'GAMMADIST', //Renvoie la probabilité d’une variable aléatoire suivant une loi Gamma.
        'LOI.GAMMA.INVERSE' => 'GAMMAINV', //Renvoie, pour une probabilité donnée, la valeur d’une variable aléatoire suivant une loi Gamma.
        'LNGAMMA' => 'GAMMALN', //Renvoie le logarithme népérien de la fonction Gamma, G(x)
        'MOYENNE.GEOMETRIQUE' => 'GEOMEAN', //Renvoie la moyenne géométrique.
        'CROISSANCE' => 'GROWTH', //Calcule des valeurs par rapport à une tendance exponentielle.
        'MOYENNE.HARMONIQUE' => 'HARMEAN', //Renvoie la moyenne harmonique.
        'LOI.HYPERGEOMETRIQUE' => 'HYPGEOMDIST', //Renvoie la probabilité d’une variable aléatoire discrète suivant une loi hypergéométrique.
        'ORDONNEE.ORIGINE' => 'INTERCEPT', //Renvoie l’ordonnée à l’origine d’une droite de régression linéaire.
        'KURTOSIS' => 'KURT', //Renvoie le kurtosis d’une série de données.
        'GRANDE.VALEUR' => 'LARGE', //Renvoie la k-ième plus grande valeur d’une série de données.
        'DROITEREG' => 'LINEST', //Renvoie les paramètres d’une tendance linéaire.
        'LOGREG' => 'LOGEST', //Renvoie les paramètres d’une tendance exponentielle.
        'LOI.LOGNORMALE.INVERSE' => 'LOGINV', //Renvoie l’inverse de la probabilité pour une variable aléatoire suivant la loi lognormale.
        'LOI.LOGNORMALE' => 'LOGNORMDIST', //Renvoie la probabilité d’une variable aléatoire continue suivant une loi lognormale.
        'MAX' => 'MAX', //Renvoie la valeur maximale contenue dans une liste d’arguments.
        'MAXA' => 'MAXA', //Renvoie la valeur maximale d’une liste d’arguments, nombres, texte et valeurs logiques inclus.
        'MEDIANE' => 'MEDIAN', //Renvoie la valeur médiane des nombres donnés.
        'MIN' => 'MIN', //Renvoie la valeur minimale contenue dans une liste d’arguments.
        'MINA' => 'MINA', //Renvoie la plus petite valeur d’une liste d’arguments, nombres, texte et valeurs logiques inclus.
        'MODE' => 'MODE', //Renvoie la valeur la plus courante d’une série de données.
        'LOI.BINOMIALE.NEG' => 'NEGBINOMDIST', //Renvoie la probabilité d’une variable aléatoire discrète suivant une loi binomiale négative.
        'LOI.NORMALE' => 'NORMDIST', //Renvoie la probabilité d’une variable aléatoire continue suivant une loi normale.
        'LOI.NORMALE.INVERSE' => 'NORMINV', //Renvoie, pour une probabilité donnée, la valeur d’une variable aléatoire suivant une loi normale standard.
        'LOI.NORMALE.STANDARD' => 'NORMSDIST', //Renvoie la probabilité d’une variable aléatoire continue suivant une loi normale standard.
        'LOI.NORMALE.STANDARD.INVERSE' => 'NORMSINV', //Renvoie l’inverse de la distribution cumulée normale standard.
        'PEARSON' => 'PEARSON', //Renvoie le coefficient de corrélation d’échantillonnage de Pearson.
        'CENTILE' => 'PERCENTILE', //Renvoie le k-ième centile des valeurs d’une plage.
        'RANG.POURCENTAGE' => 'PERCENTRANK', //Renvoie le rang en pourcentage d’une valeur d’une série de données.
        'PERMUTATION' => 'PERMUT', //Renvoie le nombre de permutations pour un nombre donné d’objets.
        'LOI.POISSON' => 'POISSON', //Renvoie la probabilité d’une variable aléatoire suivant une loi de Poisson.
        'PROBABILITE' => 'PROB', //Renvoie la probabilité que des valeurs d’une plage soient comprises entre deux limites.
        'QUARTILE' => 'QUARTILE', //Renvoie le quartile d’une série de données.
        'RANG' => 'RANK', //Renvoie le rang d’un nombre contenu dans une liste.
        'COEFFICIENT.DETERMINATION' => 'RSQ', //Renvoie la valeur du coefficient de détermination R^2 d’une régression linéaire.
        'COEFFICIENT.ASYMETRIE' => 'SKEW', //Renvoie l’asymétrie d’une distribution.
        'PENTE' => 'SLOPE', //Renvoie la pente d’une droite de régression linéaire.
        'PETITE.VALEUR' => 'SMALL', //Renvoie la k-ième plus petite valeur d’une série de données.
        'CENTREE.REDUITE' => 'STANDARDIZE', //Renvoie une valeur centrée réduite.
        'ECARTYPE' => 'STDEV', //Évalue l’écart type d’une population en se basant sur un échantillon de cette population.
        'STDEVA' => 'STDEVA', //Évalue l’écart type d’une population en se basant sur un échantillon de cette population, nombres, texte et valeurs logiques inclus.
        'ECARTYPEP' => 'STDEVP', //Calcule l’écart type d’une population à partir de la population entière.
        'STDEVPA' => 'STDEVPA', //Calcule l’écart type d’une population à partir de l’ensemble de la population, nombres, texte et valeurs logiques inclus.
        'ERREUR.TYPE.XY' => 'STEYX', //Renvoie l’erreur type de la valeur y prévue pour chaque x de la régression.
        'LOI.STUDENT' => 'TDIST', //Renvoie la probabilité d’une variable aléatoire suivant une loi T de Student.
        'LOI.STUDENT.INVERSE' => 'TINV', //Renvoie, pour une probabilité donnée, la valeur d’une variable aléatoire suivant une loi T de Student.
        'TENDANCE' => 'TREND', //Renvoie des valeurs par rapport à une tendance linéaire.
        'MOYENNE.REDUITE' => 'TRIMMEAN', //Renvoie la moyenne de l’intérieur d’une série de données.
        'TEST.STUDENT' => 'TTEST', //Renvoie la probabilité associée à un test T de Student.
        'VAR' => 'VAR', //Calcule la variance sur la base d’un échantillon.
        'VARA' => 'VARA', //Estime la variance d’une population en se basant sur un échantillon de cette population, nombres, texte et valeurs logiques incluses.
        'VAR.P' => 'VARP', //Calcule la variance sur la base de l’ensemble de la population.
        'VARPA' => 'VARPA', //Calcule la variance d’une population en se basant sur la population entière, nombres, texte et valeurs logiques inclus.
        'LOI.WEIBULL' => 'WEIBULL', //Renvoie la probabilité d’une variable aléatoire suivant une loi de Weibull.
        'TEST.Z' => 'ZTEST', //Renvoie la valeur de probabilité unilatérale d’un test z.
        'ASC' => 'ASC', //Change les caractères anglais ou katakana à pleine chasse (codés sur deux octets) à l’intérieur d’une chaîne de caractères en caractères à demi-chasse (codés sur un octet).
        'BAHTTEXT' => 'BAHTTEXT', //Convertit un nombre en texte en utilisant le format monétaire ß (baht).
        'CAR' => 'CHAR', //Renvoie le caractère spécifié par le code numérique.
        'EPURAGE' => 'CLEAN', //Supprime tous les caractères de contrôle du texte.
        'CODE' => 'CODE', //Renvoie le numéro de code du premier caractère du texte.
        'CONCATENER' => 'CONCATENATE', //Assemble plusieurs éléments textuels de façon à n’en former qu’un seul.
        'EURO' => 'DOLLAR', //Convertit un nombre en texte en utilisant le format monétaire € (euro).
        'EXACT' => 'EXACT', //Vérifie si deux valeurs de texte sont identiques.
        'TROUVE' => 'FIND', //Trouve un valeur textuelle dans une autre, en respectant la casse.
        'TROUVERB' => 'FINDB', //Trouve un valeur textuelle dans une autre, en respectant la casse.
        'CTXT' => 'FIXED', //Convertit un nombre au format texte avec un nombre de décimales spécifié.
        'JIS' => 'JIS', //Change les caractères anglais ou katakana à demi-chasse (codés sur un octet) à l’intérieur d’une chaîne de caractères en caractères à à pleine chasse (codés sur deux octets).
        'GAUCHE' => 'LEFT', //Renvoie des caractères situés à l’extrême gauche d’une chaîne de caractères.
        'GAUCHEB' => 'LEFTB', //Renvoie des caractères situés à l’extrême gauche d’une chaîne de caractères.
        'NBCAR' => 'LEN', //Renvoie le nombre de caractères contenus dans une chaîne de texte.
        'LENB' => 'LENB', //Renvoie le nombre de caractères contenus dans une chaîne de texte.
        'MINUSCULE' => 'LOWER', //Convertit le texte en minuscules.
        'STXT' => 'MID', //Renvoie un nombre déterminé de caractères d’une chaîne de texte à partir de la position que vous indiquez.
        'STXTB' => 'MIDB', //Renvoie un nombre déterminé de caractères d’une chaîne de texte à partir de la position que vous indiquez.
        'PHONETIQUE' => 'PHONETIC', //Extrait les caractères phonétiques (furigana) d’une chaîne de texte.
        'NOMPROPRE' => 'PROPER', //Met en majuscules la première lettre de chaque mot dans une chaîne textuelle.
        'REMPLACER' => 'REPLACE', //Remplace des caractères dans un texte.
        'REMPLACERB' => 'REPLACEB', //Remplace des caractères dans un texte.
        'REPT' => 'REPT', //Répète un texte un certain nombre de fois.
        'DROITE' => 'RIGHT', //Renvoie des caractères situés à l’extrême droite d’une chaîne de caractères.
        'DROITEB' => 'RIGHTB', //Renvoie des caractères situés à l’extrême droite d’une chaîne de caractères.
        'CHERCHE' => 'SEARCH', //Trouve un texte dans un autre texte (sans respecter la casse).
        'CHERCHERB' => 'SEARCHB', //Trouve un texte dans un autre texte (sans respecter la casse).
        'SUBSTITUE' => 'SUBSTITUTE', //Remplace l’ancien texte d’une chaîne de caractères par un nouveau.
        'T' => 'T', //Convertit ses arguments en texte.
        'TEXTE' => 'TEXT', //Convertit un nombre au format texte.
        'SUPPRESPACE' => 'TRIM', //Supprime les espaces du texte.
        'MAJUSCULE' => 'UPPER', //Convertit le texte en majuscules.
        'CNUM' => 'VALUE', //Convertit un argument textuel en nombre
    ],
];
//EOF
