<?php
function sub_date($orgDate,$mth){ 
  $cd = strtotime($orgDate); 
  $retDAY = date('Y-m-d H:i:s', mktime(date('H',$cd),date('i',$cd),date('s',$cd),date('m',$cd),date('d',$cd)-$mth,date('Y',$cd))); 
  return $retDAY; 
} 

function add_date($orgDate,$mth){ 
  $cd = strtotime($orgDate); 
  $retDAY = date('Y-m-d H:i:s', mktime(date('H',$cd),date('i',$cd),date('s',$cd),date('m',$cd),date('d',$cd)+$mth,date('Y',$cd))); 
  return $retDAY; 
} 

function isExpired($expiry_date) {
    $exp_date = strtotime($expiry_date);

    if(time() > $exp_date)
        return 1;
    else return 0;
}

//$suffixes = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
function formatBytes($size, $decimals = 0, $si = TRUE){
    $unit1 = array(
        '0' => 'Byte', '1' => 'KiB', '2' => 'MiB', '3' => 'GiB', '4' => 'TiB',
        '5' => 'PiB', '6' => 'EiB', '7' => 'ZiB', '8' => 'YiB'
    );
    $unit2 = array(
        '0' => 'Byte', '1' => 'KB', '2' => 'MB', '3' => 'GB', '4' => 'TB',
        '5' => 'PB', '6' => 'EB', '7' => 'ZB', '8' => 'YB'
    );
    
    $unit = ($si)? $unit2 : $unit1;

    for($i = 0; $size >= 1024 && $i <= count($unit); $i++){
        $size = $size/1024;
    }

    return round($size, $decimals).' '.$unit[$i];
}

function bytes($bytes, $force_unit = NULL, $format = NULL, $si = TRUE)
{
    // Format string
    $format = ($format === NULL) ? '%01.2f %s' : (string) $format;

    // IEC prefixes (binary)
    if ($si == FALSE OR strpos($force_unit, 'i') !== FALSE)
    {
        $units = array('B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB');
        $mod   = 1024;
    }
    // SI prefixes (decimal)
    else
    {
        $units = array('B', 'kB', 'MB', 'GB', 'TB', 'PB');
        $mod   = 1000;
    }

    // Determine unit to use
    if (($power = array_search((string) $force_unit, $units)) === FALSE)
    {
        $power = ($bytes > 0) ? floor(log($bytes, $mod)) : 0;
    }

    return sprintf($format, $bytes / pow($mod, $power), $units[$power]);
}


function convertSecToStr($secs){
    $output = '';
    if($secs >= 86400) {
        $days = floor($secs/86400);
        $secs = $secs%86400;
        $output = $days.' day';
        if($days != 1) $output .= 's';
        if($secs > 0) $output .= ', ';
    }
    if($secs>=3600){
        $hours = floor($secs/3600);
        $secs = $secs%3600;
        $output .= $hours.' hour';
        if($hours != 1) $output .= 's';
        if($secs > 0) $output .= ', ';
    }
    if($secs>=60){
        $minutes = floor($secs/60);
        $secs = $secs%60;
        $output .= $minutes.' minute';
        if($minutes != 1) $output .= 's';
        if($secs > 0) $output .= ', ';
    }
    $output .= $secs.' second';
    if($secs != 1) $output .= 's'; 
    return $output;
}


/**
 * function to convert array to xml
 * 
 * @param   Array   $data   Array to convert to XML
 * @param SimpleXMLElement $xml_data SimpleXMLElement Object passed by reference to which generated XML nodes will be added
 */
function array_to_xml( $data, &$xml_data ) {
    foreach( $data as $key => $value ) {
        if( is_numeric($key) ){
            $key = 'item'.$key; //dealing with <0/>..<n/> issues
        }
        if( is_array($value) ) {
            $subnode = $xml_data->addChild($key);
            array_to_xml($value, $subnode);
        } else {
            $xml_data->addChild("$key",htmlspecialchars("$value"));
        }
     }
}

/**
 * getRespXML take an Array and returns the equivalent XML.
 * 
 * @param   String   $rootElem    The return XML root element
 * @param   Array   $data    Array to convert to XML
 * @return  SimpleXMLElement Object    $result  SimpleXMLElement Object containing the generated XML
 */
function getRespXML($rootElem, $data) {
    // creating object of SimpleXMLElement
    $xml_data = new SimpleXMLElement($rootElem); //<PaymentNotificationResponse />

    // function call to convert array to xml
    array_to_xml($data, $xml_data);

    //saving generated xml file; 
    $result = $xml_data->asXML();
    
    return $result;
}

// Function to get the client ip address
function get_client_ip_env() {
    $ipaddress = '';
    if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
    else if(getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
    else if(getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
    else if(getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
    else if(getenv('HTTP_FORWARDED'))
        $ipaddress = getenv('HTTP_FORWARDED');
    else if(getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
    else
        $ipaddress = 'UNKNOWN';
 
    return $ipaddress;
}

/*
 * Checks if date is a valid date
 * @ret bool    TRUE if date is valid else FALSE
 */
function checkmydate($date) {
  $tempDate = explode('-', $date);
  // checkdate(month, day, year)
  return checkdate($tempDate[1], $tempDate[2], $tempDate[0]);
}

function ordinal($number) {
    $ends = array('th','st','nd','rd','th','th','th','th','th','th');
    if ((($number % 100) >= 11) && (($number%100) <= 13))
        return $number. 'th';
    else
        return $number. $ends[$number % 10];
}

function getDateTimeDifferenceString($datetime, $daysLimit=7){
    $currentDateTime = new DateTime(date("Y-m-d H:i:s"));
    $passedDateTime = new DateTime($datetime);
    $interval = $currentDateTime->diff($passedDateTime);
    //$elapsed = $interval->format('%y years %m months %a days %h hours %i minutes %s seconds');
    $day = $interval->format('%a');
    $hour = $interval->format('%h');
    $min = $interval->format('%i');
    $seconds = $interval->format('%s');

    if($day > $daysLimit) {
        return date("jS M, Y", strtotime($datetime));
    } else if($day >= 1 && $day <= $daysLimit ){
        if($day == 1) { return $day . " day ago"; }
        return $day . " days ago";
    } else if($hour >= 1 && $hour <= 24){
        if($hour == 1) { return $hour . " hour ago"; }
        return $hour . " hours ago";
    } else if($min >= 1 && $min <= 60){
        if($min == 1) { return $min . " minute ago"; }
        return $min . " minutes ago";
    } else if($seconds >= 1 && $seconds <= 60){
        if($seconds == 1) { return $seconds . " second ago"; }
        return $seconds . " seconds ago";
    }
}