<?php  
include_once '../includes/opener.php';
include_once '../includes/db.inc';
include_once '../config.php';

define("GTC_HASH_KEY", "834532DGWER6567RTYHS");
$gtcollapiurl = "http://gtweb.gtbank.com/GTCollectionRequery";
$gtcoll_requery_endpoint = "TransactionRequery_TransRef";

$requestBody = file_get_contents('php://input');
$logtable = "tbl_gtcoll_log";

$gtp_ips = ['127.0.0.1', 'localhost'];  //GTP LIVE SERVER

if (!(in_array($_SERVER['REMOTE_ADDR'], $isw_ips))) :
//   exit();
endif;
//echo 'HERE: ';print_r($requestBody);
$xml=simplexml_load_string($requestBody) or die("Error: Cannot create object");
//print_r($xml);       
        
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);

$fields = "`STATE`, `LOG`";
$value = "'IN', '$requestBody'";
$ad->insertLog($fields, $value, $logtable);

switch ($xml->getName()) {
    
    case "validationRequest" :  
    case "validationrequest" : 
    case "ValidationRequest" : 
        
        $data = custInfoResp($xml);   
    	$respBody = getRespXML("<validateResponse />", $data);
        
        echo $respBody;
    	
    	$value = "'OUT', '$respBody'";
        $ad->insertLog($fields, $value, $logtable);
        
        break;
    
    
    case "paymentUpdateRequest" :
    case "paymentupdateRequest" :
    case "paymentupdaterequest" :
    case "PaymentUpdateRequest" :
        
        $data = payNotifResp($xml);
    	$respBody = getRespXML("<paymentUpdateResponse />", $data);
        
        echo $respBody; 
    	
    	$value = "'OUT', '$respBody'";
        $ad->insertLog($fields, $value, $logtable);
        
        break;
    
    
    case "TransactionRequery" :
    case "transactionRequery" :
    case "transactionrequery" :
        
        $data = gtRequeryResp($xml);
    	$respBody = getRespXML("<transactionRequery />", $data);
        
        echo $respBody; 
    	
    	$value = "'OUT', '$respBody'";
        $ad->insertLog($fields, $value, $logtable);
        
        break;
    
    default :
        echo getRespXML("<{$xml->getName()} />", ["Message"=>"Undefined Error"]);
        break;
}
exit();


function hashThis($hashkey, ...$hashval) {
    $data = "";
    foreach ($hashval as $val) {
      $data .= trim($val);
    }
    
    return hash("sha512", trim($data).trim($hashkey)); //echo trim($data).trim($hashkey);exit();
}

/**
 * Generate an Array containing the Customer Information Response data
 * @param String $xml XML string containing the Customer Information Request from GTCollections
 * @return mixed An array containing the Customer Information Response data
 */
function custInfoResp($xml) {
    $custref = strtolower($xml->referenceID);
    $hash = $xml->hash;
    $otherdet = $xml->otherDetails;
    try {
        
        $comphash = hashThis(GTC_HASH_KEY, $custref, $otherdet->phoneNo, $otherdet->class);

        if ($hash != $comphash): 
            return ["referenceID"=>$custref, "customerName"=>"", "otherDetails"=> ["phoneNo"=>$otherdet->phoneNo, "class"=>$otherdet->class, "productName"=>"", "amount"=>0],
                        "totalAmount"=>0, "currency"=>CURRENCY, "statusCode"=>"01", "statusMessage"=>"Invalid Hash",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, "", 0, CURRENCY, "01", "Invalid Hash") 
                    ];
        endif;

        global $ad;
    //    echo "YERE: $custref";
        $sacct = $ad->loadRADAccountByUsername($custref);  //  print_r($sacct);
        // $sacc=$sacct["$custref"];    //print_r($sacc); echo "AGAIN:".$sacc[0]['SERVICE_ID'];
        foreach ($sacct as $key=>$vall):
            $sacc=$vall;
            break;
        endforeach;
    //    print_r($sacc);
        //$srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); //echo "YES";
            // $fp = fopen("paydirect_log.txt", "a+");
            // fwrite($fp, "Me test");
            // fclose($fp);
        $status = 0;
        $fname = $lname = $email = $mobile = "";
        $amt = 0;
        $payinfo = [];

        if ( (count($sacct) < 1) || (!isset($sacc[0]['ENABLED'])) || !$sacc[0]['ENABLED']) { 
            $status = 1; 
            return ["referenceID"=>$custref, "customerName"=>"", "otherDetails"=> ["phoneNo"=>$otherdet->phoneno, "class"=>$otherdet->class, "productName"=>"", "amount"=>0],
                        "totalAmount"=>0, "currency"=>CURRENCY, "statusCode"=>"01", "statusMessage"=>"Invalid Customer Reference",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, "", 0, CURRENCY, "01", "Invalid Customer Reference") 
                    ];
        } else {
            $srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); 
            foreach ($srvlist as $key => $value) {
                $amt = $value["AMOUNT"];  //$value["SRVID"]
    //            $pcode = (isset($value["PLANCODE"]) && !is_null($value["PLANCODE"]))? $value["PLANCODE"] : $value["SRVID"];
                $payinfo["otherDetails"] = ["phoneNo"=>$otherdet->phoneno, "class"=>$otherdet->class, "productName" => $value["PLAN"], 
                                    "amount" => $amt, "customerCategory"=> $value["IS_UPCOUNTRY"]? 2 : 1];

    //            if ($xml->PaymentItemCode <> $pcode) $status = 1;   
                break;
            }
            $fname = $sacc[0]["FIRSTNAME"]; //$sacct["$custref"][0]["FIRSTNAME"];
            $lname = $sacc[0]["LASTNAME"]; //$sacct["$custref"][0]["LASTNAME"];
            $email = $sacc[0]["EMAIL"]; //$sacct["$custref"][0]["EMAIL"];
            $mobile = $sacc[0]["MOBILE"]; //$sacct["$custref"][0]["MOBILE"];

        }

        if (isset($payinfo["otherDetails"])):
            return ["referenceID"=>$custref, "customerName"=>trim(trim($fname)." " .trim($lname)), "otherDetails"=> $payinfo["otherDetails"],
                        "totalAmount"=>$amt, "currency"=>CURRENCY, "statusCode"=>"00", "statusMessage"=>"Valid",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, "$fname $lname", "$amt", CURRENCY, "00", "Valid") 
                    ];
        else:
            return ["referenceID"=>$custref, "customerName"=>"", "otherDetails"=> ["phoneNo"=>trim($otherdet->phoneno), "class"=>$otherdet->class, "productName"=>"", "amount"=>0, "customerCategory"=> 0],
                        "totalAmount"=>0, "currency"=>CURRENCY, "statusCode"=>"01", "statusMessage"=>"Unable to retrieve records at the moment",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, "", 0, CURRENCY, "01", "Unable to retrieve records at the moment") 
                    ];
        endif;
    
    } catch (Exception $ex) {
        global $ad, $fields, $logtable;
        $value = "'EXC', '(validationRequest) {$ex->getCode()} :: {$ex->getMessage()}'";
        $ad->insertLog($fields, $value, $logtable);
        
        return ["referenceID"=>$custref, "customerName"=>"", "otherDetails"=> ["phoneNo"=>$otherdet->phoneno, "class"=>$otherdet->class, "productName"=>"", "amount"=>0],
                        "totalAmount"=>0, "currency"=>CURRENCY, "statusCode"=>"01", "statusMessage"=>"Unable to retrieve records at the moment",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, "", 0, CURRENCY, "01", "Unable to retrieve records at the moment") 
                    ];
    }
    
}
/**
 * Generate an Array containing the Payment Notification Response data
 * @param String $xml XML string containing the Payment Notification Request from GTCollections
 * @return mixed An array containing the Payment Notification Response data
 */
function payNotifResp($xml) { //echo $xml->ServiceUrl; print_r($xml);
    $custref = strtolower($xml->referenceID); 
    $txnref = $paylogid = $xml->transReference;
    $txnamt = $xml->totalAmount;
    $hash = $xml->hash;
    $curr = $xml->currency;
    
    try {
        
        $comphash = hashThis(GTC_HASH_KEY, $custref, $txnref, $txnamt, $curr);

        if ($hash != $comphash): 
            return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>"", "responseCode"=> "01",
                        "responseDesc"=>"Invalid Hash",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, "", "01", "Invalid Hash") 
                    ]; // - $comphash - |$custref|$txnref|$txnamt|$curr|".GTC_HASH_KEY."|"
        endif;
        
        $status = 0;
        $ret = [];

        global $ad;
        //echo "YERRRE: $custref ! $txnref !! $paylogid !!!";
        $sacct = $ad->loadRADAccountByUsername($custref);    //print_r($sacct);
    //    $sacc=$sacct["$custref"];   //print_r($sacc); //echo "AGAIN:".$sacc[0]['SERVICE_ID'];
        foreach ($sacct as $key=>$vall):
            $sacc=$vall;
            break;
        endforeach;
        if (count($sacc) < 1):
            return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>"", "responseCode"=> "01",
                        "responseDesc"=>"Invalid Customer Reference",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, "", "01", "Invalid Customer Reference") 
                    ];
        endif;
        
        $srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); //echo "YES";
        foreach ($srvlist as $key => $value) {
            $amount_due = $amt_due = $value["AMOUNT"];
            $planid = $value["PLAN_ID"];
            break;
        }

        $expiry = $ad->getExpirationDate($custref);
    //    $srvlist = $ad->loadPlans($custref);
    //    $amt_due = $srvlist[$custref]["AMOUNT"];
        $nmonths = 1;    

        /*MODIFY*/
        $vval =  $ad->getTranx4Verification($txnref);

        if (count($vval) <= 0) { $saveRet = $ad->saveInitTranx($paylogid, $custref, $expiry, $amount_due, CURRENCY, $nmonths, $planid); }

        /*MODIFY*/
        $vval =  $ad->getTranx4Verification($txnref);
        //upcountry
        $isupcountry = $vval['IS_UPCOUNTRY'];
        if ($isupcountry):
            $erpacct = PAYSTACK_UPCOUNTRY;
        else:
            $erpacct = GTC_FIBERONE;
        endif;
        
        if ( (count($vval) <= 0) || ($txnamt == 0) ) :
            return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>"", "responseCode"=> "01",
                        "responseDesc"=>"Invalid Transaction Reference",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, "", "01", "Invalid Transaction Reference") 
                    ];
        endif;
        
        if ($vval["STATUS_CODE"] == "00") { 
            //Payment Processed to DB Already
            return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$vval['PAY_REFERENCE'], "responseCode"=> "01",
                        "responseDesc"=>"Transaction Already Processed",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $vval['PAY_REFERENCE'], "01", "Transaction Already Processed") 
                    ];
        } else {
            //Not Yet Processed to DB, Process Now!
            if ($vval['DB_UPDATED'] == 1) :
                return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$vval['PAY_REFERENCE'], "responseCode"=> "01",
                        "responseDesc"=>"Transaction Already Processed",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $vval['PAY_REFERENCE'], "01", "Transaction Already Processed") 
                    ];
            endif;
            
            if (($txnamt > 0)) :
                $codeg = new Password_Generator();
                $payref = "GTC-$custref-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);
                
                $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
        
                $exp = isExpired($userdet['EXPIRATION']);
                $expd = $userdet['EXPIRATION'];
                $limitcomb = $userdet["LIMITCOMB"];

                $validity = ($vval["NMONTHS"] >= 12)? ($vval["NMONTHS"]*$userdet["VALIDITY"])+8 : ($vval["NMONTHS"]*$userdet["VALIDITY"]);
                if ($exp) :
                    $nu_expd = add_date(date("Y-m-d H:i:s"), $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                else:
                    $nu_expd = add_date($userdet['EXPIRATION'], $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                endif;
                
                //TODO: Maybe Confirm
        
                //Save Transaction
                $pdate = date("Y-m-d H:i:s"); 
                $appDate = date("Y-m-d H:i:s"); //, strtotime($payxml->PaymentDate)

                $payloc = "GTCollections";
                
                $ad->saveTranxResp($txnref, $payref, $txnamt, CURRENCY, 
                                   "00", "Approved by Financial Institution", $nu_expd, $pdate, 
                                    $payloc, $appDate,
                                   "GTC", $txnref, $txnref, $vval["RAD_USERNAME"]);
                
                $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $txnref, $exp, $vval["NMONTHS"]);
                //Log To ERP
                //if ($vval['ERPID']>0) { $ad->sendToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $txnamt, $vval["RAD_USERNAME"]."-ESERVICE-{$vval["PACKAGE"]}-Renewal(GTC)-$txnref", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], $erpacct, $txnref); }

                //Get Message
                $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
                $url = SERVER_URL . "";
                $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $txnamt, $vval["PACKAGE"], $nu_expd, $txnref, $payref, $url);

                $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on FibreOne Online", $msg);

                //Send Admin Email
                $raw_msg = $ad->getCannedMessage("ADMIN_NOTIFICATION");
                $payDate = $pdate; // date("d-m-Y H:i:s", strtotime($payxml->PaymentDate));
                $msg = sprintf($raw_msg, $txnref, "Approved by Financial Institution", $vval["RAD_USERNAME"], $payDate, number_format($txnamt, 2));

                $adminsent = $ad->sendEmail(PAY_NOTIF_EMAIL, EMAIL_SENDER, "Succesful Transaction on GTCollections", $msg);
                
                return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$payref, "responseCode"=> "00",
                        "responseDesc"=>"Transaction Processed",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $payref, "00", "Transaction Processed") 
                    ];
                
            else: 
                //reverse
            endif;
        
        }
        
    } catch (Exception $ex) {
        global $ad, $fields, $logtable;
        $value = "'EXC', '(paymentUpdateRequest) {$ex->getCode()} :: {$ex->getMessage()}'";
        $ad->insertLog($fields, $value, $logtable);
        
        return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$vval['PAY_REFERENCE'], "responseCode"=> "01",
                        "responseDesc"=>"Unable to retrieve records at the moment",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $vval['PAY_REFERENCE'], "01", "Unable to retrieve records at the moment") 
                    ];
    }
    
    
    
    
}


/**
 * Responds to GTCollection's Transaction Status Query on E-Service
 * @param String $xml XML string containing the Requery Request from GTCollections
 * @return mixed An array containing the Requery Response data for the transaction
 */
function gtRequeryResp($xml) {
    $txnref = $paylogid = $xml->transReference;
    $hash = $xml->hash;
    
    global $ad;
    
    try {
        
        $comphash = hashThis(GTC_HASH_KEY, $txnref);

        if ($hash != $comphash): 
            return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>"", "responseCode"=> "03",
                        "responseDesc"=>"Invalid Hash",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, "", "03", "Invalid Hash") 
                    ];
        endif;
        
        $vval =  $ad->getTranx4Verification($txnref);
        //upcountry
        $isupcountry = $vval['IS_UPCOUNTRY'];
        if ($isupcountry):
            $erpacct = PAYSTACK_UPCOUNTRY;
        else:
            $erpacct = GTC_FIBERONE;
        endif;
        
        if ( (count($vval) <= 0) ) :
            return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>"", "responseCode"=> "03",
                        "responseDesc"=>"Invalid Transaction Reference",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, "", "03", "Invalid Transaction Reference") 
                    ];
        else:
            if ($vval["STATUS_CODE"] == "00") { 
                //Payment Processed to DB Already
                return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$vval['PAY_REFERENCE'], "responseCode"=> "00",
                            "responseDesc"=>"Successful",
                            "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $vval['PAY_REFERENCE'], "00", "Successful") 
                        ];
            } else {
                return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$vval['PAY_REFERENCE'], "responseCode"=>$vval['STATUS_CODE'],
                            "responseDesc"=>$vval['STATUS_MSG'],
                            "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $vval['PAY_REFERENCE'], $vval['STATUS_CODE'], $vval['STATUS_MSG']) 
                        ];
            }
        endif;
    
    } catch (Exception $ex) {
        global $ad, $fields, $logtable;
        $value = "'EXC', '(requeryRequest) {$ex->getCode()} :: {$ex->getMessage()}'";
        $ad->insertLog($fields, $value, $logtable);
        
        return ["referenceID"=>$custref, "transReference"=>$txnref, "paymentReference"=>$vval['PAY_REFERENCE'], "responseCode"=> "03",
                        "responseDesc"=>"Unable to retrieve records at the moment",
                        "hash"=> hashThis(GTC_HASH_KEY, $custref, $txnref, $vval['PAY_REFERENCE'], "03", "Unable to retrieve records at the moment") 
                    ];
    }
    
}

function soapcall($data) {
    global $gtcollapiurl;
    $client = new SoapClient($gtcollapiurl); //'http://www.webservicex.net/globalweather.asmx?WSDL'
    $response = $client->TransactionRequery_TransRef(json_encode($data));
    
    return $response;
}