<?php
$page = "Orders";
$page_url = "fob_orders";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
  ?>
  <script>
    window.location.href = 'vendor_dashboard';
  </script>
  <?php
  exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$fob_vendor_id = $dashboard->getFobVendor();

$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

$vendorOrders = $dashboard->getFobOrders($fob_vendor_id);

$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//print_r($fob_vendor_id);
?>

<style>
  .main-content {
    margin-left: 230px;
    padding: 0;
    min-height: 100vh;
    background-color: white;
  }

  .top-bar {
    background: white;
    padding: 15px 30px;
    border-bottom: 1px solid #e9ecef;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    position: sticky;
    top: 0;
    z-index: 100;
  }

  .page-title {
    color: #0f172a;
    font-size: 23px;
    font-weight: 500;
    margin: 0;
  }

  .content-area {
    padding: 0 30px 30px;
  }

  .breadcrumb {
    background: none;
    padding: 0;
    margin: 5px 0 10px;
  }

  .breadcrumb a {
    color: #6c757d;
    text-decoration: none;
    font-size: 14px;
  }

  .breadcrumb a:hover {
    color: #2563eb;
  }

  .breadcrumb span {
    color: #6c757d;
    margin: 0 8px;
  }

  .breadcrumb .active {
    color: #333;
    font-size: 14px;
  }

  .stats-row {
    margin-bottom: 30px;
    display: flex;
    gap: 20px;
    flex-wrap: wrap;
  }

  .stat-card {
    background: white;
    border-radius: 8px;
    padding: 25px;
    border: 1px solid #e4e4e7;
    position: relative;
    flex: 1;
    min-width: 200px;
    max-width: 300px;
  }

  .stat-header {
    display: flex;
    justify-content: space-between;
    color: #0f172a;
  }

  .stat-value {
    font-size: 23px;
    font-weight: 700;
    color: #0f172a;
    margin-bottom: 5px;
  }

  .stat-label {
    color: #6c757d;
    font-size: 14px;
    margin-bottom: 15px;
  }

  .stat-icon {
    width: 40px;
    height: 40px;
  }

  .sales-section {
    background: white;
    border-radius: 8px;
    border: 1px solid #e9ecef;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
  }

  .sales-header {
    padding: 25px 25px 15px;
    border-bottom: 1px solid #f8f9fa;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }

  .sales-title {
    font-size: 18px;
    font-weight: 600;
    color: #0f172a;
    margin: 0;
  }

  .sales-subtitle {
    color: #6c757d;
    font-size: 14px;
    margin-top: 5px;
  }

  .search-area {
    display: flex;
    justify-content: space-between;
    margin: 20px 0;
    flex-wrap: wrap;
    gap: 10px;
  }

  .input-group {
    width: 300px;
    display: flex;
  }

  .form-control {
    border: 1px solid #ddd;
    /* padding: 17px 12px; */
    border-radius: 4px 0 0 4px;
    font-size: 14px;
  }

  .input-group-btn .btn {
    border-radius: 0 4px 4px 0;
    border: 1px solid #ddd;
    border-left: none;
    padding: 7px 12px;
    background: #f8f9fa;
  }

  .btn-filter {
    border: 1px solid #ddd;
    padding: 8px 16px;
    border-radius: 4px;
    background: #f8f9fa;
    color: #333;
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 8px;
  }

  .table-responsive {
    overflow-x: auto;
  }

  .table {
    margin: 0;
    width: 100%;
    border-collapse: collapse;
  }

  .table thead {
    background: #f8f9fa;
    border-bottom: 1px solid #e9ecef;
  }

  .table th {
    padding: 15px 25px;
    border: none;
    font-weight: 500;
    color: #6c757d;
    font-size: 14px;
  }

  .table td {
    padding: 15px 25px;
    border: none;
    vertical-align: middle;
    border-bottom: 1px solid #f8f9fa;
  }

  .customer-info {
    display: flex;
    align-items: center;
  }

  .customer-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    margin-right: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 14px;
  }

  .customer-details h6 {
    margin: 0;
    color: #0f172a;
    font-size: 14px;
    font-weight: 500;
  }

  .customer-details p {
    margin: 2px 0 0;
    color: #6c757d;
    font-size: 12px;
  }

  .label {
    padding: 4px 12px;
    border-radius: 12px;
    font-size: 12px;
    color: white;
  }

  .action-container {
    position: relative;
  }

  .action-btn {
    color: #6c757d;
    padding: 5px;
    background: none;
    border: none;
  }

  .itemdropdown {
    display: none;
    position: absolute;
    background-color: white;
    box-shadow: 0px 2px 8px rgba(0, 0, 0, 0.2);
    z-index: 10;
    right: 0;
    top: 45px;
    min-width: 160px;
    border-radius: 6px;
    overflow: hidden;
  }

  .itemdropdown a,
  .actions-header {
    padding: 10px 15px;
    display: block;
    text-decoration: none;
    color: #333;
  }

  .actions-header {
    border-bottom: 1px solid #eee;
    font-weight: 600;
  }

  .itemdropdown a:hover {
    background-color: #f1f1f1;
  }

  .itemdropdown a:last-child {
    color: red;
  }

  .modal {
    display: none;
    position: fixed;
    z-index: 50;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5);
  }

  .modal-content {
    background-color: white;
    margin: 60px auto;
    padding: 20px;
    border-radius: 10px;
    width: 90%;
    max-width: 600px;
  }

  .modal-header {
    font-size: 18px;
    font-weight: bold;
    margin-bottom: 10px;
  }

  .modal-body {
    border-top: 1px solid #ddd;
    padding-top: 10px;
  }

  .modal-body p,
  .modal-body div {
    margin: 8px 0;
  }

  .close-btn {
    float: right;
    font-size: 20px;
    cursor: pointer;
  }

  .info-table {
    width: 100%;
    margin-top: 10px;
  }

  .info-table td {
    padding: 6px;
  }

  .section-title {
    font-weight: bold;
    margin-top: 10px;
  }

  .total {
    font-weight: bold;
    font-size: 16px;
  }

  .divider {
    border-top: 1px solid #ddd;
    margin: 10px 0;
  }

  .pagination {
    padding: 20px 25px;
    border-top: 1px solid #f8f9fa;
    display: flex;
    justify-content: flex-end;
    gap: 8px;
    align-items: center;
  }

  .pagination .btn {
    border: 1px solid #ddd;
    padding: 5px 10px;
    background: #f8f9fa;
  }

  @media (max-width: 768px) {
    .main-content {
      margin-left: 0;
    }

    .content-area {
      padding: 0 15px 30px;
    }

    .stat-card {
      margin-bottom: 15px;
      max-width: 100%;
    }

    .input-group {
      width: 100%;
    }

    .table th,
    .table td {
      padding: 10px 15px;
    }
  }

  @media (max-width: 576px) {
    .search-area {
      flex-direction: column;
      align-items: stretch;
    }

    .btn-filter {
      width: 100%;
      justify-content: center;
    }

    .table th,
    .table td {
      font-size: 12px;
    }

    .customer-avatar {
      width: 30px;
      height: 30px;
      font-size: 12px;
    }
  }
</style>

<!-- Main Content -->
<div class="main-content">
  <!-- Top Bar -->
  <div class="top-bar">
    <h1 class="page-title">Dashboard</h1>
  </div>

  <!-- Content Area -->
  <div class="content-area">
    <!-- Breadcrumb -->
    <nav class="breadcrumb">
      <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
      <span>></span>
      <span class="active">Orders</span>
    </nav>


    <!-- Stats Row -->

    <!-- Search and Filter Area -->
    <div class="search-area">
      <div class="input-group">
        <input type="text" class="form-control" placeholder="Search orders" id="searchInput" />
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">
            <i class="fa fa-search"></i>
          </button>
        </span>
      </div>
      <!-- <button class="btn-filter">
        <i class="fa fa-filter"></i>Filter
      </button> -->
      <!-- Add this inside .search-area -->
      <select id="statusFilter" class="form-control" style="width:180px; color: black ">
        <option value="" selected>All Status</option>
        <option value="fulfilled payment">Fulfilled Payment</option>
        <option value="pending payment">Pending Payment</option>
        <option value="cancelled payment">Cancelled Payment</option>
        <option value="refunded payment">Refunded Payment</option>
      </select>
    </div>

    <!-- Orders Section -->
    <div class="sales-section">
      <div class="sales-header">
        <div>
          <h3 class="sales-title">Recent Orders</h3>
          <p class="sales-subtitle">Recent Orders from your Stores</p>
        </div>
      </div>

      <!-- Orders Table -->
      <div class="table-responsive">
        <table class="table table-hover">
          <thead>
            <tr>
              <th><input type="checkbox" id="selectAll" /> Name</th>
              <th>Order ID</th>
              <th>Status</th>
              <th>Total Price</th>
              <th>Date of Order</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($vendorOrders)): ?>
              <?php
              $avatarColors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
              $statusColors = [
                'fulfilled' => '#4caf50',
                'pending' => '#ff9800',
                'cancelled' => '#f44336',
                'refunded' => '#9c27b0'
              ];
              foreach ($vendorOrders as $index => $order):
                $avatarColor = $avatarColors[$index % count($avatarColors)];
                $status = strtolower($order['status']);
                $statusColor = $statusColors[$status] ?? '#607d8b';
                $initials = strtoupper(substr($order['customer_name'], 0, 1) . (strpos($order['customer_name'], ' ') !== false ? substr($order['customer_name'], strpos($order['customer_name'], ' ') + 1, 1) : ''));
                ?>
                <tr data-order-id="<?= htmlspecialchars($order['order_id']) ?>">
                  <td>
                    <div style="display: flex; align-items: center">
                      <input type="checkbox" class="order-checkbox" />
                      <div class="customer-info">
                        <div class="customer-avatar <?= $avatarColor ?>"><?= $initials ?></div>
                        <div class="customer-details">
                          <h6><?= htmlspecialchars($order['customer_name']) ?></h6>
                          <p><?= htmlspecialchars($order['customer_email']) ?></p>
                        </div>
                      </div>
                    </div>
                  </td>
                  <td>
                    <a href="/eservice/order_detail.php?id=<?= urlencode(base64_encode($order['order_id'])) ?>"
                      style="color: #1976d2; text-decoration: none;">
                      #<?= htmlspecialchars($order['order_id']) ?>
                    </a>
                  </td>
                  <td>
                    <span class="label" style="background: <?= $statusColor ?>;">
                      <span><?= ucfirst(htmlspecialchars($status)) ?> Payment</span>
                    </span>
                  </td>
                  <td>N<?= number_format($order['total_amount'], 2) ?></td>
                  <td><?= date('Y-m-d H:i', strtotime($order['created_at'])) ?></td>
                  <td>
                    <div class="action-container">
                      <button class="view-btn" onclick="viewOrder(<?= $order['order_id'] ?>)">
                        <i class="fa fa-eye"></i>
                      </button>

                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" style="text-align: center; color: #777;">No orders found for this vendor.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- Pagination -->
      <div class="pagination">
        <div style="color: #6c757d; font-size: 14px">Page 1 of 10</div>
        <div>
          <button class="btn btn-default btn-sm"><i class="fa fa-angle-double-left"></i></button>
          <button class="btn btn-default btn-sm"><i class="fa fa-angle-left"></i></button>
          <button class="btn btn-default btn-sm"><i class="fa fa-angle-right"></i></button>
          <button class="btn btn-default btn-sm"><i class="fa fa-angle-double-right"></i></button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<div id="orderModal" class="modal">
  <div class="modal-content">
    <span class="close-btn" id="closeModal">&times;</span>
    <div class="modal-header">Order</div>
    <div class="modal-body">
      <div class="order-date"><strong>Date:</strong> <span></span></div>
      <div class="section-title">Order Details</div>
      <table class="info-table order-details"></table>
      <div class="divider"></div>
      <table class="info-table order-summary">
        <tr>
          <td>Subtotal:</td>
          <td class="subtotal"></td>
        </tr>
        <tr>
          <td>Shipping:</td>
          <td class="shipping"></td>
        </tr>
        <tr>
          <td>Tax:</td>
          <td class="tax"></td>
        </tr>
        <tr class="total">
          <td>Total:</td>
          <td class="total-amount"></td>
        </tr>
      </table>
      <div class="divider"></div>
      <div class="section-title">Customer Information</div>
      <table class="info-table customer-info">
        <tr>
          <td>Customer:</td>
          <td class="customer-name"></td>
        </tr>
        <tr>
          <td>Email:</td>
          <td class="customer-email"></td>
        </tr>
        <tr>
          <td>Phone:</td>
          <td class="customer-phone"></td>
        </tr>
        <tr>
          <td>Address:</td>
          <td class="customer-address"></td>
        </tr>
      </table>
    </div>
  </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
  // Navigation function
  function navigateTo(page) {
    window.location.href = page === 'dashboard' ? 'vendor_dashboard.php' : '#';
  }

  // Search functionality
  $('#searchInput').on("keyup", function () {
    var searchTerm = $(this).val().toLowerCase();
    $("tbody tr").each(function () {
      var customerName = $(this).find(".customer-details h6").text().toLowerCase();
      var orderId = $(this).find("td:nth-child(2) a").text().toLowerCase();
      if (customerName.indexOf(searchTerm) === -1 && orderId.indexOf(searchTerm) === -1) {
        $(this).hide();
      } else {
        $(this).show();
      }
    });
  });

  // View order details
  function viewOrder(orderId) {
    window.location.href = `/eservice/order_detail.php?id=${encodeURIComponent(btoa(orderId))}`;
  }

  // Filter by status
  $('#statusFilter').on('change', function () {
    var selectedStatus = $(this).val();
    $("tbody tr").each(function () {
      var statusText = $(this).find(".label span").text().toLowerCase();
      if (!selectedStatus || statusText === selectedStatus) {
        $(this).show();
      } else {
        $(this).hide();
      }
    });
  });

  // // Combine with search filter
  // $('#searchInput').on("keyup", function () {
  //   var searchTerm = $(this).val().toLowerCase();
  //   var selectedStatus = $('#statusFilter').val();
  //   $("tbody tr").each(function () {
  //     var customerName = $(this).find(".customer-details h6").text().toLowerCase();
  //     var orderId = $(this).find("td:nth-child(2) a").text().toLowerCase();
  //     var statusText = $(this).find(".label").text().toLowerCase();
  //     var matchesSearch = customerName.indexOf(searchTerm) !== -1 || orderId.indexOf(searchTerm) !== -1;
  //     var matchesStatus = !selectedStatus || statusText === selectedStatus;
  //     if (matchesSearch && matchesStatus) {
  //       $(this).show();
  //     } else {
  //       $(this).hide();
  //     }
  //   });
  // });

  // Filter button functionality
  $('.btn-filter').click(function () {
    alert("Filter Orders - This would show filter options");
  });

  // Checkbox functionality
  $('#selectAll').change(function () {
    var isChecked = $(this).is(":checked");
    $('.order-checkbox').prop("checked", isChecked);
  });

  // Modal and dropdown functionality
  const modal = document.getElementById("orderModal");
  const closeModal = document.getElementById("closeModal");

  closeModal.addEventListener("click", () => {
    modal.style.display = "none";
  });

  window.addEventListener("click", (event) => {
    if (event.target === modal) {
      modal.style.display = "none";
    }
  });

  document.querySelectorAll(".action-btn").forEach((button) => {
    button.addEventListener("click", (e) => {
      e.preventDefault();
      const itemdropdown = button.closest(".action-container").querySelector(".itemdropdown");
      document.querySelectorAll(".itemdropdown").forEach((d) => {
        if (d !== itemdropdown) d.style.display = "none";
      });
      itemdropdown.style.display = itemdropdown.style.display === "block" ? "none" : "block";
    });
  });

  window.addEventListener("click", (event) => {
    if (!event.target.closest(".action-container")) {
      document.querySelectorAll(".itemdropdown").forEach((itemdropdown) => {
        itemdropdown.style.display = "none";
      });
    }
  });

  // // View button functionality
  // document.querySelectorAll(".view-btn").forEach((viewBtn) => {
  //   viewBtn.addEventListener("click", (e) => {
  //     e.preventDefault();
  //     const row = viewBtn.closest("tr");
  //     const orderId = row.dataset.orderId;
  //     const customerName = row.querySelector(".customer-details h6").textContent;
  //     const customerEmail = row.querySelector(".customer-details p").textContent;
  //     const orderDate = row.querySelector("td:nth-child(5)").textContent;
  //     const totalPrice = row.querySelector("td:nth-child(4)").textContent;

  //     // Fetch order details via AJAX (placeholder for actual implementation)
  //     $.ajax({
  //       type: "GET",
  //       url: "ajax/get_order_details.php",
  //       data: {
  //         order_id: orderId
  //       },
  //       dataType: "json",
  //       success: function (data) {
  //         if (data.success) {
  //           document.querySelector(".modal-header").textContent = `Order #${orderId}`;
  //           document.querySelector(".order-date span").textContent = orderDate;
  //           document.querySelector(".order-details").innerHTML = data.items.map(item => `
  //                           <tr>
  //                               <td>${item.name} x${item.quantity}</td>
  //                               <td>N${item.price.toFixed(2)}</td>
  //                           </tr>
  //                       `).join('');
  //           document.querySelector(".subtotal").textContent = `N${data.subtotal.toFixed(2)}`;
  //           document.querySelector(".shipping").textContent = `N${data.shipping.toFixed(2)}`;
  //           document.querySelector(".tax").textContent = `N${data.tax.toFixed(2)}`;
  //           document.querySelector(".total-amount").textContent = `N${data.total.toFixed(2)}`;
  //           document.querySelector(".customer-name").textContent = customerName;
  //           document.querySelector(".customer-email").textContent = customerEmail;
  //           document.querySelector(".customer-phone").textContent = data.customer_phone || 'N/A';
  //           document.querySelector(".customer-address").textContent = data.customer_address || 'N/A';
  //           modal.style.display = "block";
  //         } else {
  //           alert("Failed to load order details: " + data.message);
  //         }
  //       },
  //       error: function () {
  //         alert("Error fetching order details. Please try again.");
  //       }
  //     });
  //     viewBtn.closest(".itemdropdown").style.display = "none";
  //   });
  // });

  // Status update functionality
  document.querySelectorAll(".mark-fulfilled, .mark-declined, .mark-cancelled").forEach((actionBtn) => {
    actionBtn.addEventListener("click", (e) => {
      e.preventDefault();
      const row = actionBtn.closest("tr");
      const orderId = row.dataset.orderId;
      const status = actionBtn.dataset.status;
      const statusSpan = row.querySelector(".label");
      const bgColor = status === "Fulfilled" ? "#4caf50" : status === "Declined" ? "#ff9800" : "#f44336";

      $.ajax({
        type: "POST",
        url: "ajax/update_order_status.php",
        data: {
          order_id: orderId,
          status: status
        },
        dataType: "json",
        success: function (data) {
          if (data.success) {
            statusSpan.textContent = status;
            statusSpan.style.background = bgColor;
            alert(`Order marked as ${status}`);
          } else {
            alert(`Failed to update status: ${data.message}`);
          }
        },
        error: function () {
          alert("Error updating order status. Please try again.");
        }
      });
      actionBtn.closest(".itemdropdown").style.display = "none";
    });
  });

  // Table row hover effects
  $("tbody tr").hover(
    function () {
      $(this).css("background-color", "#f8f9fa");
    },
    function () {
      $(this).css("background-color", "white");
    }
  );

  // Initialize tooltips
  $(function () {
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>