<?PHP
$page = "Full Admin Dashboard";
$page_url = "dashi";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script> window.location.href = 'dasha';</script>
    <?PHP
    exit();
endif;


if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'usertype_id'] == 25)):
    ?>
    <script> window.location.href = 'marketdash';</script>
    <?PHP
    exit();
endif;
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new AdminDashboard($db);
$locations = $dashboard->getLocations();
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];

$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>

<style>
    .stateName {
        padding-left: 3px !important;

    }

    .nTranxContainer {
        text-align: right;
    }

    .stat-table {
        font-size: 0.8em;
    }

    .stat-table>table>thead {
        background-color: #0f1d77;
        color: white;
    }

    .box {
        border-radius: 7px;
        -webkit-box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        -moz-box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
    }

    .box .overlay {
        background: rgba(255, 255, 255, 0.85);
        border-radius: 6px;
    }

    .lastone,
    .lastone>.box,
    .lastone>.box>.box-footer {
        background-color: #eee !important;
        /*#144b90*/
        /* 	border-top: 0px; */
    }

    .widget-user .widget-user-image>span {
        width: 90px;
        height: auto;
        border: 3px solid #fff;
        vertical-align: middle;
        padding: 15px 15px;
        font-size: 1.2em;
    }

    .widget-user .box-footer {
        padding-top: 1px;
        height: 130px;
        /* 155px;*/
    }

    .widget-user .widget-user-header {
        padding: 10px !important;
        min-height: 60px !important;
        border-top-left-radius: 20px;
    }

    .box .border-right {
        border-right: 1px solid #e6d8d8;
    }

    .border-bottom {
        border-bottom: 1px solid #e6d8d8;
    }

    .border-top {
        border-top: 1px solid #e6d8d8;
    }

    .nav-stacked>li>a {
        /*     font-size: 1.2em;  */
    }

    .nav-stacked>li>a>span {
        /*font-size: 1.1em; */
    }

    .widget-user .widget-user-image {
        left: 55% !important;
    }

    .widget-user .widget-user-username {
        font-size: 15px !important;
        /*20px*/
        font-weight: 500 !important;
    }

    .center-box {
        -webkit-border-radius: 20px;
        -moz-border-radius: 20px;
        border-radius: 20px;
    }

    .description-block>.description-header {
        font-size: 0.8em !important;
    }

    .description-block>.description-text {
        font-size: 0.8em !important;
    }

    .description-block {
        cursor: pointer;
        /*font-size: 0.7em !important;*/
    }

    .description-block:hover {
        background-color: #e1f1f5 !important;
    }

    .vmiddle {
        padding-top: 30px;
    }

    .col-sm-4,
    .col-sm-6 {
        padding-left: 5px !important;
        padding-right: 5px !important;
    }

    .widget-user-image {
        display: none;
    }

    .progress-description {
        font-size: 1.2em;
        font-weight: bolder;
    }

    .progress-description>.subtext {
        float: right !important;
        font-weight: normal;
        font-size: 0.8em;
        display: inline-block;
    }

    .progress-description>.subvalue {
        /*float: right !important;*/
        font-weight: normal;
        font-size: 0.8em;
        display: inline-block;
    }

    .row>.width-20p {
        width: 19%;
        display: inline-block;
    }

    .gray-bg {
        background-color: lightgray !important;
    }

    .widget-user .box-footer {
        padding-top: 0px;
        border-bottom-right-radius: 20px;
    }

    .row {
        margin-left: -10px;
        margin-right: -10px;
    }

    .box.box-widget {
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
        background-color: #e1e1e1;
    }

    .micon {
        font-size: 0.8em;
        margin-right: 3px;
    }

    .amountBlock {
        text-align: right;
    }

    .iSelect {
        border: 2px outset #aaa2a2;
        -webkit-box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.4);
        -moz-box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.4);
    }

    .downloadIcon {
        color: #d81b60;
        font-size: 0.8em;
        margin-left: 5px;
        cursor: pointer;
    }

    .nolink {
        cursor: auto;
    }

    .stateName .col-sm-5 {
        padding-right: 1px;
    }

    .nTranxContainer .col-sm-2 {
        padding-left: 5px;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><!--  style="color:#eee"> -->
            Dashboard
            <small>Control panel</small> <!--  style="color: #aaa" -->
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>
    <!-- ./Content Header (Page header) -->

    <!-- Main content -->
    <section class="content">

        <!-- STATISTICS ROW 1 -->
        <div class="row">

            <!-- TOTAL CUSTOMERS -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">Customers &nbsp;<i class="downloadIcon fa fa-download" data-category="all"
                                data-action="totalCust"></i></h3>

                        <div class="box-tools pull-right">
                            <select id="custType" name="custType" class="iSelect" data-caller="cust">
                                <option value="all">All Customers</option>
                                <?PHP
                                foreach ($locations as $location):
                                    echo "<option value='{$location}'>{$location}</option>";
                                endforeach;
                                ?>
                            </select>

                        </div>
                        <div>
                            <span>Total - </span><span id="totalCustomer">xx,xxx</span>
                            <span id="onlineCustomer" style="float:right">xx,xxx</span><span style="float:right">Online
                                - </span>
                        </div>
                        <!--<div>
                            <span>Online - </span><span>21,032</span>
                        </div>-->
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="chart-responsive" id="custContainer">
                                    <canvas id="customerPieChart" height="150" style="max-height:250px;"></canvas>
                                </div>
                                <!-- ./chart-responsive -->
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        <ul class="nav nav-pills nav-stacked">
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:#00a65a;'></i> Active
                                    <i class="downloadIcon fa fa-download" data-category="active"
                                        data-action="totalCust"></i>
                                    <span id="activeCustomer" class="pull-right text-green">xx,xxx</span></a></li>
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:#f56954;'></i> Expired
                                    <i class="downloadIcon fa fa-download" data-category="expired"
                                        data-action="totalCust"></i>
                                    <span id="expiredCustomer" class="pull-right text-red">x,xxx</span></a>
                            </li>
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:#00c0ef;'></i> Paused
                                    <i class="downloadIcon fa fa-download" data-category="paused"
                                        data-action="totalCust"></i>
                                    <span id="pausedCustomer" class="pull-right text-yellow">xxx</span></a></li>
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:rgba(18, 31, 113, 1);'></i> Pending
                                    <i class="downloadIcon fa fa-download" data-category="pending"
                                        data-action="totalCust"></i>
                                    <span id="pendingCustomer" class="pull-right text-yellow">xxx</span></a></li>
                        </ul>
                    </div>
                    <!-- /.footer -->
                    <!-- Loading (remove the following to stop the loading)-->
                    <div id="totalCustomerOverlay" class="overlay">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>
                    <!-- end loading -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.md-4 Total Customer -->


            <!-- New CUSTOMERS -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">New Customers &nbsp;<i class="downloadIcon fa fa-download"
                                data-category="all" data-action="newCust"></i></h3>

                        <div class="box-tools pull-right">
                            <select id="newCustDuration" name="newCustDuration" class="iSelect" data-caller='newCust'>
                                <option value="thisMonth">This Month</option>
                                <option value="lastMonth">Last Month</option>
                                <option value="7">Last 7 days</option>
                                <option value="15">Last 15 days</option>
                                <option value="30">Last 30 days</option>
                                <option value="60">Last 60 days</option>
                                <option value="last3Months">Last 3 Months</option>
                                <option value="last6Months">Last 6 Months</option>
                                <option value="thisYear">This Year</option>
                                <option value="lastYear">Last Year</option>
                            </select>

                        </div>
                        <div>
                            <span>Total - </span><span id="newCustTotal">xx,xxx</span>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="chart-responsive" id="newCustContainer">
                                    <canvas id="newCustomerPieChart" height="150" style="max-height:250px;"></canvas>
                                </div>
                                <!-- ./chart-responsive -->
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        <ul class="nav nav-pills nav-stacked">
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:#00a65a;'></i> Lagos
                                    <i class="downloadIcon fa fa-download" data-category="Lagos"
                                        data-action="newCust"></i>
                                    <span id="newCustLagos" class="pull-right text-green">xx</span></a></li>
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:#f56954;'></i> Abuja
                                    <i class="downloadIcon fa fa-download" data-category="Abuja"
                                        data-action="newCust"></i>
                                    <span id="newCustAbuja" class="pull-right text-red">xx</span></a>
                            </li>
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:#00c0ef;'></i> Port-Harcourt
                                    <i class="downloadIcon fa fa-download" data-category="Port Harcourt"
                                        data-action="newCust"></i>
                                    <span id="newCustPH" class="pull-right text-yellow">xx</span></a></li>
                            <li><a class="nolink" href="#"><i class="fa fa-circle" aria-hidden="true"
                                        style='color:rgba(18, 31, 113, 1);'></i> Ilorin
                                    <i class="downloadIcon fa fa-download" data-category="Ilorin"
                                        data-action="newCust"></i>
                                    <span id="newCustIlorin" class="pull-right text-yellow">xx</span></a></li>
                        </ul>
                    </div>
                    <!-- /.footer -->
                    <!-- Loading (remove the following to stop the loading)-->
                    <div id="newCustomerOverlay" class="overlay">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>
                    <!-- end loading -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.md-4 New Customer -->


            <!-- Service Renewals -->
            <div class="col-md-4">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title">Service Renewals &nbsp;<i class="downloadIcon fa fa-download"
                                data-category="all" data-action="serviceRenewal"></i></h3>

                        <div class="box-tools pull-right">
                            <select id="tranxDuration" name="tranxDuration" class="iSelect" data-caller="tranx">
                                <option value="thisMonth">This Month</option>
                                <option value="lastMonth">Last Month</option>
                                <option value="7">Last 7 days</option>
                                <option value="15">Last 15 days</option>
                                <option value="30">Last 30 days</option>
                                <option value="60">Last 60 days</option>
                                <option value="last3Months">Last 3 Months</option>
                                <option value="last6Months">Last 6 Months</option>
                                <option value="thisYear">This Year</option>
                                <option value="lastYear">Last Year</option>
                            </select>

                        </div>
                        <div>
                            <span id="nTranx">xx,xxx</span><span> Transactions - </span><span id="tranxAmount">&#8358;
                                xxx,xxx,000.00</span>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="chart-responsive" id="tranxContainer">
                                    <canvas id="transactionPieChart" height="150" style="max-height:250px;"></canvas>
                                </div>
                                <!-- ./chart-responsive -->
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        <ul class="nav nav-pills nav-stacked">
                            <li><a class="nolink" href="#">.
                                    <span class="stateName col-sm-5"><i class="fa fa-circle micon" aria-hidden="true"
                                            style='color:#00a65a;'></i> Lagos
                                        <i class="downloadIcon fa fa-download" data-category="Lagos"
                                            data-action="serviceRenewal"></i></span>
                                    <span id="nTranxLagos" class="nTranxContainer col-sm-2">xx,000</span>
                                    <span id="tranxLagos"
                                        class="pull-right text-green col-sm-4 amountBlock">&#8358;xxx,xxx,000.00</span></a>
                            </li>
                            <li><a class="nolink" href="#">.
                                    <span class="stateName col-sm-5"><i class="fa fa-circle micon" aria-hidden="true"
                                            style='color:#f56954;'></i> Abuja
                                        <i class="downloadIcon fa fa-download" data-category="Abuja"
                                            data-action="serviceRenewal"></i></span>
                                    <span id="nTranxAbuja" class="nTranxContainer col-sm-2">x,xxx</span>
                                    <span id="tranxAbuja"
                                        class="pull-right text-red col-sm-4 amountBlock">&#8358;xx,xxx,000.00</span></a>
                            </li>
                            <li><a class="nolink" href="#">.
                                    <span class="stateName col-sm-5"><i class="fa fa-circle micon" aria-hidden="true"
                                            style='color:#00c0ef;'></i> Port-Harcourt
                                        <i class="downloadIcon fa fa-download" data-category="Port Harcourt"
                                            data-action="serviceRenewal"></i></span>
                                    <span id="nTranxPH" class="nTranxContainer col-sm-2">x,xxx</span>
                                    <span id="tranxPH"
                                        class="pull-right text-yellow col-sm-4 amountBlock">&#8358;xx,000,000.00</span></a>
                            </li>
                            <li><a class="nolink" href="#">.
                                    <span class="stateName col-sm-5"><i class="fa fa-circle micon" aria-hidden="true"
                                            style='color:rgba(18, 31, 113, 1);'></i> Ilorin
                                        <i class="downloadIcon fa fa-download" data-category="Ilorin"
                                            data-action="serviceRenewal"></i></span>
                                    <span id="nTranxIlorin" class="nTranxContainer col-sm-2">x,xx0</span>
                                    <span id="tranxIlorin"
                                        class="pull-right text-yellow col-sm-4 amountBlock">&#8358;xxx,000.00</span></a>
                            </li>
                        </ul>
                    </div>
                    <!-- /.footer -->
                    <!-- Loading (remove the following to stop the loading)-->
                    <div id="serviceRenewalOverlay" class="overlay">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>
                    <!-- end loading -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.md-4 Service Renewal -->

        </div>


        <!-- STATISTICS ROW 2 -->
        <div class="row">

            <!-- Expiring -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">Expiring</h3>

                        <div class="box-tools pull-right">
                            &nbsp;
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <!--<div class="row">
                            <div class="col-md-12">-->
                        <div class="table-responsive table-striped stat-table">
                            <table class="table no-margin">
                                <thead>
                                    <tr>
                                        <th>Location</th>
                                        <th>Today</th>
                                        <th>Tomorrow</th>
                                        <th>In
                                            <=10<br />days
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Lagos <i class="downloadIcon fa fa-download" data-category="Lagos"
                                                data-action="expiringCust"></i></td>
                                        <td><span id="expiringTodayLagos"></span></td>
                                        <td><span id="expiringTomorrowLagos"></span></td>
                                        <td><span id="expiringIn10Lagos"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Abuja <i class="downloadIcon fa fa-download" data-category="Abuja"
                                                data-action="expiringCust"></i></td>
                                        <td><span id="expiringTodayAbuja"></span></td>
                                        <td><span id="expiringTomorrowAbuja"></span></td>
                                        <td><span id="expiringIn10Abuja"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Port-Harcourt <i class="downloadIcon fa fa-download"
                                                data-category="Port Harcourt" data-action="expiringCust"></i></td>
                                        <td><span id="expiringTodayPH"></span></td>
                                        <td><span id="expiringTomorrowPH"></span></td>
                                        <td><span id="expiringIn10PH"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Ilorin <i class="downloadIcon fa fa-download" data-category="Ilorin"
                                                data-action="expiringCust"></i></td>
                                        <td><span id="expiringTodayIlorin"></span></td>
                                        <td><span id="expiringTomorrowIlorin"></span></td>
                                        <td><span id="expiringIn10Ilorin"></span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!--</div>
                            <!-- /.col -->
                        <!--</div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        &nbsp;
                    </div>
                    <!-- /.footer -->
                    <!-- Loading (remove the following to stop the loading)-->
                    <div id="expiringOverlay" class="overlay">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>
                    <!-- end loading -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.md-4 Expiring -->


            <!-- Expired -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Expired</h3>

                        <div id="expiredTotal" class="box-tools pull-right">
                            x,xxx
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <!--<div class="row">
                            <div class="col-md-12">-->
                        <div class="table-responsive table-striped stat-table">
                            <table class="table no-margin">
                                <thead>
                                    <tr>
                                        <th>Location</th>
                                        <th>0-30<br>days</th>
                                        <th>31-89<br>days</th>
                                        <th>>= 90<br />days</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Lagos <i class="downloadIcon fa fa-download" data-category="Lagos"
                                                data-action="expiredCust"></i></td>
                                        <td><span id="expiredLTE30Lagos"></span></td>
                                        <td><span id="expired31To89Lagos"></span></td>
                                        <td><span id="expiredGTE90Lagos"></span></td>
                                        <td><span id="expiredTotalLagos"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Abuja <i class="downloadIcon fa fa-download" data-category="Abuja"
                                                data-action="expiredCust"></i></td>
                                        <td><span id="expiredLTE30Abuja"></span></td>
                                        <td><span id="expired31To89Abuja"></span></td>
                                        <td><span id="expiredGTE90Abuja"></span></td>
                                        <td><span id="expiredTotalAbuja"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Port-Harcourt <i class="downloadIcon fa fa-download"
                                                data-category="Port Harcourt" data-action="expiredCust"></i></td>
                                        <td><span id="expiredLTE30PH"></span></td>
                                        <td><span id="expired31To89PH"></span></td>
                                        <td><span id="expiredGTE90PH"></span></td>
                                        <td><span id="expiredTotalPH"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Ilorin <i class="downloadIcon fa fa-download" data-category="Ilorin"
                                                data-action="expiredCust"></i></td>
                                        <td><span id="expiredLTE30Ilorin"></span></td>
                                        <td><span id="expired31To89Ilorin"></span></td>
                                        <td><span id="expiredGTE90Ilorin"></span></td>
                                        <td><span id="expiredTotalIlorin"></span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!--</div>
                            <!-- /.col -->
                        <!--</div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        &nbsp;
                    </div>
                    <!-- /.footer -->
                    <!-- Loading (remove the following to stop the loading)-->
                    <div id="expiredOverlay" class="overlay">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>
                    <!-- end loading -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.md-4 Expired -->


            <!-- Free Accounts -->
            <div class="col-md-4">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title">Free</h3>

                        <div id="freeTotal" class="box-tools pull-right">
                            xx
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <!--<div class="row">
                            <div class="col-md-12">-->
                        <div class="table-responsive table-striped stat-table">
                            <table class="table no-margin">
                                <thead>
                                    <tr>
                                        <th>Location</th>
                                        <th>Staff<br />Active</th>
                                        <th>F&F<br />Active</th>
                                        <th>Staff<br />Expired</th>
                                        <th>F&F<br />Expired</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Lagos <i class="downloadIcon fa fa-download" data-category="Lagos"
                                                data-action="freeCust"></i></td>
                                        <td><span id="activeStaffLagos"></span></td>
                                        <td><span id="activeFnFLagos"></span></td>
                                        <td><span id="expiredStaffLagos"></span></td>
                                        <td><span id="expiredFnFLagos"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Abuja <i class="downloadIcon fa fa-download" data-category="Abuja"
                                                data-action="freeCust"></i></td>
                                        <td><span id="activeStaffAbuja"></span></td>
                                        <td><span id="activeFnFAbuja"></span></td>
                                        <td><span id="expiredStaffAbuja"></span></td>
                                        <td><span id="expiredFnFAbuja"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Port-Harcourt <i class="downloadIcon fa fa-download"
                                                data-category="Port Harcourt" data-action="freeCust"></i></td>
                                        <td><span id="activeStaffPH"></span></td>
                                        <td><span id="activeFnFPH"></span></td>
                                        <td><span id="expiredStaffPH"></span></td>
                                        <td><span id="expiredFnFPH"></span></td>
                                    </tr>
                                    <tr>
                                        <td>Ilorin <i class="downloadIcon fa fa-download" data-category="Ilorin"
                                                data-action="freeCust"></i></td>
                                        <td><span id="activeStaffIlorin"></span></td>
                                        <td><span id="activeFnFIlorin"></span></td>
                                        <td><span id="expiredStaffIlorin"></span></td>
                                        <td><span id="expiredFnFIlorin"></span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!--</div>
                            <!-- /.col -->
                        <!--</div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        &nbsp;
                    </div>
                    <!-- /.footer -->
                    <!-- Loading (remove the following to stop the loading)-->
                    <div id="freeOverlay" class="overlay">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>
                    <!-- end loading -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.md-4 Free Accounts -->

        </div>




        <?PHP if (in_array(9, $mydash)) { ?>
            <div class="row">
                <div class="col-md-12">
                    <!-- TABLE: LATEST ORDERS -->
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Transaction Summary by Service for <?PHP echo date("M, Y"); ?></h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i
                                        class="fa fa-minus"></i>
                                </button>
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                                        class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="acctable"
                                    class="table no-margin table-striped table-bordered bootstrap-datatable datatable responsive dataTable nowrap">
                                    <thead>
                                        <tr>
                                            <th rowspan="2">SN</th>
                                            <th rowspan="2" class='center' style='text-align: center !important;'>SERVICE
                                            </th>
                                            <th rowspan="2" class='center' style='text-align: center !important;'>LOCATION
                                            </th>
                                            <th colspan="2" style='text-align: center !important;'>OVERALL</th>
                                            <th colspan="2" style='text-align: center !important;'>LAGOS</th>
                                            <th colspan="2" style='text-align: center !important;'>ABUJA</th>
                                            <th colspan="2" style='text-align: center !important;'>PORT-HARCOURT</th>
                                            <th colspan="2" style='text-align: center !important;'>ILORIN</th>
                                        </tr>
                                        <tr>
                                            <th style='text-align: center !important;'>TRANSACTIONS</th>
                                            <th style='text-align: center !important;'>TRANSACTION <br />COST (&#8358;)</th>
                                            <th style='text-align: center !important;'>TRANSACTIONS</th>
                                            <th style='text-align: center !important;'>TRANSACTION <br />COST (&#8358;)</th>
                                            <th style='text-align: center !important;'>TRANSACTIONS</th>
                                            <th style='text-align: center !important;'>TRANSACTION <br />COST (&#8358;)</th>
                                            <th style='text-align: center !important;'>TRANSACTIONS</th>
                                            <th style='text-align: center !important;'>TRANSACTION <br />COST (&#8358;)</th>
                                            <th style='text-align: center !important;'>TRANSACTIONS</th>
                                            <th style='text-align: center !important;'>TRANSACTION <br />COST (&#8358;)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?PHP
                                        if (!isset($plan_sales) /*&& !count($sacct[$user])*/):
                                            echo "<tr><td colspan='13' style='text-align: center !important;'>
                No Usage Data!
              </td></tr>";
                                        endif;

                                        $sn = $ntrans = $sales = $ntranslag = $saleslag = $ntransabj = $salesabj = $ntransph = $salesph = $ntransilr = $salesilr = 0;
                                        if (isset($plan_sales)) {
                                            foreach ($plan_sales as $key => $kos):
                                                $ntrans += $kos['TOTAL_TRANS'];
                                                $sales += $kos['TOTAL_SALES'];
                                                if ($kos['PLAN_LOCATION'] == 'Lagos'):
                                                    $ntranslag += $kos['TotalTrans_Lagos'];
                                                    $saleslag += $kos['Sales_Lagos'];
                                                elseif ($kos['PLAN_LOCATION'] == 'Abuja'):
                                                    $ntransabj += $kos['TotalTrans_Abuja'];
                                                    $salesabj += $kos['Sales_Abuja'];
                                                elseif ($kos['PLAN_LOCATION'] == 'Port Harcourt'):
                                                    $ntransph += $kos['TotalTrans_PH'];
                                                    $salesph += $kos['Sales_PH'];
                                                elseif ($kos['PLAN_LOCATION'] == 'Ilorin'):
                                                    $ntransilr += $kos['TotalTrans_Ilorin'];
                                                    $salesilr += $kos['Sales_Ilorin'];
                                                endif;
                                                ?>
                                                <tr>
                                                    <td><?PHP echo ++$sn; ?></td>
                                                    <td style='text-align: center !important;'><?PHP echo $kos['PLAN']; ?></td>
                                                    <td><?PHP echo $kos['PLAN_LOCATION']; ?></td>
                                                    <td style='text-align: right !important;'><?PHP echo $kos['TOTAL_TRANS']; ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo number_format($kos['TOTAL_SALES'], 2); ?></td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Lagos') ? "-" : $kos['TotalTrans_Lagos']; ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Lagos') ? "-" : number_format($kos['Sales_Lagos'], 2); ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Abuja') ? "-" : $kos['TotalTrans_Abuja']; ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Abuja') ? "-" : number_format($kos['Sales_Abuja'], 2); ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Port Harcourt') ? "-" : $kos['TotalTrans_PH']; ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Port Harcourt') ? "-" : number_format($kos['Sales_PH'], 2); ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Ilorin') ? "-" : $kos['TotalTrans_Ilorin']; ?>
                                                    </td>
                                                    <td style='text-align: right !important;'>
                                                        <?PHP echo ($kos['PLAN_LOCATION'] != 'Ilorin') ? "-" : number_format($kos['Sales_Ilorin'], 2); ?>
                                                    </td>
                                                </tr>
                                                <?PHP
                                            endforeach;
                                        }
                                        ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>&nbsp;</th>
                                            <th class='center' style='text-align: center !important;'>&nbsp;</th>
                                            <th class='center' style='text-align: right !important;'>TOTAL</th>
                                            <th class='center' style='text-align: right !important;'>
                                                <?PHP echo number_format($ntrans); ?></th>
                                            <th style='text-align: right !important;'>
                                                <?PHP echo number_format($sales, 2); ?></th>
                                            <th class='center' style='text-align: right !important;'>
                                                <?PHP echo number_format($ntranslag); ?></th>
                                            <th style='text-align: right !important;'>
                                                <?PHP echo number_format($saleslag, 2); ?></th>
                                            <th class='center' style='text-align: right !important;'>
                                                <?PHP echo number_format($ntransabj); ?></th>
                                            <th style='text-align: right !important;'>
                                                <?PHP echo number_format($salesabj, 2); ?></th>
                                            <th class='center' style='text-align: right !important;'>
                                                <?PHP echo number_format($ntransph); ?></th>
                                            <th style='text-align: right !important;'>
                                                <?PHP echo number_format($salesph, 2); ?></th>
                                            <th class='center' style='text-align: right !important;'>
                                                <?PHP echo number_format($ntransilr); ?></th>
                                            <th style='text-align: right !important;'>
                                                <?PHP echo number_format($salesilr, 2); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer clearfix">
                            <!--<a href="javascript:void(0)" class="btn btn-sm btn-info btn-flat pull-left">Place New Order</a>-->
                            <!--<a href="ad_txn_history" class="btn btn-sm btn-default btn-flat pull-right">View All Transactions</a>-->
                        </div>
                        <!-- /.box-footer -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>

        <?PHP } //endif (in_array(9, $mydash)) ?>



        <!-- Latest Transactions -->
        <div class="row">
            <div class="col-md-12">
                <!-- TABLE: LATEST ORDERS -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Latest Transactions</h3>

                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i
                                    class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                                    class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="acctable1"
                                class="table nowrap no-margin table-striped table-bordered bootstrap-datatable datatable responsive dataTable">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th class='center' style='text-align: center !important;'>TRANS_ID</th>
                                        <th class='center' style='text-align: center !important;'>SERVICE ID</th>
                                        <th class='center' style='text-align: center !important;'>AMOUNT<br />PAID</th>
                                        <!--<th style='text-align: center !important;'>STATUS CODE</th>-->
                                        <th style='text-align: center !important;'>STATUS MSG</th>
                                        <th style='text-align: center !important;'>EXPIRY DATE</th>
                                        <th style='text-align: center !important;'>NEW EXPIRY DATE</th>
                                        <th style='text-align: center !important;'>TRANS. DATE</th>
                                        <th style='text-align: center !important;'>GATEWAY</th>
                                        <!--<th class='center' style='text-align: center !important;'>ACTION</th>-->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?PHP
                                    if (!isset($mmdat) /* && !count($sacct[$user]) */):
                                        echo "<tr><td colspan='10' style='text-align: center !important;'>
                No Usage Data!
              </td></tr>";
                                    endif;

                                    $not_done = 'label-danger';
                                    $done = 'label-success';
                                    $partial = 'label-warning';
                                    $sn = 0;
                                    if (isset($mmdat))
                                        foreach ($mmdat as $key => $kos):
                                            ?>
                                            <tr>
                                                <td><?PHP echo ++$sn; ?></td>
                                                <td style='text-align: center !important;'><?PHP echo $kos['RAD_USERNAME']; ?>
                                                </td>
                                                <td style='text-align: center !important;'><?PHP echo $kos['TRANS_ID']; ?></td>
                                                <td style='text-align: center !important;'><?PHP echo $kos['APPR_AMOUNT']; ?>
                                                </td>
                                                <td style='text-align: center !important;'><?PHP echo $kos['STATUS_MSG']; ?>
                                                </td>
                                                <td class='center' style='text-align: center !important;'>
                                                    <?PHP echo ($kos['EXPIRY_DATE'] == NULL) ? "-" : date("d-m-Y H:i:s", strtotime($kos['EXPIRY_DATE'])); ?>
                                                </td>
                                                <td class='center' style='text-align: center !important;'>
                                                    <?PHP echo ($kos['NU_EXPIRY_DATE'] == NULL) ? "-" : date("d-m-Y H:i:s", strtotime($kos['NU_EXPIRY_DATE'])); ?>
                                                </td>
                                                <td style='text-align: center !important;'>
                                                    <?PHP echo ($kos['PAY_DATE'] == NULL) ? "-" : date("d-m-Y H:i:s", strtotime($kos['PAY_DATE'])); ?>
                                                </td>
                                                <td style='text-align: center !important;'><?PHP echo $kos['PAY_GATEWAY']; ?>
                                                </td>
                                                <!--                <td><?PHP
                                                //echo ($kos['STATUS_CODE']=="")? 
                                                //'<form id="gFormView' . $kos['TRANS_ID'] . '" action="" target="" method="post" style="display: inline-block; padding-right: 6px;">'.'<input type="hidden" name="txnref" id="txnref" value="' . $kos['TRANS_ID'] . '" /><button id="requery" type="button" class="loadSubA btn btn-primary sm"><i class="glyphicon glyphicon-refresh orange"></i> Requery</button>'.'</form>' : ""; 
                                                ?></td>-->
                                            </tr>
                                            <?PHP
                                        endforeach;
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>SN</th>
                                        <th class='center' style='text-align: center !important;'>TRANS_ID</th>
                                        <th class='center' style='text-align: center !important;'>SERVICE ID</th>
                                        <th class='center' style='text-align: center !important;'>AMOUNT<br />PAID</th>
                                        <!--<th style='text-align: center !important;'>STATUS CODE</th>-->
                                        <th style='text-align: center !important;'>STATUS MSG</th>
                                        <th style='text-align: center !important;'>EXPIRY DATE</th>
                                        <th style='text-align: center !important;'>NEW EXPIRY DATE</th>
                                        <th style='text-align: center !important;'>TRANS. DATE</th>
                                        <th style='text-align: center !important;'>GATEWAY</th>
                                        <!--<th class='center' style='text-align: center !important;'>ACTION</th>-->
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.table-responsive -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer clearfix">
                        <!--<a href="javascript:void(0)" class="btn btn-sm btn-info btn-flat pull-left">Place New Order</a>-->
                        <a href="ad_txn_history" class="btn btn-sm btn-default btn-flat pull-right">View All
                            Transactions</a>
                    </div>
                    <!-- /.box-footer -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->


    </section>
    <!-- ./Main Content -->


</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script type="text/javascript">
    $(document).ready(function () {

        var numberFormat = (no, decimal_place) => {
            return Number(parseFloat(no).toFixed(decimal_place)).toLocaleString('en', {
                minimumFractionDigits: decimal_place
            });
        };


        /** Pie Chart Parameters **/
        var pieChartOptions = {
            // Boolean - Whether we should show a stroke on each segment
            segmentShowStroke: true,
            // String - The colour of each segment stroke
            segmentStrokeColor: '#fff',
            // Number - The width of each segment stroke
            segmentStrokeWidth: 1,
            // Number - The percentage of the chart that we cut out of the middle
            percentageInnerCutout: 0, // This is 0 for Pie charts
            // Number - Amount of animation steps
            animationSteps: 100,
            // String - Animation easing effect
            animationEasing: 'easeOutBounce',
            // Boolean - Whether we animate the rotation of the Doughnut
            animateRotate: true,
            // Boolean - Whether we animate scaling the Doughnut from the centre
            animateScale: false,
            // Boolean - whether to make the chart responsive to window resizing
            responsive: true,
            // Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
            maintainAspectRatio: false,
            // String - A legend template
            legendTemplate: '<ul class=\'<%=name.toLowerCase()%>-legend\'><% for (var i=0; i<segments.length; i++){%><li><span style=\'background-color:<%=segments[i].fillColor%>\'></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>',
            // String - A tooltip template
            tooltipTemplate: '<%=Number(parseFloat(value).toFixed(2)).toLocaleString("en", {minimumFractionDigits: 2}) %> <%=label%> users'
        };

        var generatePieData = (values, label) => {
            const color = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)",
                "#f39c12", "#00c0ef", "$d2d6de"];
            let returnData = [];
            values.forEach((value, key) => {
                let obj = {};
                obj['value'] = value;
                obj['color'] = color[key];
                obj['highlight'] = color[key];
                obj['label'] = label[key];
                returnData.push(obj);
            });
            return returnData;
        };


        var loadCustomerData = (location) => {
            $("#totalCustomerOverlay").show();
            let dat = "location=" + location + "&action=totalCust";
            $.ajax({
                type: "POST",
                url: "ajax/dashiStat",
                data: dat,
                dataType: "json",
                success: function (response) {  //alert(response);
                    if (response.status === 1) {
                        $("#totalCustomer").text(numberFormat(response.totalCust));
                        $("#onlineCustomer").text(numberFormat(response.onlineCust));
                        $("#activeCustomer").text(numberFormat(response.activeCust));
                        $("#expiredCustomer").text(numberFormat(response.expiredCust));
                        $("#pausedCustomer").text(numberFormat(response.pausedCust));
                        $("#pendingCustomer").text(numberFormat(response.pendingCust));

                        $("#custContainer").html("");
                        $("#custContainer").html('<canvas id="customerPieChart" height="150" style="max-height:250px;"></canvas>');
                        let customerPieChart = new Chart($("#customerPieChart").get(0).getContext('2d'));
                        const pieData = generatePieData([response.activeCust, response.expiredCust,
                        response.pausedCust, response.pendingCust], ["Active Customers",
                            "Expired Customers", "Paused Customers", "Pending Customers"]);
                        customerPieChart.Doughnut(pieData, pieChartOptions);
                        $('#totalCustomerOverlay').hide();
                    }

                },
                error: function () {
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                    $('#totalCustomerOverlay').hide();
                }
            });
        };

        var loadNewCustomerData = (duration) => {
            $("#newCustomerOverlay").show();
            let dat = "duration=" + duration + "&action=newCust";
            $.ajax({
                type: "POST",
                url: "ajax/dashiStat",
                data: dat,
                dataType: "json",
                success: function (response) {  //alert(response);
                    if (response.status === 1) {
                        $("#newCustTotal").text(numberFormat(response.total));
                        $("#newCustLagos").text(numberFormat(response.Lagos));
                        $("#newCustAbuja").text(numberFormat(response.Abuja));
                        $("#newCustPH").text(numberFormat(response.PH));
                        $("#newCustIlorin").text(numberFormat(response.Ilorin));

                        $("#newCustContainer").html("");
                        $("#newCustContainer").html('<canvas id="newCustomerPieChart" height="150" style="max-height:250px;"></canvas>');
                        let newCustomerPieChart = new Chart($("#newCustomerPieChart").get(0).getContext('2d'));
                        const pieData = generatePieData([response.Lagos, response.Abuja,
                        response.PH, response.Ilorin], ["Lagos Customers",
                            "Abuja Customers", "Port-Harcourt Customers", "Ilorin Customers"]);
                        newCustomerPieChart.Doughnut(pieData, pieChartOptions);
                        $('#newCustomerOverlay').hide();
                    }

                },
                error: function () {
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                    $('#newCustomerOverlay').hide();
                }
            });
        };

        var loadTransactionData = (duration) => {
            $("#serviceRenewalOverlay").show();
            let dat = "duration=" + duration + "&action=serviceRenewal";
            $.ajax({
                type: "POST",
                url: "ajax/dashiStat",
                data: dat,
                dataType: "json",
                success: function (response) {  //alert(response);
                    if (response.status === 1) {
                        $("#nTranx").text(numberFormat(response.totalTranx));
                        $("#tranxAmount").html("&#8358; " + numberFormat(response.totalAmt, 2));
                        $("#nTranxLagos").text(numberFormat(response.Lagos.nTrans));
                        $("#tranxLagos").html("&#8358; " + numberFormat(response.Lagos.sales, 2));
                        $("#nTranxAbuja").text(numberFormat(response.Abuja.nTrans));
                        $("#tranxAbuja").html("&#8358; " + numberFormat(response.Abuja.sales, 2));
                        $("#nTranxPH").text(numberFormat(response.PH.nTrans));
                        $("#tranxPH").html("&#8358; " + numberFormat(response.PH.sales, 2));
                        $("#nTranxIlorin").text(numberFormat(response.Ilorin.nTrans));
                        $("#tranxIlorin").html("&#8358; " + numberFormat(response.Ilorin.sales, 2));

                        $("#tranxContainer").html("");
                        $("#tranxContainer").html('<canvas id="transactionPieChart" height="150" style="max-height:250px;"></canvas>');
                        let transactionPieChart = new Chart($("#transactionPieChart").get(0).getContext('2d'));
                        const pieData = generatePieData([response.Lagos.nTrans, response.Abuja.nTrans,
                        response.PH.nTrans, response.Ilorin.nTrans], ["Lagos Customers",
                            "Abuja Customers", "Port-Harcourt Customers", "Ilorin Customers"]);
                        transactionPieChart.Doughnut(pieData, pieChartOptions);
                        $('#serviceRenewalOverlay').hide();
                    }

                },
                error: function () {
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                    $('#serviceRenewalOverlay').hide();
                }
            });
        };

        var loadExpiredData = () => {
            $("#expiredOverlay").show();
            let dat = "action=expiredCust";
            $.ajax({
                type: "POST",
                url: "ajax/dashiStat",
                data: dat,
                dataType: "json",
                success: function (response) {  //alert(response);
                    if (response.status === 1) {
                        $("#expiredLTE30Lagos").text(numberFormat(response.expiredLTE30Lagos));
                        $("#expired31To89Lagos").text(numberFormat(response.expired31To89Lagos));
                        $("#expiredGTE90Lagos").text(numberFormat(response.expiredGTE90Lagos));
                        $("#expiredTotalLagos").text(numberFormat(response.expiredTotalLagos));
                        $("#expiredLTE30Abuja").text(numberFormat(response.expiredLTE30Abuja));
                        $("#expired31To89Abuja").text(numberFormat(response.expired31To89Abuja));
                        $("#expiredGTE90Abuja").text(numberFormat(response.expiredGTE90Abuja));
                        $("#expiredTotalAbuja").text(numberFormat(response.expiredTotalAbuja));
                        $("#expiredLTE30PH").text(numberFormat(response.expiredLTE30PH));
                        $("#expired31To89PH").text(numberFormat(response.expired31To89PH));
                        $("#expiredGTE90PH").text(numberFormat(response.expiredGTE90PH));
                        $("#expiredTotalPH").text(numberFormat(response.expiredTotalPH));
                        $("#expiredLTE30Ilorin").text(numberFormat(response.expiredLTE30Ilorin));
                        $("#expired31To89Ilorin").text(numberFormat(response.expired31To89Ilorin));
                        $("#expiredGTE90Ilorin").text(numberFormat(response.expiredGTE90Ilorin));
                        $("#expiredTotalIlorin").text(numberFormat(response.expiredTotalIlorin));

                        $("#expiredTotal").text(numberFormat(response.expiredTotal));

                        $('#expiredOverlay').hide();
                    }

                },
                error: function () {
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                    $('#expiredOverlay').hide();
                }
            });
        };

        var loadExpiringData = () => {
            $("#expiringOverlay").show();
            let dat = "action=expiringCust";
            $.ajax({
                type: "POST",
                url: "ajax/dashiStat",
                data: dat,
                dataType: "json",
                success: function (response) {  //alert(response);
                    if (response.status === 1) {
                        $("#expiringTodayLagos").text(numberFormat(response.expiringTodayLagos));
                        $("#expiringTomorrowLagos").text(numberFormat(response.expiringTomorrowLagos));
                        $("#expiringIn10Lagos").text(numberFormat(response.expiringIn10Lagos));
                        $("#expiringTodayAbuja").text(numberFormat(response.expiringTodayAbuja));
                        $("#expiringTomorrowAbuja").text(numberFormat(response.expiringTomorrowAbuja));
                        $("#expiringIn10Abuja").text(numberFormat(response.expiringIn10Abuja));
                        $("#expiringTodayPH").text(numberFormat(response.expiringTodayPH));
                        $("#expiringTomorrowPH").text(numberFormat(response.expiringTomorrowPH));
                        $("#expiringIn10PH").text(numberFormat(response.expiringIn10PH));
                        $("#expiringTodayIlorin").text(numberFormat(response.expiringTodayIlorin));
                        $("#expiringTomorrowIlorin").text(numberFormat(response.expiringTomorrowIlorin));
                        $("#expiringIn10Ilorin").text(numberFormat(response.expiringIn10Ilorin));

                        $('#expiringOverlay').hide();
                    }

                },
                error: function () {
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                    $('#expiringOverlay').hide();
                }
            });
        };

        var loadFreeCustomerData = () => {
            $("#freeOverlay").show();
            let dat = "action=freeCust";
            $.ajax({
                type: "POST",
                url: "ajax/dashiStat",
                data: dat,
                dataType: "json",
                success: function (response) {  //alert(response);
                    if (response.status === 1) {
                        $("#activeStaffLagos").text(numberFormat(response.activeStaffLagos));
                        $("#activeFnFLagos").text(numberFormat(response.activeFnFLagos));
                        $("#expiredStaffLagos").text(numberFormat(response.expiredStaffLagos));
                        $("#expiredFnFLagos").text(numberFormat(response.expiredFnFLagos));
                        $("#activeStaffAbuja").text(numberFormat(response.activeStaffAbuja));
                        $("#activeFnFAbuja").text(numberFormat(response.activeFnFAbuja));
                        $("#expiredStaffAbuja").text(numberFormat(response.expiredStaffAbuja));
                        $("#expiredFnFAbuja").text(numberFormat(response.expiredFnFAbuja));
                        $("#activeStaffPH").text(numberFormat(response.activeStaffPH));
                        $("#activeFnFPH").text(numberFormat(response.activeFnFPH));
                        $("#expiredStaffPH").text(numberFormat(response.expiredStaffPH));
                        $("#expiredFnFPH").text(numberFormat(response.expiredFnFPH));
                        $("#activeStaffIlorin").text(numberFormat(response.activeStaffIlorin));
                        $("#activeFnFIlorin").text(numberFormat(response.activeFnFIlorin));
                        $("#expiredStaffIlorin").text(numberFormat(response.expiredStaffIlorin));
                        $("#expiredFnFIlorin").text(numberFormat(response.expiredFnFIlorin));

                        $("#freeTotal").text(numberFormat(response.freeTotal));

                        $('#freeOverlay').hide();
                    }

                },
                error: function () {
                    alert("Sorry, cannot contact server at this time. Please try again later!");
                    $('#freeOverlay').hide();
                }
            });
        };

        //call dash functions
        setTimeout(function () { loadCustomerData("all"); }, 0);
        setTimeout(function () { loadNewCustomerData("thisMonth"); }, 0);
        setTimeout(function () { loadTransactionData("thisMonth"); }, 0);
        setTimeout(function () { loadExpiredData(); }, 0);
        setTimeout(function () { loadExpiringData(); }, 0);
        setTimeout(function () { loadFreeCustomerData(); }, 0);

        var loadData = (caller, val) => {
            if (caller === 'cust') {
                loadCustomerData(val);
            } else if (caller === 'newCust') {
                loadNewCustomerData(val);
            } else if (caller === 'tranx') {
                loadTransactionData(val);
            }
        };

        $("#newCustDuration").on('change', () => {
            const caller = $("#newCustDuration").data("caller");
            const val = $("#newCustDuration").val();
            console.log(caller + " : " + val);
            loadData(caller, val);
        });
        $("#custType").on('change', () => {
            const caller = $("#custType").data("caller");
            const val = $("#custType").val();
            console.log(caller + " : " + val);
            loadData(caller, val);
        });
        $("#tranxDuration").on('change', () => {
            const caller = $("#tranxDuration").data("caller");
            const val = $("#tranxDuration").val();
            console.log(caller + " : " + val);
            loadData(caller, val);
        });

        $(".downloadIcon").each(function () {
            $(this).off().click(function () {
                $('#myLoading').modal({
                    keyboard: false,
                    show: true,
                    backdrop: "static"
                });
                let category = $(this).data('category');
                let action = $(this).data('action');
                let location = '';
                if (action === 'totalCust') {
                    location = "&location=" + $('#custType').val();
                } else if (action === 'newCust') {
                    location = "&duration=" + $('#newCustDuration').val();
                } else if (action === 'serviceRenewal') {
                    location = "&duration=" + $('#tranxDuration').val();
                } else {
                    location = ""; //+ $(this).data('location');
                }

                let dat = "action=" + action + "&category=" + category + location;
                $.ajax({
                    type: "POST",
                    url: "ajax/dashreportgen",
                    data: dat,
                    success: function (response) {
                        alert(response);
                        $('#myLoading').modal('hide');
                    },
                    error: function () {
                        alert("Sorry, cannot contact server at this time. Please try again later!");
                        $('#myLoading').modal('hide');
                    }
                });
            });
        });


        // Append a caption to the table before the DataTables initialisation
        $('#acctable').append("<caption style=\"caption-side: title\">Transaction Summary by Service for <?PHP echo date("M, Y"); ?></caption>");
        $('#acctable1').append('<caption style="caption-side: title">Latest Transaction.</caption>');

        $('#acctable, #acctable1').DataTable({

            'ordering': true,
            'autoWidth': false,
            "aLengthMenu": [[50, 100, 200, -1], [50, 100, 200, "All"]],
            "iDisplayLength": 50,
            fixedHeader: false,
            "deferRender": true,
            dom: 'B<"clear"><"clear">lfrtip',
            'scrollX': true,
            'scrollY': '40vh',
            buttons: {
                name: 'primary',
                buttons: [{
                    extend: 'copy', footer: true, "text": '<i class="fa fa-files-o" style="color: green;"></i> Copy',
                    "titleAttr": 'Copy', className: 'btn btn-info'
                }, {
                    extend: 'csv', footer: true, "text": '<i class="fa fa-file-text" style="color: green;"></i> CSV',
                    "titleAttr": 'CSV', className: 'btn btn-warning'
                },
                {
                    extend: 'excel', footer: true, "text": '<i class="fa fa-file-excel-o" style="color: green;"></i> Excel',
                    "titleAttr": 'Excel', className: 'btn btn-success'
                }, {
                    extend: 'print', footer: true, "text": '<i class="fa fa-print" style="color: green;"></i> Print',
                    "titleAttr": 'Print',
                },
                    /*{ extend: 'pdf', footer: true },*/ 'colvis', {
                    text: 'Reload',
                    action: function (e, dt, node, config) {
                        dt.ajax.reload();
                    }
                }]
            }
        });

    }); // document ready

</script>

<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
<?PHP
include_once 'includes/footer_end.php';
