<?php
chdir(dirname(__FILE__));
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

$online = $ad->loadOnlineUsers();
$uonline = count($online);

$arm = $ad->loadRadUser("", 1);
$narm = count($arm);

// $ap  = $ad->loadClientRec("", 1);
// $nap = count($ap);

$vap  = $ad->loadRadUser4VOIP("", 1, 1);
$vnap = count($vap);

$lst = $ad->getExpiringAccounts(10);
$nex10 = count($lst);

//$lst = $ad->getExpiredAccounts();
//$nexp = count($lst);
//
//$lst = $ad->getExpiredAccounts(30);
//$nexp30 = count($lst);
//$lst = $ad->getExpiredAccounts(60);
//$nexp60 = count($lst);

$nexp = $ad->getExpiredAccountsv1();
$nexp30 = $ad->getExpiredAccountsv1(30);
$nexp60 = $ad->getExpiredAccountsv1(60);
$churned = $nexp - $nexp60;

$lst = $ad->getPausedAccounts();
$npause = count($lst);

$lst = $ad->getPendingAccounts();
$npend = count($lst);

$dashstat = $ad->getAdminDashStat((int)date("n"), (int)date("Y"));

//$mydash = array_keys($ad->adminDashList($_SESSION[$sid.'userid']));

$activeusers = $ad->getUserStat("", -1, -1, '', '', -1, -1, 0, 0, 0, 0, 1);

$nexToday = $ad->getExpiringAccountsByDate(date("Y-m-d"));
$nexTomorrow = $ad->getExpiringAccountsByDate(date( "Y-m-d", strtotime( "+1 days" ) ));

$online_up = $ad->loadOnlineUsers(1);
$uonline_up = count($online_up);
$uonline_reg = $uonline - $uonline_up;

$arm_up = $ad->loadRadUser("", 1, -1, 1);
$narm_up = count($arm_up);
$narm_reg = $narm - $narm_up;

$lst_up = $ad->getExpiringAccounts(10, 1);
$nex10_up = count($lst_up);
$nex10_reg = $nex10 - $nex10_up;
$nexToday_up = $ad->getExpiringAccountsByDate(date("Y-m-d"), 1);
$nexTomorrow_up = $ad->getExpiringAccountsByDate(date( "Y-m-d", strtotime( "+1 days" ) ), 1);
$nexToday_reg = $nexToday - $nexToday_up;
$nexTomorrow_reg = $nexTomorrow - $nexTomorrow_up;

$nexp_up = $ad->getExpiredAccountsv1(0, 1);
$nexp30_up = $ad->getExpiredAccountsv1(30, 1);
$nexp60_up = $ad->getExpiredAccountsv1(60, 1);
$churned_up = $nexp_up - $nexp60_up; 

$nexp_reg = $nexp - $nexp_up;
$nexp30_reg = $nexp30 - $nexp30_up;
$nexp60_reg = $nexp60 - $nexp60_up;
$churned_reg = $churned - $churned_up; 

$lst = $ad->getPausedAccounts(1);
$npause_up = count($lst);
$npause_reg = $npause - $npause_up; 

$lst = $ad->getPendingAccounts(1);
$npend_up = count($lst);
$npend_reg = $npend - $npend_up; 

$ntransr = $nsalesr = $ntransu = $nsalesu = 0;
if (isset($dashstat['SALES_BY_SRV'])) {
    foreach ($dashstat['SALES_BY_SRV'] as $key => $kos) :
        if ($kos['IS_UPCOUNTRY']) :
            $ntransu += $kos['NTRANS'];
            $nsalesu += $kos['SALES'];
        else:
            $ntransr += $kos['NTRANS'];
            $nsalesr += $kos['SALES'];        
        endif;
    endforeach;
}

$complist = $ad->complimentaryAccountStat('C');
$stafflist = $ad->complimentaryAccountStat('S');
$complist_up = $ad->complimentaryAccountStat('C', 1);
$stafflist_up = $ad->complimentaryAccountStat('S', 1);
foreach ($complist as $k=>$v) :
    $complist_reg[$k] = $complist[$k] - $complist_up[$k];
    $stafflist_reg[$k] = $stafflist[$k] - $stafflist_up[$k];
endforeach;


/*** ACTIVE CUSTOMER BY PLAN ***/
$ree = [];
$qryy = "SELECT PLAN_NAME, COUNT(username) AS 'NUSERS', 
		(SELECT COUNT(username) FROM tbl_user_extend 
WHERE PLAN_ID=tu.PLAN_ID AND DATE(expiration) >= DATE(NOW()) AND DATE(createdon)<=DATE(NOW())) AS 'ACTIVE',
		(SELECT COUNT(tca.USERNAME) FROM tbl_comp_account tca 
		LEFT JOIN tbl_user_extend tue ON tca.USERNAME=tue.username 
		WHERE ACCOUNT_TYPE='C' AND tue.PLAN_ID=tu.PLAN_ID) AS 'COMP',
		(SELECT COUNT(tca.USERNAME) FROM tbl_comp_account tca 
		LEFT JOIN tbl_user_extend tue ON tca.USERNAME=tue.username 
		WHERE ACCOUNT_TYPE='S' AND tue.PLAN_ID=tu.PLAN_ID) AS 'STAFF'
FROM tbl_user_extend tu
WHERE PLAN_NAME NOT LIKE '%Dedicated%' AND PLAN_NAME NOT LIKE '%Default%' AND DATE(createdon)<=DATE(NOW()) AND
( (username IN (SELECT RAD_USERNAME FROM tblclients)) 
                         OR (username IN (SELECT RAD_USERNAME FROM tbl_subaccount)) )
GROUP BY PLAN_NAME;";

$some_sth = $db->select($qryy);
while ($row = $some_sth->fetch_object()):
	$ree[] = ["PLAN_NAME"=>$row->PLAN_NAME, "NUSERS"=>$row->NUSERS, "ACTIVE"=>$row->ACTIVE, 
              "COMP"=>$row->COMP, "STAFF"=>$row->STAFF];
endwhile;
/*** /ACTIVE CUSTOMER BY PLAN ***/


$dmon = (int)date("n");
$dyr = (int)date("Y");

$dasharr = [];
        
$dasharr[] = [1, number_format($narm)];
$dasharr[] = [2, number_format($dashstat['NTRANS'])];
$dasharr[] = [3, number_format($nex10)];
$dasharr[] = [4, number_format($nexp)];
$dasharr[] = [5, number_format($dashstat['NUSERS'])];
$dasharr[] = [6, number_format($dashstat['SALES'],2)];
$dasharr[] = [7, number_format($uonline)];
$dasharr[] = [8, number_format($vnap)];
$dasharr[] = [9, json_encode($dashstat['SALES_BY_SRV'])];
$dasharr[] = [10, number_format($npause)];
$dasharr[] = [11, number_format($npend)];
$dasharr[] = [12, number_format($nexp30)];
$dasharr[] = [13, number_format($nexp60)];
$dasharr[] = [14, number_format($churned)];
$dasharr[] = [15, number_format($activeusers)];
$dasharr[] = [16, number_format($nexToday)];
$dasharr[] = [17, number_format($nexTomorrow)];
$dasharr[] = [18, number_format($uonline_up)];
$dasharr[] = [19, number_format($uonline_reg)];
$dasharr[] = [20, number_format($narm_up)];
$dasharr[] = [21, number_format($narm_reg)];
$dasharr[] = [22, number_format($nex10_up)];
$dasharr[] = [23, number_format($nex10_reg)];
$dasharr[] = [24, number_format($nexToday_up)];
$dasharr[] = [25, number_format($nexTomorrow_up)];
$dasharr[] = [26, number_format($nexToday_reg)];
$dasharr[] = [27, number_format($nexTomorrow_reg)];
$dasharr[] = [28, number_format($nexp_up)];
$dasharr[] = [29, number_format($nexp30_up)];
$dasharr[] = [30, number_format($nexp60_up)];
$dasharr[] = [31, number_format($churned_up)];
$dasharr[] = [32, number_format($nexp_reg)];
$dasharr[] = [33, number_format($nexp30_reg)];
$dasharr[] = [34, number_format($nexp60_reg)];
$dasharr[] = [35, number_format($churned_reg)];
$dasharr[] = [36, number_format($npause_up)];
$dasharr[] = [37, number_format($npend_up)];
$dasharr[] = [38, number_format($npause_reg)];
$dasharr[] = [39, number_format($npend_reg)];

$dasharr[] = [40, json_encode($complist)];
$dasharr[] = [41, json_encode($stafflist)];
$dasharr[] = [42, json_encode($complist_reg)];
$dasharr[] = [43, json_encode($stafflist_reg)];
$dasharr[] = [44, json_encode($complist_up)];
$dasharr[] = [45, json_encode($stafflist_up)];
$dasharr[] = [46, number_format($dashstat['NUSERS_REG'])];
$dasharr[] = [47, number_format($dashstat['NUSERS_UP'])];

// CUSTOMER FREQ BY PLAN
$dasharr[] = [48, json_encode($ree)];

foreach ($dasharr as $value) {
    $qry = "INSERT INTO tbl_dash_history (DASHID, `VAL`, DMONTH, DYEAR, DATERECORDED) VALUES (?, ?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE `VAL`=VALUES(`VAL`) ";
    $db->insert($qry, "isii", $value[0], $value[1], $dmon, $dyr);
}
