<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
chdir(dirname(__FILE__));
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

$users = [];
$file = fopen("fob-delete.csv","r");
while(! feof($file)):
    $arr = fgetcsv($file);
    $users[] = strtolower(trim($arr[0]));
endwhile;
fclose($file);

// print_r($users); exit();

$ofile = fopen("BulkArchiveList.txt","a");

$adminUser = 'admin(Auto-Bulk)';
$adminID = 1;
$reason = "Bulk Archiving of Churned Account";
   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$log = new Logger($db, $adminUser);

foreach ($users as $username) {
    $user_exist = $ad->verifyUserDepth($username);
    $date = date("d/m/Y H:i:s");
        if ($username === '' || $username === 'username') { continue; }
    
    if ($user_exist == 0) :
        $log->logTrail($log::NEW_USER, "($adminUser attempt to delete) Error: User [$username] does not Exist and cannot be deleted", $log::STATUS_FAILED, get_client_ip_env()); 
        echo "Error: User [$username] does not Exist and cannot be deleted"; 
        fwrite($ofile,"$username, FAILED, NOT_EXIST, $date" . PHP_EOL);
        continue;
    elseif ($user_exist == -2) :
        $log->logTrail($log::NEW_USER, "($adminUser attempt to delete) Error: User [$username] has sub-account(s) on eService and cannot be deleted", $log::STATUS_FAILED, get_client_ip_env()); 
        echo "Error: User [$username] has sub-account(s) on eService and cannot be deleted. Unlink all Sub-Account before attempting to delete"; 
        fwrite($ofile,"$username, FAILED, HAS_SUBACCOUNT, $date" . PHP_EOL);
        continue;
    elseif ($user_exist == 1) :
        $log->logTrail($log::NEW_USER, "($adminUser attempt to delete) Start deletion process of Service ID [$username] on Radius Only. ", $log::STATUS_FAILED, get_client_ip_env()); 
        $ret = $ad->deleteUserRadius($username, $adminUser, $adminID, $reason);
    elseif ($user_exist == 2) :
        $log->logTrail($log::NEW_USER, "($adminUser attempt to delete) Start deletion process of Service ID [$username] on Radius and Client. ", $log::STATUS_FAILED, get_client_ip_env()); 
        $ret = $ad->deleteUserRadnClient($username, $adminUser, $adminID, $reason);
    elseif ($user_exist == 3) :
        $log->logTrail($log::NEW_USER, "($adminUser attempt to delete) Start deletion process of Service ID [$username] on Radius and Client. ", $log::STATUS_FAILED, get_client_ip_env()); 
        $ret = $ad->deleteUserRadnSubAcct($username, $adminUser, $adminID, $reason);
    endif;
    
    if (substr( $ret, 0, 7 ) === "Success") :
        fwrite($ofile,"$username, DONE, DONE, $date" . PHP_EOL);
    else:
        fwrite($ofile,"$username, FAILED, FAILED, $date" . PHP_EOL);
    endif;
}

