<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Users
 *
 * @author OPMat
 */
class Users {
    //put your code here
    private $db;
    private $uid;
    private $fullname;
    private $is_admin; 
    private $usertype; 
    private $usertype_id;   
    private $username;
    private $lastname;
    private $firstname;
    private $middlename;
    private $regno;
    private $matricno;
    private $progid;
    private $exam_array;


    public function __construct($dbconnection, $uid=0, $username="", $fullname="", $is_admin=0, 
                        $usertype="STUDENT", $usertype_id= 3) {
        $this->db = $dbconnection;
        $this->uid = $uid;
        $this->username = $username;
        $this->fullname = $fullname;
        $this->is_admin = $is_admin;
        $this->usertype = $usertype;
        $this->usertype_id = $usertype_id;
    }
     
     public function authenticateAdmin($username)  {
        $qry = "SELECT a.USERID, a.LOGONID, a.ACCESS_LEVEL, ale.ADMIN_TYPE FROM `admin` a 
                LEFT JOIN admin_level ale ON (a.ACCESS_LEVEL=ale.ID)
                WHERE a.LOGONID=?"; 
        $some_sth = $this->db->select($qry, 's', $username);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $this->uid = $row->USERID;
            $this->username = $row->LOGONID;
            $this->is_admin = 1;
            $this->usertype = $row->ADMIN_TYPE;
            $this->usertype_id = $row->ACCESS_LEVEL;
        }

        return $rows;
     }
     
     public function verifyActiveUser($username) {
         //$this->db->autocommit(FALSE);
         //$all_query_ok=true; // our control variable
         
        $datArr = array();
        $strsql= "SELECT sli.ID, sli.REGNO, m.MATRICNO, sli.LASTNAME, sli.FIRSTNAME, sli.OTHERNAME, sli.PROGRAMME FROM z_email_gen z
                    LEFT JOIN `studentlist` sli ON (sli.REGNO=z.ADMISSIONNO)
                    LEFT JOIN matriclist m ON (m.STUDENTID=sli.ID)
                    WHERE sli.`STATUS` = 32 AND z.USERNAME =?"; //echo $strsql; exit;

        $some_st = $this->db->select($strsql, "s", $username);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) :
                $datArr[] = array("ID"=>$row['ID'], "REGNO"=>$row['REGNO'], "MATRICNO"=>$row['MATRICNO'], "LASTNAME"=>$row['LASTNAME'],
                    "FIRSTNAME"=>$row['FIRSTNAME'], "OTHERNAME"=>$row['OTHERNAME'], "PROGRAMME"=>$row['PROGRAMME']);
                    
                $this->uid = $row['ID'];
                $this->username = $username; 
                $this->fullname = "{$row['LASTNAME']}, {$row['FIRSTNAME']} {$row['OTHERNAME']}";
                $this->firstname = $row['FIRSTNAME'];
                $this->lastname = $row['LASTNAME'];
                $this->middlename = $row['OTHERNAME'];
                $this->regno = $row['REGNO'];
                $this->matricno = $row['MATRICNO'];
                $this->progid = $row['PROGRAMME'];
            endwhile;
        endif;
        
        return $datArr;
     }
     
     public function updateUserRecord($value) {
        $strsql = "INSERT INTO studdata (USERID, REGNO, MATRICNO, LASTNAME, FIRSTNAME, MIDDLENAME, PROGRAMME)
                    VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE PROGRAMME=VALUES(PROGRAMME),
                     MATRICNO=VALUES(MATRICNO)";
        $this->db->insert($strsql, "isssssi", $value);//? null : $all_query_ok=false;
        
        $strsql = "SELECT USERID FROM studdata WHERE REGNO=?";
        $some_st = $this->db->select($strsql, "s", $value[1]);
        
        return $some_st->num_rows();
     }
     
     public function verifyMCStatus($regno) {
        $datArr = array();
        $strsql= "SELECT MEDICAL, CSIS FROM filled_forms WHERE REGNO = $regno"; //echo $strsql; exit;

        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) : //print_r($row); exit;
                $datArr = array(
                                "MEDICAL" => $row['MEDICAL']? $row['MEDICAL'] : 0, 
                                "CSIS" => $row['CSIS']? $row['CSIS'] : 0
                            );
            endwhile;
        endif;
        
        return $datArr;
     }
     
     public function verifyFCStatus($regno, $acadyr, $sem) {
        $datArr = array();
        $strsql= "SELECT REGNUM FROM semregstage 
                    WHERE ACADYEAR=$acadyr AND SEMESTER=$sem AND STEP=73 AND REGNUM = $regno"; //echo $strsql; exit;

        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :            
            $datArr = array("FIN" => 1 );
        else:
            $datArr = array("FIN" => 0 );
        endif;
        
        //Course Reg.
        $strsql= "SELECT * FROM studcoursereg 
                    WHERE ACADYEAR=$acadyr AND SEMESTER=$sem AND ADMISSIONNO = $regno"; //echo $strsql; exit;

        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :            
            $datArr["CREG"] = 1;
        else:
            $strsql= "SELECT * FROM studcourseregtemp 
                    WHERE ACADYEAR=$acadyr AND SEMESTER=$sem AND ADMISSIONNO = $regno"; //echo $strsql; exit;

            $some_st = $this->db->select($strsql);
            if ($some_st->num_rows() >= 1) :            
                $datArr["CREG"] = 2;
            else:
                $datArr["CREG"] = 0;
            endif;
        endif;
        
        return $datArr;
     }
     
     public function getEvalCourses($regno, $acadyr, $sem, $kos = 0) {
        $datArr = array();
        $add = "";
        if ($kos <> 0):
            $add = " ce.COURSE=$kos AND ";
        endif;
        $strsql= "SELECT REGNO, ce.COURSE, c.COURSECODE, c.TITLE, EVAL_STATUS, DATE_COMPLETED FROM course_eval ce
                    LEFT JOIN courses c ON (ce.COURSE = c.ID)
                 WHERE $add REGNO = ? AND ce.ACADYEAR = ? AND ce.SEMESTER = ?"; //echo $strsql; exit;

        $some_st = $this->db->select($strsql, 'iii', $regno, $acadyr, $sem);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) : //print_r($row); exit;
                $datArr[] = array("COURSE" => $row['COURSE'],
                                "COURSECODE" => $row['COURSECODE'], "TITLE" => $row['TITLE'],
                                "EVAL_STATUS" => $row['EVAL_STATUS'], "DATE_COMPLETED" => $row['DATE_COMPLETED']
                            );
            endwhile;
        endif;
        
        return $datArr;
     }
     
     public function getEvalProgress($regno, $acadyr, $sem) {
        $datArr = 0;
        $strsql= "SELECT ROUND((COUNT(REGNO)/T.Total)*100,0) AS 'PERCENT'
FROM course_eval ce, 
(SELECT COUNT(REGNO) AS 'Total' FROM course_eval WHERE REGNO=? AND ACADYEAR=? AND SEMESTER=?) AS T
WHERE ce.REGNO=? AND ce.ACADYEAR=? AND ce.SEMESTER=? AND EVAL_STATUS=1"; //echo $strsql; exit;

        $some_st = $this->db->select($strsql, 'iiiiii', $regno, $acadyr, $sem, $regno, $acadyr, $sem);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) : //print_r($row); exit;
                $datArr = $row['PERCENT'];
            endwhile;
        endif;
        
        return $datArr;
     }
     
     public function getCourseReg($regno, $acadyr, $sem) {
        $datArr = array();
        $strsql = "SELECT ADMISSIONNO, scr.COURSE, scr.ACADYEAR, scr.SEMESTER
                    FROM studcoursereg scr 
                    LEFT JOIN courses c ON (scr.COURSE = c.ID)
                    WHERE scr.ADMISSIONNO=? AND scr.ACADYEAR=? AND scr.SEMESTER=? 
                    AND c.COURSECODE NOT LIKE 'TMC%2' AND c.COURSECODE NOT LIKE 'FMP%'";
        $some_st = $this->db->select($strsql, 'iii', $regno, $acadyr, $sem);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) : //print_r($row); exit;
                $datArr[] = array("REGNO" => $row['ADMISSIONNO'], "COURSE" => $row['COURSE'],
                                "ACADYEAR" => $row['ACADYEAR'], "SEMESTER" => $row['SEMESTER'],
                                "EVAL_STATUS" => 0, "DATE_STARTED" => '0000-00-00 00:00:00', 
                                "DATE_COMPLETED" => '0000-00-00 00:00:00'
                            );
            endwhile;
        endif;
        
        return $datArr;
     }
     
     public function getACS() {
        $datArr = array();
        $strsql = "SELECT LOGONID, CONCAT_WS(' ', LASTNAME, FIRSTNAME, MIDDLENAME) AS 'FULLNAME', CASE TITLE WHEN 5 THEN 'PROF.' 
            WHEN 4 THEN 'DR.' WHEN 1 THEN 'MR.' WHEN 2 THEN 'MISS' WHEN 3 THEN 'MRS' WHEN 8 THEN 'PST.' END AS 'TITLE', USERID
                    FROM users 
                    WHERE BLOCK=0 AND LOGONID NOT LIKE 'hod%' AND LOGONID NOT LIKE 'hou%'
                    AND USER_GROUP=102388 ORDER BY FULLNAME";
        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) : //print_r($row); exit;
                $datArr[$row['USERID']] = array("USERID" => $row['USERID'], "FULLNAME" => $row['FULLNAME'],
                                "TITLE" => $row['TITLE'], "LOGONID" => $row['LOGONID']
                            );
            endwhile;
        endif;
        
        return $datArr;
     }
     
     public function importCourseReg($val) {
        $chk = 0;
        foreach ($val as $key => $evalue) :
            $strsql = "INSERT INTO course_eval 
                        (REGNO, COURSE, ACADYEAR, SEMESTER, EVAL_STATUS, DATE_STARTED, DATE_COMPLETED) 
                       VALUES (?, ?, ?, ?, ?, ?, ?)
                         ON DUPLICATE KEY UPDATE TID=TID";
            $this->db->insert($strsql, "iiiiiss", $evalue)? ++$chk : null; //? null : $all_query_ok=false;
        endforeach;
        
        return $chk;
     }
     
     public function getQuestionByCategory($templateID, $cat) {
         $all_query_ok=true; // our control variable
         $datArr = array();
         $ansArr = array();
         $qid   = array();
         $totque = 0;
         $qlog = array();
         $alog = array();
         $retAns = array();
         
         $strsql = "SELECT qb.QID, qb.EXAMID, qb.QUESTION, qb.QCOMPOSITION_ID, qb.QINSTRUCTION, 
                       qb.NQUESTIONS, qb.QTYPE, qb.QCATEGORY, qb.QIMAGE
                       FROM `questionbank` qb
                       WHERE qb.EXAMID = '$templateID' AND qb.IS_ENABLED=1 AND qb.QCATEGORY = '$cat'";
        $some_st = $this->db->select($strsql);
        //if ($some_st->num_rows() >= 1) :
        while ($row = $some_st->fetch_assoc()) :
           $datArr[] = array('QID'=>$row['QID'], 'EXAMID'=>$row['EXAMID'], 'QUESTION'=>$row['QUESTION'],
           'QINSTRUCTION'=>$row['QINSTRUCTION'], 'NQUESTIONS'=>$row['NQUESTIONS'], 'QTYPE'=>$row['QTYPE'], 
           'QCATEGORY'=>$row['QCATEGORY'], 'QIMAGE'=>$row['QIMAGE']);
           $qid[] = $row['QID'];
           $totque += $row['NQUESTIONS'];
           //$qlog[] = "('$examid', '$examno', '{$row['QID']}', NULL, NOW())";
        endwhile;
        
        $queList = join(", ", $qid);
        $strsql = "SELECT AID, QID, ANSWER, `OPTION`, IS_CORRECT, WEIGHT FROM answerbank
                   WHERE QID IN ($queList)
                   ORDER BY QID";
        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            $cqid = 0;
            $opid = 0;
            $ct = 0;
            while ($row = $some_st->fetch_assoc()) :
                if ($cqid != $row['QID']) { $opid = 0; $cqid = $row['QID']; $ct = 0; }
                $ansArr[$row['QID']][++$ct] = array('AID'=>$row['AID'], 'QID'=>$row['QID'], 'ANSWER'=>$row['ANSWER'], 
                       'OPTION'=>++$opid, 'IS_CORRECT'=>$row['IS_CORRECT'], 'WEIGHT'=>$row['WEIGHT']);
                //$alog[] = "('$examid', '$examno', '{$row['QID']}', '{$row['AID']}', '$opid', '{$row['IS_CORRECT']}', '{$row['WEIGHT']}', NULL, NULL, NULL, NOW())";
            endwhile;

        endif;
        
        $this->exam_array = array("QUESTION"=>$datArr, "ANSWER"=>$ansArr);
        
     }
     
     public function setStartTime($regno, $kos, $sem, $acadyr) {
        $upd = "UPDATE course_eval SET DATE_STARTED='".date("Y-m-d H:i:s") . "' 
                     WHERE REGNO=? AND COURSE=? AND SEMESTER=? AND ACADYEAR=?"; 
        return $this->db->execute_query($upd, "iiii", $regno, $kos, $sem, $acadyr)? 1 : 0;
     }
    
    
     public function submitEval($genResp, $answerStore) {
         $this->db->autocommit(FALSE);
         $all_query_ok=true; // our control variable
         $chk = 0;
        
        //Insert General Response
        $strsql = "INSERT INTO tbl_general_response 
                    (REGNO, COURSE, LECTURER, GENDER, AGE, SEMESTER, ACADYEAR, DATE_SUBMITTED, COMMENTS) 
                   VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $rid = $this->db->insert($strsql, "iisiiiiss", $genResp); //? null : $all_query_ok=false;
        
        if ($rid>0):
            foreach ($answerStore as $key => $evalue) :
                $evalue["RID"] = $rid;
                $strsql = "INSERT INTO tbl_answer_store 
                            (RID, QID, AID, SCORE) 
                           VALUES (?, ?, ?, ?)";
                $this->db->execute_query($strsql, "iiii", $evalue)? null : $all_query_ok=false;
            endforeach;
        else:
            $all_query_ok = FALSE;
        endif;
        
        if ($all_query_ok):
            $upd = "UPDATE course_eval SET EVAL_STATUS=1, DATE_COMPLETED='".date("Y-m-d H:i:s") . "' 
                     WHERE REGNO=? AND COURSE=? AND SEMESTER=? AND ACADYEAR=?"; 
            $this->db->execute_query($upd, "iiii", $genResp['REGNO'], $genResp['COURSE'], $genResp['SEMESTER'], $genResp['ACADYEAR']);
            
            $upd = "UPDATE `tbl_answer_store` tas SET tas.SCORE = (SELECT WEIGHT FROM answerbank WHERE AID=tas.AID)
                    WHERE RID=?";
            $this->db->execute_query($upd, "i", $rid);
        endif;
        
        $all_query_ok ? $this->db->commit() : $this->db->rollback();
        
        $this->db->autocommit(TRUE);
        
        return $all_query_ok;
        
     }
     
     public function getEvalResponse($regno, $acadyr, $sem, $kos) {
         $datArr = $genArr = $ansArr = $lect = array();
         $rid = 0;
         
         $strsql = "SELECT RID, REGNO, COURSE, LECTURER, GENDER, AGE, SEMESTER, ACADYEAR, DATE_SUBMITTED, COMMENTS 
                   FROM tbl_general_response WHERE REGNO=? AND COURSE=? AND SEMESTER=? AND ACADYEAR=?";
        $some_st = $this->db->select($strsql, "iiii", $regno, $kos, $sem, $acadyr);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) :
                $genArr = array("RID"=>$row['RID'], "REGNO"=>$row['REGNO'], "COURSE"=>$row['COURSE'], 
                    "LECTURER"=>$row['LECTURER'], "GENDER"=>$row['GENDER'], "AGE"=>$row['AGE'], 
                    "SEMESTER"=>$row['SEMESTER'], "ACADYEAR"=>$row['ACADYEAR'], 
                    "DATE_SUBMITTED"=>$row['DATE_SUBMITTED'], "COMMENTS"=>$row['COMMENTS']);
                $rid = $row['RID'];
            endwhile;
        endif;
        
        $strsql = "SELECT RID, QID, AID, SCORE 
                  FROM tbl_answer_store WHERE RID=?";
        $some_st = $this->db->select($strsql, "i", $rid);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) :
                $ansArr[$row['QID']] = $row['AID'];
            endwhile;
        endif;
        
        $strsql = "SELECT LOGONID, CONCAT_WS(' ', LASTNAME, FIRSTNAME, MIDDLENAME) AS 'FULLNAME', CASE TITLE WHEN 5 THEN 'PROF.' 
            WHEN 4 THEN 'DR.' WHEN 1 THEN 'MR.' WHEN 2 THEN 'MISS' WHEN 3 THEN 'MRS' WHEN 8 THEN 'PST.' END AS 'TITLE', USERID
                    FROM users 
                    WHERE USERID IN ({$genArr['LECTURER']})"; 
        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) : 
                $lect[$row['USERID']] = array("USERID" => $row['USERID'], "FULLNAME" => $row['FULLNAME'],
                                "TITLE" => $row['TITLE'], "LOGONID" => $row['LOGONID']);
            endwhile;
        endif;
        
        $datArr = array("GENDATA" => $genArr, "ANS" => $ansArr, "LECTURERS" => $lect);
        
        return $datArr;
     }
    
    

     public function getFullName() {
         return $this->fullname;
     }

     public function getFirstName() {
         return $this->firstname;
     }

     public function getLastName() {
         return $this->lastname;
     }

     public function getMiddleName() {
         return $this->middlename;
     }

     public function getRegNo() {
         return $this->regno;
     }

     public function getMatricNo() {
         return $this->matricno;
     }

     public function getUID() {
         return $this->uid;
     }

     public function getUserType() {
         return $this->usertype;
     }

     public function getUserType_ID() {
         return $this->usertype_id;
     }

     public function getProgID() {
         return $this->progid;
     }
     
     public function getProgramme($pid) {
         $qry = "SELECT `NAME` FROM programmes
                WHERE ID=?"; 
        $some_sth = $this->db->select($qry, 's', $pid);
        $rows = $some_sth->num_rows();
        $row = $some_sth->fetch_object(); 
        
        return $row->NAME;
       
     }

     public function isAdmin() {
         return $this->is_admin;
     }   

     public function getExamArray() {
         return $this->exam_array;
     }   

     public function setDB($dbconnection) {
         $this->db = $dbconnection;
     }
     
}
