<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
//session_start(); 
//$sid = session_id();
//error_reporting(E_STRICT | E_ALL);
//require_once '../includes/common_functions.php';
if (file_exists("config2.php"))
    require_once "config2.php";
elseif (file_exists("../config2.php"))
    require_once "../config2.php";
elseif (file_exists("../../config2.php"))
    require_once "../../config2.php";

if (file_exists("includes/common_functions.php"))
    require_once "includes/common_functions.php";
elseif (file_exists("../includes/common_functions.php"))
    require_once "../includes/common_functions.php";
elseif (file_exists("../../includes/common_functions.php"))
    require_once "../../includes/common_functions.php";

if (file_exists("includes/opener.php"))
    require_once "includes/opener.php";
elseif (file_exists("../includes/opener.php"))
    require_once "../includes/opener.php";
elseif (file_exists("../../includes/opener.php"))
    require_once "../../includes/opener.php";
elseif (file_exists("../../../includes/opener.php"))
    require_once "../../../includes/opener.php";

if (file_exists("classes/PHPMailer/PHPMailerAutoload.php"))
    require_once "classes/PHPMailer/PHPMailerAutoload.php";
elseif (file_exists("../classes/PHPMailer/PHPMailerAutoload.php"))
    require_once "../classes/PHPMailer/PHPMailerAutoload.php";
elseif (file_exists("../../classes/PHPMailer/PHPMailerAutoload.php"))
    require_once "../../classes/PHPMailer/PHPMailerAutoload.php";

if (file_exists("classes/Password_Generator.php"))
    require_once "classes/Password_Generator.php";
elseif (file_exists("../classes/Password_Generator.php"))
    require_once "../classes/Password_Generator.php";
elseif (file_exists("../../classes/Password_Generator.php"))
    require_once "../../classes/Password_Generator.php";


/**
 * Description of UserProfile
 *
 * @author OPMat
 */
class UserProfile extends Logger {
    //put your code here
    private $db;
    private $uid;
    private $fullname;
    private $is_admin; 
    private $is_enabled; 
    private $usertype; 
    private $usertype_id;
    private $username; 
    private $rad_username;
    private $lastname;
    private $firstname;
    private $package;
    private $packageid;
    private $expiration;
    private $email;
    private $mobile;
    private $sid;
    private $readonly;
	private $lastlogoff;
    
    public $totalRecords;
    public $totalRecordwithFilter;



    public function __construct($dbconnection) {
        $this->db = $dbconnection;
//        parent::setDB($dbconnection);
        $this->sid = session_id();
        parent::__construct($dbconnection, $_SESSION[$this->sid."username"]);
    } 
    
     
    public function authenticateUser($username, $password)  {
       $qry = "SELECT tc.ID, tc.USERNAME, tc.RAD_USERNAME, tc.IS_ENABLED, DATE_CREATED, enableuser, uplimit, downlimit, 
                    comblimit, firstname, lastname, email, tal.ADMIN_TYPE,
                    company, mobile, expiration, ru.srvid, rs.srvname, tc.USERTYPE, lastlogoff
                FROM `tblclients` tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_admin_level tal ON tc.USERTYPE=tal.ID
                WHERE tc.USERNAME LIKE ? AND tc.PASSWORD=?"; 
       $some_sth = $this->db->select($qry, 'ss', $username, sha1($password));
       $rows = $some_sth->num_rows(); 
       while ( $row = $some_sth->fetch_object() ) {
           $this->uid = $row->ID;
           $this->username = $row->USERNAME;
           $this->rad_username = $row->RAD_USERNAME;
           $this->is_admin = 0;
           $this->usertype = $row->ADMIN_TYPE; //"USER";
           $this->usertype_id = $row->USERTYPE; //3
           $this->is_enabled = ($row->IS_ENABLED == 1 && $row->enableuser == 1);
           $this->fullname = $row->firstname . " " . $row->lastname;
           $this->email = $row->email;
           $this->mobile = $row->mobile;
           $this->expiration = $row->expiration;
           $this->packageid = $row->srvid;
           $this->package = $row->srvname;
           $this->lastlogoff = $row->lastlogoff;
       }

       return $rows;
    } 
    
     
    public function authenticateAdmin($username, $password)  {
       $qry = "SELECT tad.AID, tad.USERNAME, tad.FULLNAME, tad.MOBILE, tad.EMAIL, tad.ACCESS_LEVEL, 
                    tal.ADMIN_TYPE, tad1.FULLNAME AS 'ADDED_BY', tad.IS_ENABLED, tad.`READONLY` 
                FROM `tbl_admins` tad
                LEFT JOIN tbl_admin_level tal ON tad.ACCESS_LEVEL = tal.ID
                LEFT JOIN tbl_admins tad1 ON tad.ADDED_BY = tad1.AID
               WHERE tad.USERNAME LIKE ? AND tad.PASSWORD=?"; 
       $some_sth = $this->db->select($qry, 'ss', $username, sha1($password));
       $rows = $some_sth->num_rows();
       while ( $row = $some_sth->fetch_object() ) {
           $this->uid = $row->AID;
           $this->username = $row->USERNAME;
           $this->rad_username = "";
           $this->is_admin = 1;
           $this->usertype = $row->ADMIN_TYPE;
           $this->usertype_id = $row->ACCESS_LEVEL;
           $this->is_enabled = $row->IS_ENABLED;
           $this->fullname = $row->FULLNAME;
           $this->email = $row->EMAIL;
           $this->mobile = $row->MOBILE;
           $this->expiration = "0000-00-00";
           $this->packageid = 0;
           $this->package = "ADMIN";
           $this->readonly = $row->READONLY;
       }

       return $rows;
    }
    
    public function adminList() {
        $ret = [];
        $qry = "SELECT tad.AID, tad.USERNAME, tad.FULLNAME 
                FROM `tbl_admins` tad
               WHERE tad.IS_ENABLED = 1 AND ( (USERNAME NOT LIKE 'opmat') AND (USERNAME NOT LIKE 'akoshodi') )"; 
       $some_sth = $this->db->select($qry);
//       $rows = $some_sth->num_rows();
       while ( $row = $some_sth->fetch_object() ) {
           $ret[] = ["AID"=>$row->AID, "USERNAME"=>$row->USERNAME, "FULLNAME"=>$row->FULLNAME];
       }
       return $ret;
    }
    
    public function dashList() {
        $ret = [];
        $qry = "SELECT DASHID, DASHNAME, DASHIMG, DASHORDER FROM tbl_dash 
                WHERE ISACTIVE=1
                ORDER BY DASHORDER ASC";
        $some_sth = $this->db->select($qry);
//       $rows = $some_sth->num_rows();
       while ( $row = $some_sth->fetch_object() ) {
           $ret[] = ["DASHID"=>$row->DASHID, "DASHNAME"=>$row->DASHNAME, "DASHIMG"=>$row->DASHIMG, "DASHORDER"=>$row->DASHORDER];
       }
       return $ret;
    }
    
    public function adminDashList($adminID) {
        $ret = [];
        $qry = "SELECT tad.DASHID, DASHNAME, DASHIMG, DASHORDER FROM tbl_admin_dash tad
                LEFT JOIN tbl_dash td ON tad.DASHID=td.DASHID
                WHERE tad.AID=?
                ORDER BY DASHORDER ASC";
        $some_sth = $this->db->select($qry, "i", $adminID);
//       $rows = $some_sth->num_rows();
       while ( $row = $some_sth->fetch_object() ) {
           $ret[$row->DASHID] = ["DASHID"=>$row->DASHID, "DASHNAME"=>$row->DASHNAME, "DASHIMG"=>$row->DASHIMG, "DASHORDER"=>$row->DASHORDER];
       }
       return $ret;
    }
    
    public function createPlanSwitchRequest($username, $curPlan, $newPlan) {
        $ins = "INSERT INTO tbl_plan_change_request (USERNAME, CUR_PLAN_ID, NEW_PLAN_ID, 
                REQUEST_DATE, REQUEST_DONE) VALUE (?, ?, ?, NOW(), 0)";
        $in_id = $this->db->insert($ins, "sii", $username, $curPlan, $newPlan);
        
        if ($in_id > 0):
            $this->logTrail($this::INFO, "Plan Switch Request for User [$username] submitted successfully.", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::INFO, "Error: Plan Switch Request for User [$username] failed at this time", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0;
        endif;
    }
        
    public function setAdminDashList($adminID, $addedby, $dashlist = []) {
        $all_query_ok= true;
        // $this->db->autocommit(FALSE);
        foreach ($dashlist as $dash):
            $ins = "INSERT INTO tbl_admin_dash (AID, DASHID, ADDEDBY, DATEADDED) VALUES 
                     (?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE ADDEDBY=VALUES(ADDEDBY)";
            $this->db->insert($ins, "iii", $adminID, $dash, $addedby)? null : $all_query_ok=false;
        endforeach;
        $qry = "DELETE FROM tbl_admin_dash WHERE AID=? AND DASHID NOT IN (" . implode(",",$dashlist) . " )";
        $this->db->execute_query($qry, "i", $adminID)? null : $all_query_ok=false;
        
//         $all_query_ok ? $this->db->commit() : $this->db->rollback();
        
//         $this->db->autocommit(TRUE);
        return $all_query_ok;
    }
     
    public function loadUserProfile($radusername)  {
       $qry = "SELECT ru.username, enableuser, firstname, lastname, email,
                    company, mobile, expiration, ru.srvid, rs.srvname, address, city, state
                FROM rm_users ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                WHERE username LIKE ?"; 
       $some_sth = $this->db->select($qry, 's', $radusername);
       $rows = $some_sth->num_rows();
       if ($rows) $row = $some_sth->fetch_object(); 
       else $row = "";

       return $row;
    } 
    
    public function updateUserProfile($radusers, $email, $phone) {
        $done = 0;
        $sid = session_id();
        
        foreach ($radusers as $key => $user) {
            $upd = "UPDATE rm_users SET email=?, mobile=? WHERE username=?";
            $rett = $this->db->execute_query($upd, "sss", $email, $phone, $user);
            if ($rett) $done = 1;
        }
        
        if ($done) :            
            $_SESSION[$sid.'phoneNo'] = $phone;
            $_SESSION[$sid.'email'] = $email;
            $this->logTrail($this::INFO, "Success: Profile Update for User [$radusers]! EMAIL: $email; PHONE: $phone", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "Error: Profile Update for User [$radusers] failed! EMAIL: $email; PHONE: $phone", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Update failed! No changes made.";
        endif;
    }
    
    public function updateUserProfile2($raduser, $name, $address, $city, $state) {
        $done = 0;
        $sid = session_id();
        
        if ($raduser != "") {
            $upd = "UPDATE rm_users SET firstname=?, lastname='', address=?, city=?, state=? WHERE username=?";
            $rett = $this->db->execute_query($upd, "sssss", $name, $address, $city, $state, $raduser);
            if ($rett) $done = 1;
        }
        
        if ($done) :                        
            $_SESSION[$sid.'fullname'] = $name;
            $this->logTrail($this::INFO, "Success: Profile Update for User [$radusers]! NAME: $name; ADDRESS: $address; CITY: $city; STATE: $state", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "Error: Profile Update for User [$radusers] failed! NAME: $name; ADDRESS: $address; CITY: $city; STATE: $state", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Update failed! No changes made.";
        endif;
    }
    
    public function updateUserProfile3($raduser, $fname, $lname, $address, $city, $state, $email, $mobile) {
        $done = 0;
        $sid = session_id();
        
        if ($raduser != "") {
            $upd = "UPDATE rm_users SET firstname=?, lastname=?, address=?, city=?, state=?,email=?, mobile=?
                     WHERE username=?";
            $rett = $this->db->execute_query($upd, "ssssssss", $fname, $lname, $address, $city, $state, $email, $mobile, $raduser);
            if ($rett) $done = 1;
        }
        
        return $done;
    }
    
    
    public function verifyUserExist($username="") {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.USERNAME, tc.IS_ENABLED, enableuser
                FROM `tblclients` tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username
                WHERE tc.USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                if ($row->IS_ENABLED == 1 && $row->enableuser == 1):
                    $exist = 1;
                else:
                    //disabled
                    $exist = 2;
                endif;
            }
        endif;
        
        return $exist;
    }
    
    public function verifyUserDepth($username) {
        $exist = 0;
        $qry = "SELECT username FROM rm_users WHERE username = ?";
        $some_sth = $this->db->select($qry, 's', $username);
        $rows = $some_sth->num_rows();
        if (!$rows):
            return $exist;
        else:
            //check if exist in eservice as Client
            $cid = $this->eServiceUserExist($username);
            if ($cid > 0):
                //check if it has subaccount
                $hasSub = $this->userHasSubAccount($cid);
                return ($hasSub)? -2 : 2;
            else:
                //check if exist as subaccount in eservice
                $ist = $this->subAccountUserExist($username);
                return ($ist > 0)? 3 : 1;
            
            endif;
        endif;
        return $exist;
    }
    
    
    public function userHasSubAccount($clientID) {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.ID
                FROM `tbl_subaccount` tc
                WHERE tc.CID LIKE ?";
            $some_sth = $this->db->select($qry, 'i', $clientID);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                return 1;
            }
        endif;
        
        return $exist;
    }
    
    
    public function subAccountUserExist($username) {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.ID
                FROM `tbl_subaccount` tc
                WHERE tc.RAD_USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                $row = $some_sth->fetch_object();
                return $row->ID;
            }
        endif;
        
        return $exist;
    }
    
    
    public function eServiceUserExist($username) {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.ID, tc.USERNAME, tc.IS_ENABLED
                FROM `tblclients` tc
                WHERE tc.RAD_USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                $row = $some_sth->fetch_object();
                return $row->ID;
            }
        endif;
        
        return $exist;
    }
    
    
    public function verifyUserExistAlone($username="") {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.USERNAME, tc.IS_ENABLED
                FROM `tblclients` tc
                WHERE tc.USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                $exist = 1;
            }
        endif;
        
        return $exist;
    }
    
    
    public function verifyAdminExist($username="") {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT * FROM `tbl_admins`
                WHERE USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                if ($row->IS_ENABLED == 1):
                    $exist = 1;
                else:
                    //disabled
                    $exist = 2;
                endif;
            }
        endif;
        
        return $exist;
    }
    
    
    public function verifyPlanExist($plan="", $package=0) {
        $exist = 0;
        if ($plan <> "" && $package <> 0) :
            $qry = "SELECT SRVID, PLAN, IS_ENABLED
                FROM `tbl_plans` 
                WHERE PLAN =? AND SRVID=?";
            $some_sth = $this->db->select($qry, 'si', $plan, $package);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                if ($row->IS_ENABLED == 1):
                    $exist = 1;
                else:
                    //disabled
                    $exist = 2;
                endif;
            }
        endif;
        
        return $exist;
    }
    
    public function planIsUpCountry($plan) {
        if ($plan <> "" ) :
            $qry = "SELECT IS_UPCOUNTRY FROM `tbl_plans` WHERE PLAN =? ";
            $some_sth = $this->db->select($qry, 's', $plan);
            $row = $some_sth->fetch_object();
            return $row->IS_UPCOUNTRY;            
        else:
            return false;
        endif;
    }
    
    
    public function savePResetToken($username, $token) {
        $saved = 0;
        
        if ($username <> "") :
            $v = $this->verifyUserExist($username);
            $v1 = $this->verifyAdminExist($username);
            if ($v == 0 && $v1 == 0) :
                //Does not Exist
                $this->logTrail($this::INFO, "Error: Password Reset Request failed! User [$username] is Invalid.", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: User [$username] is Invalid.";
            elseif ($v == 2 || $v1 == 2):
                //Blocked
                $this->logTrail($this::INFO, "Error: Password Reset Request failed! User [$username] is blocked.", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: User <$username] is blocked. Please Contact the Administrator";           
            else:
                //User Is Okay
                $qry = "INSERT INTO tbl_pchange_request (USERNAME, REQUEST_TOKEN, IS_USED, REQUEST_DATE, USE_DATE) 
                 VALUES(?, ?, 0, NOW(), '0000-00-00 00:00:00')";
                $saved = $this->db->insert($qry, "ss", $username, $token);
                if ($saved > 0):
                    $this->logTrail($this::INFO, "Password Reset Request successful for User [$username].", $this::STATUS_PASSED, get_client_ip_env()); 
                    return 1;
                else:
                    $this->logTrail($this::INFO, "Error: Password Reset Request failed for User [$username]. Unable to Initiate a reset at this time", $this::STATUS_FAILED, get_client_ip_env()); 
                    return "Error: Unable to Initiate a reset at this time!";
                endif;
            endif;
        else:
            $this->logTrail($this::INFO, "Error: Password Reset Request failed! User [$username]is Invalid.", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] is Invalid!";
        endif;
        
        //return $saved;
    }
    
    public function getActivePResetToken($username) {
        $is_okay = 0;
        
        if ($username <> "") :
            $qry = "SELECT * FROM tbl_pchange_request WHERE USERNAME = ? AND IS_USED = 0 AND
                     NOW() < DATE_ADD(REQUEST_DATE, INTERVAL 24 HOUR) ORDER BY REQUEST_DATE DESC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows) {
                $is_okay = 1;
                $row = $some_sth->fetch_object();
                return $row->REQUEST_TOKEN;
            }
        endif;
        
        return $is_okay;
    }
    
    
    public function sendEmail($to, $from, $subject, $message, $cc=[], $bcc=[]) { 
        if ($to <> "" && $subject <> "" && $message <> "") :
            
            $mail = new PHPMailer;
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = 'mail.fob.com.ng'; // 'mail.kkontech.com';  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = 'erp@fob.com.ng'; // 'outbound@kkontech.com';                 // SMTP username
            $mail->Password = 'Outbound123'; // 'outbound11';  //outbound123                         // SMTP password
            $mail->SMTPSecure = 'ssl'; // 'tls'; // 'tls';                            // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 465;  // 587; //465;                                    // TCP port to connect to

            $mail->setFrom($from, 'FiberOne');
            $mail->addAddress($to);               // Name is optional
            $mail->addReplyTo($from, 'FiberOne');
            $mail->isHTML(true);                                  // Set email format to HTML
            if (count($cc) > 0) {
                foreach ($cc as $key => $value) {
                    $mail->addCC($value, $key);
                }
            }                                  // Set email format to HTML
            if (count($bcc) > 0) {
                foreach ($bcc as $key => $value) {
                    $mail->addBCC($value, $key);
                }
            }

            $mail->Subject = $subject;
            $mail->Body    = nl2br($message);
            $mail->AltBody = nl2br($message); //$mail->SMTPDebug = 1; 
    		$mail->SMTPOptions = array(
        		'ssl' => array(
            	'verify_peer' => false,
            	'verify_peer_name' => false,
            	'allow_self_signed' => true
        		)
    		);

			// $mail->SMTPDebug = 2; 
            return $mail->send();
            
        else:
            return $mail->ErrorInfo; // 0 ;
        endif;
    }
    
    
    public function getCannedMessage($purpose="") {
        $msg = "";
        $ad = "";
        if ($purpose <> "") :
            $purpose = mysqli_real_escape_string($this->db, $purpose);
            $ad = " WHERE PURPOSE LIKE '$purpose'";
        endif;
            
        $qry = "SELECT CANNED_MSG FROM `tbl_canned_msg` $ad LIMIT 1";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $msg = $row->CANNED_MSG;
        }
        
        return $msg;
    }
    
    public function verifyPResetToken($username, $token) {
        $is_okay = 0;
        
        if ($username <> "") :
            $qry = "SELECT * FROM tbl_pchange_request WHERE USERNAME = ? AND REQUEST_TOKEN = ? AND IS_USED = 0 AND
                     NOW() < DATE_ADD(REQUEST_DATE, INTERVAL 24 HOUR)";
            $some_sth = $this->db->select($qry, 'ss', $username, $token);
            $rows = $some_sth->num_rows();
            if ($rows)
                $is_okay = 1;
        endif;
        
        return $is_okay;
    }
    
    public function changePackage($username, $pckid, $pck, $adminName) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        if ($username <> "" && $pck <> "" && $pckid > 0) :
            $upd = "UPDATE rm_users SET srvid = ? 
                     WHERE USERNAME = ?";
            $this->db->execute_query($upd, "is", $pckid, $username)? null : $all_query_ok=false; 
            
            $ddate = date("Y-m-d");
            $ins = "INSERT INTO rm_changesrv (id, username, newsrvid, newsrvname, scheduledate, requestdate, `status`,
                    transid, requested) VALUES
                    (NULL, ?, ?, ?, ?, ?, 1, '', ?)"; 
            $this->db->insert($ins, 'sissss', $username, $pckid, $pck, $ddate, $ddate, "eservice-$adminName")? null : $all_query_ok=false;
            
            $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
        else:
            $all_query_ok = FALSE;
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :   
            $this->logTrail($this::SERVICE_CHANGE, "$adminName successfully changed $username service to $pck ($pckid)", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::SERVICE_CHANGE, "$adminName failed trying to change $username service to $pck ($pckid)", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0;
        endif;
    }
    
    
    public function resetPassword($username, $password, $token, $is_admin=0) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        //echo "U: $all_query_ok ". $this->db->error . "<br/>" ;
        if ($username <> "" && $password <> "") :
            $upd = "UPDATE tbl_pchange_request SET IS_USED = 1, USE_DATE = NOW() 
                     WHERE USERNAME = ? AND REQUEST_TOKEN = ? AND IS_USED = 0";
            $this->db->execute_query($upd, "ss", $username, $token)? null : $all_query_ok=false; 
                  //echo "U1: $all_query_ok ". $this->db->error . "<br/>" ;     
            if ($is_admin) :              
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 1 FROM tbl_admins WHERE USERNAME LIKE ?"; 
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;
                //echo "U2: $all_query_ok ". $this->db->error . "<br/>" ;
                
                $upd = "UPDATE tbl_admins SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
            else:                
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 0 FROM tblclients WHERE USERNAME LIKE ?";
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;
                
                $upd = "UPDATE tblclients SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
            endif;
            
            $this->db->execute_query($upd, 'ss', sha1($password), $username)? null : $all_query_ok=false;
            //echo "U3: $all_query_ok ". $this->db->error . "<br/>" ;
            
            $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
        else:
            $all_query_ok = FALSE;
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :     
            $this->logTrail($this::PASSWORD_CHANGE, "Password Reset successful for User [$username]", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::PASSWORD_CHANGE, "Error: Password Reset failed for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0;
        endif;
    }    
    
    
    public function verifyPassword($username, $password, $is_admin = 0) {
        $all_query_ok=true; // our control variable
        //$this->db->autocommit(FALSE);
        $ret = 0;
        $tb = ($is_admin)? "tbl_admins" : "tblclients";
                
        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM $tb 
                     WHERE USERNAME = ? AND PASSWORD = ?";
            $some_sth = $this->db->select($strsql, "ss", $username, sha1($password)); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
                return 1;
            } else {
                return 0;
            }
            
        endif;
        
        return (-1);
    } 
    
    
    public function verifyRadiusPassword($username, $password) {

        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM radcheck 
                     WHERE username = ? AND `value` = ? AND `attribute`='Cleartext-Password'";
            $some_sth = $this->db->select($strsql, "ss", $username, $password); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
                return 1;
            } else {
                return 0;
            }
            
        endif;
        
        return (-1);
    }
    
    
    public function changePassword($username, $password, $old_pass) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        $ret = 0;
                
        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM tblclients
                     WHERE USERNAME LIKE ? AND PASSWORD = ?";
            $some_sth = $this->db->select($strsql, "ss", $username, sha1($old_pass)); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
            
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 0 FROM tblclients WHERE USERNAME LIKE ?";
                $this->db->insert($ins, 'ss', sha1(trim($password)), $username)? null : $all_query_ok=false;

                $upd = "UPDATE tblclients SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
                $this->db->execute_query($upd, 'ss', sha1(trim($password)), $username)? null : $all_query_ok=false;

                $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
            } else {
                $all_query_ok=false;
                $ret = -1;
            }
        else:
            $all_query_ok = false; 
            $ret = -1;            
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :       
            $this->logTrail($this::PASSWORD_CHANGE, "User [$username] changed password successfully", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::PASSWORD_CHANGE, "Error: Password change failed for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return $ret;
        endif;
    }
    
    public function changeAdminPassword($username, $password, $old_pass) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        $ret = 0;
                
        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM tbl_admins
                     WHERE USERNAME = ? AND PASSWORD = ?";
            $some_sth = $this->db->select($strsql, "ss", $username, sha1($old_pass)); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
            
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 1 FROM tbl_admins WHERE USERNAME LIKE ?";
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;

                $upd = "UPDATE tbl_admins SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
                $this->db->execute_query($upd, 'ss', sha1($password), $username)? null : $all_query_ok=false;

                $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
            } else {
                $all_query_ok=false;
                $ret = -1;
            }
            
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :       
            $this->logTrail($this::PASSWORD_CHANGE, "Admin [$username] changed Password successfully", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::PASSWORD_CHANGE, "Error: Password Reset failed for Admin [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return $ret;
        endif;
    }
    
    public function getUserDataUsage($user, $unit='GiB') {
        $qry = "SELECT ru.username, tp.DATA_VOLUME, (comblimit -
                    ((SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                    FROM radacct WHERE radacct.username = ru.username) +
                    (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                    FROM rm_radacct WHERE rm_radacct.username = ru.username))) AS 'DATA_BALANCE',
                    rs.limitcomb
                FROM `rm_users` ru
                    LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                    LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID
               WHERE 
               ru.username=?";
        $some_sth = $this->db->select($qry, 's', $user);
        $row = $some_sth->fetch_object();
        //bytes($row->acctoutputoctets, $unit, '%01.2f');
        $rec = ['DATA_VOLUME'=>$row->DATA_VOLUME, 'DATA_BALANCE'=>$row->DATA_BALANCE,
                'LIMITCOMB'=>$row->limitcomb, 'DATA_VOLUME_GB'=>bytes($row->DATA_VOLUME, $unit, '%01.2f'), 
                'DATA_BALANCE_GB'=>bytes($row->DATA_BALANCE, $unit, '%01.2f'),
                'PERCENT_LEFT' => $row->DATA_VOLUME>0? round(($row->DATA_BALANCE/$row->DATA_VOLUME)*100) : 0,
                'PERCENT_USED' => $row->DATA_VOLUME>0? round((($row->DATA_VOLUME-$row->DATA_BALANCE)/$row->DATA_VOLUME)*100) : 0];
        return $rec;
    }
    
    public function loadUsage($username, $startdate = "", $stopdate = "") {
        $rec = array();
        
        if ($username <> "") :
            if ($startdate == "") :
                $startdate = date("Y")."-".date("m")."-01 00:00:00";
                $stopdate = date("Y-m-d H:i:s");
            endif;
            $up = $down = 0;
            $qry = "SELECT acctstarttime, acctstoptime,  
                        acctsessiontime, acctinputoctets, acctoutputoctets, acctterminatecause
                    FROM `radacct`
                    WHERE username LIKE ? AND acctstarttime BETWEEN $startdate AND $stopdate 
                    ORDER BY acctstarttime ASC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                $rec[] = array("ON"=>$row->acctstarttime, "OFF"=>$row->acctstoptime, 
                            "DURATION"=>  convertSecToStr($row->acctsessiontime), 
                            "UP"=> formatBytes($row->acctinputoctets), "DOWN"=> formatBytes($row->acctoutputoctets),
                            "REASON"=> $row->acctterminatecause);
            }
        endif;
        
        return $rec;
    }
    
    public function loadCurrentUsage($username) {
        $rec = array();
        
        if ($username <> "") :
            $up = $down = 0;
            $qry = "SELECT acctstarttime, acctstoptime,  
                        acctsessiontime, acctinputoctets, acctoutputoctets, acctterminatecause
                    FROM `radacct` r
                    WHERE username LIKE ? AND acctstarttime BETWEEN 
                    SUBDATE((SELECT expiration FROM rm_users WHERE username = r.username), INTERVAL 1 MONTH) AND NOW() 
                    ORDER BY acctstarttime ASC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                $rec[] = array("ON"=>$row->acctstarttime, "OFF"=>$row->acctstoptime, 
                            "DURATION"=>  convertSecToStr($row->acctsessiontime), 
                            "UP"=> formatBytes($row->acctinputoctets), "DOWN"=> formatBytes($row->acctoutputoctets),
                            "REASON"=> $row->acctterminatecause);
            }
        endif;
        
        return $rec;
    }
    
    public function loadCurrentUsageTotal($username) {
        $rec = array();
        
        if ($username <> "") :
            $up = $down = 0;
            $qry = "SELECT SUM(acctsessiontime) AS 'TIMEONLINE', SUM(acctinputoctets) AS 'INPUTOCTETS', 
                        SUM(acctoutputoctets) AS 'OUTPUTOCTETS'
                    FROM `radacct` r
                    WHERE username LIKE ? AND acctstarttime BETWEEN 
                    SUBDATE((SELECT expiration FROM rm_users WHERE username = r.username), INTERVAL 1 MONTH) AND NOW() 
                    ORDER BY acctstarttime ASC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                $rec[] = array("DURATION"=>  convertSecToStr($row->TIMEONLINE), 
                            "UP"=> formatBytes($row->INPUTOCTETS), "DOWN"=> formatBytes($row->OUTPUTOCTETS));
            }
        endif;
        
        return $rec;
    }
    
    public function getDataUsageByUser($username="", $start="todaystart", $end="todayend", $unit="GiB") {
        $ret = $rac = array();
        
        $ad = " WHERE 1";
        if ($username <> "") :
            $user = $this->db->real_escape_string($username);
            $ad .= " AND username LIKE '$user'";
        endif;
        
        $start = ($start === "todaystart")? date("Y-m-d")." 00:00:00" : $start;
        $end = ($end === "todayend")? date() : $end;
        $ad .= " AND acctstarttime BETWEEN ? AND ?";
        
        $qry = "SELECT MIN(acctstarttime) AS acctstarttime, MAX(acctstoptime) AS 'acctstoptime', (SUM(acctinputoctets) + SUM(acctoutputoctets)) AS 'TOTAL',
                    SUM(acctsessiontime) AS 'acctsessiontime', SUM(acctinputoctets) AS 'acctinputoctets', SUM(acctoutputoctets) AS 'acctoutputoctets', acctterminatecause 
                FROM `radacct`
                $ad 
                GROUP BY YEAR(acctstarttime), MONTH(acctstarttime), DAY(acctstarttime)
                ORDER BY YEAR(acctstarttime), MONTH(acctstarttime), DAY(acctstarttime)"; //echo $qry; // GROUP BY YEAR(acctstarttime), MONTH(acctstarttime), DAY(acctstarttime)
        $some_sth = $this->db->select($qry, "ss", $start, $end);
        while ( $row = $some_sth->fetch_object() ) {
            $ret['DOWN'] = bytes($row->acctoutputoctets, $unit, '%01.2f');
            $ret['UP'] = bytes($row->acctinputoctets, $unit, '%01.2f');
            $ret['TOTAL'] = bytes($row->TOTAL, $unit, '%01.2f');
            $ret['CONNECT'] = $row->acctstarttime;
            $ret['DISCONNECT'] = $row->acctstoptime;
            $ret['DURATION'] = $row->acctsessiontime;
            $ret['REASON'] = $row->acctterminatecause;  
            $ret['UNIT'] = $unit;
        	$ret['DAY'] = date("jS", strtotime($row->acctstarttime));
        	$ret['MONTH'] = date("M", strtotime($row->acctstarttime));
        	
        	$rac[] = $ret;
        }
        return $rac;
    }
    
    
    public function getMonthlyDataUsageAsString($username="", $month="", $year="") {
        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysqli_real_escape_string($this->db, $username); // mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT DAY(acctstarttime) AS 'DAY', SUM(acctinputoctets) AS 'UP', SUM(acctoutputoctets) AS 'DOWN', 
                    SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad 
                    GROUP BY DAY(acctstarttime)
                    ORDER BY DAY(acctstarttime)"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
//            $ret[$row->DAY] = array("DAY"=>$row->DAY, 
//                                    "UP"=>$row->UP, 
//                                    "DOWN"=> $row->DOWN, 
//                                    "TOTAL"=> $row->TOTAL);
            $down = bytes($row->DOWN, "MiB", '%01.2f');
            $up = bytes($row->UP, "MiB", '%01.2f');
            $total = bytes($row->TOTAL, "MiB", '%01.2f');
            $ret[1][] = "[{$row->DAY}, $down]";
            $ret[2][] = "[{$row->DAY}, $up]";
            $ret[3][] = "[{$row->DAY}, $total]";
        }
       	
        if ($rows) :
            $rac[1] = "[" . implode(", ", $ret[1]) . "]";
            $rac[2] = "[" . implode(", ", $ret[2]) . "]";
            $rac[3] = "[" . implode(", ", $ret[3]) . "]";
        endif;
        
        return $rac;
    }
    
    
    public function getMonthlyDataUsageMobile($username="", $month="", $year="") {
        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysqli_real_escape_string($this->db, $username); // mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT DAY(acctstarttime) AS 'DAY', SUM(acctinputoctets) AS 'UP', SUM(acctoutputoctets) AS 'DOWN', 
                    SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad 
                    GROUP BY DAY(acctstarttime)
                    ORDER BY DAY(acctstarttime)"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        $lbl = [];
        while ( $row = $some_sth->fetch_object() ) {
            $down = bytes($row->DOWN, "MiB", '%01.2f');
            $up = bytes($row->UP, "MiB", '%01.2f');
            $total = bytes($row->TOTAL, "MiB", '%01.2f');
            $ret[1][$row->DAY] = $down;
            $ret[2][$row->DAY] = $up;
            $ret[3][$row->DAY] = $total;
            $lbl[] = $row->DAY;
        }
        
        if ($rows) :
            $rac['down'] = json_encode($ret[1]); // "{{v:" . implode("}, {v:", $ret[1]) . "}}";
            $rac['up'] = json_encode($ret[2]); // v:" . implode("}, {v:", $ret[2]) . "}]";
            $rac['total'] = json_encode($ret[3]); // "[{v:" . implode("}, {v:", $ret[3]) . "}]";
            $rac['label'] = json_encode($lbl); // v:" . implode("}, {v:", $lbl) . "}]";
        else:
            $rac['down'] = json_encode([0,0]);
            $rac['up'] = json_encode([0,0]);
            $rac['total'] = json_encode([0,0]);
            $rac['label'] = json_encode([1,2]);
        endif;
        
        return $rac;
    }
    public function getMonthlyDataUsage($username="", $month="", $year="") {
        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysqli_real_escape_string($this->db, $username); // mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT DAY(acctstarttime) AS 'DAY', SUM(acctinputoctets) AS 'UP', SUM(acctoutputoctets) AS 'DOWN', 
                    SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad 
                    GROUP BY DAY(acctstarttime)
                    ORDER BY DAY(acctstarttime)"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
//            $ret[$row->DAY] = array("DAY"=>$row->DAY, 
//                                    "UP"=>$row->UP, 
//                                    "DOWN"=> $row->DOWN, 
//                                    "TOTAL"=> $row->TOTAL);
            $down = bytes($row->DOWN, "MiB", '%01.2f');
            $up = bytes($row->UP, "MiB", '%01.2f');
            $total = bytes($row->TOTAL, "MiB", '%01.2f');
            $ret[1][] = array($row->DAY, $down);
            $ret[2][] = array($row->DAY, $up);
            $ret[3][] = array($row->DAY, $total);
        }
        
//        if ($rows) :
//            $rac[1] = "[" . implode(", ", $ret[1]) . "]";
//            $rac[2] = "[" . implode(", ", $ret[2]) . "]";
//            $rac[3] = "[" . implode(", ", $ret[3]) . "]";
//        endif;
        
        return $ret;
    }
    
    public function getTotalMonthlyDataUsage($username="", $month="", $year="") {
//        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysqli_real_escape_string($this->db, $username); // mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad "; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $total = bytes($row->TOTAL, "GiB", '%01.2f');
        }
        
        return $total;
    }
    
    public function getYearlyDataUsage($username="", $nmonth=11) {
        $rac = [];
        
        $ad = "";
        if ($username <> "") :
            $user = mysqli_real_escape_string($this->db, $username); // mysql_escape_string($username);
            $ad = " AND username LIKE '$user'";
        endif;
        
        $qry = "SELECT MONTH(acctstarttime) AS 'MON', MONTHNAME(acctstarttime) AS 'MON_NAME', YEAR(acctstarttime) AS 'YR', 
            SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' 
FROM `radacct` 
WHERE 1=1 $ad 
AND acctstarttime <= NOW() and acctstarttime >= DATE_ADD(NOW(),INTERVAL - $nmonth MONTH)
GROUP BY YEAR(acctstarttime), MONTH(acctstarttime) "; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $total = bytes($row->TOTAL, "GiB", '%01.2f');
            $rac[] = ["mon" => $row->MON, "month" => $row->MON_NAME, "yr" => $row->YR, "total" => $total ];
        }
        
        return $rac;
    }
    
    
    public function loadRadUser($user="", $is_enabled=-1, $is_linked = -1, $is_upcountry=-1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad = " WHERE username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE username $in_not (SELECT RAD_USERNAME FROM tblclients)";
            else
                $ad .= " AND username $in_not (SELECT RAD_USERNAME FROM tblclients)";
        endif;
        if (is_int($is_upcountry) && $is_upcountry > -1){
            if ($ad == "") {
                $ad = " WHERE username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
            } else {
                $ad .= " AND username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
            }
        }
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration 
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->username] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "IS_ENABLED" => $row->enableuser);
        }
        
        return $ret;
    }
    
    
    public function loadUnPaidInvObject($user="") {
        $ret = array();
        
        $ad = ' WHERE PAID_INVOICE IN (0,2) AND DATE(DATEINITITATED)>="2021-09-01" ';
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad .= " AND ted.RAD_USERNAME LIKE '%$user%'";
        endif;
        $planList = $this->loadPlans(-1, 0, 1);
        $planOpt = "<option ></option>";
        foreach($planList as $val):
            $planOpt .= "<option value='{$val['PLAN']}'>{$val['PLAN']}</option>";
        endforeach;
        $qry = "SELECT ted.RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, STATE, EMAIL, TELEPHONE, PACKAGE, INVOICENO, PAID_INVOICE
                FROM tbl_erpdata ted 
                LEFT JOIN tbl_install_invoice tii USING (RAD_USERNAME)
                $ad ORDER BY DATEINITITATED DESC"; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
            $status = "NOT PAID";
            if ($row->PACKAGE == '' || is_null($row->INVOICENO)):
                $edit .= '<form id="gFormEdit_' . $row->RAD_USERNAME . '" action="" method="post" style="display: inline-block; ">';
                $edit .= '<select name="plan" style="color:black;" required>' . $planOpt . '</select>
                        <a href="javascript: submitform(\'gFormEdit_' . $row->RAD_USERNAME . '\', 1)" title="Add Invoice and Process" data-toggle="tooltip">
                        <span><i class="fa fa-plus-circle text-yellow"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->RAD_USERNAME . '" /></a>'; 
                $edit .= "</form>";
                $status = "NO INVOICE";
            else:
                //view form
                if ($row->PAID_INVOICE == 2):
                    $edit .= '<form id="gFormWaive_' . $row->RAD_USERNAME . '" action="" method="post" target="_blank" style="display: inline-block; ">';
                    $edit .= '<a href="javascript: submitform(\'gFormWaive_' . $row->RAD_USERNAME . '\', 3)" title="Waive Incomplete Payment" data-toggle="tooltip">
                            <span><i class="fa fa-money text-green"></i></span>
                            <input type="hidden" name="user" id="user" value="' . $row->RAD_USERNAME . '" /></a>'; 
                    $edit .= "</form>"; 
                    $status = "INCOMPLETE PAYMENT";
                else:
                    $edit .= '<form id="gFormView_' . $row->RAD_USERNAME . '" action="" method="post" target="_blank" style="display: inline-block; ">';
                    $edit .= '<a href="javascript: submitform(\'gFormView_' . $row->RAD_USERNAME . '\', 2)" title="Process Invoice" data-toggle="tooltip">
                            <span><i class="fa fa-credit-card text-green"></i></span>
                            <input type="hidden" name="user" id="user" value="' . $row->RAD_USERNAME . '" /></a>'; 
                    $edit .= "</form>"; 
                endif;
                           
            endif;
            $row->EDIT = $edit;
            $row->STAT = $status;
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    
    public function createNProcessInvManually($user, $plan, $adminUser, $adminEmail) {
//        $qry = "SELECT * FROM tbl_install_invoice WHERE RAD_USERNAME=?";
//        $some_sth = $this->db->select($qry, "s", $user);
//        $rows = $some_sth->num_rows();
//        if ($rows == 0) {
//            $strsql = "SELECT DATA FROM tbl_erpinvoice_data WHERE DATAORIGIN='ERP_ACCINIT' AND DATA LIKE '%\"username\":\"$user\"%' 
//                     ORDER BY DATESENT DESC LIMIT 1";
//            $some_sth = $this->db->select($strsql);
//        }
        $strsql = "SELECT DATA FROM tbl_erpinvoice_data WHERE DATAORIGIN='ERP_ACCINIT' AND CAST(`DATA` AS CHAR) LIKE '%\"username\":\"$user\"%' 
                ORDER BY DATESENT DESC LIMIT 1";
        $some_sth = $this->db->select($strsql);
        $rows = $some_sth->num_rows();
        if ($rows) {
            $roww = $some_sth->fetch_object();
            $rowData = json_decode($roww->DATA);
            $rowData->tot_amt = (($rowData->tot_amt*1) == 0)? 0.1 : $rowData->tot_amt;
        } else {
            $qry = "SELECT *
                FROM tbl_erpdata ted
                WHERE ted.RAD_USERNAME like ?
                ORDER BY DATEINITITATED DESC"; //echo $qry;
            $some_sth = $this->db->select($qry, "s", $user);
            $row = $some_sth->fetch_object(); 
            // $rowDat = json_decode($row, TRUE); //print_r($rowDat);
            if ($row->PACKAGE == '') { 
                // return ["STATUS"=>0, "MSG"=>"No Package information"];
            }
            $qry1 = "SELECT DATA FROM tbl_erpinvoice_data WHERE DATAORIGIN='ERP_USER' AND CAST(`DATA` AS CHAR) LIKE '%\"username\":\"$user\"%' 
                ORDER BY DATESENT DESC LIMIT 1";
            $some_sth = $this->db->select($qry1);
            $rowq = $some_sth->fetch_object(); //print_r($rowq);
        	$rowq = json_decode($rowq->DATA); //print_r($rowq);
            $rowData = ["ip"=>"","city"=>$rowq->city_cust,"item2"=>"Installation","item1_qty"=>"1.0",
               "item1"=>$plan,"company_id"=>$rowq->company_id,
            "pck"=>"","state"=>$rowq->state_ng,"erpid"=>$row->ERPID,"item1_cost"=>"0.1","salesemail"=>$adminEmail,
            "email"=>$row->EMAIL,"username"=>$user,"firstname"=>$row->FIRSTNAME,"lastname"=>$row->LASTNAME,
            "company"=>$row->COMPANY,"phone"=>$row->TELEPHONE,"salesperson"=>$adminUser,
            "item2_cost"=>"0.1","address"=>$row->ADDRESS,"orderdate"=>date("Y-m-d H:i:s"),
            "mobile"=>$row->TELEPHONE,"item2_qty"=>"1.0","tot_amt"=>"0.2","orderno"=>"SO$user","order_erpid"=>"22{$row->ERPID}"];
        	// print_r($rowData);
        } 
        $ret = $this->__curlURL("https://eservice.fob.ng/apy/public/erp/accinit", 1, http_build_query($rowData), 
                    ["Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJpZCI6ImVycHUiLCJlbnRyeSI6InczYnMzcnZpYzMhMjMqIn0.H5l5Kcwx75iKGDut5fgknYx8X3dUPiTp79ykB3NnMyliqzRXEhfuys4uLeSZIC2INwkCMP3O89kuOc1yYd7Hgw"]); 
            
        $nret = json_decode($ret, TRUE);
        if ($nret['STATUS'] == 1) {
            $this->logTrail($this::INFO, "Admin [$adminUser] generated and processed invoice manually", $this::STATUS_PASSED, get_client_ip_env());
            return $this->processInvManually($user, $adminUser);
        } else {
            return $nret;
        }
    }
    
    
    public function processInvManually($user, $adminUser) {
        $qry = "SELECT ted.RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, STATE, EMAIL, TELEPHONE, PACKAGE, INVOICENO,
                ted.ERPID, ORDER_ERPID, INVOICE_TOTAL
                FROM tbl_erpdata ted 
                LEFT JOIN tbl_install_invoice tii USING (RAD_USERNAME)
                WHERE tii.PAID=0 AND ted.RAD_USERNAME=?
                ORDER BY DATEINITITATED DESC"; //echo $qry;
        $some_sth = $this->db->select($qry, "s", $user);
        $rows = $some_sth->num_rows();
        if ($rows > 0) {
            $row = $some_sth->fetch_object();
            $strsql = "SELECT DATA FROM tbl_erpinvoice_data WHERE DATAORIGIN='ERP_ACCINIT' AND CAST(`DATA` AS CHAR) LIKE '%\"username\":\"$user\"%' 
                     ORDER BY DATESENT DESC LIMIT 1"; //echo $srtsql;
            $some_sth = $this->db->select($strsql);
            $roww = $some_sth->fetch_object();
            $rowData = json_decode($roww->DATA); //print_r($rowData);
            $company_id = $rowData->company_id;
            $payArr = [
                "processedby" => $adminUser, "erpid" => $row->ERPID, "company_id" =>$company, 
                "paydate" => date("Y-m-d H:i:s"), "orderno" => $row->INVOICENO,
                "paid_amt" => ($row->INVOICE_TOTAL <= 0)? 0.1 : $row->INVOICE_TOTAL,
                "order_erpid" => $row->ORDER_ERPID, "tellerno" => "TRF-ManualProcess-$adminUser"
            ]; //print_r(json_encode($payArr)); // $company_id
            $ret = $this->__curlURL("https://eservice.fob.ng/apy/public/erp/maninvpay", 1, http_build_query($payArr), 
                    ["Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJpZCI6ImVycHUiLCJlbnRyeSI6InczYnMzcnZpYzMhMjMqIn0.H5l5Kcwx75iKGDut5fgknYx8X3dUPiTp79ykB3NnMyliqzRXEhfuys4uLeSZIC2INwkCMP3O89kuOc1yYd7Hgw"]); 
            
            $this->logTrail($this::INFO, "Admin [$adminUser] processed invoice manually", $this::STATUS_PASSED, get_client_ip_env());
            return json_decode($ret, TRUE);
            
        } else {
            return ["STATUS"=>0, "MSG"=>"Transaction already processed."];
        }
    }
    
    
    public function processIncompleteInvPay($user, $adminUser) {
        $qry = "SELECT ted.RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, STATE, EMAIL, TELEPHONE, PACKAGE, INVOICENO,
                ted.ERPID, ORDER_ERPID, INVOICE_TOTAL
                FROM tbl_erpdata ted 
                LEFT JOIN tbl_install_invoice tii USING (RAD_USERNAME)
                WHERE tii.PAID=2 AND ted.RAD_USERNAME=?
                ORDER BY DATEINITITATED DESC"; //echo $qry;
        $some_sth = $this->db->select($qry, "s", $user);
        $rows = $some_sth->num_rows();
        if ($rows > 0) {
            $row = $some_sth->fetch_object();
            $all_query_ok= true;
            $this->db->autocommit(FALSE);
            $upd = "UPDATE tbl_erpdata SET `PAID_INVOICE` = 1 WHERE `INVOICENO` = ?";
            $rett = $this->db->execute_query($upd, "s", $row->INVOICENO);
            $all_query_ok = ($rett)? true : false;

            $upd2 = "UPDATE tbl_install_invoice SET `PAID` = 1 WHERE `ORDERNO` = ?";
            $rett2 = $this->db->execute_query($upd2, "s", $row->INVOICENO);
            $all_query_ok = ($rett2)? true : false;

            $all_query_ok ? $this->db->commit() : $this->db->rollback();

            $this->db->autocommit(TRUE);

            if ($all_query_ok):
                $this->logTrail($this::INFO, "Admin [$adminUser] processed incomplete invoice payment manually", $this::STATUS_PASSED, get_client_ip_env());
                return ["STATUS"=>1, "MSG"=>"Transaction processed."];
            else: 
                return ["STATUS"=>0, "MSG"=>"Transaction failed to update."];
            endif;
            
        } else {
            return ["STATUS"=>0, "MSG"=>"Transaction with incomplete payment not found."];
        }
    }
    
    
    public function loadNurUserObject($user="", $is_enabled=-1, $is_linked = -1, $daysBack=30) {
        $ret = array();
        
        $ad = " WHERE DATE_ACTIVATED IS NOT NULL AND DATE_SUB(DATE(NOW()), INTERVAL $daysBack DAY) <= DATE(DATE_ACTIVATED) ";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad .= " AND ru.username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            $ad .= " AND ru.enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (ru.username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (ru.username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        $qry = "SELECT ru.username, enableuser, ru.firstname, ru.lastname, ru.mobile, ru.email, ru.staticipcpe, 
                    ru.srvid, rs.srvname, ru.expiration, ru.company, createdon, lastlogoff, ru.address, ru.city, ru.state,
                    uplimit, downlimit, comblimit
                FROM tbl_erpdata ted 
                LEFT JOIN tbl_install_invoice tii USING (RAD_USERNAME)
                LEFT JOIN `rm_users` ru ON ted.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry; exit();
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    
    public function loadRadUserObject($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad = " WHERE username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                         AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
            else
                $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                         AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, company, createdon, lastlogoff, address, city, state,
                    uplimit, downlimit, comblimit
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    
    public function loadRadUserObjectV2($user="", $is_enabled=-1, $is_linked = -1, $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len=50) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad .= " AND username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR username LIKE '%$searchval%' OR rs.srvname = '$searchval') ";
        endif;
        $tqry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, company, createdon, lastlogoff, address, city, state,
                    uplimit, downlimit, comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS 'DOWN',
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ru.username) AS 'COMB', limitcomb
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid ";
        $mqry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, company, createdon, lastlogoff, address, city, state,
                    uplimit, downlimit, comblimit
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid "; //echo $qry;
        $some_st = $this->db->select($mqry);
        $this->totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad";
        $some_s = $this->db->select($fqry);
        $this->totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }


	public function getUserStat($user="", $is_enabled=-1, $is_linked = -1, 
            $expstart='', $expend='', $expiring=-1, $expired=-1, $area=0, $region=0, $olt=0, $gpon=0, $is_active=-1, $plan=0) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad .= " AND username LIKE '%$user%'";
        endif;
        if (( $is_enabled != 0) ) :
    		$ad .= " AND tmp.enableuser = 1";
    	else:
            $ad .= " AND tmp.enableuser = $is_enabled";
        endif;
        if ($is_active <> -1 && ($is_active == 1 || $is_active == 0) ) :
            
            if ($is_active == 0):
            $ad .= " AND
            			(IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
                        ";
    		else:
    			$ad .= " AND
            			(limitdl = 0 OR IF (limitdl =1, downlimit -
          		      (SELECT COALESCE(SUM(acctoutputoctets), 0)
             		      FROM radacct WHERE radacct.username = tmp.username) -
             		      (SELECT COALESCE(SUM(dlbytes), 0) 
             		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
             		      AND
             		      (limitul = 0 OR IF (limitul =1, uplimit -
             		      (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) -
                              (SELECT COALESCE(SUM(ulbytes ), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limitcomb = 0 OR IF (limitcomb =1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limituptime = 0 OR IF (limituptime=1, uptimelimit -
                              (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)";
    		endif;
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(expiration) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(expiration) <= '$expend' ) ";
        endif; 
        $ad .= (is_numeric($expired) && ($expired > -1) )? " AND ( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR
                ( (IF (limitcomb = 1, comblimit -
                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) +
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -$expired AND 0 ) " : "";
        $ad .= (is_numeric($expiring) && ($expiring > -1) )? " AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $expiring" : "";
        $ad .= (is_numeric($area) && ($area > 0) )? " AND AREA_ID=$area" : "";
        $ad .= (is_numeric($region) && ($region > 0) )? " AND REGION_ID=$region" : "";
        $ad .= (is_numeric($olt) && ($olt > 0) )? " AND OLT_ID=$olt" : "";
        $ad .= (is_numeric($gpon) && ($gpon > 0) )? " AND GPON_ID=$gpon" : "";
        $ad .= (is_numeric($plan) && ($plan > 0) )? " AND PLAN_ID=$plan" : "";
        
        $tqry = "SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, expiration, uptimelimit, credits, comment,
  	    enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,  lastlogoff /*LEFT(lastlogoff, 10) AS 'lastlogoff'*/
  	    , IF (limitdl = 1, downlimit - COALESCE((SELECT SUM(acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'DOWN',

                IF (limitul = 1, uplimit - COALESCE((SELECT SUM(acctinputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UP',

                IF (limitcomb =1, comblimit - COALESCE((SELECT SUM(acctinputoctets + acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'BALANCE',

                IF (limituptime = 1, uptimelimit - COALESCE((SELECT SUM(acctsessiontime) FROM radacct
                WHERE radacct.username = tmp.username) - 
                (SELECT COALESCE(SUM(acctsessiontime), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UPTIME',

                 AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
                          
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
		INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              WHERE username NOT IN (SELECT USERNAME FROM tbl_comp_account)
            ) AS tmp 
                 ";
        

        $fqry = "$tqry WHERE 1 AND (tmp.acctype = '0' OR tmp.acctype = '1' OR tmp.acctype = '3' OR tmp.acctype = '4' ) $ad";  // "$mqry WHERE 1 $ad"; 
        $some_s = $this->db->select($fqry);
        // new
        $this->totalRecordwithFilter = $some_s->num_rows();
        
        
        return $this->totalRecordwithFilter;
    }
    


    public function loadRadUserActivation($user="", $is_enabled=-1, $is_linked = -1, $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=50, $actstart='', $actend='', $expiring=-1, $activatedDaysAgo=-1, $area=0, $region=0, $olt=0, $gpon=0, $is_active=-1, $plan=0) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad .= " AND username LIKE '%$user%'";
        endif;
        // if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
        if (( $is_enabled != 0) ) :
    		$ad .= " AND tmp.enableuser = 1";
    	else:
            $ad .= " AND tmp.enableuser = $is_enabled";
        endif;
        if ($is_active <> -1 && ($is_active == 1 || $is_active == 0) ) :
            //$ad .= ($is_active == 0)? " AND expiration < NOW()" : " AND expiration >= NOW()";
            // $actsign = ($is_active == 0)? " <= " : " > ";
    		if ($is_active == 0):
            $ad .= " AND
            			(IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
                        ";
    		else:
    			$ad .= " AND
            			(limitdl = 0 OR IF (limitdl =1, downlimit -
          		      (SELECT COALESCE(SUM(acctoutputoctets), 0)
             		      FROM radacct WHERE radacct.username = tmp.username) -
             		      (SELECT COALESCE(SUM(dlbytes), 0) 
             		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
             		      AND
             		      (limitul = 0 OR IF (limitul =1, uplimit -
             		      (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) -
                              (SELECT COALESCE(SUM(ulbytes ), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limitcomb = 0 OR IF (limitcomb =1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limituptime = 0 OR IF (limituptime=1, uptimelimit -
                              (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)";
    		endif;
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR username LIKE '%$searchval%' OR PLAN_NAME = '$searchval') ";
        endif;
        if ($actstart <> "") :
            $actstart = mysqli_real_escape_string($this->db, $actstart);
            $ad .= " AND ( DATE(DATE_ACTIVATED) >= '$actstart' ) ";
        endif;
        if ($actend <> "") :
            $actend = mysqli_real_escape_string($this->db, $actend);
            $ad .= " AND ( DATE(DATE_ACTIVATED) <= '$actend' ) ";
        endif; 
        $ad .= (is_numeric($activatedDaysAgo) && ($activatedDaysAgo > -1) )? " "
                . " AND DATE_SUB(DATE(NOW()), INTERVAL $activatedDaysAgo DAY) <= DATE(DATE_ACTIVATED) " : "";
       $ad .= (is_numeric($expiring) && ($expiring > -1) )? " AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $expiring" : "";
        $ad .= (is_numeric($area) && ($area > 0) )? " AND AREA_ID=$area" : "";
        $ad .= (is_numeric($region) && ($region > 0) )? " AND REGION_ID=$region" : "";
        $ad .= (is_numeric($olt) && ($olt > 0) )? " AND OLT_ID=$olt" : "";
        $ad .= (is_numeric($gpon) && ($gpon > 0) )? " AND GPON_ID=$gpon" : "";
        $ad .= (is_numeric($plan) && ($plan > 0) )? " AND PLAN_ID=$plan" : "";
        
        $tqry = "SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, expiration, uptimelimit, credits, comment,
  	    enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,  lastlogoff /*LEFT(lastlogoff, 10) AS 'lastlogoff'*/
  	    , IF (limitdl = 1, downlimit - COALESCE((SELECT SUM(acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'DOWN',

                IF (limitul = 1, uplimit - COALESCE((SELECT SUM(acctinputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UP',

                IF (limitcomb =1, comblimit - COALESCE((SELECT SUM(acctinputoctets + acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'BALANCE',

                IF (limituptime = 1, uptimelimit - COALESCE((SELECT SUM(acctsessiontime) FROM radacct
                WHERE radacct.username = tmp.username) - 
                (SELECT COALESCE(SUM(acctsessiontime), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UPTIME',

                 AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, DATE_ACTIVATED
                          
            FROM 
            (
              SELECT username, ru.firstname, ru.lastname, ru.address, ru.city, zip, ru.country, ru.state, ru.phone, ru.mobile, ru.email, ru.company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
		INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID, DATE_ACTIVATED
              FROM tbl_erpdata ted
              LEFT JOIN tbl_user_extend ru ON ru.username=ted.RAD_USERNAME
              LEFT JOIN tbl_install_invoice tii ON ted.RAD_USERNAME=tii.RAD_USERNAME AND INVOICENO=ORDERNO
              JOIN rm_services  rs USING (srvid)
              WHERE username NOT IN (SELECT USERNAME FROM tbl_comp_account) AND DATE_ACTIVATED IS NOT NULL
            ) AS tmp 
                 ";
        
        $mqry1 = "SELECT COUNT(RAD_USERNAME) AS 'TOTAL' FROM tbl_install_invoice WHERE DATE_ACTIVATED IS NOT NULL ";
        $loc = [];
        $olt = [];
        $some_st = $this->db->select($mqry1); // $mqry);
    	// new
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; // $some_st->num_rows();
        if ($ad==""):
    		$this->totalRecordwithFilter = $this->totalRecords;
    	else:
        	$fqry = "$tqry WHERE 1 AND (acctype = '0' OR acctype = '1' OR acctype = '3' OR acctype = '4' ) $ad";  // "$mqry WHERE 1 $ad"; 
    		// echo ($is_active == 1 || $is_active == 0)? $fqry : "u";
        	$some_s = $this->db->select($fqry);
    		// new
    		// $rec = $some_s->fetch_object();
        	$this->totalRecordwithFilter = $some_s->num_rows(); // $rec->TOTAL; // $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1 AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' ) $ad $msort $limit";
    	// echo ($is_active == 1 || $is_active == 0)? $qry : "v";
        $some_sth = $this->db->select($qry);
        
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
            /*
            if ($_SESSION[$this->sid.'usertype_id'] == 4 || $_SESSION[$this->sid.'usertype_id'] == 7):
                $edit .= '<form id="gFormDel_' . $row->username . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->username . '" href="javascript:void(0)" class="gFormDel" title="Delete & Archive User ' . $row->username . '" data-toggle="tooltip">
                        <span><i class="fa fa-close text-red"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
                $edit .= "</form>";
            endif;
            if ($_SESSION[$this->sid.'readonly'] == 0):
                $edit .= '<form id="gFormEdit_' . $row->username . '" action="ad_edituserplus" method="post" style="display: inline-block; ">';
                $edit .= '<a href="javascript: submitform(\'gFormEdit_' . $row->username . '\')" title="Edit User ' . $row->username . '" data-toggle="tooltip">
                        <span><i class="fa fa-edit text-yellow"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
                $edit .= "</form>";
            endif;
            //view form
            $edit .= '<form id="gFormView_' . $row->username . '" action="userusage" method="post" target="_blank" style="display: inline-block; ">';
            $edit .= '<a href="javascript: submitform(\'gFormView_' . $row->username . '\')" title="View User ' . $row->username . ' Info" data-toggle="tooltip">
                    <span><i class="fa fa-eye text-green"></i></span>
                    <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
            $edit .= "</form>";
            */
            $bal = "-";
            if ($row->limitcomb):
                $bal = formatBytes( ($row->BALANCE), 2);
            endif;
            $curDate = date('Y-m-d H:i:s');
            $daysLeft = (strtotime($curDate) - strtotime($row->expiration));
            $ret[] = array("EDIT"=>$edit, "USERNAME"=>$row->username, "SERVICE"=>$row->srvname, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=>$row->lastname, "COMPANY"=>$row->company, "ADDRESS"=>$row->address, "CITY"=>$row->city, "STATE"=>$row->state, "BALANCE"=>$bal,
                        "DATE_ACTIVATED"=>date( 'd-m-Y', strtotime($row->DATE_ACTIVATED)), "EXPIRATION"=>date( 'd-m-Y', strtotime($row->expiration)),
                         "IP"=>$row->staticipcpe, "EMAIL"=>$row->email,
                        "PHONE"=>$row->mobile, "REGDATE"=>date( 'd-m-Y', strtotime($row->createdon)), "LASTLOGOFF"=>date( 'd-m-Y H:i:s', strtotime($row->lastlogoff)),
                        "AREA"=>$row->AREA_NAME, "REGION"=>$row->REGION_NAME, "OLT"=>$row->OLT_NAME, 
                     	"GPON"=>$row->GPON_NAME, "INTERFACE"=>$row->INTERFACE, "SERIALNO"=>$row->SERIALNO, "VLAN"=>$row->VLAN, 
                        "STAT"=>($row->enableuser)? (($daysLeft < 0)? "Active" : "Expired"): "Disabled" );
//            $ret[] = $row; //"LASTLOGOFF"=>$row->lastlogoff, 
        }
        
        return $ret;
    }
    
    
    public function loadRadUserObjectV4($user="", $is_enabled=-1, $is_linked = -1, $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=50, $expstart='', $expend='', $expiring=-1, $expired=-1, $area=0, $region=0, $olt=0, $gpon=0, $is_active=-1, $plan=0) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad .= " AND username LIKE '%$user%'";
        endif;
        // if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
        if (( $is_enabled != 0) ) :
    		$ad .= " AND tmp.enableuser = 1";
    	else:
            $ad .= " AND tmp.enableuser = $is_enabled";
        endif;
        if ($is_active <> -1 && ($is_active == 1 || $is_active == 0) ) :
            //$ad .= ($is_active == 0)? " AND expiration < NOW()" : " AND expiration >= NOW()";
            // $actsign = ($is_active == 0)? " <= " : " > ";
    		if ($is_active == 0):
            $ad .= " AND
            			(IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
                        ";
    		else:
    			$ad .= " AND
            			(limitdl = 0 OR IF (limitdl =1, downlimit -
          		      (SELECT COALESCE(SUM(acctoutputoctets), 0)
             		      FROM radacct WHERE radacct.username = tmp.username) -
             		      (SELECT COALESCE(SUM(dlbytes), 0) 
             		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
             		      AND
             		      (limitul = 0 OR IF (limitul =1, uplimit -
             		      (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) -
                              (SELECT COALESCE(SUM(ulbytes ), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limitcomb = 0 OR IF (limitcomb =1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limituptime = 0 OR IF (limituptime=1, uptimelimit -
                              (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                              AND
                              (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)";
    		endif;
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR username LIKE '%$searchval%' OR PLAN_NAME = '$searchval') ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(expiration) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(expiration) <= '$expend' ) ";
        endif; 
        $ad .= (is_numeric($expired) && ($expired > -1) )? " AND ( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR
                ( (IF (limitcomb = 1, comblimit -
                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) +
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -$expired AND 0 ) " : "";
        $ad .= (is_numeric($expiring) && ($expiring > -1) )? " AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $expiring" : "";
        $ad .= (is_numeric($area) && ($area > 0) )? " AND AREA_ID=$area" : "";
        $ad .= (is_numeric($region) && ($region > 0) )? " AND REGION_ID=$region" : "";
        $ad .= (is_numeric($olt) && ($olt > 0) )? " AND OLT_ID=$olt" : "";
        $ad .= (is_numeric($gpon) && ($gpon > 0) )? " AND GPON_ID=$gpon" : "";
        $ad .= (is_numeric($plan) && ($plan > 0) )? " AND PLAN_ID=$plan" : "";
        
        $tqry = "SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, expiration, uptimelimit, credits, comment,
  	    enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,  lastlogoff /*LEFT(lastlogoff, 10) AS 'lastlogoff'*/
  	    , IF (limitdl = 1, downlimit - COALESCE((SELECT SUM(acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'DOWN',

                IF (limitul = 1, uplimit - COALESCE((SELECT SUM(acctinputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UP',

                IF (limitcomb =1, comblimit - COALESCE((SELECT SUM(acctinputoctets + acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'BALANCE',

                IF (limituptime = 1, uptimelimit - COALESCE((SELECT SUM(acctsessiontime) FROM radacct
                WHERE radacct.username = tmp.username) - 
                (SELECT COALESCE(SUM(acctsessiontime), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UPTIME',

                 AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
                          
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
		INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              WHERE username NOT IN (SELECT USERNAME FROM tbl_comp_account)
            ) AS tmp 
                 ";
        
        $mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_user_extend ";
        $loc = [];
        $olt = [];
        $some_st = $this->db->select($mqry1); // $mqry);
    	// new
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; // $some_st->num_rows();
        if ($ad==""):
    		$this->totalRecordwithFilter = $this->totalRecords;
    	else:
        	$fqry = "$tqry WHERE 1 AND (acctype = '0' OR acctype = '1' OR acctype = '3' OR acctype = '4' ) $ad";  // "$mqry WHERE 1 $ad"; 
    		// echo ($is_active == 1 || $is_active == 0)? $fqry : "u";
        	$some_s = $this->db->select($fqry);
    		// new
    		// $rec = $some_s->fetch_object();
        	$this->totalRecordwithFilter = $some_s->num_rows(); // $rec->TOTAL; // $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1 AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' ) $ad $msort $limit";
    	// echo ($is_active == 1 || $is_active == 0)? $qry : "v";
        $some_sth = $this->db->select($qry);
        
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
            if ($_SESSION[$this->sid.'usertype_id'] == 4 || $_SESSION[$this->sid.'usertype_id'] == 7):
                $edit .= '<form id="gFormDel_' . $row->username . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->username . '" href="javascript:void(0)" class="gFormDel" title="Delete & Archive User ' . $row->username . '" data-toggle="tooltip">
                        <span><i class="fa fa-close text-red"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
                $edit .= "</form>";
            endif;
            if ($_SESSION[$this->sid.'readonly'] == 0):
                $edit .= '<form id="gFormEdit_' . $row->username . '" action="ad_edituserplus" method="post" style="display: inline-block; ">';
                $edit .= '<a href="javascript: submitform(\'gFormEdit_' . $row->username . '\')" title="Edit User ' . $row->username . '" data-toggle="tooltip">
                        <span><i class="fa fa-edit text-yellow"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
                $edit .= "</form>";
            endif;
            //view form
            $edit .= '<form id="gFormView_' . $row->username . '" action="userusage" method="post" target="_blank" style="display: inline-block; ">';
            $edit .= '<a href="javascript: submitform(\'gFormView_' . $row->username . '\')" title="View User ' . $row->username . ' Info" data-toggle="tooltip">
                    <span><i class="fa fa-eye text-green"></i></span>
                    <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
            $edit .= "</form>";
            $bal = "-";
            if ($row->limitcomb):
                $bal = formatBytes( ($row->BALANCE), 2);
            endif;
            $curDate = date('Y-m-d H:i:s');
            $daysLeft = (strtotime($curDate) - strtotime($row->expiration));
            $ret[] = array("EDIT"=>$edit, "USERNAME"=>$row->username, "SERVICE"=>$row->srvname, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=>$row->lastname, "COMPANY"=>$row->company, "ADDRESS"=>$row->address, "CITY"=>$row->city, "STATE"=>$row->state, "BALANCE"=>$bal,
                        "EXPIRATION"=>date( 'd-m-Y', strtotime($row->expiration)),
                         "IP"=>$row->staticipcpe, "EMAIL"=>$row->email,
                        "PHONE"=>$row->mobile, "REGDATE"=>date( 'd-m-Y', strtotime($row->createdon)), "LASTLOGOFF"=>date( 'd-m-Y H:i:s', strtotime($row->lastlogoff)),
                        "AREA"=>$row->AREA_NAME, "REGION"=>$row->REGION_NAME, "OLT"=>$row->OLT_NAME, 
                     	"GPON"=>$row->GPON_NAME, "INTERFACE"=>$row->INTERFACE, "SERIALNO"=>$row->SERIALNO, "VLAN"=>$row->VLAN, 
                        "STAT"=>($row->enableuser)? (($daysLeft < 0)? "Active" : "Expired"): "Disabled" );
//            $ret[] = $row; //"LASTLOGOFF"=>$row->lastlogoff, 
        }
        
        return $ret;
    }
    
    
    public function loadRadUserObjectV3($user="", $is_enabled=-1, $is_linked = -1, $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=50, $expstart='', $expend='', $expiring=-1, $expired=-1, $area=0, $region=0, $olt=0, $gpon=0, $is_active=-1, $plan=0) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad .= " AND username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_active <> -1 && ($is_active == 1 || $is_active == 0) ) :
            $ad .= ($is_active == 0)? " AND expiration < NOW()" : " AND expiration >= NOW()";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR username LIKE '%$searchval%' OR PLAN_NAME = '$searchval') ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(expiration) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(expiration) <= '$expend' ) ";
        endif;        
        $ad .= (is_numeric($expired) && ($expired > -1) )? " AND DATEDIFF(NOW(), expiration) BETWEEN 0 AND $expired" : "";
        $ad .= (is_numeric($expiring) && ($expiring > -1) )? " AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $expiring" : "";
        $ad .= (is_numeric($area) && ($area > 0) )? " AND AREA_ID=$area" : "";
        $ad .= (is_numeric($region) && ($region > 0) )? " AND REGION_ID=$region" : "";
        $ad .= (is_numeric($olt) && ($olt > 0) )? " AND OLT_ID=$olt" : "";
        $ad .= (is_numeric($gpon) && ($gpon > 0) )? " AND GPON_ID=$gpon" : "";
        $ad .= (is_numeric($plan) && ($plan > 0) )? " AND PLAN_ID=$plan" : "";
        
        $tqry = "SELECT ru.username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, PLAN_NAME AS srvname, expiration, company, createdon, lastlogoff, address, city, state,
                    uplimit, downlimit, comblimit, /*((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS 'DOWN',
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ru.username) AS 'COMB',*/ limitcomb, 
				AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
                FROM `tbl_user_extend` ru
                 ";
							// $mqry = "SELECT ru.username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
							// ru.srvid, PLAN_NAME AS srvname, expiration, company, createdon, lastlogoff, address, city, state,
							// uplimit, downlimit, comblimit, 
							// AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
							// FROM `tbl_user_extend` ru  "; //echo $qry;
    	$mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_user_extend ";
				// $locq = "SELECT ID, USERNAME, ul.AREA, ta.AREA_ID, AREA_NAME, REGION, REGION_ID, REGION_NAME FROM tbl_usrloc ul
				// LEFT JOIN tbl_areas ta ON ul.AREA=ta.AREA_ID
				// LEFT JOIN tbl_regions tr ON ul.REGION=tr.REGION_ID";
				// $sst = $this->db->select($locq);
    	$loc = [];
    	// while ( $row = $sst->fetch_assoc() ) {
    	// $loc[$row["USERNAME"]] = [ "AREA_NAME"=>$row['AREA_NAME'], 'REGION_NAME'=>$row['REGION_NAME'] ];
    	// }
    	// $oltq = "SELECT ID, USERNAME, ul.OLT, ta.OLT_ID, OLT_NAME, GPON, GPON_ID, GPON_NAME FROM tbl_usrolt ul
    	// LEFT JOIN tbl_olt ta ON ul.OLT=ta.OLT_ID
    	// LEFT JOIN tbl_gpon tr ON ul.GPON=tr.GPON_ID";
    	// $sst = $this->db->select($oltq);
    	$olt = [];
    	// while ( $row = $sst->fetch_assoc() ) {
    	// $olt[$row["USERNAME"]] = [ "OLT_NAME"=>$row['OLT_NAME'], 'GPON_NAME'=>$row['GPON_NAME'] ];
    	// }
    	
        $some_st = $this->db->select($mqry1); // $mqry);
    	// new
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; // $some_st->num_rows();
        if ($ad==""):
    		$this->totalRecordwithFilter = $this->totalRecords;
    	else:
        	$fqry = "$mqry1 WHERE 1 $ad";  // "$mqry WHERE 1 $ad"; 
        	$some_s = $this->db->select($fqry);
    		// new
    		$rec = $some_s->fetch_object();
        	$this->totalRecordwithFilter = $rec->TOTAL; // $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return [$ret, $loc, $olt];
    }
    
    
    public function radUserIsLinked($username) {
//        $isLinked = 0;
        
        //User Exist?
        $qry = "SELECT * FROM `rm_users` WHERE username LIKE ?";
        $some_sth = $this->db->select($qry, "s", $username);
        $rows = $some_sth->num_rows();
        
        if ($rows) :
            //Is Linked?
            $qry = "SELECT USERNAME FROM tblclients WHERE RAD_USERNAME LIKE ? 
                    UNION
                    SELECT tc.USERNAME FROM tbl_subaccount sa 
                    LEFT JOIN tblclients tc ON sa.CID=tc.ID WHERE sa.RAD_USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, "s", $username);
            $rows = $some_sth->num_rows();
            if ($rows) :
                $row = $some_sth->fetch_object();
                return "Success: [$username] already linked to " . $row->USERNAME;
            else: 
                return "Error: Username [$username] is yet to be linked";
            endif;
        else:
            return "Error: Username [$username] does not exist on the Radius Server";
        endif;
    }
    
    public function safeToDelete($username) {
//        $isLinked = 0;
        
        //User Exist?
        $qry = "SELECT * FROM `rm_users` WHERE username LIKE ?";
        $some_sth = $this->db->select($qry, "s", $username);
        $rows = $some_sth->num_rows();
        
        if ($rows) :
            
        else:
            
        endif;
    
    }
    
    
    public function loadAdminRec($user="", $is_enabled=-1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad = " WHERE tad.USERNAME LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tad.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tad.IS_ENABLED = $is_enabled";
        endif;
        if ($ad == ""):
            $ad = " WHERE ( (tad.USERNAME NOT LIKE 'opmat') AND (tad.USERNAME NOT LIKE 'akoshodi') )";
        else:
            $ad .= " AND ( (tad.USERNAME NOT LIKE 'opmat') AND (tad.USERNAME NOT LIKE 'akoshodi') )";
        endif;
        $qry = "SELECT tad.AID, tad.USERNAME, tad.FULLNAME, tad.MOBILE, tad.EMAIL, tad.ACCESS_LEVEL, 
                    tal.ADMIN_TYPE, tad1.FULLNAME AS 'ADDED_BY', tad.IS_ENABLED, tad.`READONLY` 
                FROM `tbl_admins` tad
                LEFT JOIN tbl_admin_level tal ON tad.ACCESS_LEVEL = tal.ID
                LEFT JOIN tbl_admins tad1 ON tad.ADDED_BY = tad1.AID $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->FULLNAME, 
                        "LASTNAME"=> "", "RAD_USERNAME"=>"",
                        "MOBILE"=> $row->MOBILE, "EMAIL"=> $row->EMAIL,
                        "ADMIN_TYPE"=> $row->ADMIN_TYPE, "ACCESS_LEVEL"=>$row->ACCESS_LEVEL,
                        "ENABLED" => $row->IS_ENABLED, "UID" => $row->AID, "READONLY" => $row->READONLY);
        }
        
        return $ret;
    }
    
    
    public function loadClientRec($user="", $is_enabled=-1, $days_to_expiration=-1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad = " WHERE tc.USERNAME LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tc.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tc.IS_ENABLED = $is_enabled";
        endif;
        $qry = "SELECT tc.ID, tc.USERNAME, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname 
                FROM tblclients tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);
        }
        
        return $ret;
    }
    
    public function loadClientRec2($expstart = '', $expend = '', $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len=50, $readonly=0, $expiring=-1, $expired=-1) {
        $ret = $response = array();
        $sn = 0; $tt = $act = "";
        
        $ad = "";
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (CONCAT(firstname, ' ', lastname) LIKE '%$searchval%' OR tc.USERNAME LIKE '%$searchval%' OR srvname = '$searchval') ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(expiration) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(expiration) <= '$expend' ) ";
        endif;        
        $ad .= (is_numeric($expired) && ($expired > -1) )? " AND DATEDIFF(NOW(), expiration) BETWEEN 0 AND $expired" : "";
        $ad .= (is_numeric($expiring) && ($expiring > -1) )? " AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $expiring" : "";
    
    	$eqry = "SET @count = 0;"; $this->db->execute_query($eqry);
        $mqry = "SELECT (@count:=@count+1) AS 'SN', ID, tc.USERNAME, RAD_USERNAME, CONCAT(firstname, ' ', lastname) AS 'FULLNAME', mobile, 
                    email, staticipcpe, expiration, IS_ENABLED, enableuser, rs.srvid, srvname 
                FROM tblclients tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid";
        $some_st = $this->db->select($mqry);
        $totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad";
        $some_s = $this->db->select($fqry);
        $totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $qry = "$mqry WHERE 1 $ad ORDER BY $sortby $sortorder $limit"; //$myfile = fopen("/home/kkontech/pubv2/reportfiles/_mqry.txt", "w+");fwrite($myfile, $qry.PHP_EOL);fwrite($myfile, "UYT: $expired|$expiring|".is_numeric($expired)."|".PHP_EOL);fclose($myfile);file_put_contents("/home/kkontech/pubv2/reportfiles/_mqry.txt", $qry.PHP_EOL , FILE_APPEND | LOCK_EX);
        $some_sth = $this->db->select($qry);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $user = $srv = $exp = $tt = $act = "";
            $sublist = $this->loadSubAccount($row->ID);
            if (count($sublist)) {
                foreach ($sublist[$row->USERNAME] as $kd => $vd) {
                    $user .= "<br />\r\n<span style='color:red'>".$vd['RAD_USERNAME']."</span>";
                    $srv .= "<br />\r\n<span style='color:red'>".$vd['SERVICE']."</span>";
                    $exp .= "<br />\r\n<span style='color:red'>".date( 'd-m-Y H:i:s', strtotime($vd['EXPIRATION']))."</span>";
                }
            }
            if (isset($row->IS_ENABLED)){
                if ($row->IS_ENABLED == 1) {
                    $tt = "<span class='label-default label label-success'>ENABLED</span>";
                } else {
                    $tt = "<span class='label-default label label-danger'>DISABLED</span>";
                }
            }
            if ((isset($row->IS_ENABLED)) && ($row->IS_ENABLED==1) && ( $readonly == 0)): 
                $act .= '<form id="gFormAdd' . $row->ID . '" action="ad_subacc.php" target="_blank" method="post" style="display: inline-block; padding-right: 6px;">';
                $act .= '<a href="javascript: submitform(\'gFormAdd' . $row->ID . '\')" title="Add more Service ID as Sub-Account.." data-toggle="tooltip">
                        <span><i class="glyphicon glyphicon-plus-sign green"></i></span>
                      </a><input type="hidden" name="uid" id="uid" value="' . $row->ID . '" />
                        <input type="hidden" name="user" id="user" value="' . $row->USERNAME . '" />'; 
                $act .= "</form>";                        
            endif; 

            $act .= '<form id="gFormView' . $row->ID . '" action="#" target="_blank" method="post" style="display: inline-block; padding-right: 6px;">';
            $act .= '<a href="#" class="loadSubA" id="loadSubA' . $row->ID . '" title="View Sub-Accounts" data-toggle="tooltip">
                    <span><i class="glyphicon glyphicon-eye-open orange"></i></span>
                  </a><input type="hidden" name="uid" id="uid" value="' . $row->ID . '" />
                    <input type="hidden" name="user" id="user" value="' . $row->USERNAME . '" />'; 
            $act .= "</form>"; 
            if ( $readonly  == 0):
                $act .= '<form id="gFormEdit' . $row->ID . '" action="ad_edituser" method="post" style="display: inline-block; padding-right: 6px;">';
                $act .= '<a href="javascript: submitform(\'gFormEdit' . $row->ID . '\')" title="Edit User" data-toggle="tooltip">
                        <span><i class="glyphicon glyphicon-pencil yellow"></i></span>
                      </a><input type="hidden" name="uid" id="uid" value="' . $row->ID . '" />
                        <input type="hidden" name="user" id="user" value="' . $row->USERNAME . '" />'; 
                $act .= "</form>";   
            endif;
            
            $ret[] = ["SN"=>++$sn, "USERNAME"=>$row->USERNAME, "RAD_USERNAME"=>$row->RAD_USERNAME . $user, "FULLNAME"=>$row->FULLNAME,
                       "srvname"=>$row->srvname . $srv, "expiration"=>$row->expiration . $exp, 
                       "STAT"=>$tt, "ACTION"=>$act ];
        }
        ## Response
        $response = array(
          "iTotalRecords" => $totalRecords,
          "iTotalDisplayRecords" => $totalRecordwithFilter,
          "aaData" => $ret
        );
        return $response;
    }
    
    
    public function getDailySalesByPlan($mon, $yr, $plan=0) {
        $ret = $rett = $response = array();
        $sn = 0; $tt = $act = "";
        
        $ad = "";
        if ($plan > 0) :
            $ad .= (is_numeric($plan) && ($plan > 0) )? " AND tp.PLAN_ID = $plan" : "";
        endif;   
        $a1=array_fill_keys(range(1,32),0);
        $rett = array_merge(["<strong>TOTAL:</strong>"], $a1);
    
        $qry = "SELECT DAY(PAY_DATE) AS 'DAYY', MONTH(PAY_DATE) AS 'MON', MONTHNAME(PAY_DATE) AS 'MONN', tp.PLAN, COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) >= ? AND YEAR(PAY_DATE) = ? $ad
GROUP BY DAY(PAY_DATE), MONTH(PAY_DATE), tp.PLAN ORDER BY tp.PLAN, DAY(PAY_DATE)";
        $some_sth = $this->db->select($qry, "ii", $mon, $yr);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $tt = $row->MONN;
            if (!isset($ret[$row->PLAN])) {
                $a1=array_fill_keys(range(1,32),0);
                $ret[$row->PLAN] = array_merge([$row->PLAN], $a1);
            }
            $ret[$row->PLAN][$row->DAYY] = $row->NTRANS;
            $ret[$row->PLAN][32] += $row->NTRANS;
            $rett[$row->DAYY] += $row->NTRANS; 
        }        
        $rett[32] = array_sum(array_slice($rett, 1, 31));
        $ret['z'] =$rett;
    	foreach ($ret as $val):
    		$ref[] = $val;
    	endforeach;
        
        ## Response
        $response = array(
          "iTotalRecords" => count($ret),
          "iTotalDisplayRecords" => count($ret),
          "aaData" => $ref,
          "monthname" => $tt
        );
        return $response;
    }
    
    
    public function getDailySalesByArea($mon, $yr, $area=0) {
        $ret = $rett = $response = array();
        $sn = 0; $tt = $act = "";
        
        $ad = "";
        if ($area > 0) :
            $ad .= (is_numeric($area) && ($area > 0) )? " AND r.AREA_ID = $area" : "";
        endif;   
        $a1=array_fill_keys(range(1,32),0);
        $rett = array_merge(["<strong>TOTAL:</strong>"], $a1);
    
        $qry = "SELECT DAY(PAY_DATE) AS 'DAYY', MONTH(PAY_DATE) AS 'MON', MONTHNAME(PAY_DATE) AS 'MONN', 
            CASE WHEN r.AREA_NAME='' THEN 'UNKNOWN' ELSE r.AREA_NAME END AS 'AREA_NAME', COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
LEFT JOIN tbl_user_extend r ON tx.RAD_USERNAME=r.username
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) >= ? AND YEAR(PAY_DATE) = ? $ad
GROUP BY DAY(PAY_DATE), MONTH(PAY_DATE), r.AREA_NAME ORDER BY r.AREA_NAME, DAY(PAY_DATE)";
        $some_sth = $this->db->select($qry, "ii", $mon, $yr);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $tt = $row->MONN;
            if (!isset($ret[$row->AREA_NAME])) {
                $a1=array_fill_keys(range(1,32),0);
                $ret[$row->AREA_NAME] = array_merge([$row->AREA_NAME], $a1);
            }
            $ret[$row->AREA_NAME][$row->DAYY] = $row->NTRANS;
            $ret[$row->AREA_NAME][32] += $row->NTRANS;
            $rett[$row->DAYY] += $row->NTRANS; 
        }          
        $rett[32] = array_sum(array_slice($rett, 1, 31));
        $ret['z'] =$rett;
    	foreach ($ret as $val):
    		$ref[] = $val;
    	endforeach;
        
        ## Response
        $response = array(
          "iTotalRecords" => count($ret),
          "iTotalDisplayRecords" => count($ret),
          "aaData" => $ref,
          "monthname" => $tt
        );
        return $response;
    }
    
    
    public function getDailySalesByOLT($mon, $yr, $olt=0) {
        $ret = $rett = $response = array();
        $sn = 0; $tt = $act = "";
        
        $ad = "";
        if ($olt > 0) :
            $ad .= (is_numeric($olt) && ($olt > 0) )? " AND r.OLT_ID = $olt" : "";
        endif;   
        $a1=array_fill_keys(range(1,32),0);
        $rett = array_merge(["<strong>TOTAL:</strong>"], $a1);
    
        $qry = "SELECT DAY(PAY_DATE) AS 'DAYY', MONTH(PAY_DATE) AS 'MON', MONTHNAME(PAY_DATE) AS 'MONN', 
            CASE WHEN r.OLT_NAME='' THEN 'UNKNOWN' ELSE r.OLT_NAME END AS 'OLT_NAME', COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
LEFT JOIN tbl_user_extend r ON tx.RAD_USERNAME=r.username
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) >= ? AND YEAR(PAY_DATE) = ? $ad
GROUP BY DAY(PAY_DATE), MONTH(PAY_DATE), r.OLT_NAME ORDER BY r.OLT_NAME, DAY(PAY_DATE)";
        $some_sth = $this->db->select($qry, "ii", $mon, $yr);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $tt = $row->MONN;
            if (!isset($ret[$row->OLT_NAME])) {
                $a1=array_fill_keys(range(1,32),0);
                $ret[$row->OLT_NAME] = array_merge([$row->OLT_NAME], $a1);
            }
            $ret[$row->OLT_NAME][$row->DAYY] = $row->NTRANS;
            $ret[$row->OLT_NAME][32] += $row->NTRANS;
            $rett[$row->DAYY] += $row->NTRANS; 
        }        
        $rett[32] = array_sum(array_slice($rett, 1, 31));
        $ret['z'] =$rett;
    	foreach ($ret as $val):
    		$ref[] = $val;
    	endforeach;
        
        ## Response
        $response = array(
          "iTotalRecords" => count($ret),
          "iTotalDisplayRecords" => count($ret),
          "aaData" => $ref,
          "monthname" => $tt
        );
        return $response;
    }
    
    
    public function getDataForInvResend($orderno) {
        $ret = array();
        
        $qry = "SELECT INVID, ORDERNO, ORDER_ERPID, ORDERNO AS TRANX_ID, tii.RAD_USERNAME, DATE(NOW()) AS EXPIRY_DATE, INVOICE_TOTAL, PAID,
                        INVOICE_TOTAL AS REQ_AMOUNT, INVOICEDATE, INVOICEDATE AS REQUEST_DATE, 1 AS NMONTHS, STATUS_CODE, tep.ERPID,
			SALESEMAIL, SALESPERSON, ted.FIRSTNAME, ted.LASTNAME, ted.PACKAGE, ted.EMAIL
               FROM tbl_install_invoice tii 
                 LEFT JOIN tbl_erp tep ON tii.RAD_USERNAME=tep.RAD_USERNAME
                 LEFT JOIN tbl_erpdata ted ON tii.RAD_USERNAME=ted.RAD_USERNAME
                 WHERE ORDERNO LIKE ?";
        $some_sth = $this->db->select($qry, "s", $orderno); 
//        $rows = $some_sth->num_rows(); 
        while ( $row = $some_sth->fetch_object() ) {
            $ret['DAT'] = ["FIRSTNAME"=>$row->FIRSTNAME, "LASTNAME"=>$row->LASTNAME, "INVOICE_TOTAL"=>$row->INVOICE_TOTAL, "EMAIL"=>$row->EMAIL,
                            "PACKAGE"=>$row->PACKAGE, "SALESPERSON"=>$row->SALESPERSON, "SALESEMAIL"=>$row->SALESEMAIL];
            
            $strsql = "SELECT ITEM, QTY, UNIT_PRICE FROM tbl_invoice_metadata tm WHERE INVID= ?";
            $some_st = $this->db->select($strsql, "i", $row->INVID);
            while ( $ro = $some_st->fetch_object() ) {
                $ret['BD'][] = ["ITEM"=> $ro->ITEM, "QTY"=> $ro->QTY, "UNIT_PRICE"=> $ro->UNIT_PRICE];
            }
        }
        
        return $ret;
    }
    
    
    public function loadERPRec($user="", $erpid=0, $is_prov=-1, $act=0, $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=500000, $expstart='', $expend='') {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad = " AND e.RAD_USERNAME LIKE '$user'";
        endif;
        if ($is_prov <> -1 && ($is_prov == 1 || $is_prov == 0) ) :
            $ad .= " AND PROVISIONED = $is_prov";
        endif;
        if ($erpid > 0) :
            $ad .= " AND ERPID = $erpid";
        endif;
        if ($act > 0) :
            $ad .= " AND ONLY_ACTIVATE = $act";
        endif;
        
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (e.RAD_USERNAME LIKE '%$searchval%' OR PACKAGE LIKE '%$searchval%' OR FIRSTNAME LIKE '%$searchval%' OR LASTNAME LIKE '%$searchval%' ) ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(DATEINITITATED) >= '$expstart' ) ";
        else:
             $ad .= " AND DATEINITITATED >= '2020-09-01'";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(DATEINITITATED) <= '$expend' ) ";
        endif;   
        
        $mqry = "SELECT COUNT(e.RAD_USERNAME) AS 'TOTAL' FROM `tbl_erpdata` e
                LEFT JOIN rm_services s ON e.PACKAGE=s.srvname
                LEFT JOIN tbl_install_invoice tii ON e.INVOICENO = tii.ORDERNO ";
        $some_st = $this->db->select($mqry);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; 
        if ($ad==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$mqry WHERE 1 $ad";  //echo $fqry." ;;;;;;";
            $some_s = $this->db->select($fqry);
            $rec = $some_s->fetch_object();
            $this->totalRecordwithFilter = $rec->TOTAL; 
    	endif;
        
        $qry = "SELECT ID, ERPID, e.RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS, 
                CITY, STATE, EMAIL, TELEPHONE, PACKAGE, srvid, `PASSWORD`, IPADDY, DATEINITITATED, 
                PROVISIONED, DATEPROVISIONED, ONLY_ACTIVATE, INVOICENO, tii.PAID 
                FROM `tbl_erpdata` e
                LEFT JOIN rm_services s ON e.PACKAGE=s.srvname
                LEFT JOIN tbl_install_invoice tii ON e.INVOICENO = tii.ORDERNO ";
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY DATEINITITATED DESC";
        $qry = "$qry WHERE 1 $ad $msort $limit"; //echo "$qry ;;;;;;;;;";
        $some_sth = $this->db->select($qry);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->ERPID] = array("ERPID"=>$row->ERPID, "ID"=>$row->ID, 
                "RAD_USERNAME"=> $row->RAD_USERNAME, "FIRSTNAME"=>$row->FIRSTNAME,
                "LASTNAME"=> $row->LASTNAME, "COMPANY"=> $row->COMPANY,
                "ADDRESS"=> $row->ADDRESS, "CITY"=>$row->CITY, "STATE"=>$row->STATE,
                "EMAIL" => $row->EMAIL, "TELEPHONE" => $row->TELEPHONE, "SRVID" => $row->srvid,
                "PASSWORD" => $row->PASSWORD, "IPADDY" => $row->IPADDY, "PACKAGE" => $row->PACKAGE, 
                "DATEINITITATED" => $row->DATEINITITATED, "PROVISIONED" => $row->PROVISIONED,
                "DATEPROVISIONED" => $row->DATEPROVISIONED, "ONLY_ACTIVATE" => $row->ONLY_ACTIVATE, 
                "INVOICENO" => $row->INVOICENO, "PAID" => $row->PAID);
        }
        
        return $ret;
    }
    
    public function updateERPProvStat($erpid, $raduser) {
        $done = 0;
        
        if ($erpid > 0) {
            $upd = "UPDATE `tbl_erpdata` SET PROVISIONED=1, DATEPROVISIONED=NOW()
                     WHERE ERPID=?";
            $rett = $this->db->execute_query($upd, "i", $erpid);
            if ($rett) { $done = 1; }
            $qry = "SELECT * FROM tbl_erp WHERE ERPID=?";
            $some_sth = $this->db->select($qry, "i", $erpid);
            $rows = $some_sth->num_rows();
            if ($rows <= 0):
                $ins = "INSERT IGNORE INTO tbl_erp (ERPID, RAD_USERNAME)
                        VALUES (?, ?)";
                $this->db->insert($ins, 'is', $erpid, $raduser);
            endif;
        }
        
        return $done;
    }
    
    public function loadInvoiceByID($invno="") {
        $ret = array();
        $ad = "";
        if ( $invno <> "") :
            $invno = mysqli_real_escape_string($this->db, $invno); // mysql_escape_string($invno);
            $ad = " WHERE ORDERNO = '$invno'";
        endif;
        $qry = "SELECT tii.INVID, tii.RAD_USERNAME, ORDERNO, ORDER_ERPID, INVOICE_TOTAL, SALESPERSON, SALESEMAIL,
                    INVOICEDATE, PAID, DATEPAID, PAY_GATEWAY, PAY_REFERENCE, APPR_AMOUNT, FIRSTNAME, LASTNAME, 
                    EMAIL, COMPANY, TELEPHONE AS 'MOBILE', ADDRESS
                FROM tbl_install_invoice tii
                LEFT JOIN tbl_erpdata ted ON tii.RAD_USERNAME=ted.RAD_USERNAME $ad";
        $some_sth = $this->db->select($qry);        
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = array("INVOICENO"=>$row->ORDERNO, "FIRSTNAME"=>$row->FIRSTNAME, "ADDRESS" => $row->ADDRESS, 
                        "LASTNAME"=> $row->LASTNAME, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->MOBILE, "EMAIL"=> $row->EMAIL, "COMPANY"=> $row->COMPANY,
                        "INVID"=> $row->INVID, "ORDER_ERPID"=> $row->ORDER_ERPID, "INVOICE_TOTAL"=> $row->INVOICE_TOTAL,
                         "SALESPERSON"=> $row->SALESPERSON, "SALESEMAIL"=> $row->SALESEMAIL, "INVOICEDATE"=> $row->INVOICEDATE,
                        "PAID" => $row->PAID, "DATEPAID" => $row->DATEPAID, "PAY_GATEWAY" => $row->PAY_GATEWAY,
                        "PAY_REFERENCE" => $row->PAY_REFERENCE, "APPR_AMOUNT" => $row->APPR_AMOUNT );
        }        
        return $ret;
    }
    
    public function loadInvoiceByUser($user="") {
        $ret = array();
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad = " WHERE tii.RAD_USERNAME LIKE '$user'";
        endif;
        $qry = "SELECT tii.INVID, tii.RAD_USERNAME, ORDERNO, ORDER_ERPID, INVOICE_TOTAL, SALESPERSON, SALESEMAIL,
                    INVOICEDATE, PAID, DATEPAID, PAY_GATEWAY, PAY_REFERENCE, APPR_AMOUNT, FIRSTNAME, LASTNAME, 
                    EMAIL, COMPANY, TELEPHONE AS 'MOBILE', ADDRESS
                FROM tbl_install_invoice tii
                LEFT JOIN tbl_erpdata ted ON tii.RAD_USERNAME=ted.RAD_USERNAME $ad";
        $some_sth = $this->db->select($qry);        
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = array("INVOICENO"=>$row->ORDERNO, "FIRSTNAME"=>$row->FIRSTNAME, "ADDRESS" => $row->ADDRESS, 
                        "LASTNAME"=> $row->LASTNAME, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->MOBILE, "EMAIL"=> $row->EMAIL, "COMPANY"=> $row->COMPANY,
                        "INVID"=> $row->INVID, "ORDER_ERPID"=> $row->ORDER_ERPID, "INVOICE_TOTAL"=> $row->INVOICE_TOTAL,
                         "SALESPERSON"=> $row->SALESPERSON, "SALESEMAIL"=> $row->SALESEMAIL, "INVOICEDATE"=> $row->INVOICEDATE,
                        "PAID" => $row->PAID, "DATEPAID" => $row->DATEPAID, "PAY_GATEWAY" => $row->PAY_GATEWAY,
                        "PAY_REFERENCE" => $row->PAY_REFERENCE, "APPR_AMOUNT" => $row->APPR_AMOUNT );
        }        
        return $ret;
    }
    
    public function loadInvoiceMetadata($invid) {
        $ret = [];
        $qry = "SELECT INVID, ITEM, QTY, UNIT_PRICE FROM tbl_invoice_metadata WHERE INVID=?";
        $some_sth = $this->db->select($qry, "i", $invid);
        
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = array("INVID"=>$row->INVID, "ITEM"=>$row->ITEM, 
                        "QTY"=> $row->QTY, "UNIT_PRICE"=>$row->UNIT_PRICE);
        }
        
        return $ret;
    }
    
    
    public function loadMainAccounts($user = "", $is_enabled = 1) {
        $ret = array();
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad = " WHERE tc.USERNAME LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        
        $qry = "SELECT tc.ID, tc.USERNAME, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser 
                FROM tblclients tc
                INNER JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                $ad";
        $some_sth = $this->db->select($qry);
        
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);
        }
        
        return $ret;
    }
    
    
    public function delSubAccount($userid=0, $raduser="", $adminUser="") {
        if ($userid == 0 || $raduser == "") :
            $this->logTrail($this::INFO, "($adminUser attempt Delete SubAccount) Error: [$raduser] User ID and the Service ID cannot be empty", $this::STATUS_FAILED, get_client_ip_env()); 
            echo "Error: User ID and the Service ID cannot be empty";
        else :
            $qry = "DELETE FROM tbl_subaccount WHERE CID = ? AND RAD_USERNAME = ?";
            $rett = $this->db->execute_query($qry, "is", $userid, $raduser);
            
            if ($rett) :
                $this->logTrail($this::INFO, "($adminUser attempt Delete SubAccount) Success: User [$raduser] Service ID Unlinked!!", $this::STATUS_PASSED, get_client_ip_env()); 
                echo "Success: Service ID Unlinked!";
            else:
                $this->logTrail($this::INFO, "($adminUser attempt Delete SubAccount) Error: User [$raduser] Unlink Process Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
                echo "Error: Unlink Process Failed!";
            endif;
        endif;
    }
    
    
    public function loadSubAccount($userid=0) {
        $ret = array();
        
        $ad = "";
        if ($userid <> 0) :
            $ad = " WHERE sa.CID = '$userid'";
        endif;
        $qry = "SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname 
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username  -- tc
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);
        }
        
        return $ret;
    }
    
    
    public function loadLowData() {
        $ret = array();
        

        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, tc.PUSHID, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE', comblimit, @too :=((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                @ti := ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT, @rem := (comblimit - (@too+@ti) ) AS 'BAL', tp.LOW_LEVEL, (tp.LOW_LEVEL>@rem) AS IS_LOW
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID WHERE tp.LOW_LEVEL>0 AND tc.RAD_USERNAME NOT IN (
		SELECT USERNAME FROM tbl_lowdatalog WHERE DATE(SENDDATE) = DATE(NOW())) AND tc.IS_ENABLED=1
            UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, tc.PUSHID, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE', comblimit, @tooo :=((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                @tio := ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT, @remo := (comblimit - (@tooo+@tio) ) AS 'BAL', tp.LOW_LEVEL, (tp.LOW_LEVEL>@remo) AS IS_LOW
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID WHERE tp.LOW_LEVEL>0 AND sa.RAD_USERNAME NOT IN (
		SELECT USERNAME FROM tbl_lowdatalog WHERE DATE(SENDDATE) = DATE(NOW())) AND tc.IS_ENABLED=1
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; //echo $qry;
        $some_sth = $this->db->select($qry);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $bal = $row->comblimit - ($row->TOTALOUTPUT + $row->TOTALINPUT);
            if ( ($bal>0) && ($row->LOW_LEVEL > $bal) ) :
                $ret[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                            "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                            "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "LIMITCOMB" => $row->limitcomb,
                            "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                            "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                            "ACC_TYPE" => $row->ACC_TYPE, "BALANCE" => $bal, "COMBLIMIT" => $row->comblimit,
                            "AMOUNT" => $row->AMOUNT, "LOW_LEVEL" => $row->LOW_LEVEL, "PUSHID" => $row->PUSHID);
            endif;
        }
        
        return $ret;
    }
    
    
    public function loadAllRADAccount($userid=0) {
        $ret = array();
        
        $ad = $add = "";
        if ($userid <> 0) :
            $ad = " WHERE sa.CID = '$userid'";
            $add = " WHERE tc.ID = '$userid'";
        endif;
        //echo "$ad  $add";
        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $add
            
                UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $ad 
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $bal = $row->comblimit - ($row->TOTALOUTPUT + $row->TOTALINPUT);
            $ret[$row->USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "LIMITCOMB" => $row->limitcomb,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                        "ACC_TYPE" => $row->ACC_TYPE, "BALANCE" => $bal, "COMBLIMIT" => $row->comblimit,
                        "AMOUNT" => $row->AMOUNT);
        }
        
        return $ret;
    }
    
    
    public function loadAllRADAccountByUsername($userid="") {
        $ret = array();
        
        $ad = $add = "";
        if ($userid <> "") :
            $ad = " WHERE LCASE(tc.USERNAME) LIKE LCASE('$userid')";
            $add = " WHERE LCASE(tc.USERNAME) LIKE LCASE('$userid')";
        endif;
        //echo "$ad  $add";
        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $add
            
                UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $ad 
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $bal = $row->comblimit - ($row->TOTALOUTPUT + $row->TOTALINPUT);
            $ret[strtolower($row->USERNAME)][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "LIMITCOMB" => $row->limitcomb,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                        "ACC_TYPE" => $row->ACC_TYPE, "EXPIRATION_FORMAT" => date("d-M-Y h:i:s A", strtotime($row->expiration)), 
                        "BALANCE" => $bal, "COMBLIMIT" => $row->comblimit, "AMOUNT" => $row->AMOUNT);
        }
        return $ret;
    }
    
    
    public function loadRADAccountByUsername($userid="") {
        $ret = array();
        
        $ad = $add = "";
        if ($userid <> "") :
            $low = strtolower($userid);
            $ad = " WHERE sa.RAD_USERNAME LIKE '$userid' OR sa.RAD_USERNAME LIKE '$low'";
            $add = " WHERE tc.USERNAME LIKE '$userid' OR tc.USERNAME LIKE '$low'";
        endif;
        
        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE'
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $add
            
                UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE'
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad 
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; 
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->RAD_USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                        "ACC_TYPE" => $row->ACC_TYPE);
        }
        
        return $ret;
    }
    
    public function loadOnlineUsers($is_upcountry=-1) {
        $ret = array();
        
        $qry = "SELECT * FROM `radacct` WHERE acctstoptime IS NULL";
        
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $qry .= " AND username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
        }
        
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    public function loadStatess() {
        $ret = array();
        
        $qry = "SELECT NAME AS 'STATE' FROM `state` ";
        $some_sth = $this->db->select($qry);

        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row->STATE;
        }
        
        return $ret;
    }
    
    
    public function createClientOnAll($username, $password, $firstname, $lastname, $company, $email, $phoneNo, 
                    $addy, $city, $state, $planID, 
                    $srvid, $srvname, $expiry_date, $download, $upload, $total, $ip, $adminID, $adminUser) {
        $user_exist = $this->verifyUserExist($username);
        
//        parent::setUsername($adminUser);
        $this->setUsername($adminUser);
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist and Account is Disabled";
        else :
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Start to create Service ID [$username]. ", $this::STATUS_PASSED, get_client_ip_env()); 
            $all_query_ok=true; // our control variable
            $this->db->autocommit(FALSE);
            $ret = 0; $chk = "";  
            
            //Create in Radius
            $mpass = md5($password);
            $ins = "INSERT INTO rm_changesrv
                    (username, newsrvid, newsrvname, scheduledate, requestdate, `status`, requested)
                    VALUES
                    (?, ?, ?, NOW(), NOW(), 1, ?)";
            $this->db->insert($ins, 'ssss', $username, $srvid, $srvname, "eService_$adminUser")? null : $all_query_ok=false;
            $chk .= "CH1:".$all_query_ok."||";
            $ins = "INSERT INTO radcheck (UserName, Attribute, op, `Value`)
                        VALUES (?, 'Cleartext-Password', ':=', ?), "
                        . " (?, 'Simultaneous-Use', ':=', '1')";
            $this->db->insert($ins, 'sss', $username, $password, $username)? null : $all_query_ok=false;            
            $chk .= "CH2:".$all_query_ok."||";
            $dd = date("Y-m-d");
            $ins = "INSERT INTO rm_users (
   		      username, `password`, downlimit, uplimit, comblimit, firstname, lastname, company,
   		      phone, mobile, email, address, city, zip, country, state, `comment`, mac, expiration,
   		      enableuser, usemacauth, uptimelimit, srvid, staticipcm, staticipcpe, ipmodecm, ipmodecpe,
   		      createdon, acctype, createdby, taxid, maccm, credits, `owner`, groupid, custattr, poolidcm, poolidcpe,
   		      contractid, contractvalid, gpslong, gpslat, alertemail, alertsms, lang)
                      VALUES (
   		      ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '', 'Nigeria', ?, '', '', ?, " .
   		      "'1', 0, '0', ?, '', ?, 0, 2, '$dd', '0', " .
   		      "?, '', '', '0.00', 'admin', '1', '', '0', '0', " .
   		      "'', '', '0', '0', 1, 1, 'English' )";
            $useme = "eService_$adminUser";
            $this->db->insert($ins, 'ssiiissssssssssiss', $username, $mpass, $download, $upload, $total, $firstname, 
                        $lastname, $company, $phoneNo, $phoneNo, $email, $addy, $city, $state, $expiry_date,
                        $srvid, $ip, $useme)? null : $all_query_ok=false;
//            $ins = "INSERT INTO rm_users (
//   		      username, password, downlimit, uplimit, comblimit, firstname, lastname, company,
//   		      phone, mobile, email, address, city, zip, country, state, comment, mac, expiration,
//   		      enableuser, usemacauth, uptimelimit, srvid, staticipcm, staticipcpe, ipmodecm, ipmodecpe,
//   		      createdon, acctype, createdby, taxid, maccm, credits, owner, groupid, custattr, poolidcm, poolidcpe,
//   		      contractid, contractvalid, gpslong, gpslat, alertemail, alertsms, lang)
//                      VALUES (
//   		      'opma', '96f2a3e3588c33f5c0c10c9f5d27602a', 0, 0, 0, 'Opeyemi', 'Matiluko', 'OPMat Inc', '8059463559', '8059463559', 'sad@lmu.edu.ng', 'LU Staff Qtrs', 'Omu-Aran', '', 'Nigeria', 'Kwara', '', '', '2019-01-24',
//   		      '1', 0, '0', '40', '', '11.23.234.23', 0, 2, NOW(), '0',
//   		      'eService_opmat', '', '', '0.00', 'admin', '1', '', '0', '0',
//   		      '', '', '0', '0', 1, 1, 'English' )";
//            $this->db->insert($ins);
            $chk .= "CH3:".$all_query_ok."||";
            //create in eservice
            $ins = "INSERT INTO tblclients (USERNAME, `PASSWORD`, RAD_USERNAME, IS_ENABLED, DATE_CREATED, ADDED_BY)
                VALUES (?, ?, ?, 1, NOW(), ?)";
            $this->db->insert($ins, 'sssi', $username, sha1($password), $username, $adminID)? null : $all_query_ok=false;
            $chk .= "CH4:".$all_query_ok."||";
            if ($all_query_ok) {
                $this->db->commit();
                $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Created Service ID [$username] on eService and Radius!", $this::STATUS_PASSED, get_client_ip_env()); 
                $this->db->autocommit(TRUE);
                return "Success: Created Service ID [$username] on eService and Radius!$chk";
            } else {
//                $this->db->error();
                $this->db->rollback();
                $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to create Service ID [$username] on eService and Radius!", $this::STATUS_FAILED, get_client_ip_env()); 
                $this->db->autocommit(TRUE);
                return "Error: Failed to create Service ID [$username] on eService and Radius!$chk";
            }
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to create Service ID [$username]. Something Went Wrong", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Something went Wrong";
            
        endif;
    }
    
    public function deleteUserRadius($username, $adminUser, $adminID=0, $reason='') {
        $this->setUsername($adminUser);
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        
        $strsql = "DELETE FROM rm_changesrv WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM radcheck WHERE UserName = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $ins = "REPLACE INTO tbl_account_archive SELECT * FROM tbl_user_extend WHERE username=?";
        $this->db->insert($ins, 's', $username); //? null : $all_query_ok=false;
        $sel = "SELECT * FROM tbl_user_extend WHERE username=?";
        $some_sth = $this->db->select($sel, "s", $username);
        $some_sth->num_rows()? null : $all_query_ok=false;
        
        $inss = "INSERT INTO tbl_account_deleted VALUES (NULL, ?, ?, NOW(), USER(), ?, NULL, NULL, NULL)";
        $this->db->insert($inss, 'sis', $username, $adminID,  $reason)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM rm_users WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Service ID [$username] deleted on Radius!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] deleted and archived on Radius!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to delete Service ID [$username] on Radius!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to delete Service ID [$username] on Radius!";
        }
    }
    
    public function deleteUserRadnClient($username, $adminUser, $adminID=0, $reason='') {
        $this->setUsername($adminUser); $kk='';
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        
        $strsql = "DELETE FROM rm_changesrv WHERE username = ?"; 
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM radcheck WHERE UserName = ?"; 
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM tblclients WHERE RAD_USERNAME = ?"; 
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $ins = "INSERT INTO tbl_account_archive SELECT * FROM tbl_user_extend WHERE username=?"; 
        $this->db->insert($ins, 's', $username); //? null : $all_query_ok=false;
        $sel = "SELECT * FROM tbl_user_extend WHERE username=?";
        $some_sth = $this->db->select($sel, "s", $username);
        $some_sth->num_rows()? null : $all_query_ok=false;
        
        $inss = "INSERT INTO tbl_account_deleted VALUES (NULL, ?, ?, NOW(), USER(), ?, NULL, NULL, NULL)"; 
        $this->db->insert($inss, 'sis', $username, $adminID,  $reason)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM rm_users WHERE username = ?"; 
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM tbl_erpdata WHERE RAD_USERNAME = ?"; 
        $this->db->execute_query($strsql, "s", $username);
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Service ID [$username] deleted on Radius and eService!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] deleted and archived on Radius and eService!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to delete Service ID [$username] on Radius and eService!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to delete Service ID [$username] on Radius and eService! ";
        
        }
    }
    
    public function deleteUserRadnSubAcct($username, $adminUser, $adminID=0, $reason='') {
        $this->setUsername($adminUser);
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        
        $strsql = "DELETE FROM rm_changesrv WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM radcheck WHERE UserName = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $ins = "REPLACE INTO tbl_account_archive SELECT * FROM tbl_user_extend WHERE username=?";
        $this->db->insert($ins, 's', $username); //? null : $all_query_ok=false;
        $sel = "SELECT * FROM tbl_user_extend WHERE username=?";
        $some_sth = $this->db->select($sel, "s", $username);
        $some_sth->num_rows()? null : $all_query_ok=false;
        
        $inss = "INSERT INTO tbl_account_deleted VALUES (NULL, ?, ?, NOW(), USER(), ?, NULL, NULL, NULL)";
        $this->db->insert($inss, 'sis', $username, $adminID,  $reason)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM tbl_subaccount WHERE RAD_USERNAME = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM rm_users WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false; 
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Service ID [$username] deleted on Radius and eService (Sub-Account)!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] deleted and archived on Radius and eService (Sub-Account)!";
        } else {
//                $this->db->error(); 
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to delete Service ID [$username] on Radius and eService (Sub-Account)!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to delete Service ID [$username] on Radius and eService (Sub-Account)!";
        }
    }
    
    
    public function erpProvisioning($erpid, $raduser, $company, $firstname='', $lastname='',
                        $addy='', $city='', $state='', $email='', $phone='', $package='', 
                        $ip='0.0.0.0', $pass='', $estate='', $gender='', $dob='') {
        
        $qry = "SELECT * FROM `tbl_erpdata` WHERE ERPID=? OR RAD_USERNAME=?";
        $some_sth = $this->db->select($qry, "is", $erpid, $raduser);
        $rows = $some_sth->num_rows();
        if ($rows):
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$raduser] or ERP ID [$erpid] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$raduser] or ERP ID [$erpid] already Exist"];
        endif;
        
        $user_exist = $this->verifyUserExist($raduser);
        $username = $raduser;
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$username] already Exist"];
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$username] already Exist and Account is Disabled"];
        else :
            $ins = "INSERT INTO tbl_erpdata (ERPID, RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS,
                        CITY, STATE, EMAIL, TELEPHONE, PACKAGE, PASSWORD, IPADDY, DATEINITITATED,
                        GENDER, DOB, ESTATE)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?, ?)";
            $in_id = $this->db->insert($ins, 'isssssssssssssss', $erpid, strtolower($raduser), $firstname, $lastname,
                        $company, $addy, $city, $state, $email, $phone, $package, $pass, $ip, $gender, $dob, $estate);
            
            if ($in_id) :
                $qry = "SELECT * FROM tbl_erp WHERE ERPID=?";
                $some_sth = $this->db->select($qry, "i", $erpid);
                $rows = $some_sth->num_rows();
                if ($rows <= 0):
                    $ins = "INSERT IGNORE INTO tbl_erp (ERPID, RAD_USERNAME)
                            VALUES (?, ?)";
                    $this->db->insert($ins, 'is', $erpid, $raduser);
                endif;
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$username] provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                return ["STATUS"=>1, "MSG"=> "Success: User [$username] provisioned!"];
            else:
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$username]"];
            endif;
            
        endif;
        
    }
    
    
    public function accProvisionFromOrder($raduser, $invno) {
        $raduser = $pass = strtolower($raduser);
        //get client details
        $user_exist = $this->verifyUserExist($raduser);
        $username = $raduser;
        $uidd = 0;
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist, no need to recreate", $this::STATUS_PASSED, get_client_ip_env()); 
            return ["STATUS"=>1, "MSG"=> "Success: User [$username] already Exist, no need to recreate"];
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist and Account is Disabled, no need to recreate", $this::STATUS_PASSED, get_client_ip_env()); 
            return ["STATUS"=>1, "MSG"=> "Success: User [$username] already Exist and Account is Disabled, no need to recreate"];
        else :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Notice: User [$username] provisioning on eService & Radius Started!", $this::STATUS_PASSED, get_client_ip_env()); 
            //get user details
            $strsql = "SELECT FIRSTNAME, LASTNAME, COMPANY, EMAIL, TELEPHONE AS 'PHONE', PLAN_ID, tp.SRVID,
                            DATA_VOLUME, ADDRESS, ERPID, CITY, STATE, PLAN, SALESPERSON, SALESEMAIL, ted.ID FROM tbl_erpdata ted
                        LEFT JOIN `tbl_plans` tp ON ted.PACKAGE=tp.PLAN
                        LEFT JOIN rm_services rs ON tp.SRVID=rs.srvid
                        LEFT JOIN tbl_install_invoice tii ON ted.RAD_USERNAME=tii.RAD_USERNAME
                        WHERE ted.RAD_USERNAME LIKE ? AND tii.ORDERNO = ?";
            $some_sth = $this->db->select($strsql, "ss", $raduser, $invno);
            $row = $some_sth->fetch_object();
            $postdata = ["firstname"=>$row->FIRSTNAME, "lastname"=>$row->LASTNAME, "company"=>$row->COMPANY, "email"=>$row->EMAIL, 
                "phoneNo"=>$row->PHONE, "username"=>strtolower($raduser), "plan_id"=>$row->PLAN_ID, "srvid"=>$row->SRVID, "pass"=>$pass, 
                "passconfirm"=>$pass, "expiry_date"=>date("Y-m-d"), "download"=>0, "upload"=>0, "invoiceno" => $invno,
                "total_limit"=>$row->DATA_VOLUME, "staticipcpe"=>"0.0.0.0", "changep"=>"main", "mainraduser"=>"", "usertype"=>8,
                "salesperson"=>$row->SALESPERSON, "salesemail"=>$row->SALESEMAIL, "addy"=>$row->ADDRESS, "srvname"=>$row->PLAN, "erpid"=>$row->ERPID,
                "city"=>$row->CITY, "state"=>$row->STATE, "adminID" => 44, "adminUser" => "erpuser"  ];  
            $uidd = $row->ID;  
           //send post
           $ret = $this->__curlURL(SERVER_URL."ajax/cusererp", 1, http_build_query($postdata));
           if(stripos($ret, "Success:") !== false):
               $strupd = "UPDATE rm_users SET enableuser=0 WHERE username='".strtolower($raduser)."'";
               $this->db->execute_query($strupd);
               //created
               $upd = "UPDATE tbl_erpdata SET ONLY_ACTIVATE=1 WHERE ID=$uidd";
               $this->db->execute_query($upd);
               $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$raduser] fully provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
               return ["STATUS"=>1, "MSG"=> "Success: User [$raduser] full provisioned!"];
           else:
               //not created
               $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$raduser] partially provisioned! $ret", $this::STATUS_PASSED, get_client_ip_env()); 
               return ["STATUS"=>1, "MSG"=> "Success: User [$raduser] provisioned -!"];
           endif;
        endif;
        
    }
    
    
    public function erpOrderProvisioningV3($erpid, $order_erpid, $orderno, $raduser, $company, $orderdate, 
                        $item1, $item2, $item1_cost, $item2_cost, $item1_qty, $item2_qty, $tot_amt, $salesperson, $salesemail='', $firstname='', $lastname='',
                        $addy='', $city='', $state='', $email='', $phone='', $package='', 
                        $ip='0.0.0.0', $pass='', $data='') {
        /*** TEST ***/
        $ins = "INSERT INTO tbl_erpinvoice_data (ID, DATA, DATESENT)
                VALUES (NULL, ?, NOW())";
        $in_id = $this->db->insert($ins, 's', $data); 

        if ($in_id) :
            $this->logTrail($this::NEW_USER, "(ERP INVOICE API attempt) Success: Order [$order_erpid] saved!", $this::STATUS_PASSED, get_client_ip_env()); 
//            return ["STATUS"=>1, "MSG"=> "Success: Order saved!"];
        else:
            $this->logTrail($this::NEW_USER, "(ERP INVOICE API attempt) Error: Unable to save order [$order_erpid] data == $in_id === ", $this::STATUS_FAILED, get_client_ip_env()); 
//            return ["STATUS"=>0, "MSG"=> "Error: Unable to save Order"];
        endif;
        /**** END TEST ***/
        
        $in_id = -1;
        $qry = "SELECT * FROM `tbl_erpdata` WHERE ERPID=? OR RAD_USERNAME=?";
        $some_sth = $this->db->select($qry, "is", $erpid, $raduser);
        $rows = $some_sth->num_rows();
        if ($rows):
//            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$raduser] or ERP ID [$erpid] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
//            return ["STATUS"=>0, "MSG"=> "Error: User [$raduser] or ERP ID [$erpid] already Exist"];
            $row = $some_sth->fetch_object();
            $in_id = $row->ID;
            $upd = "UPDATE `tbl_erpdata` SET PACKAGE=?, INVOICENO=? WHERE ERPID=?";
            $this->db->execute_query($upd, "ssi", $package, $orderno, $erpid);
        else:
           //Not Yet created, Create in tbl_erpdata 
            $ins = "INSERT INTO tbl_erpdata (ERPID, RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS,
                        CITY, STATE, EMAIL, TELEPHONE, PACKAGE, PASSWORD, IPADDY, DATEINITITATED, INVOICED,
                        PAID_INVOICE, INVOICENO, ONLY_ACTIVATE)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), 1, 0, ?, 0)";
            $in_id = $this->db->insert($ins, 'isssssssssssss', $erpid, strtolower($raduser), $firstname, $lastname,
                        $company, $addy, $city, $state, $email, $phone, $package, $pass, $ip, $orderno);
            
            if ($in_id > 0) :
                
            else:
               $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$raduser]"];
            endif;
            
        endif;
        $qry = "SELECT * FROM tbl_erp WHERE ERPID=?";
        $some_sth = $this->db->select($qry, "i", $erpid);
        $rows = $some_sth->num_rows();
        if ($rows <= 0):
            $ins = "INSERT IGNORE INTO tbl_erp (ERPID, RAD_USERNAME)
                    VALUES (?, ?)";
            $this->db->insert($ins, 'is', $erpid, $raduser);
        endif;
        
    	$qry = "SELECT * FROM tbl_install_invoice WHERE RAD_USERNAME=? AND ORDERNO=?";
        $some_sth = $this->db->select($qry, "ss", strtolower($raduser), $orderno);
        $rows = $some_sth->num_rows();
        if (!$rows) :
        //create invoice
        $inss = "INSERT INTO tbl_install_invoice (RAD_USERNAME, ORDERNO, ORDER_ERPID, INVOICE_TOTAL, SALESPERSON, SALESEMAIL, INVOICEDATE) 
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        $inid = $this->db->insert($inss, "ssidsss", strtolower($raduser), $orderno, $order_erpid, $tot_amt, $salesperson, $salesemail, $orderdate);
        if ($inid) :
            $inst = "INSERT INTO tbl_invoice_metadata (INVID, ITEM, QTY, UNIT_PRICE) VALUES (?, ?, ?, ?), (?, ?, ?, ?) ";
            $insid = $this->db->insert($inst, "isidisid", $inid, $item1, $item1_qty, $item1_cost, $inid, $item2, $item2_qty, $item2_cost );
            if ($insid) :
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$raduser] fully provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                //Send Email
                $raw_msg = $this->getCannedMessage("INVOICE_MAIL");
                $pgen = new Password_Generator();
                $hashed = urlencode($pgen->generate(10, 10, true, true, false, false) . base64_encode($pgen->generate(15, 15, true, true, true, false) . $orderno));
                $url = SERVER_URL . "minv/" . $hashed; //add hashed invno
                
                $vat = $tot_amt-($item1_cost+$item2_cost);
                $msg = sprintf($raw_msg, "$firstname $lastname", $orderno, $url, $url, $orderno, number_format($tot_amt,2), $package, number_format($item1_cost,2), number_format($item2_cost,2), number_format($vat,2), number_format($tot_amt,2));
                $sent = $this->sendEmail($email, NEW_SALES_EMAIL, "Proforma Invoice - New Customer Installation", $msg, ["New Sales Team"=>NEW_SALES_EMAIL, $salesperson=>$salesemail]);
                $this->logTrail($this::NEW_USER, "(INVOICE MAIL attempt) User [$raduser] Mail Status: |$sent|", $this::STATUS_PASSED, get_client_ip_env()); 
                return ["STATUS"=>1, "MSG"=> "Success: User [$raduser] fully provisioned!"];
                
            else:
                $del = "DELETE FROM tbl_install_invoice WHERE INVID=$inid; DELETE FROM tbl_erpdata WHERE ID=$in_id;";
                // $this->db->execute_query($del);
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$raduser]"];
            endif;

        else: 
            $del = "DELETE FROM tbl_erpdata WHERE ID=$in_id;";
            $this->db->execute_query($del);
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$raduser]"];

        endif;
        
        endif;
    }
    
    
    public function erpOrderProvisioningV2($erpid, $order_erpid, $orderno, $raduser, $company, $orderdate, 
                        $item1, $item2, $item1_cost, $item2_cost, $item1_qty, $item2_qty, $tot_amt, $salesperson, $salesemail='', $firstname='', $lastname='',
                        $addy='', $city='', $state='', $email='', $phone='', $package='', 
                        $ip='0.0.0.0', $pass='', $data='') {
        /*** TEST ***/
        $ins = "INSERT INTO tbl_erpinvoice_data (ID, DATA, DATESENT)
                VALUES (NULL, ?, NOW())";
        $in_id = $this->db->insert($ins, 's', $data);

        if ($in_id) :
            $this->logTrail($this::NEW_USER, "(ERP INVOICE API attempt) Success: Order [$order_erpid] saved!", $this::STATUS_PASSED, get_client_ip_env()); 
//            return ["STATUS"=>1, "MSG"=> "Success: Order saved!"];
        else:
            $this->logTrail($this::NEW_USER, "(ERP INVOICE API attempt) Error: Unable to save order [$order_erpid] data == $in_id === ", $this::STATUS_FAILED, get_client_ip_env()); 
//            return ["STATUS"=>0, "MSG"=> "Error: Unable to save Order"];
        endif;
        /**** END TEST ***/
        
        $in_id = -1;
        $qry = "SELECT * FROM `tbl_erpdata` WHERE ERPID=? OR RAD_USERNAME=?";
        $some_sth = $this->db->select($qry, "is", $erpid, $raduser);
        $rows = $some_sth->num_rows();
        if ($rows):
//            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$raduser] or ERP ID [$erpid] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
//            return ["STATUS"=>0, "MSG"=> "Error: User [$raduser] or ERP ID [$erpid] already Exist"];
            $row = $some_sth->fetch_object();
            $in_id = $row->ID;
			$upd = "UPDATE `tbl_erpdata` SET PACKAGE=? WHERE ERPID=?";
            $this->db->execute_query($upd, "si", $package, $erpid);
        else:
           //Not Yet created, Create in tbl_erpdata 
            $ins = "INSERT INTO tbl_erpdata (ERPID, RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS,
                        CITY, STATE, EMAIL, TELEPHONE, PACKAGE, PASSWORD, IPADDY, DATEINITITATED, INVOICED,
                        PAID_INVOICE, INVOICENO, ONLY_ACTIVATE)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), 1, 0, ?, 0)";
            $in_id = $this->db->insert($ins, 'isssssssssssss', $erpid, strtolower($raduser), $company, $lastname,
                        $company, $addy, $city, $state, $email, $phone, $package, $pass, $ip, $orderno);
            
            if ($in_id > 0) :
                
            else:
               $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$raduser]"];
            endif;
            
        endif;
        
        //create invoice
        $inss = "INSERT INTO tbl_install_invoice (RAD_USERNAME, ORDERNO, ORDER_ERPID, INVOICE_TOTAL, SALESPERSON, SALESEMAIL, INVOICEDATE) 
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        $inid = $this->db->insert($inss, "ssidsss", strtolower($raduser), $orderno, $order_erpid, $tot_amt, $salesperson, $salesemail, $orderdate);
        if ($inid) :
            $inst = "INSERT INTO tbl_invoice_metadata (INVID, ITEM, QTY, UNIT_PRICE) VALUES (?, ?, ?, ?), (?, ?, ?, ?) ";
            $insid = $this->db->insert($inst, "isidisid", $inid, $item1, $item1_qty, $item1_cost, $inid, $item2, $item2_qty, $item2_cost );
            if ($insid) :
                $plan = $this->loadPlanFromName($package);
                $srvid = $plan['SRVID'];
                $planid = $plan["PLAN_ID"];
                $datalimit = $plan["DATAV"];
                $postdata = ["firstname"=>$firstname, "lastname"=>$lastname, "company"=>$company, "email"=>$email, 
                     "phoneNo"=>$phone, "username"=>strtolower($raduser), "plan_id"=>$planid, "srvid"=>$srvid, "pass"=>strtolower($pass), 
                     "passconfirm"=>strtolower($pass), "expiry_date"=>date("Y-m-d"), "download"=>0, "upload"=>0, "invoiceno" => $orderno,
                     "total_limit"=>$datalimit, "staticipcpe"=>"0.0.0.0", "changep"=>"main", "mainraduser"=>"", "usertype"=>8,
                     "salesperson"=>$salesperson, "salesemail"=>$salesemail, "addy"=>$addy, "srvname"=>$package, "erpid"=>$erpid,
                     "city"=>$city, "state"=>$state, "adminID" => 44, "adminUser" => "erpuser"  ];  
                //send post
                $ret = $this->__curlURL(SERVER_URL."ajax/cusererp", 1, http_build_query($postdata));
                if(stripos($ret, "Success:") !== false):
                    //created
                    $upd = "UPDATE tbl_erpdata SET ONLY_ACTIVATE=1 WHERE ID=$in_id";
                    $this->db->execute_query($upd);
                    $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$raduser] fully provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                    return ["STATUS"=>1, "MSG"=> "Success: User [$raduser] full provisioned!"];
                else:
                    //not created
                    $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$raduser] partially provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                    return ["STATUS"=>1, "MSG"=> "Success: User [$raduser] provisioned -!"];
                endif;
            else:
                $del = "DELETE FROM tbl_install_invoice WHERE INVID=$inid; DELETE FROM tbl_erpdata WHERE ID=$in_id;";
                $this->db->execute_query($del);
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$raduser]"];
            endif;

        else: 
            $del = "DELETE FROM tbl_erpdata WHERE ID=$in_id;";
            $this->db->execute_query($del);
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$raduser]"];

        endif;
    }
    
    
	public function erpOrderProvisioning($erpid, $order_erpid, $orderno, $raduser, $company, $orderdate, 
                        $item1, $item2, $item1_cost, $item2_cost, $item1_qty, $item2_qty, $tot_amt, $salesperson, $salesemail='', $firstname='', $lastname='',
                        $addy='', $city='', $state='', $email='', $phone='', $package='', 
                        $ip='0.0.0.0', $pass='', $data='') {
//    public function erpOrderProvisioning($data) {
        
        /*** TEST ***/
        $ins = "INSERT INTO tbl_erpinvoice_data (ID, DATA, DATESENT)
                VALUES (NULL, ?, NOW())";
        $in_id = $this->db->insert($ins, 's', $data);

        if ($in_id) :
            $this->logTrail($this::NEW_USER, "(ERP INVOICE API attempt) Success: Order [$order_erpid] saved!", $this::STATUS_PASSED, get_client_ip_env()); 
//            return ["STATUS"=>1, "MSG"=> "Success: Order saved!"];
        else:
            $this->logTrail($this::NEW_USER, "(ERP INVOICE API attempt) Error: Unable to save order [$order_erpid] data == $in_id === ", $this::STATUS_FAILED, get_client_ip_env()); 
//            return ["STATUS"=>0, "MSG"=> "Error: Unable to save Order"];
        endif;
        /**** END TEST ***/
        
        $qry = "SELECT * FROM `tbl_erpdata` WHERE ERPID=? OR RAD_USERNAME=?";
        $some_sth = $this->db->select($qry, "is", $erpid, $raduser);
        $rows = $some_sth->num_rows();
        if ($rows):
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$raduser] or ERP ID [$erpid] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$raduser] or ERP ID [$erpid] already Exist"];
        endif;
        
        $user_exist = $this->verifyUserExist($raduser);
        $username = $raduser;
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$username] already Exist"];
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$username] already Exist and Account is Disabled"];
        else :
            $ins = "INSERT INTO tbl_erpdata (ERPID, RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS,
                        CITY, STATE, EMAIL, TELEPHONE, PACKAGE, PASSWORD, IPADDY, DATEINITITATED, INVOICED,
                        PAID_INVOICE, INVOICENO, ONLY_ACTIVATE)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), 1, 0, ?, 0)";
            $in_id = $this->db->insert($ins, 'isssssssssssss', $erpid, strtolower($raduser), $company, $lastname,
                        $company, $addy, $city, $state, $email, $phone, $package, $pass, $ip, $orderno);
            
            if ($in_id) :
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$username] provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                //return ["STATUS"=>1, "MSG"=> "Success: User [$username] provisioned!"];
            
                //create invoice
                $inss = "INSERT INTO tbl_install_invoice (RAD_USERNAME, ORDERNO, ORDER_ERPID, INVOICE_TOTAL, SALESPERSON, SALESEMAIL, INVOICEDATE) 
                        VALUES (?, ?, ?, ?, ?, ?, ?)";
                $inid = $this->db->insert($inss, "ssidsss", strtolower($raduser), $orderno, $order_erpid, $tot_amt, $salesperson, $salesemail, $orderdate);
                if ($inid) :
                    $inst = "INSERT INTO tbl_invoice_metadata (INVID, ITEM, QTY, UNIT_PRICE) VALUES (?, ?, ?, ?), (?, ?, ?, ?) ";
                    $insid = $this->db->insert($inst, "isidisid", $inid, $item1, $item1_qty, $item1_cost, $inid, $item2, $item2_qty, $item2_cost );
                    if ($insid) :
                      $plan = $this->loadPlanFromName($package);
                      $srvid = $plan['SRVID'];
                      $planid = $plan["PLAN_ID"];
                	  $datalimit = $plan["DATAV"];
                      $postdata = ["firstname"=>$firstname, "lastname"=>$lastname, "company"=>$company, "email"=>$email, 
                           "phoneNo"=>$phone, "username"=>strtolower($raduser), "plan_id"=>$planid, "srvid"=>$srvid, "pass"=>strtolower($pass), 
                           "passconfirm"=>strtolower($pass), "expiry_date"=>date("Y-m-d"), "download"=>0, "upload"=>0, "invoiceno" => $orderno,
                           "total_limit"=>$datalimit, "staticipcpe"=>"0.0.0.0", "changep"=>"main", "mainraduser"=>"", "usertype"=>8,
                           "salesperson"=>$salesperson, "salesemail"=>$salesemail, "addy"=>$addy, "srvname"=>$package, "erpid"=>$erpid,
                           "city"=>$city, "state"=>$state, "adminID" => 44, "adminUser" => "erpuser"  ];    
                        //send post
                        $ret = $this->__curlURL(SERVER_URL."ajax/cusererp", 1, http_build_query($postdata));
                        if(stripos($ret, "Success:") !== false){
                            //created
                            $upd = "UPDATE tbl_erpdata SET ONLY_ACTIVATE=1 WHERE ID=$in_id";
                            $this->db->execute_query($upd);
                            $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$username] fully provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                            return ["STATUS"=>1, "MSG"=> "Success: User [$username] full provisioned!"];
                        } else{
                            //not created
                            $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$username] partially provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                            return ["STATUS"=>1, "MSG"=> "Success: User [$username] provisioned -!"];
                        }
                    else:
                        $del = "DELETE FROM tbl_install_invoice WHERE INVID=$inid; DELETE FROM tbl_erpdata WHERE ID=$in_id;";
                        $this->db->execute_query($del);
                        $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                        return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$username]"];
                    endif;
                    
                else: 
                    $del = "DELETE FROM tbl_erpdata WHERE ID=$in_id;";
                    $this->db->execute_query($del);
                    $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                    return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$username]"];
                    
                endif;
                
            else:
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$username]"];
            endif;
            
        endif;
        
    }
    
    
    private function __curlURL($strURL, $isPost=0, $postdata="", $header=[]) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // Return data inplace of echoing on screen
        curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge(["X-Requested-With: XMLHttpRequest"],$header));
        curl_setopt($ch, CURLOPT_URL, $strURL);
        
        if ($isPost):
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        endif;
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); // Skip SSL Verification
        //curl_setopt($ch, CURLOPT_SSLVERSION,3);
        //curl_setopt( $ch, CURLOPT_SSLVERSION, 'CURL_SSLVERSION_SSLv3' );
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1);
        $rsData = curl_exec($ch); //print_r($rsData); echo "Dahs"; //return;
        //echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);

        return $rsData;
    }
    
    
    public function createClient($username, $password, $raduser, $adminID, $subraduser=array()) {
        $user_exist = $this->verifyUserExist($username);
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist and Account is Disabled";
        else :
            $ins = "INSERT INTO tblclients (USERNAME, PASSWORD, RAD_USERNAME, IS_ENABLED, DATE_CREATED, ADDED_BY)
                    VALUES (?, ?, ?, 1, NOW(), ?)";
            $in_id = $this->db->insert($ins, 'sssi', $username, sha1($password), $raduser, $adminID);
            
            $rett = 0;
            if (count($raduser) >= 1) :
                $rett = $this->createSubAccount($in_id, $adminID, $subraduser);
            endif;
            
            if ($in_id) :
                if (count($raduser) >= 1) :
                    if ($rett):
                        $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$username] Created and Linked to Service ID [$raduser] and other sub-accounts!", $this::STATUS_PASSED, get_client_ip_env()); 
                        return "Success: User [$username] Created and Linked to Service ID [$raduser] and other sub-accounts!";
                    else:
                        $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$username] Created but unable to link sub-account, please verify and try adding later!", $this::STATUS_PASSED, get_client_ip_env()); 
                        return "Success: User [$username] Created but unable to link sub-account, please verify and try adding later!";
                    endif;
                endif;
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$username] Created and Linked to Service ID [$raduser>!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: User [$username] Created and Linked to Service ID [$raduser>!";
            else:
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create and link User [$username>", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create and link User [$username>";
            endif;
        endif;
        
    }
    
    
    public function createSubAccount($uid, $adminID, $raduser=array()) {
        
        if (count($raduser) < 1) :
            return 0;
        else :
            $ret = 0;
            foreach ($raduser as $k=>$v) :
                if (trim($v)) :
                    $ins = "INSERT INTO tbl_subaccount (CID, RAD_USERNAME, DATE_CREATED, ADDED_BY) 
                            VALUES (?, ?, NOW(), ?)";
                    $in_id = $this->db->insert($ins, 'isi', $uid, $v, $adminID);
                    
                    if ($in_id) {
                        $ret = 1;
                        $this->logTrail($this::NEW_USER, "($adminID attempt) Service ID [$v] created on eService (Sub-Account)!", $this::STATUS_PASSED, get_client_ip_env()); 
                    }
                endif;
            endforeach;
            
            return $ret;
            
        endif;
        
    }
    
    
    public function editUser($username, $raduser, $password="", $enabled=1, $rad_enabled = 1) {
        $adstr = "";
        
        if ($password != ""):
            $adstr .= ", `PASSWORD` = '" . sha1($password) . "'";

            $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                    SELECT USERNAME, `PASSWORD`, ?, NOW(), 0 FROM tblclients WHERE USERNAME LIKE ?";
            $this->db->insert($ins, 'ss', sha1($password), $username);
        endif;
        if ($raduser != ""):
            $adstr .= ", `RAD_USERNAME` = '" . $raduser . "'";
        endif;

        $upd = "UPDATE tblclients SET IS_ENABLED=? $adstr WHERE USERNAME=?"; 
        $rett = $this->db->execute_query($upd, "is", $enabled, $username);

        if ($rett) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: User ($username) Update Completed", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error! User ($username) Update Failed", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Update failed!";
        endif;

    }
    
    public function editRadUser($username, $firstname, $lastname, $passwd, $company, $addy, $city, $state, 
                            $email, $phoneNo, $staticipcpe) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        $addon = $addon1 = "";
        
        if ($passwd != "") :
            $strsql = "UPDATE radcheck SET `value`=? 
                WHERE username = ? AND `attribute`='Cleartext-Password'";
            $this->db->execute_query($strsql, "ss", $passwd, $username)? null : $all_query_ok=false;
            $addon = ", `password` = MD5('$passwd')";
            $addon1 = ", `PASSWORD` = '" . sha1($passwd) . "'";
        endif;
        
        $strsql = "UPDATE rm_users SET firstname=?, lastname=?, company=?, 
                phone=?, mobile=?, email=?, address=?, city=?, state=?, staticipcpe=?, enableuser=1 $addon WHERE username = ?";
        $this->db->execute_query($strsql, "sssssssssss", $firstname, $lastname, $company, 
                    $phoneNo, $phoneNo, $email, $addy, $city, $state, $staticipcpe, $username)? null : $all_query_ok=false;
        
        if ($all_query_ok) {
            $updd = "UPDATE tblclients SET IS_ENABLED=1 $addon1 WHERE USERNAME=?";
            $this->db->execute_query($updd, "s", $username);
            $this->db->commit();
            $this->db->autocommit(TRUE);            
            $this->logTrail($this::INFO, "($adminUser attempt) Success: Service ID [$username] updated on Radius!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] updated on Radius!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::INFO, "($adminUser attempt) Error: Failed to update Service ID [$username] on Radius!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to update Service ID [$username] on Radius!";
        }
    }
    
    public function extendExpiration($username, $expiry_date) {
        $strsql = "UPDATE `rm_users` SET `expiration`=? 
                WHERE username = ?";  
        $rett = $this->db->execute_query($strsql, "ss", $expiry_date, $username);
        
        return $rett;
    }
    
    public function extendExpirationBulk($users, $extendby, $cutoff, $criteria, $critlist) {
        $userlist = "'" . implode("', '", $users) . "'";
    	if (( filter_var($extendby, FILTER_VALIDATE_INT) === false )) {
        	$this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Extension for $criteria [$critlist] by $extendby Days Update failed!", $this::STATUS_FAILED, get_client_ip_env());
            return "Error: Update failed!";
        }
        $strsql = "UPDATE rm_users SET expiration=(CASE WHEN expiration < NOW() 
                    THEN DATE_ADD(NOW(),INTERVAL $extendby DAY) ELSE DATE_ADD(expiration,INTERVAL $extendby DAY) END)
WHERE username IN (
$userlist
)
AND expiration >= ?";  
        $rett = $this->db->execute_query($strsql, "s", "$cutoff");
        
//        return $rett;
        if ($rett) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Extension for $criteria [$critlist] by $extendby Days Update Completed!", $this::STATUS_PASSED, get_client_ip_env());
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Extension for $criteria [$critlist] by $extendby Days Update failed!", $this::STATUS_FAILED, get_client_ip_env());
            return "Error: Update failed!";
        endif;
    }
    
    
    public function createAdmin($username, $password, $fullname, $email, $mobile, $access, $adminID, $is_enabled=1, $is_readonly=0) {
        $user_exist = $this->verifyAdminExist($username);
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Admin User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Admin User [$username] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Admin User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Admin User [$username] already Exist and Account is Disabled";
        else :
            $ins = "INSERT INTO tbl_admins (USERNAME, `PASSWORD`, FULLNAME, EMAIL, MOBILE, ACCESS_LEVEL,
                            IS_ENABLED, DATE_ADDED, ADDED_BY, `READONLY`) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?)";//echo $ins;echo "<br/>($username, $password, $fullname, $email, $mobile, $access, $adminID, $is_enabled=1, $is_readonly=0)";
            $in_id = $this->db->insert($ins, 'sssssiiii', $username, sha1($password), $fullname, $email,
                            $mobile, $access, $is_enabled, $adminID, $is_readonly);
            if ($in_id) :
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: Admin User [$username] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
                $raw_msg = $this->getCannedMessage("ADMIN_ACCOUNT_CREATION");
                $msg = sprintf($raw_msg, $fullname, $username, $password);
                $sent = $this->sendEmail($email, EMAIL_SENDER, "Account Creation on eService", $msg);
                return "Success: Admin User [$username] Created!";
            else:
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Admin User [$username>", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create Admin User [$username>";
            endif;
        endif;
        
    }
    
    
    public function editAdmin($username, $password="", $fullname="", $email="", $mobile="", $enabled=1, $usergroup=-1, $is_readonly=0) {
        //$user_exist = $this->verifyAdminExist($username);
        $adstr = ""; 
        
        //if ($user_exist == 1 || ($user_exist == 2)) :
            if ($password != ""):
                $adstr .= ", `PASSWORD` = '" . sha1($password) . "'";
            endif;
            if ($usergroup != -1 && is_numeric($usergroup) ): //echo "<$usergroup>";
                $adstr .= ", `ACCESS_LEVEL` = $usergroup";
            endif;
            
            $upd = "UPDATE tbl_admins SET FULLNAME=?, EMAIL=?, MOBILE=?, IS_ENABLED=?, `READONLY`=? $adstr WHERE USERNAME=?"; //echo $upd;
            $rett = $this->db->execute_query($upd, "sssiis", $fullname, $email, $mobile, $enabled, $is_readonly, $username);
            
            if ($rett) :
                echo "Success: Update Completed!";
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Update to Admin [$username] completed", $this::STATUS_PASSED, get_client_ip_env());
            else:
                echo "Error: Update failed!";
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Update to Admin [$username] Failed", $this::STATUS_FAILED, get_client_ip_env());
            endif;
//        else :
//            return "Error: Admin User [$username] does not Exist";        
//        endif;
    }
    
    
    public function setAdminStatus($username, $status=1) {
        if ($status == 0 || $status == 1) :
            $upd = "UPDATE tbl_admins SET IS_ENABLED=? WHERE USERNAME=?";
            $this->db->execute_query($upd, "is", $status, $username);
            
            //verify
            $qry = "SELECT * FROM tbl_admins WHERE USERNAME=? AND IS_ENABLED=?";
            $some_sth = $this->db->select($qry, "si", $username, $status);
            $rows = $some_sth->num_rows();
            if ($rows){
                $this->logTrail($this::INFO, "Admin [$username] status changed to $status", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Status set Successfully";
            } else {
                $this->logTrail($this::INFO, "Error occurred changing Admin [$username] status to $status", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Status Change Failed!";
            }
        else:
            $this->logTrail($this::INFO, "Error occurred changing Admin [$username] status to $status. Invalid Status [$status]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Invalid Status!";
        endif;
        
    }
    
    
    public function setUserStatus($username, $status=1) {
        if ($status == 0 || $status == 1) :
            $upd = "UPDATE tblclients SET IS_ENABLED=? WHERE USERNAME=?";
            $this->db->execute_query($upd, "is", $status, $username);
            
            //verify
            $qry = "SELECT * FROM tblclients WHERE USERNAME=? AND IS_ENABLED=?";
            $some_sth = $this->db->select($qry, "si", $username, $status);
            $rows = $some_sth->num_rows();
            if ($rows) {
                $this->logTrail($this::INFO, "User [$username] status changed to $status", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Status set Successfully";
            } else {
                $this->logTrail($this::INFO, "Error occurred changing User [$username] status to $status", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Status Change Failed!";
            }
        else:
            return "Error: Invalid Status!"; 
        endif;
         
    }
    
    
    public function listServices($package=-1, $is_enabled=-1) { 
        $ret =array();
        
        $ad = "";
        if ($package <> -1 && is_int($package)):
            $ad = " WHERE srvid = $package";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableservice = $is_enabled";
            else
                $ad .= " AND enableservice = $is_enabled";
        endif;
        
        $qry = "SELECT srvid, srvname, limitcomb, limitexpiration, monthly, 
                        enableservice, descr, trafficunitcomb,
                        (SELECT COUNT(PLAN) FROM tbl_plans tp WHERE tp.SRVID=rs.srvid) AS 'NPLANS'
                FROM `rm_services` rs $ad"; //resetcounters, 
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        if ($rows) :
            while ($row = $some_sth->fetch_object()) :
                $ret[$row->srvid] = array("PACKAGE_ID"=>$row->srvid, "PACKAGE"=>$row->srvname, 
                            "LIMITCOMB"=>$row->limitcomb, "LIMIT_EXPIRY"=>$row->limitexpiration, 
                            "MONTHLY"=>$row->monthly, /*"RESET_COUNTER"=>$row->resetcounters,*/ 
                            "IS_ENABLED"=>$row->enableservice, "DESCRIPTION"=>$row->descr, "NPLANS"=> $row->NPLANS, 
                            "DATA_SIZE"=>$row->trafficunitcomb);
            endwhile;
        endif;
        
        
        return $ret;
    }
    
    public function createPlan($plan, $package, $data, $amount, $validity, $description, $adminID, $upcountry) {
        $user_exist = $this->verifyPlanExist($plan, $package);
        
        if ($user_exist == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Plan [$plan] already Exist", $this::STATUS_FAILED, get_client_ip_env());
            return "Error: Plan [$plan] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Plan [$plan] already Exist under selected Package/Service but it is Disabled", $this::STATUS_FAILED, get_client_ip_env());
            return "Error: Plan [$plan] already Exist under selected Package/Service but it is Disabled";
        else :
            $qry = "INSERT INTO tbl_plans (PLAN, SRVID, DATA_VOLUME, AMOUNT, VALIDITY, CAN_SPILLOVER, 
                        DESCRIPTION, IS_ENABLED, DATE_ADDED, ADDED_BY, IS_UPCOUNTRY)
                    VALUES (?, ?, ?, ?, ?, 0, ?, 1, NOW(), ?, ?)";
            $in_id = $this->db->insert($qry, 'siidisii', $plan, $package, $data, $amount, $validity, 
                            $description, $adminID, $upcountry);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Plan [$plan] Created under Selected Service!", $this::STATUS_PASSED, get_client_ip_env());
                return "Success: Plan [$plan] Created under Selected Service!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Plan [$plan]", $this::STATUS_FAILED, get_client_ip_env());
                return "Error: Unable to create Plan [$plan>";
            endif;
        endif;
    }
    
    
    public function editPlan($planid, $plan="", $srvid=0, $data=0, $amount=0, $validity=0, $description="", $enabled=1) {
        //$user_exist = $this->verifyAdminExist($username);
        $adstr = "";
        
        //if ($user_exist == 1 || ($user_exist == 2)) :
            if ($description != ""):
                $adstr .= ", `DESCRIPTION` = '" . $description . "'";
            endif;
            if ($plan != ""):
                $adstr .= ", `PLAN` = '" . $plan . "'";
            endif;
//            if ($srvid != 0):
//                $adstr .= ", `SRVID` = '" . $srvid . "'";
//            endif;
            if ($data >= 0):
                $adstr .= ", `DATA_VOLUME` = '" . $data . "'";
            endif;
            if ($amount != 0):
                $adstr .= ", `AMOUNT` = '" . $amount . "'";
            endif;
            if ($validity != 0):
                $adstr .= ", `VALIDITY` = '" . $validity . "'";
            endif;
            
            $upd = "UPDATE tbl_plans SET IS_ENABLED=? $adstr WHERE PLAN_ID=?"; //echo $upd; exit();
            $rett = $this->db->execute_query($upd, "ii", $enabled, $planid);
            
            if ($rett) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Service/Plan [$plan] Update Completed!", $this::STATUS_PASSED, get_client_ip_env());
                echo "Success: Update Completed!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Service/Plan [$plan] Update failed!", $this::STATUS_FAILED, get_client_ip_env());
                echo "Error: Update failed!";
            endif;
//        else :
//            return "Error: Admin User [$username] does not Exist";        
//        endif;
    }
    
    
    public function loadPlans($package=-1, $plan=0, $is_enabled=-1) {
        $rec = array();
        
        $ad = "";
        if ($package<>-1):
            $ad = " WHERE tp.SRVID = $package";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tp.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tp.IS_ENABLED = $is_enabled";
        endif;
        
        if ($plan > 0) :
            if ($ad == "")
                $ad = " WHERE tp.PLAN_ID = $plan";
            else
                $ad .= " AND tp.PLAN_ID = $plan";
        endif;
        
//        if ($plan <> 0 && $package <> 0) :
        $qry = "SELECT PLAN_ID, PLAN, tp.SRVID, DATA_VOLUME, tp.AMOUNT, tp.VALIDITY, tp.CAN_SPILLOVER, IS_UPCOUNTRY, 
                    tp.DESCRIPTION, tp.IS_ENABLED, tp.DATE_ADDED, tp.ADDED_BY, rs.srvname, rs.descr, tp.PLANCODE
                FROM `tbl_plans` tp 
                LEFT JOIN rm_services rs ON tp.SRVID=rs.srvid 
                $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->PLAN_ID] = array("PLAN_ID"=>$row->PLAN_ID, "PLAN"=>$row->PLAN, "SRVID"=>$row->SRVID, 
                    "DATA"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY, 
                    "CAN_SPILLOVER"=>$row->CAN_SPILLOVER, "PLAN_DESC"=>$row->DESCRIPTION, 
                    "IS_ENABLED"=>$row->IS_ENABLED, "DATE_ADDED"=>$row->DATE_ADDED, "ADDED_BY"=>$row->ADDED_BY,
                    "PACKAGE"=>$row->srvname, "PACKAGE_DESC"=>$row->descr, "PLANCODE"=>$row->PLANCODE,
                    "ODATA"=>formatBytes($row->DATA_VOLUME, 2, FALSE),"DATAV"=>$row->DATA_VOLUME, "IS_UPCOUNTRY"=>$row->IS_UPCOUNTRY);

        }
//        endif;
        
        return $rec;
    }
    
    
    public function loadPlansByHierarchy($package=-1, $is_enabled=-1) {
        $rec = array();
        
        $ad = " WHERE 1=1";
        if (is_int($package) && $package>0):
            // $ad = " WHERE tp.SRVID = $package";
    		$ad .= " AND tp.IS_UPCOUNTRY = (SELECT IS_UPCOUNTRY FROM tbl_plans WHERE SRVID=$package)
				AND tp.HIERARCHY > (SELECT HIERARCHY FROM tbl_plans WHERE SRVID=$package)";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
             $ad .= " AND tp.IS_ENABLED = $is_enabled";
        endif;
        
        $qry = "SELECT PLAN_ID, PLAN, tp.SRVID, DATA_VOLUME, tp.AMOUNT, tp.VALIDITY, tp.CAN_SPILLOVER, IS_UPCOUNTRY, HIERARCHY, 
                    tp.DESCRIPTION, tp.IS_ENABLED, tp.DATE_ADDED, tp.ADDED_BY, rs.srvname, rs.descr, tp.PLANCODE
                FROM `tbl_plans` tp 
                LEFT JOIN rm_services rs ON tp.SRVID=rs.srvid 
                $ad ORDER BY HIERARCHY"; //echo $qry;
        $some_sth = $this->db->select($qry);
        // $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->PLAN_ID] = array("PLAN_ID"=>$row->PLAN_ID, "PLAN"=>$row->PLAN, "SRVID"=>$row->SRVID, 
                    "DATA"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY, 
                    "CAN_SPILLOVER"=>$row->CAN_SPILLOVER, "PLAN_DESC"=>$row->DESCRIPTION, "HIERARCHY"=>$row->HIERARCHY,
                    "IS_ENABLED"=>$row->IS_ENABLED, "DATE_ADDED"=>$row->DATE_ADDED, "ADDED_BY"=>$row->ADDED_BY,
                    "PACKAGE"=>$row->srvname, "PACKAGE_DESC"=>$row->descr, "PLANCODE"=>$row->PLANCODE,
                    "ODATA"=>formatBytes($row->DATA_VOLUME, 2, FALSE),"DATAV"=>$row->DATA_VOLUME, "IS_UPCOUNTRY"=>$row->IS_UPCOUNTRY);
					
        }
//        endif;
        
        return $rec;
    }
    
    
    public function loadPlanFromName($package, $plan=0, $is_enabled=-1) {
        $rec = array();
        
        $ad = "";
        if ($package<>""):
            $ad = " WHERE rs.srvname LIKE '$package'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tp.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tp.IS_ENABLED = $is_enabled";
        endif;
        
        if ($plan > 0) :
            if ($ad == "")
                $ad = " WHERE tp.PLAN_ID = $plan";
            else
                $ad .= " AND tp.PLAN_ID = $plan";
        endif;
        
//        if ($plan <> 0 && $package <> 0) :
        $qry = "SELECT PLAN_ID, PLAN, tp.SRVID, DATA_VOLUME, tp.AMOUNT, tp.VALIDITY, tp.CAN_SPILLOVER, 
                    tp.DESCRIPTION, tp.IS_ENABLED, tp.DATE_ADDED, tp.ADDED_BY, rs.srvname, rs.descr, tp.PLANCODE
                FROM `tbl_plans` tp 
                LEFT JOIN rm_services rs ON tp.SRVID=rs.srvid 
                $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec = array("PLAN_ID"=>$row->PLAN_ID, "PLAN"=>$row->PLAN, "SRVID"=>$row->SRVID, 
                    "DATA"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY, 
                    "CAN_SPILLOVER"=>$row->CAN_SPILLOVER, "PLAN_DESC"=>$row->DESCRIPTION, 
                    "IS_ENABLED"=>$row->IS_ENABLED, "DATE_ADDED"=>$row->DATE_ADDED, "ADDED_BY"=>$row->ADDED_BY,
                    "PACKAGE"=>$row->srvname, "PACKAGE_DESC"=>$row->descr, "PLANCODE"=>$row->PLANCODE,
                    "ODATA"=>formatBytes($row->DATA_VOLUME, 2, FALSE),"DATAV"=>$row->DATA_VOLUME);

        }
//        endif;
        
        return $rec;
    }
    
    
    public function setPlanStatus($plan, $status=1) {
        if ($status == 0 || $status == 1) :
            $upd = "UPDATE tbl_plans SET IS_ENABLED=? WHERE PLAN_ID=?";
            $this->db->execute_query($upd, "ii", $status, $plan);
            
            //verify
            $qry = "SELECT * FROM tbl_plans WHERE PLAN_ID=? AND IS_ENABLED=?";
            $some_sth = $this->db->select($qry, "si", $plan, $status);
            $rows = $some_sth->num_rows();
            if ($rows) {
                $this->logTrail($this::INFO, "Plan [$plan] status changed to $status", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Status set Successfully";
            } else {
                $this->logTrail($this::INFO, "Error occurred changing Plan [$plan] status to $status", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Status Change Failed!";
            }
        else:
            $this->logTrail($this::INFO, "Error occurred changing Plan [$plan] status to $status. Invalid Status", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Invalid Status!";
        endif;
        
    }
    
    public function saveExpirationLog($username, $fullname, $expiration) {
        $qry = "INSERT INTO tbl_expirationlog (USERNAME, CLIENTNAME, EXPIRATIONDATE, SENDDATE)
                    VALUES (?, ?, ?, NOW())";
        $in_id = $this->db->insert($qry, 'sss', $username, $fullname, $expiration);
        if ($in_id) :
            return "Success: Log Saved!";
        else:
            return "Error: Unable to save Log";
        endif;
    }
    
    public function saveLowDataLog($username, $databal) {
        $qry = "INSERT INTO tbl_lowdatalog (USERNAME, DATA_LEFT, SENDDATE)
                    VALUES (?, ?, NOW())";
        $in_id = $this->db->insert($qry, 'ss', $username, $databal);
        if ($in_id) :
            return "Success: Log Saved!";
        else:
            return "Error: Unable to save Log";
        endif;
    }
    
    public function createRelocationRequest($username, $phone, $email, $old_addy, $new_addy) {
        $qry = "INSERT INTO tbl_relocation_request (USERNAME, PHONE, EMAIL, OLD_ADDRESS, NEW_ADDRESS, REQUESTDATE)
                    VALUES (?, ?, ?, ?, ?, NOW())";
        $in_id = $this->db->insert($qry, 'sssss', $username, $phone, $email, $old_addy, $new_addy);
        if ($in_id) :
            return 1;
        else:
            return 0;
        endif;
    }
    
    public function getRelocationRequest($username="") {
        $rec = array(); $ad = "";
        if ($username !== ""){
            $user = mysqli_real_escape_string($this->db, $username);
            $ad = " AND USERNAME = '$user'";
        }
        $qry = "SELECT USERNAME, PHONE, EMAIL, OLD_ADDRESS, NEW_ADDRESS, REQUESTDATE, TREATED, DATE_TREATED "
                . " FROM tbl_relocation_request WHERE 1 $ad";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "PHONE"=>$row->PHONE, 
                        "EMAIL"=> $row->EMAIL, "OLD_ADDRESS"=>$row->OLD_ADDRESS,
                        "REQUESTDATE"=> $row->REQUESTDATE, "TREATED"=> $row->TREATED,
                        "DATE_TREATED" => $row->DATE_TREATED);
        }
        
        return $rec;
    }
    
    public function getPlanSwitchHistory($username="") {
        $rec = array(); $ad = "";
        if ($username !== ""){
            $user = mysqli_real_escape_string($this->db, $username);
            $ad = " AND username = '$user'";
        }
        $qry = "SELECT username, newsrvid, newsrvname, requestdate "
                . " FROM rm_changesrv WHERE 1 $ad ORDER BY requestdate DESC";
        $some_sth = $this->db->select($qry);
        $i = -1;
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->username, "NEW_PACKAGE_ID"=>$row->newsrvid, 
                        "NEW_PACKAGE"=> $row->newsrvname, "REQUESTDATE"=>$row->requestdate,
                        "REQUESTDATE_FORMAT"=> date("jS M, Y", strtotime($row->requestdate)),
                        "OLD_PACKAGE"=>'N/A');
            if (++$i > 0) {
                $rec[$i-1]["OLD_PACKAGE"] = $rec[$i]["NEW_PACKAGE"];
            }
        }
        
        return $rec;
    }
    
    
    public function getExpiringAccounts($days2expiry=0, $is_upcountry=-1) {
        $rec = array(); $ad = "";
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $ad = " AND ru.username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
        }
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND ? $ad
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND ? $ad
                ";
        $some_sth = $this->db->select($qry, "ii", $days2expiry, $days2expiry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "EXPIRATION" => $row->expiration);

        }
        
        return $rec;
    }
    
    
    public function getExpiringAccountsByDate($edate='', $is_upcountry=-1) { 
        $edate = ($edate == '')? date("Y-m-d") : $edate;  $ad = "";
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $ad = " AND ru.username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
        }
        $qry = "SELECT count(username) AS NFREQ 
                    FROM rm_users ru
                WHERE enableuser=1 AND date(expiration) =?  $ad ";
        $some_sth = $this->db->select($qry, "s", $edate);
        $row = $some_sth->fetch_object();
            
        return $row->NFREQ;
    }
    
    
    public function getExpiredAccounts($daysAgo=0) {
        $rec = array();
        $add = (is_int($daysAgo) && ($daysAgo > 0) )? "AND DATEDIFF(NOW(), expiration) BETWEEN 0 AND $daysAgo" : "";        
        
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND expiration <= NOW() AND enableuser=1
		AND tc.USERNAME NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8 UNION SELECT USERNAME FROM tbl_comp_account) $add
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND expiration <= NOW() AND enableuser=1
		AND tc.USERNAME NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8 UNION SELECT USERNAME FROM tbl_comp_account) $add
                ";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "EXPIRATION" => $row->expiration);

        }
        
        return $rec;
    }
    
    
    public function getExpiredAccountsv1($daysAgo=0, $is_upcountry=-1) {
        $rec = $inarr = array(); $mad = '';
//        $add = (is_int($daysAgo) && ($daysAgo > 0) )? "AND DATEDIFF(NOW(), expiration) BETWEEN 0 AND $daysAgo" : ""; 
//        $add = (is_int($daysAgo) && ($daysAgo > 0) )? " AND
//((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$daysAgo AND 0 ) " : " AND
        $qrylst = "SELECT USERNAME FROM tbl_comp_account";
        $some_st = $this->db->select($qrylst);
    	while ($roww = $some_st->fetch_object()) {
            $inarr[] = $roww->USERNAME;
        }
        $qrylst = "SELECT RAD_USERNAME FROM tblclients WHERE USERTYPE=8";
        $some_s = $this->db->select($qrylst);
    	while ($rowww = $some_s->fetch_object()) {
            $inarr[] = $rowww->RAD_USERNAME;
        }
        $qrylst = "SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1";
        $some_s = $this->db->select($qrylst);
    	while ($rowww = $some_s->fetch_object()) {
            $inarr[] = $rowww->USERNAME;
        }
        $userlist = "'" . implode("', '", array_unique($inarr)) . "'";
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $mad = " WHERE username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
        }
        
        $add = (is_int($daysAgo) && ($daysAgo > 0) )? " AND
( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                                        ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$daysAgo AND 0 ) )
            		      OR 
            		      ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$daysAgo AND 0 ) )
                                OR
                                ( (IF (limitcomb = 1, comblimit -
                                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                                FROM radacct WHERE radacct.username = tmp.username) +
                                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$daysAgo AND 0 ) )
                                OR 
                                ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$daysAgo AND 0 ) )
                                OR 
                                IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -$daysAgo AND 0 ) " : " AND
         		      (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0) ";
        
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND expiration <= NOW() AND enableuser=1
		AND tc.USERNAME NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8) $add
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND expiration <= NOW() AND enableuser=1
		AND tc.USERNAME NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8) $add
                ";
        $qry = "SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, expiration, uptimelimit, credits, comment,
  	    enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm, LEFT(lastlogoff, 10)
                          
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1 AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
	    AND tmp.enableuser = 1 
AND username NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8) $add	    
	    ORDER BY expiration DESC ";
        $qry = "SELECT COUNT(username) AS 'NNO'
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
							INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid) $mad
            ) AS tmp
            WHERE 1
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
	    AND tmp.enableuser = 1 
            AND username NOT IN ($userlist) $add"; // echo $qry;
        $some_sth = $this->db->select($qry);
        // $rows = $some_sth->num_rows();
    	$row = $some_sth->fetch_object();
        // return $rows;
        return $row->NNO;
//        while ( $row = $some_sth->fetch_object() ) {
//            $rec[] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
//                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->username, 
//                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
//                        "EXPIRATION" => $row->expiration);
//
//        }
//        
//        return $rec;
    }
    
    
    public function getExpiredAccountsGrouping($grouping="srvname") {
        $ret = $rec = $inarr = [];
        
        if (!in_array($grouping, ["srvname", "AREA_NAME", "OLT_NAME"]) ) {
            return [];
        }
        
        $qrylst = "SELECT USERNAME FROM tbl_comp_account";
        $some_st = $this->db->select($qrylst);
    	while ($roww = $some_st->fetch_object()) {
            $inarr[] = $roww->USERNAME;
        }
        $qrylst = "SELECT RAD_USERNAME FROM tblclients WHERE USERTYPE=8";
        $some_s = $this->db->select($qrylst);
    	while ($rowww = $some_s->fetch_object()) {
            $inarr[] = $rowww->RAD_USERNAME;
        }
        $qrylst = "SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1";
        $some_s = $this->db->select($qrylst);
    	while ($rowww = $some_s->fetch_object()) {
            $inarr[] = $rowww->USERNAME;
        }
        $userlist = "'" . implode("', '", array_unique($inarr)) . "'";
        
        $totcust = $tot = $tot30 = $tot60 = $totmore = 0;
        
        $qry = "SELECT (CASE WHEN ($grouping, $grouping) <> ('', NULL) THEN $grouping ELSE 'UNCLASSIFIED' END) AS 'mgrp', COUNT(username) AS 'No'
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
							INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
	    
	    AND tmp.enableuser = 1 
	    GROUP BY $grouping
	    ORDER BY $grouping ASC";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->mgrp]["cust"] = $row->No;
        }
        
        $qry = "SELECT (CASE WHEN ($grouping, $grouping) <> ('', NULL) THEN $grouping ELSE 'UNCLASSIFIED' END) AS 'mgrp', COUNT(username) AS 'No'
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
							INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
	    AND username NOT IN ($userlist)
	    AND tmp.enableuser = 1 
            AND
                (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                OR 
                IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                OR
                IF (limitcomb = 1, comblimit -
                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) +
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                OR 
                IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                OR 
                IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
	    GROUP BY $grouping
	    ORDER BY $grouping ASC";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->mgrp]["mexp"] = $row->No;
        }
        
        //30 days
        $qry="SELECT (CASE WHEN ($grouping, $grouping) <> ('', NULL) THEN $grouping ELSE 'UNCLASSIFIED' END) AS 'mgrp', COUNT(username) AS 'No'               
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
							INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1
    
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
		AND username NOT IN ($userlist)
	    AND tmp.enableuser = 1 
            AND      (
		( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
                OR 
                ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                  FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                  FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
                  OR
                  ( (IF (limitcomb = 1, comblimit -
                  (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                  FROM radacct WHERE radacct.username = tmp.username) +
                  (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                  FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
                  OR 
                  ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                  FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                  FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
                  OR 
                  IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -30 AND 0 )
	    
	    GROUP BY $grouping
	    ORDER BY $grouping ASC";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->mgrp]["m30"] = $row->No;
        }
        
        //60 days
        $qry="SELECT (CASE WHEN ($grouping, $grouping) <> ('', NULL) THEN $grouping ELSE 'UNCLASSIFIED' END) AS 'mgrp', COUNT(username) AS 'No'               
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
							INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1
    
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
		AND username NOT IN ($userlist)
	    AND tmp.enableuser = 1 
            AND      (
		( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND 0 ) )
                OR 
                ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                  FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                  FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND 0 ) )
                  OR
                  ( (IF (limitcomb = 1, comblimit -
                  (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                  FROM radacct WHERE radacct.username = tmp.username) +
                  (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                  FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND 0 ) )
                  OR 
                  ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                  FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                  FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND 0 ) )
                  OR 
                  IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -60 AND 0 )
	    
	    GROUP BY $grouping
	    ORDER BY $grouping ASC";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->mgrp]["m60"] = $row->No;
        }
        
        foreach ($rec as $key => $value) {
            $ret[] = ["GROUPING"=>$key,  "ALL_CUSTOMERS"=>number_format($value["cust"]), "ALL_EXPIRED"=>number_format($value["mexp"]), "WITHIN_30DAYS"=>number_format($value["m30"]), 
                        "WITHIN_30_60DAYS"=>number_format($value["m60"]-$value["m30"]), "BEYOND_60DAYS"=>number_format($value["mexp"]-$value["m60"])];
            $totcust += $value["cust"]; $tot += $value["mexp"]; $tot30 += $value["m30"]; $tot60 += $value["m60"]-$value["m30"]; $totmore += $value["mexp"]-$value["m60"];
        }
        $ret[] = ["GROUPING"=>"<strong>TOTAL</strong>", "ALL_CUSTOMERS"=>"<strong>".number_format($totcust)."</strong>", "ALL_EXPIRED"=>"<strong>".number_format($tot)."</strong>", 
                        "WITHIN_30DAYS"=>"<strong>".number_format($tot30)."</strong>", 
                        "WITHIN_30_60DAYS"=>"<strong>".number_format($tot60)."</strong>", "BEYOND_60DAYS"=>"<strong>".number_format($totmore)."</strong>"];
        return $ret;
        
    }
    
    
    public function getExpiredAccountsRangev1($timeline="", $area=0, $olt=0, $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len=50) {
        $rec = $inarr =array();
//        $add = (is_int($daysAgo) && ($daysAgo > 0) )? "AND DATEDIFF(NOW(), expiration) BETWEEN 0 AND $daysAgo" : "";   
        $qrylst = "SELECT USERNAME FROM tbl_comp_account";
        $some_st = $this->db->select($qrylst);
    	while ($roww = $some_st->fetch_object()) {
            $inarr[] = $roww->USERNAME;
        }
        $qrylst = "SELECT RAD_USERNAME FROM tblclients WHERE USERTYPE=8";
        $some_s = $this->db->select($qrylst);
    	while ($rowww = $some_s->fetch_object()) {
            $inarr[] = $rowww->RAD_USERNAME;
        }
        $qrylst = "SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1";
        $some_s = $this->db->select($qrylst);
    	while ($rowww = $some_s->fetch_object()) {
            $inarr[] = $rowww->USERNAME;
        }
        $userlist = "'" . implode("', '", array_unique($inarr)) . "'";
        
        if ($timeline === "<=30"):
             $add = " AND
( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
            OR 
            ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
              OR
              ( (IF (limitcomb = 1, comblimit -
              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) +
              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
              OR 
              ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -30 AND 0 ) )
              OR 
              IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -30 AND 0 )";
        elseif ($timeline === "31-60"):
            $add = " AND
( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND -31 ) )
            OR 
            ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND -31 ) )
              OR
              ( (IF (limitcomb = 1, comblimit -
              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) +
              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND -31 ) )
              OR 
              ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
              ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -60 AND -31 ) )
              OR 
              IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -60 AND -31 )";
        elseif ($timeline === ">60"):
            $add = " AND
( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
            ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) < -60 ) )
            OR 
            ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
            FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
            FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
            ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) < -60 ) )
            OR
            ( (IF (limitcomb = 1, comblimit -
            (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
            FROM radacct WHERE radacct.username = tmp.username) +
            (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
            FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
            ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) < -60 ) )
            OR 
            ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
            FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
            FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
            ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) < -60) )
            OR 
            IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) < -60 )";
        else:
            $add = " AND
                    (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                    FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                    FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                    OR 
                    IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                    FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                    FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                    OR
                    IF (limitcomb = 1, comblimit -
                    (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                    FROM radacct WHERE radacct.username = tmp.username) +
                    (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                    FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                    OR 
                    IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                    FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                    FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                    OR 
                    IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0) ";
        endif;
        
        $add .= (is_int($area) && ($area > 0) )? " AND AREA_ID = $area " : "";
        $add .= (is_int($olt) && ($olt > 0) )? " AND OLT_ID = $olt " : "";
//        if ($searchval <> "") :
//            $searchval = mysqli_real_escape_string($this->db, $searchval);
//            $add .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR username LIKE '%$searchval%' OR PLAN_NAME = '$searchval') ";
//        endif;
        
        $qry = "SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, expiration, uptimelimit, credits, comment,
  	    enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
			INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID
                          
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
			INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID
              FROM tbl_user_extend ru 
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1 AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
            AND username NOT IN ($userlist)
	    AND tmp.enableuser = 1 $add	    
	     ";  // echo $qry;
        // AND username NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8)
//        $some_sth = $this->db->select($qry);
        // $rows = $some_sth->num_rows();
//    	$row = $some_sth->fetch_object();
        
        $mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_user_extend ";
        $some_st = $this->db->select($mqry1); 
    	// new
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; // $some_st->num_rows();
        if ($add==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$qry";  // "$mqry WHERE 1 $ad"; 
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows(); // $rec->TOTAL; // $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY expiration DESC";
        $qry = "$qry $msort $limit";
        $some_sth = $this->db->select($qry);
        
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
//            $curDate = date('Y-m-d H:i:s');
//            $daysLeft = (strtotime($curDate) - strtotime($row->expiration));
            $ret[] = array("USERNAME"=>$row->username, "SERVICE"=>$row->srvname, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=>$row->lastname, "COMPANY"=>$row->company, "ADDRESS"=>$row->address, "CITY"=>$row->city, "STATE"=>$row->state, 
                        "EXPIRATION"=>date( 'd-m-Y', strtotime($row->expiration)),
                         "IP"=>$row->staticipcpe, "EMAIL"=>$row->email,
                        "PHONE"=>$row->mobile, "REGDATE"=>date( 'd-m-Y', strtotime($row->createdon)), "LASTLOGOFF"=>date( 'd-m-Y H:i:s', strtotime($row->lastlogoff)),
                        "AREA"=>$row->AREA_NAME, "REGION"=>$row->REGION_NAME, "OLT"=>$row->OLT_NAME, 
                     	"GPON"=>$row->GPON_NAME, "INTERFACE"=>$row->INTERFACE, "SERIALNO"=>$row->SERIALNO, "VLAN"=>$row->VLAN );
        }
        
        return $ret;
    }
    
   public function getPendingAccounts($is_upcountry=-1) {
        $rec = array(); $mad = '';
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $mad = " AND ru.username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
        }
        
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE (tc.IS_ENABLED=1 AND enableuser IN (0,1) )
		AND tc.USERNAME IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8) $mad
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE (tc.IS_ENABLED=1 AND enableuser IN (0,1) )
		AND tc.USERNAME IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8) $mad
                ";
        // WHERE tc.IS_ENABLED=1 AND enableuser=1
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "EXPIRATION" => $row->expiration);

        }
        
        return $rec;
    }
    
    public function getPausedAccounts($is_upcountry=-1) { 
        $rec = array(); $mad = '';
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $mad = " AND ru.username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
        }
        
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND enableuser=0
                AND tc.USERNAME IN (SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1) $mad
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND enableuser=0
		AND tc.USERNAME IN (SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1) $mad
                ";
//		AND tc.USERNAME NOT IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8)
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "EXPIRATION" => $row->expiration);

        }
        
        return $rec;
    }
    
    public function getExpirationDate($raduser) {
        $exp = "";
        $qry = "SELECT expiration FROM rm_users WHERE username = ?";
        $some_sth = $this->db->select($qry, "s", $raduser);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp = $row->expiration;
        }
        
        return $exp;
    }
    
    
    public function getAnniversaryAccounts() {
        $rec = array();
        $qry = "SELECT ru.username, lastname, firstname, createdon, YEAR(createdon) AS 'YEAR_JOINED', (YEAR(NOW())-YEAR(createdon)) AS 'NYRS', email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND DAY(createdon)=DAY(NOW()) AND MONTH(createdon)=MONTH(NOW())
                AND createdon<>DATE(NOW())
                UNION
                SELECT ru.username, lastname, firstname, createdon, YEAR(createdon) AS 'YEAR_JOINED', (YEAR(NOW())-YEAR(createdon)) AS 'NYRS', email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND DAY(createdon)=DAY(NOW()) AND MONTH(createdon)=MONTH(NOW())
                AND createdon<>DATE(NOW())
                ";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "CREATEDON"=> $row->createdon,
                        "YEAR_JOINED" => $row->YEAR_JOINED, "NYRS" => $row->NYRS);
        }
        
        return $rec;
    }
    
    public function logPayDirectReversal($param) {
        //$txnid = $param["TRANX_ID"];
        
        //check if reversal has already been logged
        $qry = "SELECT * FROM tbl_tranx_reversal WHERE TRANX_ID=?";
        $some_sth = $this->db->select($qry, "s", $param["TRANX_ID"]);
        $rows = $some_sth->num_rows();
        
        if ($rows < 1) :
            //Log Record
            $keys = implode(", ", array_keys($param));
            $qry = "INSERT INTO tbl_tranx_reversal (TRANX_ID, RAD_USERNAME, PAY_REFERENCE, ORIGINAL_PAY_REFERENCE, 
                        RET_REF_NO, ORIGINAL_RET_REF_NO, APPR_AMOUNT) 
                 VALUES(?, ?, ?, ?, ?, ?, ?)";
            $saved = $this->db->insert($qry, "ssssssd", $param["TRANX_ID"], $param["RAD_USERNAME"], 
                            $param["PAY_REFERENCE"], $param["ORIGINAL_PAY_REFERENCE"], $param["RET_REF_NO"], 
                            $param["ORIGINAL_RET_REF_NO"], $param["APPR_AMOUNT"]);
            $this->logTrail($this::PAYMENT, "Transaction [{$param['TRANX_ID']}] reversed", $this::STATUS_PASSED, get_client_ip_env()); 
            if ($saved > 0)
                return 1;
            else
                return 0;
        endif;
    }
    
    
    public function renewSubscription($raduser, $data_volume, $limitcomb, 
            $expiration, $tranx_id="", $is_expd=1) {
        $done = 0;
        
        $up = $down = $tot = $ntot = 0;
        $qry = "SELECT
                (SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ?) AS 'DOWN',
                (SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ?) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ?) AS 'COMB'";
        $some_sth = $this->db->select($qry, "sssss", $raduser, $raduser, $raduser, $raduser, $raduser);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $down = $row->DOWN;
            $up = $row->UP;
            $diff = ($row->COMB - ($down + $up));
            $combb = ( $diff<0 )? ($row->COMB+($diff * -1)) : ($row->COMB) ;
            $tot = ($is_expd)? ($down + $up) : ($combb);
        }
        
        $chk = "SELECT DB_UPDATED FROM tbl_tranx WHERE TRANX_ID=? AND DB_UPDATED=1";
        $crett = $this->db->select($chk, "s", $tranx_id);
        if ($crett->num_rows()) {
            return 1;
        }
        
        $ntot = ($limitcomb)? ($tot + $data_volume) : $tot;
        $renewData = bytes($data_volume, "GiB", '%01.2f %s');
        $expiry_date = date("d-M-Y H:i:s", strtotime($expiration));
        
        $upd = "UPDATE rm_users SET uplimit = '$up', downlimit = '$down', comblimit = '$ntot', expiration=?
                WHERE username = ?";
        $rett = $this->db->execute_query($upd, "ss", $expiration, $raduser);
        if ($rett) :
            $done = 1;
            $upd = "UPDATE tbl_tranx SET DB_UPDATED=1 WHERE TRANX_ID=?";
            $rett = $this->db->execute_query($upd, "s", $tranx_id);
            $this->logTrail($this::RENEWAL_AUTO, "({$_SESSION[$this->sid.'username']} attempt) Success: Auto Renewal of User $raduser completed! Data Added: $renewData; New Expiry Date: $expiry_date", $this::STATUS_PASSED, get_client_ip_env()); 
        else:
            $this->logTrail($this::RENEWAL_AUTO, "({$_SESSION[$this->sid.'username']} attempt) Error: Auto Renewal of User $raduser Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
        endif;
        
        return $done;
    }
    
    
    public function renewSubscriptionManual($raduser, $data_volume, $limitcomb, 
            $expiration, $tranx_id="", $adminUser="", 
            $is_extend_only=0, $is_expd=1) {
        $done = 0;
        
        $up = $down = $tot = $ntot = 0;
        $qry = "SELECT
                (SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ?) AS 'DOWN',
                (SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ?) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ?) AS 'COMB'";
        $some_sth = $this->db->select($qry, "sssss", $raduser, $raduser, $raduser, $raduser, $raduser);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $down = $row->DOWN;
            $up = $row->UP;
//            $tot = $down + $up;
            $diff = ($row->COMB - ($down + $up));
            $combb = ( $diff<0 )? ($row->COMB+($diff * -1)) : ($row->COMB) ;
            $tot = ($is_expd)? ($down + $up) : ($combb);
        }

        $ext = ($is_extend_only)? "Extension" : "Renewal";
        
        $ntot = ($limitcomb)? ($tot + $data_volume) : $tot;
        
        $renewData = bytes($data_volume, "GiB", '%01.2f %s');
        $expiry_date = date("d-M-Y H:i:s", strtotime($expiration));
        
        $upd = "UPDATE rm_users SET uplimit = '$up', downlimit = '$down', comblimit = '$ntot', expiration=?
                WHERE username = ?";
        $rett = $this->db->execute_query($upd, "ss", $expiration, $raduser);
        if ($rett) :
            $done = 1;
            if ($tranx_id != ""):
                $upd = "UPDATE tbl_tranx SET DB_UPDATED=1 WHERE TRANX_ID=?";
                $rett = $this->db->execute_query($upd, "s", $tranx_id);
            endif;
            $this->logTrail($this::RENEWAL_MANUAL, "($adminUser attempt) Success: Manual $ext of User $raduser completed by $adminUser! Data Added: $renewData; New Expiry Date: $expiry_date", $this::STATUS_PASSED, get_client_ip_env()); 
        else:
            $this->logTrail($this::RENEWAL_MANUAL, "($adminUser attempt) Error: Manual $ext of User $raduser by $adminUser Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
        endif;
        
        return $done;
    }
    
    
    public function logManualRenewal($raduser, $exp_date, $nu_exp_date, $data, $extendonly, $admin) {
        
        $qry = "INSERT INTO tbl_manrenewal (RAD_USERNAME, EXPIRY_DATE, NEW_EXPIRY_DATE, 
                    ADDED_DATA, EXTEND_ONLY, ADMIN, DATEDONE) 
                 VALUES(?, ?, ?, ?, ?, ?, NOW())";
        $saved = $this->db->insert($qry, "ssssii", $raduser, $exp_date, $nu_exp_date, $data, $extendonly, $admin);
        
        if ($saved > 0)
            return 1;
        else
            return 0;
    }
    
    
     
    public function loadUserDet4Update($radusername)  {
        $ret = array();
       $qry = "SELECT ru.username, expiration, ru.srvid, rs.srvname, tp.PLAN_ID, tp.PLAN, 
                    tp.DATA_VOLUME, tp.AMOUNT, tp.VALIDITY, rs.limitcomb, firstname, lastname, email
                FROM rm_users ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
		LEFT JOIN tbl_plans tp ON rs.srvid = tp.SRVID
                WHERE username LIKE ?"; 
       $some_sth = $this->db->select($qry, 's', $radusername);
       $rows = $some_sth->num_rows();
       while ($row = $some_sth->fetch_object()):
           $ret = array("RAD_USERNAME"=>$row->username, "EXPIRATION"=>$row->expiration, "SRVID"=>$row->srvid,
                        "SERVICE"=>$row->srvname, "PLAN"=>$row->PLAN, "PLAN_ID"=>$row->PLAN_ID, "EMAIL"=>$row->email,
                        "DATA_VOLUME"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY,
                        "LIMITCOMB"=>$row->limitcomb, "FULLNAME"=>$row->firstname." ".$row->lastname);
       endwhile;

       return $ret;
    }
    
    
    public function saveInitTranx($tranx_id, $raduser, $exp_date, $amt, $curr, $nmonths=1, $plan_id=0) {
        $ddate = date("Y-m-d H:i:s");
        $qry = "INSERT INTO tbl_tranx (TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, NMONTHS, PLAN_ID) 
                 VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
        $saved = $this->db->insert($qry, "sssdssii", $tranx_id, $raduser, $exp_date, $amt, $curr, $ddate, $nmonths, $plan_id);
        $this->logTrail($this::PAYMENT, "Transaction [$tranx_id] for =N=$amt initiated for user [$raduser]; ", $this::STATUS_PASSED, get_client_ip_env()); 
        if ($saved > 0)
            return 1;
        else
            return 0;
    }
    
    
    public function saveTranxResp($tranx_id, $pay_ref, $amt, $curr, $status_code, $status_msg, $nu_expd, $pdate, $gway_name, $app_date, $cardno, $retrefno, $receiptno="", $raduser="") {
        $done = 0;
        $upd = "UPDATE tbl_tranx SET PAY_REFERENCE=?, APPR_AMOUNT=?, APPR_CURRENCY=?, STATUS_CODE=?,
                STATUS_MSG=?, NU_EXPIRY_DATE=?, PAY_DATE=?, PAY_GATEWAY=?, APPR_DATE=?, CARDNO=?, RET_REF_NO=?, RECEIPT_NO=?
                WHERE TRANX_ID=?";
        $rett = $this->db->execute_query($upd, "sdsssssssssss", $pay_ref, $amt, $curr, $status_code, 
                                        $status_msg, $nu_expd, $pdate, $gway_name, $app_date, $cardno, $retrefno, $receiptno, $tranx_id);
        $this->logTrail($this::PAYMENT, "Transaction [$tranx_id] for =N=$amt response for user [$raduser]; STATUS: $status_msg; GW: $gway_name; PAY_DATE: $pdate", $this::STATUS_PASSED, get_client_ip_env()); 
        if ($rett) $done = 1;
        
        return $done;
    }
    
    
    public function saveInvoiceTranxResp($tranx_id, $paid, $pay_ref, $amt, $curr, $status_code, $status_msg, $pdate, $gway_name, $app_date, $cardno, $raduser="") {
        $done = 0;
        $upd = "UPDATE tbl_install_invoice SET PAY_REFERENCE=?, APPR_AMOUNT=?, APPR_CURRENCY=?, STATUS_CODE=?,
                STATUS_MSG=?, DATEPAID=?, PAY_GATEWAY=?, APPR_DATE=?, CARDNO=?, PAID=?
                WHERE ORDERNO=?";
        $rett = $this->db->execute_query($upd, "sdsssssssis", $pay_ref, $amt, $curr, $status_code, 
                                        $status_msg, $pdate, $gway_name, $app_date, $cardno, $paid, $tranx_id);
        $this->logTrail($this::PAYMENT, "INVOICE PAYMENT [$tranx_id] for =N=$amt response for user [$raduser]; STATUS: $status_msg; GW: $gway_name; PAY_DATE: $pdate", $this::STATUS_PASSED, get_client_ip_env()); 
        $upd2 = "UPDATE tbl_erpdata SET PAID_INVOICE=? WHERE RAD_USERNAME=?";
        $rt = $this->db->execute_query($upd2, "is", $paid, $raduser);
        if ($rett) $done = 1;
        
        return $done;
    }
    
    
    public function getTranx4Verification($tranx_id) {
        $exp = array();
        $qry = "SELECT TRANX_ID, tx.RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, tp.IS_UPCOUNTRY, STATUS_MSG,
                    REQUEST_DATE, NMONTHS, STATUS_CODE, DB_UPDATED, tep.ERPID, rs.srvname, tp.ERP_CODE, PAY_REFERENCE 
                 FROM tbl_tranx tx 
                 LEFT JOIN tbl_erp tep ON tx.RAD_USERNAME=tep.RAD_USERNAME
                 LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                 LEFT JOIN rm_services rs ON ru.srvid=rs.srvid
                 LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                 WHERE TRANX_ID = ?";
        $some_sth = $this->db->select($qry, "s", $tranx_id);
        //$rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, "IS_UPCOUNTRY"=>$row->IS_UPCOUNTRY,
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "REQ_CURRENCY"=>$row->REQ_CURRENCY, "REQUEST_DATE"=>$row->REQUEST_DATE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "NMONTHS"=>$row->NMONTHS, "STATUS_CODE" => $row->STATUS_CODE, "ERP_CODE" => $row->ERP_CODE,
                        "DB_UPDATED"=>$row->DB_UPDATED, "ERPID"=>$row->ERPID, "PACKAGE"=>$row->srvname, "PAY_REFERENCE"=>$row->PAY_REFERENCE);
        }
        
        return $exp;
    }
    
    
    public function getOrderNoByID($erp_orderid) {
        $qry = "SELECT ORDERNO FROM tbl_install_invoice WHERE ORDER_ERPID = ?";
        $some_sth = $this->db->select($qry, "i", $erp_orderid);
        //$rows = $some_sth->num_rows();
        $row = $some_sth->fetch_object();
        
        return $row->ORDERNO;
    }
    
    
    public function getInvoice4Verification($tranx_id) {
        $exp = array();
        $qry = "SELECT INVID, ORDERNO, ORDER_ERPID, ORDERNO AS TRANX_ID, tii.RAD_USERNAME, DATE(NOW()) AS EXPIRY_DATE, INVOICE_TOTAL, PAID,
                        INVOICE_TOTAL AS REQ_AMOUNT, INVOICEDATE, INVOICEDATE AS REQUEST_DATE, 1 AS NMONTHS, STATUS_CODE, tep.ERPID	 
               FROM tbl_install_invoice tii 
                 LEFT JOIN tbl_erp tep ON tii.RAD_USERNAME=tep.RAD_USERNAME
                 WHERE ORDERNO = ?";
        $some_sth = $this->db->select($qry, "s", $tranx_id);
        //$rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp = array("TRANS_ID"=>$row->TRANX_ID, "ORDERNO"=>$row->ORDERNO, "INVID"=>$row->INVID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, "INVOICE_TOTAL"=>$row->INVOICE_TOTAL, 
                        "INVOICEDATE"=>$row->INVOICEDATE, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "NMONTHS"=>$row->NMONTHS, "STATUS_CODE" => $row->STATUS_CODE, "ORDER_ERPID" => $row->ORDER_ERPID,
                        "PAID"=>$row->PAID, "ERPID"=>$row->ERPID, "INVOICE_TOTAL"=>$row->INVOICE_TOTAL);
        }
        
        return $exp;
    }
    
    public function getTransactions($raduser="", $has_status = 0, $limit = 0, $is_upcountry=-1) {
        $exp = array();
        $adc = $lim = "";
        if ($limit > 0) {
            $lim = " LIMIT $limit";
        }
        
        if (is_array($raduser)) :
            $tmp = array();
            foreach ($raduser as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $adc .= " WHERE RAD_USERNAME IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($raduser != ""):
                $adc .= " WHERE RAD_USERNAME = '" . mysqli_real_escape_string($this->db, $raduser) . "'";
            endif;
        endif;
        
        if ($has_status) :
            $adc = ($adc == "")? " WHERE STATUS_CODE IS NOT NULL" : $adc . " AND STATUS_CODE IS NOT NULL";
        endif;
        
        if ($is_upcountry > -1) :
            $adc = ($adc == "")? " WHERE IS_UPCOUNTRY = ".($is_upcountry*1) : $adc . " AND IS_UPCOUNTRY =".($is_upcountry*1);
        endif;
                
        $qry = "SELECT TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY, IS_UPCOUNTRY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED, NMONTHS
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid 
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $adc
                 ORDER BY REQUEST_DATE DESC $lim";    
 
        $some_sth = $this->db->select($qry);  
        //$rows = $some_sth->num_rows(); 
      //try {
        while ( $row = $some_sth->fetch_object() ) { //print_r($row);
            $exp[] = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "REQ_CURRENCY"=>$row->REQ_CURRENCY, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "PAY_REF"=>$row->PAY_REFERENCE, "APPR_AMOUNT"=>$row->APPR_AMOUNT,
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "NU_EXPIRY_DATE"=>$row->NU_EXPIRY_DATE, "PAY_DATE"=>$row->PAY_DATE, "NMONTHS"=>$row->NMONTHS,
                        "SERVICE"=>$row->srvname, "PAY_GATEWAY"=>$row->PAY_GATEWAY, "DB_UPDATED"=>$row->DB_UPDATED);
        }
     /* } catch (Exception $ex) {
        //print_r($ex);
        echo $e->errorMessage();
      } finally {
        echo $e->errorMessage();
        print_r($exp); 
        //exit();
      }*/
        return $exp;
    } 
    
    public function getTransactionsUV2($raduser="", $has_status = 0, $startdate = '', $enddate = '', $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0) {
        $exp = $response = array();
        $adc = $ad = $lim = "";
        $sn = 0; 
                
        if (is_array($raduser)) :
            $tmp = array();
            foreach ($raduser as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $ad .= " AND RAD_USERNAME IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($raduser != ""):
                $ad .= " AND RAD_USERNAME = '" . mysqli_real_escape_string($this->db, $raduser) . "'";
            endif;
        endif;
        
        if ($has_status) :
//            $adc = ($adc == "")? " WHERE STATUS_CODE IS NOT NULL" : $adc . " AND STATUS_CODE IS NOT NULL";
            $ad .= " AND STATUS_CODE IS NOT NULL";
        endif;        
        
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (TRANX_ID LIKE '%$searchval%' ) ";  // OR RAD_USERNAME LIKE '%$searchval%'
        endif;
        if ($startdate <> "") :
            $startdate = mysqli_real_escape_string($this->db, $startdate);
            $ad .= " AND ( DATE(PAY_DATE) >= '$startdate' ) ";
        endif; 
        if ($enddate <> "") :
            $enddate = mysqli_real_escape_string($this->db, $enddate);
            $ad .= " AND ( DATE(PAY_DATE) <= '$enddate' ) ";
        endif;
        
        $mqry1 = "SELECT COUNT(TRANX_ID) AS 'TOTAL' FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid ";
        $some_st = $this->db->select($mqry1);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; 
        if ($ad==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$mqry1 WHERE 1 $ad";  //echo $fqry." ;;;;;;";
            $some_s = $this->db->select($fqry);
            $rec = $some_s->fetch_object();
            $this->totalRecordwithFilter = $rec->TOTAL; 
    	endif;
        
        $eqry = "SET @count = 0;"; $this->db->execute_query($eqry);
        $mqry = "SELECT (@count:=@count+1) AS 'SN', TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED, PAY_REFERENCE
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid";
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY REQUEST_DATE DESC";
        
        $qry = "$mqry WHERE 1 $ad $msort $limit"; //echo $qry;
        $some_sth = $this->db->select($qry);
                
        while ( $row = $some_sth->fetch_object() ) { 
            $act = ($row->STATUS_CODE =="" || $row->STATUS_CODE == "Z25" || $row->STATUS_CODE == "Z0")? 
                '<form id="gFormView' . $row->TRANX_ID . '" action="" target="" method="post" style="display: inline-block; padding-right: 6px;">'.'<input type="hidden" name="txnref" id="txnref" value="' . $row->TRANX_ID . '" /><input type="hidden" name="payref" id="payref" value="' . $row->PAY_REFERENCE . '" /><button id="requery" type="button" class="loadSubA btn btn-primary sm"><i class="glyphicon glyphicon-refresh orange"></i> Requery</button>'.'</form>' : "" ;
            if ($row->STATUS_CODE =="00" ) :
                $pgen = new Password_Generator();
                $hashed = urlencode($pgen->generate(10, 10, true, true, false, false) . base64_encode($pgen->generate(15, 15, true, true, true, false) . $row->TRANX_ID));
                $url = "payinv/" . $hashed;
                $act = '<a href="'.$url.'" target="blank">..<i class="glyphicon glyphicon-print orange"></i></a>';
            endif;
            $exp[] = array("SN"=>++$sn, "TRANX_ID"=>$row->TRANX_ID, "APPR_AMOUNT"=>$row->APPR_AMOUNT, 
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "EXPIRY_DATE"=>($row->EXPIRY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->EXPIRY_DATE)),
                        "NU_EXPIRY_DATE"=>($row->NU_EXPIRY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->NU_EXPIRY_DATE)),
                        "PAY_DATE"=>($row->PAY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->PAY_DATE)),
                        "PAY_GATEWAY"=>$row->PAY_GATEWAY, "ACTION"=>$act);
        }

        ## Response
        $response = array(
          "iTotalRecords" => $this->totalRecords,
          "iTotalDisplayRecords" => $this->totalRecordwithFilter,
          "aaData" => $exp
        );
        return $response;
        
    }
    
    public function getTransactionsUV3($raduser="", $has_status = 0, $startdate = '', $enddate = '', $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0) { 
        $exp = $response = array();
        $adc = $ad = $lim = "";
        $sn = 0; 
        
        if (is_array($raduser)) :
            $tmp = array();
            foreach ($raduser as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $ad .= " AND RAD_USERNAME IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($raduser != ""):
                $ad .= " AND RAD_USERNAME = '" . mysqli_real_escape_string($this->db, $raduser) . "'";
            endif;
        endif;
        
        if ($has_status) :
//            $adc = ($adc == "")? " WHERE STATUS_CODE IS NOT NULL" : $adc . " AND STATUS_CODE IS NOT NULL";
            $ad .= " AND STATUS_CODE IS NOT NULL";
        endif;        
        
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (TRANX_ID LIKE '%$searchval%' OR RAD_USERNAME LIKE '%$searchval%') ";
        endif;
        if ($startdate <> "") :
            $startdate = mysqli_real_escape_string($this->db, $startdate);
            $ad .= " AND ( DATE(PAY_DATE) >= '$startdate' ) ";
        endif; 
        if ($enddate <> "") :
            $enddate = mysqli_real_escape_string($this->db, $enddate);
            $ad .= " AND ( DATE(PAY_DATE) <= '$enddate' ) ";
        endif;
    	$time_start = microtime(true);
        $eqry = "SET @count = 0;"; $this->db->execute_query($eqry);
        $mqry = "SELECT (@count:=@count+1) AS 'SN', TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED, PAY_REFERENCE
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid";
        $some_st = $this->db->select($mqry);
        $totalRecords = $some_st->num_rows();
    	$time_stop = microtime(true);
		$exec_time = ($time_stop - $time_start)/60;
        
    	$time_start = microtime(true);
        $fqry = "$mqry WHERE 1 $ad"; //echo $fqry.":::::";
        $some_s = $this->db->select($fqry);
        $totalRecordwithFilter = $some_s->num_rows();
    	$time_stop = microtime(true);
		$exec_time1 = ($time_stop - $time_start)/60;
        
    	$time_start = microtime(true);
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY REQUEST_DATE DESC";
        
        $qry = "$mqry WHERE 1 $ad $msort $limit"; //echo $qry;
        $some_sth = $this->db->select($qry);
    	
    	$time_stop = microtime(true);
		$exec_time2 = ($time_stop - $time_start)/60;
                
    	$time_start = microtime(true);
        while ( $row = $some_sth->fetch_object() ) { 
            $act = ($row->STATUS_CODE =="" || $row->STATUS_CODE == "Z25" || $row->STATUS_CODE == "Z0")? 
                '<form id="gFormView' . $row->TRANX_ID . '" action="" target="" method="post" style="display: inline-block; padding-right: 6px;">'.'<input type="hidden" name="txnref" id="txnref" value="' . $row->TRANX_ID . '" /><input type="hidden" name="payref" id="payref" value="' . $row->PAY_REFERENCE . '" /><button id="requery" type="button" class="loadSubA btn btn-primary sm"><i class="glyphicon glyphicon-refresh orange"></i> Requery</button>'.'</form>' : "" ;
            if ($row->STATUS_CODE =="00" ) :
                $pgen = new Password_Generator();
                $hashed = urlencode($pgen->generate(10, 10, true, true, false, false) . base64_encode($pgen->generate(15, 15, true, true, true, false) . $row->TRANX_ID));
                $url = "payinv/" . $hashed;
                $act = '<a href="'.$url.'" target="blank">..<i class="glyphicon glyphicon-print orange"></i></a>';
            endif;
            $exp[] = array("SN"=>++$sn, "TRANX_ID"=>$row->TRANX_ID, "APPR_AMOUNT"=>$row->APPR_AMOUNT, 
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "EXPIRY_DATE"=>($row->EXPIRY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->EXPIRY_DATE)),
                        "NU_EXPIRY_DATE"=>($row->NU_EXPIRY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->NU_EXPIRY_DATE)),
                        "PAY_DATE"=>($row->PAY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->PAY_DATE)),
                        "PAY_GATEWAY"=>$row->PAY_GATEWAY, "ACTION"=>$act);
        }
    	
    	$time_stop = microtime(true);
		$exec_time3 = ($time_stop - $time_start)/60;

        ## Response
        $response = array(
          "iTotalRecords" => $totalRecords,
          "iTotalDisplayRecords" => $totalRecordwithFilter,
          "aaData" => $exp,
          "EXEC2-1" => $exec_time,
          "EXEC2-2" => $exec_time1,
          "EXEC2-3" => $exec_time2,
          "EXEC2-4" => $exec_time3
        );
        return $response;
    }
    
    public function getTransactionByID($txnid) {
        $txnid = mysqli_real_escape_string($this->db, $txnid);
        $qry = "SELECT TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED,
                    firstname, lastname, company, address, email, phone, tx.ID, tx.NMONTHS, PAY_GATEWAY, tp.IS_UPCOUNTRY
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid 
                LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID 
                WHERE TRANX_ID LIKE '$txnid'"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $row = $some_sth->fetch_assoc();  //$some_sth->fetch_object();
        
        return $row;
    }
    
    public function getTransactionsV2($startdate = '', $enddate = '', $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0, $is_upcountry=-1) { 
        $exp = $response = array();
        $adc = $ad = $lim = "";
        $sn = 0; 
        
        if ($searchval <> "") :
            // $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (TRANX_ID LIKE '%$searchval%' OR RAD_USERNAME LIKE '%$searchval%') ";
        endif;
        if ($startdate <> "") :
            // $startdate = mysqli_real_escape_string($this->db, $startdate);
            $ad .= " AND ( DATE(PAY_DATE) >= '$startdate' ) ";
        endif; 
        if ($enddate <> "") :
            // $enddate = mysqli_real_escape_string($this->db, $enddate);
            $ad .= " AND ( DATE(PAY_DATE) <= '$enddate' ) ";
        endif;
        if ($is_upcountry > -1) :
            $ad .= " AND IS_UPCOUNTRY = " . ($is_upcountry*1);
        endif;
        $eqry = "SET @count = 0;"; $this->db->execute_query($eqry);  
        $mqry = "SELECT (@count:=@count+1) AS 'SN', TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED, PAY_REFERENCE
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID "; 
        $some_st = $this->db->select($mqry); //echo $mqry; exit();
        $totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad";
        $some_s = $this->db->select($fqry);
        $totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY REQUEST_DATE DESC";
        
        $qry = "$mqry WHERE 1 $ad $msort $limit"; //echo $qry;
        $some_sth = $this->db->select($qry);
                
        while ( $row = $some_sth->fetch_object() ) { 
            $act = ($row->STATUS_CODE =="" || $row->STATUS_CODE == "Z25" || $row->STATUS_CODE == "Z0")? 
                '<form id="gFormView' . $row->TRANX_ID . '" action="" target="" method="post" style="display: inline-block; padding-right: 6px;">'.'<input type="hidden" name="txnref" id="txnref" value="' . $row->TRANX_ID . '" /><input type="hidden" name="payref" id="payref" value="' . $row->PAY_REFERENCE . '" /><button id="requery" type="button" class="loadSubA btn btn-primary sm"><i class="glyphicon glyphicon-refresh orange"></i> Requery</button>'.'</form>' : "" ;
            if ($row->STATUS_CODE =="00" ) :
                $pgen = new Password_Generator();
                $hashed = urlencode($pgen->generate(10, 10, true, true, false, false) . base64_encode($pgen->generate(15, 15, true, true, true, false) . $row->TRANX_ID));
                $url = "payinv/" . $hashed;
                $act = '<a href="'.$url.'" target="blank">..<i class="glyphicon glyphicon-print orange"></i></a>';
            endif;
            $exp[] = array("SN"=>++$sn, "TRANX_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "APPR_AMOUNT"=>$row->APPR_AMOUNT, "STATUS_MSG"=>$row->STATUS_MSG,
                        "EXPIRY_DATE"=>($row->EXPIRY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->EXPIRY_DATE)),
                        "NU_EXPIRY_DATE"=>($row->NU_EXPIRY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->NU_EXPIRY_DATE)),
                        "PAY_DATE"=>($row->PAY_DATE == NULL)? "-" : date( 'd-m-Y H:i:s', strtotime($row->PAY_DATE)),
                        "PAY_GATEWAY"=>$row->PAY_GATEWAY, "ACTION"=>$act);
        }

        ## Response
        $response = array(
          "iTotalRecords" => $totalRecords,
          "iTotalDisplayRecords" => $totalRecordwithFilter,
          "aaData" => $exp
        );
        return $response;
    }
    
    public function getInvoiceTransactions($raduser="", $has_status = 0, $limit = 0) {
        $exp = array();
        $adc = $lim = "";
        if ($limit > 0) {
            $lim = " LIMIT $limit";
        }
        
        if (is_array($raduser)) :
            $tmp = array();
            foreach ($raduser as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $adc .= " WHERE tii.RAD_USERNAME IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($raduser != ""):
                $adc .= " WHERE tii.RAD_USERNAME LIKE '" . mysqli_real_escape_string($this->db, $raduser) . "'";
            endif;
        endif;
        
        if ($has_status) :
            $adc = ($adc == "")? " WHERE STATUS_CODE IS NOT NULL" : $adc . " AND STATUS_CODE IS NOT NULL";
        endif;
                
        $qry = "SELECT ORDERNO, ORDERNO AS 'TRANX_ID', tii.RAD_USERNAME, INVOICE_TOTAL AS 'REQ_AMOUNT', INVOICEDATE AS 'REQUEST_DATE',
                    PAY_GATEWAY, PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, DATEPAID AS 'PAY_DATE', PAID, SENTTOERP, IS_ACTIVATED,
                    SALESPERSON, SALESEMAIL, PACKAGE
                FROM `tbl_install_invoice` tii
                LEFT JOIN tbl_erpdata ted ON tii.RAD_USERNAME=ted.RAD_USERNAME $adc
                 ORDER BY INVOICEDATE DESC $lim";  
 
        $some_sth = $this->db->select($qry);  
        //$rows = $some_sth->num_rows(); 
      //try {
        while ( $row = $some_sth->fetch_object() ) { //print_r($row);
            $exp[] = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, "ORDERNO"=>$row->ORDERNO,
                        "SENTTOERP"=>$row->SENTTOERP, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "PAID"=>$row->PAID, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "PAY_REF"=>$row->PAY_REFERENCE, "APPR_AMOUNT"=>$row->APPR_AMOUNT,
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "IS_ACTIVATED"=>$row->IS_ACTIVATED, "PAY_DATE"=>$row->PAY_DATE, "SALESEMAIL"=>$row->SALESEMAIL,
                        "SERVICE"=>$row->PACKAGE, "PAY_GATEWAY"=>$row->PAY_GATEWAY, "SALESPERSON"=>$row->SALESPERSON);
        }
     /* } catch (Exception $ex) {
        //print_r($ex);
        echo $e->errorMessage();
      } finally {
        echo $e->errorMessage();
        print_r($exp); 
        //exit();
      }*/
        return $exp;
    }
    
    public function getDisTransaction($transid) {
        $exp = array();
        
        $qry = "SELECT TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid 
                WHERE TRANX_ID=?";  
        $some_sth = $this->db->select($qry, "s", $transid);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp[] = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "REQ_CURRENCY"=>$row->REQ_CURRENCY, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "PAY_REF"=>$row->PAY_REFERENCE, "APPR_AMOUNT"=>$row->APPR_AMOUNT,
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "NU_EXPIRY_DATE"=>$row->NU_EXPIRY_DATE, "PAY_DATE"=>$row->PAY_DATE,
                        "SERVICE"=>$row->srvname, "PAY_GATEWAY"=>$row->PAY_GATEWAY, "DB_UPDATED"=>$row->DB_UPDATED);
        }
        
        return $exp;
    }
    
    
    public function loadRadUser4VOIP($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if (is_array($user)) :
            $tmp = array();
            foreach ($user as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $ad .= " WHERE username IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($user != ""):
                $ad .= " WHERE username LIKE '" . mysqli_real_escape_string($this->db, $user) . "'";
            endif;
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE username $in_not (SELECT RAD_USERNAME FROM tbl_voip)";
            else
                $ad .= " AND username $in_not (SELECT RAD_USERNAME FROM tbl_voip)";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, VOIP_NO 
                FROM `rm_users` ru
                LEFT JOIN tbl_voip tv ON ru.username = tv.RAD_USERNAME
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad 
                 ORDER BY username"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->username] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "VOIP_NO" => $row->VOIP_NO, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "IS_ENABLED" => $row->enableuser);
        }
        
        return $ret;
    }    
      
    
    public function loadRadUserObject4VOIP($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad = " WHERE username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE ( (username $in_not (SELECT RAD_USERNAME FROM tbl_voip))  )";
            else
                $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tbl_voip))  )";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration 
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
      
    
    public function loadVOIPList($user="", $is_enabled=-1, $is_linked = -1, $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=50) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user); // mysql_escape_string($user);
            $ad .= " AND username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tbl_voip))  )";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR ru.email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR ru.username LIKE '%$searchval%'  OR rs.srvname = '$searchval' ) ";
        endif;
        
        $tqry = "SELECT ru.username, VOIP_NO, enableuser, firstname, lastname, ru.mobile, ru.email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, tad.FULLNAME AS 'ADDED_BY', tv.DATE_ADDED
                FROM `tbl_voip` tv
                LEFT JOIN `rm_users` ru ON tv.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_admins tad ON tv.ADDED_BY=tad.AID "; //echo $qry;
        
        $mqry1 = "SELECT COUNT(RAD_USERNAME) AS 'TOTAL' FROM tbl_voip ";
        $some_st = $this->db->select($mqry1); 
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; // $some_st->num_rows();
        if ($ad==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$tqry WHERE 1 $ad";  
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows(); // $rec->TOTAL; // $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1  $ad $msort $limit";
    	// echo ($is_active == 1 || $is_active == 0)? $qry : "v";
        $some_sth = $this->db->select($qry);
        
        $sn = 0;
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = array( "SN"=>++$sn, "USERNAME"=>$row->username, "FULLNAME"=>"{$row->firstname} {$row->lastname}", "SERVICE"=>$row->srvname, 
                "VOIP_NO"=>$row->VOIP_NO, "ADDED_BY"=>$row->ADDED_BY, "DATE_ADDED"=>date( 'd-m-Y H:i:s', strtotime($row->DATE_ADDED)) );
        }
        
        return $ret;
    }
    
    
    public function createVOIP($raduser, $voip_no, $adminID) {
        $voip_exist = $this->verifyVOIPExist($voip_no);
        $rad_exist = $this->radAssignedVOIP($raduser);
        
        if ($voip_exist == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: VOIP Number [$voip_no] already Assigned", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: VOIP Number [$voip_no] already Assigned";
        else:
            if ($rad_exist == 1) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Service ID [$raduser] already Assigned a VOIP Number", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Service ID [$raduser] already Assigned a VOIP Number";
            else :
                $qry = "INSERT INTO tbl_voip (RAD_USERNAME, VOIP_NO, ADDED_BY, DATE_ADDED)
                        VALUES (?, ?, ?, NOW())";
                $in_id = $this->db->insert($qry, 'ssi', $raduser, $voip_no, $adminID);
                if ($in_id) :
                    $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: VOIP Number [$voip_no] successfully assigned to [$raduser]!", $this::STATUS_PASSED, get_client_ip_env());
                    return "Success: VOIP Number [$voip_no] successfully assigned to [$raduser]!";
                else:
                    $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to assigned VOIP Number [$voip_no] to [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
                    return "Error: Unable to assigned VOIP Number [$voip_no] to [$raduser]";
                endif;
            endif;
        endif;
    }    
    
    
    public function editVOIP($raduser, $voip_no) {
        $voip_exist = $this->verifyVOIPExist($voip_no, $raduser);
        
        if ($voip_exist == 1) :
            return "Error: VOIP Number [$voip_no] already Assigned to another account";
        else:
            $upd = "UPDATE tbl_voip SET VOIP_NO=? WHERE RAD_USERNAME=?"; 
            $rett = $this->db->execute_query($upd, "ss", $voip_no, $raduser);
            
            if ($rett) :
                return "Success: Update Completed!";
            else:
                return "Error: Update failed!";
            endif;
        endif;
    }
    
    public function verifyVOIPExist($voip_no="", $raduser="") {
        $exist = 0;
        $adc = "";
        if ($raduser != ""):
            $adc = " AND RAD_USERNAME <> '" . mysqli_real_escape_string($this->db, $raduser) . "'";
        endif;
        if ($voip_no != "") :
            $qry = "SELECT RAD_USERNAME
                FROM `tbl_voip` 
                WHERE VOIP_NO =? $adc";
            $some_sth = $this->db->select($qry, 's', $voip_no);
            $rows = $some_sth->num_rows();
            if ($rows):
                $exist = 1;
            endif;
        endif;
        
        return $exist;
    } 
    
    public function radAssignedVOIP($raduser="") {
        $exist = 0;
        if ($raduser <> "") :
            $qry = "SELECT VOIP_NO
                FROM `tbl_voip` 
                WHERE RAD_USERNAME =?";
            $some_sth = $this->db->select($qry, 's', $raduser);
            $rows = $some_sth->num_rows();
            if ($rows):
                $exist = 1;
            endif;
        endif;
        
        return $exist;
    }
    
    // data used for logging
    public function dataToStore($raduser, $tranx_id, $amount, $curr, $months=1){
        $importantValues = array($raduser, $tranx_id, $amount, $curr, $months); // you can include customer name in this (CUST_NAME) if you'll be setting that
        return @json_encode($importantValues);
    }
    
    // generate the sha512 hash
    public function hashGenerator($tranx_id, $amount, $notif_url, $hashkey){
        $dataToHash = $tranx_id . $amount . $notif_url . $hashkey;
        return hash("sha512", $dataToHash);
    }
    
    // generate the sha512 hash from supplied string
    public function hashGeneratorNew($dataToHash){
        //$dataToHash = $tranx_id . $amount . $notif_url . $hashkey;
        return hash("sha512", $dataToHash);
    }
    
    // generate the verification sha512 hash
    public function verifyHash($tranx_id, $amt_kobo, $status_code, $hashkey){
        $dataToHash = $tranx_id . $amount . $status_code . $hashkey;
        return hash("sha512", $dataToHash);
    }
        
    public function insertLog($fields, $value, $table="paydirect_log") {
        
        $qry = "INSERT INTO $table ($fields)
                    VALUES ($value)";
        $in_id = $this->db->insert($qry);
        if ($in_id) :
            return "Success";
        else:
            return "Error";
        endif;
         
    }      
     
    public function loadStates()  {
       $qry = "SELECT *
                FROM tbl_states ORDER BY STATENAME"; 
       $some_sth = $this->db->select($qry);
       $rows = $some_sth->num_rows();
       if ($rows) :
           while ($row = $some_sth->fetch_object()):
                $ret[] = ["STATECODE"=>$row->STATECODE, "STATENAME"=>$row->STATENAME, "STATE"=>$row->STATENAME];
           endwhile; 
       else: $ret = [];
       endif;

       return $ret;
    }    
     
    public function getUserGroupArray()  {
       $qry = "SELECT ID, ADMIN_TYPE, IS_ADMIN
                FROM tbl_admin_level ORDER BY ADMIN_TYPE"; 
       $some_sth = $this->db->select($qry);
       $rows = $some_sth->num_rows();
       if ($rows) :
           while ($row = $some_sth->fetch_object()):
                $ret[$row->ID] = ["UGID"=>$row->ID, "ADMIN_TYPE"=>$row->ADMIN_TYPE, "IS_ADMIN"=>$row->IS_ADMIN];
           endwhile; 
       else: $ret = [];
       endif;

       return $ret;
    } 
    
    public function getAdminDashStat($month=0, $yr=0) {
        if ($month == 0 && $yr == 0):
            return [];
        endif;
        
        $ret = [];
        
        $qry = "SELECT COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' FROM `tbl_tranx` "
                . "WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret = ["NTRANS" => $row->NTRANS, "SALES" => $row->SALES]; 
        
        $qry = "SELECT COUNT(username) AS 'NUSERS' FROM rm_users WHERE MONTH(createdon)=? AND YEAR(createdon)=?"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret['NUSERS'] = $row->NUSERS;
        
        $qry = "SELECT COUNT(username) AS 'NUSERS' FROM rm_users WHERE MONTH(createdon)=? AND YEAR(createdon)=? 
                 AND username IN (SELECT username FROM tbl_user_extend WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=0))"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret['NUSERS_REG'] = $row->NUSERS;
        
        $qry = "SELECT COUNT(username) AS 'NUSERS' FROM rm_users WHERE MONTH(createdon)=? AND YEAR(createdon)=? 
                 AND username IN (SELECT username FROM tbl_user_extend WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=1))"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret['NUSERS_UP'] = $row->NUSERS;
        
//        $qry = "SELECT srvname AS 'SRV', descr AS 'SRV_DESC', COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' 
//FROM `tbl_tranx` tx
//LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
//LEFT JOIN rm_services rs ON r.srvid = rs.srvid
//WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?
//GROUP BY srvname"; 
        $qry = "SELECT tp.PLAN AS 'SRV', tp.DESCRIPTION AS 'SRV_DESC', COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES', IS_UPCOUNTRY
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?
GROUP BY tp.PLAN"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_SRV'][] = ["SRV"=>$row->SRV, "SRV_DESC"=>$row->SRV_DESC, 
                            "NTRANS"=>$row->NTRANS, "SALES"=>$row->SALES, "IS_UPCOUNTRY"=>$row->IS_UPCOUNTRY];
        endwhile;
        
        return $ret;
    }
    
    public function getAdminDashStatv1($month=0, $yr=0) {
        if ($month == 0 && $yr == 0):
            return [];
        endif;
        
        $ret = [];
        
        $qry = "SELECT COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' FROM `tbl_tranx` "
                . "WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret = ["NTRANS" => $row->NTRANS, "SALES" => $row->SALES]; 
        
        $qry = "SELECT COUNT(username) AS 'NUSERS' FROM rm_users WHERE MONTH(createdon)=? AND YEAR(createdon)=?"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret['NUSERS'] = $row->NUSERS;
        
//        $qry = "SELECT srvname AS 'SRV', descr AS 'SRV_DESC', COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' 
//FROM `tbl_tranx` tx
//LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
//LEFT JOIN rm_services rs ON r.srvid = rs.srvid
//WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?
//GROUP BY srvname"; 
        $qry = "SELECT tp.PLAN AS 'SRV', (SELECT COUNT(username) FROM tbl_user_extend WHERE PLAN_NAME=tp.PLAN AND enableuser = 1) AS 'NCUST', 
            tp.DESCRIPTION AS 'SRV_DESC', COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES'
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?
GROUP BY tp.PLAN"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_SRV'][] = ["SRV"=>$row->SRV, "SRV_DESC"=>$row->SRV_DESC, "NCUST"=>$row->NCUST, 
                            "NTRANS"=>$row->NTRANS, "SALES"=>$row->SALES];
        endwhile;
        
        $qry = "SELECT MONTH(PAY_DATE) AS 'MON', MONTHNAME(PAY_DATE) AS 'MONN', YEAR(PAY_DATE) AS 'YR', COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES'
FROM `tbl_tranx` tx
WHERE STATUS_CODE = '00' AND YEAR(PAY_DATE)>= ?
GROUP BY YEAR(PAY_DATE), MONTH(PAY_DATE)";
        $some_sth = $this->db->select($qry, "i", $yr-3);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_YR'][$row->YR][] = ["MON"=>$row->MON, "MONN"=>$row->MONN, 
                            "NTRANS"=>$row->NTRANS, "SALES"=>$row->SALES];
        endwhile;
        
        $qry = "SELECT MONTHNAME(PAY_DATE) AS 'MONN', MONTH(PAY_DATE) AS 'MON', DAY(PAY_DATE) AS 'DDAY', COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) >= ? AND YEAR(PAY_DATE) = ?
GROUP BY MONTH(PAY_DATE), DAY(PAY_DATE)";
        $qry = "SELECT MONTHNAME(PAY_DATE) AS 'MONN', MONTH(PAY_DATE) AS 'MON', DAY(PAY_DATE) AS 'DDAY', COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
WHERE STATUS_CODE = '00' AND PAY_DATE  >= DATE_FORMAT(CURDATE(), '%Y-%m-01') - INTERVAL 1 MONTH
GROUP BY MONTH(PAY_DATE), DAY(PAY_DATE)";
        // $some_sth = $this->db->select($qry, "ii", ($month==1)? 12 : $month-1, ($month==1)? $yr-1: $yr);
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_MON'][$row->MONN][] = $row->NTRANS;;
            if (!in_array($row->DDAY, $ret['DAYS']) ):
                $ret['DAYS'][] = $row->DDAY;
            endif;
        endwhile;
        
        $qry = "SELECT MONTH(PAY_DATE) AS 'MON', MONTHNAME(PAY_DATE) AS 'MONN', tp.PLAN, COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) >= ? AND YEAR(PAY_DATE) = ?
GROUP BY MONTH(PAY_DATE), tp.PLAN";
        $some_sth = $this->db->select($qry, "ii", ($month==1)? 12 : $month-1, ($month==1)? $yr-1: $yr);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_PLAN'][$row->PLAN][$row->MONN] =$row->NTRANS;
            if (!in_array($row->PLAN, $ret['PLANS']) ):
                $ret['PLANS'][] = $row->PLAN;
            endif;
            
        endwhile;
        
        $qry = "SELECT PLAN_NAME, COUNT(username) AS 'NFREQ' FROM tbl_user_extend 
WHERE PLAN_ID IN (SELECT DISTINCT PLAN_ID FROM tbl_tranx WHERE STATUS_CODE = '00' ) AND PLAN_NAME NOT LIKE '%Dedicated%'
AND PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_ENABLED=1)
GROUP BY PLAN_NAME";
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret['PLAN_FREQ'][$row->PLAN_NAME] = $row->NFREQ;
        endwhile;
        
        $qry = "SELECT PLAN_NAME, COUNT(username) AS 'NFREQ'
            FROM 
            (
              SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
							INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID
              FROM tbl_user_extend ru
              JOIN rm_services  rs USING (srvid)
              
            ) AS tmp
            WHERE 1
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
	    AND tmp.enableuser = 1 
AND
         		      (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
	    AND PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_ENABLED=1) AND PLAN_NAME NOT LIKE '%Dedicated%'
	    GROUP BY PLAN_NAME";
        
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret['EXP'][$row->PLAN_NAME] = $row->NFREQ;
        endwhile;
        
        
        return $ret;
    }
    
    
    public function getSalesByPck($cals, $plans=[], $dayfrom=[], $dayto=[]) {
        $ret = [];
        $tre = $retst = [];
        $ad = $pad = "";
        foreach ($cals as $k => $val) {
          $cal = explode("|", $val);
          if ($dayfrom[$k] > $dayto[$k]) { return "Error: Day from should be less than day to"; }
          $tre[] = "(MONTH(PAY_DATE) = '". ($cal[0]*1) ."' AND YEAR(PAY_DATE) = '". ($cal[1]*1) ."' AND (DAY(PAY_DATE) BETWEEN ". ($dayfrom[$k]*1) ." AND ". ($dayto[$k]*1) ." ) )";
          $retst[$cal[0]*1] = "Day {$dayfrom[$k]} to {$dayto[$k]}";
        }
        if (count($tre)) { $ad = " AND ( ". join(" OR ", $tre) . " )"; }
        if (count($plans)) {
            $pad = " AND tx.PLAN_ID IN (" .implode(",", $plans) . ")";
        }
        
        $qry = "SELECT MONTH(PAY_DATE) AS 'MON', MONTHNAME(PAY_DATE) AS 'MONN', YEAR(PAY_DATE) AS 'DYEAR', tp.PLAN, COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
WHERE STATUS_CODE = '00' $ad $pad
GROUP BY MONTH(PAY_DATE), tp.PLAN"; 
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_PLAN'][$retst[$row->MON] . " " . $row->MONN . " " . $row->DYEAR][$row->PLAN] =$row->NTRANS;
            if (!in_array($row->PLAN, $ret['PLANS']) ):
                $ret['PLANS'][] = $row->PLAN;
            endif;
            
        endwhile;
        
        return $ret;
    }
    
    
    public function getSalesByMon($cals, $dayfrom=[], $dayto=[]) {
        $ret = [];
        $tre = $retst = [];
        $ad = "";
        foreach ($cals as $k=>$val) {
          $cal = explode("|", $val);
          if ($dayfrom[$k] > $dayto[$k]) { return "Error: Day from should be less than day to"; }
          $tre[] = "(MONTH(PAY_DATE) = '". ($cal[0]*1) ."' AND YEAR(PAY_DATE) = '". ($cal[1]*1) ."' AND (DAY(PAY_DATE) BETWEEN ". ($dayfrom[$k]*1) ." AND ". ($dayto[$k]*1) ." ) )";
          $retst[$cal[0]*1] = "Day {$dayfrom[$k]} to {$dayto[$k]}";
        }
        if (count($tre)) { $ad = " AND ( ". join(" OR ", $tre) . " )"; }
        
        $qry = "SELECT MONTHNAME(PAY_DATE) AS 'MONN', MONTH(PAY_DATE) AS 'MON', DAY(PAY_DATE) AS 'DDAY', YEAR(PAY_DATE) AS 'DYEAR', COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
WHERE STATUS_CODE = '00' $ad
GROUP BY MONTH(PAY_DATE), DAY(PAY_DATE)"; //echo $qry;
        
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_MON'][$retst[$row->MON] . " " . $row->MONN . " " . $row->DYEAR][] = $row->NTRANS;;
            if (!in_array($row->DDAY, $ret['DAYS']) ):
                $ret['DAYS'][] = $row->DDAY;
            endif;
        endwhile;
        
        return $ret;
    }
    
    
    public function getSalesByMonv0($cals) {
        $ret = [];
        $tre = [];
        $ad = "";
        foreach ($cals as $val) {
            $cal = explode("|", $val);
            $tre[] = "(MONTH(PAY_DATE) = '". ($cal[0]*1) ."' AND YEAR(PAY_DATE) = '". ($cal[1]*1) ."')";
        }
        if (count($tre)) { $ad = " AND ( ". join(" OR ", $tre) . " )"; }
        
        $qry = "SELECT MONTHNAME(PAY_DATE) AS 'MONN', MONTH(PAY_DATE) AS 'MON', DAY(PAY_DATE) AS 'DDAY', YEAR(PAY_DATE) AS 'DYEAR', COUNT(TRANX_ID) AS 'NTRANS'
FROM `tbl_tranx` tx
WHERE STATUS_CODE = '00' $ad
GROUP BY MONTH(PAY_DATE), DAY(PAY_DATE)";
        
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_MON'][$row->MONN . " " . $row->DYEAR][] = $row->NTRANS;;
            if (!in_array($row->DDAY, $ret['DAYS']) ):
                $ret['DAYS'][] = $row->DDAY;
            endif;
        endwhile;
        
        return $ret;
    }
    
    public function getTranxByService($srvid=0, $startdate="", $enddate="") {
        $addthis = "";
        if (is_int($srvid) && ($srvid > 0)):
            $addthis = " AND r.srvid=$srvid";
        endif;
        
        if ($startdate <> "" && $enddate <> ""):
            $me = " AND PAY_DATE BETWEEN '$startdate' AND '$enddate' ";
            $addthis = ($addthis == "")? $me : $addthis . $me;
        else:
            $me = " AND MONTH(PAY_DATE) = MONTH(NOW()) AND YEAR(PAY_DATE) = YEAR(NOW())";
            $addthis = ($addthis == "")? $me : $addthis . $me;
        endif;
        
        $qry = "SELECT r.username, rs.srvname, tx.TRANX_ID, PAY_DATE, NU_EXPIRY_DATE, APPR_AMOUNT, NMONTHS, 
            DB_UPDATED, PAY_GATEWAY 
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN rm_services rs ON r.srvid = rs.srvid
WHERE STATUS_CODE = '00' $addthis";  //echo $qry . "$startdate  $enddate";
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret[] = ["SRV"=>$row->srvname, "TRANSID"=>$row->TRANX_ID, "USERNAME"=>$row->username,
                            "PAY_DATE"=>$row->PAY_DATE, "NU_EXPIRY_DATE"=>$row->NU_EXPIRY_DATE,
                            "AMOUNT"=>$row->APPR_AMOUNT, "NMONTHS"=>$row->NMONTHS,
                            "DB_UPDATED"=>$row->DB_UPDATED, "PAY_GATEWAY"=>$row->PAY_GATEWAY];
        endwhile;
        
        return $ret;
    }


	public function getJournalInfoERP2($journalType) {
    	$qry = "SELECT * FROM tbl_erpv2_journal WHERE ACCOUNTTYPE=?";
    	$some_sth = $this->db->select($qry, "s", $journalType);
        $row = $some_sth->fetch_assoc();
    	return $row;
    }
    
    
    public function sendToERP($url, $db, $username, $password, $erpid, $amt, $desc, $paydate, $productid=0, $nmonths=1, $journal_id=10, $txn="", $expiry="", $journal_info=[]) {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }

        $url = 'http://erp.fob.ng:8069';
        $username = "ebilling";
        $password = "ebilling";
        $db = "Prod";
    	
        $common = ripcord::client($url . "/xmlrpc/2/common"); 
        $uid = $common->authenticate($db, $username, $password, []);         
        $models = ripcord::client($url . "/xmlrpc/2/object");

        $paidAmt = (str_replace(",", "", $amt))*1;
        $unitPrice = ($paidAmt/$nmonths); // * 0.925
    	//bank_name, bank_number   $journal_info
        $payload = ['name'=>'sale', 'journal_id'=> $journal_id, 'customerid'=> $erpid, 'ebilling_ref'=>$txn,
                    'no_of_paid_month'=>$nmonths, 'expiry'=> $expiry, 'date'=>$paydate, 
                    'bank_name'=>$journal_info['BANK'], 'bank_number'=>$journal_info['ACCOUNTNO'],
                    'lines'=>[
                        [
                            'description' => $desc . "-$nmonths month(s)",
                            'qty' => $nmonths,
                            'price' => $unitPrice,
                            'uom' => 1, 'tax' => 1, 'product_id' => $productid,
                        ]
                    ]];
        $payment_id = $models->execute_kw($db, $uid, $password,
            'wb.request.registration', 'wbRequestRegisration', [[], $payload]);

        //Log IT
        $payid = mysqli_real_escape_string($this->db, json_encode($payment_id)); //(is_array($productid))? $productid : json_encode($productid);
        $fields = "TXN_ID, JOURNAL_ID, COMPANY_ID, ERPID, PRODUCT_ID, AMOUNT, DESCRIPTION, NMONTHS, ERP_RESPONSE, DATESENT, PAYDATE";
        $values = "'$txn', '$journal_id', '$company', '$erpid', '$productid', '$amt', '$desc-$nmonths month(s)', '$nmonths', '$payid', NOW(), '$paydate'";
        $this->insertLog($fields, $values, "tbl_senttoerp");
    	$this->logTrail($this::INFO, "(SEND RENEWAL TO ERP) SENT:".json_encode($payment_id) . "| ($paidAmt/$nmonths)  | $erpid | $unitPrice |".json_encode($payload) ."|", $this::STATUS_PASSED, get_client_ip_env()); 

        return $payment_id;
    }
    
    
    public function sendToERP_OLD($url, $db, $username, $password, $erpid, $amt, $desc, $paydate, $productid=0, $nmonths=1, $journal_id=10, $txn="") {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }
    	// $txn = is_numeric($txn)? $txn . "PD" : $txn;
    	// $txn = (strlen($txn)==9)? $txn . "PD" : $txn;
    	// $url = "http://41.223.66.18:8069";
        $common = ripcord::client($url . "/xmlrpc/2/common"); 
        
        $company = ($journal_id==PAYSTACK_UPCOUNTRY)? COMPANY_KKON : COMPANY_FOB;
        $username = ($journal_id==PAYSTACK_UPCOUNTRY)? UPERP_USER : $username;
        $password = ($journal_id==PAYSTACK_UPCOUNTRY)? UPERP_PASS : $password;
        $uid = $common->authenticate($db, $username, $password, array());         
        $models = ripcord::client($url . "/xmlrpc/2/object");
        $payment_id = $models->execute_kw($db, $uid, $password,
            'account.payment.group', 'create',
                 array(array(
                     'date'=> $paydate,
                     'is_from_rpc'=>true,
                     'journal_id'=> $journal_id, // 10, //8
                     'company_id'=> $company,  // 3
                      'amount'=> (str_replace(",", "", $amt))*1,
                      'ref' => $desc . "-$nmonths month(s)", 
                      'partner_id' => $erpid,
                      'product_id' => $productid,
                      'num_renewal' => $nmonths*1
                 )));
        //Log IT
        $payid = mysqli_real_escape_string($this->db, json_encode($payment_id)); //(is_array($productid))? $productid : json_encode($productid);
        $fields = "TXN_ID, JOURNAL_ID, COMPANY_ID, ERPID, PRODUCT_ID, AMOUNT, DESCRIPTION, NMONTHS, ERP_RESPONSE, DATESENT, PAYDATE";
        $values = "'$txn', '$journal_id', '$company', '$erpid', '$productid', '$amt', '$desc-$nmonths month(s)', '$nmonths', '$payid', NOW(), '$paydate'";
        $this->insertLog($fields, $values, "tbl_senttoerp");
//        $nmonths = ($nmonths<=0)? 1 : $nmonths;
//        $pamt = $amt / $nmonths;
//        for ($i=1; $i<= $nmonths; $i++) {
//            if ($i>1) {
//                $paydate = date("Y-m-d", strtotime(add_date($paydate, 30) ));
//            }
//            $payment_id = $models->execute_kw($db, $uid, $password,
//               'account.payment.group', 'create',
//                    array(array(
//                        'date'=> $paydate,
//                        'is_from_rpc'=>True,
//                        'journal_id'=> $journal_id, // 10, //8
//                        'company_id'=> ($journal_id==PAYSTACK_UPCOUNTRY)? COMPANY_KKON : COMPANY_FOB,  // 3
//                         'amount'=> $pamt,
//                         'ref' => $desc . " Month $i", 
//                         'partner_id' => $erpid,
//                         'product_id' => $productid
//                    )));
//        }
        
        return $payment_id;
    }
    
    
    public function sendToERPv1($url, $db, $username, $password, $erpid, $amt, $desc, $paydate) {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }
    
 		// $url = "http://41.223.66.18:8069";   
        $common = ripcord::client($url . "/xmlrpc/2/common");
        
        $uid = $common->authenticate($db, $username, $password, array()); //echo "USER: $uid };";
        
        $models = ripcord::client($url . "/xmlrpc/2/object");
        $id_journal_entry = $models->execute_kw($db, $uid, $password,
            'account.move', 'create',
            array(array(
                'is_from_rpc'=>True,
                'date'=>$paydate,
                'journal_id'=> 52, # this is the ID of the Eservice Payment Journal Book on ODEX
                'company_id'=> 3,  # This is the FOB company ID
            ))); //echo "USER1: $uid };";
        $id_debit_journal_item = $models->execute_kw($db, $uid, $password,
            'account.move.line', 'create',
            array(array(
                'is_from_rpc'=>True,
                'move_id'=> $id_journal_entry,     
                'account_id' => 932,   # The account to debit which is the Accounts Receivable ID. 
                'name'=>$desc,
                'debit'=>$amt,  # Test value
                'partner_id' => $erpid,   # This is a temporary test partner ID (Customer) which will come from the customers ID that have to be pushed initially to eservice system
                'company_id'=> 3,  # This is the FOB company ID
                )
            ));
        $id_credit_journal_item = $models->execute_kw($db, $uid, $password,
            'account.move.line', 'create',
            array(array(
                'is_from_rpc'=>True,
                'move_id'=> $id_journal_entry,     
                'account_id' => 935,   # The account to credit which is the Accounts Receivable ID. 
                'name'=>$desc,
                'credit'=>$amt,  # Test value
                'partner_id' => $erpid,   # This is a temporary test partner ID (Customer) which will come from the customers ID that have to be pushed initially to eservice system
                'company_id'=> 3,  # This is the FOB company ID
                )
            )); //echo "USER2: $uid };";
        
        return ["DB_LEG"=>$id_debit_journal_item, "CR_LEG"=>$id_credit_journal_item];
    }
    
    
    public function sendInvoiceToERP($url, $db, $username, $password, $erpid, $order_erpid, $amt, $desc, $paydate, $journal_id=9, $isManual=0) {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }

        if ($isManual==0) {
            $url = 'http://erp.fob.ng:8069';
            $username = "ebilling";
            $password = "ebilling";
            $db = "Prod";
            
            $common = ripcord::client($url . "/xmlrpc/2/common"); 
            $uid = $common->authenticate($db, $username, $password, []);         
            $models = ripcord::client($url . "/xmlrpc/2/object");

            $paidAmt = (str_replace(",", "", $amt))*1;
            $unitPrice = ($paidAmt) ;  // * 0.925
            $payload = ['name'=>'auto_account_approval', 'orderid'=> $order_erpid, 'date'=>$paydate,
                        'amount'=>$unitPrice, ];
            $payment_id = $models->execute_kw($db, $uid, $password,
                'wb.request.registration', 'wbRequestRegisration', [[], $payload]);

        } else { $payment_id = ["Manual Payment from ERP"]; }

        //Log IT
        $upd = "UPDATE tbl_install_invoice SET SENTTOERP=1 WHERE ORDER_ERPID=?";
        $this->db->execute_query($upd, "i", $order_erpid);
        $this->logTrail($this::INFO, "(SEND INVOICE TO ERP) SENT:".json_encode($payment_id) . "| ($paidAmt) * 0.925 | $order_erpid | $unitPrice |".json_encode($payload) ."|", $this::STATUS_PASSED, get_client_ip_env()); 

        return $payment_id;
    }
    
    public function sendInvoiceToERP_OLD($url, $db, $username, $password, $erpid, $order_erpid, $amt, $desc, $paydate, $journal_id=9, $isManual=0) {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }

    	if ($isManual==0) {
    	// $url = "http://41.223.66.18:8069";
        $common = ripcord::client($url . "/xmlrpc/2/common");        
        $uid = $common->authenticate($db, $username, $password,array());         
        $models = ripcord::client($url . "/xmlrpc/2/object");

        $payment_id = $models->execute_kw($db, $uid, $password,
               'sale.order', 'ebilling_payment_receive',
                    array(array(
                        'date'=> $paydate,
                        'is_from_rpc'=>True,
                        'journal_id'=> $journal_id,  //8 //9
                        'company_id'=> ($journal_id==PAYSTACK_UPCOUNTRY)? COMPANY_KKON : COMPANY_FOB,  // 3  
                        'amount'=> $amt,
                        'ref' => $desc, 
                        'order_id' => $order_erpid,
                        'partner_id' => $erpid

                    )));
        } else { $payment_id = ["Manual Payment from ERP"]; }
//        print $payment_id;
        $upd = "UPDATE tbl_install_invoice SET SENTTOERP=1 WHERE ORDER_ERPID=?";
        $this->db->execute_query($upd, "i", $order_erpid);
        $this->logTrail($this::INFO, "(SEND INVOICE TO ERP) SENT:".json_encode($payment_id) . "| $order_erpid | $desc", $this::STATUS_PASSED, get_client_ip_env()); 
        return $payment_id;
    }
    
    
    public function activateUser($raduser) {
        $is_okay=0;
        //log activation
        //set paid_invoice = 1, only_activate to 0 in tbl_erpdata
        $upd = "UPDATE tbl_erpdata SET PAID_INVOICE=1, ONLY_ACTIVATE=0 WHERE RAD_USERNAME=?";
        if ($this->db->execute_query($upd, "s", $raduser)) { $is_okay = 1; }
        //set is_activated=1 and date_activate=NOW() in tbl_install_invoice
        $upd1 = "UPDATE tbl_install_invoice SET IS_ACTIVATED=1, DATE_ACTIVATED=NOW() WHERE RAD_USERNAME=? AND PAID=1";
        if ($this->db->execute_query($upd1, "s", $raduser)) { $is_okay = 1; }
        //set usertype=3 in tblclients
        $upd2 = "UPDATE tblclients SET USERTYPE=3 WHERE RAD_USERNAME=? ";
        if ($this->db->execute_query($upd2, "s", $raduser)) { $is_okay = 1; }
        
        $this->logTrail($this::INFO, "($raduser ACTIVATION) SENT: $is_okay", $this::STATUS_PASSED, get_client_ip_env()); 
        
        return $is_okay;
    }
    
    public function unpauseAccount($raduser, $adminID, $adminUser) {
        $all_query_ok = true;
        //Check if User is on Pause
        $sel = "SELECT PAUSE_ID, PAUSE_DATE, PAUSE_TILL, DAYS_TO_EXPIRE FROM tbl_pause_account WHERE IS_PAUSED=1 AND USERNAME=?";
        $some_sth = $this->db->select($sel, "s", $raduser); 
        $rows = $some_sth->num_rows();
        if ($rows) :
            $row = $some_sth->fetch_object();
//            $pausedon = date( 'd-m-Y', strtotime($row->PAUSE_DATE));
//            $pausedtill = date( 'd-m-Y', strtotime($row->PAUSE_TILL));
            $pauseid = $row->PAUSE_ID;
            $extendby = $row->DAYS_TO_EXPIRE;
            $nu_expd = add_date(date("Y-m-d H:i:s"), $extendby );
            $nu_expdate = date( 'd-m-Y', strtotime($nu_expd));
            $today = date("Y-m-d H:i:s");
            $this->db->autocommit(FALSE);
            
            $upd = "UPDATE tbl_pause_account SET IS_PAUSED=0, UNPAUSED_BY=?, DATE_UNPAUSED=?, NU_EXPIRATION=? WHERE USERNAME=? AND PAUSE_ID=?";
            $this->db->execute_query($upd, "isssi", $adminID, $today, $nu_expd, $raduser, $pauseid)? null : $all_query_ok=false;  
            
            $upd = "UPDATE rm_users SET enableuser=1 WHERE username=?";
            $this->db->execute_query($upd, "s", $raduser)? null : $all_query_ok=false;         

            $all_query_ok ? $this->db->commit() : $this->db->rollback();
            $this->db->autocommit(TRUE);
            if ($all_query_ok) :   
                $this->logTrail($this::INFO, "($adminUser Attempt) SUCCESS: User Account [$raduser] was successfully unpaused and expiration extended by $extendby days till $nu_expdate", $this::STATUS_PASSED, get_client_ip_env()); 
                return ["STATUS"=>1, "MSG"=> "SUCCESS: User Account [$raduser] was successfully unpaused and expiration extended by $extendby days till $nu_expdate"];
            else:
                $this->logTrail($this::INFO, "($adminUser Attempt) ERROR: Unable to Unpause User Account [$raduser] at the moment", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "ERROR: Unable to Unpause User Account [$raduser] at the moment"];
            endif;
        else:
            $this->logTrail($this::INFO, "($adminUser Attempt) ERROR: User Account [$raduser] not currently paused", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "ERROR: User Account [$raduser] not currently paused"];
        endif;
    }
    
    public function pauseAccount($raduser, $pause_till, $adminID, $adminUser) {
        $all_query_ok = true;
        //Check if User is on Pause
        $sel = "SELECT PAUSE_DATE, PAUSE_TILL FROM tbl_pause_account WHERE IS_PAUSED=1 AND USERNAME=?";
        $some_sth = $this->db->select($sel, "s", $raduser); 
        $rows = $some_sth->num_rows();
        if ($rows) :
            $row = $some_sth->fetch_object();
            $pausedon = date( 'd-m-Y', strtotime($row->PAUSE_DATE));
            $pausedtill = date( 'd-m-Y', strtotime($row->PAUSE_TILL));
            $this->logTrail($this::INFO, "($adminUser Attempt) ERROR: User Account [$raduser] already paused on $pausedon till $pausedtill", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "ERROR: User Account [$raduser] already paused on $pausedon till $pausedtill"];
        endif;
        
        //check if expired
        $expire = $this->getExpirationDate($raduser);
        $today = strtotime(date("Y-m-d H:i:s"));
        $expirystr = strtotime($expire); 
        $daysLeft = round(($expirystr - $today)/(24*3600));
        if ( $daysLeft < 1):
            $exipredon = date( 'd-m-Y H:i:s', $expirystr);
            $this->logTrail($this::INFO, "($adminUser Attempt) ERROR: User Account [$raduser] has already expired or about to expire on $exipredon and cannot be paused", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "ERROR: User Account [$raduser] has already expired or about to expire on $exipredon and cannot be paused "];
        endif;
        
        $this->db->autocommit(FALSE);
        
        $ins = "INSERT INTO tbl_pause_account (USERNAME, PAUSE_DATE, PAUSE_TILL, IS_PAUSED, DAYS_TO_EXPIRE, PAUSED_BY, CUR_EXPIRATION) VALUES 
                 (?, NOW(), ?, 1, ?, ?, ?)";
        $this->db->insert($ins, "ssiis", $raduser, $pause_till, $daysLeft, $adminID, $expire)? null : $all_query_ok=false; 
        
        $upd = "UPDATE rm_users SET enableuser=0 WHERE username=?";
        $this->db->execute_query($upd, "s", $raduser)? null : $all_query_ok=false;         
        
        $all_query_ok ? $this->db->commit() : $this->db->rollback();
        
        $this->db->autocommit(TRUE);
        
        $pausetill = date( 'd-m-Y H:i:s', strtotime($pause_till));
        if ($all_query_ok) :   
            $this->logTrail($this::INFO, "($adminUser Attempt) SUCCESS: User Account [$raduser] was successfully paused till $pausetill", $this::STATUS_PASSED, get_client_ip_env()); 
            return ["STATUS"=>1, "MSG"=> "SUCCESS: User Account [$raduser] was successfully paused till $pausetill"];
        else:
            $this->logTrail($this::INFO, "($adminUser Attempt) ERROR: Unable to Pause User Account [$raduser] till $pausetill", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "ERROR: Unable to Pause User Account [$raduser] till $pausetill"];
        endif;
    }
    
    
    public function pausedAccountList($searchval='', $sortby='PAUSE_DATE', $sortorder='desc', $startrow=0, 
            $len=50, $expstart='', $expend='', $actstatus=-1) {
        $ret = array();
        
        $ad = "";
        if (is_numeric($actstatus) && $actstatus > -1):
            $ad .= " AND IS_PAUSED = $actstatus";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR tpa.USERNAME LIKE '%$searchval%' ) ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= (is_numeric($actstatus) && $actstatus == 0)? " AND ( DATE(DATE_UNPAUSED) >= '$expstart' ) " : " AND ( DATE(PAUSE_DATE) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= (is_numeric($actstatus) && $actstatus == 0)? " AND ( DATE(DATE_UNPAUSED) >= '$expend' ) " : " AND ( DATE(PAUSE_DATE) >= '$expend' ) ";
        endif; 
        
        $tqry = "SELECT PAUSE_ID, tpa.USERNAME, CONCAT(firstname, ' ', lastname) AS 'FULLNAME', PAUSE_DATE, PAUSE_TILL, IS_PAUSED, DAYS_TO_EXPIRE, PAUSED_BY,
		UNPAUSED_BY, DATE_UNPAUSED, PLAN_NAME, CUR_EXPIRATION AS 'expiration', tad.FULLNAME AS 'PAUSED_BY_NAME', tad1.FULLNAME AS 'UNPAUSED_BY_NAME'
 FROM tbl_pause_account tpa
LEFT JOIN tbl_user_extend tu ON tpa.USERNAME=tu.username
LEFT JOIN tbl_admins tad ON tpa.PAUSED_BY=tad.AID
LEFT JOIN tbl_admins tad1 ON tpa.UNPAUSED_BY=tad1.AID ";
        $mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_pause_account ";
        $some_st = $this->db->select($mqry1); 
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; 
        if ($ad==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$tqry WHERE 1 $ad";  
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        $sn=0;
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
            if ($_SESSION[$this->sid.'readonly'] == 0 && $row->IS_PAUSED == 1):
                $edit .= '<form id="gFormDel_' . $row->USERNAME . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->USERNAME . '" href="javascript:void(0)" class="gFormDel" title="Unpause User ' . $row->USERNAME . '" data-toggle="tooltip">
                        <span><i class="fa fa-play text-green"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->USERNAME . '" /></a>'; 
                $edit .= "</form>";
            endif;
            $ret[] = array("SN"=>++$sn, "USERNAME"=>$row->USERNAME, "FULLNAME"=>$row->FULLNAME, "PLAN_NAME"=>$row->PLAN_NAME, 
                        "expiration"=>date( 'd-m-Y H:i:s', strtotime($row->expiration)),
                         "DAYS_TO_EXPIRE"=>$row->DAYS_TO_EXPIRE, "PAUSE_DATE"=>date( 'd-m-Y H:i:s', strtotime($row->PAUSE_DATE)), 
                         "PAUSE_TILL"=>date( 'd-m-Y H:i:s', strtotime($row->PAUSE_TILL)),
                        "PAUSED_BY"=>$row->PAUSED_BY_NAME, "STAT"=>(($row->IS_PAUSED == 0)? "UNPAUSED" : "PAUSED"), 
                        "DATE_UNPAUSED"=>($row->DATE_UNPAUSED)?date( 'd-m-Y H:i:s', strtotime($row->DATE_UNPAUSED)) : "<center>-</center>", "UNPAUSED_BY"=>$row->UNPAUSED_BY_NAME, 
                     	"ACTION"=>"<center><font size='5px'>$edit</font></center>" );
        }
        
        return $ret;
    }
    
    
    public function expiredConnectedList($searchval='', $sortby='expiration', $sortorder='asc', $startrow=0, 
            $len=50, $expstart='', $expend='') {
        $ret = array();
        
        $ad = "";
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR username LIKE '%$searchval%' ) ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(expiration) >= '$expstart' ) " ;
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(expiration) >= '$expend' ) " ;
        endif; 
        
        $tqry = "SELECT username, CONCAT(firstname, ' ', lastname) AS 'FULLNAME', company, mobile, email, expiration, PLAN_NAME, lastlogoff,
DATEDIFF(NOW(),lastlogoff) AS 'DAYS_LOGGEDIN', DATEDIFF(NOW(), expiration) AS 'DAYS_EXPIRED'
FROM tbl_user_extend
WHERE expiration < NOW() AND username IN (SELECT username from radacct WHERE acctstoptime IS NULL) ";
        $mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_user_extend ";
        $some_st = $this->db->select($mqry1); 
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; 

        $fqry = ($ad != '')?  "$tqry AND $ad" : $tqry;  
        $some_s = $this->db->select($fqry);
        $this->totalRecordwithFilter = $some_s->num_rows();

        
        $limit = ($len == -1)? "" : " LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? " ORDER BY $sortby $sortorder" : " ORDER BY tad.USERNAME ASC";
        $qry = ($ad != '')?  "$tqry AND $ad $msort $limit" : "$tqry $msort $limit"; 
        $some_sth = $this->db->select($qry);
        $sn=0;
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
//            if ($_SESSION[$this->sid.'readonly'] == 0 && $row->IS_RESTORED == 0):
//                $edit .= '<form id="gFormDel_' . $row->USERNAME . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
//                $edit .= '<a data-val="' . $row->USERNAME . '" href="javascript:void(0)" class="gFormDel" title="Unpause User ' . $row->USERNAME . '" data-toggle="tooltip">
//                        <span><i class="fa fa-play text-green"></i></span>
//                        <input type="hidden" name="user" id="user" value="' . $row->USERNAME . '" /></a>'; 
//                $edit .= "</form>";
//            endif;
            $ret[] = array("SN"=>++$sn, "username"=>$row->username, "FULLNAME"=>$row->FULLNAME, "PLAN_NAME"=>$row->PLAN_NAME, 
                         "company"=>$row->company, "email"=>$row->email,
                        "mobile"=>$row->mobile, 
                        "expiration"=>date( 'd-m-Y H:i:s', strtotime($row->expiration)), "DAYS_LOGGEDIN"=>$row->DAYS_LOGGEDIN, 
                        "lastlogoff"=>date( 'd-m-Y H:i:s', strtotime($row->lastlogoff)), "DAYS_EXPIRED"=>$row->DAYS_EXPIRED, 
                     	"ACTION"=>"<center><font size='5px'>$edit</font></center>" ); 
        }
        
        return $ret;
    }
    
    public function getArchivedAccount($username) {
        $strsql = "SELECT taa.*, tp.SRVID FROM tbl_account_archive taa LEFT JOIN tbl_plans tp ON taa.PLAN_ID=tp.PLAN_ID WHERE taa.username = ?";
        $some_st = $this->db->select($strsql, "s", $username); 
        $rec = $some_st->fetch_object();
        
        return $rec;
    }
    
    public function restoreUserAccount($user, $expiry_date, $adminID, $adminUser) {
        $postdata = ["user"=>$user, "expiry_date"=>$expiry_date, "adminID"=>$adminID, "adminUser"=>$adminUser, "test"=>1]; //echo SERVER_URL."ajax/user_restore";
        //send post
        $ret = $this->__curlURL(SERVER_URL."ajax/user_restore", 1, http_build_query($postdata)); //print_r($ret);
        if(stripos($ret, "Success:") !== false):
            $strupd = "UPDATE tbl_account_deleted SET IS_RESTORED=1, RESTORED_BY=?, DATE_RESTORED=NOW() WHERE USERNAME=?";
            $this->db->execute_query($strupd, "is", $adminID, $user);
            
            $this->logTrail($this::NEW_USER, $ret, $this::STATUS_PASSED, get_client_ip_env()); 
            return ["STATUS"=>1, "MSG"=> $ret];
        else:
            //not created
            $this->logTrail($this::NEW_USER, $ret, $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> $ret];
        endif;
    }
    
    
    public function archivedAccountList($searchval='', $sortby='PAUSE_DATE', $sortorder='desc', $startrow=0, 
            $len=50, $expstart='', $expend='', $actstatus=-1) {
        $ret = array();
        
        $ad = "";
        if (is_numeric($actstatus) && $actstatus > -1):
            $ad .= " AND IS_RESTORED = $actstatus";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR tad.USERNAME LIKE '%$searchval%' ) ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= (is_numeric($actstatus) && $actstatus == 0)? " AND ( DATE(DATE_DELETED) >= '$expstart' ) " : " AND ( DATE(DATE_RESTORED) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= (is_numeric($actstatus) && $actstatus == 0)? " AND ( DATE(DATE_DELETED) >= '$expend' ) " : " AND ( DATE(DATE_RESTORED) >= '$expend' ) ";
        endif; 
        
        $tqry = "SELECT tad.USERNAME, CONCAT(firstname,lastname) AS'FULLNAME', PLAN_NAME, DATE_DELETED AS 'DATE_ARCHIVED', 
DELETE_REASON AS 'REASON', ta.FULLNAME AS 'ARCHIVED_BY', DBUSER, PLAN_ID, IS_RESTORED, ta1.FULLNAME AS 'RESTORED_BY', DATE_RESTORED
FROM `tbl_account_deleted` tad
LEFT JOIN tbl_account_archive taa ON tad.USERNAME=taa.username
LEFT JOIN tbl_admins ta ON tad.DELETEDBY=ta.AID
LEFT JOIN tbl_admins ta1 ON tad.RESTORED_BY=ta1.AID ";
        $mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_account_deleted ";
        $some_st = $this->db->select($mqry1); 
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; 
        if ($ad==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$tqry WHERE 1 $ad";  
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY tad.USERNAME ASC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        $sn=0;
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
           if ($_SESSION[$this->sid.'readonly'] == 0 && $row->IS_RESTORED == 0):
               $edit .= '<form id="gFormDel_' . $row->USERNAME . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
               $edit .= '<a data-val="' . $row->USERNAME . '" href="javascript:void(0)" class="gFormDel" title="Unpause User ' . $row->USERNAME . '" data-toggle="tooltip">
                       <span><i class="fa fa-play text-green"></i></span>
                       <input type="hidden" name="user" id="user" value="' . $row->USERNAME . '" /></a>'; 
               $edit .= "</form>";
           endif;
            $ret[] = array("SN"=>++$sn, "USERNAME"=>$row->USERNAME, "FULLNAME"=>$row->FULLNAME, "PLAN_NAME"=>$row->PLAN_NAME, 
                        "DATE_ARCHIVED"=>date( 'd-m-Y H:i:s', strtotime($row->DATE_ARCHIVED)),
                         "REASON"=>$row->REASON, "ARCHIVED_BY"=>$row->ARCHIVED_BY,
                        "STAT"=>(($row->IS_RESTORED == 0)? "ARCHIVED" : "RESTORED"), 
                       "DATE_RESTORED"=>($row->DATE_RESTORED)?date( 'd-m-Y H:i:s', strtotime($row->DATE_RESTORED)) : "<center>-</center>", "RESTORED_BY"=>$row->RESTORED_BY, 
                     	"ACTION"=>"<center><font size='5px'>$edit</font></center>" );
        }
        
        return $ret;
    }
    
    
    public function complimentaryAccountStat($account_type='', $is_upcountry=-1) {
        $ret = array();
        
         $tqry = "SELECT COUNT(username) AS NFREQ
                          
            FROM 
            (
                SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, ru.mobile, ru.email, company,
                taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
                ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
                limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
                mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
                  INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID, ACCOUNT_TYPE, tad.FULLNAME
                FROM tbl_user_extend ru 
                JOIN rm_services  rs USING (srvid)
                INNER JOIN tbl_comp_account tca ON ru.username=tca.USERNAME
                LEFT JOIN tbl_admins tad ON tca.ADDEDBY=tad.AID
              
            ) AS tmp 
             WHERE 1 AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' )
                 ";
         
         $exp = $tqry . " AND tmp.enableuser = 1 AND
                        (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR 
                      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR
                      IF (limitcomb = 1, comblimit -
                      (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) +
                      (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR 
                      IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                      FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR 
                      IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
                    ";
         
         $act = $tqry . " AND
                        (limitdl = 0 OR IF (limitdl =1, downlimit -
                      (SELECT COALESCE(SUM(acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) -
                      (SELECT COALESCE(SUM(dlbytes), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limitul = 0 OR IF (limitul =1, uplimit -
                      (SELECT COALESCE(SUM(acctinputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) -
                      (SELECT COALESCE(SUM(ulbytes ), 0)
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limitcomb = 0 OR IF (limitcomb =1, comblimit -
                      (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) +
                      (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limituptime = 0 OR IF (limituptime=1, uptimelimit -
                      (SELECT COALESCE(SUM(acctsessiontime), 0)
                      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)
                    ";
         
         $paused = $tqry . " AND username IN (SELECT USERNAME FROM `tbl_pause_account` WHERE IS_PAUSED=1)";
         
         $ad = ''; $mad = '';
        if (is_int($is_upcountry) && $is_upcountry > -1){
            $mad = " AND username IN (SELECT username FROM tbl_user_extend 
                       WHERE PLAN_ID IN (SELECT PLAN_ID FROM tbl_plans WHERE IS_UPCOUNTRY=$is_upcountry))";
            $exp .= $mad; $act .= $mad; $paused .= $mad;
        }
        if (in_array(strtoupper($account_type), ['C', 'S'])){
            $ad = " AND ACCOUNT_TYPE = '". strtoupper($account_type) ."'";
            $exp .= $ad; $act .= $ad; $paused .= $ad;
        }
        $some_sth = $this->db->select($exp);
        $row = $some_sth->fetch_object();
        $ret["EXPIRED"] = $row->NFREQ;
        $some_sth = $this->db->select($act);
        $row = $some_sth->fetch_object();
        $ret["ACTIVE"] = $row->NFREQ;
        $some_sth = $this->db->select($paused);
        $row = $some_sth->fetch_object();
        $ret["PAUSED"] = $row->NFREQ;
        
        return $ret;
    }
    
    
    public function isComplimentary($uname) {
        $sel = "SELECT * FROM tbl_comp_account WHERE USERNAME LIKE ?";
        $some_sth = $this->db->select($sel, 's', $uname);
        $rows = $some_sth->num_rows();
        
        return $rows;
    }
    
    
    public function add2Complimentary($uname, $compType, $adminUserId) {
        if ($this->isComplimentary($uname)) {
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to Add [$uname] to Complimentary/Staff List - Already exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to add [$uname] to Complimentary/Staff List - Already Exist";
        }
        $comp = ['C'=>"Complimentary", 'S'=>"Staff"];
        if (!in_array($compType, array_keys($comp))){
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to Add [$uname] as {$comp[$compType]} Account to Complimentary/Staff List", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to Add [$uname] as {$comp[$compType]} Account to Complimentary/Staff List";
        }
        $ins = "INSERT INTO tbl_comp_account (RECID, USERNAME, ADDEDBY, ACCOUNT_TYPE, DATE_ADDED) 
                VALUES (NULL, ?, ?, ?, NOW())";
        $in_id = $this->db->insert($ins, 'sis', $uname, $adminUserId, $compType);
        if ($in_id) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$in_id - $uname] Added as {$comp[$compType]} Account to Complimentary/Staff List!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: User [$uname] Added as {$comp[$compType]} Account to Complimentary/Staff List!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to Add [$in_id - $uname] as {$comp[$compType]} Account to Complimentary/Staff List", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to Add [- $uname] as {$comp[$compType]} Account to Complimentary/Staff List";
        endif;
    }
    
    
    public function delFromComplimentary($uname, $adminUser) {
        if (!$this->isComplimentary($uname)) {
            $this->logTrail($this::INFO, "({$adminUser} attempt) Error: Unable to Remove [$uname] from Complimentary/Staff List - Not Found", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to Remove [$uname] from Complimentary List/Staff - Not Found";
        }
        
        $all_query_ok= true;
        $sql = "DELETE FROM `tbl_comp_account` WHERE (`USERNAME`=?)";
        $this->db->execute_query($sql, 's', $uname)? null : $all_query_ok=false;
        if ($all_query_ok) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$uname] removed from Complimentary/Staff List!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: User [$uname] removed from Complimentary/Staff List!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to remove [- $uname] from Complimentary/Staff List", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to remove [- $uname] from Complimentary/Staff List";
        endif;
    }
    
    
    public function complimentaryAccountList($account_type='', $is_enabled=-1, $is_linked = -1, $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=50, $expstart='', $expend='', $expiring=-1, $expired=-1, $area=0, $region=0, $olt=0, $gpon=0, $is_active=-1, $plan=0) {
        $ret = array();
        
        $ad = "";
        if (in_array(strtoupper($account_type), ['C', 'S'])){
            $ad .= " AND ACCOUNT_TYPE = '". strtoupper($account_type) ."'";
        }
        if (( $is_enabled != 0) ) :
    		$ad .= " AND tmp.enableuser = 1";
    	else:
            $ad .= " AND tmp.enableuser = $is_enabled";
        endif;
        if ($is_active <> -1 && ($is_active == 1 || $is_active == 0) ) :
            //$ad .= ($is_active == 0)? " AND expiration < NOW()" : " AND expiration >= NOW()";
            // $actsign = ($is_active == 0)? " <= " : " > ";
    		if ($is_active == 0):
                    $ad .= " AND
                        (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR 
                      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR
                      IF (limitcomb = 1, comblimit -
                      (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) +
                      (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR 
                      IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                      FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                      OR 
                      IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
                    ";
    		else:
                    $ad .= " AND
                        (limitdl = 0 OR IF (limitdl =1, downlimit -
                      (SELECT COALESCE(SUM(acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) -
                      (SELECT COALESCE(SUM(dlbytes), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limitul = 0 OR IF (limitul =1, uplimit -
                      (SELECT COALESCE(SUM(acctinputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) -
                      (SELECT COALESCE(SUM(ulbytes ), 0)
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limitcomb = 0 OR IF (limitcomb =1, comblimit -
                      (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                      FROM radacct WHERE radacct.username = tmp.username) +
                      (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limituptime = 0 OR IF (limituptime=1, uptimelimit -
                      (SELECT COALESCE(SUM(acctsessiontime), 0)
                      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
                      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
                      AND
                      (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)";
    		endif;
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                     AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (firstname LIKE '%$searchval%' OR lastname LIKE '%$searchval%' OR email LIKE '%$searchval%' OR company LIKE '%$searchval%' OR username LIKE '%$searchval%' OR PLAN_NAME = '$searchval') ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(expiration) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(expiration) <= '$expend' ) ";
        endif; 
        $ad .= (is_numeric($expired) && ($expired > -1) )? " AND ( ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                  ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                ( (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR
                ( (IF (limitcomb = 1, comblimit -
                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) +
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                ( (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0) AND 
                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) BETWEEN -$expired AND 0 ) )
                OR 
                IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) BETWEEN -$expired AND 0 ) " : "";
        $ad .= (is_numeric($expiring) && ($expiring > -1) )? " AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $expiring" : "";
        $ad .= (is_numeric($area) && ($area > 0) )? " AND AREA_ID=$area" : "";
        $ad .= (is_numeric($region) && ($region > 0) )? " AND REGION_ID=$region" : "";
        $ad .= (is_numeric($olt) && ($olt > 0) )? " AND OLT_ID=$olt" : "";
        $ad .= (is_numeric($gpon) && ($gpon > 0) )? " AND GPON_ID=$gpon" : "";
        $ad .= (is_numeric($plan) && ($plan > 0) )? " AND PLAN_ID=$plan" : "";
        
        $tqry = "SELECT username, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, expiration, uptimelimit, credits, comment,
  	    enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,  lastlogoff /*LEFT(lastlogoff, 10) AS 'lastlogoff'*/
  	    , IF (limitdl = 1, downlimit - COALESCE((SELECT SUM(acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'DOWN',

                IF (limitul = 1, uplimit - COALESCE((SELECT SUM(acctinputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UP',

                IF (limitcomb =1, comblimit - COALESCE((SELECT SUM(acctinputoctets + acctoutputoctets) FROM radacct
                WHERE radacct.username = tmp.username) -
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'BALANCE',

                IF (limituptime = 1, uptimelimit - COALESCE((SELECT SUM(acctsessiontime) FROM radacct
                WHERE radacct.username = tmp.username) - 
                (SELECT COALESCE(SUM(acctsessiontime), 0) FROM rm_radacct
                WHERE rm_radacct.username = tmp.username), 0), 0) AS 'UPTIME',

                 AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, ACCOUNT_TYPE, FULLNAME
                          
            FROM 
            (
                SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, ru.mobile, ru.email, company,
                taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
                ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
                limitul, rs.limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
                mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, AREA_NAME, REGION_NAME, OLT_NAME, GPON_NAME, 
                  INTERFACE, SERIALNO, VLAN, PLAN_NAME, PLAN_ID, AREA_ID, REGION_ID, OLT_ID, GPON_ID, ACCOUNT_TYPE, tad.FULLNAME
                FROM tbl_user_extend ru 
                JOIN rm_services  rs USING (srvid)
                INNER JOIN tbl_comp_account tca ON ru.username=tca.USERNAME
                LEFT JOIN tbl_admins tad ON tca.ADDEDBY=tad.AID
              
            ) AS tmp 
                 ";
        
        $mqry1 = "SELECT COUNT(username) AS 'TOTAL' FROM tbl_user_extend ";
        $loc = [];
        $olt = [];
        $some_st = $this->db->select($mqry1); // $mqry);
    	// new
    	$rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; // $some_st->num_rows();
        if ($ad==""):
    		$this->totalRecordwithFilter = $this->totalRecords;
    	else:
        	$fqry = "$tqry WHERE 1 AND (acctype = '0' OR acctype = '1' OR acctype = '3' OR acctype = '4' ) $ad";  // "$mqry WHERE 1 $ad"; 
    		// echo ($is_active == 1 || $is_active == 0)? $fqry : "u";
        	$some_s = $this->db->select($fqry);
    		// new
    		// $rec = $some_s->fetch_object();
        	$this->totalRecordwithFilter = $some_s->num_rows(); // $rec->TOTAL; // $some_s->num_rows();
    	endif;
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY username ASC";
        $qry = "$tqry WHERE 1 AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '3'  OR tmp.acctype = '4' ) $ad $msort $limit";
    	// echo ($is_active == 1 || $is_active == 0)? $qry : "v";
        $some_sth = $this->db->select($qry);
        
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $edit = "";
            if ($_SESSION[$this->sid.'usertype_id'] == 4 || $_SESSION[$this->sid.'usertype_id'] == 7):
                $edit .= '<form id="gFormDel_' . $row->username . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->username . '" href="javascript:void(0)" class="gFormDel" title="Remove User ' . $row->username . ' from list" data-toggle="tooltip">
                        <span><i class="fa fa-close text-red"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
                $edit .= "</form>";
            endif;
            if ($_SESSION[$this->sid.'readonly'] == 0):
                $rd = ($account_type=='C')? str_replace("=","",base64_encode('ad_compList')) : str_replace("=","",base64_encode('ad_staffList'));
                $edit .= '<form id="gFormEdit_' . $row->username . '" action="ad_edituserplus?rd='.$rd.'" method="post" style="display: inline-block; ">';
                $edit .= '<a href="javascript: submitform(\'gFormEdit_' . $row->username . '\')" title="Edit User ' . $row->username . '" data-toggle="tooltip">
                        <span><i class="fa fa-edit text-yellow"></i></span>
                        <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
                $edit .= "</form>";
            endif;
            //view form
            $edit .= '<form id="gFormView_' . $row->username . '" action="userusage" method="post" target="_blank" style="display: inline-block; ">';
            $edit .= '<a href="javascript: submitform(\'gFormView_' . $row->username . '\')" title="View User ' . $row->username . ' Info" data-toggle="tooltip">
                    <span><i class="fa fa-eye text-green"></i></span>
                    <input type="hidden" name="user" id="user" value="' . $row->username . '" /></a>'; 
            $edit .= "</form>";
            $bal = "-";
            if ($row->limitcomb):
                $bal = formatBytes( ($row->BALANCE), 2);
            endif;
            $curDate = date('Y-m-d H:i:s');
            $daysLeft = (strtotime($curDate) - strtotime($row->expiration));
            $ret[] = array("EDIT"=>$edit, "USERNAME"=>$row->username, "SERVICE"=>$row->srvname, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=>$row->lastname, "COMPANY"=>$row->company, "ADDRESS"=>$row->address, "CITY"=>$row->city, "STATE"=>$row->state, "BALANCE"=>$bal,
                        "EXPIRATION"=>date( 'd-m-Y', strtotime($row->expiration)),
                         "IP"=>$row->staticipcpe, "EMAIL"=>$row->email,
                        "PHONE"=>$row->mobile, "REGDATE"=>date( 'd-m-Y', strtotime($row->createdon)), "LASTLOGOFF"=>date( 'd-m-Y H:i:s', strtotime($row->lastlogoff)),
                        "ACCOUNT_TYPE"=>($row->ACCOUNT_TYPE=='S')? "Staff" : "Complimentary", "ADDED_BY"=>$row->FULLNAME,
                        "AREA"=>$row->AREA_NAME, "REGION"=>$row->REGION_NAME, "OLT"=>$row->OLT_NAME, 
                     	"GPON"=>$row->GPON_NAME, "INTERFACE"=>$row->INTERFACE, "SERIALNO"=>$row->SERIALNO, "VLAN"=>$row->VLAN, 
                        "STAT"=>($row->enableuser)? (($daysLeft < 0)? "Active" : "Expired"): "Disabled" );
//            $ret[] = $row; //"LASTLOGOFF"=>$row->lastlogoff, 
        }
        
        return $ret;
    }
    
    
    public function manRenewRpt($month, $yr, $userid=0, $limit = 0) {
        $exp = $ret = array();
        $adc = $lim = "";
        if ($limit > 0) {
            $lim = " LIMIT $limit";
        }
        
        if ($userid > 0 && is_int($userid)):
            $userid = (int)$userid;
            $adc .= " AND ADMIN = $userid";
        endif;
        $qry = "SELECT m.RAD_USERNAME, EXPIRY_DATE, NEW_EXPIRY_DATE, ADDED_DATA, EXTEND_ONLY, 
                    ADMIN, tad.FULLNAME, DATEDONE, ru.srvid, tp.PLAN, tp.AMOUNT,  
                    CASE WHEN DATEDONE < EXPIRY_DATE THEN DATEDIFF(NEW_EXPIRY_DATE,EXPIRY_DATE)
						ELSE DATEDIFF(NEW_EXPIRY_DATE,DATEDONE) END AS 'NDAYS'  
                FROM `tbl_manrenewal` m
                LEFT JOIN tbl_admins tad ON m.ADMIN = tad.AID
                LEFT JOIN rm_users ru ON m.RAD_USERNAME=ru.username
                LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                WHERE YEAR(DATEDONE)=? AND MONTH(DATEDONE)=? $adc $lim";  
 
        $some_sth = $this->db->select($qry, "ii", $yr, $month);  
        while ( $row = $some_sth->fetch_object() ) { 
            $ret["LIST"][] = ["RAD_USERNAME"=>$row->RAD_USERNAME, "EXPIRY_DATE"=>$row->EXPIRY_DATE, 
                        "NU_EXPIRY_DATE"=>$row->NEW_EXPIRY_DATE, "ADDED_DATA"=> ($row->ADDED_DATA), 
                        "EXTEND_ONLY"=>$row->EXTEND_ONLY, "ADMIN"=>$row->ADMIN, "NDAYS"=>$row->NDAYS,
                        "FULLNAME"=>$row->FULLNAME, "DATEDONE"=>$row->DATEDONE, 
                        "SRVID"=>$row->srvid, "PLAN"=>$row->PLAN, "AMOUNT"=>$row->AMOUNT];
        }        
        
        $qry = "SELECT EXTEND_ONLY, COUNT(RAD_USERNAME) AS 'NO' FROM `tbl_manrenewal` 
                WHERE YEAR(DATEDONE)=? AND MONTH(DATEDONE)=?
                GROUP BY EXTEND_ONLY";  
 
        $some_sth = $this->db->select($qry, "ii", $yr, $month);  
        while ( $row = $some_sth->fetch_object() ) { 
            $ret["EXT"][$row->EXTEND_ONLY] = $row->NO;
        }       
        
        $qry = "SELECT FULLNAME, COUNT(RAD_USERNAME) AS 'NO' FROM `tbl_manrenewal` m
                LEFT JOIN tbl_admins tad ON m.ADMIN = tad.AID
                WHERE YEAR(DATEDONE)=? AND MONTH(DATEDONE)=?
                GROUP BY FULLNAME";  
 
        $some_sth = $this->db->select($qry, "ii", $yr, $month);  
        while ( $row = $some_sth->fetch_object() ) { 
            $ret["ADMINCOUNT"][$row->FULLNAME] = $row->NO;
        }
        
        return $ret;
    }
    
    
    public function getRegions($area_id=0, $src="") {
        $params = "";
        $types = "";
        $val = [];
        if ($area_id > 0):
            $params = " WHERE tr.AREA_ID = ?";
            $types = "i";
            $val[] = $area_id;
        endif;
        if (strlen($src)>0):
            if ($params == "") :
                $params = " WHERE REGION_NAME LIKE ?";
                $types = "s";
                $val[] = "%$src%";
            else:
                $params .= " AND REGION_NAME LIKE ?";
                $types .= "s";
                $val[] = "%$src%";
            endif;
        endif;
        $strsql = "SELECT tr.AREA_ID, AREA_NAME, REGION_ID, REGION_NAME, tr.DATEADDED, tr.ADDEDBY, ta.FULLNAME AS 'ADMIN_NAME' FROM `tbl_regions` tr
                    LEFT JOIN tbl_areas a ON a.AREA_ID=tr.AREA_ID
                    LEFT JOIN tbl_admins ta ON tr.ADDEDBY=ta.AID $params ORDER BY AREA_NAME, REGION_NAME"; //echo $strsql; print_r($val);echo $types;
        if (count($val)):
            $args = array_merge( [$strsql, $types], $val);
        else:
            $args = [$strsql];
        endif;
        $some_sth = call_user_func_array(array($this->db, 'select'), $this->ref($args));

        $ret=[];
        while ( $row = $some_sth->fetch_object() ) { 
            $ret[] = ["AREA_ID"=>$row->AREA_ID, "AREA_NAME"=>$row->AREA_NAME, "REGION_ID"=>$row->REGION_ID, 
                        "REGION_NAME"=>$row->REGION_NAME, "DATEADDED"=>$row->DATEADDED, "ADMIN_NAME"=>$row->ADMIN_NAME];
        }
        return $ret;
    }
    
    
    public function getGpon($olt_id=0, $src="") {
        $params = "";
        $types = "";
        $val = [];
        if ($olt_id > 0):
            $params = " WHERE tr.OLT_ID = ?";
            $types = "i";
            $val[] = $olt_id;
        endif;
        if (strlen($src)>0):
            if ($params == "") :
                $params = " WHERE GPON_NAME LIKE ?";
                $types = "s";
                $val[] = "%$src%";
            else:
                $params .= " AND GPON_NAME LIKE ?";
                $types .= "s";
                $val[] = "%$src%";
            endif;
        endif;
        $strsql = "SELECT tr.OLT_ID, OLT_NAME, GPON_ID, GPON_NAME, tr.DATEADDED, tr.ADDEDBY, ta.FULLNAME AS 'ADMIN_NAME' FROM `tbl_gpon` tr
                    LEFT JOIN tbl_olt a ON a.OLT_ID=tr.OLT_ID
                    LEFT JOIN tbl_admins ta ON tr.ADDEDBY=ta.AID $params ORDER BY OLT_NAME, GPON_NAME"; //echo $strsql; print_r($val);echo $types;
        if (count($val)):
            $args = array_merge( [$strsql, $types], $val);
        else:
            $args = [$strsql];
        endif;
        $some_sth = call_user_func_array(array($this->db, 'select'), $this->ref($args));

        $ret=[];
        while ( $row = $some_sth->fetch_object() ) { 
            $ret[] = ["OLT_ID"=>$row->OLT_ID, "OLT_NAME"=>$row->OLT_NAME, "GPON_ID"=>$row->GPON_ID, 
                        "GPON_NAME"=>$row->GPON_NAME, "DATEADDED"=>$row->DATEADDED, "ADMIN_NAME"=>$row->ADMIN_NAME];
        }
        return $ret;
    }
    
    
    public function getOLT($src="") {
        if (strlen($src)>0) :
            $qry = "SELECT OLT_ID, OLT_NAME, DATEADDED, ADDEDBY, ta.FULLNAME AS 'ADMIN_NAME' FROM `tbl_olt` a
                        LEFT JOIN tbl_admins ta ON a.ADDEDBY=ta.AID
                        WHERE OLT_NAME LIKE ? ORDER BY OLT_NAME";
            $some_sth = $this->db->select($qry, "s", "%$src%");  
        else:
            $qry = "SELECT OLT_ID, OLT_NAME, DATEADDED, ADDEDBY, ta.FULLNAME AS 'ADMIN_NAME' FROM `tbl_olt` a
                        LEFT JOIN tbl_admins ta ON a.ADDEDBY=ta.AID ORDER BY OLT_NAME";
            $some_sth = $this->db->select($qry); 
        endif;
        $ret=[];
        while ( $row = $some_sth->fetch_object() ) { 
            $ret[] = ["OLT_ID"=>$row->OLT_ID, "OLT_NAME"=>$row->OLT_NAME, 
                        "DATEADDED"=>$row->DATEADDED, "ADMIN_NAME"=>$row->ADMIN_NAME];
        }
        return $ret;
    }
    
    
    public function getAreas($src="") {
        if (strlen($src)>0) :
            $qry = "SELECT AREA_ID, AREA_NAME, DATEADDED, ADDEDBY, ta.FULLNAME AS 'ADMIN_NAME' FROM `tbl_areas` a
                        LEFT JOIN tbl_admins ta ON a.ADDEDBY=ta.AID
                        WHERE AREA_NAME LIKE ? ORDER BY AREA_NAME";
            $some_sth = $this->db->select($qry, "s", "%$src%");  
        else:
            $qry = "SELECT AREA_ID, AREA_NAME, DATEADDED, ADDEDBY, ta.FULLNAME AS 'ADMIN_NAME' FROM `tbl_areas` a
                        LEFT JOIN tbl_admins ta ON a.ADDEDBY=ta.AID ORDER BY AREA_NAME";
            $some_sth = $this->db->select($qry); 
        endif;
        $ret=[];
        while ( $row = $some_sth->fetch_object() ) { 
            $ret[] = ["AREA_ID"=>$row->AREA_ID, "AREA_NAME"=>$row->AREA_NAME, 
                        "DATEADDED"=>$row->DATEADDED, "ADMIN_NAME"=>$row->ADMIN_NAME];
        }
        return $ret;
    }
    
    public function addOLT($olt, $admin_id) {
        $olt_exist = $this->getOLT($olt);
        
        if (count($olt_exist) == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: OLT [$olt] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: OLT [$olt] already Exist";
        else :
            $ins = "INSERT INTO tbl_olt (OLT_NAME, `DATEADDED`, ADDEDBY)
                    VALUES (?, NOW(), ?)";
            $in_id = $this->db->insert($ins, 'si', $olt, $admin_id);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: OLT [$in_id - $olt] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: OLT [$olt] Created!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create OLT [$in_id - $olt]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create OLT [$olt]";
            endif;
        endif;
    }
    
    public function addArea($area, $admin_id) {
        $area_exist = $this->getAreas($area);
        
        if (count($area_exist) == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Area [$area] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Area [$area] already Exist";
        else :
            $ins = "INSERT INTO tbl_areas (AREA_NAME, `DATEADDED`, ADDEDBY)
                    VALUES (?, NOW(), ?)";
            $in_id = $this->db->insert($ins, 'si', $area, $admin_id);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Area [$in_id - $area] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Area [$area] Created!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Area [$in_id - $area]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create Area [$area]";
            endif;
        endif;
    }
    
    public function addRegion($area_id, $region, $admin_id) {
        $region_exist = $this->getRegions($area_id, $region);
        
        if (count($region_exist) == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Region [$region] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Region [$region] already Exist";
        else :
            $ins = "INSERT INTO tbl_regions (AREA_ID, REGION_NAME, `DATEADDED`, ADDEDBY)
                    VALUES (?, ?, NOW(), ?)";
            $in_id = $this->db->insert($ins, 'isi', $area_id, $region, $admin_id);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Region [$in_id - $region] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Region [$region] Created!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Region [$in_id - $region]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create Region [$region]";
            endif;
        endif;
    }
    
    public function addGpon($olt_id, $gpon, $admin_id) {
        $gpon_exist = $this->getGpon($olt_id, $gpon);
        
        if (count($gpon_exist) == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Gpon [$gpon] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Gpon [$gpon] already Exist";
        else :
            $ins = "INSERT INTO tbl_gpon (OLT_ID, GPON_NAME, `DATEADDED`, ADDEDBY)
                    VALUES (?, ?, NOW(), ?)";
            $in_id = $this->db->insert($ins, 'isi', $olt_id, $gpon, $admin_id);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Gpon [$in_id - $gpon] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Gpon [$gpon] Created!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Gpon [$in_id - $gpon]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create Gpon [$gpon]";
            endif;
        endif;
    }
    
    public function editOLT($olt_id, $olt_name) {
        $olt_exist = $this->getOLT($olt_name);
        
        if (count($olt_exist) < 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: OLT [$olt_id] does not Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: OLT [$olt_id] does not Exist";
        else :
            $upg = "UPDATE tbl_olt SET OLT_NAME=? WHERE OLT_ID=?";
            if ($this->db->execute_query($upg, "si", $olt_name, $olt_id)) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: OLT [$olt_id] Updated to [$olt_name]!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: OLT [$olt] Updated!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to update OLT [$olt_id] to [$olt_name]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to update OLT [$olt_id]";
            endif;
        endif;
    }
    
    public function deleteOLT($olt_id) {
        if ($this->OLTHasGpon($olt_id)){
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to delete OLT [$olt_id]. Gpon(s) Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to delete OLT [$olt_id]. Gpon(s) exist";
        } else {
            $strsql = "DELETE FROM tbl_olt WHERE OLT_ID = ?";
            if ($this->db->execute_query($strsql, "i", $olt_id)) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: OLT [$olt_id] Deleted!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: OLT [$olt_id] Deleted!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to delete OLT [$olt_id]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to delete OLT [$olt_id]";
            endif;
        }
    }
    
    public function OLTHasGpon($olt_id) {
        $strsql = "SELECT GPON_ID FROM tbl_gpon WHERE OLT_ID=?";
        $some_sth = $this->db->select($strsql, "i", $olt_id); 
        return $some_sth->num_rows();
    }
    
    public function editArea($area_id, $area_name) {
        $area_exist = $this->getAreas($area_name);
        
        if (count($area_exist) < 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Area [$area_id] does not Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Area [$area_id] does not Exist";
        else :
            $upg = "UPDATE tbl_areas SET AREA_NAME=? WHERE AREA_ID=?";
            if ($this->db->execute_query($upg, "si", $area_name, $area_id)) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Area [$area_id] Updated to [$area]!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Area [$area_id] Updated!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to update Area [$area_id] to [$area]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to update Area [$area_id]";
            endif;
        endif;
    }
    
    public function deleteArea($area_id) {
        if ($this->areaHasRegions($area_id)){
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to delete Area [$area_id]. Region(s) Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to delete Area [$area_id]. Region(s) exist";
        } else {
            $strsql = "DELETE FROM tbl_areas WHERE AREA_ID = ?";
            if ($this->db->execute_query($strsql, "i", $area_id)) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Area [$area_id] Deleted!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Area [$area_id] Deleted!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to delete Area [$area_id]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to delete Area [$area_id]";
            endif;
        }
    }
    
    public function deleteRegion($region_id) {
        $strsql = "DELETE FROM tbl_regions WHERE REGION_ID = ?";
        if ($this->db->execute_query($strsql, "i", $region_id)) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Region [$region_id] Deleted!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Region [$region_id] Deleted!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to delete Region [$region_id]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to delete Region [$region_id]";
        endif;

    }
    
    public function deleteGpon($gpon_id) {
        $strsql = "DELETE FROM tbl_gpon WHERE GPON_ID = ?";
        if ($this->db->execute_query($strsql, "i", $gpon_id)) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Gpon [$gpon_id] Deleted!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Gpon [$gpon_id] Deleted!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to delete Gpon [$gpon_id]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to delete Gpon [$gpon_id]";
        endif;

    }
    
    public function areaHasRegions($area_id) {
        $strsql = "SELECT REGION_ID FROM tbl_regions WHERE AREA_ID=?";
        $some_sth = $this->db->select($strsql, "i", $area_id); 
        return $some_sth->num_rows();
    }
    
    public function addLoc2RadUser($username, $area, $region, $admin_id) {
        $loc_exist = $this->getUserLoc([$username]);
        
        if (count($loc_exist) == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Location already Exist for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Location already Exist for User [$username]";
        else :
            $ins = "INSERT INTO tbl_usrloc (USERNAME, AREA, REGION, `DATEADDED`, ADDEDBY)
                    VALUES (?, ?, ?, NOW(), ?)
                    ON DUPLICATE KEY UPDATE AREA=VALUES(AREA), REGION=VALUES(REGION), DATEADDED=VALUES(DATEADDED),  ADDEDBY=VALUES(ADDEDBY)";
            $in_id = $this->db->insert($ins, 'siii', $username, $area, $region, $admin_id);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Location created for User [$username]!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Location created for User [$username]!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Location for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create Location for User [$username]";
            endif;
        endif;
    }
    
    public function addOLT2RadUser($username, $olt, $gpon, $admin_id) {
        $loc_exist = $this->getUserOLT([$username]);
        
        if (count($loc_exist) == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: OLT already Exist for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: OLT already Exist for User [$username]";
        else :
            $ins = "INSERT INTO tbl_usrolt (USERNAME, OLT, GPON, `DATEADDED`, ADDEDBY)
                    VALUES (?, ?, ?, NOW(), ?)
                    ON DUPLICATE KEY UPDATE OLT=VALUES(OLT), GPON=VALUES(GPON), DATEADDED=VALUES(DATEADDED),  ADDEDBY=VALUES(ADDEDBY)";
            $in_id = $this->db->insert($ins, 'siii', $username, $olt, $gpon, $admin_id);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: OLT created for User [$username]!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: OLT created for User [$username]!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create OLT for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create OLT for User [$username]";
            endif;
        endif;
    }
    
    public function updateUserLoc($username, $area, $region) {
        $upd = "UPDATE tbl_usrloc SET AREA=?, REGION=? WHERE USERNAME=?";
        $in_id = $this->db->execute_query($upd, "iis", $area, $region, $username);
        if ($in_id) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Location updated for User [$username]!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Location update for User [$username]!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to update Location for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to update Location for User [$username]";
        endif;
    }

    public function updateUserOLT($username, $olt, $gpon) {
        $upd = "UPDATE tbl_usrolt SET OLT=?, GPON=? WHERE USERNAME=?";
        $in_id = $this->db->execute_query($upd, "iis", $olt, $gpon, $username);
        if ($in_id) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: OLT updated for User [$username]!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: OLT update for User [$username]!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to update OLT for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to update OLT for User [$username]";
        endif;
    }
    
    public function getUserTypeFromDB($username) {
        $qry = "SELECT USERTYPE FROM `tblclients` WHERE RAD_USERNAME=?";
        $some_sth = $this->db->select($qry, "s", $username); 
        $row = $some_sth->fetch_object();
        
        return $row->USERTYPE;
    }
    
    public function getUserLoc($username=[]) {
        if (is_array($username)):
            $params = implode(",", array_fill(0, count($username), "?"));
            $types = str_repeat("s", count($username));
        else:
            return false;
        endif;
        $ret = [];        
        if (count($username) > 0) { $stmt = " WHERE ul.USERNAME IN ($params)"; } else { $stmt = ""; }
        $strsql ="SELECT ul.USERNAME, a.AREA_NAME, a.AREA_ID, r.REGION_NAME, r.REGION_ID, ru.lastname, ru.firstname, ta.FULLNAME AS 'ADMIN_NAME', ul.DATEADDED "
                . "FROM tbl_usrloc ul "
                . " LEFT JOIN tbl_areas a ON ul.AREA=a.AREA_ID "
                . " LEFT JOIN tbl_regions r ON ul.REGION=r.REGION_ID "
                . " LEFT JOIN rm_users ru ON ul.USERNAME=ru.username
                    LEFT JOIN tbl_admins ta ON ul.ADDEDBY=ta.AID $stmt"; //echo $strsql; //exit();
        if (count($username) > 0) {
            $args = array_merge( [$strsql, $types], $username);
        } else { $args = [$strsql]; } 
        $some_sth = call_user_func_array(array($this->db, 'select'), $this->ref($args)); 
        while ( $row = $some_sth->fetch_object() ) :
            $ret[] = ["USERNAME"=>$row->USERNAME, "AREA"=>$row->AREA_NAME, "AREA_ID"=>$row->AREA_ID,
                        "REGION"=>$row->REGION_NAME, "REGION_ID"=>$row->REGION_ID, "DATEADDED"=>$row->DATEADDED,
                        "FULLNAME"=>$row->firstname . " " . $row->lastname, "ADMIN_NAME"=>$row->ADMIN_NAME];
        endwhile;
        return $ret;
    }
    
    public function getUserOLT($username=[]) {
        if (is_array($username)):
            $params = implode(",", array_fill(0, count($username), "?"));
            $types = str_repeat("s", count($username));
        else:
            return false;
        endif;
        $ret = [];        
        if (count($username) > 0) { $stmt = " WHERE ul.USERNAME IN ($params)"; } else { $stmt = ""; }
        $strsql ="SELECT ul.USERNAME, a.OLT_NAME, a.OLT_ID, r.GPON_NAME, r.GPON_ID, ru.lastname, ru.firstname, ta.FULLNAME AS 'ADMIN_NAME', ul.DATEADDED "
                . "FROM tbl_usrolt ul "
                . " LEFT JOIN tbl_olt a ON ul.OLT=a.OLT_ID "
                . " LEFT JOIN tbl_gpon r ON ul.GPON=r.GPON_ID "
                . " LEFT JOIN rm_users ru ON ul.USERNAME=ru.username
                    LEFT JOIN tbl_admins ta ON ul.ADDEDBY=ta.AID $stmt"; //echo $strsql; //exit();
        if (count($username) > 0) {
            $args = array_merge( [$strsql, $types], $username);
        } else { $args = [$strsql]; } 
        $some_sth = call_user_func_array(array($this->db, 'select'), $this->ref($args)); 
        while ( $row = $some_sth->fetch_object() ) :
            $ret[] = ["USERNAME"=>$row->USERNAME, "OLT"=>$row->OLT_NAME, "OLT_ID"=>$row->OLT_ID,
                        "GPON"=>$row->GPON_NAME, "GPON_ID"=>$row->GPON_ID, "DATEADDED"=>$row->DATEADDED,
                        "FULLNAME"=>$row->firstname . " " . $row->lastname, "ADMIN_NAME"=>$row->ADMIN_NAME];
        endwhile;
        return $ret;
    }
    
    public function getUsersWithoutLoc($user) {
        $ret = [];
        $strsql = "SELECT username, firstname, lastname FROM rm_users ru "
                . "WHERE username NOT IN (SELECT USERNAME FROM tbl_usrloc)"
                . " AND enableuser=1 AND username LIKE ?"; //echo $strsql; exit();
        $some_sth = $this->db->select($strsql, "s", "%$user%");
        while ( $row = $some_sth->fetch_object() ) :
            $ret[] = ["USERNAME"=>$row->username, "LASTNAME"=>$row->lastname, "FIRSTNAME"=>$row->firstname,
                        "FULLNAME"=>$row->firstname . " " . $row->lastname];
        endwhile;
        return $ret;
    }
    
    public function getUsersWithoutOLT($user) {
        $ret = [];
        $strsql = "SELECT username, firstname, lastname FROM rm_users ru "
                . "WHERE username NOT IN (SELECT USERNAME FROM tbl_usrolt)"
                . " AND enableuser=1 AND username LIKE ?"; //echo $strsql; exit();
        $some_sth = $this->db->select($strsql, "s", "%$user%");
        while ( $row = $some_sth->fetch_object() ) :
            $ret[] = ["USERNAME"=>$row->username, "LASTNAME"=>$row->lastname, "FIRSTNAME"=>$row->firstname,
                        "FULLNAME"=>$row->firstname . " " . $row->lastname];
        endwhile;
        return $ret;
    }
    
    public function getUserContact($factor="all", $criteria=[], $actstatus=-1, $isNursery=0, $actStart='', $actEnd='') {
        if ($isNursery) {
            $joinme = " RIGHT JOIN tbl_erpdata ted ON ru.username=ted.RAD_USERNAME
                LEFT JOIN tbl_install_invoice tii USING (RAD_USERNAME) ";
            $cond = " AND DATE_ACTIVATED IS NOT NULL AND DATE_SUB(DATE(NOW()), INTERVAL 30 DAY) <= DATE(DATE_ACTIVATED)";
            if ($actStart != '' && $actEnd != '') :
                $cond = " AND DATE_ACTIVATED IS NOT NULL AND DATE(DATE_ACTIVATED) BETWEEN '$actStart' AND '$actEnd'";
            endif;
            
        }
        if (!in_array($factor, ["all", "sel", "area", "region", "olt", "gpon"]) || (!is_array($criteria)) ):
            return false;
        endif;
        if ($factor != "all" && count($criteria) < 1):
            return false;
        endif;
        $ad = '';
        if ($actstatus <> -1 && ($actstatus == 1 || $actstatus == 0) ) :
    		if ($actstatus == 0):
            $ad .= " AND
            			(IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = ru.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = ru.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = ru.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = ru.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) <= 0)
                        ";
    		else:
    			$ad .= " AND
            			(limitdl = 0 OR IF (limitdl =1, downlimit -
          		      (SELECT COALESCE(SUM(acctoutputoctets), 0)
             		      FROM radacct WHERE radacct.username = ru.username) -
             		      (SELECT COALESCE(SUM(dlbytes), 0) 
             		      FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) > 0)
             		      AND
             		      (limitul = 0 OR IF (limitul =1, uplimit -
             		      (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = ru.username) -
                              (SELECT COALESCE(SUM(ulbytes ), 0)
                              FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) > 0)
                              AND
                              (limitcomb = 0 OR IF (limitcomb =1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = ru.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) > 0)
                              AND
                              (limituptime = 0 OR IF (limituptime=1, uptimelimit -
                              (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = ru.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = ru.username) , 1) > 0)
                              AND
                              (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)";
    		endif;
        endif;
        $ret = [];
        $params = implode(",", array_fill(0, count($criteria), "?"));
        if ($factor == "sel") :
            $types = str_repeat("s", count($criteria));
        else:
            $types = str_repeat("i", count($criteria));
        endif;
        $searchtb = ($factor == "all")? "" : (($factor == "sel")? "ru.username" : (($factor == "area")? "ul.AREA" : (($factor == "region")? "ul.REGION" :  (($factor == "olt")? "ul.OLT" : (($factor == "gpon")? "ul.GPON" :  "")))));
        $searchtb = ($searchtb == "")? " WHERE ru.enableuser=1" : " WHERE $searchtb IN ($params) AND ru.enableuser=1";
        
        if (in_array($factor, ["all", "sel"])) :
            $strsql ="SELECT ru.username, ru.email, ru.phone, ru.lastname, ru.firstname FROM rm_users ru
                    LEFT JOIN tbl_usrloc ul ON ru.username = ul.USERNAME LEFT JOIN rm_services rs ON ru.srvid=rs.srvid $joinme $searchtb $ad $cond";
        elseif (in_array($factor, ["area", "region"])) :
            $strsql ="SELECT ru.username, ru.email, ru.phone, ru.lastname, ru.firstname FROM tbl_usrloc ul
                    LEFT JOIN rm_users ru ON ul.USERNAME=ru.username LEFT JOIN rm_services rs ON ru.srvid=rs.srvid $joinme $searchtb $ad $cond";
        elseif (in_array($factor, ["olt", "gpon"])) :
            $strsql ="SELECT ru.username, ru.email, ru.phone, ru.lastname, ru.firstname FROM tbl_usrolt ul
                    LEFT JOIN rm_users ru ON ul.USERNAME=ru.username LEFT JOIN rm_services rs ON ru.srvid=rs.srvid $joinme $searchtb $ad $cond";
        endif;
        // print_r(array_merge( [$strsql, $types], $criteria));
        $args = ($types != "")? array_merge( [$strsql, $types], $criteria) : [$strsql]; //print_r($args);
        // $args = array_merge( [$strsql, $types], $criteria); //print_r($args);
        $some_sth = call_user_func_array(array($this->db, 'select'), $this->ref($args));
        while ( $row = $some_sth->fetch_object() ) :
            $ret[] = ["USERNAME"=>$row->username, "EMAIL"=>$row->email, "PHONE"=>$row->phone,
                        "LASTNAME"=>$row->lastname, "FIRSTNAME"=>$row->firstname,
                        "FULLNAME"=>$row->firstname . " " . $row->lastname];
        endwhile;
        return $ret;
    }
    
    public function createAdBanner($nufile, $nufileThumb, $adContentUrl, $userid) {
        
        $ins = "INSERT INTO tbl_banner_adverts (AD_IMG, AD_IMG_THUMB, AD_CONTENT_URL, ADDEDBY, DATEADDED, ISACTIVE)
                VALUES (?, ?, ?, ?, NOW(), 1)";
        $in_id = $this->db->insert($ins, 'sssi', $nufile, $nufileThumb, $adContentUrl, $userid);
        if ($in_id) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']}-$userid attempt) Success: Ad Banner [$in_id] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Ad Banner Created!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']}-$userid attempt) Error: Unable to create Ad Banner [$in_id]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Unable to create Ad Banner";
        endif;
        
    }
    
    public function loadAdBanner($bannerID=0, $isactive=-1, $searchval='', $sortby='DATEADDED', $sortorder='desc', $startrow=0, $len=50) {
        $ret = [];
        $ad = ''; 
        $sn = 0;
        if ($bannerID>0 && is_int($bannerID)) {
            $ad .= " AND b.AD_ID = $bannerID";
        }
        if ($isactive>=0 && is_int($isactive)) {
            $ad .= " AND b.ISACTIVE = $isactive";
        }
        
        $mqry1 = "SELECT COUNT(AD_IMG) AS 'TOTAL' FROM tbl_banner_adverts ";
        $some_st = $this->db->select($mqry1);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL;
        
        $tqry = "SELECT AD_ID, AD_IMG, AD_IMG_THUMB, AD_CONTENT_URL, ADDEDBY, DATEADDED, b.ISACTIVE, a.FULLNAME 
                 FROM tbl_banner_adverts b 
                 LEFT JOIN tbl_admins a ON b.ADDEDBY=a.AID ";
        if ($ad ===""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$tqry WHERE 1 $ad";  
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows(); 
    	endif;
        $limit = ($len === -1)? "" : "LIMIT $startrow, $len";
        $msort = ($sortby !== "")? "ORDER BY $sortby $sortorder" : "ORDER BY DATEADDED DESC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) :
            $edit = "";
            $ico = $row->ISACTIVE? "<i class='fa fa-pause-circle text-red'></i>" : "<i class='fa fa-play-circle text-green'></i>";
            if ($_SESSION[$this->sid.'readonly'] == 0):
                $edit .= '<form id="gFormStatus_' . $row->AD_ID . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->AD_ID . '" href="javascript:void(0)" class="gFormDel" title="Enable/Disable Banner ' . $row->AD_ID . '" data-toggle="tooltip">
                        <span>' . $ico . '</span>
                        <input type="hidden" name="bannerid" id="bannerid" value="' . $row->AD_ID . '" /></a>'; 
                $edit .= "</form>";
            endif;
    		$bannerThumb = "https://eservice.fob.ng/" . $row->AD_IMG_THUMB;
            $ret[] = ["SN"=>++$sn, "AD_ID"=>$row->AD_ID, "AD_BANNER"=>"<img src='$bannerThumb' />", "AD_IMG"=>$row->AD_IMG, 
                    "AD_IMG_THUMB"=>$row->AD_IMG_THUMB, "STATUS"=>($row->ISACTIVE)? "Active" : "Inactive",
                        "AD_CONTENT_URL"=>$row->AD_CONTENT_URL, "ADDEDBY"=>$row->ADDEDBY,
                        "DATEADDED"=>date("d-M-Y H:i:s", strtotime($row->DATEADDED)), "ISACTIVE"=>$row->ISACTIVE,
                        "FULLNAME"=>$row->FULLNAME, "ACTION"=>$edit];
        endwhile;
        return $ret;
    }
    
    public function createFAQ($question, $answer, $userid) {
        
        $ins = "INSERT INTO tbl_faqs (QUESTION, ANSWER, CREATEDBY, CREATEDON, ISACTIVE)
                VALUES (?, ?, ?, NOW(), 1)";
        $in_id = $this->db->insert($ins, 'ssi', $question, $answer, $userid);
        if ($in_id) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']}-$userid attempt) Success: FAQ Item [$in_id] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']}-$userid attempt) Error: Unable to create FAQ Item [$in_id]", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0;
        endif;
        
    }
    
    public function loadFAQs($faqID=0, $isactive=-1, $searchval='', $sortby='CREATEDON', $sortorder='desc', $startrow=0, $len=50) {
        $ret = [];
        $ad = '';
        $sn = 0;
        if ($faqID>0 && is_int($faqID)) {
            $ad .= " AND b.FAQ_ID = $faqID";
        }
        if ($isactive>=0 && is_int($isactive)) {
            $ad .= " AND b.ISACTIVE = $isactive";
        }
        
        $mqry1 = "SELECT COUNT(QUESTION) AS 'TOTAL' FROM tbl_faqs ";
        $some_st = $this->db->select($mqry1);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL;
        
        $tqry = "SELECT FAQ_ID, QUESTION, ANSWER, CREATEDBY, CREATEDON, b.ISACTIVE, a.FULLNAME 
                 FROM tbl_faqs b 
                 LEFT JOIN tbl_admins a ON b.CREATEDBY=a.AID ";
        if ($ad ===""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$tqry WHERE 1 $ad";  
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows(); 
    	endif;
        $limit = ($len === -1)? "" : "LIMIT $startrow, $len";
        $msort = ($sortby !== "")? "ORDER BY $sortby $sortorder" : "ORDER BY CREATEDON DESC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) :
            $edit = "";
            $ico = $row->ISACTIVE? "<i class='fa fa-pause-circle text-red'><i>" : "<i class='fa fa-play-circle text-green'><i>";
            if ($_SESSION[$this->sid.'readonly'] == 0):
                $edit .= '<form id="gFormStatus_' . $row->FAQ_ID . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->FAQ_ID . '" href="javascript:void(0)" class="gFormDel" title="Enable/Disable NewsItem ' . $row->FAQ_ID . '" data-toggle="tooltip">
                        <span>' . $ico . '</span>
                        <input type="hidden" name="newsid" id="newid" value="' . $row->FAQ_ID . '" /></a>'; 
                $edit .= "</form>";
            endif;
            
            $ret[] = ["SN"=>++$sn, "FAQ_ID"=>$row->FAQ_ID, "QUESTION"=>$row->QUESTION, 
                    "ANSWER"=>$row->ANSWER, "STATUS"=>($row->ISACTIVE)? "Active" : "Inactive",
                        "CREATEDBY"=>$row->CREATEDBY,
                        "CREATEDON"=>date("d-M-Y H:i:s", strtotime($row->CREATEDON)), "ISACTIVE"=>$row->ISACTIVE,
                        "FULLNAME"=>$row->FULLNAME, "ACTION"=>$edit];
        endwhile;
        return $ret;
    }
    
    public function createMobileNews($nufile, $nufileThumb, $newsTitle, $newsSummary, $newsURL, $userid) {
        
        $ins = "INSERT INTO tbl_news (NEWS_TITLE, NEWS_SUMMARY, NEWS_IMG_URL, NEWS_URL, ADDEDBY, DATEADDED, ISACTIVE)
                VALUES (?, ?, ?, ?, ?, NOW(), 1)";
        $in_id = $this->db->insert($ins, 'ssssi', $newsTitle, $newsSummary, $nufile, $newsURL, $userid);
        if ($in_id) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']}-$userid attempt) Success: News Item [$in_id] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1; // "Success: News Item Created!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']}-$userid attempt) Error: Unable to create News Item [$in_id]", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0; // "Error: Unable to create News Item";
        endif;
        
    }
    
    public function loadMobileNews($newsID=0, $isactive=-1, $searchval='', $sortby='DATEADDED', $sortorder='desc', $startrow=0, $len=50) {
        $ret = [];
        $ad = '';
        $sn = 0;
        if ($newsID>0 && is_int($newsID)) {
            $ad .= " AND b.NEWS_ID = $newsID";
        }
        if ($isactive>=0 && is_int($isactive)) {
            $ad .= " AND b.ISACTIVE = $isactive";
        }
        
        $mqry1 = "SELECT COUNT(NEWS_TITLE) AS 'TOTAL' FROM tbl_news ";
        $some_st = $this->db->select($mqry1);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL;
        
        $tqry = "SELECT NEWS_ID, NEWS_TITLE, NEWS_SUMMARY, NEWS_IMG_URL, NEWS_URL, ADDEDBY, DATEADDED, b.ISACTIVE, a.FULLNAME 
                 FROM tbl_news b 
                 LEFT JOIN tbl_admins a ON b.ADDEDBY=a.AID ";
        if ($ad ===""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$tqry WHERE 1 $ad";  
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows(); 
    	endif;
        $limit = ($len === -1)? "" : "LIMIT $startrow, $len";
        $msort = ($sortby !== "")? "ORDER BY $sortby $sortorder" : "ORDER BY DATEADDED DESC";
        $qry = "$tqry WHERE 1 $ad $msort $limit";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) :
            $edit = "";
            $ico = $row->ISACTIVE? "<i class='fa fa-pause-circle text-red'><i>" : "<i class='fa fa-play-circle text-green'><i>";
            if ($_SESSION[$this->sid.'readonly'] == 0):
                $edit .= '<form id="gFormStatus_' . $row->NEWS_ID . '" action="" method="post" style="display: inline-block; padding-right: 3px;">';
                $edit .= '<a data-val="' . $row->NEWS_ID . '" href="javascript:void(0)" class="gFormDel" title="Enable/Disable NewsItem ' . $row->NEWS_ID . '" data-toggle="tooltip">
                        <span>' . $ico . '</span>
                        <input type="hidden" name="newsid" id="newid" value="' . $row->NEWS_ID . '" /></a>'; 
                $edit .= "</form>";
            endif;
            $bannerThumb = "https://eservice.fob.ng/" . $row->NEWS_IMG_URL;
            $ret[] = ["SN"=>++$sn, "NEWS_ID"=>$row->NEWS_ID, "NEWS_BANNER"=>"<img src='$bannerThumb' />", "NEWS_TITLE"=>$row->NEWS_TITLE, 
                    "NEWS_SUMMARY"=>$row->NEWS_SUMMARY, "STATUS"=>($row->ISACTIVE)? "Active" : "Inactive",
                        "NEWS_IMG_URL"=>$row->NEWS_IMG_URL, "ADDEDBY"=>$row->ADDEDBY, "NEWS_URL"=>$row->NEWS_URL,
                        "DATEADDED"=>date("d-M-Y H:i:s", strtotime($row->DATEADDED)), "ISACTIVE"=>$row->ISACTIVE,
                        "FULLNAME"=>$row->FULLNAME, "ACTION"=>$edit];
        endwhile;
        return $ret;
    }


    public function getFullName() {
         return $this->fullname;
     }
     
     
    public function getUserName() {
         return $this->username;
     }
     
     
    public function getRADUserName() {
         return $this->rad_username;
     }
     
     
    public function getUID() {
         return $this->uid;
     }
     
    
    public function getUserType() {
        return $this->usertype;
    }
    
    public function getUserTypeID() {
        return $this->usertype_id;
    }
    
    
    public function isAdmin() {
        return $this->is_admin;
    } 
    
    
    public function isEnabled() {
        return $this->is_enabled;
    } 
     
     
    public function getPackage() {
         return $this->package;
     }
     
     
    public function getPackageID() {
         return $this->packageid;
     }
     
     
    public function getExpiration() {
         return $this->expiration;
     }
     
     
    public function getEmail() {
         return $this->email;
     }
     
    public function getMobile() {
         return $this->mobile;
     }
     
    public function getReadOnly() {
         return $this->readonly;
     }
     
    public function getLastLogOff() {
         return $this->lastlogoff;
     }
    

    public function setDB($dbconnection) {
        $this->db = $dbconnection;
        parent::setDB($dbconnection);
    }
    
    public function savePushUUID($userid, $uuid) {
        $upd = "UPDATE tblclients SET `PUSHID` = ? WHERE `ID` = ?";
        $rett = $this->db->execute_query($upd, "si", $uuid, $userid);
        if ($rett):
            return 1;
        else: 
            return 0;
        endif;
        
    }
    
    public function saveNIBSSSecret($key, $iv) {
        $all_query_ok= true;
        $this->db->autocommit(FALSE);
        $upd = "UPDATE tbl_zsettings SET `SETTINGS_VALUE` = ? WHERE `SETTINGS_KEY` = ?";
        $rett = $this->db->execute_query($upd, "ss", $iv, "NIBSS_IV");
        $all_query_ok = ($rett)? true : false;
        
        $upd2 = "UPDATE tbl_zsettings SET `SETTINGS_VALUE` = ? WHERE `SETTINGS_KEY` = ?";
        $rett2 = $this->db->execute_query($upd2, "ss", $key, "NIBSS_SECRET");
        $all_query_ok = ($rett2)? true : false;
        
        $all_query_ok ? $this->db->commit() : $this->db->rollback();
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok):
            return 1;
        else: 
            return 0;
        endif;
        
    }
    
    
    public function getNIBSSSecret() {  
        $ret = [];
        $qry = "SELECT SETTINGS_KEY, SETTINGS_VALUE FROM `tbl_zsettings` WHERE SETTINGS_KEY IN ('NIBSS_IV', 'NIBSS_SECRET')";
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->SETTINGS_KEY] = $row->SETTINGS_VALUE;
        }
        
        return $ret;
    }
    
    public function finalizeInvoice($ordeNo, $orderERPID, $dateFinalized, $finalizedBy) {
        $upd = "UPDATE tbl_install_invoice SET `DATE_FINALIZED` = ?, `FINALIZEDBY`= ? 
                 WHERE `ORDER_ERPID` = ? AND `ORDERNO` LIKE ?";
        $rett = $this->db->execute_query($upd, "ssis", $dateFinalized, $finalizedBy, $orderERPID, $ordeNo);
        
        if ($rett):
            return 1;
        else: 
            return 0;
        endif;
    }
    
    
    // ----------------------------------------------------------------------------------
    // helper function to turn an array of values into an array of value references
    // necessary because mysqli_stmt::bind_param needs value refereces for no good reason
    function ref($arr) {
        $refs = array();
        foreach ($arr as $key => $val) $refs[$key] = &$arr[$key];
        return $refs;
    }
}