<?php
/**
 * Description of PushSMS
 *
 * @author OPMat
 */
class PushSMS {
    //put your code here
    const ONESIGNAL_APP_ID = "a47bf520-b589-4b30-a39b-336ebe4fce7c";
    const REST_API_KEY = "MTYxYjY0MTYtZjdlOS00OGYxLThiZjktYWZmZDU3OTkxYjdj";
    const API_BASE_URL = "https://onesignal.com/api/v1/";
    
    const SEND_TO_SEGMENT = 1;
    const SEND_TO_PLAYER = 2;
    
    public $sentCount = 0;
    public $failedCount = 0;
    public $sentUserList = [];
    public $failedUserList = [];
    
    private $devicelist = [];
    
    private $db;
    
    public function __construct($dbconnection) {
        $this->db = $dbconnection;
    } 
    
    public function getAppDetails(){ 
        $app_id = $this::ONESIGNAL_APP_ID;
        $ch = curl_init(); 
        curl_setopt($ch, CURLOPT_URL, $this::API_BASE_URL . "apps/" . $app_id); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 
                                                   'Authorization: Basic '. $this::REST_API_KEY)); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch); 
        curl_close($ch); 
        return $response; 
    } 
    
    public function getDevices($limit=300, $offset=0 ){ 
        $app_id = $this::ONESIGNAL_APP_ID;
        $ch = curl_init(); 
        curl_setopt($ch, CURLOPT_URL, $this::API_BASE_URL . "players?app_id=" . $app_id . "&limit=$limit&offset=$offset"); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 
                                                   'Authorization: Basic '. $this::REST_API_KEY)); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch); 
        curl_close($ch); 
        return $response; 
    } 
    
    public function getDevicesForSelectv1(){ 
        $ret = [];
        
        $ra = json_decode($this->getDevices());
        foreach ($ra->players as $key => $player) {
            if (!isset($player->tags->username)) : continue; endif;
            $ret[$player->id] = $player->tags->username;   
            $this->devicelist[$player->tags->username][] = $player->id;        
        }
        
        return $ret;
    }
    
    public function getDevicesForSelect($search='') {
        $ad = "";
        $ret = [];
        if ($search <> "") :
            $search = mysqli_real_escape_string($this->db, $search); // mysql_escape_string($user);
            $ad = " WHERE USERNAME LIKE '%$search%'";
        endif;
        $strsql = "SELECT LOWER(`USERNAME`) AS 'USERNAME', `PUSHID` 
                    FROM tbl_push_id $ad";
        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) :
                $ret[$row["USERNAME"]] = $row["USERNAME"]; 
                // $ret[$row["PUSHID"]] = $row["USERNAME"];   
                $this->devicelist[$row["USERNAME"]][] = $row["PUSHID"];        
            endwhile;
        endif;
        
        return $ret;
    }
    
    
    
    public function getDeviceByUser($username = "") {
        if ($username == "") {
            return $this->devicelist;
        } elseif (is_array($username) && count($username)) {
            $ret = [];
            $userlist = "'" . join("','", $username) . "'";
            $strsql = "SELECT PUSHID FROM tbl_push_id WHERE USERNAME IN ($userlist)";
            $some_st = $this->db->select($strsql);
            if ($some_st->num_rows() >= 1) :
                while ($row = $some_st->fetch_assoc()) :
                    $ret[] = $row["PUSHID"];
                endwhile;
            endif;
            return $ret;
        } else {
            return isset($this->devicelist[$username])? $this->devicelist[$username] : [];
        }
    }
    
    
    public function logPushData($id, $sentCount, $failedCount, $sentUsers, $failedUsers, 
                                    $started, $ended) {
        $ins = "INSERT INTO tbl_push_logs (PUSH_ID, SENTCOUNT, FAILEDCOUNT,  
                SENTUSER, FAILEDUSER, TIMESTARTED, TIMEFINISHED, DURATION) VALUES 
                (?, ?, ?, ?, ?, ?, ?, TIMEDIFF('$ended', '$started') ) ";
        $in_id = $this->db->insert($ins, "iiissss", $id, $sentCount, $failedCount, $sentUsers, $failedUsers, 
                                    $started, $ended);
        
        return $in_id;
    }
    
    public function sendPUSH($title, $content, $recipient=[], $send_to_type=0, $subtitle="", $priority=10) {
        $data['app_id'] = $this::ONESIGNAL_APP_ID;
        $data['headings'] = ["en" => $title];
        $data['contents'] = ["en" => $content];
        $data["android_accent_color"] = "FFFF0011";  //android_led_color
        $data["priority"] = $priority; //10 highest
        if ($subtitle != ""):
            $data['subtitle'] = ["en" => $subtitle];
        endif;
        if ($send_to_type == $this::SEND_TO_SEGMENT):
            $data['included_segments'] = $recipient;
        elseif ($send_to_type == $this::SEND_TO_PLAYER):
//            $data['include_player_ids'] = $recipient;
            $recChunks = array_chunk($recipient,1950);
            $resp = []; $id = ""; 
            foreach ($recChunks as $recChunk) {
                $data['include_subscription_ids'] = $recChunk;
                $data_string = json_encode($data);
                $result = $this->sendViaCURL($data_string);
                if ($id ==="" && isset($result->id) ) { $id = $result->id; }
                $resp['response'][] = $result;
            }
            $resp['id'] = $id;
            return json_decode(json_encode($resp));
            //new send to username alias but recipient array needs to contain username
//            $data['include_aliases']["external_id"] = $recipient;
//            or
//            $data['include_aliases']["userd"] = $recipient;
//            then this
//            $data['target_channel'] = 'push';
        endif;
        $data_string = json_encode($data);																															
        
        $result = $this->sendViaCURL($data_string);
        /*
         * {
  "id": "458dcec4-cf53-11e3-add2-000c2940e62c",
  "recipients": 3
}
         */
        
        return $result; 
    }
    
    public function sendPUSHWithUsername($title, $content, $recipient=[], $send_to_type=0, $subtitle="", $priority=10) {
        $data['app_id'] = $this::ONESIGNAL_APP_ID;
        $data['headings'] = ["en" => $title];
        $data['contents'] = ["en" => $content];
        $data["android_accent_color"] = "FFFF0011";  //android_led_color
        $data["priority"] = $priority; //10 highest
        if ($subtitle != ""):
            $data['subtitle'] = ["en" => $subtitle];
        endif;
        if ($send_to_type == $this::SEND_TO_SEGMENT):
            $data['included_segments'] = $recipient;
        elseif ($send_to_type == $this::SEND_TO_PLAYER):
//            $data['include_player_ids'] = $recipient;
            $recChunks = array_chunk($recipient,1950);
            $resp = []; $id = ""; 
            $data['target_channel'] = 'push';
            foreach ($recChunks as $recChunk) {
                $data['include_aliases']["external_id"] = $recChunk;
                $data_string = json_encode($data);
                $result = $this->sendViaCURL($data_string);
                if ($id ==="" && isset($result->id) ) { $id = $result->id; }
                $resp['response'][] = $result;
            }
            $resp['id'] = $id;
            return json_decode(json_encode($resp));
            //new send to username alias but recipient array needs to contain username
//            $data['include_aliases']["external_id"] = $recipient;
//            or
//            $data['include_aliases']["userd"] = $recipient;
//            then this
//            $data['target_channel'] = 'push';
        endif;
        $data_string = json_encode($data);																															
        
        $result = $this->sendViaCURL($data_string);
        /*
         * {
  "id": "458dcec4-cf53-11e3-add2-000c2940e62c",
  "recipients": 3
}
         */
        
        return $result; 
    }
    
    public function sendViaCURL($data_string) {
        $ch = curl_init($this::API_BASE_URL . 'notifications');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
                'Authorization: Basic ' . $this::REST_API_KEY)
            );																			
        $result = json_decode(curl_exec($ch));
        
        return $result; 
    }
    
    public function savePUSH($notifID, $title, $content, $recipient, $nreceived, 
                                $sentBy, $send_to_type=0, $subtitle="", $priority=10, $report='') {
        $ins = "INSERT INTO tbl_push (`NOTIF_ID`, `TITLE`, `CONTENT`, `SUBTITLE`, `RECIPIENT`, 
                    `NRECEIVED`, `RECIPIENT_TYPE`, `PRIORITY`, `SENT_BY`, `DATE_SENT`, `REPORT`)
               VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)"; 
        $in_id = $this->db->insert($ins, "sssssiiiis", $notifID, $title, $content, $subtitle, $recipient, 
                        $nreceived, $send_to_type, $priority, $sentBy, $report);
        
        return $in_id;
    }
    
    public function getPUSH($notifID = "") {
        $add = "";
        $ret = [];
        if ($notifID <> ""):
            $add = " WHERE `NOTIF_ID` = '" . mysqli_real_escape_string($notifID) . "'";
        endif;
        $strsql = "SELECT `NOTIF_ID`, `TITLE`, `CONTENT`, `SUBTITLE`, `RECIPIENT`, 
                    `NRECEIVED`, `RECIPIENT_TYPE`, `PRIORITY`, `SENT_BY`, `DATE_SENT`, ta.USERNAME AS 'SENDER' 
                    FROM tbl_push tp
                  LEFT JOIN tbl_admins ta ON tp.SENT_BY=ta.AID 
                $add 
                 ORDER BY `DATE_SENT` DESC";
        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) :
                $ret[] = $row;
            endwhile;
        endif;
        
        return $ret;
    }
    
    
    public function getPushSMS($searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0) {
        $exp = $response = array();
        $adc = $ad = $lim = "";
        $sn = 0; 
        
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (ID LIKE '%$searchval%' OR `TITLE` LIKE '%$searchval%' OR `RECIPIENT` LIKE '%$searchval%') ";
        endif;
        $eqry = "SET @count = 0;"; $this->db->execute_query($eqry);
        $mqry = "SELECT (@count:=@count+1) AS 'SN', `NOTIF_ID`, `TITLE`, `CONTENT`, `SUBTITLE`, `RECIPIENT`, 
                    `NRECEIVED`, `RECIPIENT_TYPE`, `PRIORITY`, `SENT_BY`, `DATE_SENT`, ta.USERNAME AS 'SENDER', ta.FULLNAME 
                    FROM tbl_push tp
                  LEFT JOIN tbl_admins ta ON tp.SENT_BY=ta.AID ";
        $some_st = $this->db->select($mqry);
        $totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad";
        $some_s = $this->db->select($fqry);
        $totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY `DATE_SENT` DESC";
        
        $qry = "$mqry WHERE 1 $ad $msort $limit"; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) { 
            $exp[] = array("SN"=>++$sn, "NOTIF_ID"=>$row->NOTIF_ID, "TITLE"=>$row->TITLE, 
                        "CONTENT"=>$row->CONTENT, "RECIPIENT"=>($row->RECIPIENT_TYPE=='all')? "All":$row->RECIPIENT,
                        "NRECEIVED"=>$row->NRECEIVED, "SENDER"=>"{$row->FULLNAME} <{$row->SENDER}>",
                        "DATE_SENT"=>($row->DATE_SENT == NULL)? "-" : date( 'd-M-Y h:iA', strtotime($row->DATE_SENT)) );
        }

        ## Response
        $response = array(
          "iTotalRecords" => $totalRecords,
          "iTotalDisplayRecords" => $totalRecordwithFilter,
          "aaData" => $exp
        );
        return $response;
    }

}
