<?PHP

if (file_exists("config2.php"))
    require_once "config2.php";
elseif (file_exists("../config2.php"))
    require_once "../config2.php";
elseif (file_exists("../../config2.php"))
    require_once "../../config2.php";

if (file_exists("includes/common_functions.php"))
    require_once "includes/common_functions.php";
elseif (file_exists("../includes/common_functions.php"))
    require_once "../includes/common_functions.php";
elseif (file_exists("../../includes/common_functions.php"))
    require_once "../../includes/common_functions.php";

if (file_exists("includes/opener.php"))
    require_once "includes/opener.php";
elseif (file_exists("../includes/opener.php"))
    require_once "../includes/opener.php";
elseif (file_exists("../../includes/opener.php"))
    require_once "../../includes/opener.php";
elseif (file_exists("../../../includes/opener.php"))
    require_once "../../../includes/opener.php";

/**
 * Description of UserProfile
 *
 * @author OPMat
 */
class LoyaltyPromo extends Logger {

    //put your code here
    private $db;
    private $uid;
    private $fullname;
    private $is_admin;
    private $is_enabled;
    private $usertype;
    private $usertype_id;
    private $username;
    private $rad_username;
    private $lastname;
    private $firstname;
    private $package;
    private $packageid;
    private $expiration;
    private $email;
    private $mobile;
    private $sid;
    private $readonly;
    private $lastlogoff;
    public $totalRecords;
    public $totalRecordwithFilter;
    private $activities = [
        'renewal' => 'RENEWAL_POINT',
        'referral' => 'REFERRAL_POINT',
        '12monthbonus' => '12MONTH_RENEWAL_BONUS',
        'online' => 'ESERVICE_ENGAGEMENT_POINT',
        'mobile' => 'MYFOB_APP_ENGAGEMENT_POINT',
        'redemption_point' => 'REDEMPTION_POINT'
    ];

    public function __construct($dbconnection) {
        $this->db = $dbconnection;

        $this->sid = session_id();
        parent::__construct($dbconnection, $_SESSION[$this->sid . "username"]);
    }

    public function getPlanStatus($planId = 0, $isActive = -1, $readonly = 0) {
        $whereClause = $ret = [];
        $ad = '';
        if (is_numeric($planId) && $planId) :
            $planId = mysqli_real_escape_string($this->db, $planId);
            $whereClause[] = "l.PLAN = $planId";
        endif;
        if (is_numeric($isActive) && $isActive > -1) :
            $isActive = mysqli_real_escape_string($this->db, $isActive);
            $whereClause[] = "l.ISACTIVE = $isActive";
        endif;

        $tqry = "SELECT l.PLAN_SETUP_ID, p.PLAN_ID, p.PLAN, l.ISACTIVE, l.LASTMODIFIED, l.LASTMODIFIEDBY 
                FROM `loyalty_plan_status` l 
                 LEFT JOIN tbl_plans p ON l.PLAN=p.PLAN_ID ";
        $mqry1 = "SELECT COUNT(PLAN) AS 'TOTAL' FROM loyalty_plan_status ";
        $some_st = $this->db->select($mqry1);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL;
        if (!count($whereClause)):
            $this->totalRecordwithFilter = $this->totalRecords;
            $qry = $tqry;
        else:
            $ad = implode(" AND ", $whereClause);
            $fqry = "$tqry WHERE $ad";
            $some_s = $this->db->select($fqry);
            $this->totalRecordwithFilter = $some_s->num_rows();
            $qry = $fqry;
        endif;

//        $qry = "$tqry WHERE 1 AND $ad ";
        $some_sth = $this->db->select($qry);
        $sn = 0;
        while ($row = $some_sth->fetch_object()) {
            if (isset($row->ISACTIVE)) {
                if ($row->ISACTIVE == 1) {
                    $tt = "<span class='label-default label label-success'>ACTIVE</span>";
                    $act = ($readonly == 0) ? "form" : "";
                } else {
                    $tt = "<span class='label-default label label-danger'>INACTIVE</span>";
                    $act = ($readonly == 0) ? "form" : "";
                }
            }
            $ret[] = ["PLAN_SETUP_ID" => $row->PLAN_SETUP_ID, "PLAN_ID" => $row->PLAN_ID,
                "PLAN" => $row->PLAN, "ISACTIVE" => $tt,
                "LASTMODIFIED" => $row->LASTMODIFIED, "LASTMODIFIEDBY" => $row->LASTMODIFIEDBY, "ACTION" => $act];
        }

        return $ret;
    }

    public function getPlanStatusTable($planId = 0, $isActive = -1) {
        $planStatus = $this->getPlanStatusTable($planId, $isActive);
    }

    public function userHasBeenOnlineDisMonth($user, $month, $year, $route='online') {
        $sql = "SELECT LOYALTY_ACT_ID FROM loyalty_activity_logs "
                . " WHERE USERNAME=? AND ACT_MONTH=? AND ACT_YEAR=?"
                . " AND ACT_TYPE=?";
        $some_sth = $this->db->select($sql, "siis", $user, $month, $year, $this->activities[$route]);

        return $some_sth->num_rows();
    }


    public function getRedemptionByPlan( $plan = '') {
        $whereClause = $ret = [];
        $ad = '';
        if ($plan !== '') :
            $plan = mysqli_real_escape_string($this->db, $plan);
            $whereClause[] = "USER_SERVICE = '$plan'";
        endif;

        $sql = "SELECT USER_SERVICE, SUM(POINTS_REDEEMED) AS 'POINTS' FROM loyalty_redemption";
        if (count($whereClause)):
            $ad = implode(" AND ", $whereClause);
            $sql .= " WHERE $ad";
        endif;
        $sql .= " GROUP BY USER_SERVICE";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()) {
            $ret[$row->USER_SERVICE] = $row->POINTS;
        }

        return $ret;
    }

    public function getRedemptionHistory($username = '', $limit=50) {
        $ret = [];
        
        $username = mysqli_real_escape_string($this->db, $username);
        $whereClause = ($username !== '')? " WHERE USERNAME=?" : "";
        
        $sql = "SELECT USERNAME, USER_SERVICE, POINTS_REDEEMED, REWARD, "
                . "DATE_REDEEMED FROM loyalty_redemption "
                . " $whereClause ORDER BY DATE_REDEEMED DESC LIMIT $limit";
        if ($whereClause !== "") {
            $some_sth = $this->db->select($sql, "s", $username);
        } else {
            $some_sth = $this->db->select($sql);
        }
        while ($row = $some_sth->fetch_object()) :
            $ret[] = ["USERNAME"=>$row->USERNAME, "USER_SERVICE"=>$row->USER_SERVICE, "POINTS_REDEEMED"=>$row->POINTS_REDEEMED,
                "DATE_REDEEMED"=>date("d-M-Y H:i:s", strtotime($row->DATE_REDEEMED)), "REWARD"=>$row->REWARD ]; 
        endwhile;
        
        return $ret;
    }

    public function getUserActivities($username = '', $limit=50) {
        $ret = [];
        
        $username = mysqli_real_escape_string($this->db, $username);
        $whereClause = ($username !== '')? " WHERE USERNAME=?" : "";
        
        $sql = "SELECT USERNAME, USER_SERVICE, POINT_EARNED, ACT_DATE, ACT_TYPE, "
                . "QUANTITY, ACT_UNIT_POINT FROM loyalty_activity_logs"
                . " $whereClause ORDER BY ACT_DATE DESC LIMIT $limit";
        if ($whereClause !== "") {
            $some_sth = $this->db->select($sql, "s", $username);
        } else {
            $some_sth = $this->db->select($sql);
        }
        while ($row = $some_sth->fetch_object()) :
            $ret[] = ["USERNAME"=>$row->USERNAME, "USER_SERVICE"=>$row->USER_SERVICE, "POINT_EARNED"=>$row->POINT_EARNED,
                "ACT_DATE"=>date("d-M-Y H:i:s", strtotime($row->ACT_DATE)), "ACT_TYPE"=>$row->ACT_TYPE, 
                "QUANTITY"=>$row->QUANTITY, "ACT_UNIT_POINT"=>$row->ACT_UNIT_POINT]; 
        endwhile;
        
        return $ret;
    }

    public function getUserPlan( $user) {
        $qry = "SELECT ru.username, ru.srvid, rs.srvname, tp.PLAN_ID, tp.PLAN
                FROM rm_users ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
		LEFT JOIN tbl_plans tp ON rs.srvid = tp.SRVID
                WHERE username LIKE ?";
        $some_sth = $this->db->select($qry, 's', $user);
        $row = $some_sth->fetch_object();
        return ["PLANID" => $row->PLAN_ID, "PLANNAME" => $row->PLAN];
    }

    public function setActivityPoint4User( $user, $activity, $quantity=1) {
        $plan = $this->getUserPlan($user);
        $activityPointy = $this->getPlanActivityPoint($plan["PLANID"], $this->activities[$activity]);
        $activityPoint = $activityPointy[$this->activities[$activity]];
    	if (!$activityPoint) {
            return 0;
        }
        
        $ins = "INSERT INTO loyalty_activity_logs (USERNAME, USER_SERVICE, "
                . "ACT_MONTH, ACT_YEAR, ACT_TYPE, QUANTITY, ACT_UNIT_POINT, "
                . "POINT_EARNED, ACT_DATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        $saved = $this->db->insert($ins, 'ssiisiii', $user, $plan["PLANNAME"],
                date("m"), date("Y"), $this->activities[$activity], $quantity, 
                $activityPoint, $activityPoint*$quantity);
        if ($saved > 0) {
            return 1;
        } else {
            return 0;
        }
    }
 
    
    public function redeemPoint( $user, $points2Redeem, $rewardType="SERVICE_EXTENSION") {
        $plan = $this->getUserPlan($user);
        $rewardPoint = $this->getPlanRewardPoint($plan["PLANID"], $rewardType);
        $requiredPoint = $rewardPoint["REQUIRED_POINT"];
        
        $redemptionQty = intdiv($points2Redeem, $requiredPoint);
        if ((($points2Redeem % $requiredPoint) == 0) && $redemptionQty > 0) {
            $redemptionQty = intdiv($points2Redeem, $requiredPoint);
            $expiry_date = $this->getExpirationDate($user);
            $extendby = $rewardPoint["EXTRA_DAYS"] * $redemptionQty;
            $extendDataBy = $rewardPoint["EXTRA_DATA"] * $redemptionQty;
            $is_expd = isExpired($expiry_date);
            $nu_expd = ($is_expd)? add_date(date("Y-m-d H:i:s"), $extendby ) : add_date($expiry_date, $extendby );
            $updated = $this->serviceExtReward($user, $nu_expd, $extendDataBy, $is_expd);
            
            if ($updated) {
                // Deduct Point
                $done = $this->deductRedemptionPoint($user, $plan["PLANNAME"], $points2Redeem, json_encode($rewardPoint));
                return ['STATUS'=>0, 'MSG'=>'Loyalty Redemption Successful with Data ' . json_encode($rewardPoint)];
            } else {
                return ['STATUS'=>0, 'MSG'=>'Loyalty Redemption failed'];
            }
        } else {
            return ['STATUS'=>0, 'MSG'=>'Redemption Point must be in multiples of ' . $requiredPoint];
        }
    }
   
  
    public function deductRedemptionPoint( $user, $userPlan, $points2Redeem, $reward) {
        $ins = "INSERT INTO loyalty_redemption (USERNAME, USER_SERVICE, POINTS_REDEEMED, REWARD, DATE_REDEEMED) VALUES "
                . " (?, ?, ?, ?, NOW())";
        $saved = $this->db->insert($ins, 'ssis', $user, $userPlan,
                $points2Redeem, $reward);
        if ($saved > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    public function getPointSettingsByPlan( $userService) {
        $sql = "SELECT ACTIVITY, ACTIVITY_POINT FROM loyalty_setup WHERE SERVICE_PLAN=?";
        $some_sth = $this->db->select($sql, "i", $userService);
        $sn = 0;
        while ($row = $some_sth->fetch_object()) {
            $ret[$row->ACTIVITY] = ['SN' => ++$sn, 'ACTIVITY' => $row->ACTIVITY, 'ACTIVITY_POINT' => $row->ACTIVITY_POINT];
        }

        return $ret;
    }

    public function getPlanRewardPoint( $plan, $rewardType = '') {
        $act = '';
        $ret = [];

        if ($rewardType !== '') {
            $act = " AND REWARD_TYPE=?";
        }
        $sql = "SELECT REWARD_TYPE, REQUIRED_POINT, EXTRA_DAYS, EXTRA_DATA"
                . " FROM loyalty_reward_setup WHERE SERVICE_PLAN=?"; 
        if ($act === ''):
            $some_sth = $this->db->select($sql, "i", $plan);
        else: 
            $sql .= $act; 
            $some_sth = $this->db->select($sql, "is", $plan, $rewardType);
        endif; 
        while ($row = $some_sth->fetch_object()) {
            $ret[$row->REWARD_TYPE] = ["REQUIRED_POINT"=>$row->REQUIRED_POINT, 
                "EXTRA_DAYS"=>$row->EXTRA_DAYS, "EXTRA_DATA"=>$row->EXTRA_DATA];
        }

        return $ret;
    }

    public function getPlanActivityPoint( $plan, $activity = '') {
        $act = '';
        $ret = [];

        if ($activity !== '') {
            $act = " AND ACTIVITY=?";
        }
        $sql = "SELECT ACTIVITY, ACTIVITY_POINT FROM loyalty_setup WHERE SERVICE_PLAN=?";
        if ($act === ''): 
            $some_sth = $this->db->select($sql, "i", $plan);
        else:
            $sql .= $act;
            $some_sth = $this->db->select($sql, "is", $plan, $activity);
        endif;
        while ($row = $some_sth->fetch_object()) {
            $ret[$row->ACTIVITY] = $row->ACTIVITY_POINT;
        }

        return $ret;
    }


    public function getRedeemedPoint( $username = '') {
        $whereClause = $ret = [];
        $ad = '';
        if ($username !== '') :
            $username = mysqli_real_escape_string($this->db, $username);
            $whereClause[] = "USERNAME = '$username'";
        endif;

        $sql = "SELECT USERNAME, SUM(POINTS_REDEEMED) AS 'POINTS' FROM loyalty_redemption";
        if (count($whereClause)):
            $ad = implode(" AND ", $whereClause);
            $sql .= " WHERE $ad";
        endif;
        $sql .= " GROUP BY USERNAME";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()) {
            $ret[$row->USERNAME] = $row->POINTS;
        }

        return $ret;
    }


    public function getAccumulatedPoints( $username = '', $limit=50) {
        $whereClause = $ret = [];
        $ad = '';
        if ($username !== '') :
            $username = mysqli_real_escape_string($this->db, $username);
            $whereClause[] = "USERNAME = '$username'";
        endif;

        $sql = "SELECT USERNAME, SUM(POINT_EARNED) AS 'POINTS' FROM loyalty_activity_logs";
        if (count($whereClause)):
            $ad = implode(" AND ", $whereClause);
            $sql .= " WHERE $ad";
        endif;
        $sql .= " GROUP BY USERNAME ORDER BY POINTS DESC LIMIT $limit"; 
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()) {
            $ret[$row->USERNAME] = $row->POINTS;
        }

        return $ret;
    }

    
    public function getExpirationDate($raduser) {
        $exp = "";
        $qry = "SELECT expiration FROM rm_users WHERE username = ?";
        $some_sth = $this->db->select($qry, "s", $raduser);
        while ( $row = $some_sth->fetch_object() ) {
            $exp = $row->expiration;
        }
        
        return $exp;
    }
    
   
    public function serviceExtReward($raduser, $expiration, $data_volume=0, 
            $is_expd=1) {
        $done = 0;
        
        $up = $down = $tot = $ntot = 0;
        $qry = "SELECT
                (SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ?) AS 'DOWN',
                (SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ?) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ?) AS 'COMB'";
        $some_sth = $this->db->select($qry, "sssss", $raduser, $raduser, $raduser, $raduser, $raduser);
        while ( $row = $some_sth->fetch_object() ) {
            $down = $row->DOWN;
            $up = $row->UP;
            $diff = ($row->COMB - ($down + $up));
            $combb = ( $diff<0 )? ($row->COMB+($diff * -1)) : ($row->COMB) ;
            $tot = ($is_expd)? ($down + $up) : ($combb);
        }
        
        $ntot = ($data_volume>0)? ($tot + $data_volume) : $tot;
        
        $renewData = bytes($data_volume, "GiB", '%01.2f %s');
        $expiry_date = date("d-M-Y H:i:s", strtotime($expiration));
        
        $upd = "UPDATE rm_users SET uplimit = '$up', downlimit = '$down', comblimit = '$ntot', expiration=?
                WHERE username = ?";
        $rett = $this->db->execute_query($upd, "ss", $expiration, $raduser);
        if ($rett) :
            $done = 1;
            $this->logTrail($this::RENEWAL_MANUAL, "($raduser attempt) Success: User $raduser completed Loyalty Reward Claim! Data Added: $renewData; New Expiry Date: $expiry_date", $this::STATUS_PASSED, get_client_ip_env()); 
        else:
            $this->logTrail($this::RENEWAL_MANUAL, "($raduser attempt) Error: User $raduser Loyalty Reward Claim Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
        endif;
        
        return $done;
    }

}

// End Class