<?php

/**
 * Description of BulkSMS
 *
 * @author OPMat
 */
class BulkSMS {
    //put your code here
    const API_BASE_URL = "https://novajii.com/novaji_webhooks/public/index.php/novaji/bulk-sms/";
//            "https://cloud.novajii.com/novaji_webhooks/public/index.php/novaji/bulk-sms/"; 
//"http://152.228.212.181/novaji_webhooks/public/index.php/novaji/bulk-sms/";
    const SINGLE_API_BASE_URL = "https://novajii.com/ords/sms/api/";
    const USERNAME = "infosystem@kkontech.com";
    const PASS = "Admin123@";
    
    private $db;
    
    public function __construct($dbconnection) {
        $this->db = $dbconnection;
    } 
    
    public function sendSingleSMS($msg, $recipient, $sender="FiberOne") {
        if (strlen($sender)<1) {
            $sender = "FiberOne";
        }
        if (is_array($recipient)) {
            return "Error: Kindly use the correct method to send bulk SMS";
        }
        if (strlen($recipient) < 11 || strlen($recipient) > 13) {
            return "Error: Incorrect Recipient";
        }
        $data['username'] = $this::USERNAME;
        $data['password'] = $this::PASS;
        $data['sender'] = $sender;
        $data['destination'] = $recipient;
        $data['message'] = $msg;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // Return data inplace of echoing on screen
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("X-Requested-With: XMLHttpRequest"));
        curl_setopt($ch, CURLOPT_URL, $this::SINGLE_API_BASE_URL . 'sms/');
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); 
        // curl_setopt($ch, CURLOPT_CAINFO, "/home/kkontech/pubv2/includes/novajii-com-chain.pem");
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1);
        $rsData = curl_exec($ch); 
        
        curl_close($ch);

        return $rsData;
    }
    
    public function sendSMS($msg, $recipients, $sender="FiberOne") {
        if (!is_array($recipients)) {
            $recipients = explode(",", $recipients);
        }
        if (count($recipients) <= 0) {
            return "Error: There must be atleast 1 recipient";
        }
        if (strlen($sender)<1) {
            $sender = "FiberOne";
        }
        
        $data = ["username"=> $this::USERNAME, "password"=>$this::PASS, 
            "sender"=>$sender, "phone"=>$recipients, "message"=>$msg]; 
        
        $data_string = json_encode($data);	
    	$headers  = [
            'Content-Type: application/json'
        ];
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $this::API_BASE_URL . 'send');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);           
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    	// curl_setopt($ch, CURLOPT_CAINFO, "/home/kkontech/pubv2/includes/novajii-com-chain.pem");
    	// curl_setopt($ch, CURLOPT_SSLCERT, "/home/kkontech/pubv2/includes/novajii_com.pem");
        $result     = curl_exec($ch);
        // $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); //echo "  KJ::". $statusCode; //echo "||  $data_string";
    															
        // $result = curl_exec($ch); //echo ("  UYT:".$result,"|");
    	if (curl_errno($ch)) {
        	return curl_error($ch);
        }
        curl_close($ch);
    	$res = json_decode($result, TRUE);
//        {
//    "message": "Sent"
//}
        return $res;
    }
    
    public function updateReport($param) {
        
    }
    
    public function saveSMSDetails($smsID, $smsReport) {
        $ct = 0;
        foreach ($smsReport as $k => $vSms) {
            foreach ($vSms as $no => $id) {
                $ins = "INSERT INTO tbl_sms_report (SMS_ID, RECIPIENT, MESSAGE_ID, 
                        DATESENT) VALUES (?, ?, ?, NOW())";
                $ins_id = $this->db->insert($ins, "iss", $smsID, $no, $id);
                if ($ins_id) { ++$ct; }
            }
        }
        
        return $ct;
    }
    
    public function saveSMS($notifID, $senderid, $content, $recipient, $nreceived, 
                                $sentBy, $report, $send_to_type=0, $msgType=1) {
        $ins = "INSERT INTO tbl_sms (`NOTIF_ID`, `SENDERID`, `CONTENT`,  `RECIPIENT`, 
                    `NRECEIVED`, `RECIPIENT_TYPE`, `SENT_BY`, `DATE_SENT`, REPORT, MTYPE)
               VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?)";
        $in_id = $this->db->insert($ins, "ssssiiisi", $notifID, $senderid, $content, $recipient, 
                        $nreceived, $send_to_type, $sentBy, json_encode($report), $msgType); 
        
        return $in_id;
    }
    
    public function getSMS($notifID = "") {
        $add = "";
        $ret = [];
        if ($notifID <> ""):
            $add = " WHERE `NOTIF_ID` = '" . mysqli_real_escape_string($notifID) . "'";
        endif;
        $strsql = "SELECT `NOTIF_ID`, `TITLE`, `CONTENT`, `RECIPIENT`, 
                    `NRECEIVED`, `RECIPIENT_TYPE`, `SENT_BY`, `DATE_SENT`, ta.USERNAME AS 'SENDER' 
                    FROM tbl_sms tp
                  LEFT JOIN tbl_admins ta ON tp.SENT_BY=ta.AID 
                $add 
                 ORDER BY `DATE_SENT` DESC";
        $some_st = $this->db->select($strsql);
        if ($some_st->num_rows() >= 1) :
            while ($row = $some_st->fetch_assoc()) :
                $ret[] = $row;
            endwhile;
        endif;
        
        return $ret;
    }
    
    
    public function getSMS4Report($searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0) {
        $exp = $response = array();
        $adc = $ad = $lim = "";
        $sn = 0; 
        
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (ID LIKE '%$searchval%' OR `TITLE` LIKE '%$searchval%' OR `RECIPIENT` LIKE '%$searchval%') ";
        endif;
        $eqry = "SET @count = 0;"; $this->db->execute_query($eqry);
        $mqry = "SELECT (@count:=@count+1) AS 'SN', `NOTIF_ID`, `CONTENT`, `RECIPIENT`, SENDERID,
                    `NRECEIVED`, `RECIPIENT_TYPE`, `SENT_BY`, `DATE_SENT`, ta.USERNAME AS 'SENDER', ta.FULLNAME, REPORT 
                    FROM tbl_sms tp
                  LEFT JOIN tbl_admins ta ON tp.SENT_BY=ta.AID ";
        $some_st = $this->db->select($mqry);
        $totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad";
        $some_s = $this->db->select($fqry);
        $totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY `DATE_SENT` DESC";
        
        $qry = "$mqry WHERE 1 $ad $msort $limit"; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) { 
            $exp[] = array("SN"=>++$sn, /*"NOTIF_ID"=>$row->NOTIF_ID,*/ "SENDERID"=>$row->SENDERID,
                        "CONTENT"=>$row->CONTENT, "RECIPIENT"=>($row->RECIPIENT_TYPE=='all')? "All":$row->RECIPIENT,
                        "NRECEIVED"=>$row->NRECEIVED, "SENDER"=>"{$row->FULLNAME} <{$row->SENDER}>",
                        "DATE_SENT"=>($row->DATE_SENT == NULL)? "-" : date( 'd-M-Y h:iA', strtotime($row->DATE_SENT)), 
                        "REPORT"=>$row->REPORT);
        }

        ## Response
        $response = array(
          "iTotalRecords" => $totalRecords,
          "iTotalDisplayRecords" => $totalRecordwithFilter,
          "aaData" => $exp
        );
        return $response;
    }
    
    
    public function cleanMobile($phoneNo) { 
        $cleanPhoneNo = [];
        $cleanThis = ["-", "+", " ", "(", ")"];
        if (gettype($phoneNo) === 'array') { 
            foreach ($phoneNo as $value) {
                $cleanPhoneNo[] = str_replace($cleanThis, "", $value);
            }
        } else { 
            $cleanPhoneNo[] = str_replace($cleanThis, "", $phoneNo);
        }
        
        return $cleanPhoneNo;
    }
    
}
