<?php

if (file_exists("config2.php")) {
    require_once "config2.php";
} elseif (file_exists("../config2.php")) {
    require_once "../config2.php";
} elseif (file_exists("../../config2.php")) {
    require_once "../../config2.php";
}

if (file_exists("includes/common_functions.php")) {
    require_once "includes/common_functions.php";
} elseif (file_exists("../includes/common_functions.php")) {
    require_once "../includes/common_functions.php";
} elseif (file_exists("../../includes/common_functions.php")) {
    require_once "../../includes/common_functions.php";
}

if (file_exists("includes/opener.php")) {
    require_once "includes/opener.php";
} elseif (file_exists("../includes/opener.php")) {
    require_once "../includes/opener.php";
} elseif (file_exists("../../includes/opener.php")) {
    require_once "../../includes/opener.php";
} elseif (file_exists("../../../includes/opener.php")) {
    require_once "../../../includes/opener.php";
} 


/**
 * Description of AdminDashboard
 *
 * @author opmat
 */
class AdminDashboard {
    //put your code here
    private $db;
    private $sid;
    public $totalRecords;
    public $totalRecordwithFilter;
    
    public function __construct($dbconnection) {
        $this->db = $dbconnection;
//        parent::setDB($dbconnection);
        $this->sid = session_id();
    } 
    
    public function getLocations() {
        $sql = "SELECT DISTINCT PLAN_LOCATION FROM tbl_plans ORDER BY PLAN_LOCATION";
        $some_sth = $this->db->select($sql);
        $plans = [];
        while ( $row = $some_sth->fetch_object() ) {
            $plans[] = $row->PLAN_LOCATION;
        }
        return $plans;
    }
    
    /**
     * 
     * Get the list of Complimentary, Pending and Paused Accounts for IN Query
     * 
     * @return string $userlist
     */
    public function getVariableList($addComplimentaryAcc=1, $addPendingAcc=1, $addPausedAcc=1) {
        $inarr = array(); 
        if ($addComplimentaryAcc):
            $qrylst = "SELECT USERNAME FROM tbl_comp_account";
            $some_st = $this->db->select($qrylst);
            while ($roww = $some_st->fetch_object()) {
                $inarr[] = $roww->USERNAME;
            }
        endif;
        if ($addPendingAcc):
            $qrylst = "SELECT RAD_USERNAME FROM tblclients WHERE USERTYPE=8";
            $some_s = $this->db->select($qrylst);
            while ($rowww = $some_s->fetch_object()) {
                $inarr[] = $rowww->RAD_USERNAME;
            }
        endif;
        if ($addPausedAcc):
            $qrylst = "SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1";
            $some_s = $this->db->select($qrylst);
            while ($rowww = $some_s->fetch_object()) {
                $inarr[] = $rowww->USERNAME;
            }
        endif;
        $userlist = "'" . implode("', '", array_unique($inarr)) . "'";
        
        return $userlist;
    }
    
    public function getTotalCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = "LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID WHERE PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT COUNT(username) AS 'nUsers'
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              $addon";
        $some_sth = $this->db->select($sql);
        $row = $some_sth->fetch_object();
        $rows = $row->nUsers;
        
        return $rows;
    }
    
    public function getOnlineCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT COUNT(rt.username) AS 'nUsers'
                FROM radacct rt
                    LEFT JOIN rm_users ru ON rt.username = ru.username
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                WHERE rt.acctstoptime IS NULL
              $addon";
        $some_sth = $this->db->select($sql);
        $row = $some_sth->fetch_object();
        $rows = $row->nUsers;
        
        return $rows;
    }
    
    public function getActiveCustomers($location='', $getComplimentaryAcc=0, $complimentaryType='', $groupByLocation=0) {
        $locations = $this->getLocations();
        $addon = $groupBy = $addPlanField = $compClause = $compTypeClause = $compTypeField = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " WHERE PLAN_LOCATION='$location'";
        endif;
        if ($groupByLocation):
            $addPlanField = "PLAN_LOCATION, ";
            $groupBy = " GROUP BY PLAN_LOCATION";
        endif;
        if ($getComplimentaryAcc):
            $compClause = " INNER JOIN tbl_comp_account tca ON ru.username=tca.USERNAME ";
            $compTypeField = ", ACCOUNT_TYPE";
            if($complimentaryType && in_array($complimentaryType, ['C', 'S'])):
                $compTypeClause = " AND ACCOUNT_TYPE = '". strtoupper($complimentaryType) ."'";
            endif;
        endif;
        $sql = "SELECT $addPlanField COUNT(username) AS 'nUsers'
            FROM (
            SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, PLAN_LOCATION $compTypeField
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              $compClause
		$addon					
                ) AS tmp
  	    WHERE 1 AND (acctype IN ( '0', '1', '2', '3', '4', '5' )) AND enableuser = 1
                AND
              (limitdl = 0 OR IF (limitdl =1, downlimit -
              (SELECT COALESCE(SUM(acctoutputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) -
              (SELECT COALESCE(SUM(dlbytes), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limitul = 0 OR IF (limitul =1, uplimit -
              (SELECT COALESCE(SUM(acctinputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) -
              (SELECT COALESCE(SUM(ulbytes ), 0)
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limitcomb = 0 OR IF (limitcomb =1, comblimit -
              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) +
              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limituptime = 0 OR IF (limituptime=1, uptimelimit -
              (SELECT COALESCE(SUM(acctsessiontime), 0)
              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)
              $compTypeClause
              $groupBy ";
        $some_sth = $this->db->select($sql);
        if ($groupByLocation):
            while ($row = $some_sth->fetch_object()):
                $stat[$row->PLAN_LOCATION] = $row->nUsers;
            endwhile;
            
            foreach ($locations as $loc) {
                $response[$loc] = isset($stat[$loc])? 
                                                $stat[$loc] : 0;
            }

            return $response;
        else:
            $row = $some_sth->fetch_object();
            $rows = $row->nUsers;

            return $rows;
        endif;
        
    }
    
    public function __createTempExpiryTable($tablename) {
        $sql = "CREATE TEMPORARY TABLE IF NOT EXISTS `$tablename` AS (
                SELECT SQL_CALC_FOUND_ROWS 
IF ((limitdl=1 OR limitul=1 OR limitcomb=1 OR limituptime=1), 'CAPPED', 'UNCAPPED') AS 'PLAN_TYPE',
IF ((limitdl=1 OR limitul=1 OR limitcomb=1 OR limituptime=1), ROUND(-1*((UNIX_TIMESTAMP(COALESCE(lastlogoff,expiration)) - UNIX_TIMESTAMP(NOW()))/(24*3600))), ROUND(-1*((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600))) ) AS 'DAYS_EXPIRED_ROUND',
IF ((limitdl=1 OR limitul=1 OR limitcomb=1 OR limituptime=1), -1*((UNIX_TIMESTAMP(COALESCE(lastlogoff,expiration)) - UNIX_TIMESTAMP(NOW()))/(24*3600)), -1*((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)) ) AS 'DAYS_EXPIRED',
username, expiration, LEFT(lastlogoff, 10) AS 'last_logoff', enableuser, PAUSED, firstname, lastname, address, city, zip, country, state, phone, mobile,
  	    email, company, taxid, srvid, downlimit, uplimit, comblimit, uptimelimit, credits, comment,
  	    staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl, limitul, limitcomb, limitexpiration,
  	    limituptime, createdon, verifycode, verified, selfreg, acctype, maccm, PLAN_LOCATION, lastlogoff
  	    
            FROM 
            (
              SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, PLAN_LOCATION,
	(SELECT IS_PAUSED FROM tbl_pause_account WHERE USERNAME= ru.username ORDER BY LAST_MODIFIED DESC LIMIT 1) AS'PAUSED'
              FROM rm_users ru
              JOIN rm_services USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              
              ORDER BY username ASC
            ) AS tmp
            WHERE 1
  
	     AND (tmp.acctype = '0'  OR tmp.acctype = '1'  OR tmp.acctype = '2'  OR tmp.acctype = '3'  OR tmp.acctype = '4'  OR tmp.acctype = '5'  OR tmp.acctype = '6' )

	    AND tmp.enableuser = 1 AND
         		      (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
            		      OR 
            		      IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR
                              IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0
                              OR 
                              IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) <= 0)
															
							ORDER BY DAYS_EXPIRED_ROUND ASC
                )";
        $some_sth = $this->db->execute_query($sql);
    	$qry = "SELECT username FROM `$tablename`";
    	$some_st = $this->db->select($qry);
    	$rows = $some_st->num_rows();
        if ($rows) {
            return 1;
        }
        return 0;
    }
    
    public function __destroyTempTable($tablename) {
        $sql = "DROP TEMPORARY TABLE IF EXISTS `$tablename`";
        $some_sth = $this->db->execute_query($sql);
        if ($some_sth) {
            return 1;
        }
        return 0;
    }
    
    public function getExpiredCustomersFromTable($tablename, $location='', $daysExpired='', $getComplimentaryAcc=0, 
                    $complimentaryType='', $groupByLocation=0) {
        $locations = $this->getLocations();
        $addon = $expiredClause = $groupBy = $addPlanField = $compClause = $compTypeClause = $compTypeField = "";
        $expiredDays = " AND DAYS_EXPIRED_ROUND >= 0";
        
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        if ($groupByLocation):
            $addPlanField = "PLAN_LOCATION, ";
            $groupBy = " GROUP BY PLAN_LOCATION";
        endif;
        
        if ($getComplimentaryAcc):
            $compClause = " INNER JOIN tbl_comp_account tca ON t.username=tca.USERNAME ";
            $compTypeField = ", ACCOUNT_TYPE";
            if($complimentaryType && in_array($complimentaryType, ['C', 'S'])):
                $compTypeClause = " AND ACCOUNT_TYPE = '". strtoupper($complimentaryType) ."'";
            endif;
        endif;
        if ($daysExpired == "0-30"):
            $expiredDays = " AND DAYS_EXPIRED_ROUND <= 30";
        elseif ($daysExpired == "31-60"):
            $expiredDays = " AND DAYS_EXPIRED_ROUND BETWEEN 31 AND 60";
        elseif ($daysExpired == "31-89"):
            $expiredDays = " AND DAYS_EXPIRED_ROUND BETWEEN 31 AND 89";
        elseif ($daysExpired == ">=90" || $daysExpired == "Churn" ):
            $expiredDays = " AND DAYS_EXPIRED_ROUND >= 90";
        endif;
        
        $sql = "SELECT $addPlanField COUNT(t.username) AS 'nUsers' FROM `$tablename` t
                $compClause
                WHERE 1 $addon $compTypeClause $expiredDays
                $groupBy ";
        $some_sth = $this->db->select($sql);
        if ($groupByLocation):
            while ($row = $some_sth->fetch_object()):
                $stat[$row->PLAN_LOCATION] = $row->nUsers;
            endwhile;
            
            foreach ($locations as $loc) {
                $response[$loc] = isset($stat[$loc])? 
                                                $stat[$loc] : 0;
            }

            return $response;
        else:
            $row = $some_sth->fetch_object();
            $rows = $row->nUsers;

            return $rows;
        endif;
        
    }
    
    public function getExpiredCustomers($location='', $daysExpired='', $getComplimentaryAcc=0, 
                    $complimentaryType='', $groupByLocation=0) {
        $locations = $this->getLocations();
        $addon = $expiredClause = $groupBy = $addPlanField = $compClause = $compTypeClause = $compTypeField = "";
        $expiredDays = " <= 0";
        
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " WHERE PLAN_LOCATION='$location'";
        elseif ($location == ''):
            
        endif;
        if ($groupByLocation):
            $addPlanField = "PLAN_LOCATION, ";
            $groupBy = " GROUP BY PLAN_LOCATION";
        endif;
        
        if ($getComplimentaryAcc):
            $compClause = " INNER JOIN tbl_comp_account tca ON ru.username=tca.USERNAME ";
            $compTypeField = ", ACCOUNT_TYPE";
            if($complimentaryType && in_array($complimentaryType, ['C', 'S'])):
                $compTypeClause = " AND ACCOUNT_TYPE = '". strtoupper($complimentaryType) ."'";
            endif;
        endif;
        if ($daysExpired == "0-30"):
            $expiredDays = "BETWEEN -30 AND 0";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        elseif ($daysExpired == "31-60"):
            $expiredDays = "BETWEEN -60 AND -31";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        elseif ($daysExpired == "31-89"):
            $expiredDays = "BETWEEN -89 AND -31";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        elseif ($daysExpired == ">=90" || $daysExpired == "Churn" ):
            $expiredDays = "<= -90";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        endif;
        $sql = "SELECT $addPlanField COUNT(username) AS 'nUsers'
            FROM (
            SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, PLAN_LOCATION $compTypeField
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              $compClause
		$addon					
                ) AS tmp
  	    WHERE 1 AND (acctype IN ( '0', '1', '2', '3', '4', '5', '6' )) AND enableuser = 1
                AND
              ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR 
                (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR
                (IF (limitcomb = 1, comblimit -
                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) +
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR 
                (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR 
                IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) $expiredDays )
                $compTypeClause
                $groupBy"; //echo $sql;
        $some_sth = $this->db->select($sql);
        if ($groupByLocation):
            while ($row = $some_sth->fetch_object()):
                $stat[$row->PLAN_LOCATION] = $row->nUsers;
            endwhile;
            
            foreach ($locations as $loc) {
                $response[$loc] = isset($stat[$loc])? 
                                                $stat[$loc] : 0;
            }

            return $response;
        else:
            $row = $some_sth->fetch_object();
            $rows = $row->nUsers;

            return $rows;
        endif;
        
    }
    
    public function getChurnedCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " WHERE PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT COUNT(username) AS 'nUsers'
            FROM (
            SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, PLAN_LOCATION
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
		$addon					
                ) AS tmp
  	    WHERE 1 AND (acctype IN ( '0', '1', '2', '3', '4', '5', '6' )) AND enableuser = 1
                AND
              ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
            		      FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
            		      FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 AND 
				((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) <= -90 ) )
            		      OR 
            		     ( IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 AND 
				((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) <= -90 ) )
                              OR
                           (   IF (limitcomb = 1, comblimit -
                              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                              FROM radacct WHERE radacct.username = tmp.username) +
                              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 AND 
                                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) <= -90 ) )
                              OR 
                            (  IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                              FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 AND 
                                ((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600) <= -90 ) )
                              OR 
                              IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) <= -90) 
                ";
        $some_sth = $this->db->select($sql);
        $row = $some_sth->fetch_object();
        $rows = $row->nUsers;
        
        return $rows;
    }
    
    public function getPausedCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT COUNT(username)  AS 'nUsers'
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                WHERE enableuser=0 
                AND username IN (SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1)
              $addon";
        $some_sth = $this->db->select($sql);
        $row = $some_sth->fetch_object();
        $rows = $row->nUsers;
        
        return $rows;
    }
    
    public function getPendingCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT COUNT(username) AS 'nUsers'
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              WHERE enableuser=0
                AND username IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8)
                AND lastlogoff IS NULL
              $addon";
        $some_sth = $this->db->select($sql);
        $row = $some_sth->fetch_object();
        $rows = $row->nUsers;
        
        return $rows;
    }
    
    public function getNewActivationsByLocation($startDate, $endDate) {
        $stat = $response = [];
        $sql = "SELECT PLAN_LOCATION, COUNT(tii.RAD_USERNAME) AS 'nUsers' 
                    FROM tbl_install_invoice tii
                    LEFT JOIN rm_users ru ON tii.RAD_USERNAME=ru.username
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                    WHERE 1 
                    AND DATE(tii.DATE_ACTIVATED) BETWEEN '$startDate' AND '$endDate'
                    GROUP BY PLAN_LOCATION
              ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[$row->PLAN_LOCATION] = $row->nUsers;
        endwhile;
        $locations = $this->getLocations();
        foreach ($locations as $location) {
            $response[$location] = isset($stat[$location])? 
                                            $stat[$location] : 0;
        }
        
        return $response;
    }
    
    public function getRenewalTransactions($startDate, $endDate) {
        $locations = $this->getLocations();
        $stat = $response = [];
        $sql = "SELECT PLAN_LOCATION, COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' 
                    FROM `tbl_tranx` tx
                    LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
                    WHERE STATUS_CODE = '00' 
                    AND DATE(tx.PAY_DATE) BETWEEN '$startDate' AND '$endDate'
                    GROUP BY PLAN_LOCATION
              ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[$row->PLAN_LOCATION] = ["location"=>$row->PLAN_LOCATION, 
                "nTrans"=>$row->NTRANS, "sales"=>$row->SALES];
        endwhile;
        foreach ($locations as $location) {
            $response[$location] = isset($stat[$location])? 
                                            $stat[$location] :
                                            ["location"=>$location, "nTrans"=>0,"sales"=>0];
        }
        
        return $response;
    }
    
    public function getExpiringByDate($expiryDate, $location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $stat = $response = [];
        $sql = "SELECT PLAN_LOCATION, COUNT(username) AS 'nUsers' 
                    FROM rm_users ru 
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                    WHERE 1 AND enableuser = 1
                    AND DATE(expiration) = '$expiryDate' $addon
                    GROUP BY PLAN_LOCATION  ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[$row->PLAN_LOCATION] = $row->nUsers;
        endwhile;
        if ($location == "") {
            foreach ($locations as $loc) {
                $response[$loc] = isset($stat[$loc])? $stat[$loc] : 0;
            }
        }
        
        return $response;
    }
    
    public function getExpiringInDays($daysToExpire, $location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $stat = $response = [];
        $sql = "SELECT PLAN_LOCATION, COUNT(username) AS 'nUsers' 
                    FROM rm_users ru 
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                    WHERE 1 AND enableuser = 1
                    AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $daysToExpire $addon
                    GROUP BY PLAN_LOCATION  ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[$row->PLAN_LOCATION] = $row->nUsers;
        endwhile;
        if ($location == "") {
            foreach ($locations as $loc) {
                $response[$loc] = isset($stat[$loc])? $stat[$loc] : 0;
            }
        }
        
        return $response;
    }
    
    public function salesByLocation($startDate, $endDate, $location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $stat = $response = [];
        
        $qry = "SELECT PLAN, PLAN_LOCATION, PLAN_DESC, SUM(NTRANS) AS 'TOTAL_TRANS', SUM(SALES) AS 'TOTAL_SALES', SUM(CASE
                    WHEN PLAN_LOCATION = 'Lagos' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_Lagos', SUM(CASE
                    WHEN PLAN_LOCATION = 'Lagos' THEN SALES ELSE 0 END
                  ) AS 'Sales_Lagos', SUM(CASE
                    WHEN PLAN_LOCATION = 'Abuja' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_Abuja', SUM(CASE
                    WHEN PLAN_LOCATION = 'Abuja' THEN SALES ELSE 0 END
                  ) AS 'Sales_Abuja', SUM(CASE
                    WHEN PLAN_LOCATION = 'Port Harcourt' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_PH', SUM(CASE
                    WHEN PLAN_LOCATION = 'Port Harcourt' THEN SALES ELSE 0 END
                  ) AS 'Sales_PH', SUM(CASE
                    WHEN PLAN_LOCATION = 'Ilorin' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_Ilorin', SUM(CASE
                    WHEN PLAN_LOCATION = 'Ilorin' THEN SALES ELSE 0 END
                  ) AS 'Sales_Ilorin'
                  FROM
		(SELECT tp.PLAN_LOCATION, tp.PLAN AS 'PLAN', tp.DESCRIPTION AS 'PLAN_DESC', 
                        COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES'
                FROM `tbl_tranx` tx
                LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
                LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
                WHERE STATUS_CODE = '00' AND DATE(PAY_DATE) BETWEEN ? AND ?
                $addon
                GROUP BY tp.PLAN_LOCATION, tp.PLAN) AS tmp
								
            GROUP BY PLAN
            ORDER BY PLAN_LOCATION, PLAN"; 
        $some_sth = $this->db->select($qry, "ss", $startDate, $endDate);
        while ($row = $some_sth->fetch_object()):
            $response[] = ["PLAN"=>$row->PLAN, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "PLAN_DESC"=>$row->PLAN_DESC,
                            "TOTAL_TRANS"=>$row->TOTAL_TRANS, "TOTAL_SALES"=>$row->TOTAL_SALES, 
                            "TotalTrans_Lagos"=>$row->TotalTrans_Lagos, "Sales_Lagos"=>$row->Sales_Lagos, 
                            "TotalTrans_Abuja"=>$row->TotalTrans_Abuja, "Sales_Abuja"=>$row->Sales_Abuja, 
                            "TotalTrans_PH"=>$row->TotalTrans_PH, "Sales_PH"=>$row->Sales_PH, 
                            "TotalTrans_Ilorin"=>$row->TotalTrans_Ilorin, "Sales_Ilorin"=>$row->Sales_Ilorin];
        endwhile;
        
        return $response;
    }
}
