<?php

header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
$user = $raduser = filter_var($_POST['uname'], FILTER_SANITIZE_STRING); 
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL); 
$phone = filter_var($_POST['phone'], FILTER_SANITIZE_STRING); 
$curAddy = filter_var($_POST['curAddy'], FILTER_SANITIZE_STRING); 
$newAddy = html_entity_decode(urldecode(filter_var($_POST['newAddy'], FILTER_SANITIZE_STRING)));

$amount_due = RELOC_PRICE;

// convert new address
$newAddressArr = json_decode($newAddy, TRUE);  

$ad = new AddressCoverage();

// Check Coverage
$isCovered = $ad->checkCoverage($newAddressArr['lat'], $newAddressArr['lng']);
 
if ($isCovered['success']==true && $isCovered["data"] == "FIBERONE BROADBAND is available in your area") :
    //there is coverage
    //save Relocation Request
    $db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
    $db->set_charset("utf8");
    $up = new UserProfile($db);
    $reloc_id = $up->createRelocationRequest($user, $phone, $email, $curAddy, $newAddressArr['address']);

    if (isset($reloc_id) && $reloc_id>0) :
        // create Transaction Id
        $codeg = new Password_Generator();
        $txn_id = "PAYS-RELOC$reloc_id-$raduser-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);

        $saveRet = $up->saveInitRelocTranx($txn_id, $raduser, $amount_due, CURRENCY, $reloc_id);
        while (!$saveRet):
            $txn_id = "PAYS-RELOC$reloc_id-$raduser-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);
            $saveRet = $up->saveInitRelocTranx($txn_id, $raduser, $amount_due, CURRENCY, $reloc_id);
        endwhile;
        if ($saveRet && $reloc_id){
            echo json_encode(["STATUS"=>1, "MSG"=>"Success: Initialization completed", 
                "TRANX_ID"=>$txn_id, "ADDRESS"=>$newAddressArr['address'], "AMOUNT"=>$amount_due,
                "AMOUNTF"=>number_format($amount_due, 2), "RELOC_ID"=>$reloc_id ]);
            exit();
        }
    endif;
endif;

echo json_encode(["status"=>0, "data"=>$isCovered["data"], "MSG"=>$isCovered["data"]]);