<?php
header('Content-type: application/json');

//error_reporting(E_ALL);

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
  die('This file cannot be accessed directly!');
}

## Read value


$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

$dashboard = new MarketplaceDashboard($db);
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$vendor_type_id = $_SESSION[$sid . 'usertype_id'];

$productId    = isset($_POST['productId']) ? (int) $_POST['productId'] : 0;
$product_status  = "pending";

// Validate input
if ($productId <= 0) {
  echo json_encode([
    "success" => false,
    "message" => "Invalid input data."
  ]);
  exit;
}


$response = $dashboard->submitArhiveProduct($productId, $vendor_id, $product_status);


if ($response) {
  echo json_encode([
    "success" => true,
    "message" => "Product submited for review successfully."
  ]);
} else {
  echo json_encode([
    "success" => false,
    "message" => "Failed to submit product."
  ]);
}

// if ($success) {
//   header('Location: product_detail.php?id=' . $productId . '&status=success');
//   exit;
// } else {
//   echo "Error updating product status. Please check your inputs.";
// }
