<?php
header('Content-type: application/json');
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST); 

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");


$ad = new UserProfile($db);
//$rad_exist = $ad->loadRadUser($raduser, 1, 0);
$log = new Logger($db, $adminUser);

$username = $user; 

$urec = $ad->getArchivedAccount($username); //foreach($urec as $key=>$val) { echo "$key ::: $val;  "; }
if (count($urec)<=0){
    $log->logTrail($log::NEW_USER, "($adminUser attempt) Error: Service ID [$username] restoration failed. Account not Found!", $log::STATUS_FAILED, get_client_ip_env()); 
    echo "Error: Service ID [$username] restoration failed. Account not Found!";
    exit();
}

//Get Message
$raw_msg = $ad->getCannedMessage("LOGIN_INFO");

$user_exist = $ad->verifyUserExist($username);

if ($user_exist == 1) :
    $log->logTrail($log::NEW_USER, "($adminUser attempt) Error: User [$username] already Exist", $log::STATUS_FAILED, get_client_ip_env()); 
    echo "Error: User [$username] already Exist"; exit();
elseif ($user_exist == 2) :
    $log->logTrail($log::NEW_USER, "($adminUser attempt) Error: User [$username] already Exist and Account is Disabled", $log::STATUS_FAILED, get_client_ip_env()); 
    echo "Error: User [$username] already Exist and Account is Disabled"; exit();
else :
    $log->logTrail($log::NEW_USER, "($adminUser attempt) Start to Restore Service ID [$username]. ", $log::STATUS_FAILED, get_client_ip_env()); 
            

// Create connection
$conn = new mysqli($db_hostname, $db_username, $db_password, $db_database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

/* Switch off auto commit to allow transactions*/
$conn->autocommit(FALSE);
$query_success = TRUE;
$err = "";

$useme = "eService_$adminUser";
$password = $user;


$ins = "INSERT INTO rm_changesrv
                    (username, newsrvid, newsrvname, scheduledate, requestdate, `status`, requested)
                    VALUES
                    (?, ?, ?, NOW(), NOW(), 1, ?)";
$stmt = $conn->prepare($ins);
if ( false===$stmt ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :1: ";
}
$rc = $stmt->bind_param('ssss', $urec->username, $urec->PLAN_ID, $urec->PLAN_NAME, $useme); //echo "ssss ' . {$urec->username} . {$urec->PLAN_ID} . {$urec->PLAN_NAME} . $useme";
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :2: ";
}
$rc = $stmt->execute();
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :3: ";
}


$ins = "INSERT INTO radcheck (UserName, Attribute, op, `Value`)
                        VALUES (?, 'Cleartext-Password', ':=', ?), "
                        . " (?, 'Simultaneous-Use', ':=', '1')";
$stmt = $conn->prepare($ins);
if ( false===$stmt ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :4: ";
}
$rc = $stmt->bind_param('sss', $urec->username, $password, $urec->username);
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :5: ";
}
$rc = $stmt->execute();
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :6: ";
}

$dd = date("Y-m-d");
$ins = "INSERT INTO rm_users (
   		      username, `password`, downlimit, uplimit, comblimit, firstname, lastname, company,
   		      phone, mobile, email, address, city, zip, country, state, `comment`, mac, expiration,
   		      enableuser, usemacauth, uptimelimit, srvid, staticipcm, staticipcpe, ipmodecm, ipmodecpe,
   		      createdon, acctype, createdby, taxid, maccm, credits, `owner`, groupid, custattr, poolidcm, poolidcpe,
   		      contractid, contractvalid, gpslong, gpslat, alertemail, alertsms, lang)
                      VALUES (
   		      ?, ?, 0, 0, 0, ?, ?, ?, ?, ?, ?, ?, ?, '', 'Nigeria', ?, '', '', ?, " .
   		      "'1', 0, '0', ?, '', ?, 0, 2, '$dd', '0', " .
   		      "?, '', '', '0.00', 'admin', '1', '', '0', '0', " .
   		      "'', '', '0', '0', 1, 1, 'English' )";
            
            $mpass = md5($password); 
$stmt = $conn->prepare($ins); //echo $inc;
if ( false===$stmt ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :7: ";// echo $err;
}
$rc = $stmt->bind_param('ssssssssssssiss', $urec->username, $mpass, $urec->firstname, 
                        $urec->lastname, $urec->company, $urec->phone, $urec->phone, $urec->email, $urec->address, 
                        $urec->city, $urec->state, $expiry_date,
                        $urec->SRVID, $urec->staticipcpe, $useme); //echo $rc;
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :8: "; //echo $err;
}
$rc = $stmt->execute();
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :9: "; //echo $err;
}


    $ins = "INSERT INTO tblclients (USERNAME, `PASSWORD`, RAD_USERNAME, IS_ENABLED, DATE_CREATED, ADDED_BY)
                VALUES (?, ?, ?, 1, NOW(), ?)"; //echo $ins;


$stmt = $conn->prepare($ins);
if ( false===$stmt ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :10: ";
}
$sha = sha1($password);

    $rc = $stmt->bind_param('sssi', $urec->username, $sha, $urec->username, $adminID);
    $acctype = "Main Account";


if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :11: ";
}
$rc = $stmt->execute();
if ( false===$rc ) {
    $query_success = FALSE;
    $err .= htmlspecialchars($mysqli->error). " :12: ";
}

/* Commit or rollback transaction */
if ($query_success) {
    $conn->commit();
} else {
    $conn->rollback();
}
$conn->autocommit(TRUE);

$stmt->close();
$conn->close();
//exit();

if ($query_success) {
    $log->logTrail($log::NEW_USER, "($adminUser attempt) Success: Restored Service ID [$username] on eService ($acctype) and Radius!", $log::STATUS_PASSED, get_client_ip_env()); 
    echo "Success: Restored Service ID [$username] on eService and Radius!";
} else {
    $log->logTrail($log::NEW_USER, "($adminUser attempt) Error: Failed to restore Service ID [$username] on eService ($acctype) and Radius! $err", $log::STATUS_FAILED, get_client_ip_env()); 
    echo "Error: Failed to restore Service ID [$username] on eService and Radius!";
}

    $user_dets = $ad->loadClientRec($username);
    if (count($user_dets)):
        $user_det = $user_dets[$username];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
        $admin_user = 0;
        $plan = $user_det["SERVICE"];
        
        $url = SERVER_URL . "";

        $msg = sprintf($raw_msg, $fullname, $username, $username, $plan, $url, $username, $pass);

        $sent = $ad->sendEmail($email, EMAIL_SENDER, "Welcome Back to FiberOne Online", $msg);
    endif;


endif;