<?php
//header('Content-Type: application/json');
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

// Extract POST data
$reference = $_POST['reference'] ?? '';
$tracking_id = $_POST['tracking_id'] ?? '';

if (!$reference || !$tracking_id) {
    echo json_encode(['success' => false, 'message' => 'Missing reference or tracking ID']);
    exit();
}

// Open DB connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");
$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
// Fetch transaction info for this reference
$result = $dashboard->populatePaystackReference($tracking_id, $reference);
if ($result) {
    echo json_encode(['success' => true, 'message' => "Payment reference updated successfully."]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update payment reference.']);
}

