<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST);

$user = $_POST['user'];
$token = $_POST['token'];

$tk = base64_decode(urldecode($token));
$user = base64_decode(substr(urldecode($user), 3));
$pass = base64_decode(urldecode($_POST['pass']));


//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$log = new Logger($db, $user);

$is_user = $ad->verifyUserExist($user);

if ($is_user == 0) :
    //does not exist, verify if Admin
    $is_admin = $ad->verifyAdminExist($user);
    if ($is_admin == 0) :
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Invalid Username <$user>, Please verify and try again later!", $log::STATUS_FAILED, get_client_ip_env());
        echo "Invalid Username, Please verify and try again later!";
        exit();
    else:
        if ($is_admin == 2) :
            $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user>, Account has been disabled! Contact Administrator", $log::STATUS_FAILED, get_client_ip_env());
            echo "Error: Account has been disabled! Contact Administrator";
            exit();
        endif;
    endif;
else:
    if ($is_user == 2) :
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user>, Account has been disabled! Contact Administrator", $log::STATUS_FAILED, get_client_ip_env());
        echo "Error: Account has been disabled! Contact Administrator";
        exit();
    endif;
endif;

//Get Message
$raw_msg = $ad->getCannedMessage("PASS_RESET_SUCCESS");
$admin_user = 0;

if ($is_user) :
    $user_det = $ad->loadClientRec($user)[$user];
    $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
    $email = $user_det["EMAIL"];
    $admin_user = 0;
elseif ($is_admin) :
    $user_det = $ad->loadAdminRec($user)[$user];
    $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
    $email = $user_det["EMAIL"];
    $admin_user = 1;
endif;

if ($ad->verifyPResetToken($user, $tk)) :
    //Valid Token
    $resp = $ad->resetPassword($user, $pass, $tk, $admin_user);
    if ($resp == 1):
        $url = SERVER_URL . "";

        $msg = sprintf($raw_msg, $fullname, $user, $url);

        $sent = $ad->sendEmail($email, EMAIL_SENDER, "Password Reset on FiberOne Online", $msg);
        if ($sent):
            $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET SUCCESS: Username <$user> Password reset and update sent to your mail on record [$email]", $log::STATUS_PASSED, get_client_ip_env());
            echo "Success: Password reset successful and update sent to your mail on record [$email]";
        else: 
            $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET SUCCESS: Username <$user> Password reset successfully", $log::STATUS_PASSED, get_client_ip_env());
            echo "Success: Password reset successful.";
        endif;
    else:
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user> Password reset failed.", $log::STATUS_FAILED, get_client_ip_env());
        echo "Error: Password Reset Failed!";
    endif;
        
else:
    //Invalid
    $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user> Password reset, Expired/Invalid Token!", $log::STATUS_FAILED, get_client_ip_env());
    echo "Error: Expired/Invalid Token!";
endif;

