<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    echo json_encode(['error' => 'This file cannot be accessed directly!']);
    exit;
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);
$ad = new UserProfile($db);

//$user_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$user_id = $_SESSION[$sid . 'userid'];

if (!isset($_POST['customer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Customer ID missing']);
    exit;
}

$customerId = intval($_POST['customer_id']);
$paymentData = $dashboard->getPaymentReminderDetails($user_id, $customerId);
if (!$paymentData) {
    echo json_encode(['success' => false, 'message' => 'No payment data found']);
    exit;
}

$raw_msg = $ad->getCannedMessage("PAYMENT_REMINDER");
if (!$raw_msg) {
    echo json_encode(['success' => false, 'message' => 'Email template not found']);
    exit;
}

$msg = sprintf(
    $raw_msg,
    $paymentData['name'],
    $paymentData['plan_name'],
    $paymentData['total_price'],
    $paymentData['checkout_link'],
    $paymentData['tracking_id'],
    SERVER_URL,
    SERVER_URL
);

$emailSent = $ad->sendEmail(
    $paymentData['email'],
    EMAIL_SENDER,
    "FiberOne - Reminder: Complete Your Payment",
    $msg
);

if ($emailSent) {
    echo json_encode(['success' => true, 'message' => 'Payment reminder sent successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to send email']);
}

//echo json_encode($result);
