<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('Requested file does not exist!'); }
   
extract($_POST);
$user = $_POST['user'];
$userrr = $_POST['username'];
if ($userrr !== 'fob0xYz'){
	echo "Error: Service temporarily unavailable";
	exit();
}

// echo "Error: Service temporarily unavailable";
// exit();

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$log = new Logger($db, $user);

$is_user = $ad->verifyUserExist($user);

if ($is_user == 0) :
    //does not exist, verify if Admin
    $is_admin = $ad->verifyAdminExist($user);
    if ($is_admin == 0) :
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Invalid Username <$user>, Please verify and try again later!", $log::STATUS_FAILED, get_client_ip_env()); // Invalid Username <$user>, Please verify and try again later!
        echo "I am lost!";
        exit();
    else:
        if ($is_admin == 2) :
            $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user>, Account has been disabled! Contact Administrator", $log::STATUS_FAILED, get_client_ip_env()); //Username <$user>, Account has been disabled
            echo "Error: Not sure I understand you! Contact Administrator";
            exit();
        endif;
    endif;
else:
    if ($is_user == 2) :
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user>, Account has been disabled! Contact Administrator", $log::STATUS_FAILED, get_client_ip_env()); //Username <$user>, Account has been disabled
        echo "Error: Not sure I understand you! Contact Administrator";
        exit();
    endif;
endif;

//Get Message
$raw_msg = $ad->getCannedMessage("PASS_RESET_REQUEST");

if ($is_user) : 
    $user_det = $ad->loadClientRec($user)[$user];
    $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
    $email = $user_det["EMAIL"];
elseif ($is_admin) : 
    $user_det = $ad->loadAdminRec($user)[$user];
    $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
    $email = $user_det["EMAIL"];
endif;

$tk = new Password_Generator();
$token = $tk->generate(45, 60, true, false, true, false);
$entoken = base64_encode($token);
$enuser = $tk->generate(3,3) . base64_encode($user);

//Store Token
$save = $ad->savePResetToken($user, $token);

if ($save == 1) :

    $url = SERVER_URL . RECOVERY_URL . "";

    $ddate = date("D, jS F, Y H:i:s T");

    $msg = sprintf($raw_msg, $fullname, $user, $url, $entoken, $enuser, $user, $ddate);
    
    $sent = $ad->sendEmail($email, EMAIL_SENDER, "Password Reset Request on FiberOne Online", $msg);
    if ($sent):
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET SUCCESS: Username <$user> Password reset link sent to your mail on record [$email]", $log::STATUS_PASSED, get_client_ip_env());
        echo "Success: Password reset link sent to your mail on record [$email]";
    else: 
        $log->logTrail($log::PASSWORD_CHANGE, "PASS RESET ERROR: Username <$user> Password reset, but Unable to send Password Reset Link at this time.", $log::STATUS_FAILED, get_client_ip_env());
        echo "Unable to send Password Reset Link at this time.";
    endif;
else:
    echo $save;
endif;
