<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {$a["error"]="Nothing to view here"; die(json_encode(a)); /*die('This file cannot be accessed directly!');*/ }
   
extract($_POST);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

$raduser = $user = strtolower($clientId);

//$userRec = $ad->loadClientRec($raduser);
//$ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
//                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
//                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
//                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
//                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);

$profile = $ad->loadUserProfile($raduser);
//ru.username, enableuser, firstname, lastname, email,
//                    company, mobile, expiration, ru.srvid, rs.srvname, address, city, state
$found = 0; 
$userRecord = [];
if ($profile <> ""){
    $found = 1;
    $userRecord = (array)$profile;
    $userRecord["expiry_formatted"] = date("d-M-Y H:i:s", strtotime($profile->expiration));
}
//foreach ($userRec as $u => $rec) {
//    if (strtolower($u) == strtolower($user)){
//        $found = 1;
//        $userRecord = $rec;
//        break;
//    }
//}
if (!$found) {
    echo json_encode(["STATUS"=>0, "MSG"=>"Invalid ID, kindly check and try again later"]);
    exit();
}
// check if active
$isactive = $ad->isActiveAccount($raduser);
if (!$isactive) {
    echo json_encode(["STATUS"=>0, "MSG"=>"Account is not currently active and cannot change plan at the moment. Please contact Support (csc@fob.ng) if you need assistance!"]);
    exit();
}

//check if qualified for PROMO 
$isQualified = $ad->isQualifiedForPromo($user, "WeMissU1");
if (!$isQualified) {
    echo json_encode(["STATUS"=>0, "MSG"=>"This account is not eligible for this promo. If you received an invitation, kindly contact Support (csc@fob.ng)!"]);
    exit();
}

//check if exhausted benefit from PROMO already
$hasExhaustedBenefit = $ad->hasExhaustedBenefitFromPromo($user, "WeMissU1", 1);
if ($hasExhaustedBenefit) {
    echo json_encode(["STATUS"=>0, "MSG"=>"This account is no longer eligible for this promo because it has exhausted its promo slot. If this is incorrect, kindly contact Support (csc@fob.ng)!"]);
    exit();
}

/*
 * $rec = array("PLAN_ID"=>$row->PLAN_ID, "PLAN"=>$row->PLAN, "SRVID"=>$row->SRVID, 
                    "DATA"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY, 
                    "CAN_SPILLOVER"=>$row->CAN_SPILLOVER, "PLAN_DESC"=>$row->DESCRIPTION, 
                    "IS_ENABLED"=>$row->IS_ENABLED, "DATE_ADDED"=>$row->DATE_ADDED, "ADDED_BY"=>$row->ADDED_BY,
                    "PACKAGE"=>$row->srvname, "PACKAGE_DESC"=>$row->descr, "PLANCODE"=>$row->PLANCODE,
                    "ODATA"=>formatBytes($row->DATA_VOLUME, 2, FALSE),"DATAV"=>$row->DATA_VOLUME);
 */
$services = $ad->loadPlans($profile->srvid);
$service = [];
foreach ($services as $serv) :
    $service = $serv;
endforeach;

echo json_encode(["STATUS"=>1, "MSG"=>"User exist and is qualified<br/><strong>USERNAME:</strong>$user<br/><strong>NAME:</strong>{$profile->firstname} {$profile->lastname}<br/><strong>PLAN:</strong>{$profile->srvname}", 
    "PROFILE"=>$userRecord, "PLAN"=>$service["PLAN"], "PLAN_ID"=>$service["PLAN_ID"],
    "AMOUNT"=>$service["AMOUNT"], "AMOUNTF"=>number_format($service["AMOUNT"],2) ]);