<?php
set_time_limit(0);
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

include_once __DIR__ . '/../includes/fast-excel-writer/autoload.php';

use \avadim\FastExcelWriter\Excel;

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
$storeFileDir = __DIR__ . '/../storage/';
$outFileDir = SERVER_URL . 'reporfils/';
$adminUsername = trim($_SESSION[$sid.'username']);
$adminUser = str_replace(".","-",trim($_SESSION[$sid.'username']));
$adminEmail = $_SESSION[$sid.'email'];

if (!isset($_SESSION[$sid.'email']) || (!isset($_SESSION[$sid.'username']))) {
    echo "Your session has expired and your request cannot be completed at the moment. Please login and try again";
    exit();
}
   
extract($_POST);

$draw = $_POST['draw'];
$row = $_POST['start'];
$rowperpage = $_POST['length']; // Rows display per page
$columnIndex = $_POST['order'][0]['column']; // Column index
$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
$searchValue = $_POST['search']['value']; // Search value

## Custom Field value
$startdate = $_POST['durFrom'];
$enddate = $_POST['durTo'];
$ticket_type = $_POST['tckType'] ===''? 'All' : $_POST['tckType'];
   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$adr = new AdminDashboardReport($db);
$ad = new UserProfile($db);

//log Report Request
$logId = $adr->logReportRequest($ticket_type, json_encode($_POST), $adminUsername, $adminEmail, date("Y-m-d H:i:s"));

session_write_close();
$reportType = (($ticket_type == 'All')? "All Plan Changes [Duration: $startdate - $enddate]" :
        (($ticket_type == 'Upgrade')? "All Plan Upgrades [Duration: $startdate - $enddate]" :
        (($ticket_type == 'Downgrade')? "All Plan Downgrades [Duration: $startdate - $enddate]" : "")));
$message ='Your request for a report on '.$reportType.' has been received and is currently been proceessed.';
$message .= " The report will be sent to your email ($adminEmail) once ready. Thank you";
echo $message;
$backgroundJob = function () use ($message) {
    echo $message;
};
 register_shutdown_function($backgroundJob);
 fastcgi_finish_request();
 
$rand = new Password_Generator();
$randStr = $rand->generate(9, 15, true, true);

// if ($action == 'allTickets') :
//     totalCust($ad, $location, $category);
// elseif ($action == 'deptTickets') :
//     (newCust($ad, $duration, $category));
// elseif ($action == 'openTickets') :
//     (renewals($ad, $duration, $category));
// elseif ($action == 'closedTickets') :
//     (expiring($ad, $category));
// endif;

$requestTime = date("d-m-Y H:i:s");
$timer = microtime(true);

$excel = Excel::create();
$sheets = 0;
$acolformat = [ 9=>'@datetime'
    ];

$tck = new Tickets($db, $ad);

$ticketList = $ad->getPlanSwitchReport($ticket_type, $startdate, $enddate, $searchValue, $columnName, $columnSortOrder);

if (count($ticketList)): 
    ++$sheets; 
endif;
$sheet1 = $excel->makeSheet($ticket_type.' as at '.date("Y-m-d")); 
makeExcelSheet($sheet1, $ticketList, $acolformat); 

//remove sheet1
        if ($sheets) { $excel->removeSheet('Sheet1'); }

        //save Excel File
        $filename = $ticket_type.$adminUser."_".date('dmYHi');
        $outFileName = $outFileDir.  $randStr . "/" . $filename;
        $storename = $storeFileDir . $filename . ".xlsx";
        $excel->save($storename);
        
        //timer
        $time = round(microtime(true) - $timer, 3);
        $completeTiime = date("d-m-Y H:i:s");

        //send file download link in email
        sendMail("REPORT_MAIL", $reportType, $outFileName, $requestTime, $completeTiime, $time);

/**
 * Create Excel sheet. $columnFormat defines the format for the columns in the sheet in a key-value pattern,
 * where the key is the column number starting from 1.
 * 
 * @param mixed $sheet
 * @param array $data
 * @param array $columnFormat   
 */
function makeExcelSheet(&$sheet, $data, $columnFormat=[]) {
    
    $headStyle = [
        'font' => [
            'style' => 'bold'
        ],
        'text-align' => 'center',
        'vertical-align' => 'center',
        'border' => 'thin',
        'height' => 24,
    ];
    $headings = array_keys($data[0]);
    $sheet->writeHeader($headings, $headStyle);
    //set format
    if (count($columnFormat)):
        foreach ($columnFormat as $key => $value) {
            $sheet->setColFormat($key, $value);
        }
    endif;
    
    $rowNum = 1;
    foreach($data as $rowData) {
        $rowOptions = [
            'height' => 20, 'border' => 'thin',
        ];
        if ($rowNum % 2) {
            $rowOptions['fill-color'] = '#eee';
        }
        $sheet->writeRow($rowData, $rowOptions);
    }
}

function sendMail($mailType, $subject, $file, $startTime, $endTime, $duration) {
    global $db, $adminEmail, $logId, $adr;
    if (filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
    	$up = new UserProfile($db); 
    	$raw_msg = $up->getCannedMessage($mailType); 
    	// $raw_msg_addon = $up->getCannedMessageAddon($mailType); print_r( $raw_msg_addon); return;
    	$msg = sprintf($raw_msg, $subject, $startTime, $endTime, $duration ."s", $file, $file); 
    	$sent = $up->sendEmailBrevo($adminEmail, 'fiberonepayment@gmail.com', "Report on $subject - ".date("Y-m-d H:i:s"), $msg, [], [], $raw_msg_addon);
    }
    $adr->setReportGenCompleted($logId, date("Y-m-d H:i:s"), $sent);
    
    return $sent;
}