<?PHP
include_once "../includes/opener.php";
include_once "../config.php";
include_once "../includes/db.inc";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST);
 
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database); //print_r($db);
$db->set_charset("utf8");

$ad = new UserProfile($db);

$pel = new PelPay($db);

$pel->auth();


$param = ["amount"=>$amount, "currency"=>"NGN", "merchantRef"=>$txn_ref, 
    "narration"=> "$cust_id-{$nmonths}m-$plan", 
    "callBackUrl"=>NOTIFICATION_PELP_URL, 
    "productCode"=>$plan,
    "shouldTokenize"=>false, 
    "customer"=>[
        "customerId"=>$cust_id,
        "customerLastName"=>$cust_name,
        "customerFirstName"=>"me",
        "customerEmail"=>$email,
        "customerPhoneNumber"=>$_SESSION[$sid.'phoneNo'],
        "customerCountryCode"=> "NG"
    ], 
    "integrationKey"=>$pel->getIntegrationKey(), 
    "notificationUrl"=>NOTIFICATION_PELP_URL
    ];

$logtable = 'tbl_pelpay_log';
$fields = "`STATE`, `LOG`";
$value = "'OUT1', '" . json_encode($param) . "'";
$ad->insertLog($fields, $value, $logtable);

$payAdvice = $pel->createPayAdvice($param);

$value = "'RET1', '" . json_encode($payAdvice) . "'";
$ad->insertLog($fields, $value, $logtable);

if ($payAdvice["requestSuccessful"]) {
    $retData = $payAdvice["responseData"];
    $sql = "UPDATE tbl_tranx SET RET_REF_NO=? WHERE TRANX_ID=?";
    $locked = $db->execute_query($sql, "ss", $retData["adviceReference"], $txn_ref);
    
    $payURL = $retData["paymentUrl"];
    echo $payURL;
} else {
    echo "Error: Payment Initialization Failed";
}
